; Compiled with: PIC Simulator IDE v7.27
; Microcontroller model: PIC16F628A
; Clock frequency: 4.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R2L EQU 0x024
	R2H EQU 0x025
	R3L EQU 0x026
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R1HL EQU 0x022
	R2HL EQU 0x024
	R4HL EQU 0x028
	R1HL0HL EQU 0x020
;       The value of 'ctrl_pause' (global) is 15
;       The value of 'speed_step' (global) is 2
;       The address of 'position' (bit) (global) is 0x027,0
;       The address of 'speed' (word) (global) is 0x02C
;       The address of 'runtime_up' (word) (global) is 0x02E
;       The address of 'runtime_down' (word) (global) is 0x030
;       The address of 'runtime' (word) (global) is 0x02A
;       The address of 'switchtime' (word) (global) is 0x032
;       The address of 'breaktime' (word) (global) is 0x034
;       The address of 'fwd' (bit) (global) is 0x006,4
;       The address of 'rev' (bit) (global) is 0x006,5
;       The address of 'red_led' (bit) (global) is 0x006,6
;       The address of 'green_led' (bit) (global) is 0x006,7
;       The address of 'fbup' (bit) (global) is 0x005,1
;       The address of 'fbdn' (bit) (global) is 0x005,2
;       The address of 'limit_up' (bit) (global) is 0x005,4
;       The address of 'limit_down' (bit) (global) is 0x005,3
;       The address of 'redsign' (bit) (global) is 0x005,6
;       The address of 'cmd_down' (bit) (global) is 0x005,5
;       The address of 'cmd_up' (bit) (global) is 0x005,0
;       The address of 'greensign' (bit) (global) is 0x005,7
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0003
	ORG 0x0004
	RETFIE
; User code start
L0003:
; 1: 'program bridge up/down
; 2: 'print MGV116
; 3: '24-8-14 version v1.08 bridge reversed, speed lower, speed-up/down slower.
; 4: '24-8-14 version v1.09 calculation runtime change decreased, bouncing disabled.
; 5: '24-8-14 version v1.11 calculation runtime corrected.
; 6: '24-8-14 version v1.14 procedure bridge changed.
; 7: '25-8-14 version v1.16 no eeprom used
; 8: '25-8-14 version v1.17 red led switched before going down en brigde delayed
; 9: '_                     Min_speed is lower on going down
; 10: '-                     extra delay between red sign on and start bridge down
; 11: 
; 12: Define CONF_WORD = 0x3f50
; 13: 'Define SIMULATION_WAITMS_VALUE = 1
; 14: AllDigital
	MOVLW 0x07
	MOVWF CMCON
; 15: CMCON = 7
	MOVLW 0x07
	MOVWF CMCON
; 16: TRISA = %00111001
	MOVLW 0x39
	BSF STATUS,RP0
	MOVWF TRISA
; 17: TRISB = %00000000
	CLRF TRISB
	BCF STATUS,RP0
; 18: PORTA = 255
	MOVLW 0xFF
	MOVWF PORTA
; 19: PORTB = 0
	CLRF PORTB
; 20: Symbol fwd = RB4
; 21: Symbol rev = RB5
; 22: Symbol red_led = RB6
; 23: Symbol green_led = RB7
; 24: Symbol fbup = RA1
; 25: Symbol fbdn = RA2
; 26: Symbol limit_up = RA4
; 27: Symbol limit_down = RA3
; 28: Symbol redsign = RA6
; 29: Symbol cmd_down = RA5
; 30: Symbol cmd_up = RA0
; 31: Symbol greensign = RA7
; 32: Dim position As Bit
; 33: Dim speed As Word
; 34: Dim runtime_up As Word
; 35: Dim runtime_down As Word
; 36: Dim runtime As Word
; 37: Dim switchtime As Word  'time when motor should slow down
; 38: Dim breaktime As Word  'time that is needed from min_ tot max_speed
; 39: Const ctrl_pause = 15
; 40: Const speed_step = 2
; 41: PWMon 1, 1
	MOVLW 0xFF
	BSF STATUS,RP0
	MOVWF PR2
	BCF TRISB,3
	BCF STATUS,RP0
	CLRF CCPR1L
	BCF CCP1CON,CCP1X
	BCF CCP1CON,CCP1Y
	BCF T2CON,T2CKPS0
	BSF T2CON,T2CKPS1
	BSF T2CON,TMR2ON
	MOVLW 0x0C
	IORWF CCP1CON,F
; 42: fbup = 1
	BSF PORTA,1
; 43: fbdn = 1
	BSF PORTA,2
; 44: position = 0
	BCF 0x027,0
; 45: If limit_up = 0 Then
	BTFSC 0x005,4
	GOTO L0004
; 46: If limit_down = 1 Then
	BTFSS 0x005,3
	GOTO L0005
; 47: position = 1
	BSF 0x027,0
; 48: Endif
L0005:
; 49: Endif
L0004:
; 50: runtime_up = 900
	MOVLW 0x84
	MOVWF 0x02E
	MOVLW 0x03
	MOVWF 0x02F
; 51: runtime_down = 900
	MOVLW 0x84
	MOVWF 0x030
	MOVLW 0x03
	MOVWF 0x031
; 52: breaktime = 400
	MOVLW 0x90
	MOVWF 0x034
	MOVLW 0x01
	MOVWF 0x035
; 53: WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
	CALL W001
; 54: redsign = 1
	BSF PORTA,6
; 55: greensign = 0
	BCF PORTA,7
; 56: green_led = position
	BCF PORTB,7
	BTFSC 0x027,0
	BSF PORTB,7
; 57: red_led = Not green_led
	BTFSS 0x006,7
	BSF 0x006,6
	BTFSC 0x006,7
	BCF 0x006,6
; 58: 
; 59: main:
L0001:
; 60: While cmd_down = cmd_up  'do nothing before 1st command
L0006:
	CLRW
	BTFSC 0x005,5
	ADDLW 0x01
	BTFSC 0x005,0
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0007
; 61: WaitMs 20
	MOVLW 0xCE
	MOVWF R4L
	MOVLW 0x07
	MOVWF R4H
	CALL DL02
; 62: Wend
	GOTO L0006
L0007:
; 63: If cmd_up = 1 Then  'bridge cmd up
	BTFSS 0x005,0
	GOTO L0008
; 64: If position = 0 Then  's bridge down?
	BTFSC 0x027,0
	GOTO L0009
; 65: If limit_up = 1 Then  'is it already up?
	BTFSS 0x005,4
	GOTO L0010
; 66: Call bridge()  'no
	CALL L0002
; 67: Endif
L0010:
; 68: Endif
L0009:
; 69: Endif
L0008:
; 70: While cmd_down = cmd_up  'do nothing before 1st command
L0011:
	CLRW
	BTFSC 0x005,5
	ADDLW 0x01
	BTFSC 0x005,0
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0012
; 71: WaitMs 20
	MOVLW 0xCE
	MOVWF R4L
	MOVLW 0x07
	MOVWF R4H
	CALL DL02
; 72: Wend
	GOTO L0011
L0012:
; 73: If cmd_down = 1 Then  'bridge cmd down
	BTFSS 0x005,5
	GOTO L0013
; 74: If position = 1 Then  's bridge up?
	BTFSS 0x027,0
	GOTO L0014
; 75: If limit_down = 1 Then  'is it already down?
	BTFSS 0x005,3
	GOTO L0015
; 76: Call bridge()  'no
	CALL L0002
; 77: Endif
L0015:
; 78: Endif
L0014:
; 79: Endif
L0013:
; 80: Goto main
	GOTO L0001
; 81: End
L0016:	GOTO L0016
; 82: 
; 83: Proc bridge()
L0002:
; 84: fbup = 1
	BSF PORTA,1
; 85: fbdn = 1
	BSF PORTA,2
; 86: runtime = 0
	CLRF 0x02A
	CLRF 0x02B
; 87: If position = 0 Then  'bridge going up
	BTFSC 0x027,0
	GOTO L0017
; 88: redsign = 1
	BSF PORTA,6
; 89: greensign = 0
	BCF PORTA,7
; 90: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 91: speed = 150
	MOVLW 0x96
	MOVWF 0x02C
	CLRF 0x02D
; 92: PWMduty 1, speed  'speed of motor set to minimum
	MOVF 0x02C,W
	MOVWF R0L
	MOVF 0x02D,W
	MOVWF R0H
	BTFSC R0L,0
	BSF CCP1CON,CCP1Y
	BTFSS R0L,0
	BCF CCP1CON,CCP1Y
	BTFSC R0L,1
	BSF CCP1CON,CCP1X
	BTFSS R0L,1
	BCF CCP1CON,CCP1X
	RRF R0H,F
	RRF R0L,F
	RRF R0H,F
	RRF R0L,W
	MOVWF CCPR1L
; 93: switchtime = runtime_up - breaktime
	MOVF 0x034,W
	SUBWF 0x02E,W
	MOVWF 0x032
	MOVF 0x035,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x02F,W
	MOVWF 0x033
; 94: rev = 0
	BCF PORTB,5
; 95: fwd = 1  'set direction
	BSF PORTB,4
; 96: While limit_up = 1  'wait for limit switch
L0018:
	BTFSS 0x005,4
	GOTO L0019
; 97: WaitMs ctrl_pause
	MOVLW 0xDA
	MOVWF R4L
	MOVLW 0x05
	MOVWF R4H
	CALL DL02
; 98: runtime = runtime + 1
	MOVF 0x02A,W
	ADDLW 0x01
	MOVWF 0x02A
	MOVF 0x02B,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x02B
; 99: If runtime < breaktime Then
	MOVF 0x02A,W
	MOVWF R0L
	MOVF 0x02B,W
	MOVWF R0H
	MOVF 0x034,W
	MOVWF R1L
	MOVF 0x035,W
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0020
; 100: If speed < 550 Then
	MOVF 0x02C,W
	MOVWF R0L
	MOVF 0x02D,W
	MOVWF R0H
	MOVLW 0x26
	MOVWF R1L
	MOVLW 0x02
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0021
; 101: speed = speed + speed_step  'increase motor speed
	MOVF 0x02C,W
	ADDLW 0x02
	MOVWF 0x02C
	MOVF 0x02D,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x02D
; 102: Endif
L0021:
; 103: Else
	GOTO L0022
L0020:
; 104: If runtime > switchtime Then
	MOVF 0x02A,W
	MOVWF R0L
	MOVF 0x02B,W
	MOVWF R0H
	MOVF 0x032,W
	MOVWF R1L
	MOVF 0x033,W
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0023
; 105: If speed > 150 Then
	MOVF 0x02C,W
	MOVWF R0L
	MOVF 0x02D,W
	MOVWF R0H
	MOVLW 0x96
	MOVWF R1L
	CLRF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0024
; 106: speed = speed - speed_step
	MOVLW 0x02
	SUBWF 0x02C,W
	MOVWF 0x02C
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x02D,W
	MOVWF 0x02D
; 107: Endif
L0024:
; 108: Endif
L0023:
; 109: Endif
L0022:
; 110: PWMduty 1, speed  'speed of motor
	MOVF 0x02C,W
	MOVWF R0L
	MOVF 0x02D,W
	MOVWF R0H
	BTFSC R0L,0
	BSF CCP1CON,CCP1Y
	BTFSS R0L,0
	BCF CCP1CON,CCP1Y
	BTFSC R0L,1
	BSF CCP1CON,CCP1X
	BTFSS R0L,1
	BCF CCP1CON,CCP1X
	RRF R0H,F
	RRF R0L,F
	RRF R0H,F
	RRF R0L,W
	MOVWF CCPR1L
; 111: Wend
	GOTO L0018
L0019:
; 112: fwd = 0
	BCF PORTB,4
; 113: rev = 0
	BCF PORTB,5
; 114: redsign = 0
	BCF PORTA,6
; 115: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 116: greensign = 1
	BSF PORTA,7
; 117: WaitMs 2000
	MOVLW 0xD0
	MOVWF R0L
	MOVLW 0x07
	MOVWF R0H
	CALL W001
; 118: Else  'bridge going down
	GOTO L0025
L0017:
; 119: redsign = 1
	BSF PORTA,6
; 120: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 121: greensign = 0
	BCF PORTA,7
; 122: WaitMs 2000
	MOVLW 0xD0
	MOVWF R0L
	MOVLW 0x07
	MOVWF R0H
	CALL W001
; 123: speed = 150
	MOVLW 0x96
	MOVWF 0x02C
	CLRF 0x02D
; 124: PWMduty 1, speed  'speed of motor set to minimum
	MOVF 0x02C,W
	MOVWF R0L
	MOVF 0x02D,W
	MOVWF R0H
	BTFSC R0L,0
	BSF CCP1CON,CCP1Y
	BTFSS R0L,0
	BCF CCP1CON,CCP1Y
	BTFSC R0L,1
	BSF CCP1CON,CCP1X
	BTFSS R0L,1
	BCF CCP1CON,CCP1X
	RRF R0H,F
	RRF R0L,F
	RRF R0H,F
	RRF R0L,W
	MOVWF CCPR1L
; 125: switchtime = runtime_down - breaktime
	MOVF 0x034,W
	SUBWF 0x030,W
	MOVWF 0x032
	MOVF 0x035,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x031,W
	MOVWF 0x033
; 126: rev = 1
	BSF PORTB,5
; 127: fwd = 0  'set direction
	BCF PORTB,4
; 128: While limit_down = 1  'wait for limit switch
L0026:
	BTFSS 0x005,3
	GOTO L0027
; 129: WaitMs ctrl_pause
	MOVLW 0xDA
	MOVWF R4L
	MOVLW 0x05
	MOVWF R4H
	CALL DL02
; 130: runtime = runtime + 1
	MOVF 0x02A,W
	ADDLW 0x01
	MOVWF 0x02A
	MOVF 0x02B,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x02B
; 131: If runtime < breaktime Then
	MOVF 0x02A,W
	MOVWF R0L
	MOVF 0x02B,W
	MOVWF R0H
	MOVF 0x034,W
	MOVWF R1L
	MOVF 0x035,W
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0028
; 132: If speed < 550 Then
	MOVF 0x02C,W
	MOVWF R0L
	MOVF 0x02D,W
	MOVWF R0H
	MOVLW 0x26
	MOVWF R1L
	MOVLW 0x02
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0029
; 133: speed = speed + speed_step  'increase motor speed
	MOVF 0x02C,W
	ADDLW 0x02
	MOVWF 0x02C
	MOVF 0x02D,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x02D
; 134: Endif
L0029:
; 135: Else
	GOTO L0030
L0028:
; 136: If runtime > switchtime Then
	MOVF 0x02A,W
	MOVWF R0L
	MOVF 0x02B,W
	MOVWF R0H
	MOVF 0x032,W
	MOVWF R1L
	MOVF 0x033,W
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0031
; 137: If speed > 100 Then
	MOVF 0x02C,W
	MOVWF R0L
	MOVF 0x02D,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0032
; 138: speed = speed - speed_step
	MOVLW 0x02
	SUBWF 0x02C,W
	MOVWF 0x02C
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x02D,W
	MOVWF 0x02D
; 139: Endif
L0032:
; 140: Endif
L0031:
; 141: Endif
L0030:
; 142: PWMduty 1, speed  'speed of motor
	MOVF 0x02C,W
	MOVWF R0L
	MOVF 0x02D,W
	MOVWF R0H
	BTFSC R0L,0
	BSF CCP1CON,CCP1Y
	BTFSS R0L,0
	BCF CCP1CON,CCP1Y
	BTFSC R0L,1
	BSF CCP1CON,CCP1X
	BTFSS R0L,1
	BCF CCP1CON,CCP1X
	RRF R0H,F
	RRF R0L,F
	RRF R0H,F
	RRF R0L,W
	MOVWF CCPR1L
; 143: Wend
	GOTO L0026
L0027:
; 144: rev = 0
	BCF PORTB,5
; 145: fwd = 0
	BCF PORTB,4
; 146: Endif
L0025:
; 147: 'now calculate the difference between old en new time and correct it
; 148: If position = 0 Then  'bridge went up
	BTFSC 0x027,0
	GOTO L0033
; 149: position = 1
	BSF 0x027,0
; 150: If runtime > runtime_up Then
	MOVF 0x02A,W
	MOVWF R0L
	MOVF 0x02B,W
	MOVWF R0H
	MOVF 0x02E,W
	MOVWF R1L
	MOVF 0x02F,W
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0034
; 151: runtime = runtime - runtime_up
	MOVF 0x02E,W
	SUBWF 0x02A,W
	MOVWF 0x02A
	MOVF 0x02F,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x02B,W
	MOVWF 0x02B
; 152: runtime = runtime / 5
	MOVF 0x02A,W
	MOVWF R0L
	MOVF 0x02B,W
	MOVWF R0H
	MOVLW 0x05
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x02A
	MOVF R0H,W
	MOVWF 0x02B
; 153: runtime_up = runtime_up + runtime
	MOVF 0x02E,W
	ADDWF 0x02A,W
	MOVWF 0x02E
	MOVF 0x02F,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x02B,W
	MOVWF 0x02F
; 154: Else
	GOTO L0035
L0034:
; 155: runtime = runtime_up - runtime
	MOVF 0x02A,W
	SUBWF 0x02E,W
	MOVWF 0x02A
	MOVF 0x02B,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x02F,W
	MOVWF 0x02B
; 156: runtime = runtime / 5
	MOVF 0x02A,W
	MOVWF R0L
	MOVF 0x02B,W
	MOVWF R0H
	MOVLW 0x05
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x02A
	MOVF R0H,W
	MOVWF 0x02B
; 157: runtime_up = runtime_up - runtime
	MOVF 0x02A,W
	SUBWF 0x02E,W
	MOVWF 0x02E
	MOVF 0x02B,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x02F,W
	MOVWF 0x02F
; 158: Endif
L0035:
; 159: Else  'bridge went down
	GOTO L0036
L0033:
; 160: position = 0
	BCF 0x027,0
; 161: If runtime > runtime_down Then
	MOVF 0x02A,W
	MOVWF R0L
	MOVF 0x02B,W
	MOVWF R0H
	MOVF 0x030,W
	MOVWF R1L
	MOVF 0x031,W
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0037
; 162: runtime = runtime - runtime_down
	MOVF 0x030,W
	SUBWF 0x02A,W
	MOVWF 0x02A
	MOVF 0x031,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x02B,W
	MOVWF 0x02B
; 163: runtime = runtime / 5
	MOVF 0x02A,W
	MOVWF R0L
	MOVF 0x02B,W
	MOVWF R0H
	MOVLW 0x05
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x02A
	MOVF R0H,W
	MOVWF 0x02B
; 164: runtime_down = runtime_down + runtime
	MOVF 0x030,W
	ADDWF 0x02A,W
	MOVWF 0x030
	MOVF 0x031,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x02B,W
	MOVWF 0x031
; 165: Else
	GOTO L0038
L0037:
; 166: runtime = runtime_down - runtime
	MOVF 0x02A,W
	SUBWF 0x030,W
	MOVWF 0x02A
	MOVF 0x02B,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x031,W
	MOVWF 0x02B
; 167: runtime = runtime / 5
	MOVF 0x02A,W
	MOVWF R0L
	MOVF 0x02B,W
	MOVWF R0H
	MOVLW 0x05
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x02A
	MOVF R0H,W
	MOVWF 0x02B
; 168: runtime_down = runtime_down - runtime
	MOVF 0x02A,W
	SUBWF 0x030,W
	MOVWF 0x030
	MOVF 0x02B,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x031,W
	MOVWF 0x031
; 169: Endif
L0038:
; 170: Endif
L0036:
; 171: '*************** end calculation
; 172: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 173: fbup = Not position
	BTFSS 0x027,0
	BSF 0x005,1
	BTFSC 0x027,0
	BCF 0x005,1
; 174: fbdn = position
	BCF PORTA,2
	BTFSC 0x027,0
	BSF PORTA,2
; 175: End Proc
	RETURN
; 176: 
; 177: 
; 178: 
; 179: 
; 180: 
; 181: 
; 182: 
; End of user code
L0039:	GOTO L0039
;
;
; Delay Routine Byte
; minimal routine execution time: 8s
; routine execution time step: 3s
; maximal routine execution time: 770s
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 15s
; routine execution time step: 10s
; maximal routine execution time: 655365s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0x61
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
	GOTO W001
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
;
;
; Configuration settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
