Define CONFIG = 0x33c4


'program GCA202
'program is for monophase stepper motors (5 connections )
'mainly issued for use with steppermotor 28BYJ-48

Define STEP_A_REG = PORTA
Define STEP_A_BIT = 1
Define STEP_B_REG = PORTA
Define STEP_B_BIT = 2
Define STEP_C_REG = PORTC
Define STEP_C_BIT = 0
Define STEP_D_REG = PORTC
Define STEP_D_BIT = 1
Define STEP_MODE = 1
TRISA = %111001
TRISC = %100100
PORTA = 0
PORTC = 0
AllDigital
ANSEL = %00000001
StepHold
Dim step_duration As Word  'this is interval between steps.
Dim command As Byte  'used for calculating forward or reverse.

main:
	Gosub get_speed
	command = 3
	command.0 = RA5
	command.1 = RA4
	Select Case command
	Case 0, 2
		StepCW 1, step_duration
		RC3 = 1
		RC4 = 0
	Case 1
		StepCCW 1, step_duration
		RC3 = 0
		RC4 = 1
	Case Else  'clear all outputs, motor off, no current through coils.
		RA1 = 0
		RA2 = 0
		RC0 = 0
		RC1 = 0
		RC3 = 0
		RC4 = 0
	EndSelect
	Goto main
End                                               
get_speed:
	Adcin 0, step_duration
	step_duration = step_duration * 62  '0..1023 > 0..63426
	step_duration = step_duration + 1500  'limited between 1500 and 64926
		
Return                                            
