Define CONF_WORD = 0x3f50



'program to control for 8 Turnouts with single coil or motor drive.
'By Peter Giling

'board MGV125
'due to low power supply, only one output will be activated at all times.
'positions are saved in EEprom to allow correct startup.
Define SIMULATION_WAITMS_VALUE = 0
Dim dip_switch As Byte
Dim turnout_delay As Word
Dim calc_delay As Single
Dim positions As Byte
AllDigital
TRISA = %11111111
TRISB = %11110011
Symbol dta = RB0
Symbol sck = RB1
Symbol green = RB2
Symbol red = RB3
I2CPrepare dta, sck
WaitMs 100
Call ctrl_motor(64, 0)  'set motors 1..4 off
Call ctrl_motor(66, 0)  'set motors 5..8 off
WaitMs 1000  'give time to get all units ready
Read 1, positions
green = 1  'green led on
red = 0  'red led off
main:
	Gosub get_turnout_delay
	If RA1 <> positions.0 Then  'turnout 1 to be checked
		If positions.0 = 1 Then
			Call ctrl_motor(64, %00000001)
			positions.0 = 0
		Else
			Call ctrl_motor(64, %00000010)
			positions.0 = 1
		Endif
		Write 1, positions  'store actial position
	Endif

	If RA0 <> positions.1 Then  'turnout  2 to be checked
		If positions.1 = 1 Then
			Call ctrl_motor(64, %00000100)
			positions.1 = 0
		Else
			Call ctrl_motor(64, %00001000)
			positions.1 = 1
		Endif
		Write 1, positions  'store actial position
	Endif
	
	If RA7 <> positions.2 Then  'turnout  3 to be checked
		If positions.2 = 1 Then
			Call ctrl_motor(64, %00010000)
			positions.2 = 0
		Else
			Call ctrl_motor(64, %00100000)
			positions.2 = 1
		Endif
		Write 1, positions  'store actial position
	Endif
	
	If RA6 <> positions.3 Then  'turnout  4 to be checked
		If positions.3 = 1 Then
			Call ctrl_motor(64, %01000000)
			positions.3 = 0
		Else
			Call ctrl_motor(64, %10000000)
			positions.3 = 1
		Endif
		Write 1, positions  'store actial position
	Endif

	If RB7 <> positions.4 Then  'turnout 5 to be checked
		If positions.4 = 1 Then
			Call ctrl_motor(66, %00000001)
			positions.4 = 0
		Else
			Call ctrl_motor(66, %00000010)
			positions.4 = 1
		Endif
		Write 1, positions  'store actial position
	Endif

	If RB6 <> positions.5 Then  'turnout 6 to be checked
		If positions.5 = 1 Then
			Call ctrl_motor(66, %00000100)
			positions.5 = 0
		Else
			Call ctrl_motor(66, %00001000)
			positions.5 = 1
		Endif
		Write 1, positions  'store actial position
	Endif

	If RB5 <> positions.6 Then  'turnout 7 to be checked
		If positions.6 = 1 Then
			Call ctrl_motor(66, %00010000)
			positions.6 = 0
		Else
			Call ctrl_motor(66, %00100000)
			positions.6 = 1
		Endif
		Write 1, positions  'store actial position
	Endif

	If RB4 <> positions.7 Then  'turnout 7 to be checked
		If positions.7 = 1 Then
			Call ctrl_motor(66, %01000000)
			positions.7 = 0
		Else
			Call ctrl_motor(66, %10000000)
			positions.7 = 1
		Endif
		Write 1, positions  'store actial position
	Endif

	WaitMs 100
Goto main
End                                               
Proc ctrl_motor(adress As Byte, value As Byte)
	green = 0  'green led off
	red = 1  'red led on
	I2CStart  'actovate motor(x)
	I2CSend adress
	I2CSend value
	I2CStop
	WaitMs turnout_delay
	I2CStart  'now motor(x) off again
	I2CSend adress
	I2CSend 0
	I2CStop
	green = 1  'green led on
	red = 0  'red led off
	
End Proc                                          

get_turnout_delay:
	dip_switch = PORTA
	dip_switch = dip_switch And %00011100
	dip_switch = dip_switch / 4
'MIN = 2^0 X 100 = 100 MSec,  max = 2^7  x 100 = 12,8 sec.
	calc_delay = Power(2, dip_switch)
	calc_delay = calc_delay * 100
	turnout_delay = calc_delay  'convert to integer
Return                                            