Define CONF_WORD = 0x3f50

'Commuter program for MGV140 unit definitve version with 3 pushbuttons
CMCON = 7
TRISA = %11100111
TRISB = %11100000
PORTB = 255
PORTA = 255

Symbol pluskey = RB6
Symbol minuskey = RB5
Symbol shiftkey = RB7
Symbol stopleft = RA0
Symbol stopmid = RA2
Symbol stopright = RA1
Symbol stopextra = RA5
Symbol leftled = RA3
Symbol rightled = RA4
Dim flasher As Byte
Dim route As Byte
Dim speed As Byte
Dim maxspeed_fw As Byte
'Dim maxspeed_rev As Byte
Dim run As Bit
Dim delay_right As Byte
Dim delay_mid As Byte
Dim delay_left As Byte
Dim delay As Byte
Dim acc_time As Byte
Const maxdelay = 50
'WaitMs 1000
Read 0, maxspeed_fw
If maxspeed_fw > 240 Then
	maxspeed_fw = 125
	Write 0, maxspeed_fw
Endif
If maxspeed_fw < 30 Then
	maxspeed_fw = 30
	Write 0, maxspeed_fw
Endif
Read 1, delay_right
If delay_right > maxdelay Then
	delay_right = maxdelay  '2 seconds to start with
	Write 1, delay_right
Endif
Read 2, delay_mid
If delay_mid > maxdelay Then
	delay_mid = maxdelay  '2 seconds to start with
	Write 2, delay_mid
Endif
Read 3, delay_left
If delay_left > maxdelay Then
	delay_left = maxdelay  '2 seconds to start with
	Write 3, delay_left
Endif
PWMon 1, 7
PWMduty 1, 0
route = 0
If stopright = 0 Then
	route = 4
Endif
If stopmid = 0 Then
	route = 2
Endif
Call calc_acc()
main:
	Select Case route
	Case 0  'loc = in left hand side position
		run = 0  'lok stopped
		rightled = 1
		leftled = flasher.2
		If delay > 0 Then  'lok waiting for timeout
			If speed = 0 Then
				delay = delay - 1
			Endif
		Else  'time is up
			route = 1  'next route step
			run = 1  'start lok
			Call motordirection(0)  'set correect direction
		Endif
	Case 1  'running 'right towards midsection
		run = 1  'lok running
		leftled = 1  'left led off
		rightled = 0  'right led on
		Call motordirection(0)  'set correct direction
		If stopmid = 0 Then  'arrival in station
			run = 0  'stop loc
			delay = delay_mid  'start timeout
			route = route + 1  'next route step
		Endif
		If stopright = 0 Then  'arrival on left end position
			run = 0  'stop engine
			delay = delay_right  'start timeout
			route = 4  'stepover to correct next route
		Endif
	Case 2  'loc = in mid position to go right
		run = 0  'stop engine
		leftled = 1  'lefd led off
		rightled = flasher.3  'blink right led
		If delay > 0 Then  'loc waiting for timeout
			If speed = 0 Then
				delay = delay - 1
			Endif
		Else  'time is up
			route = 3  'next route step
			run = 1  'start loc
			Call motordirection(0)  'select correct direction
		Endif
	Case 3  'running 'right towards end
		run = 1  'start loc
		leftled = 1  'left led off
		rightled = 0  'right led on
		Call motordirection(0)  'select correct direction
		If stopright = 0 Then  'arrival in right had stop section?
			run = 0  'stop engine
			delay = delay_right  'set timeout
			route = 4  'set next route step
		Endif
	Case 4  'loc = in right hand side position
		run = 0  'stop engine
		rightled = flasher.2  'right led off
		leftled = 1  'blink left led
		If delay > 0 Then  'waiting for timeout
			If speed = 0 Then
				delay = delay - 1
			Endif
		Else  'time is up
			route = 5  'set next route
			run = 1  'start engine
			Call motordirection(1)  'select correct direction
		Endif
	Case 5  'running 'left towards midsection
		run = 1  'start engine
		rightled = 1  'right led off
		leftled = 0  'left led on
		Call motordirection(1)  'set correct direction
		If stopextra = 0 Then  'arrival in station?
			run = 0  'stop loc
			delay = delay_mid  'set timeout
			route = route + 1  'set next route step
		Endif
		If stopleft = 0 Then  'arrival in left end station
			run = 0  'stop loc
			delay = delay_left  'set timeout
			route = 0  'loc is at left end position
		Endif
	Case 6  'loc = in mid position to go left
		run = 0  'stop engine
		rightled = 1  'right led off
		leftled = flasher.3  'blink left led
		If delay > 0 Then  'waiting for timeout
			If speed = 0 Then
				delay = delay - 1
			Endif
		Else  'time is up
			route = 7  'set next route step
			run = 1  'start loc
			Call motordirection(1)  'set correct direction
		Endif
	Case 7  'running left towards end
		run = 1  'start loc
		leftled = 0  'left led On
		rightled = 1  'right led off
		Call motordirection(1)  'select correct direction
		If stopleft = 0 Then  'arrival in left end station?
			run = 0  'stop lok
			delay = delay_left  'set timeout
			route = 0  'next route step
		Endif
	Case Else
	EndSelect
	If run = 0 Then  'controlling ramp up or ramp down speed
		If speed > 30 Then
			speed = speed - acc_time
		Else
			speed = 0
		Endif
	Else
		If speed < maxspeed_fw Then
			If speed < 30 Then
				speed = 30
			Else
				speed = speed + acc_time
			Endif
		Else
			speed = maxspeed_fw
		Endif
	Endif
	PWMduty 1, speed
	Gosub readkey
	flasher = flasher + 1
	WaitMs 125
Goto main

End                                               
Proc motordirection(direction As Bit)
	RB1 = direction
	RB0 = Not direction
End Proc                                          
readkey:
	While shiftkey = 0  'changing waittimes
		rightled = 1
		leftled = 1
		If pluskey = 0 Then
			Select Case route
			Case 4
				If delay_right < maxdelay Then  'maximum = 250 x 0.1 sec
					delay_right = delay_right + 10  '1 second more
					Call indicate_delay(delay_right, 2)
					Write 1, delay_right
				Endif
			Case 2, 6
				If delay_mid < maxdelay Then  'maximum = 250 x 0.1 sec
					delay_mid = delay_mid + 10  '1 second more
					Call indicate_delay(delay_mid, 1)
					Write 2, delay_mid
				Endif
			Case 0
				If delay_left < maxdelay Then  'maximum = 250 x 0.1 sec
					delay_left = delay_left + 10  '1 second more
					Call indicate_delay(delay_left, 1)
					Write 3, delay_left
				Endif
			Case Else
			EndSelect
			While pluskey = 0
				WaitMs 200
			Wend
		Endif
		If minuskey = 0 Then
			Select Case route
			Case 4
				If delay_right > 19 Then  'minimum = 10 x 0.1 sec
					delay_right = delay_right - 10  '1 second less
					Call indicate_delay(delay_right, 2)
				Endif
			Case 2, 6
				If delay_mid > 19 Then  'minimum = 10 x 0.1 sec
					delay_mid = delay_mid - 10  '1 second less
					Call indicate_delay(delay_mid, 1)
				Endif
			Case 0
				If delay_left > 19 Then  'minimum = 10 x 0.1 sec
					delay_left = delay_left - 10  '1 second less
					Call indicate_delay(delay_left, 1)
				Endif
			Case Else
			EndSelect
			While minuskey = 0
				WaitMs 200
			Wend
		Endif
		WaitMs 200
	Wend
	'just speed change
	If pluskey = 0 Then
		If maxspeed_fw < 254 Then
			maxspeed_fw = maxspeed_fw + 2
			Write 0, maxspeed_fw
		Endif
		Call calc_acc()
		While pluskey = 0
			WaitMs 200
		Wend
	Endif
	If minuskey = 0 Then
		If maxspeed_fw > 61 Then
			maxspeed_fw = maxspeed_fw - 2
			Write 0, maxspeed_fw
		Endif
		Call calc_acc()
		While minuskey = 0
			WaitMs 200
		Wend
	Endif
Return                                            

Proc calc_acc()
	acc_time = maxspeed_fw - 30
	acc_time = acc_time / 30  '3 secs acc / dec
	If acc_time < 1 Then
		acc_time = 1
	Endif
	If acc_time > 240 Then
		acc_time = 1
	Endif
End Proc                                          

Proc indicate_delay(time As Byte, which As Byte)
'led left , right or both will flash the amount of seconds as set.
	For flasher = 0 To time Step 10
		leftled = 1
		rightled = 1
		WaitMs 200
		Select Case which
		Case 0  'left hand flash
			leftled = 0
		Case 1  'middle position
			leftled = 0
			rightled = 0
		Case Else  'right hand position
			rightled = 0
		EndSelect
		WaitMs 200
	Next flasher
End Proc                                          

