#include <bitswap.h>
#include <chipsets.h>
#include <color.h>
#include <colorpalettes.h>
#include <colorutils.h>
#include <controller.h>
#include <cpp_compat.h>
#include <dmx.h>
#include <FastLED.h>
#include <fastled_config.h>
#include <fastled_delay.h>
#include <fastled_progmem.h>
#include <fastpin.h>
#include <fastspi.h>
#include <fastspi_bitbang.h>
#include <fastspi_dma.h>
#include <fastspi_nop.h>
#include <fastspi_ref.h>
#include <fastspi_types.h>
#include <hsv2rgb.h>
#include <led_sysdefs.h>
#include <lib8tion.h>
#include <noise.h>
#include <pixelset.h>
#include <pixeltypes.h>
#include <platforms.h>
#include <power_mgt.h>

/*
input format:
alle waarden < 255 en hoofdletters

K,n1,n2,#
K= kleur: R,G,B,W,A,C,K,E,F,G,H,I,O,Y,U
R=Red, G=Green, B=Blue, etc.

U=Black, uitschakelen

n1,n2 adressen

n1=n2 een enkel adres schakelen

n2>n1 alle adressen schakelen tussen n1 en n2

n1,n2,n3,n4 etc alle geadresseerde adressen schakelen

# eindmarkering van de opdracht

D = dimmen

D,10,# dimt de leds naar 10%

*/

#include <FastLED.h>
#define DATA_PIN 3
#define NUM_LEDS 100
CRGB leds[NUM_LEDS];
 
// byte index = 0;
boolean haveNewData = false;
byte kommateller = 0;
String kleur;
String inpString ="";

void setup()
{
 // Serial.begin(57600);
 Serial.begin(9600);
 FastLED.addLeds<WS2812B, DATA_PIN, GRB>(leds, NUM_LEDS);
 inpString.reserve(200);
 FastLED.setBrightness(100);
}
 
void loop()
{    
  if ( haveNewData ) 
    {  
      processNewData();
      inpString="";
      haveNewData=false;  
    }  
}
 
void serialEvent()
{ 
  while (Serial.available() > 0)
    {       
       char c = (char)Serial.read();      
      if ( c == ',')
            { 
              kommateller = kommateller + 1;
            }  
      inpString += c;                 
      if (c =='\n' | c == '#' | c == 0x00)     
      {
        haveNewData = true;
       }  
    }
}

void switchleds(String c, int getal) 
{                                   
  if (c == "R") {leds[getal] =  0xFF0000 ;} 
  if (c == "G") {leds[getal] =  0x00FF00 ;}
  if (c == "B") {leds[getal] =  0x0000FF ;}     
  if (c == "W") {leds[getal] =  0xF5F5DC ;}
  if (c == "A") {leds[getal] =  0xFAEBD7 ;}
  if (c == "C") {leds[getal] =  0x00FFFF ;}   
  if (c == "K") {leds[getal] =  0xFF8C00 ;}
  if (c == "E") {leds[getal] =  0xFF0000 ;}
  if (c == "F") {leds[getal] =  0xFF00FF ;}
  if (c == "G") {leds[getal] =  0xFFD700 ;}
  if (c == "H") {leds[getal] =  0xFF00FF ;}
  if (c == "I") {leds[getal] =  0xFFFFF0 ;}
  if (c == "O") {leds[getal] =  0xFF4500 ;}
  if (c == "Y") {leds[getal] =  0xFFFF00 ;}
  if (c == "U") {leds[getal] =  0x000000 ;}
  if (c == "D") {FastLED.setBrightness(getal);}

       
  FastLED.show();
}

void processNewData()
{
  Serial.print(inpString);   
  int i;
  String sub1 ;
  String sub2 ;
  String sub3 ; 
  String stringOne = inpString;
  int firstClosingBracket = stringOne.indexOf(',');
  kleur = stringOne.substring(0,firstClosingBracket); 
  int secondClosingBracket = stringOne.indexOf(',', firstClosingBracket + 1 );
  int thirdClosingBracket = stringOne.indexOf(',',secondClosingBracket +1);
  int lastClosingBracket = stringOne.lastIndexOf(',');  

if (kommateller = 2)
  {
    sub1=stringOne.substring(firstClosingBracket+1,stringOne.indexOf(',', firstClosingBracket + 1 )  );                                      
    char carray1[sub1.length() + 1];                                          
    sub1.toCharArray(carray1, sizeof(carray1));                                            
    int getal1 = atoi(carray1);  
    switchleds(kleur,getal1);
  }
  if (kommateller = 3)
    {
    sub1=stringOne.substring(firstClosingBracket+1,stringOne.indexOf(',', firstClosingBracket + 1 )  );                                      
    char carray1[sub1.length() + 1];                                          
    sub1.toCharArray(carray1, sizeof(carray1));                                            
    int getal1 = atoi(carray1);                                               
    sub2=stringOne.substring(secondClosingBracket+1,stringOne.indexOf(',', secondClosingBracket + 1 )  );
    char carray2[sub2.length() + 1];                                    
    sub2.toCharArray(carray2, sizeof(carray2));                              
    int getal2 = atoi(carray2);                                          

    for (int n = getal1; n <= getal2; n ++) 
      {
        switchleds(kleur,n);
      }
    }
  
  if (kommateller >= 4 )
    {
      for (int n = 1; n < kommateller; n++)
      {
        sub3=stringOne.substring(firstClosingBracket+1,secondClosingBracket);
        char carray3[sub3.length() + 1];                                          
        sub3.toCharArray(carray3, sizeof(carray3));                                            
        int getal1 = atoi(carray3);                                                    
        switchleds(kleur,getal1);
        firstClosingBracket=secondClosingBracket;
        secondClosingBracket=stringOne.indexOf(',', firstClosingBracket+1 );
      }     
    } 
   haveNewData = false;
   kommateller = 0;
}
