
/**
 **********************************************************************************************************************
 * @file		Enc28J60Cfg.h
 * @ingroup	    Network stack 
 * @brief		ENC28J60 network chip driver configuration file  
 **********************************************************************************************************************
 */
#ifndef ENC_28J60_CFG_H
#define ENC_28J60_CFG_H

#ifdef __cplusplus
// *INDENT-OFF*
extern "C" {
// *INDENT-ON*
#endif

/***********************************************************************************************************************
 * I N C L U D E S
 **********************************************************************************************************************/

/***********************************************************************************************************************
 * E X P O R T E D   S Y M B O L   D E F I N I T I O N S (defines, typedefs)
 **********************************************************************************************************************/

/* *INDENT-OFF* */

#define SPI_DDR         DDRB
#define SPI_PORT        PORTB
#define SPI_SCK         5
#define SPI_MISO        4
#define SPI_MOSI        3
#define SPI_SS          4

#define ENC_DDR         DDRB
#define ENC_PORT        PORTB
#define ENC_PIN         PINB
#define ENC_CS          2
#define ENC_INT         2

#define enc_select()    ENC_PORT &= ~(1<<ENC_CS)
#define enc_deselect()  ENC_PORT |= (1<<ENC_CS)

#define ETH_INTERRUPT   //INT2_vect
#define ETH_INT_ACTIVE  //(!(ENC_PIN & (1<<ENC_INT)))

#define ETH_INT_ENABLE  //GICR |= (1<<INT2)
#define ETH_INT_DISABLE //GICR &= ~(1<<INT2)
	
//#define FULL_DUPLEX
	
/* *INDENT-ON* */	

/***********************************************************************************************************************
 * E X P O R T E D   D A T A
 **********************************************************************************************************************/

/***********************************************************************************************************************
 * I N L I N E   F U N C T I O N S
 **********************************************************************************************************************/

/***********************************************************************************************************************
 * E X P O R T E D   F U N C T I O N   P R O T O T Y P E S
 **********************************************************************************************************************/

#ifdef __cplusplus
// *INDENT-OFF*
}
// *INDENT-ON*
#endif

#endif   // ENC_28J60_CFG_H
