
/**
 ******************************************************************************************
 * @file       main.c
 * @ingroup    main
 * @author		Robert Evers                                                      
 * @attention	Main of Axle counter application.
 ******************************************************************************************
 */

/*
 ******************************************************************************************
 * Standard include files
 ******************************************************************************************
 */
#include <stdio.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include "Version.h"
#include "Serial_Mega.h"
#include "MgvAxleCounter.h"

/*
 *******************************************************************************************
 * Macro definitions
 *******************************************************************************************
 */

/*
 *******************************************************************************************
 * Types
 *******************************************************************************************
  */

/*
 *******************************************************************************************
 * Variables
 *******************************************************************************************
 */

/*
 *******************************************************************************************
 * Prototypes
 *******************************************************************************************
 */

/*
 *******************************************************************************************
 * Routines implementation
 *******************************************************************************************
 */

/**
 *******************************************************************************************
 * @fn	    void main(void)		
 * @brief   Main routine of Axle counter application.
 * @return	None
 * @attention	
 *******************************************************************************************
 */

int main(void)
{
#  ifdef MGV_AXLE_COUNTER_DEBUG
   Serial_Init_19200_Baud();
   Serial_Enable_Transmit_Interrupts();
#  endif

   MgvAxleCounterInit();

   sei();

   while (1)
   {
      MgvAxleCounterMain();
   }
}
