; Compiled with: PIC Simulator IDE v7.46 b3
; Microcontroller model: PIC12F675
; Clock frequency: 4.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R1HL EQU 0x022
	R4HL EQU 0x028
	R1HL0HL EQU 0x020
	LONG_0 EQU 0x02A
	LONG_1 EQU 0x02B
	LONG_2 EQU 0x02C
	LONG_3 EQU 0x02D
	LONG2_0 EQU 0x02E
	LONG2_1 EQU 0x02F
	LONG2_2 EQU 0x030
	LONG2_3 EQU 0x031
	LONG1 EQU 0x02A
	LONG2 EQU 0x02E
;       The address of 'short_count' (word) (global) is 0x033
;       The address of 'short_time' (word) (global) is 0x026
;       The address of 'no_pulse_count' (byte) (global) is 0x025
;       The address of 'ok_state' (byte) (global) is 0x024
;       The address of 'old_p1' (bit) (global) is 0x035,0
;       The address of 'led_counter' (byte) (global) is 0x032
;       The address of 'ibt_2' (bit) (global) is 0x005,5
;       The address of 'booster_on' (bit) (global) is 0x005,4
;       The address of 'l2' (bit) (global) is 0x005,0
;       The address of 'pulses' (bit) (global) is 0x005,3
;       The address of 'short_out' (bit) (global) is 0x005,2
;       The address of 'short_in' (bit) (global) is 0x005,1
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0002
	ORG 0x0004
	RETFIE
; User code start
L0002:
; 1: 'program for ORD-3 Spax booster / DDX Booster
; 2: 'this edition accept dc based pulses
; 3: Define CONF_WORD = 0x31c4
; 4: 
; 5: AllDigital
	BSF STATUS,RP0
	CLRF ANSEL
	MOVLW 0x07
	BCF STATUS,RP0
	MOVWF CMCON
; 6: TRISIO = %001010
	MOVLW 0x0A
	BSF STATUS,RP0
	MOVWF TRISIO
	BCF STATUS,RP0
; 7: Symbol ibt_2 = GP5
; 8: Symbol booster_on = GP4  'remains always ON
; 9: Symbol l2 = GP0
; 10: Symbol pulses = GP3
; 11: Symbol short_out = GP2
; 12: Symbol short_in = GP1
; 13: Dim short_count As Word
; 14: Dim short_time As Word
; 15: Dim no_pulse_count As Byte
; 16: Dim ok_state As Byte
; 17: Dim old_p1 As Bit
; 18: Dim led_counter As Byte
; 19: ibt_2 = 0  'system off
	BCF GPIO,5
; 20: short_count = 0
	CLRF 0x033
	CLRF 0x034
; 21: short_time = 0
	CLRF 0x026
	CLRF 0x027
; 22: no_pulse_count = 0
	CLRF 0x025
; 23: booster_on = 1
	BSF GPIO,4
; 24: ok_state = 0
	CLRF 0x024
; 25: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 26: 
; 27: main:
L0001:
; 28: WaitUs 850  'Total loop time of program when no pulses are coming in
	MOVLW 0x53
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
; 29: '*                 = 150 us. We need timing of 1 mSec
; 30: led_counter = led_counter + 1
	MOVF 0x032,W
	ADDLW 0x01
	MOVWF 0x032
; 31: If short_in = 1 Then
	BTFSS 0x005,1
	GOTO L0003
; 32: If short_count < 250 Then
	MOVF 0x033,W
	MOVWF R0L
	MOVF 0x034,W
	MOVWF R0H
	MOVLW 0xFA
	MOVWF R1L
	CLRF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0004
; 33: short_count = short_count + 1
	MOVF 0x033,W
	ADDLW 0x01
	MOVWF 0x033
	MOVF 0x034,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x034
; 34: Else
	GOTO L0005
L0004:
; 35: short_time = 5000
	MOVLW 0x88
	MOVWF 0x026
	MOVLW 0x13
	MOVWF 0x027
; 36: ok_state.1 = 1
	BSF 0x024,1
; 37: Endif
L0005:
; 38: Endif
L0003:
; 39: If pulses <> old_p1 Then
	CLRW
	BTFSC 0x005,3
	ADDLW 0x01
	BTFSC 0x035,0
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0006
; 40: old_p1 = pulses
	BCF 0x035,0
	BTFSC GPIO,3
	BSF 0x035,0
; 41: ok_state.0 = 0
	BCF 0x024,0
; 42: no_pulse_count = 0
	CLRF 0x025
; 43: Else
	GOTO L0007
L0006:
; 44: no_pulse_count = no_pulse_count + 1
	MOVF 0x025,W
	ADDLW 0x01
	MOVWF 0x025
; 45: If no_pulse_count > 249 Then
	MOVF 0x025,W
	SUBLW 0xF9
	BTFSC STATUS,C
	GOTO L0008
; 46: ok_state.0 = 1
	BSF 0x024,0
; 47: no_pulse_count = 0
	CLRF 0x025
; 48: Endif
L0008:
; 49: Endif
L0007:
; 50: Select Case ok_state
; 51: Case 0  'no problem found
	MOVF 0x024,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0009
; 52: ibt_2 = 1  'power on booster
	BSF GPIO,5
; 53: l2 = 1  'red led On
	BSF GPIO,0
; 54: short_out = 0
	BCF GPIO,2
; 55: Case 1  'no pulses found
	GOTO L0010
L0009:
	MOVF 0x024,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0011
; 56: ibt_2 = 0  'power off booster
	BCF GPIO,5
; 57: l2 = led_counter.7  'led flashes
	BTFSS 0x032,7
	BCF GPIO,0
	BTFSC 0x032,7
	BSF GPIO,0
; 58: short_out = 0
	BCF GPIO,2
; 59: Case Else  'there is a short circuit
	GOTO L0012
L0011:
; 60: If short_time > 0 Then
	MOVF 0x026,W
	MOVWF R0L
	MOVF 0x027,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0013
; 61: short_time = short_time - 1
	MOVLW 0x01
	SUBWF 0x026,W
	MOVWF 0x026
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x027,W
	MOVWF 0x027
; 62: ibt_2 = 0  'power off booster
	BCF GPIO,5
; 63: l2 = led_counter.6  'red led Off
	BTFSS 0x032,6
	BCF GPIO,0
	BTFSC 0x032,6
	BSF GPIO,0
; 64: short_out = 1  'indicate to IC4
	BSF GPIO,2
; 65: Else
	GOTO L0014
L0013:
; 66: ok_state.1 = 0
	BCF 0x024,1
; 67: short_time = 5000
	MOVLW 0x88
	MOVWF 0x026
	MOVLW 0x13
	MOVWF 0x027
; 68: ibt_2 = 1  'power on booster
	BSF GPIO,5
; 69: l2 = 1  'red led Off
	BSF GPIO,0
; 70: short_out = 0  'indicate to IC4
	BCF GPIO,2
; 71: Endif
L0014:
; 72: EndSelect
L0012:
L0010:
; 73: Goto main
	GOTO L0001
; 74: End
L0015:	GOTO L0015
; 75: 
; 76: 
; End of user code
L0016:	GOTO L0016
;
;
; Delay Routine Byte
; minimal routine execution time: 8s
; routine execution time step: 3s
; maximal routine execution time: 770s
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 15s
; routine execution time step: 10s
; maximal routine execution time: 655365s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0x61
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
	GOTO W001
;
;
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
;
;
; Configuration settings
	ORG 0x2007
	DW 0x31C4
; End of listing
	END
