/*
 Rocrail - Model Railroad Software
 Copyright (c) 2002-2018 Robert Jan Versluis, Rocrail.net
 All rights reserved.
*/
#ifndef _RCANDFS_H_
#define _RCANDFS_H_

#include <Arduino.h>

#define RCAN_VERMAJ 3
#define RCAN_VERMIN 0

#define null 0
#define uint unsigned int

#define DEFAULT_CANID 127


typedef struct CANFrame {
  unsigned long id;
  unsigned char ext;
  unsigned char dlc;
  unsigned char data[8];
} * iCANFrame;

typedef struct CmdData {
  byte cmd; // internal code
  bool thisid;
  unsigned int id; // Node number, UID
  unsigned int addr;
  byte value;
} * iCmdData;


// General EEPROM variables
#define EE_SYNCID 0   // 1 byte SYNCID
#define EE_CONFIG 1   // 1 byte configuration
#define EE_CANID  2   // 1 byte CANID
#define EE_BOARD  31  // 1 byte board config

// node config
#define CFG_SAVEOUTPUT 0x01
#define CFG_SHORTEVENTS 0x02
#define CFG_PULSETIME_MASK 0x0C
#define CFG_PULSETIME_250 0x00
#define CFG_PULSETIME_500 0x04
#define CFG_PULSETIME_1000 0x08
#define CFG_PULSETIME_2000 0x0C
#define CFG_SOD_REPORTALL 0x10
#define CFG_PULSETIME_LONG 0x20         // for 1500 3000 6000 12000ms Pulse Time

#define MTYP_CANGC2a   12 // 16 I/O

// Boards
#define BOARD_MASK    0x07
#define BOARD_GPIO    0x00

#define PINLAYOUT_MASK 0x08
#define PINLAYOUT_0    0x00
#define PINLAYOUT_1    0x08

// Protocols
#define PROTOCOL_MASK  0x30
#define PROTOCOL_CBUS  0x00
#define PROTOCOL_MBUS  0x10
#define PROTOCOL_ZBUS  0x20

// CLock speed
#define CLOCK_MASK  0xC0
#define CLOCK_8MHZ  0x00
#define CLOCK_16MHZ 0x40

#define MAX_FILTERS 2

#endif
