/*
 Rocrail - Model Railroad Software
 Copyright (c) 2002-2018 Robert Jan Versluis, Rocrail.net
 All rights reserved.
*/
#ifndef _RCAN_zbus_H_
#define _RCAN_zbus_H_

#include "RCAN_dfs.h"
#include "cv.h"
#include "prot.h"


class ZBus : public Prot
{
private:
protected:
  byte m_CANID;
  unsigned int  m_UID;
  byte m_BoardType;

public:
  ZBus(byte ID, byte BoardType);
  bool evalFrame(iCANFrame frame, iCmdData cmd);
  bool makeFrame(iCANFrame frame, iCmdData cmd);
  int getCANBPS();
  void setID(byte id);
  byte getFilters(unsigned long* filters);
};


#endif
