/*
 Rocrail - Model Railroad Software
 Copyright (c) 2002-2018 Robert Jan Versluis, Rocrail.net
 All rights reserved.
*/
#include "zbus.h"
#include "zbus_dfs.h"
#include "trace.h"

//---------- ZBus constructor.
ZBus::ZBus(byte ID, byte BoardType) {
  m_CANID = ID;
  m_UID   = UID_SENSOR + m_CANID;
  trace("ZBus 0x%04X", m_UID );
  m_BoardType = BoardType;
}


/*
  :X1A02C030N30C22F1000020000;
  NID=C030 M=2 0A:00 8
  :X1802C030N0100000853460000;
  NID=C030 M=2 08:00 8


FILTER/MASK TRUTH TABLE
Mask | Filter | ID | Accept
 0       x      x    yes
 1       0      0    yes
 1       0      1    no
 1       1      0    no
 1       1      1    yes
 (x = dont care)
*/
// Seems to be positive filtering...
byte ZBus::getFilters(unsigned long* filters) {
  filters[0] = 0x0FFF0000; // MASK
  filters[1] = 0x08020000;
  return 0; // Disable... 
}


int ZBus::getCANBPS() {
  return 125;
}

void ZBus::setID(byte id) {
  m_CANID = id;
}


bool ZBus::evalFrame(iCANFrame frame, iCmdData cmd) {
  bool eval = false;
  cmd->cmd = 0;
  if( frame->id > 0 ) {
    byte cmd = (byte)((frame->id >> 18) & 0x3F);
    byte grp = (byte)((frame->id >> 24) & 0x0F);
    if( frame->dlc == 8 && (frame->id == 0x1A02C030 || frame->id == 0x1802C030) ) {
      // Filter out
    }
    else {
      trace("NID=%X M=%X %02X:%02X %d", (unsigned int)(frame->id & 0xFFFF), (byte)((frame->id >> 16) & 0x03), grp, cmd, frame->dlc );
    }
  }
  return eval;
}


bool ZBus::makeFrame(iCANFrame frame, iCmdData cmd) {
  bool didmake = false;

  if( cmd->cmd == EVT_OUTPUT || cmd->cmd == EVT_SENSOR) {
    unsigned long tmp = 0;
    frame->id = 0x10000000;
    tmp = GRP_ACCESSORY; tmp <<= 24;
    frame->id += tmp;
    tmp = ACCESSORY_PORT4; tmp <<= 18;
    frame->id += tmp;
    tmp = 2; tmp <<= 16; // Modus
    frame->id += tmp;
    frame->id += m_UID;
    frame->ext = 1;
    frame->dlc = 4;
    frame->data[0] = m_UID / 256;
    frame->data[1] = m_UID & 0xFF;
    frame->data[2] = cmd->addr + 1;
    frame->data[3] = cmd->value;
    didmake = true;
  }
  
  return didmake;
}
