; Compiled with: PIC Simulator IDE v7.27
; Microcontroller model: PIC16F886
; Clock frequency: 20.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R2L EQU 0x024
	R2H EQU 0x025
	R3L EQU 0x026
	R3H EQU 0x027
	R4L EQU 0x028
	R4H EQU 0x029
	R5L EQU 0x02A
	R5H EQU 0x02B
	R0HL EQU 0x020
	R1HL EQU 0x022
	R2HL EQU 0x024
	R3HL EQU 0x026
	R4HL EQU 0x028
	R5HL EQU 0x02A
	R1HL0HL EQU 0x020
	R3HL2HL EQU 0x024
	R5HL4HL EQU 0x028
	LONG_0 EQU 0x02C
	LONG_1 EQU 0x02D
	LONG_2 EQU 0x02E
	LONG_3 EQU 0x02F
	LONG2_0 EQU 0x030
	LONG2_1 EQU 0x031
	LONG2_2 EQU 0x032
	LONG2_3 EQU 0x033
	LONG1 EQU 0x02C
	LONG2 EQU 0x030
	SCL_PORT EQU 0x034
	SCL_BIT EQU 0x035
	SDA_PORT EQU 0x036
	SDA_BIT EQU 0x037
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'disp3' (global) is 112
;       The value of 'disp4' (global) is 114
;       The value of 'mem_act_pos' (global) is 201
;       The value of 'mem_turn_counter' (global) is 202
;       The value of 'mem_speed_min' (global) is 203
;       The value of 'mem_speed_max' (global) is 204
;       The value of 'mem_speed_step' (global) is 205
;       The value of 'mem_one_round' (global) is 206
;       The value of 'mem_ctrl_type' (global) is 210
;       The value of 'mem_max_pos' (global) is 211
;       The value of 'mem_free_space' (global) is 212
;       The value of 'mem_rev_pos' (global) is 214
;       The value of 'mem_bridge_power' (global) is 215
;       The value of 'mem_pos_match_delay' (global) is 216
;       The value of 'mem_bridge_rev_pos' (global) is 217
;       The value of 'mem_motor_start_delay' (global) is 218
;       The value of 'mem_relay_on_delay' (global) is 219
;       The value of 'mem_incremental_count' (global) is 220
;       The address of 'steps' (long) (global) is 0x03A
;       The address of 'half_steps' (long) (global) is 0x075
;       The address of 'ramp_down_point' (long) (global) is 0x06E
;       The address of 'program_set' (byte) (global) is 0x047
;       The address of 'new_steps' (long) (global) is 0x052
;       The address of 'act_steps' (long) (global) is 0x066
;       The address of 'new_pos' (byte) (global) is 0x05E
;       The address of 'act_pos' (byte) (global) is 0x042
;       The address of 'one_round' (long) (global) is 0x056
;       The address of 'one_round_half' (long) (global) is 0x079
;       The address of 'bus_pos' (byte) (global) is 0x062
;       The address of 'old_bus_pos' (byte) (global) is 0x06A
;       The address of 'speed' (word) (global) is 0x05F
;       The address of 'speed_min' (word) (global) is 0x040
;       The address of 'speed_max' (word) (global) is 0x04A
;       The address of 'new_encoder' (byte) (global) is 0x063
;       The address of 'old_encoder' (byte) (global) is 0x06B
;       The address of 'manual_pos' (byte) (global) is 0x03E
;       The address of 'old_manual_pos' (byte) (global) is 0x065
;       The address of 'result' (byte) (global) is 0x03F
;       The address of 'free_space_steps' (word) (global) is 0x048
;       The address of 'value' (byte) (global) is 0x038
;       The address of 'eprom_pointer' (byte) (global) is 0x039
;       The address of 'encoder_count' (byte) (global) is 0x05A
;       The address of 'max_pos' (byte) (global) is 0x045
;       The address of 'disp1_val' (byte) (global) is 0x04C
;       The address of 'disp2_val' (byte) (global) is 0x04D
;       The address of 'old_pos_write' (bit) (global) is 0x05B,5
;       The address of 'ramp_up' (bit) (global) is 0x05B,2
;       The address of 'speed_step' (byte) (global) is 0x05D
;       The address of 'version' (bit) (global) is 0x05B,3
;       The address of 'steps_set' (bit) (global) is 0x05B,1
;       The address of 'bridge_power' (byte) (global) is 0x061
;       The address of 'pos_match_delay' (byte) (global) is 0x04E
;       The address of 'bridge_rev_pos' (byte) (global) is 0x04F
;       The address of 'ctrl_type' (byte) (global) is 0x046
;       The address of 'turn_counter' (byte) (global) is 0x064
;       The address of 'proceed' (bit) (global) is 0x05B,0
;       The address of 'motor_start_delay' (byte) (global) is 0x050
;       The address of 'relay_on_delay' (byte) (global) is 0x051
;       The address of 'incremental_count' (byte) (global) is 0x072
;       The address of 'longword' (word) (global) is 0x043
;       The address of 'delay_value' (byte) (wait_pos_match) is 0x06C
;       The address of 'delay_value' (byte) (delays) is 0x05C
;       The address of 'speed' (word) (run_to_zero) is 0x073
;       The address of 'calc' (bit) (run_to_zero) is 0x05B,7
;       The address of 'bitposition' (bit) (run_to_zero_switch) is 0x05B,6
;       The address of 'counting' (bit) (run_to_zero_switch) is 0x06D,0
;       The address of 'onoff' (bit) (relays) is 0x05B,4
;       The address of 'swfw' (bit) (global) is 0x006,0
;       The address of 'swrev' (bit) (global) is 0x006,1
;       The address of 'sck' (bit) (global) is 0x006,2
;       The address of 'sda' (bit) (global) is 0x006,3
;       The address of 'pos_match' (bit) (global) is 0x006,4
;       The address of 'pos_write' (bit) (global) is 0x006,5
;       The address of 'direction' (bit) (global) is 0x007,0
;       The address of 'clk' (bit) (global) is 0x007,1
;       The address of 'ena' (bit) (global) is 0x007,2
;       The address of 'zero' (bit) (global) is 0x006,6
;       The address of 'max_end' (bit) (global) is 0x006,7
;       The address of 'ec1' (bit) (global) is 0x007,4
;       The address of 'ec2' (bit) (global) is 0x007,5
;       The address of 'ecsw' (bit) (global) is 0x007,6
;       The address of 'pgm' (bit) (global) is 0x007,7
;       The address of 'adjust_en' (bit) (global) is 0x007,3
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0024
	ORG 0x0004
	RETFIE
; LookUp Table: (3, 2, 1, 3)
_lookup_lab_0001:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
; LookUp Table: (1, 3, 3, 2)
_lookup_lab_0002:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
; LookUp Table: (2, 3, 3, 1)
_lookup_lab_0003:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
; LookUp Table: (3, 1, 2, 3)
_lookup_lab_0004:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0005:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; LookUp Table: (%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111)
_lookup_lab_0006:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0007:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; LookUp Table: (%10111111, %10111001, %10100100, %10110000, %10011001, %10010010, %10000010, %10111000, %10000000, %10010000, %10111111)
_lookup_lab_0008:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xBF
	RETLW 0xB9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xB8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
; Delay Routine Byte
; minimal routine execution time: 2s
; routine execution time step: 1s
; maximal routine execution time: 256s
DL01:
	NOP
	NOP
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 3s
; routine execution time step: 2s
; maximal routine execution time: 131073s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0xF1
	MOVWF R4L
	MOVLW 0x01
	MOVWF R4H
	CALL DL02
	GOTO W001
; Waitus Routine Word
; minimal routine execution time: 3s
; routine execution time step: 2s
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; Long Addition Routine
LA01:	MOVF R2L,W
	ADDWF R0L,F
	BTFSC STATUS,C
	CALL LA02
	MOVF R2H,W
	ADDWF R0H,F
	BTFSC STATUS,C
	CALL LA03
	MOVF R3L,W
	ADDWF R1L,F
	BTFSC STATUS,C
	CALL LA04
	MOVF R3H,W
	ADDWF R1H,F
	RETURN
LA02:	INCF R0H,F
	BTFSS STATUS,Z
	RETURN
LA03:	INCF R1L,F
	BTFSS STATUS,Z
	RETURN
LA04:	INCF R1H,F
	RETURN
; Long Subtraction Routine
LS01:
	CALL LS02
	CALL LA01
	RETURN
LS02:	COMF R2L,F
	COMF R2H,F
	COMF R3L,F
	COMF R3H,F
	INCF R2L,F
	BTFSS STATUS,Z
	RETURN
	INCF R2H,F
	BTFSS STATUS,Z
	RETURN
	INCF R3L,F
	BTFSS STATUS,Z
	RETURN
	INCF R3H,F
	RETURN
; Long Multiplication Routine
LM01:	CLRF R0L
	CLRF R0H
	CLRF R1L
	CLRF R1H
	BCF STATUS,IRP
	MOVLW LONG_0
	MOVWF FSR
	MOVLW 0x04
	MOVWF R5L
	GOTO LM03
LM02:
	CALL LM04
LM03:
	BTFSC INDF,0
	CALL LA01
	CALL LM04
	BTFSC INDF,1
	CALL LA01
	CALL LM04
	BTFSC INDF,2
	CALL LA01
	CALL LM04
	BTFSC INDF,3
	CALL LA01
	CALL LM04
	BTFSC INDF,4
	CALL LA01
	CALL LM04
	BTFSC INDF,5
	CALL LA01
	CALL LM04
	BTFSC INDF,6
	CALL LA01
	CALL LM04
	BTFSC INDF,7
	CALL LA01
	INCF FSR,F
	DECF R5L,F
	BTFSS STATUS,Z
	GOTO LM02
	RETURN
LM04:	BCF STATUS,C
	RLF R2L,F
	RLF R2H,F
	RLF R3L,F
	RLF R3H,F
	RETURN
; Long Division Routine
LD01:	CLRF LONG_0
	CLRF LONG_1
	CLRF LONG_2
	CLRF LONG_3
	BCF STATUS,IRP
LD02:
	BTFSS R3H,7
	GOTO LD03
	RETURN
LD03:
	CALL LS02
	BTFSC R3H,7
	GOTO LD04
	RETURN
LD04:	CLRF R5H
LD05:
	BTFSS R3H,6
	GOTO LD06
	INCF R5H,F
	CALL LM04
	GOTO LD05
LD06:	MOVF R1H,W
	MOVWF LONG2_3
	MOVF R1L,W
	MOVWF LONG2_2
	MOVF R0H,W
	MOVWF LONG2_1
	MOVF R0L,W
	MOVWF LONG2_0
	CALL LA01
	BTFSS R1H,7
	GOTO LD07
	MOVF LONG2_3,W
	MOVWF R1H
	MOVF LONG2_2,W
	MOVWF R1L
	MOVF LONG2_1,W
	MOVWF R0H
	MOVF LONG2_0,W
	MOVWF R0L
	GOTO LD99
LD07:	MOVF R5H,W
	SUBLW 0x07
	BTFSS STATUS,C
	GOTO LD08
	MOVLW LONG_0
	GOTO LD20
LD08:	MOVF R5H,W
	SUBLW 0x0F
	BTFSS STATUS,C
	GOTO LD09
	MOVLW LONG_1
	GOTO LD20
LD09:	MOVF R5H,W
	SUBLW 0x17
	BTFSS STATUS,C
	GOTO LD10
	MOVLW LONG_2
	GOTO LD20
LD10:	MOVLW LONG_3
LD20:	MOVWF FSR
	MOVF R5H,W
	ANDLW 0x07
	MOVWF R5L
	MOVLW 0x01
	MOVWF R4H
	BTFSC STATUS,Z
	GOTO LD30
LD21:	BCF STATUS,C
	RLF R4H,F
	DECFSZ R5L,F
	GOTO LD21
LD30:	MOVF R4H,W
	IORWF INDF,F
LD99:	BSF STATUS,C
	RRF R3H,F
	RRF R3L,F
	RRF R2H,F
	RRF R2L,F
	DECF R5H,F
	BTFSS R5H,7
	GOTO LD06
	RETURN
; Long Comparison Routine
CL01:	MOVF R3H,W
	SUBWF R1H,W
	BTFSS STATUS,Z
	GOTO CL02
	MOVF R3L,W
	SUBWF R1L,W
	BTFSS STATUS,Z
	GOTO CL02
	MOVF R2H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO CL02
	MOVF R2L,W
	SUBWF R0L,W
CL02:	RETURN
CL03:	MOVF R1H,W
	SUBWF R3H,W
	BTFSS STATUS,Z
	GOTO CL04
	MOVF R1L,W
	SUBWF R3L,W
	BTFSS STATUS,Z
	GOTO CL04
	MOVF R0H,W
	SUBWF R2H,W
	BTFSS STATUS,Z
	GOTO CL04
	MOVF R0L,W
	SUBWF R2L,W
CL04:	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
;
;
; User code start
L0024:
; 1: 
; 2: Define CONFIG = 0x23e2
; 3: Define CONFIG2 = 0x3eff
; 4: 
; 5: 
; 6: 
; 7: 'program TT for PCBoard GCA145 / MGV145
; 8: 'Universal version N_1_1  Speed for position 63, going to zero point, is set to minimum
; 9: 'For sliding systems (FY) extra end switch is used.
; 10: 'RB7 on ICSP1 (pin3) is endswitch (pass last rail)
; 11: 'J4 is used as zero switch (pass first rail)
; 12: 'EEP1 jumper is to be set permanatly On at MGV145, EEP1 on GCA145 can be omitted
; 13: 'PROCESSOR PIC16F886 !!!!!
; 14: 'three extra position are possible:
; 15: '-  position 63 to go to zero switch and then to rail 1
; 16: '-  Position 62 to manually set all positions first time (Manual initialisation, only when eep1 is set)
; 17: 'programs :
; 18: '0  correction actual position
; 19: '1  Max positions
; 20: '2  min speed
; 21: '3  max speed
; 22: '4  incr/decr delay
; 23: '5  extra correction steps
; 24: '6  bridge power normal/ reversed (Pos) at this position and all higher ones, bridge power is reversed
; 25: '7  Bridge power on/off (1/0) while moving
; 26: '8  pos_match delay
; 27: '9  setting of control type (0..6)
; 28: '-  control types:
; 29: '-    1 |control is set For turntable NO 'shortest way option' means that running from highest to lowest position (or v.v.) will NOT pass 0 position.|
; 30: '-    2 |control is set For turntable with  'shortest way option' which means that running from one to next position (or v.v.) could pass 0 position.|
; 31: '-    3 |version for two rail tt, no restriction on 'short way'. This is special for TT with contact rings  (no cables).|
; 32: '-    4 |fiddle yard.railpower. End switch at the High position side is needed.|
; 33: 
; 34: '-      for control type see manual
; 35: '- V7.2  2 apr 2013  Delay after position set activated.
; 36: '- V7.3  May 20 2013 In fiddle yard function, max-limit swotch is now emergengy stop for both directions.
; 37: '- V_N1_1 march 2014 maximum steps increased to 1,000,000
; 38: '-                   motor will be on hold with power on for 250 mSecs to be able to brake motor movement.
; 39: '- V_N1.2 nov 2014 menu 8 amd 9 are swapped
; 40: '-                 menu extended with 2 extra delay settings,
; 41: '-     menu 9   delay before motor starts after sending new value
; 42: '-     menu 10  delay after motor stops, before rails are switched on
; 43: '-     menu 11  delay between rails on and indication 'Systemn ready'is sent.
; 44: Dim steps As Long
; 45: Dim half_steps As Long
; 46: Dim ramp_down_point As Long
; 47: Dim program_set As Byte
; 48: Dim new_steps As Long
; 49: Dim act_steps As Long
; 50: Dim new_pos As Byte
; 51: Dim act_pos As Byte
; 52: Dim one_round As Long
; 53: Dim one_round_half As Long
; 54: Dim bus_pos As Byte
; 55: Dim old_bus_pos As Byte
; 56: Dim speed As Word
; 57: Dim speed_min As Word
; 58: Dim speed_max As Word
; 59: Dim new_encoder As Byte
; 60: Dim old_encoder As Byte
; 61: Dim manual_pos As Byte
; 62: Dim old_manual_pos As Byte
; 63: Dim result As Byte
; 64: Dim free_space_steps As Word
; 65: Dim value As Byte
; 66: Dim eprom_pointer As Byte
; 67: Dim encoder_count As Byte
; 68: 'Dim onoff As Bit
; 69: Dim max_pos As Byte
; 70: Dim disp1_val As Byte
; 71: Dim disp2_val As Byte
; 72: Dim old_pos_write As Bit
; 73: Dim ramp_up As Bit
; 74: Dim speed_step As Byte
; 75: Dim version As Bit
; 76: Dim steps_set As Bit
; 77: Dim bridge_power As Byte
; 78: Dim pos_match_delay As Byte
; 79: Dim bridge_rev_pos As Byte
; 80: Dim ctrl_type As Byte
; 81: Dim turn_counter As Byte
; 82: Dim proceed As Bit
; 83: Dim motor_start_delay As Byte
; 84: Dim relay_on_delay As Byte
; 85: Dim incremental_count As Byte
; 86: Dim longword As Word
; 87: Const disp1 = 64
; 88: Const disp2 = 66
; 89: Const disp3 = 112
; 90: Const disp4 = 114
; 91: Const mem_act_pos = 201
; 92: Const mem_turn_counter = 202
; 93: Const mem_speed_min = 203
; 94: Const mem_speed_max = 204
; 95: Const mem_speed_step = 205
; 96: Const mem_one_round = 206  '4 BYTES RESERVED
; 97: Const mem_ctrl_type = 210
; 98: Const mem_max_pos = 211
; 99: Const mem_free_space = 212  '2 BYTES RESERVED
; 100: Const mem_rev_pos = 214
; 101: Const mem_bridge_power = 215
; 102: Const mem_pos_match_delay = 216
; 103: Const mem_bridge_rev_pos = 217
; 104: Const mem_motor_start_delay = 218
; 105: Const mem_relay_on_delay = 219
; 106: Const mem_incremental_count = 220
; 107: Symbol swfw = RB0
; 108: Symbol swrev = RB1
; 109: Symbol sck = RB2
; 110: Symbol sda = RB3
; 111: Symbol pos_match = RB4
; 112: Symbol pos_write = RB5
; 113: Symbol direction = RC0
; 114: Symbol clk = RC1
; 115: Symbol ena = RC2
; 116: Symbol zero = RB6
; 117: Symbol max_end = RB7
; 118: Symbol ec1 = RC4
; 119: Symbol ec2 = RC5
; 120: Symbol ecsw = RC6
; 121: Symbol pgm = RC7
; 122: Symbol adjust_en = RC3
; 123: AllDigital
	BSF STATUS,RP0
	BSF STATUS,RP1
	CLRF ANSEL
	CLRF ANSELH
	BCF STATUS,RP1
	BCF STATUS,RP0
; 124: 'ADCON1 = %0110
; 125: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF TRISA
	BCF STATUS,RP0
; 126: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF TRISB
	BCF STATUS,RP0
; 127: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF TRISC
	BCF STATUS,RP0
; 128: PORTB = %11101100
	MOVLW 0xEC
	MOVWF PORTB
; 129: PORTC = %11111000
	MOVLW 0xF8
	MOVWF PORTC
; 130: I2CPrepare sda, sck
	BCF STATUS,IRP
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
	CALL IC41
; 131: Gosub init_values
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0010
; 132: Call relays(1)
	BSF 0x05B,4
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0022
; 133: program_set = 0
	CLRF 0x047
; 134: max_end = 1
	BSF PORTB,7
; 135: 
; 136: main:
L0001:
; 137: If pgm = 0 Then
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC 0x007,7
	GOTO L0025
; 138: Gosub adjust_settings
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0004
; 139: WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 140: Endif
L0025:
; 141: 
; 142: Gosub get_new_position
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0002
; 143: If bus_pos <> old_bus_pos Then
	MOVF 0x062,W
	SUBWF 0x06A,W
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,Z
	GOTO L0026
; 144: Call relays(0)
	BCF 0x05B,4
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0022
; 145: pos_match = 1  'indicate not in position
	BSF PORTB,4
; 146: new_pos = bus_pos
	MOVF 0x062,W
	MOVWF 0x05E
; 147: Gosub stepmotor
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0007
; 148: Call delays(relay_on_delay)
	MOVF 0x051,W
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 149: Call relays(1)
	BSF 0x05B,4
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0022
; 150: Call wait_pos_match(pos_match_delay)
	MOVF 0x04E,W
	MOVWF 0x06C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0016
; 151: Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0027
L0026:
; 152: If ecsw = 0 Then  'only when knob is pushed
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC 0x007,6
	GOTO L0028
; 153: If manual_pos <> old_manual_pos Then
	MOVF 0x03E,W
	SUBWF 0x065,W
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,Z
	GOTO L0029
; 154: Call relays(0)
	BCF 0x05B,4
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0022
; 155: pos_match = 1  'indicate not in position
	BSF PORTB,4
; 156: old_manual_pos = manual_pos
	MOVF 0x03E,W
	MOVWF 0x065
; 157: new_pos = manual_pos
	MOVF 0x03E,W
	MOVWF 0x05E
; 158: Gosub stepmotor
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0007
; 159: Call delays(relay_on_delay)
	MOVF 0x051,W
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 160: Call relays(1)
	BSF 0x05B,4
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0022
; 161: Call wait_pos_match(pos_match_delay)
	MOVF 0x04E,W
	MOVWF 0x06C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0016
; 162: Endif
L0029:
; 163: Endif
L0028:
; 164: Endif
L0027:
; 165: WaitMs 10
	MOVLW 0x86
	MOVWF R4L
	MOVLW 0x13
	MOVWF R4H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL DL02
; 166: Goto main
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0001
; 167: End
	BCF PCLATH,3
	BCF PCLATH,4
L0030:	GOTO L0030
; 168: 
; 169: get_new_position:
L0002:
; 170: value = bus_pos  'remember the position
	MOVF 0x062,W
	MOVWF 0x038
; 171: If pos_write = 1 Then
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x006,5
	GOTO L0031
; 172: If old_pos_write = 0 Then  'react once on rising edge
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC 0x05B,5
	GOTO L0032
; 173: old_pos_write = 1
	BSF 0x05B,5
; 174: value = PORTA And 63  'now get value from J5
	MOVF PORTA,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x038
; 175: Select Case value
; 176: Case 63  'position reset is desired
	MOVF 0x038,W
	SUBLW 0x3F
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0033
; 177: value = 63
	MOVLW 0x3F
	MOVWF 0x038
; 178: Case 0  'POS 0 NOT ALLOWED, KEEP OLD VALUE ALIVE
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0034
L0033:
	MOVF 0x038,W
	SUBLW 0x00
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0035
; 179: value = bus_pos
	MOVF 0x062,W
	MOVWF 0x038
; 180: Case Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0036
L0035:
; 181: If value > max_pos Then  'this is not allowed
	MOVF 0x038,W
	SUBWF 0x045,W
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0037
; 182: value = bus_pos  'put it back to old situation
	MOVF 0x062,W
	MOVWF 0x038
; 183: Endif
L0037:
; 184: EndSelect
L0036:
L0034:
; 185: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 186: If value = bus_pos Then  'no other position is set, just a response on pos_write is required
	MOVF 0x038,W
	SUBWF 0x062,W
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0038
; 187: pos_match = 1
	BSF PORTB,4
; 188: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 189: pos_match = 0
	BCF PORTB,4
; 190: Endif
L0038:
; 191: Endif
L0032:
; 192: Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0039
L0031:
; 193: old_pos_write = 0
	BCF 0x05B,5
; 194: Endif
L0039:
; 195: bus_pos = value  'now take over the desired position
	MOVF 0x038,W
	MOVWF 0x062
; 196: Gosub calc_rotation
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0003
; 197: Select Case result
; 198: Case 1
	MOVF 0x03F,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0040
; 199: If encoder_count < 6 Then
	MOVLW 0x06
	SUBWF 0x05A,W
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0041
; 200: encoder_count = encoder_count + 1
	MOVF 0x05A,W
	ADDLW 0x01
	MOVWF 0x05A
; 201: Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0042
L0041:
; 202: encoder_count = 0
	CLRF 0x05A
; 203: Select Case manual_pos
; 204: Case < max_pos
	MOVF 0x045,W
	SUBWF 0x03E,W
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0043
; 205: manual_pos = manual_pos + 1
	MOVF 0x03E,W
	ADDLW 0x01
	MOVWF 0x03E
; 206: Case max_pos
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0044
L0043:
	MOVF 0x03E,W
	SUBWF 0x045,W
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0045
; 207: If adjust_en = 1 Then
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x007,3
	GOTO L0046
; 208: manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x03E
; 209: Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0047
L0046:
; 210: manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x03E
; 211: Endif
L0047:
; 212: Case 63
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0048
L0045:
	MOVF 0x03E,W
	SUBLW 0x3F
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0049
; 213: manual_pos = 1
	MOVLW 0x01
	MOVWF 0x03E
; 214: Case 62
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0050
L0049:
	MOVF 0x03E,W
	SUBLW 0x3E
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0051
; 215: manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x03E
; 216: Case Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0052
L0051:
; 217: EndSelect
L0052:
L0050:
L0048:
L0044:
; 218: value = manual_pos
	MOVF 0x03E,W
	MOVWF 0x038
; 219: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 220: Endif
L0042:
; 221: Case 2
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0053
L0040:
	MOVF 0x03F,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0054
; 222: If encoder_count > 0 Then
	MOVF 0x05A,W
	SUBLW 0x00
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0055
; 223: encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x05A,W
	MOVWF 0x05A
; 224: Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0056
L0055:
; 225: encoder_count = 6
	MOVLW 0x06
	MOVWF 0x05A
; 226: Select Case manual_pos
; 227: Case 62
	MOVF 0x03E,W
	SUBLW 0x3E
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0057
; 228: manual_pos = max_pos
	MOVF 0x045,W
	MOVWF 0x03E
; 229: Case 63
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0058
L0057:
	MOVF 0x03E,W
	SUBLW 0x3F
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0059
; 230: If adjust_en = 1 Then
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x007,3
	GOTO L0060
; 231: manual_pos = max_pos
	MOVF 0x045,W
	MOVWF 0x03E
; 232: Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0061
L0060:
; 233: manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x03E
; 234: Endif
L0061:
; 235: Case 1
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0062
L0059:
	MOVF 0x03E,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0063
; 236: manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x03E
; 237: Case 0
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0064
L0063:
	MOVF 0x03E,W
	SUBLW 0x00
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0065
; 238: manual_pos = 1
	MOVLW 0x01
	MOVWF 0x03E
; 239: Case Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0066
L0065:
; 240: manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x03E,W
	MOVWF 0x03E
; 241: EndSelect
L0066:
L0064:
L0062:
L0058:
; 242: value = manual_pos
	MOVF 0x03E,W
	MOVWF 0x038
; 243: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 244: Endif
L0056:
; 245: Case Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0067
L0054:
; 246: EndSelect
L0067:
L0053:
; 247: WaitMs 2
	MOVLW 0xE6
	MOVWF R4L
	MOVLW 0x03
	MOVWF R4H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL DL02
; 248: 
; 249: Return
	RETURN
; 250: 
; 251: 
; 252: 
; 253: calc_rotation:  'this routine checks the incrimental switch
L0003:
; 254: '1 = increasing value
; 255: '2 = decreasing value
; 256: '3 = no change
; 257: new_encoder = 0
	CLRF 0x063
; 258: new_encoder.0 = ec1
	BCF 0x063,0
	BTFSC PORTC,4
	BSF 0x063,0
; 259: new_encoder.1 = ec2
	BCF 0x063,1
	BTFSC PORTC,5
	BSF 0x063,1
; 260: result = 0
	CLRF 0x03F
; 261: Select Case old_encoder
; 262: Case 0
	MOVF 0x06B,W
	SUBLW 0x00
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0068
; 263: result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x063,W
	MOVWF R0L
	SUBLW 0x03
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0069
	BCF PCLATH,3
	BCF PCLATH,4
	CALL _lookup_lab_0001
	MOVWF 0x03F
L0069:
; 264: Case 1
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0070
L0068:
	MOVF 0x06B,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0071
; 265: result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x063,W
	MOVWF R0L
	SUBLW 0x03
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0072
	BCF PCLATH,3
	BCF PCLATH,4
	CALL _lookup_lab_0002
	MOVWF 0x03F
L0072:
; 266: Case 2
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0073
L0071:
	MOVF 0x06B,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0074
; 267: result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x063,W
	MOVWF R0L
	SUBLW 0x03
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0075
	BCF PCLATH,3
	BCF PCLATH,4
	CALL _lookup_lab_0003
	MOVWF 0x03F
L0075:
; 268: Case Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0076
L0074:
; 269: result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x063,W
	MOVWF R0L
	SUBLW 0x03
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0077
	BCF PCLATH,3
	BCF PCLATH,4
	CALL _lookup_lab_0004
	MOVWF 0x03F
L0077:
; 270: EndSelect
L0076:
L0073:
L0070:
; 271: old_encoder = new_encoder
	MOVF 0x063,W
	MOVWF 0x06B
; 272: Return
	RETURN
; 273: 
; 274: 
; 275: adjust_settings:
L0004:
; 276: Gosub i2c_display_pgm
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0006
; 277: WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 278: Call relays(0)
	BCF 0x05B,4
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0022
; 279: Gosub steps_reading
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0011
; 280: new_steps = act_steps  'nothing is changed yet
	MOVF 0x066,W
	MOVWF 0x052
	MOVF 0x067,W
	MOVWF 0x053
	MOVF 0x068,W
	MOVWF 0x054
	MOVF 0x069,W
	MOVWF 0x055
; 281: While pgm = 0  'the program switch is still activated
L0078:
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC 0x007,7
	GOTO L0079
; 282: If ecsw = 0 Then  'knob is pressed, inrease program_set
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC 0x007,6
	GOTO L0080
; 283: program_set = program_set + 1
	MOVF 0x047,W
	ADDLW 0x01
	MOVWF 0x047
; 284: If program_set > 11 Then
	MOVF 0x047,W
	SUBLW 0x0B
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0081
; 285: program_set = 0
	CLRF 0x047
; 286: Endif
L0081:
; 287: value = program_set
	MOVF 0x047,W
	MOVWF 0x038
; 288: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 289: WaitMs 1000  'give some time for display to be read
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 290: While ecsw = 0  'be sure pushbutton is released
L0082:
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC 0x007,6
	GOTO L0083
; 291: WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 292: Wend
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0082
L0083:
; 293: Endif
L0080:
; 294: Select Case program_set
; 295: Case 0  'correction of current position
	MOVF 0x047,W
	SUBLW 0x00
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0084
; 296: value = act_pos
	MOVF 0x042,W
	MOVWF 0x038
; 297: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 298: Gosub calc_rotation  'look for the knob to be turned
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0003
; 299: Select Case result
; 300: Case 1
	MOVF 0x03F,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0085
; 301: If new_steps < 1000000 Then
	MOVF 0x052,W
	MOVWF R0L
	MOVF 0x053,W
	MOVWF R0H
	MOVF 0x054,W
	MOVWF R1L
	MOVF 0x055,W
	MOVWF R1H
	MOVLW 0x40
	MOVWF R2L
	MOVLW 0x42
	MOVWF R2H
	MOVLW 0x0F
	MOVWF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL CL01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0086
; 302: ena = 1  'motor on
	BSF PORTC,2
; 303: new_steps = new_steps + 1
	MOVF 0x052,W
	MOVWF R0L
	MOVF 0x053,W
	MOVWF R0H
	MOVF 0x054,W
	MOVWF R1L
	MOVF 0x055,W
	MOVWF R1H
	MOVLW 0x01
	MOVWF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LA01
	MOVF R0L,W
	MOVWF 0x052
	MOVF R0H,W
	MOVWF 0x053
	MOVF R1L,W
	MOVWF 0x054
	MOVF R1H,W
	MOVWF 0x055
; 304: direction = 1
	BSF PORTC,0
; 305: clk = 1  'clock out
	BSF PORTC,1
; 306: WaitUs speed_min
	MOVF 0x040,W
	MOVWF R4L
	MOVF 0x041,W
	MOVWF R4H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL Y001
; 307: clk = 0
	BCF PORTC,1
; 308: 'WaitUs speed_min
; 309: Endif
L0086:
; 310: Case 2
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0087
L0085:
	MOVF 0x03F,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0088
; 311: If new_steps > 0 Then
	MOVF 0x052,W
	MOVWF R0L
	MOVF 0x053,W
	MOVWF R0H
	MOVF 0x054,W
	MOVWF R1L
	MOVF 0x055,W
	MOVWF R1H
	CLRF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL CL03
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0089
; 312: ena = 1  'motor on
	BSF PORTC,2
; 313: new_steps = new_steps - 1
	MOVF 0x052,W
	MOVWF R0L
	MOVF 0x053,W
	MOVWF R0H
	MOVF 0x054,W
	MOVWF R1L
	MOVF 0x055,W
	MOVWF R1H
	MOVLW 0x01
	MOVWF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LS01
	MOVF R0L,W
	MOVWF 0x052
	MOVF R0H,W
	MOVWF 0x053
	MOVF R1L,W
	MOVWF 0x054
	MOVF R1H,W
	MOVWF 0x055
; 314: direction = 0
	BCF PORTC,0
; 315: clk = 1  'clock out
	BSF PORTC,1
; 316: WaitUs speed_min
	MOVF 0x040,W
	MOVWF R4L
	MOVF 0x041,W
	MOVWF R4H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL Y001
; 317: clk = 0
	BCF PORTC,1
; 318: 'WaitUs speed_min
; 319: Endif
L0089:
; 320: Case Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0090
L0088:
; 321: EndSelect
L0090:
L0087:
; 322: Case 1  'setting of maximum positions
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0091
L0084:
	MOVF 0x047,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0092
; 323: steps_set = 0
	BCF 0x05B,1
; 324: ena = 0  'shut off motor
	BCF PORTC,2
; 325: value = max_pos
	MOVF 0x045,W
	MOVWF 0x038
; 326: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 327: Gosub calc_rotation
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0003
; 328: Select Case result
; 329: Case 1
	MOVF 0x03F,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0093
; 330: Call check_encoder_count()
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0023
; 331: If proceed = 1 Then
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x05B,0
	GOTO L0094
; 332: If max_pos < 48 Then  'no more positions possible
	MOVLW 0x30
	SUBWF 0x045,W
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0095
; 333: max_pos = max_pos + 1
	MOVF 0x045,W
	ADDLW 0x01
	MOVWF 0x045
; 334: Write mem_max_pos, max_pos
	MOVLW 0xD3
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x045,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BCF PCLATH,4
L0096:	BTFSC EECON1,WR
	GOTO L0096
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 335: Endif
L0095:
; 336: Endif
L0094:
; 337: Case 2
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0097
L0093:
	MOVF 0x03F,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0098
; 338: Call check_encoder_count()
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0023
; 339: If proceed = 1 Then
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x05B,0
	GOTO L0099
; 340: If max_pos > 2 Then  'minimum 2 positions
	MOVF 0x045,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0100
; 341: max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x045,W
	MOVWF 0x045
; 342: Write mem_max_pos, max_pos
	MOVLW 0xD3
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x045,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BCF PCLATH,4
L0101:	BTFSC EECON1,WR
	GOTO L0101
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 343: Endif
L0100:
; 344: Endif
L0099:
; 345: Case Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0102
L0098:
; 346: EndSelect
L0102:
L0097:
; 347: Case 2  'setting of speed interval Minimum
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0103
L0092:
	MOVF 0x047,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0104
; 348: 'setting will be done in multiple of 256 uSecs
; 349: 'minimum is usually not less then 5, and maximum is 99 (is real slow)
; 350: steps_set = 0
	BCF 0x05B,1
; 351: ena = 0  'shut off motor
	BCF PORTC,2
; 352: value = speed_min.HB
	MOVF 0x041,W
	MOVWF 0x038
; 353: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 354: Gosub calc_rotation
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0003
; 355: Call check_encoder_count()
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0023
; 356: If proceed = 1 Then
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x05B,0
	GOTO L0105
; 357: Select Case result
; 358: Case 1
	MOVF 0x03F,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0106
; 359: If speed_min.HB < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x041,W
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0107
; 360: speed_min.HB = speed_min.HB + 1
	MOVF 0x041,W
	ADDLW 0x01
	MOVWF 0x041
; 361: Write mem_speed_min, speed_min.HB
	MOVLW 0xCB
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x041,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BCF PCLATH,4
L0108:	BTFSC EECON1,WR
	GOTO L0108
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 362: Endif
L0107:
; 363: Case 2
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0109
L0106:
	MOVF 0x03F,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0110
; 364: If speed_min.HB > speed_max.HB Then
	MOVF 0x041,W
	SUBWF 0x04B,W
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0111
; 365: speed_min.HB = speed_min.HB - 1
	MOVLW 0x01
	SUBWF 0x041,W
	MOVWF 0x041
; 366: Write mem_speed_min, speed_min.HB
	MOVLW 0xCB
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x041,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BCF PCLATH,4
L0112:	BTFSC EECON1,WR
	GOTO L0112
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 367: Endif
L0111:
; 368: Case Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0113
L0110:
; 369: EndSelect
L0113:
L0109:
; 370: Endif
L0105:
; 371: Case 3  'setting of speed interval Maximum
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0114
L0104:
	MOVF 0x047,W
	SUBLW 0x03
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0115
; 372: 'setting will be done in multiple of 256 uSecs
; 373: 'minimum is 1 and maximum is 99 (is real slow)
; 374: steps_set = 0
	BCF 0x05B,1
; 375: ena = 0  'shut off motor
	BCF PORTC,2
; 376: value = speed_max.HB
	MOVF 0x04B,W
	MOVWF 0x038
; 377: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 378: Gosub calc_rotation
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0003
; 379: Call check_encoder_count()
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0023
; 380: If proceed = 1 Then
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x05B,0
	GOTO L0116
; 381: Select Case result
; 382: Case 1
	MOVF 0x03F,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0117
; 383: If speed_max.HB < speed_min.HB Then  'not more then speed_min
	MOVF 0x041,W
	SUBWF 0x04B,W
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0118
; 384: speed_max.HB = speed_max.HB + 1
	MOVF 0x04B,W
	ADDLW 0x01
	MOVWF 0x04B
; 385: Write mem_speed_max, speed_max.HB
	MOVLW 0xCC
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x04B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BCF PCLATH,4
L0119:	BTFSC EECON1,WR
	GOTO L0119
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 386: Endif
L0118:
; 387: Case 2
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0120
L0117:
	MOVF 0x03F,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0121
; 388: If speed_max.HB > 2 Then
	MOVF 0x04B,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0122
; 389: speed_max.HB = speed_max.HB - 1
	MOVLW 0x01
	SUBWF 0x04B,W
	MOVWF 0x04B
; 390: Write mem_speed_max, speed_max.HB
	MOVLW 0xCC
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x04B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BCF PCLATH,4
L0123:	BTFSC EECON1,WR
	GOTO L0123
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 391: Endif
L0122:
; 392: Case Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0124
L0121:
; 393: EndSelect
L0124:
L0120:
; 394: Endif
L0116:
; 395: Case 4  'setting of ramp up and down speed
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0125
L0115:
	MOVF 0x047,W
	SUBLW 0x04
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0126
; 396: 'speed will be the value that speed will be changed every step up and down
; 397: steps_set = 0
	BCF 0x05B,1
; 398: ena = 0  'shut off motor
	BCF PORTC,2
; 399: value = speed_step
	MOVF 0x05D,W
	MOVWF 0x038
; 400: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 401: Gosub calc_rotation
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0003
; 402: Call check_encoder_count()
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0023
; 403: If proceed = 1 Then
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x05B,0
	GOTO L0127
; 404: Select Case result
; 405: Case 1
	MOVF 0x03F,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0128
; 406: If speed_step < 99 Then  'maximum 99 is possible
	MOVLW 0x63
	SUBWF 0x05D,W
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0129
; 407: speed_step = speed_step + 1
	MOVF 0x05D,W
	ADDLW 0x01
	MOVWF 0x05D
; 408: Write mem_speed_step, speed_step
	MOVLW 0xCD
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x05D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BCF PCLATH,4
L0130:	BTFSC EECON1,WR
	GOTO L0130
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 409: Endif
L0129:
; 410: Case 2
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0131
L0128:
	MOVF 0x03F,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0132
; 411: If speed_step > 1 Then
	MOVF 0x05D,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0133
; 412: speed_step = speed_step - 1
	MOVLW 0x01
	SUBWF 0x05D,W
	MOVWF 0x05D
; 413: Write mem_speed_step, speed_step
	MOVLW 0xCD
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x05D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BCF PCLATH,4
L0134:	BTFSC EECON1,WR
	GOTO L0134
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 414: Endif
L0133:
; 415: Case Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0135
L0132:
; 416: EndSelect
L0135:
L0131:
; 417: Endif
L0127:
; 418: 
; 419: Case 5  'setting of extra free space steps
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0136
L0126:
	MOVF 0x047,W
	SUBLW 0x05
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0137
; 420: steps_set = 0
	BCF 0x05B,1
; 421: ena = 0  'shut off motor
	BCF PORTC,2
; 422: If free_space_steps > 250 Then
	MOVF 0x048,W
	MOVWF R0L
	MOVF 0x049,W
	MOVWF R0H
	MOVLW 0xFA
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C003
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0138
; 423: free_space_steps = 250
	MOVLW 0xFA
	MOVWF 0x048
	CLRF 0x049
; 424: Write mem_free_space, free_space_steps
	MOVLW 0xD4
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x048,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BCF PCLATH,4
L0139:	BTFSC EECON1,WR
	GOTO L0139
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 425: Endif
L0138:
; 426: value = free_space_steps
	MOVF 0x048,W
	MOVWF 0x038
; 427: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 428: Gosub calc_rotation
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0003
; 429: Call check_encoder_count()
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0023
; 430: If proceed = 1 Then
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x05B,0
	GOTO L0140
; 431: Select Case result
; 432: Case 1
	MOVF 0x03F,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0141
; 433: If free_space_steps < 99 Then  'display is limited to 99
	MOVF 0x048,W
	MOVWF R0L
	MOVF 0x049,W
	MOVWF R0H
	MOVLW 0x63
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C004
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0142
; 434: free_space_steps = free_space_steps + 1
	MOVF 0x048,W
	ADDLW 0x01
	MOVWF 0x048
	MOVF 0x049,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x049
; 435: Gosub set_free_space
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0013
; 436: Endif
L0142:
; 437: Case 2
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0143
L0141:
	MOVF 0x03F,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0144
; 438: If free_space_steps > 0 Then
	MOVF 0x048,W
	MOVWF R0L
	MOVF 0x049,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C003
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0145
; 439: free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x048,W
	MOVWF 0x048
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x049,W
	MOVWF 0x049
; 440: Gosub set_free_space
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0013
; 441: Write mem_free_space, free_space_steps
	MOVLW 0xD4
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x048,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BCF PCLATH,4
L0146:	BTFSC EECON1,WR
	GOTO L0146
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 442: Endif
L0145:
; 443: Case Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0147
L0144:
; 444: EndSelect
L0147:
L0143:
; 445: Endif
L0140:
; 446: Case 6  'at which postion is in bridge reversed power
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0148
L0137:
	MOVF 0x047,W
	SUBLW 0x06
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0149
; 447: steps_set = 0
	BCF 0x05B,1
; 448: ena = 0  'shut off motor
	BCF PORTC,2
; 449: steps_set = 0
	BCF 0x05B,1
; 450: ena = 0  'shut off motor
	BCF PORTC,2
; 451: value = bridge_rev_pos
	MOVF 0x04F,W
	MOVWF 0x038
; 452: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 453: Gosub calc_rotation
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0003
; 454: Call check_encoder_count()
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0023
; 455: If proceed = 1 Then
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x05B,0
	GOTO L0150
; 456: Select Case result
; 457: Case 1
	MOVF 0x03F,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0151
; 458: If bridge_rev_pos < max_pos Then  'no more positions possible
	MOVF 0x045,W
	SUBWF 0x04F,W
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0152
; 459: bridge_rev_pos = bridge_rev_pos + 1
	MOVF 0x04F,W
	ADDLW 0x01
	MOVWF 0x04F
; 460: Write mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0xD9
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x04F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BCF PCLATH,4
L0153:	BTFSC EECON1,WR
	GOTO L0153
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 461: Endif
L0152:
; 462: Case 2
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0154
L0151:
	MOVF 0x03F,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0155
; 463: If bridge_rev_pos > 0 Then  '0 does not effect reversing
	MOVF 0x04F,W
	SUBLW 0x00
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0156
; 464: bridge_rev_pos = bridge_rev_pos - 1
	MOVLW 0x01
	SUBWF 0x04F,W
	MOVWF 0x04F
; 465: Write mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0xD9
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x04F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BCF PCLATH,4
L0157:	BTFSC EECON1,WR
	GOTO L0157
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 466: Endif
L0156:
; 467: Case Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0158
L0155:
; 468: EndSelect
L0158:
L0154:
; 469: Endif
L0150:
; 470: Case 7  'setting if power should be on or off while bridge is moving (0 = off)
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0159
L0149:
	MOVF 0x047,W
	SUBLW 0x07
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0160
; 471: Read mem_bridge_power, bridge_power
	MOVLW 0xD7
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x061
; 472: If bridge_power > 1 Then
	MOVF 0x061,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0161
; 473: bridge_power = 1
	MOVLW 0x01
	MOVWF 0x061
; 474: Endif
L0161:
; 475: value = bridge_power
	MOVF 0x061,W
	MOVWF 0x038
; 476: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 477: Gosub calc_rotation
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0003
; 478: Call check_encoder_count()
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0023
; 479: If proceed = 1 Then
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x05B,0
	GOTO L0162
; 480: Select Case result
; 481: Case 1
	MOVF 0x03F,W
	SUBLW 0x01
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0163
; 482: bridge_power = 1
	MOVLW 0x01
	MOVWF 0x061
; 483: Write mem_bridge_power, bridge_power
	MOVLW 0xD7
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x061,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BCF PCLATH,4
L0164:	BTFSC EECON1,WR
	GOTO L0164
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 484: Case 2
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0165
L0163:
	MOVF 0x03F,W
	SUBLW 0x02
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0166
; 485: bridge_power = 0
	CLRF 0x061
; 486: Write mem_bridge_power, bridge_power
	MOVLW 0xD7
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x061,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BCF PCLATH,4
L0167:	BTFSC EECON1,WR
	GOTO L0167
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 487: Case Else
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0168
L0166:
; 488: EndSelect
L0168:
L0165:
; 489: Endif
L0162:
; 490: Case 8  'menu 8 , setting control type
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0169
L0160:
	MOVF 0x047,W
	SUBLW 0x08
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0170
; 491: steps_set = 0
	BCF 0x05B,1
; 492: ena = 0  'shut off motor
	BCF PORTC,2
; 493: If ctrl_type > 4 Then
	MOVF 0x046,W
	SUBLW 0x04
	BCF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0171
; 494: ctrl_type = 4
	MOVLW 0x04
	MOVWF 0x046
; 495: Write mem_ctrl_type, ctrl_type
	MOVLW 0xD2
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x046,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BCF PCLATH,4
L0172:	BTFSC EECON1,WR
	GOTO L0172
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 496: Endif
L0171:
; 497: value = ctrl_type
	MOVF 0x046,W
	MOVWF 0x038
; 498: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 499: Gosub calc_rotation
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0003
; 500: Call check_encoder_count()
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0023
; 501: If proceed = 1 Then
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x05B,0
	GOTO L0173
; 502: Select Case result
; 503: Case 1
	MOVF 0x03F,W
	SUBLW 0x01
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0174
; 504: If ctrl_type < 4 Then
	MOVLW 0x04
	SUBWF 0x046,W
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0175
; 505: ctrl_type = ctrl_type + 1
	MOVF 0x046,W
	ADDLW 0x01
	MOVWF 0x046
; 506: Write mem_ctrl_type, ctrl_type
	MOVLW 0xD2
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x046,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BCF PCLATH,4
L0176:	BTFSC EECON1,WR
	GOTO L0176
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 507: Endif
L0175:
; 508: Case 2
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0177
L0174:
	MOVF 0x03F,W
	SUBLW 0x02
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0178
; 509: If ctrl_type > 1 Then
	MOVF 0x046,W
	SUBLW 0x01
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0179
; 510: ctrl_type = ctrl_type - 1
	MOVLW 0x01
	SUBWF 0x046,W
	MOVWF 0x046
; 511: Write mem_ctrl_type, ctrl_type
	MOVLW 0xD2
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x046,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
	BCF PCLATH,4
L0180:	BTFSC EECON1,WR
	GOTO L0180
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 512: Endif
L0179:
; 513: Case Else
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0181
L0178:
; 514: EndSelect
L0181:
L0177:
; 515: Endif
L0173:
; 516: Case 9  'setting delay in .1 secs before 'tt ready' is sent)
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0182
L0170:
	MOVF 0x047,W
	SUBLW 0x09
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0183
; 517: Read mem_pos_match_delay, pos_match_delay
	MOVLW 0xD8
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x04E
; 518: If pos_match_delay > 99 Then
	MOVF 0x04E,W
	SUBLW 0x63
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0184
; 519: pos_match_delay = 10
	MOVLW 0x0A
	MOVWF 0x04E
; 520: Endif
L0184:
; 521: value = pos_match_delay
	MOVF 0x04E,W
	MOVWF 0x038
; 522: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 523: Gosub calc_rotation
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0003
; 524: Call check_encoder_count()
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0023
; 525: If proceed = 1 Then
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x05B,0
	GOTO L0185
; 526: Select Case result
; 527: Case 1
	MOVF 0x03F,W
	SUBLW 0x01
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0186
; 528: If pos_match_delay < 50 Then
	MOVLW 0x32
	SUBWF 0x04E,W
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0187
; 529: pos_match_delay = pos_match_delay + 1
	MOVF 0x04E,W
	ADDLW 0x01
	MOVWF 0x04E
; 530: Endif
L0187:
; 531: Write mem_pos_match_delay, pos_match_delay
	MOVLW 0xD8
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x04E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
	BCF PCLATH,4
L0188:	BTFSC EECON1,WR
	GOTO L0188
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 532: Case 2
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0189
L0186:
	MOVF 0x03F,W
	SUBLW 0x02
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0190
; 533: If pos_match_delay > 0 Then
	MOVF 0x04E,W
	SUBLW 0x00
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0191
; 534: pos_match_delay = pos_match_delay - 1
	MOVLW 0x01
	SUBWF 0x04E,W
	MOVWF 0x04E
; 535: Endif
L0191:
; 536: Write mem_pos_match_delay, pos_match_delay
	MOVLW 0xD8
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x04E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
	BCF PCLATH,4
L0192:	BTFSC EECON1,WR
	GOTO L0192
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 537: Case Else
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0193
L0190:
; 538: EndSelect
L0193:
L0189:
; 539: Endif
L0185:
; 540: Case 10  'settting delay in .1 secs before motor starts after sening new position
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0194
L0183:
	MOVF 0x047,W
	SUBLW 0x0A
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0195
; 541: Read mem_motor_start_delay, motor_start_delay
	MOVLW 0xDA
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x050
; 542: If motor_start_delay > 99 Then
	MOVF 0x050,W
	SUBLW 0x63
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0196
; 543: motor_start_delay = 10
	MOVLW 0x0A
	MOVWF 0x050
; 544: Endif
L0196:
; 545: value = motor_start_delay
	MOVF 0x050,W
	MOVWF 0x038
; 546: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 547: Gosub calc_rotation
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0003
; 548: Call check_encoder_count()
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0023
; 549: If proceed = 1 Then
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x05B,0
	GOTO L0197
; 550: Select Case result
; 551: Case 1
	MOVF 0x03F,W
	SUBLW 0x01
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0198
; 552: If motor_start_delay < 99 Then
	MOVLW 0x63
	SUBWF 0x050,W
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0199
; 553: motor_start_delay = motor_start_delay + 1
	MOVF 0x050,W
	ADDLW 0x01
	MOVWF 0x050
; 554: Endif
L0199:
; 555: Write mem_motor_start_delay, motor_start_delay
	MOVLW 0xDA
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x050,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
	BCF PCLATH,4
L0200:	BTFSC EECON1,WR
	GOTO L0200
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 556: Case 2
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0201
L0198:
	MOVF 0x03F,W
	SUBLW 0x02
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0202
; 557: If motor_start_delay > 0 Then
	MOVF 0x050,W
	SUBLW 0x00
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0203
; 558: motor_start_delay = motor_start_delay - 1
	MOVLW 0x01
	SUBWF 0x050,W
	MOVWF 0x050
; 559: Endif
L0203:
; 560: Write mem_motor_start_delay, motor_start_delay
	MOVLW 0xDA
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x050,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
	BCF PCLATH,4
L0204:	BTFSC EECON1,WR
	GOTO L0204
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 561: Case Else
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0205
L0202:
; 562: EndSelect
L0205:
L0201:
; 563: Endif
L0197:
; 564: Case 11  'settting delay in .1 secs before rails are switched on
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0206
L0195:
	MOVF 0x047,W
	SUBLW 0x0B
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0207
; 565: Read mem_relay_on_delay, relay_on_delay
	MOVLW 0xDB
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x051
; 566: If relay_on_delay > 99 Then
	MOVF 0x051,W
	SUBLW 0x63
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0208
; 567: relay_on_delay = 10
	MOVLW 0x0A
	MOVWF 0x051
; 568: Endif
L0208:
; 569: value = relay_on_delay
	MOVF 0x051,W
	MOVWF 0x038
; 570: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 571: Gosub calc_rotation
	BCF PCLATH,3
	BCF PCLATH,4
	CALL L0003
; 572: Call check_encoder_count()
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0023
; 573: If proceed = 1 Then
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x05B,0
	GOTO L0209
; 574: Select Case result
; 575: Case 1
	MOVF 0x03F,W
	SUBLW 0x01
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0210
; 576: If relay_on_delay < 99 Then
	MOVLW 0x63
	SUBWF 0x051,W
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0211
; 577: relay_on_delay = relay_on_delay + 1
	MOVF 0x051,W
	ADDLW 0x01
	MOVWF 0x051
; 578: Endif
L0211:
; 579: Write mem_relay_on_delay, relay_on_delay
	MOVLW 0xDB
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x051,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
	BCF PCLATH,4
L0212:	BTFSC EECON1,WR
	GOTO L0212
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 580: Case 2
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0213
L0210:
	MOVF 0x03F,W
	SUBLW 0x02
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0214
; 581: If relay_on_delay > 0 Then
	MOVF 0x051,W
	SUBLW 0x00
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0215
; 582: relay_on_delay = relay_on_delay - 1
	MOVLW 0x01
	SUBWF 0x051,W
	MOVWF 0x051
; 583: Endif
L0215:
; 584: Write mem_relay_on_delay, relay_on_delay
	MOVLW 0xDB
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x051,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
	BCF PCLATH,4
L0216:	BTFSC EECON1,WR
	GOTO L0216
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 585: Case Else
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0217
L0214:
; 586: EndSelect
L0217:
L0213:
; 587: Endif
L0209:
; 588: Case Else
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0218
L0207:
; 589: program_set = 0
	CLRF 0x047
; 590: EndSelect
L0218:
L0206:
L0194:
L0182:
L0169:
L0159:
L0148:
L0136:
L0125:
L0114:
L0103:
L0091:
; 591: WaitMs 2
	MOVLW 0xE6
	MOVWF R4L
	MOVLW 0x03
	MOVWF R4H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL DL02
; 592: Wend
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0078
L0079:
; 593: ena = 0  'shut off motor
	BCF PORTC,2
; 594: '***************   now check if changes have to BE written in eeprom
; 595: If new_steps <> act_steps Then  'now save new position
	MOVF 0x052,W
	MOVWF R0L
	MOVF 0x053,W
	MOVWF R0H
	MOVF 0x054,W
	MOVWF R1L
	MOVF 0x055,W
	MOVWF R1H
	MOVF 0x066,W
	MOVWF R2L
	MOVF 0x067,W
	MOVWF R2H
	MOVF 0x068,W
	MOVWF R3L
	MOVF 0x069,W
	MOVWF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL CL01
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,Z
	GOTO L0219
; 596: Gosub save_steps
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0012
; 597: Endif
L0219:
; 598: value = act_pos
	MOVF 0x042,W
	MOVWF 0x038
; 599: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 600: Call relays(1)
	BSF 0x05B,4
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0022
; 601: Return
	RETURN
; 602: 
; 603: i2c_display:
L0005:
; 604: Select Case value
; 605: Case 100
	MOVF 0x038,W
	SUBLW 0x64
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0220
; 606: disp1_val = %11111110
	MOVLW 0xFE
	MOVWF 0x04C
; 607: disp2_val = %11111110
	MOVLW 0xFE
	MOVWF 0x04D
; 608: Case 99
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0221
L0220:
	MOVF 0x038,W
	SUBLW 0x63
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0222
; 609: disp1_val = %10111111
	MOVLW 0xBF
	MOVWF 0x04C
; 610: disp2_val = %10111111
	MOVLW 0xBF
	MOVWF 0x04D
; 611: Case Else
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0223
L0222:
; 612: disp1_val = value
	MOVF 0x038,W
	MOVWF 0x04C
; 613: disp1_val = disp1_val Mod 10
	MOVF 0x04C,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVF R2L,W
	MOVWF 0x04C
; 614: disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x04C,W
	MOVWF R0L
	SUBLW 0x09
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0224
	BCF PCLATH,3
	BCF PCLATH,4
	CALL _lookup_lab_0005
	MOVWF 0x04C
L0224:
; 615: disp1_val.7 = pgm
	BCF 0x04C,7
	BTFSC PORTC,7
	BSF 0x04C,7
; 616: disp2_val = value
	MOVF 0x038,W
	MOVWF 0x04D
; 617: disp2_val = disp2_val / 10
	MOVF 0x04D,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVF R0L,W
	MOVWF 0x04D
; 618: disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x04D,W
	MOVWF R0L
	SUBLW 0x0A
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0225
	BCF PCLATH,3
	BCF PCLATH,4
	CALL _lookup_lab_0006
	MOVWF 0x04D
L0225:
; 619: disp2_val.7 = version
	BCF 0x04D,7
	BTFSC 0x05B,3
	BSF 0x04D,7
; 620: EndSelect
L0223:
L0221:
; 621: I2CStart
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC31
; 622: I2CSend disp1
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x40
	CALL IC01
; 623: I2CSend disp1_val
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x04C,W
	CALL IC01
; 624: I2CStop
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
; 625: I2CStart
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC31
; 626: I2CSend disp3
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x70
	CALL IC01
; 627: I2CSend disp1_val
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x04C,W
	CALL IC01
; 628: I2CStop
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
; 629: I2CStart
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC31
; 630: I2CSend disp2
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x42
	CALL IC01
; 631: I2CSend disp2_val
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x04D,W
	CALL IC01
; 632: I2CStop
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
; 633: I2CStart
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC31
; 634: I2CSend disp4
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x72
	CALL IC01
; 635: I2CSend disp2_val
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x04D,W
	CALL IC01
; 636: I2CStop
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
; 637: Return
	RETURN
; 638: 
; 639: i2c_display_pgm:
L0006:
; 640: disp1_val = value
	MOVF 0x038,W
	MOVWF 0x04C
; 641: disp1_val = disp1_val Mod 10
	MOVF 0x04C,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVF R2L,W
	MOVWF 0x04C
; 642: disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x04C,W
	MOVWF R0L
	SUBLW 0x09
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0226
	BCF PCLATH,3
	BCF PCLATH,4
	CALL _lookup_lab_0007
	MOVWF 0x04C
L0226:
; 643: disp1_val.7 = pgm
	BCF 0x04C,7
	BTFSC PORTC,7
	BSF 0x04C,7
; 644: disp2_val = value
	MOVF 0x038,W
	MOVWF 0x04D
; 645: disp2_val = disp2_val / 10
	MOVF 0x04D,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVF R0L,W
	MOVWF 0x04D
; 646: disp2_val = LookUp(%10111111, %10111001, %10100100, %10110000, %10011001, %10010010, %10000010, %10111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x04D,W
	MOVWF R0L
	SUBLW 0x0A
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0227
	BCF PCLATH,3
	BCF PCLATH,4
	CALL _lookup_lab_0008
	MOVWF 0x04D
L0227:
; 647: disp2_val.7 = version
	BCF 0x04D,7
	BTFSC 0x05B,3
	BSF 0x04D,7
; 648: I2CStart
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC31
; 649: I2CSend disp1
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x40
	CALL IC01
; 650: I2CSend disp1_val
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x04C,W
	CALL IC01
; 651: I2CStop
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
; 652: I2CStart
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC31
; 653: I2CSend disp3
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x70
	CALL IC01
; 654: I2CSend disp1_val
	BCF PCLATH,3
	BCF PCLATH,4
	MOVF 0x04C,W
	CALL IC01
; 655: I2CStop
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
; 656: I2CStart
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC31
; 657: I2CSend disp2
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x42
	CALL IC01
; 658: I2CSend %10111111
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0xBF
	CALL IC01
; 659: I2CStop
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
; 660: I2CStart
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC31
; 661: I2CSend disp4
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0x72
	CALL IC01
; 662: I2CSend %10111111
	BCF PCLATH,3
	BCF PCLATH,4
	MOVLW 0xBF
	CALL IC01
; 663: I2CStop
	BCF PCLATH,3
	BCF PCLATH,4
	CALL IC41
; 664: 
; 665: Return
	RETURN
; 666: 
; 667: stepmotor:
L0007:
; 668: speed = 0
	CLRF 0x05F
	CLRF 0x060
; 669: Gosub steps_reading
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0011
; 670: Select Case new_pos
; 671: Case 62  'this is the manual setting for each position
	MOVF 0x05E,W
	SUBLW 0x3E
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0228
; 672: 'this position is equal for all control types, except for max switch
; 673: 'in case of control type < 6 the zero switch is used for total steps calculation
; 674: 'and bridge will run one full round extra.
; 675: direction = 0  'first backward
	BCF PORTC,0
; 676: ena = 1  'motor on
	BSF PORTC,2
; 677: pos_match = 1  'not indicate pos_match
	BSF PORTB,4
; 678: Call delays(motor_start_delay)
	MOVF 0x050,W
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 679: Call run_to_zero_switch(1, 0)
	BSF 0x05B,6
	BCF 0x06D,0
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0021
; 680: Call delays(5)  'just keep motor powered for 0.4 sec
	MOVLW 0x05
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 681: ena = 0  'motor off
	BCF PORTC,2
; 682: Call delays(10)  'Wait 1 sec
	MOVLW 0x0A
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 683: one_round = 0  'start counting steps to max pos
	CLRF 0x056
	CLRF 0x057
	CLRF 0x058
	CLRF 0x059
; 684: ena = 1  'motor on
	BSF PORTC,2
; 685: act_pos = 1
	MOVLW 0x01
	MOVWF 0x042
; 686: If ctrl_type < 4 Then  'now extra round to be made to calculate total steps
	MOVLW 0x04
	SUBWF 0x046,W
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0229
; 687: Call run_to_zero_switch(0, 1)  'RUN TO ZERO SWITCH AND COUNT STEPS
	BCF 0x05B,6
	BSF 0x06D,0
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0021
; 688: Call run_to_zero_switch(1, 1)  'RUN TO ZERO SWITCH AND COUNT STEPS
	BSF 0x05B,6
	BSF 0x06D,0
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0021
; 689: Endif
L0229:
; 690: Gosub store_one_round
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0018
; 691: Call delays(10)  'Wait 1 sec
	MOVLW 0x0A
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 692: direction = 1  'run forward
	BSF PORTC,0
; 693: value = 0  'WE ARE IN ZERO POSITION NOW
	CLRF 0x038
; 694: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 695: one_round = 0  'temporary use variable to count individual postitions
	CLRF 0x056
	CLRF 0x057
	CLRF 0x058
	CLRF 0x059
; 696: While act_pos <= max_pos  'turn motor until max pos is reached
L0230:
	MOVF 0x042,W
	SUBWF 0x045,W
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,C
	GOTO L0231
; 697: clk = 1  'clock out
	BSF PORTC,1
; 698: WaitUs speed_min
	MOVF 0x040,W
	MOVWF R4L
	MOVF 0x041,W
	MOVWF R4H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL Y001
; 699: clk = 0
	BCF PORTC,1
; 700: 'WaitUs speed_min
; 701: one_round = one_round + 1
	MOVF 0x056,W
	MOVWF R0L
	MOVF 0x057,W
	MOVWF R0H
	MOVF 0x058,W
	MOVWF R1L
	MOVF 0x059,W
	MOVWF R1H
	MOVLW 0x01
	MOVWF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LA01
	MOVF R0L,W
	MOVWF 0x056
	MOVF R0H,W
	MOVWF 0x057
	MOVF R1L,W
	MOVWF 0x058
	MOVF R1H,W
	MOVWF 0x059
; 702: If ecsw = 0 Then  'knob is pressed, save position and increase act_pos
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC 0x007,6
	GOTO L0232
; 703: new_steps = one_round
	MOVF 0x056,W
	MOVWF 0x052
	MOVF 0x057,W
	MOVWF 0x053
	MOVF 0x058,W
	MOVWF 0x054
	MOVF 0x059,W
	MOVWF 0x055
; 704: Gosub save_steps
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0012
; 705: value = act_pos
	MOVF 0x042,W
	MOVWF 0x038
; 706: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 707: act_pos = act_pos + 1
	MOVF 0x042,W
	ADDLW 0x01
	MOVWF 0x042
; 708: WaitMs 500  'give some time to breeze
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 709: While ecsw = 0  'Check If knob is Not pressed
L0233:
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC 0x007,6
	GOTO L0234
; 710: Wend
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0233
L0234:
; 711: Endif
L0232:
; 712: If ctrl_type = 4 Then  'for FY , max limit switch is to be checked.
	MOVF 0x046,W
	SUBLW 0x04
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0235
; 713: If max_end = 0 Then  'end switch for fy is touched, end cycle
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC 0x006,7
	GOTO L0236
; 714: act_pos = max_pos + 1  'cancel the procedure
	MOVF 0x045,W
	ADDLW 0x01
	MOVWF 0x042
; 715: ena = 0
	BCF PORTC,2
; 716: Endif
L0236:
; 717: Endif
L0235:
; 718: Wend
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0230
L0231:
; 719: Write mem_turn_counter, 127  'reset turn_counter
	MOVLW 0xCA
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x7F
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
	BCF PCLATH,4
L0237:	BTFSC EECON1,WR
	GOTO L0237
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 720: Gosub get_one_round
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0019
; 721: direction = 0  'goto to zero switch
	BCF PORTC,0
; 722: ena = 1  'set anable on
	BSF PORTC,2
; 723: pos_match = 1  'not indicate pos_match
	BSF PORTB,4
; 724: Call delays(10)  'Wait 1 sec
	MOVLW 0x0A
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 725: Call run_to_zero_switch(1, 0)
	BSF 0x05B,6
	BCF 0x06D,0
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0021
; 726: Call delays(10)  'Wait 1 sec
	MOVLW 0x0A
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 727: act_pos = 0
	CLRF 0x042
; 728: new_pos = 1
	MOVLW 0x01
	MOVWF 0x05E
; 729: Gosub steps_reading
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0011
; 730: direction = 1  'now forwards
	BSF PORTC,0
; 731: steps = new_steps + free_space_steps
	MOVF 0x052,W
	MOVWF R0L
	MOVF 0x053,W
	MOVWF R0H
	MOVF 0x054,W
	MOVWF R1L
	MOVF 0x055,W
	MOVWF R1H
	MOVF 0x048,W
	MOVWF R2L
	MOVF 0x049,W
	MOVWF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LA01
	MOVF R0L,W
	MOVWF 0x03A
	MOVF R0H,W
	MOVWF 0x03B
	MOVF R1L,W
	MOVWF 0x03C
	MOVF R1H,W
	MOVWF 0x03D
; 732: ramp_up = 1
	BSF 0x05B,2
; 733: ramp_down_point = 0
	CLRF 0x06E
	CLRF 0x06F
	CLRF 0x070
	CLRF 0x071
; 734: half_steps = steps / 2
	MOVF 0x03A,W
	MOVWF R0L
	MOVF 0x03B,W
	MOVWF R0H
	MOVF 0x03C,W
	MOVWF R1L
	MOVF 0x03D,W
	MOVWF R1H
	MOVLW 0x02
	MOVWF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LD01
	MOVF LONG_0,W
	MOVWF 0x075
	MOVF LONG_1,W
	MOVWF 0x076
	MOVF LONG_2,W
	MOVWF 0x077
	MOVF LONG_3,W
	MOVWF 0x078
; 735: ena = 1  'set Enable on
	BSF PORTC,2
; 736: Call delays(10)  'Wait 1 sec
	MOVLW 0x0A
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 737: Call run_to_zero(speed_min, 0)
	MOVF 0x040,W
	MOVWF 0x073
	MOVF 0x041,W
	MOVWF 0x074
	BCF 0x05B,7
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0020
; 738: Call delays(10)  'Wait 1 sec
	MOVLW 0x0A
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 739: steps = free_space_steps
	MOVF 0x048,W
	MOVWF 0x03A
	MOVF 0x049,W
	MOVWF 0x03B
	CLRF 0x03C
	CLRF 0x03D
; 740: direction = 0  'now go back the free-space correction
	BCF PORTC,0
; 741: Call delays(10)  'Wait 1 sec
	MOVLW 0x0A
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 742: Call run_to_zero(speed_min, 0)
	MOVF 0x040,W
	MOVWF 0x073
	MOVF 0x041,W
	MOVWF 0x074
	BCF 0x05B,7
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0020
; 743: ena = 0  'enable off
	BCF PORTC,2
; 744: Call delays(pos_match_delay)  'Wait
	MOVF 0x04E,W
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 745: Case 63  'go to zero switch and then to 1st rail position (Pos 1)
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0238
L0228:
	MOVF 0x05E,W
	SUBLW 0x3F
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0239
; 746: direction = 0  'goto to zero switch
	BCF PORTC,0
; 747: ena = 1  'set anable on
	BSF PORTC,2
; 748: pos_match = 1  'not indicate pos_match
	BSF PORTB,4
; 749: Call delays(motor_start_delay)  'Wait 1 sec
	MOVF 0x050,W
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 750: Call run_to_zero_switch(1, 0)
	BSF 0x05B,6
	BCF 0x06D,0
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0021
; 751: Call delays(10)  'Wait 1 sec
	MOVLW 0x0A
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 752: new_pos = 1
	MOVLW 0x01
	MOVWF 0x05E
; 753: Gosub steps_reading
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0011
; 754: direction = 1  'now forwards
	BSF PORTC,0
; 755: steps = new_steps + free_space_steps
	MOVF 0x052,W
	MOVWF R0L
	MOVF 0x053,W
	MOVWF R0H
	MOVF 0x054,W
	MOVWF R1L
	MOVF 0x055,W
	MOVWF R1H
	MOVF 0x048,W
	MOVWF R2L
	MOVF 0x049,W
	MOVWF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LA01
	MOVF R0L,W
	MOVWF 0x03A
	MOVF R0H,W
	MOVWF 0x03B
	MOVF R1L,W
	MOVWF 0x03C
	MOVF R1H,W
	MOVWF 0x03D
; 756: ramp_up = 1
	BSF 0x05B,2
; 757: ramp_down_point = 0
	CLRF 0x06E
	CLRF 0x06F
	CLRF 0x070
	CLRF 0x071
; 758: half_steps = steps / 2
	MOVF 0x03A,W
	MOVWF R0L
	MOVF 0x03B,W
	MOVWF R0H
	MOVF 0x03C,W
	MOVWF R1L
	MOVF 0x03D,W
	MOVWF R1H
	MOVLW 0x02
	MOVWF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LD01
	MOVF LONG_0,W
	MOVWF 0x075
	MOVF LONG_1,W
	MOVWF 0x076
	MOVF LONG_2,W
	MOVWF 0x077
	MOVF LONG_3,W
	MOVWF 0x078
; 759: speed = speed_min
	MOVF 0x040,W
	MOVWF 0x05F
	MOVF 0x041,W
	MOVWF 0x060
; 760: ena = 1  'set Enable on
	BSF PORTC,2
; 761: pos_match = 1  'not indicate pos_match
	BSF PORTB,4
; 762: Call run_to_zero(speed_min, 1)
	MOVF 0x040,W
	MOVWF 0x073
	MOVF 0x041,W
	MOVWF 0x074
	BSF 0x05B,7
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0020
; 763: Call delays(10)  'Wait 1 sec
	MOVLW 0x0A
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 764: steps = free_space_steps
	MOVF 0x048,W
	MOVWF 0x03A
	MOVF 0x049,W
	MOVWF 0x03B
	CLRF 0x03C
	CLRF 0x03D
; 765: direction = 0  'now go back the free-space correction
	BCF PORTC,0
; 766: Call run_to_zero(speed_min, 1)
	MOVF 0x040,W
	MOVWF 0x073
	MOVF 0x041,W
	MOVWF 0x074
	BSF 0x05B,7
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0020
; 767: ena = 0  'enable off
	BCF PORTC,2
; 768: Case Else  'this is the normal position sequence
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0240
L0239:
; 769: steps = 0
	CLRF 0x03A
	CLRF 0x03B
	CLRF 0x03C
	CLRF 0x03D
; 770: one_round_half = one_round / 2
	MOVF 0x056,W
	MOVWF R0L
	MOVF 0x057,W
	MOVWF R0H
	MOVF 0x058,W
	MOVWF R1L
	MOVF 0x059,W
	MOVWF R1H
	MOVLW 0x02
	MOVWF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LD01
	MOVF LONG_0,W
	MOVWF 0x079
	MOVF LONG_1,W
	MOVWF 0x07A
	MOVF LONG_2,W
	MOVWF 0x07B
	MOVF LONG_3,W
	MOVWF 0x07C
; 771: If new_steps > act_steps Then
	MOVF 0x052,W
	MOVWF R0L
	MOVF 0x053,W
	MOVWF R0H
	MOVF 0x054,W
	MOVWF R1L
	MOVF 0x055,W
	MOVWF R1H
	MOVF 0x066,W
	MOVWF R2L
	MOVF 0x067,W
	MOVWF R2H
	MOVF 0x068,W
	MOVWF R3L
	MOVF 0x069,W
	MOVWF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL CL03
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0241
; 772: steps = new_steps - act_steps
	MOVF 0x052,W
	MOVWF R0L
	MOVF 0x053,W
	MOVWF R0H
	MOVF 0x054,W
	MOVWF R1L
	MOVF 0x055,W
	MOVWF R1H
	MOVF 0x066,W
	MOVWF R2L
	MOVF 0x067,W
	MOVWF R2H
	MOVF 0x068,W
	MOVWF R3L
	MOVF 0x069,W
	MOVWF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LS01
	MOVF R0L,W
	MOVWF 0x03A
	MOVF R0H,W
	MOVWF 0x03B
	MOVF R1L,W
	MOVWF 0x03C
	MOVF R1H,W
	MOVWF 0x03D
; 773: direction = 1
	BSF PORTC,0
; 774: Gosub check_0_pass_allowed
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0008
; 775: Else
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0242
L0241:
; 776: steps = act_steps - new_steps
	MOVF 0x066,W
	MOVWF R0L
	MOVF 0x067,W
	MOVWF R0H
	MOVF 0x068,W
	MOVWF R1L
	MOVF 0x069,W
	MOVWF R1H
	MOVF 0x052,W
	MOVWF R2L
	MOVF 0x053,W
	MOVWF R2H
	MOVF 0x054,W
	MOVWF R3L
	MOVF 0x055,W
	MOVWF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LS01
	MOVF R0L,W
	MOVWF 0x03A
	MOVF R0H,W
	MOVWF 0x03B
	MOVF R1L,W
	MOVWF 0x03C
	MOVF R1H,W
	MOVWF 0x03D
; 777: direction = 0
	BCF PORTC,0
; 778: Gosub check_0_pass_allowed
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0008
; 779: Endif
L0242:
; 780: If steps > 0 Then  'motor must be activated
	MOVF 0x03A,W
	MOVWF R0L
	MOVF 0x03B,W
	MOVWF R0H
	MOVF 0x03C,W
	MOVWF R1L
	MOVF 0x03D,W
	MOVWF R1H
	CLRF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL CL03
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0243
; 781: If direction = 1 Then
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x007,0
	GOTO L0244
; 782: steps = steps + free_space_steps
	MOVF 0x03A,W
	MOVWF R0L
	MOVF 0x03B,W
	MOVWF R0H
	MOVF 0x03C,W
	MOVWF R1L
	MOVF 0x03D,W
	MOVWF R1H
	MOVF 0x048,W
	MOVWF R2L
	MOVF 0x049,W
	MOVWF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LA01
	MOVF R0L,W
	MOVWF 0x03A
	MOVF R0H,W
	MOVWF 0x03B
	MOVF R1L,W
	MOVWF 0x03C
	MOVF R1H,W
	MOVWF 0x03D
; 783: Endif
L0244:
; 784: ramp_up = 1
	BSF 0x05B,2
; 785: ramp_down_point = 0
	CLRF 0x06E
	CLRF 0x06F
	CLRF 0x070
	CLRF 0x071
; 786: half_steps = steps / 2
	MOVF 0x03A,W
	MOVWF R0L
	MOVF 0x03B,W
	MOVWF R0H
	MOVF 0x03C,W
	MOVWF R1L
	MOVF 0x03D,W
	MOVWF R1H
	MOVLW 0x02
	MOVWF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LD01
	MOVF LONG_0,W
	MOVWF 0x075
	MOVF LONG_1,W
	MOVWF 0x076
	MOVF LONG_2,W
	MOVWF 0x077
	MOVF LONG_3,W
	MOVWF 0x078
; 787: speed = speed_min
	MOVF 0x040,W
	MOVWF 0x05F
	MOVF 0x041,W
	MOVWF 0x060
; 788: ena = 1  'set anable on
	BSF PORTC,2
; 789: pos_match = 1  'not indicate pos_match
	BSF PORTB,4
; 790: Call delays(motor_start_delay)  'Wait
	MOVF 0x050,W
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 791: While steps > 0  'NOW RUN UNTIL STEPS = 0
L0245:
	MOVF 0x03A,W
	MOVWF R0L
	MOVF 0x03B,W
	MOVWF R0H
	MOVF 0x03C,W
	MOVWF R1L
	MOVF 0x03D,W
	MOVWF R1H
	CLRF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL CL03
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0246
; 792: clk = 1  'clock out
	BSF PORTC,1
; 793: WaitUs speed
	MOVF 0x05F,W
	MOVWF R4L
	MOVF 0x060,W
	MOVWF R4H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL Y001
; 794: clk = 0
	BCF PORTC,1
; 795: Gosub speed_calc
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0009
; 796: steps = steps - 1
	MOVF 0x03A,W
	MOVWF R0L
	MOVF 0x03B,W
	MOVWF R0H
	MOVF 0x03C,W
	MOVWF R1L
	MOVF 0x03D,W
	MOVWF R1H
	MOVLW 0x01
	MOVWF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LS01
	MOVF R0L,W
	MOVWF 0x03A
	MOVF R0H,W
	MOVWF 0x03B
	MOVF R1L,W
	MOVWF 0x03C
	MOVF R1H,W
	MOVWF 0x03D
; 797: If ctrl_type = 4 Then  'only for fiddle yard
	MOVF 0x046,W
	SUBLW 0x04
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0247
; 798: If max_end = 0 Then
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC 0x006,7
	GOTO L0248
; 799: Gosub stop_the_motor
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0015
; 800: Endif
L0248:
; 801: Endif
L0247:
; 802: Wend
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0245
L0246:
; 803: If direction = 1 Then
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x007,0
	GOTO L0249
; 804: If free_space_steps > 0 Then
	MOVF 0x048,W
	MOVWF R0L
	MOVF 0x049,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C003
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0250
; 805: Call delays(10)  'Wait 1 sec
	MOVLW 0x0A
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 806: steps = free_space_steps
	MOVF 0x048,W
	MOVWF 0x03A
	MOVF 0x049,W
	MOVWF 0x03B
	CLRF 0x03C
	CLRF 0x03D
; 807: direction = 0  'now go back the free-space correction
	BCF PORTC,0
; 808: Call run_to_zero(speed_min, 0)
	MOVF 0x040,W
	MOVWF 0x073
	MOVF 0x041,W
	MOVWF 0x074
	BCF 0x05B,7
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0020
; 809: Endif
L0250:
; 810: Endif
L0249:
; 811: Call delays(25)  'just keep motor powered for 0.25 sec
	MOVLW 0x19
	MOVWF 0x05C
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0017
; 812: ena = 0  'enable off
	BCF PORTC,2
; 813: Endif
L0243:
; 814: EndSelect
L0240:
L0238:
; 815: act_pos = new_pos
	MOVF 0x05E,W
	MOVWF 0x042
; 816: Write mem_act_pos, act_pos
	MOVLW 0xC9
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x042,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
	BCF PCLATH,4
L0251:	BTFSC EECON1,WR
	GOTO L0251
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 817: bus_pos = act_pos
	MOVF 0x042,W
	MOVWF 0x062
; 818: old_bus_pos = act_pos
	MOVF 0x042,W
	MOVWF 0x06A
; 819: manual_pos = act_pos
	MOVF 0x042,W
	MOVWF 0x03E
; 820: old_manual_pos = act_pos
	MOVF 0x042,W
	MOVWF 0x065
; 821: 
; 822: Return
	RETURN
; 823: 
; 824: check_0_pass_allowed:
L0008:
; 825: If steps > one_round_half Then
	MOVF 0x03A,W
	MOVWF R0L
	MOVF 0x03B,W
	MOVWF R0H
	MOVF 0x03C,W
	MOVWF R1L
	MOVF 0x03D,W
	MOVWF R1H
	MOVF 0x079,W
	MOVWF R2L
	MOVF 0x07A,W
	MOVWF R2H
	MOVF 0x07B,W
	MOVWF R3L
	MOVF 0x07C,W
	MOVWF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL CL03
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0252
; 826: Select Case ctrl_type
; 827: Case 2  'crossing zero possible but only if not too many turns in one direction
	MOVF 0x046,W
	SUBLW 0x02
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0253
; 828: If steps > one_round_half Then
	MOVF 0x03A,W
	MOVWF R0L
	MOVF 0x03B,W
	MOVWF R0H
	MOVF 0x03C,W
	MOVWF R1L
	MOVF 0x03D,W
	MOVWF R1H
	MOVF 0x079,W
	MOVWF R2L
	MOVF 0x07A,W
	MOVWF R2H
	MOVF 0x07B,W
	MOVWF R3L
	MOVF 0x07C,W
	MOVWF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL CL03
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0254
; 829: Read mem_turn_counter, turn_counter  'get the total turns
	MOVLW 0xCA
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x064
; 830: If turn_counter > 124 And direction = 1 Then  'crossing point zero in direction 0 allowed
	MOVF 0x064,W
	SUBLW 0x7C
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0255
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x007,0
	GOTO L0255
; 831: turn_counter = turn_counter - 1  'substract 1 pass
	MOVLW 0x01
	SUBWF 0x064,W
	MOVWF 0x064
; 832: Write mem_turn_counter, turn_counter
	MOVLW 0xCA
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x064,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
	BCF PCLATH,4
L0256:	BTFSC EECON1,WR
	GOTO L0256
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 833: direction = 0  'change direction
	BCF PORTC,0
; 834: steps = one_round - steps  'set the number of steps for the other direction
	MOVF 0x056,W
	MOVWF R0L
	MOVF 0x057,W
	MOVWF R0H
	MOVF 0x058,W
	MOVWF R1L
	MOVF 0x059,W
	MOVWF R1H
	MOVF 0x03A,W
	MOVWF R2L
	MOVF 0x03B,W
	MOVWF R2H
	MOVF 0x03C,W
	MOVWF R3L
	MOVF 0x03D,W
	MOVWF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LS01
	MOVF R0L,W
	MOVWF 0x03A
	MOVF R0H,W
	MOVWF 0x03B
	MOVF R1L,W
	MOVWF 0x03C
	MOVF R1H,W
	MOVWF 0x03D
; 835: Else
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0257
L0255:
; 836: If turn_counter < 130 And direction = 0 Then  'crossing point zero in direction 1 allowed
	MOVLW 0x82
	SUBWF 0x064,W
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0258
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC 0x007,0
	GOTO L0258
; 837: turn_counter = turn_counter + 1
	MOVF 0x064,W
	ADDLW 0x01
	MOVWF 0x064
; 838: Write mem_turn_counter, turn_counter  'add 1 pass
	MOVLW 0xCA
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x064,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
	BCF PCLATH,4
L0259:	BTFSC EECON1,WR
	GOTO L0259
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 839: direction = 1  'change direction
	BSF PORTC,0
; 840: steps = one_round - steps  'set the number of steps for the other direction
	MOVF 0x056,W
	MOVWF R0L
	MOVF 0x057,W
	MOVWF R0H
	MOVF 0x058,W
	MOVWF R1L
	MOVF 0x059,W
	MOVWF R1H
	MOVF 0x03A,W
	MOVWF R2L
	MOVF 0x03B,W
	MOVWF R2H
	MOVF 0x03C,W
	MOVWF R3L
	MOVF 0x03D,W
	MOVWF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LS01
	MOVF R0L,W
	MOVWF 0x03A
	MOVF R0H,W
	MOVWF 0x03B
	MOVF R1L,W
	MOVWF 0x03C
	MOVF R1H,W
	MOVWF 0x03D
; 841: Endif
L0258:
; 842: Endif
L0257:
; 843: Endif
L0254:
; 844: Case 3  'shortest way always possible
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0260
L0253:
	MOVF 0x046,W
	SUBLW 0x03
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0261
; 845: direction = Not direction  'change direction
	MOVLW 0x01
	XORWF 0x007,F
; 846: steps = one_round - steps  'set the number of steps for the other direction
	MOVF 0x056,W
	MOVWF R0L
	MOVF 0x057,W
	MOVWF R0H
	MOVF 0x058,W
	MOVWF R1L
	MOVF 0x059,W
	MOVWF R1H
	MOVF 0x03A,W
	MOVWF R2L
	MOVF 0x03B,W
	MOVWF R2H
	MOVF 0x03C,W
	MOVWF R3L
	MOVF 0x03D,W
	MOVWF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LS01
	MOVF R0L,W
	MOVWF 0x03A
	MOVF R0H,W
	MOVWF 0x03B
	MOVF R1L,W
	MOVWF 0x03C
	MOVF R1H,W
	MOVWF 0x03D
; 847: Case Else  'no zero crossing allowed
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0262
L0261:
; 848: EndSelect
L0262:
L0260:
; 849: Endif
L0252:
; 850: Return
	RETURN
; 851: 
; 852: 
; 853: speed_calc:
L0009:
; 854: If steps < half_steps Then  'at this point  ramp up MUST end half way
	MOVF 0x03A,W
	MOVWF R0L
	MOVF 0x03B,W
	MOVWF R0H
	MOVF 0x03C,W
	MOVWF R1L
	MOVF 0x03D,W
	MOVWF R1H
	MOVF 0x075,W
	MOVWF R2L
	MOVF 0x076,W
	MOVWF R2H
	MOVF 0x077,W
	MOVWF R3L
	MOVF 0x078,W
	MOVWF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL CL01
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0263
; 855: ramp_up = 0
	BCF 0x05B,2
; 856: Endif
L0263:
; 857: If ramp_up = 1 Then  'we were supposed to ramp up
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS 0x05B,2
	GOTO L0264
; 858: If speed > speed_max Then
	MOVF 0x05F,W
	MOVWF R0L
	MOVF 0x060,W
	MOVWF R0H
	MOVF 0x04A,W
	MOVWF R1L
	MOVF 0x04B,W
	MOVWF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C003
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0265
; 859: speed = speed - speed_step
	MOVF 0x05D,W
	SUBWF 0x05F,W
	MOVWF 0x05F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x060,W
	MOVWF 0x060
; 860: ramp_down_point = ramp_down_point + 1  'this counts down with the steps
	MOVF 0x06E,W
	MOVWF R0L
	MOVF 0x06F,W
	MOVWF R0H
	MOVF 0x070,W
	MOVWF R1L
	MOVF 0x071,W
	MOVWF R1H
	MOVLW 0x01
	MOVWF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LA01
	MOVF R0L,W
	MOVWF 0x06E
	MOVF R0H,W
	MOVWF 0x06F
	MOVF R1L,W
	MOVWF 0x070
	MOVF R1H,W
	MOVWF 0x071
; 861: Else
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0266
L0265:
; 862: ramp_up = 0
	BCF 0x05B,2
; 863: Endif
L0266:
; 864: Else
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0267
L0264:
; 865: If steps < ramp_down_point Then  'this is the point tot start ramp down
	MOVF 0x03A,W
	MOVWF R0L
	MOVF 0x03B,W
	MOVWF R0H
	MOVF 0x03C,W
	MOVWF R1L
	MOVF 0x03D,W
	MOVWF R1H
	MOVF 0x06E,W
	MOVWF R2L
	MOVF 0x06F,W
	MOVWF R2H
	MOVF 0x070,W
	MOVWF R3L
	MOVF 0x071,W
	MOVWF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL CL01
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0268
; 866: If speed < speed_min Then
	MOVF 0x05F,W
	MOVWF R0L
	MOVF 0x060,W
	MOVWF R0H
	MOVF 0x040,W
	MOVWF R1L
	MOVF 0x041,W
	MOVWF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C004
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0269
; 867: speed = speed + speed_step
	MOVF 0x05F,W
	ADDWF 0x05D,W
	MOVWF 0x05F
	MOVF 0x060,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x060
; 868: Endif
L0269:
; 869: Endif
L0268:
; 870: Endif
L0267:
; 871: Return
	RETURN
; 872: 
; 873: 
; 874: 
; 875: init_values:
L0010:
; 876: value = 12  'version number
	MOVLW 0x0C
	MOVWF 0x038
; 877: version = 0  'decimal point in display on
	BCF 0x05B,3
; 878: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 879: WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 880: version = 1  'decimal point in display off
	BSF 0x05B,3
; 881: encoder_count = 0
	CLRF 0x05A
; 882: speed_min = 0
	CLRF 0x040
	CLRF 0x041
; 883: 
; 884: Read mem_ctrl_type, ctrl_type
	MOVLW 0xD2
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x046
; 885: If ctrl_type > 4 Or ctrl_type = 0 Then
	MOVF 0x046,W
	SUBLW 0x04
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0272
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0271
L0272:
	MOVF 0x046,W
	SUBLW 0x00
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0270
L0271:
; 886: ctrl_type = 1
	MOVLW 0x01
	MOVWF 0x046
; 887: Write mem_ctrl_type, ctrl_type
	MOVLW 0xD2
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x046,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
	BCF PCLATH,4
L0273:	BTFSC EECON1,WR
	GOTO L0273
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 888: Endif
L0270:
; 889: 
; 890: Read mem_speed_min, speed_min.HB
	MOVLW 0xCB
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x041
; 891: If speed_min.HB > 99 Then
	MOVF 0x041,W
	SUBLW 0x63
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0274
; 892: speed_min.HB = 30
	MOVLW 0x1E
	MOVWF 0x041
; 893: Else
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0275
L0274:
; 894: If speed_min.HB < 2 Then
	MOVLW 0x02
	SUBWF 0x041,W
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0276
; 895: speed_min.HB = 20
	MOVLW 0x14
	MOVWF 0x041
; 896: Endif
L0276:
; 897: Endif
L0275:
; 898: 
; 899: Write mem_speed_min, speed_min.HB
	MOVLW 0xCB
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x041,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
	BCF PCLATH,4
L0277:	BTFSC EECON1,WR
	GOTO L0277
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 900: speed_max = 0
	CLRF 0x04A
	CLRF 0x04B
; 901: Read mem_speed_max, speed_max.HB
	MOVLW 0xCC
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x04B
; 902: If speed_max.HB > speed_min.HB Then
	MOVF 0x04B,W
	SUBWF 0x041,W
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0278
; 903: speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x04B
; 904: Else
	BSF PCLATH,3
	BCF PCLATH,4
	GOTO L0279
L0278:
; 905: If speed_max.HB < 2 Then
	MOVLW 0x02
	SUBWF 0x04B,W
	BSF PCLATH,3
	BCF PCLATH,4
	BTFSC STATUS,C
	GOTO L0280
; 906: speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x04B
; 907: Endif
L0280:
; 908: Endif
L0279:
; 909: Write mem_speed_max, speed_max.HB
	MOVLW 0xCC
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x04B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BSF PCLATH,4
L0281:	BTFSC EECON1,WR
	GOTO L0281
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 910: eprom_pointer = mem_one_round
	MOVLW 0xCE
	MOVWF 0x039
; 911: Gosub get_one_round
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0019
; 912: If one_round > 1000000 Then
	MOVF 0x056,W
	MOVWF R0L
	MOVF 0x057,W
	MOVWF R0H
	MOVF 0x058,W
	MOVWF R1L
	MOVF 0x059,W
	MOVWF R1H
	MOVLW 0x40
	MOVWF R2L
	MOVLW 0x42
	MOVWF R2H
	MOVLW 0x0F
	MOVWF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL CL03
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0282
; 913: one_round = 0
	CLRF 0x056
	CLRF 0x057
	CLRF 0x058
	CLRF 0x059
; 914: Endif
L0282:
; 915: one_round_half = one_round / 2
	MOVF 0x056,W
	MOVWF R0L
	MOVF 0x057,W
	MOVWF R0H
	MOVF 0x058,W
	MOVWF R1L
	MOVF 0x059,W
	MOVWF R1H
	MOVLW 0x02
	MOVWF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LD01
	MOVF LONG_0,W
	MOVWF 0x079
	MOVF LONG_1,W
	MOVWF 0x07A
	MOVF LONG_2,W
	MOVWF 0x07B
	MOVF LONG_3,W
	MOVWF 0x07C
; 916: 
; 917: Read mem_max_pos, max_pos
	MOVLW 0xD3
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x045
; 918: If max_pos > 48 Or max_pos < 2 Then
	MOVF 0x045,W
	SUBLW 0x30
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0285
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0284
L0285:
	MOVLW 0x02
	SUBWF 0x045,W
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0283
L0284:
; 919: max_pos = 20
	MOVLW 0x14
	MOVWF 0x045
; 920: bridge_rev_pos = 10
	MOVLW 0x0A
	MOVWF 0x04F
; 921: Write mem_max_pos, max_pos
	MOVLW 0xD3
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x045,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BSF PCLATH,4
L0286:	BTFSC EECON1,WR
	GOTO L0286
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 922: Write mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0xD9
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x04F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BSF PCLATH,4
L0287:	BTFSC EECON1,WR
	GOTO L0287
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 923: Endif
L0283:
; 924: 
; 925: Read mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0xD9
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x04F
; 926: If bridge_rev_pos > max_pos Then
	MOVF 0x04F,W
	SUBWF 0x045,W
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0288
; 927: bridge_rev_pos = max_pos / 2
	MOVF 0x045,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL D001
	MOVF R0L,W
	MOVWF 0x04F
; 928: Write mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0xD9
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x04F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BSF PCLATH,4
L0289:	BTFSC EECON1,WR
	GOTO L0289
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 929: Endif
L0288:
; 930: 
; 931: Read mem_act_pos, act_pos
	MOVLW 0xC9
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x042
; 932: If act_pos > max_pos Then
	MOVF 0x042,W
	SUBWF 0x045,W
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0290
; 933: act_pos = 1
	MOVLW 0x01
	MOVWF 0x042
; 934: Write mem_act_pos, act_pos
	MOVLW 0xC9
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x042,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BSF PCLATH,4
L0291:	BTFSC EECON1,WR
	GOTO L0291
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 935: Endif
L0290:
; 936: value = act_pos
	MOVF 0x042,W
	MOVWF 0x038
; 937: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 938: 
; 939: Gosub get_free_space
	BCF PCLATH,3
	BSF PCLATH,4
	CALL L0014
; 940: If free_space_steps > 5000 Then
	MOVF 0x048,W
	MOVWF R0L
	MOVF 0x049,W
	MOVWF R0H
	MOVLW 0x88
	MOVWF R1L
	MOVLW 0x13
	MOVWF R1H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL C003
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0292
; 941: free_space_steps = 0
	CLRF 0x048
	CLRF 0x049
; 942: Endif
L0292:
; 943: 
; 944: Read mem_speed_step, speed_step
	MOVLW 0xCD
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x05D
; 945: If speed_step > 99 Then
	MOVF 0x05D,W
	SUBLW 0x63
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0293
; 946: speed_step = 99
	MOVLW 0x63
	MOVWF 0x05D
; 947: Write mem_speed_step, speed_step
	MOVLW 0xCD
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x05D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BSF PCLATH,4
L0294:	BTFSC EECON1,WR
	GOTO L0294
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 948: Endif
L0293:
; 949: 
; 950: Read mem_pos_match_delay, pos_match_delay
	MOVLW 0xD8
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x04E
; 951: If pos_match_delay > 50 Then
	MOVF 0x04E,W
	SUBLW 0x32
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0295
; 952: pos_match_delay = 10
	MOVLW 0x0A
	MOVWF 0x04E
; 953: Endif
L0295:
; 954: 
; 955: Read mem_relay_on_delay, relay_on_delay
	MOVLW 0xDB
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x051
; 956: If relay_on_delay > 99 Then
	MOVF 0x051,W
	SUBLW 0x63
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0296
; 957: relay_on_delay = 10
	MOVLW 0x0A
	MOVWF 0x051
; 958: Endif
L0296:
; 959: 
; 960: Read mem_motor_start_delay, motor_start_delay
	MOVLW 0xDA
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x050
; 961: If motor_start_delay > 99 Then
	MOVF 0x050,W
	SUBLW 0x63
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0297
; 962: motor_start_delay = 10
	MOVLW 0x0A
	MOVWF 0x050
; 963: Endif
L0297:
; 964: 
; 965: Read mem_incremental_count, incremental_count
	MOVLW 0xDC
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x072
; 966: If incremental_count > 10 Then
	MOVF 0x072,W
	SUBLW 0x0A
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0298
; 967: incremental_count = 5
	MOVLW 0x05
	MOVWF 0x072
; 968: Endif
L0298:
; 969: 
; 970: steps_set = 0
	BCF 0x05B,1
; 971: new_pos = act_pos
	MOVF 0x042,W
	MOVWF 0x05E
; 972: bus_pos = act_pos
	MOVF 0x042,W
	MOVWF 0x062
; 973: old_bus_pos = act_pos
	MOVF 0x042,W
	MOVWF 0x06A
; 974: manual_pos = act_pos
	MOVF 0x042,W
	MOVWF 0x03E
; 975: old_manual_pos = act_pos
	MOVF 0x042,W
	MOVWF 0x065
; 976: old_pos_write = 1
	BSF 0x05B,5
; 977: Return
	RETURN
; 978: 
; 979: steps_reading:
L0011:
; 980: Select Case act_pos
; 981: Case 63, 62
	MOVF 0x042,W
	SUBLW 0x3F
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0301
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0300
L0301:
	MOVF 0x042,W
	SUBLW 0x3E
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0299
L0300:
; 982: act_steps = 0
	CLRF 0x066
	CLRF 0x067
	CLRF 0x068
	CLRF 0x069
; 983: Case Else
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0302
L0299:
; 984: eprom_pointer = act_pos
	MOVF 0x042,W
	MOVWF 0x039
; 985: Read eprom_pointer, longword.LB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x043
; 986: eprom_pointer = eprom_pointer + 48
	MOVF 0x039,W
	ADDLW 0x30
	MOVWF 0x039
; 987: Read eprom_pointer, longword.HB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x044
; 988: act_steps.LW = longword
	MOVF 0x043,W
	MOVWF 0x066
	MOVF 0x044,W
	MOVWF 0x067
; 989: eprom_pointer = eprom_pointer + 48
	MOVF 0x039,W
	ADDLW 0x30
	MOVWF 0x039
; 990: Read eprom_pointer, longword.LB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x043
; 991: longword.HB = 0
	CLRF 0x044
; 992: act_steps.HW = longword
	MOVF 0x043,W
	MOVWF 0x068
	MOVF 0x044,W
	MOVWF 0x069
; 993: EndSelect
L0302:
; 994: Select Case new_pos
; 995: Case 62, 63
	MOVF 0x05E,W
	SUBLW 0x3E
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0305
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0304
L0305:
	MOVF 0x05E,W
	SUBLW 0x3F
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0303
L0304:
; 996: new_steps = 0
	CLRF 0x052
	CLRF 0x053
	CLRF 0x054
	CLRF 0x055
; 997: Case Else
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0306
L0303:
; 998: eprom_pointer = new_pos
	MOVF 0x05E,W
	MOVWF 0x039
; 999: Read eprom_pointer, longword.LB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x043
; 1000: eprom_pointer = eprom_pointer + 48
	MOVF 0x039,W
	ADDLW 0x30
	MOVWF 0x039
; 1001: Read eprom_pointer, longword.HB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x044
; 1002: new_steps.LW = longword
	MOVF 0x043,W
	MOVWF 0x052
	MOVF 0x044,W
	MOVWF 0x053
; 1003: eprom_pointer = eprom_pointer + 48
	MOVF 0x039,W
	ADDLW 0x30
	MOVWF 0x039
; 1004: Read eprom_pointer, longword.LB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x043
; 1005: longword.HB = 0
	CLRF 0x044
; 1006: new_steps.HW = longword
	MOVF 0x043,W
	MOVWF 0x054
	MOVF 0x044,W
	MOVWF 0x055
; 1007: EndSelect
L0306:
; 1008: Return
	RETURN
; 1009: 
; 1010: 
; 1011: save_steps:
L0012:
; 1012: eprom_pointer = act_pos
	MOVF 0x042,W
	MOVWF 0x039
; 1013: longword = new_steps.LW
	MOVF 0x052,W
	MOVWF 0x043
	MOVF 0x053,W
	MOVWF 0x044
; 1014: Write eprom_pointer, longword.LB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x043,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BSF PCLATH,4
L0307:	BTFSC EECON1,WR
	GOTO L0307
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1015: eprom_pointer = eprom_pointer + 48
	MOVF 0x039,W
	ADDLW 0x30
	MOVWF 0x039
; 1016: Write eprom_pointer, longword.HB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x044,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BSF PCLATH,4
L0308:	BTFSC EECON1,WR
	GOTO L0308
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1017: longword = new_steps.HW
	MOVF 0x054,W
	MOVWF 0x043
	MOVF 0x055,W
	MOVWF 0x044
; 1018: eprom_pointer = eprom_pointer + 48
	MOVF 0x039,W
	ADDLW 0x30
	MOVWF 0x039
; 1019: Write eprom_pointer, longword.LB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x043,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BSF PCLATH,4
L0309:	BTFSC EECON1,WR
	GOTO L0309
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1020: Return
	RETURN
; 1021: 
; 1022: set_free_space:
L0013:
; 1023: eprom_pointer = mem_free_space
	MOVLW 0xD4
	MOVWF 0x039
; 1024: Write eprom_pointer, free_space_steps.LB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x048,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BSF PCLATH,4
L0310:	BTFSC EECON1,WR
	GOTO L0310
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1025: eprom_pointer = eprom_pointer + 1
	MOVF 0x039,W
	ADDLW 0x01
	MOVWF 0x039
; 1026: Write eprom_pointer, free_space_steps.HB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x049,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BSF PCLATH,4
L0311:	BTFSC EECON1,WR
	GOTO L0311
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1027: 
; 1028: Return
	RETURN
; 1029: 
; 1030: get_free_space:
L0014:
; 1031: eprom_pointer = mem_free_space
	MOVLW 0xD4
	MOVWF 0x039
; 1032: Read eprom_pointer, free_space_steps.LB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x048
; 1033: eprom_pointer = eprom_pointer + 1
	MOVF 0x039,W
	ADDLW 0x01
	MOVWF 0x039
; 1034: Read eprom_pointer, free_space_steps.HB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x049
; 1035: 
; 1036: Return
	RETURN
; 1037: 
; 1038: stop_the_motor:
L0015:
; 1039: ena = 0
	BCF PORTC,2
; 1040: value = act_pos
	MOVF 0x042,W
	MOVWF 0x038
; 1041: version = 0  'decimal point in display on
	BCF 0x05B,3
; 1042: While ecsw = 1
L0312:
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS 0x007,6
	GOTO L0313
; 1043: WaitMs 250
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL W001
; 1044: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 1045: version = Not version
	MOVLW 0x08
	XORWF 0x05B,F
; 1046: Wend
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0312
L0313:
; 1047: version = 1  'decimal point off
	BSF 0x05B,3
; 1048: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 1049: ena = 1  'set anable on
	BSF PORTC,2
; 1050: Return
	RETURN
; 1051: Proc wait_pos_match(delay_value As Byte)
L0016:
; 1052: value = 99
	MOVLW 0x63
	MOVWF 0x038
; 1053: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 1054: While delay_value > 0
L0314:
	MOVF 0x06C,W
	SUBLW 0x00
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0315
; 1055: WaitMs 100
	MOVLW 0x4E
	MOVWF R4L
	MOVLW 0xC3
	MOVWF R4H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL DL02
; 1056: delay_value = delay_value - 1
	MOVLW 0x01
	SUBWF 0x06C,W
	MOVWF 0x06C
; 1057: Wend
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0314
L0315:
; 1058: value = act_pos
	MOVF 0x042,W
	MOVWF 0x038
; 1059: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 1060: pos_match = 0  'indicate pos_match
	BCF PORTB,4
; 1061: End Proc
	RETURN
; 1062: 
; 1063: Proc delays(delay_value As Byte)
L0017:
; 1064: value = 100
	MOVLW 0x64
	MOVWF 0x038
; 1065: Gosub i2c_display
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0005
; 1066: While delay_value > 0
L0316:
	MOVF 0x05C,W
	SUBLW 0x00
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0317
; 1067: WaitMs 100
	MOVLW 0x4E
	MOVWF R4L
	MOVLW 0xC3
	MOVWF R4H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL DL02
; 1068: delay_value = delay_value - 1
	MOVLW 0x01
	SUBWF 0x05C,W
	MOVWF 0x05C
; 1069: Wend
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0316
L0317:
; 1070: 
; 1071: End Proc
	RETURN
; 1072: 
; 1073: store_one_round:
L0018:
; 1074: eprom_pointer = mem_one_round
	MOVLW 0xCE
	MOVWF 0x039
; 1075: longword = one_round.LW
	MOVF 0x056,W
	MOVWF 0x043
	MOVF 0x057,W
	MOVWF 0x044
; 1076: Write eprom_pointer, longword.LB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x043,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BSF PCLATH,4
L0318:	BTFSC EECON1,WR
	GOTO L0318
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1077: eprom_pointer = eprom_pointer + 1
	MOVF 0x039,W
	ADDLW 0x01
	MOVWF 0x039
; 1078: Write eprom_pointer, longword.HB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x044,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BSF PCLATH,4
L0319:	BTFSC EECON1,WR
	GOTO L0319
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1079: longword = one_round.HW
	MOVF 0x058,W
	MOVWF 0x043
	MOVF 0x059,W
	MOVWF 0x044
; 1080: eprom_pointer = eprom_pointer + 1
	MOVF 0x039,W
	ADDLW 0x01
	MOVWF 0x039
; 1081: Write eprom_pointer, longword.LB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x043,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
	BSF PCLATH,4
L0320:	BTFSC EECON1,WR
	GOTO L0320
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1082: one_round_half = one_round / 2
	MOVF 0x056,W
	MOVWF R0L
	MOVF 0x057,W
	MOVWF R0H
	MOVF 0x058,W
	MOVWF R1L
	MOVF 0x059,W
	MOVWF R1H
	MOVLW 0x02
	MOVWF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LD01
	MOVF LONG_0,W
	MOVWF 0x079
	MOVF LONG_1,W
	MOVWF 0x07A
	MOVF LONG_2,W
	MOVWF 0x07B
	MOVF LONG_3,W
	MOVWF 0x07C
; 1083: Return
	RETURN
; 1084: 
; 1085: get_one_round:
L0019:
; 1086: eprom_pointer = mem_one_round
	MOVLW 0xCE
	MOVWF 0x039
; 1087: Read eprom_pointer, longword.LB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x043
; 1088: eprom_pointer = eprom_pointer + 1
	MOVF 0x039,W
	ADDLW 0x01
	MOVWF 0x039
; 1089: Read eprom_pointer, longword.HB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x044
; 1090: one_round.LW = longword
	MOVF 0x043,W
	MOVWF 0x056
	MOVF 0x044,W
	MOVWF 0x057
; 1091: eprom_pointer = eprom_pointer + 1
	MOVF 0x039,W
	ADDLW 0x01
	MOVWF 0x039
; 1092: Read eprom_pointer, longword.LB
	MOVF 0x039,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x043
; 1093: longword.HB = 0
	CLRF 0x044
; 1094: one_round.HW = longword
	MOVF 0x043,W
	MOVWF 0x058
	MOVF 0x044,W
	MOVWF 0x059
; 1095: Return
	RETURN
; 1096: 
; 1097: Proc run_to_zero(speed As Word, calc As Bit)
L0020:
; 1098: While steps > 0  'NOW RUN UNTIL STEPS = 0
L0321:
	MOVF 0x03A,W
	MOVWF R0L
	MOVF 0x03B,W
	MOVWF R0H
	MOVF 0x03C,W
	MOVWF R1L
	MOVF 0x03D,W
	MOVWF R1H
	CLRF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL CL03
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0322
; 1099: If calc = 1 Then
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS 0x05B,7
	GOTO L0323
; 1100: Gosub speed_calc
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0009
; 1101: Endif
L0323:
; 1102: 
; 1103: clk = 1  'clock out
	BSF PORTC,1
; 1104: WaitUs speed
	MOVF 0x073,W
	MOVWF R4L
	MOVF 0x074,W
	MOVWF R4H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL Y001
; 1105: clk = 0
	BCF PORTC,1
; 1106: 'WaitUs speed
; 1107: Gosub speed_calc
	BSF PCLATH,3
	BCF PCLATH,4
	CALL L0009
; 1108: steps = steps - 1
	MOVF 0x03A,W
	MOVWF R0L
	MOVF 0x03B,W
	MOVWF R0H
	MOVF 0x03C,W
	MOVWF R1L
	MOVF 0x03D,W
	MOVWF R1H
	MOVLW 0x01
	MOVWF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LS01
	MOVF R0L,W
	MOVWF 0x03A
	MOVF R0H,W
	MOVWF 0x03B
	MOVF R1L,W
	MOVWF 0x03C
	MOVF R1H,W
	MOVWF 0x03D
; 1109: Wend
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0321
L0322:
; 1110: 
; 1111: End Proc
	RETURN
; 1112: Proc run_to_zero_switch(bitposition As Bit, counting As Bit)
L0021:
; 1113: If counting = 1 Then
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS 0x06D,0
	GOTO L0324
; 1114: While zero = bitposition  'NOW RUN UNTIL switch is activated
L0325:
	CLRW
	BTFSC 0x006,6
	ADDLW 0x01
	BTFSC 0x05B,6
	SUBLW 0x01
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0326
; 1115: clk = 1  'clock out
	BSF PORTC,1
; 1116: WaitUs speed_min
	MOVF 0x040,W
	MOVWF R4L
	MOVF 0x041,W
	MOVWF R4H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL Y001
; 1117: clk = 0
	BCF PORTC,1
; 1118: steps = steps - 1
	MOVF 0x03A,W
	MOVWF R0L
	MOVF 0x03B,W
	MOVWF R0H
	MOVF 0x03C,W
	MOVWF R1L
	MOVF 0x03D,W
	MOVWF R1H
	MOVLW 0x01
	MOVWF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LS01
	MOVF R0L,W
	MOVWF 0x03A
	MOVF R0H,W
	MOVWF 0x03B
	MOVF R1L,W
	MOVWF 0x03C
	MOVF R1H,W
	MOVWF 0x03D
; 1119: one_round = one_round + 1
	MOVF 0x056,W
	MOVWF R0L
	MOVF 0x057,W
	MOVWF R0H
	MOVF 0x058,W
	MOVWF R1L
	MOVF 0x059,W
	MOVWF R1H
	MOVLW 0x01
	MOVWF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LA01
	MOVF R0L,W
	MOVWF 0x056
	MOVF R0H,W
	MOVWF 0x057
	MOVF R1L,W
	MOVWF 0x058
	MOVF R1H,W
	MOVWF 0x059
; 1120: Wend
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0325
L0326:
; 1121: Else
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0327
L0324:
; 1122: While zero = bitposition  'NOW RUN UNTIL switch is activated
L0328:
	CLRW
	BTFSC 0x006,6
	ADDLW 0x01
	BTFSC 0x05B,6
	SUBLW 0x01
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0329
; 1123: clk = 1  'clock out
	BSF PORTC,1
; 1124: WaitUs speed_min
	MOVF 0x040,W
	MOVWF R4L
	MOVF 0x041,W
	MOVWF R4H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL Y001
; 1125: clk = 0
	BCF PORTC,1
; 1126: steps = steps - 1
	MOVF 0x03A,W
	MOVWF R0L
	MOVF 0x03B,W
	MOVWF R0H
	MOVF 0x03C,W
	MOVWF R1L
	MOVF 0x03D,W
	MOVWF R1H
	MOVLW 0x01
	MOVWF R2L
	CLRF R2H
	CLRF R3L
	CLRF R3H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL LS01
	MOVF R0L,W
	MOVWF 0x03A
	MOVF R0H,W
	MOVWF 0x03B
	MOVF R1L,W
	MOVWF 0x03C
	MOVF R1H,W
	MOVWF 0x03D
; 1127: Wend
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0328
L0329:
; 1128: Endif
L0327:
; 1129: End Proc
	RETURN
; 1130: 
; 1131: Proc relays(onoff As Bit)
L0022:
; 1132: If act_pos < bridge_rev_pos Or bridge_rev_pos = 0 Then  'just normal Bridge power (if allowed)
	MOVF 0x04F,W
	SUBWF 0x042,W
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0332
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0331
L0332:
	MOVF 0x04F,W
	SUBLW 0x00
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSS STATUS,Z
	GOTO L0330
L0331:
; 1133: swfw = 0
	BCF PORTB,0
; 1134: WaitMs 100  'just wait for the relay to drop
	MOVLW 0x4E
	MOVWF R4L
	MOVLW 0xC3
	MOVWF R4H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL DL02
; 1135: If onoff = 0 Then
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC 0x05B,4
	GOTO L0333
; 1136: swrev = bridge_power.0
	BCF PORTB,1
	BTFSC 0x061,0
	BSF PORTB,1
; 1137: Else
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0334
L0333:
; 1138: swrev = 1
	BSF PORTB,1
; 1139: Endif
L0334:
; 1140: Else  'inverse bridge power (if allowed)
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0335
L0330:
; 1141: swrev = 0
	BCF PORTB,1
; 1142: WaitMs 100  'just wait for the relay to drop
	MOVLW 0x4E
	MOVWF R4L
	MOVLW 0xC3
	MOVWF R4H
	BCF PCLATH,3
	BCF PCLATH,4
	CALL DL02
; 1143: If onoff = 0 Then
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC 0x05B,4
	GOTO L0336
; 1144: swfw = bridge_power.0
	BCF PORTB,0
	BTFSC 0x061,0
	BSF PORTB,0
; 1145: Else
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0337
L0336:
; 1146: swfw = 1
	BSF PORTB,0
; 1147: Endif
L0337:
; 1148: Endif
L0335:
; 1149: End Proc
	RETURN
; 1150: Proc check_encoder_count()
L0023:
; 1151: If encoder_count < 6 Then
	MOVLW 0x06
	SUBWF 0x05A,W
	BCF PCLATH,3
	BSF PCLATH,4
	BTFSC STATUS,C
	GOTO L0338
; 1152: encoder_count = encoder_count + 1
	MOVF 0x05A,W
	ADDLW 0x01
	MOVWF 0x05A
; 1153: proceed = 0
	BCF 0x05B,0
; 1154: Else
	BCF PCLATH,3
	BSF PCLATH,4
	GOTO L0339
L0338:
; 1155: encoder_count = 0
	CLRF 0x05A
; 1156: proceed = 1
	BSF 0x05B,0
; 1157: Endif
L0339:
; 1158: End Proc
	RETURN
; 1159: 
; End of user code
	BCF PCLATH,3
	BSF PCLATH,4
L0340:	GOTO L0340
;
;
; Configuration settings
	ORG 0x2007
	DW 0x23E2
	DW 0x3EFF
; End of listing
	END
