#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>

#define DEFAULT_ADDR  0x300
void main(int argc, char * argv[])
{
     int  IoAdr=DEFAULT_ADDR;
     int  StartWork=0;
     int  TriggerHiLow=0;
     int  WaveHiLow=0;
     int  GetValue=0;
     int  CodeValue=0;
     int  CodeCount=0;

     if ( argc >= 2 ) {
	 if ( argc == 2 ) {
	     switch ( atoi(argv[1]) ) {
             case 1: IoAdr=0x1B0; break;
	     case 2: IoAdr=0x1B8; break;
	     case 3: IoAdr=0x300; break;
	     case 4: IoAdr=0x360; break;
	     default: argc = 3; break;
	     }
	 }
	 if ( argc > 2 ) {
	     printf("Usage CodeGet [1=0x1B0, 2=0x1B8, 3=0x300, 4=0x360]\n");
	     exit(1);
	 }
     }
     printf("Start Get 8255 date from port %X\n", IoAdr);
     // Initial 8255 as input port ( default is also this mode )
     // PA0 is signal under test
     // PA1 is square wave ( 100K Hz )
     // PA2 is trigger for signal under test ( pulse per 200us )
     outportb(IoAdr+3, 0x9B);
     printf("Press G to start/reset the wave counting, Q to stop\n");
     // while loop to count wave
     while (1) {
	 if ( kbhit() ) {
	     switch( (getch()) ) {
	     case 'Q' :
	     case 'q' : exit(0);
			break;
	     case 'G' :
	     case 'g' : StartWork = 1;
			break;
	     }
	 }
	 if ( StartWork ) {
	     GetValue = inportb(IoAdr)&0x07;
	     if ( TriggerHiLow == 0 ) {
		 // In this period, we have to wait trigger to high
		 if ( GetValue & 0x04 ) {
		     TriggerHiLow = 1;
		     CodeValue=0; CodeCount=0;
		 }
	     } else {
		 // Here we start to count 10 wave clock ( 10us * 10 )
		 if ( WaveHiLow & 0x02 != GetValue & 0x02 ) {
		     // Square Wave change state
		     WaveHiLow = GetValue & 0x02;
		     if ( WaveHiLow != 0 ) {
			 CodeValue = CodeValue*2 + (GetValue&0x01);
			 CodeCount++;
			 if ( CodeCount >= 10 ) {
			     // Here We Get the value
			     printf("Get Code Value=%X\n", CodeValue);
			     CodeValue=0;
			     CodeCount=0;
			     TriggerHiLow=0;
			 }
		     }
		 }

	     }
	 }
    }
}