/*  This is the QC program for 8255/8253 I/O CARD

    Auther : Johnny Tseng
    Date : 1999/10/02   */

#include <dos.h>
#include <stdio.h>
#include <conio.h>

/* set default value for ioport, CNTR */
unsigned int ioport = 0;

void test8255loopback (void)
{
  int loop, i, c, step = 0;
  unsigned char x1, x2, x3, y1, y2, y3, z1, z2, z3;
  unsigned long x;
  unsigned long y;
  unsigned duration = 64;

  if (!ioport)
    return;

  gotoxy (10, 16);
  outportb (ioport + 3, 0x80);
  outportb (ioport + 7, 0x9b);

  for (loop = 0; loop < 100; loop ++) {
    for (i = 0; i < 24; i++) {
      x = (unsigned long)1 << i;
      x1 = x & 0x00ff;
      x2 = (x >> 8) & 0x00ff;
      x3 = (x >> 16) & 0x00ff;
      y = 0x00800000 >> i;
      y1 = y & 0x00ff;
      y2 = y >> 8;
      y3 = y >> 16;
      outportb (ioport, x1);
      outportb (ioport + 1, x2);
      outportb (ioport + 2, x3);
      delay (duration);
      z1 = inportb (ioport + 4);
      z2 = inportb (ioport + 5);
      z3 = inportb (ioport + 6);
      gotoxy (3, 16);
      cprintf("Loop: %3d  Testing Pin:%2d  Output: %02X%02X%02X  Input:%02X%02X%02X  Correct:%02X%02X%02X",
	       loop + 1, i, x3, x2, x1, z3, z2, z1, y3, y2, y1);
      if (z1 != y1 || z2 != y2 || z3 != y3) {
	cputs (" Error ");
	c = getch ();
	if (c == 27)
	  break;
      }
      else {
	cputs ("  OK   ");
	//c = getch ();
      }
      if (kbhit () || step) {
	c = getch ();
	if (c == 27)
	  break;
	else if (c == ' ')
	  step = !step;
	else if (c == '+') {
	  if (duration > 1)
	    duration >>= 1;
	}
	else if (c == '-') {
	  if (duration < 512)
	    duration <<= 1;
	}
	else if (!step)
	  getch ();
      }
    }
    if (c == 27)
      break;
  }
  gotoxy (3, 17);
  cputs("Press any key when ready");
  if (kbhit ())
    getch();
}

void dumpbits (unsigned long x)
{
  int i;

  for (i = 0; i < 24; i++) {
    putch (((0x00800000 >> i) & x)? '1' : '0');
  }
}

void test8255output (void)
{
  unsigned long x, loop = 0L;
  int i, flag, iop, step = 0;
  unsigned char x1, x2, x3, c = 0;
  unsigned duration = 64;

  outportb (ioport + 3, 0x80);
  outportb (ioport + 7, 0x80);
  outportb (ioport, 0);
  outportb (ioport + 1, 0);
  outportb (ioport + 2, 0);
  outportb (ioport + 4, 0);
  outportb (ioport + 5, 0);
  outportb (ioport + 6, 0);
  for (flag = 0;;flag = !flag) {
    outportb (iop, 0);
    outportb (iop + 1, 0);
    outportb (iop + 2, 0);
    if (flag) {
      iop = ioport + 4;
    } else {
      iop = ioport;
    }
    for (i = 0, x = (unsigned long)1; i < 24; i++, x <<= 1, loop++) {
      x1 = x & 0x00ff;
      x2 = (x >> 8) & 0x00ff;
      x3 = (x >> 16) & 0x00ff;
      outportb (iop, x1);
      outportb (iop + 1, x2);
      outportb (iop + 2, x3);
      gotoxy (3, 16);
      cprintf("Loop: %8ld : ", loop);
      if (flag) {
	dumpbits (x);
	dumpbits (0);
      } else {
	dumpbits (0);
	dumpbits (x);
      }
      delay (duration);
      if (kbhit () || step) {
	c = getch ();
	if (c == 27)
	  break;
	else if (c == ' ')
	  step = !step;
	else if (c == '+') {
	  if (duration > 1)
	    duration >>= 1;
	}
	else if (c == '-') {
	  if (duration < 512)
	    duration <<= 1;
	}
	else if (!step)
	  getch ();
      }
    } // for (i)
    if (c == 27)
      break;
  } // for (flag)
  if (kbhit ())
    getch ();
}

void test8255input (void)
{
  unsigned long x, y, loop = 0L;
  unsigned char c;

  outportb (ioport + 3, 0x9b);
  outportb (ioport + 7, 0x9b);
  for (loop = 0;;loop++) {
    x = inportb (ioport + 2);
    x = (x << 8) | inportb (ioport + 1);
    x = (x << 8) | inportb (ioport);
    y = inportb (ioport + 6);
    y = (y << 8) | inportb (ioport + 5);
    y = (y << 8) | inportb (ioport + 4);
    gotoxy (3, 16);
    cprintf("Loop: %8ld : ", loop);
    dumpbits (y);
    dumpbits (x);
    if (kbhit ()) {
      c = getch ();
      if (c == 27)
	break;
    } // for (i)
  } // for (flag)
  if (kbhit ())
    getch ();
}

void test8253 (void)
{
  unsigned long loop = 0L;
  unsigned duration = 4;
  int step = 0;
  int i, j;
  unsigned char c;

  outportb (ioport + 3, 0x9b); //All input
  outportb (ioport + 7, 0x89); //Port A, B output and Port C input

  outportb (ioport + 11, 0x36); //Counter 0: Mode 3, LSB + MSB
  outportb (ioport + 8, 10);
  outportb (ioport + 8, 0);

  outportb (ioport + 11, 0x76); //Counter 1: Mode 3, LSB + MSB
  outportb (ioport + 9, 10);
  outportb (ioport + 9, 0);

  outportb (ioport + 11, 0xb6); //Counter 2: Mode 3, LSB + MSB
  outportb (ioport + 10, 10);
  outportb (ioport + 10, 0);

//  outportb (ioport + 5, 0x2a);
  gotoxy (3, 17);
  cprintf ("Please use probe to check if OUT0, OUT1, and OUT2 are blinking.");

  for (loop = 0;;loop++) {
    for (i = 0; i < 10; i++) {
      outportb (ioport + 5, 0x2a);
      for (j = 0; j <10; j++);
      outportb (ioport + 5, 0x3f);
      for (j = 0; j <10; j++);
    }
    gotoxy (3, 16);
    cprintf("Loop: %8ld : ", loop);
    delay (duration);
    if (kbhit () || step) {
      c = getch ();
      if (c == 27)
	break;
      else if (c == ' ')
	step = !step;
      else if (c == '+') {
	if (duration > 1)
	  duration >>= 1;
      }
      else if (c == '-') {
	if (duration < 512)
	  duration <<= 1;
      }
      else if (!step)
	getch ();
    } //if
    if (c == 27)
      break;
  } // for (flag)
  if (kbhit ())
    getch ();
}

void main()
{
  int r;
  int flag = 1;
  char ch;
  ioport = 0x1b0;

  while (flag) {
    clrscr();
    cputs ("\n\n\n\r");
    cputs ("                     8255/8253 I/O CARD Q.C. Program V1.2\n\r");
    cputs ("                     ====================================\n\r");
    cputs ("\n\r");
    cprintf ("                     I/O Address: %04X\n\r", ioport);
    cputs ("\n\r");
    cputs ("                     (0): Change I/O setting\n\r");
    cputs ("                     (1): 8255 Loopback test\n\r");
    cputs ("                     (2): Output Test\n\r");
    cputs ("                     (3): Input Test\n\r");
    cputs ("                     (4): Counter Test (8253)\n\r");
    cputs ("                     ESC: EXIT\n\r");
    cputs ("                     Choose:");
    do {
      ch = getch();
    } while (ch != '0' && ch != '1' && ch != '2' && ch != '3' && ch != '4' && ch != 27);

    switch (ch) {
      case 27:
	flag = 0;
	break;
      case '0':
	if (ioport == 0x1b0)
	  ioport = 0x300;
	else if (ioport == 0x300)
	  ioport = 0x360;
	else if (ioport == 0x360)
	  ioport = 0x1b8;
	else
	  ioport = 0x1b0;
	break;
      case '1':
	test8255loopback ();
	break;
      case '2':
	test8255output ();
	break;
      case '3':
	test8255input ();
	break;
      case '4':
	test8253 ();
	break;
    }
  }
} /* end of main */
