; Compiled with: PIC Simulator IDE v6.92
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_act_pos' (global) is 127
;       The value of 'mem_turn_counter' (global) is 101
;       The value of 'mem_speed_min' (global) is 103
;       The value of 'mem_speed_max' (global) is 104
;       The value of 'mem_speed_step' (global) is 105
;       The value of 'mem_one_round_lb' (global) is 106
;       The value of 'mem_one_round_hb' (global) is 107
;       The value of 'mem_ctrl_type' (global) is 108
;       The value of 'mem_max_pos' (global) is 109
;       The value of 'mem_free_space' (global) is 110
;       The value of 'mem_rev_pos' (global) is 111
;       The value of 'mem_bridge_power' (global) is 112
;       The value of 'mem_pos_match_delay' (global) is 113
;       The value of 'mem_bridge_rev_pos' (global) is 114
;       The address of 'steps' (word) (global) is 0x30
	steps EQU 0x30
;       The address of 'speed_min' (word) (global) is 0x32
	speed_min EQU 0x32
;       The address of 'act_pos' (byte) (global) is 0x34
	act_pos EQU 0x34
;       The address of 'value' (byte) (global) is 0x35
	value EQU 0x35
;       The address of 'speed_max' (word) (global) is 0x36
	speed_max EQU 0x36
;       The address of 'manual_pos' (byte) (global) is 0x38
	manual_pos EQU 0x38
;       The address of 'result' (byte) (global) is 0x39
	result EQU 0x39
;       The address of 'one_round' (word) (global) is 0x3A
	one_round EQU 0x3A
;       The address of 'max_pos' (byte) (global) is 0x3C
	max_pos EQU 0x3C
;       The address of 'free_space_steps' (byte) (global) is 0x3D
	free_space_steps EQU 0x3D
;       The address of 'ctrl_type' (byte) (global) is 0x3E
	ctrl_type EQU 0x3E
;       The address of 'new_steps' (word) (global) is 0x3F
	new_steps EQU 0x3F
;       The address of 'pos_match_delay' (byte) (global) is 0x41
	pos_match_delay EQU 0x41
;       The address of 'bridge_rev_pos' (byte) (global) is 0x42
	bridge_rev_pos EQU 0x42
;       The address of 'program_set' (byte) (global) is 0x43
	program_set EQU 0x43
;       The address of 'speed_step' (byte) (global) is 0x44
	speed_step EQU 0x44
;       The address of 'encoder_count' (byte) (global) is 0x45
	encoder_count EQU 0x45
;       The address of 'new_pos' (byte) (global) is 0x46
	new_pos EQU 0x46
;       The address of 'eprom_pointer' (byte) (global) is 0x47
	eprom_pointer EQU 0x47
;       The address of 'proceed' (bit) (global) is 0x48,0
;       The address of 'bridge_power' (byte) (global) is 0x49
	bridge_power EQU 0x49
;       The address of 'speed' (word) (global) is 0x4A
	speed EQU 0x4A
;       The address of 'disp1_val' (byte) (global) is 0x4C
	disp1_val EQU 0x4C
;       The address of 'new_encoder' (byte) (global) is 0x4D
	new_encoder EQU 0x4D
;       The address of 'steps_set' (bit) (global) is 0x48,1
;       The address of 'turn_counter' (byte) (global) is 0x4E
	turn_counter EQU 0x4E
;       The address of 'onoff' (bit) (relays) is 0x48,2
;       The address of 'act_steps' (word) (global) is 0x4F
	act_steps EQU 0x4F
;       The address of 'bus_pos' (byte) (global) is 0x51
	bus_pos EQU 0x51
;       The address of 'disp2_val' (byte) (global) is 0x52
	disp2_val EQU 0x52
;       The address of 'version' (bit) (global) is 0x48,3
;       The address of 'bitposition' (bit) (run_to_zero_switch) is 0x48,4
;       The address of 'ramp_up' (bit) (global) is 0x48,5
;       The address of 'speed' (word) (run_to_zero) is 0x53
;       The address of 'calc' (bit) (run_to_zero) is 0x48,6
;       The address of 'counting' (bit) (run_to_zero_switch) is 0x48,7
;       The address of 'ramp_down_point' (word) (global) is 0x55
	ramp_down_point EQU 0x55
;       The address of 'one_round_half' (word) (global) is 0x57
	one_round_half EQU 0x57
;       The address of 'old_encoder' (byte) (global) is 0x59
	old_encoder EQU 0x59
;       The address of 'old_manual_pos' (byte) (global) is 0x5A
	old_manual_pos EQU 0x5A
;       The address of 'old_pos_write' (bit) (global) is 0x5B,0
;       The address of 'half_steps' (word) (global) is 0x5C
	half_steps EQU 0x5C
;       The address of 'old_bus_pos' (byte) (global) is 0x5E
	old_bus_pos EQU 0x5E
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x6,6
;       The address of 'max_end' (bit) (global) is 0x6,7
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
;       The address of 'adjust_en' (bit) (global) is 0x7,3
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0019
	ORG 0x0004
	RETFIE
; LookUp Table: (3, 2, 1, 3)
_lookup_lab_0001:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
; LookUp Table: (1, 3, 3, 2)
_lookup_lab_0002:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
; LookUp Table: (2, 3, 3, 1)
_lookup_lab_0003:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
; LookUp Table: (3, 1, 2, 3)
_lookup_lab_0004:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0005:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; LookUp Table: (%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111)
_lookup_lab_0006:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0007:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0019:
; 1: 
; 2: 
; 3: Define CONF_WORD = 0x3f72
; 4: 
; 5: 'program TT for PCBoard GCA145 / MGV145
; 6: 'Universal version 7.2
; 7: 'For sliding systems (FY) extra end switch is used.
; 8: 'RB7 on ICSP1 (pin3) is endswitch (pass last rail)
; 9: 'J4 is used as zero switch (pass first rail)
; 10: 'EEP1 jumper is used to enable pos 61 and 62
; 11: 
; 12: 'three extra position are possible:
; 13: '-  position 63 to go to zero switch and then to rail 1
; 14: '-  Position 62 to manually set all positions first time (Manual initialisation, only when eep1 is set)
; 15: 'programs :
; 16: '0  correction actual position
; 17: '1  Max positions
; 18: '2  min speed
; 19: '3  max speed
; 20: '4  incr/decr delay
; 21: '5  extra correction steps
; 22: '6  bridge power normal/ reversed (Pos) at this position and all higher ones, bridge power is reversed
; 23: '7  Bridge power on/off (1/0) while moving
; 24: '8  pos_match delay
; 25: '9  setting of control type (0..6)
; 26: '-  control types:
; 27: '-    1 |control is set For turntable NO 'shortest way option' means that running from highest to lowest position (or v.v.) will NOT pass 0 position.|
; 28: '-    2 |control is set For turntable with  'shortest way option' which means that running from one to next position (or v.v.) could pass 0 position.|
; 29: '-    3 |version for two rail tt, no restriction on 'short way'. This is special for TT with contact rings  (no cables).|
; 30: '-    4 |fiddle yard.railpower. End switch at the High position side is needed.|
; 31: 
; 32: '-      for control type see manual
; 33: '- V7-2  2 apr 2013  Delay after position set activated.
; 34: Dim steps As Word
; 35: Dim half_steps As Word
; 36: Dim ramp_down_point As Word
; 37: Dim program_set As Byte
; 38: Dim new_steps As Word
; 39: Dim act_steps As Word
; 40: Dim new_pos As Byte
; 41: Dim act_pos As Byte
; 42: Dim one_round As Word
; 43: Dim one_round_half As Word
; 44: Dim bus_pos As Byte
; 45: Dim old_bus_pos As Byte
; 46: Dim speed As Word
; 47: Dim speed_min As Word
; 48: Dim speed_max As Word
; 49: Dim new_encoder As Byte
; 50: Dim old_encoder As Byte
; 51: Dim manual_pos As Byte
; 52: Dim old_manual_pos As Byte
; 53: Dim result As Byte
; 54: Dim free_space_steps As Byte
; 55: Dim value As Byte
; 56: Dim eprom_pointer As Byte
; 57: Dim encoder_count As Byte
; 58: 'Dim onoff As Bit
; 59: Dim max_pos As Byte
; 60: Dim disp1_val As Byte
; 61: Dim disp2_val As Byte
; 62: Dim old_pos_write As Bit
; 63: Dim ramp_up As Bit
; 64: Dim speed_step As Byte
; 65: Dim version As Bit
; 66: Dim steps_set As Bit
; 67: Dim bridge_power As Byte
; 68: Dim pos_match_delay As Byte
; 69: Dim bridge_rev_pos As Byte
; 70: Dim ctrl_type As Byte
; 71: Dim turn_counter As Byte
; 72: Dim proceed As Bit
; 73: Const disp1 = 64
; 74: Const disp2 = 66
; 75: Const mem_act_pos = 127
; 76: Const mem_turn_counter = 101
; 77: Const mem_speed_min = 103
; 78: Const mem_speed_max = 104
; 79: Const mem_speed_step = 105
; 80: Const mem_one_round_lb = 106
; 81: Const mem_one_round_hb = 107
; 82: Const mem_ctrl_type = 108
; 83: Const mem_max_pos = 109
; 84: Const mem_free_space = 110
; 85: Const mem_rev_pos = 111
; 86: Const mem_bridge_power = 112
; 87: Const mem_pos_match_delay = 113
; 88: Const mem_bridge_rev_pos = 114
; 89: Symbol swfw = RB0
; 90: Symbol swrev = RB1
; 91: Symbol sck = RB2
; 92: Symbol sda = RB3
; 93: Symbol pos_match = RB4
; 94: Symbol pos_write = RB5
; 95: Symbol direction = RC0
; 96: Symbol clk = RC1
; 97: Symbol ena = RC2
; 98: Symbol zero = RB6
; 99: Symbol max_end = RB7
; 100: Symbol ec1 = RC4
; 101: Symbol ec2 = RC5
; 102: Symbol ecsw = RC6
; 103: Symbol pgm = RC7
; 104: Symbol adjust_en = RC3
; 105: 
; 106: ADCON1 = %0110
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 107: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 108: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 109: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 110: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 111: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 112: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 113: Gosub init_values
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0010
; 114: Call relays(1)
	BSF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 115: program_set = 0
	CLRF 0x43
; 116: max_end = 1
	BSF 0x06,7
; 117: 
; 118: main:
L0001:
; 119: 	If pgm = 0 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0020
; 120: 		Gosub adjust_settings
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0004
; 121: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 122: 	Endif
L0020:
; 123: 
; 124: 	Gosub get_new_position
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0002
; 125: 	If bus_pos <> old_bus_pos Then
	MOVF 0x51,W
	SUBWF 0x5E,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0021
; 126: 		Call relays(0)
	BCF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 127: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 128: 		steps = pos_match_delay * 100
	MOVF 0x41,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x30
	MOVF R2H,W
	MOVWF 0x31
; 129: 		WaitMs steps
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 130: 		new_pos = bus_pos
	MOVF 0x51,W
	MOVWF 0x46
; 131: 		Gosub stepmotor
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0007
; 132: 		Gosub wait_pos_match
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 133: 		Call relays(1)
	BSF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 134: 'onoff = 1
; 135: 'Gosub relays
; 136: 		Gosub wait_pos_match
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 137: 	Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0022
L0021:
; 138: 		If ecsw = 0 Then  'only when knob is pushed
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0023
; 139: 			If manual_pos <> old_manual_pos Then
	MOVF 0x38,W
	SUBWF 0x5A,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0024
; 140: 				Call relays(0)
	BCF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 141: 				pos_match = 1  'indicate not in position
	BSF 0x06,4
; 142: 				steps = pos_match_delay * 100
	MOVF 0x41,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x30
	MOVF R2H,W
	MOVWF 0x31
; 143: 				WaitMs steps
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 144: 				old_manual_pos = manual_pos
	MOVF 0x38,W
	MOVWF 0x5A
; 145: 				new_pos = manual_pos
	MOVF 0x38,W
	MOVWF 0x46
; 146: 				Gosub stepmotor
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0007
; 147: 				Gosub wait_pos_match
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 148: 				Call relays(1)
	BSF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 149: 			Endif
L0024:
; 150: 		Endif
L0023:
; 151: 	Endif
L0022:
; 152: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 153: 	Goto main
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0001
; 154: End
;       PAGE SELECT
	BCF PCLATH,3
L0025:	GOTO L0025
; 155: 
; 156: get_new_position:
L0002:
; 157: 	value = bus_pos  'remember the position
	MOVF 0x51,W
	MOVWF 0x35
; 158: 	If pos_write = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,5
	GOTO L0026
; 159: 		If old_pos_write = 0 Then  'react once on rising edge
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x5B,0
	GOTO L0027
; 160: 			old_pos_write = 1
	BSF 0x5B,0
; 161: 			value = PORTA And 63  'now get value from J5
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x35
; 162: 			Select Case value
; 163: 			Case 63  'position reset is desired
	MOVF 0x35,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0028
; 164: 				value = 63
	MOVLW 0x3F
	MOVWF 0x35
; 165: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0029
L0028:
; 166: 				If value > max_pos Then  'this is not allowed
	MOVF 0x35,W
	SUBWF 0x3C,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0030
; 167: 					value = bus_pos  'put it back to old situation
	MOVF 0x51,W
	MOVWF 0x35
; 168: 				Endif
L0030:
; 169: 			EndSelect
L0029:
; 170: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 171: 			If value = bus_pos Then  'no other position is set, just a response on pos_write is required
	MOVF 0x35,W
	SUBWF 0x51,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0031
; 172: 				pos_match = 1
	BSF 0x06,4
; 173: 				WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 174: 				pos_match = 0
	BCF 0x06,4
; 175: 			Endif
L0031:
; 176: 		Endif
L0027:
; 177: 	Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0032
L0026:
; 178: 		old_pos_write = 0
	BCF 0x5B,0
; 179: 	Endif
L0032:
; 180: 	bus_pos = value  'now take over the desired position
	MOVF 0x35,W
	MOVWF 0x51
; 181: 	Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 182: 	Select Case result
; 183: 	Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0033
; 184: 		If encoder_count < 6 Then
	MOVLW 0x06
	SUBWF 0x45,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0034
; 185: 			encoder_count = encoder_count + 1
	MOVF 0x45,W
	ADDLW 0x01
	MOVWF 0x45
; 186: 		Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0035
L0034:
; 187: 			encoder_count = 0
	CLRF 0x45
; 188: 			Select Case manual_pos
; 189: 			Case < max_pos
	MOVF 0x3C,W
	SUBWF 0x38,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0036
; 190: 				manual_pos = manual_pos + 1
	MOVF 0x38,W
	ADDLW 0x01
	MOVWF 0x38
; 191: 			Case max_pos
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0037
L0036:
	MOVF 0x38,W
	SUBWF 0x3C,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0038
; 192: 				If adjust_en = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0039
; 193: 					manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x38
; 194: 				Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0040
L0039:
; 195: 					manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x38
; 196: 				Endif
L0040:
; 197: 			Case 63
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0041
L0038:
	MOVF 0x38,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0042
; 198: 				manual_pos = 1
	MOVLW 0x01
	MOVWF 0x38
; 199: 			Case 62
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0043
L0042:
	MOVF 0x38,W
	SUBLW 0x3E
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0044
; 200: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x38
; 201: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0045
L0044:
; 202: 			EndSelect
L0045:
L0043:
L0041:
L0037:
; 203: 			value = manual_pos
	MOVF 0x38,W
	MOVWF 0x35
; 204: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 205: 		Endif
L0035:
; 206: 	Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0046
L0033:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0047
; 207: 		If encoder_count > 0 Then
	MOVF 0x45,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0048
; 208: 			encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x45,W
	MOVWF 0x45
; 209: 		Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0049
L0048:
; 210: 			encoder_count = 6
	MOVLW 0x06
	MOVWF 0x45
; 211: 			Select Case manual_pos
; 212: 			Case 62
	MOVF 0x38,W
	SUBLW 0x3E
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0050
; 213: 				manual_pos = max_pos
	MOVF 0x3C,W
	MOVWF 0x38
; 214: 			Case 63
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0051
L0050:
	MOVF 0x38,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0052
; 215: 				If adjust_en = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0053
; 216: 					manual_pos = max_pos
	MOVF 0x3C,W
	MOVWF 0x38
; 217: 				Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0054
L0053:
; 218: 					manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x38
; 219: 				Endif
L0054:
; 220: 			Case 1
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0055
L0052:
	MOVF 0x38,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0056
; 221: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x38
; 222: 			Case 0
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0057
L0056:
	MOVF 0x38,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0058
; 223: 				manual_pos = 1
	MOVLW 0x01
	MOVWF 0x38
; 224: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0059
L0058:
; 225: 				manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x38,W
	MOVWF 0x38
; 226: 			EndSelect
L0059:
L0057:
L0055:
L0051:
; 227: 			value = manual_pos
	MOVF 0x38,W
	MOVWF 0x35
; 228: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 229: 		Endif
L0049:
; 230: 	Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0060
L0047:
; 231: 	EndSelect
L0060:
L0046:
; 232: 	WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 233: 	
; 234: Return
	RETURN
; 235: 
; 236: 
; 237: 
; 238: calc_rotation:  'this routine checks the incrimental switch
L0003:
; 239: '1 = increasing value
; 240: '2 = decreasing value
; 241: '3 = no change
; 242: 		new_encoder = 0
	CLRF 0x4D
; 243: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x4D,0
	BTFSS 0x07,4
	BCF 0x4D,0
; 244: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x4D,1
	BTFSS 0x07,5
	BCF 0x4D,1
; 245: 		Select Case old_encoder
; 246: 		Case 0
	MOVF 0x59,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0061
; 247: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x4D,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0062
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0001
	MOVWF 0x39
L0062:
; 248: 		Case 1
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0063
L0061:
	MOVF 0x59,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0064
; 249: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x4D,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0065
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0002
	MOVWF 0x39
L0065:
; 250: 		Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0066
L0064:
	MOVF 0x59,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0067
; 251: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x4D,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0068
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0003
	MOVWF 0x39
L0068:
; 252: 		Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0069
L0067:
; 253: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x4D,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0070
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0004
	MOVWF 0x39
L0070:
; 254: 		EndSelect
L0069:
L0066:
L0063:
; 255: 		old_encoder = new_encoder
	MOVF 0x4D,W
	MOVWF 0x59
; 256: Return
	RETURN
; 257: 
; 258: 
; 259: adjust_settings:
L0004:
; 260: 	Gosub i2c_display_pgm
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0006
; 261: 	WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 262: 	Call relays(0)
	BCF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 263: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 264: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x4F,W
	MOVWF 0x3F
	MOVF 0x50,W
	MOVWF 0x40
; 265: 	While pgm = 0  'the program switch is still activated
L0071:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0072
; 266: 		If ecsw = 0 Then  'knob is pressed, inrease program_set
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0073
; 267: 			program_set = program_set + 1
	MOVF 0x43,W
	ADDLW 0x01
	MOVWF 0x43
; 268: 			If program_set > 9 Then  'no more than 9 items te change
	MOVF 0x43,W
	SUBLW 0x09
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0074
; 269: 				program_set = 0
	CLRF 0x43
; 270: 			Endif
L0074:
; 271: 			Gosub i2c_display_pgm
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0006
; 272: 			WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 273: 			While ecsw = 0  'be sure pushbutton is released
L0075:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0076
; 274: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 275: 			Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0075
L0076:
; 276: 		Endif
L0073:
; 277: 		Select Case program_set
; 278: 		Case 0  'correction of current position
	MOVF 0x43,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0077
; 279: 			value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 280: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 281: 			Gosub calc_rotation  'look for the knob to be turned
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 282: 			Select Case result
; 283: 			Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0078
; 284: 				If new_steps < 60000 Then
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0079
; 285: 					ena = 1  'motor on
	BSF 0x07,2
; 286: 					new_steps = new_steps + 1
	MOVF 0x3F,W
	ADDLW 0x01
	MOVWF 0x3F
	MOVF 0x40,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x40
; 287: 					direction = 1
	BSF 0x07,0
; 288: 					clk = 1  'clock out
	BSF 0x07,1
; 289: 					WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 290: 					clk = 0
	BCF 0x07,1
; 291: 					WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 292: 				Endif
L0079:
; 293: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0080
L0078:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0081
; 294: 				If new_steps > 0 Then
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0082
; 295: 					ena = 1  'motor on
	BSF 0x07,2
; 296: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x3F
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x40,W
	MOVWF 0x40
; 297: 					direction = 0
	BCF 0x07,0
; 298: 					clk = 1  'clock out
	BSF 0x07,1
; 299: 					WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 300: 					clk = 0
	BCF 0x07,1
; 301: 					WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 302: 				Endif
L0082:
; 303: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0083
L0081:
; 304: 			EndSelect
L0083:
L0080:
; 305: 		Case 1  'setting of maximum positions
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0084
L0077:
	MOVF 0x43,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0085
; 306: 			steps_set = 0
	BCF 0x48,1
; 307: 			ena = 0  'shut off motor
	BCF 0x07,2
; 308: 			value = max_pos
	MOVF 0x3C,W
	MOVWF 0x35
; 309: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 310: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 311: 			Select Case result
; 312: 			Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0086
; 313: 				Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 314: 				If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0087
; 315: 					If max_pos < 48 Then  'no more positions possible
	MOVLW 0x30
	SUBWF 0x3C,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0088
; 316: 						max_pos = max_pos + 1
	MOVF 0x3C,W
	ADDLW 0x01
	MOVWF 0x3C
; 317: 						Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0089:	BTFSC EECON1,WR
	GOTO L0089
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 318: 					Endif
L0088:
; 319: 				Endif
L0087:
; 320: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0090
L0086:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0091
; 321: 				Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 322: 				If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0092
; 323: 					If max_pos > 2 Then  'minimum 2 positions
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0093
; 324: 						max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x3C,W
	MOVWF 0x3C
; 325: 						Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0094:	BTFSC EECON1,WR
	GOTO L0094
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 326: 					Endif
L0093:
; 327: 				Endif
L0092:
; 328: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0095
L0091:
; 329: 			EndSelect
L0095:
L0090:
; 330: 		Case 2  'setting of speed interval Minimum
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0096
L0085:
	MOVF 0x43,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0097
; 331: 					'setting will be done in multiple of 256 uSecs
; 332: 					'minimum is usually not less then 5, and maximum is 99 (is real slow)
; 333: 			steps_set = 0
	BCF 0x48,1
; 334: 			ena = 0  'shut off motor
	BCF 0x07,2
; 335: 			value = speed_min.HB
	MOVF 0x33,W
	MOVWF 0x35
; 336: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 337: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 338: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 339: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0098
; 340: 				Select Case result
; 341: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0099
; 342: 					If speed_min.HB < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x33,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0100
; 343: 						speed_min.HB = speed_min.HB + 1
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x33
; 344: 						Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0101:	BTFSC EECON1,WR
	GOTO L0101
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 345: 					Endif
L0100:
; 346: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0102
L0099:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0103
; 347: 					If speed_min.HB > speed_max.HB Then
	MOVF 0x33,W
	SUBWF 0x37,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0104
; 348: 						speed_min.HB = speed_min.HB - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
; 349: 						Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0105:	BTFSC EECON1,WR
	GOTO L0105
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 350: 					Endif
L0104:
; 351: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0106
L0103:
; 352: 				EndSelect
L0106:
L0102:
; 353: 			Endif
L0098:
; 354: 		Case 3  'setting of speed interval Maximum
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0107
L0097:
	MOVF 0x43,W
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0108
; 355: 					'setting will be done in multiple of 256 uSecs
; 356: 					'minimum is 1 and maximum is 99 (is real slow)
; 357: 			steps_set = 0
	BCF 0x48,1
; 358: 			ena = 0  'shut off motor
	BCF 0x07,2
; 359: 			value = speed_max.HB
	MOVF 0x37,W
	MOVWF 0x35
; 360: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 361: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 362: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 363: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0109
; 364: 				Select Case result
; 365: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0110
; 366: 					If speed_max.HB < speed_min.HB Then  'not more then speed_min
	MOVF 0x33,W
	SUBWF 0x37,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0111
; 367: 						speed_max.HB = speed_max.HB + 1
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x37
; 368: 						Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0112:	BTFSC EECON1,WR
	GOTO L0112
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 369: 					Endif
L0111:
; 370: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0113
L0110:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0114
; 371: 					If speed_max.HB > 2 Then
	MOVF 0x37,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0115
; 372: 						speed_max.HB = speed_max.HB - 1
	MOVLW 0x01
	SUBWF 0x37,W
	MOVWF 0x37
; 373: 						Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0116:	BTFSC EECON1,WR
	GOTO L0116
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 374: 					Endif
L0115:
; 375: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0117
L0114:
; 376: 				EndSelect
L0117:
L0113:
; 377: 			Endif
L0109:
; 378: 		Case 4  'setting of ramp up and down speed
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0118
L0108:
	MOVF 0x43,W
	SUBLW 0x04
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0119
; 379: 					'speed will be the value that speed will be changed every step up and down
; 380: 			steps_set = 0
	BCF 0x48,1
; 381: 			ena = 0  'shut off motor
	BCF 0x07,2
; 382: 			value = speed_step
	MOVF 0x44,W
	MOVWF 0x35
; 383: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 384: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 385: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 386: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0120
; 387: 				Select Case result
; 388: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0121
; 389: 					If speed_step < 99 Then  'maximum 99 is possible
	MOVLW 0x63
	SUBWF 0x44,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0122
; 390: 						speed_step = speed_step + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
; 391: 						Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0123:	BTFSC EECON1,WR
	GOTO L0123
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 392: 					Endif
L0122:
; 393: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0124
L0121:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0125
; 394: 					If speed_step > 1 Then
	MOVF 0x44,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0126
; 395: 						speed_step = speed_step - 1
	MOVLW 0x01
	SUBWF 0x44,W
	MOVWF 0x44
; 396: 						Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0127:	BTFSC EECON1,WR
	GOTO L0127
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 397: 					Endif
L0126:
; 398: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0128
L0125:
; 399: 				EndSelect
L0128:
L0124:
; 400: 			Endif
L0120:
; 401: 	
; 402: 		Case 5  'setting of extra free space steps
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0129
L0119:
	MOVF 0x43,W
	SUBLW 0x05
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0130
; 403: 			steps_set = 0
	BCF 0x48,1
; 404: 			ena = 0  'shut off motor
	BCF 0x07,2
; 405: 			If free_space_steps > 250 Then
	MOVF 0x3D,W
	SUBLW 0xFA
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0131
; 406: 				free_space_steps = 250
	MOVLW 0xFA
	MOVWF 0x3D
; 407: 				Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0132:	BTFSC EECON1,WR
	GOTO L0132
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 408: 			Endif
L0131:
; 409: 			value = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x35
; 410: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 411: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 412: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 413: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0133
; 414: 				Select Case result
; 415: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0134
; 416: 					If free_space_steps < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x3D,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0135
; 417: 						free_space_steps = free_space_steps + 1
	MOVF 0x3D,W
	ADDLW 0x01
	MOVWF 0x3D
; 418: 						Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0136:	BTFSC EECON1,WR
	GOTO L0136
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 419: 					Endif
L0135:
; 420: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0137
L0134:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0138
; 421: 					If free_space_steps > 0 Then
	MOVF 0x3D,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0139
; 422: 						free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
; 423: 						Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0140:	BTFSC EECON1,WR
	GOTO L0140
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 424: 					Endif
L0139:
; 425: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0141
L0138:
; 426: 				EndSelect
L0141:
L0137:
; 427: 			Endif
L0133:
; 428: 		Case 6  'at which postion is in bridge reversed power
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0142
L0130:
	MOVF 0x43,W
	SUBLW 0x06
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0143
; 429: 			steps_set = 0
	BCF 0x48,1
; 430: 			ena = 0  'shut off motor
	BCF 0x07,2
; 431: 			steps_set = 0
	BCF 0x48,1
; 432: 			ena = 0  'shut off motor
	BCF 0x07,2
; 433: 			value = bridge_rev_pos
	MOVF 0x42,W
	MOVWF 0x35
; 434: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 435: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 436: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 437: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0144
; 438: 				Select Case result
; 439: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0145
; 440: 					If bridge_rev_pos < max_pos Then  'no more positions possible
	MOVF 0x3C,W
	SUBWF 0x42,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0146
; 441: 						bridge_rev_pos = bridge_rev_pos + 1
	MOVF 0x42,W
	ADDLW 0x01
	MOVWF 0x42
; 442: 						Write mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0147:	BTFSC EECON1,WR
	GOTO L0147
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 443: 					Endif
L0146:
; 444: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0148
L0145:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0149
; 445: 					If bridge_rev_pos > 0 Then  '0 does not effect reversing
	MOVF 0x42,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0150
; 446: 						bridge_rev_pos = bridge_rev_pos - 1
	MOVLW 0x01
	SUBWF 0x42,W
	MOVWF 0x42
; 447: 						Write mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0151:	BTFSC EECON1,WR
	GOTO L0151
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 448: 					Endif
L0150:
; 449: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0152
L0149:
; 450: 				EndSelect
L0152:
L0148:
; 451: 			Endif
L0144:
; 452: 		Case 7  'setting if power should be on or off while bridge is moving (0 = off)
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0153
L0143:
	MOVF 0x43,W
	SUBLW 0x07
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0154
; 453: 			Read mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x49
; 454: 			If bridge_power > 1 Then
	MOVF 0x49,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0155
; 455: 				bridge_power = 1
	MOVLW 0x01
	MOVWF 0x49
; 456: 			Endif
L0155:
; 457: 			value = bridge_power
	MOVF 0x49,W
	MOVWF 0x35
; 458: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 459: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 460: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 461: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0156
; 462: 				Select Case result
; 463: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0157
; 464: 					bridge_power = 1
	MOVLW 0x01
	MOVWF 0x49
; 465: 					Write mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x49,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0158:	BTFSC EECON1,WR
	GOTO L0158
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 466: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0159
L0157:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0160
; 467: 					bridge_power = 0
	CLRF 0x49
; 468: 					Write mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x49,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0161:	BTFSC EECON1,WR
	GOTO L0161
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 469: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0162
L0160:
; 470: 				EndSelect
L0162:
L0159:
; 471: 			Endif
L0156:
; 472: 		Case 8  'setting delay in millisecs before tt is ready is sent)
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0163
L0154:
	MOVF 0x43,W
	SUBLW 0x08
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0164
; 473: 			Read mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 474: 			If pos_match_delay > 50 Then
	MOVF 0x41,W
	SUBLW 0x32
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0165
; 475: 				pos_match_delay = 50
	MOVLW 0x32
	MOVWF 0x41
; 476: 			Endif
L0165:
; 477: 			value = pos_match_delay
	MOVF 0x41,W
	MOVWF 0x35
; 478: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 479: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 480: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 481: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0166
; 482: 				Select Case result
; 483: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0167
; 484: 					If pos_match_delay < 50 Then
	MOVLW 0x32
	SUBWF 0x41,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0168
; 485: 						pos_match_delay = pos_match_delay + 1
	MOVF 0x41,W
	ADDLW 0x01
	MOVWF 0x41
; 486: 					Endif
L0168:
; 487: 					Write mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0169:	BTFSC EECON1,WR
	GOTO L0169
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 488: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0170
L0167:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0171
; 489: 					If pos_match_delay > 0 Then
	MOVF 0x41,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0172
; 490: 						pos_match_delay = pos_match_delay - 1
	MOVLW 0x01
	SUBWF 0x41,W
	MOVWF 0x41
; 491: 					Endif
L0172:
; 492: 					Write mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0173:	BTFSC EECON1,WR
	GOTO L0173
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 493: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0174
L0171:
; 494: 				EndSelect
L0174:
L0170:
; 495: 			Endif
L0166:
; 496: 		Case Else  'menu 9 , setting control type
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0175
L0164:
; 497: 			steps_set = 0
	BCF 0x48,1
; 498: 			ena = 0  'shut off motor
	BCF 0x07,2
; 499: 			If ctrl_type > 4 Then
	MOVF 0x3E,W
	SUBLW 0x04
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0176
; 500: 				ctrl_type = 4
	MOVLW 0x04
	MOVWF 0x3E
; 501: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0177:	BTFSC EECON1,WR
	GOTO L0177
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 502: 			Endif
L0176:
; 503: 			value = ctrl_type
	MOVF 0x3E,W
	MOVWF 0x35
; 504: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 505: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 506: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 507: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0178
; 508: 				Select Case result
; 509: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0179
; 510: 					If ctrl_type < 4 Then
	MOVLW 0x04
	SUBWF 0x3E,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0180
; 511: 						ctrl_type = ctrl_type + 1
	MOVF 0x3E,W
	ADDLW 0x01
	MOVWF 0x3E
; 512: 						Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0181:	BTFSC EECON1,WR
	GOTO L0181
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 513: 					Endif
L0180:
; 514: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0182
L0179:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0183
; 515: 					If ctrl_type > 1 Then
	MOVF 0x3E,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0184
; 516: 						ctrl_type = ctrl_type - 1
	MOVLW 0x01
	SUBWF 0x3E,W
	MOVWF 0x3E
; 517: 						Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0185:	BTFSC EECON1,WR
	GOTO L0185
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 518: 					Endif
L0184:
; 519: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0186
L0183:
; 520: 				EndSelect
L0186:
L0182:
; 521: 			Endif
L0178:
; 522: 		EndSelect
L0175:
L0163:
L0153:
L0142:
L0129:
L0118:
L0107:
L0096:
L0084:
; 523: 		WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 524: 	Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0071
L0072:
; 525: 	ena = 0  'shut off motor
	BCF 0x07,2
; 526: 		'***************   now check if changes have to BE written in eeprom
; 527: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	MOVF 0x4F,W
	MOVWF R1L
	MOVF 0x50,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C002
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0187
; 528: 		Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 529: 	Endif
L0187:
; 530: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 531: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 532: 	Call relays(1)
	BSF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 533: Return
	RETURN
; 534: 
; 535: i2c_display:
L0005:
; 536: 	Select Case value
; 537: 	Case 99
	MOVF 0x35,W
	SUBLW 0x63
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0188
; 538: 		disp1_val = %10111111
	MOVLW 0xBF
	MOVWF 0x4C
; 539: 		disp2_val = %10111111
	MOVLW 0xBF
	MOVWF 0x52
; 540: 	Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0189
L0188:
; 541: 		disp1_val = value
	MOVF 0x35,W
	MOVWF 0x4C
; 542: 		disp1_val = disp1_val Mod 10
	MOVF 0x4C,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x4C
; 543: 		disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x4C,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0190
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0005
	MOVWF 0x4C
L0190:
; 544: 		disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x4C,7
	BTFSS 0x07,7
	BCF 0x4C,7
; 545: 		disp2_val = value
	MOVF 0x35,W
	MOVWF 0x52
; 546: 		disp2_val = disp2_val / 10
	MOVF 0x52,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x52
; 547: 		disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x52,W
	MOVWF R0L
	SUBLW 0x0A
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0191
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0006
	MOVWF 0x52
L0191:
; 548: 		disp2_val.7 = version
	BTFSC 0x48,3
	BSF 0x52,7
	BTFSS 0x48,3
	BCF 0x52,7
; 549: 	EndSelect
L0189:
; 550: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 551: 	I2CSend disp1
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 552: 	I2CSend disp1_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x4C,W
	CALL IC01
; 553: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 554: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 555: 	I2CSend disp2
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 556: 	I2CSend disp2_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x52,W
	CALL IC01
; 557: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 558: Return
	RETURN
; 559: 
; 560: i2c_display_pgm:
L0006:
; 561: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), program_set
	MOVF 0x43,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0192
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0007
	MOVWF 0x4C
L0192:
; 562: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 563: 	I2CSend disp1
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 564: 	I2CSend disp1_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x4C,W
	CALL IC01
; 565: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 566: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 567: 	I2CSend disp2
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 568: 	I2CSend %10111111
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 569: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 570: Return
	RETURN
; 571: 
; 572: stepmotor:
L0007:
; 573: 	speed = 0
	CLRF 0x4A
	CLRF 0x4B
; 574: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 575: 	Select Case new_pos
; 576: 	Case 62  'this is the manual setting for each position
	MOVF 0x46,W
	SUBLW 0x3E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0193
; 577: 'this position is equal for all control types, except for max switch
; 578: 'in case of control type < 6 the zero switch is used for total steps calculation
; 579: 'and bridge will run one full round extra.
; 580: 		direction = 0  'first backward
	BCF 0x07,0
; 581: 		ena = 1  'motor on
	BSF 0x07,2
; 582: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 583: 		Call run_to_zero_switch(1, 0)
	BSF 0x48,4
	BCF 0x48,7
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 584: 		ena = 0  'motor off
	BCF 0x07,2
; 585: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 586: 		one_round = 0  'start counting steps to max pos
	CLRF 0x3A
	CLRF 0x3B
; 587: 		ena = 1  'motor on
	BSF 0x07,2
; 588: 		act_pos = 1
	MOVLW 0x01
	MOVWF 0x34
; 589: 		If ctrl_type < 4 Then  'now extra round to be made to calculate total steps
	MOVLW 0x04
	SUBWF 0x3E,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0194
; 590: 			Call run_to_zero_switch(0, 1)  'RUN TO ZERO SWITCH AND COUNT STEPS
	BCF 0x48,4
	BSF 0x48,7
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 591: 			Call run_to_zero_switch(1, 1)  'RUN TO ZERO SWITCH AND COUNT STEPS
	BSF 0x48,4
	BSF 0x48,7
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 592: 		Endif
L0194:
; 593: 		Write mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0195:	BTFSC EECON1,WR
	GOTO L0195
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 594: 		Write mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0196:	BTFSC EECON1,WR
	GOTO L0196
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 595: 		one_round_half = one_round / 2
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x57
	MOVF R0H,W
	MOVWF 0x58
; 596: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 597: 		direction = 1  'run forward
	BSF 0x07,0
; 598: 		value = 0  'WE ARE IN ZERO POSITION NOW
	CLRF 0x35
; 599: 		Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 600: 		one_round = 0  'temporary use variable to count individual postitions
	CLRF 0x3A
	CLRF 0x3B
; 601: 		While act_pos <= max_pos  'turn motor until max pos is reached
L0197:
	MOVF 0x34,W
	SUBWF 0x3C,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0198
; 602: 				clk = 1  'clock out
	BSF 0x07,1
; 603: 				WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 604: 				clk = 0
	BCF 0x07,1
; 605: 				WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 606: 				one_round = one_round + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
	MOVF 0x3B,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3B
; 607: 				If ecsw = 0 Then  'knob is pressed, save position and increase act_pos
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x07,6
	GOTO L0199
; 608: 					new_steps = one_round
	MOVF 0x3A,W
	MOVWF 0x3F
	MOVF 0x3B,W
	MOVWF 0x40
; 609: 					Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 610: 					value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 611: 					Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 612: 					act_pos = act_pos + 1
	MOVF 0x34,W
	ADDLW 0x01
	MOVWF 0x34
; 613: 					WaitMs 500  'give some time to breeze
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 614: 					While ecsw = 0  'Check If knob is Not pressed
L0200:
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x07,6
	GOTO L0201
; 615: 					Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0200
L0201:
; 616: 				Endif
L0199:
; 617: 				If ctrl_type = 4 Then  'for FY , max limit switch is to be checked.
	MOVF 0x3E,W
	SUBLW 0x04
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0202
; 618: 					If max_end = 0 Then  'end switch for fy is touched, end cycle
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x06,7
	GOTO L0203
; 619: 						act_pos = max_pos + 1  'cancel the procedure
	MOVF 0x3C,W
	ADDLW 0x01
	MOVWF 0x34
; 620: 						ena = 0
	BCF 0x07,2
; 621: 					Endif
L0203:
; 622: 				Endif
L0202:
; 623: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0197
L0198:
; 624: 		Write mem_turn_counter, 127  'reset turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x7F
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0204:	BTFSC EECON1,WR
	GOTO L0204
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 625: 		Read mem_one_round_lb, one_round.LB  'put stored value back in one_round
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3A
; 626: 		Read mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3B
; 627: 		direction = 0  'goto to zero switch
	BCF 0x07,0
; 628: 		ena = 1  'set anable on
	BSF 0x07,2
; 629: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 630: 		Call run_to_zero_switch(1, 0)
	BSF 0x48,4
	BCF 0x48,7
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 631: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 632: 		act_pos = 0
	CLRF 0x34
; 633: 		new_pos = 1
	MOVLW 0x01
	MOVWF 0x46
; 634: 		Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 635: 		direction = 1  'now forwards
	BSF 0x07,0
; 636: 		steps = new_steps + free_space_steps
	MOVF 0x3F,W
	ADDWF 0x3D,W
	MOVWF 0x30
	MOVF 0x40,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x31
; 637: 		ramp_up = 1
	BSF 0x48,5
; 638: 		ramp_down_point = 0
	CLRF 0x55
	CLRF 0x56
; 639: 		half_steps = steps / 2
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x5C
	MOVF R0H,W
	MOVWF 0x5D
; 640: 		ena = 1  'set Enable on
	BSF 0x07,2
; 641: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 642: 		Call run_to_zero(speed_min, 0)
	MOVF 0x32,W
	MOVWF 0x53
	MOVF 0x33,W
	MOVWF 0x54
	BCF 0x48,6
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 643: 		WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 644: 		steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x30
	CLRF 0x31
; 645: 		direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 646: 		Call run_to_zero(speed_min, 0)
	MOVF 0x32,W
	MOVWF 0x53
	MOVF 0x33,W
	MOVWF 0x54
	BCF 0x48,6
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 647: 		ena = 0  'enable off
	BCF 0x07,2
; 648: 	Case 63  'go to zero switch and then to 1st rail position (Pos 1)
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0205
L0193:
	MOVF 0x46,W
	SUBLW 0x3F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0206
; 649: 		direction = 0  'goto to zero switch
	BCF 0x07,0
; 650: 		ena = 1  'set anable on
	BSF 0x07,2
; 651: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 652: 		Call run_to_zero_switch(1, 0)
	BSF 0x48,4
	BCF 0x48,7
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 653: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 654: 		new_pos = 1
	MOVLW 0x01
	MOVWF 0x46
; 655: 		Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 656: 		direction = 1  'now forwards
	BSF 0x07,0
; 657: 		steps = new_steps + free_space_steps
	MOVF 0x3F,W
	ADDWF 0x3D,W
	MOVWF 0x30
	MOVF 0x40,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x31
; 658: 		ramp_up = 1
	BSF 0x48,5
; 659: 		ramp_down_point = 0
	CLRF 0x55
	CLRF 0x56
; 660: 		half_steps = steps / 2
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x5C
	MOVF R0H,W
	MOVWF 0x5D
; 661: 		speed = speed_min
	MOVF 0x32,W
	MOVWF 0x4A
	MOVF 0x33,W
	MOVWF 0x4B
; 662: 		ena = 1  'set Enable on
	BSF 0x07,2
; 663: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 664: 		Call run_to_zero(speed_min, 1)
	MOVF 0x32,W
	MOVWF 0x53
	MOVF 0x33,W
	MOVWF 0x54
	BSF 0x48,6
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 665: 		WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 666: 		steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x30
	CLRF 0x31
; 667: 		direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 668: 		Call run_to_zero(speed_min, 1)
	MOVF 0x32,W
	MOVWF 0x53
	MOVF 0x33,W
	MOVWF 0x54
	BSF 0x48,6
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 669: 		ena = 0  'enable off
	BCF 0x07,2
; 670: 	Case Else  'this is the normal position sequence
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0207
L0206:
; 671: 		steps = 0
	CLRF 0x30
	CLRF 0x31
; 672: 		one_round_half = one_round / 2
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x57
	MOVF R0H,W
	MOVWF 0x58
; 673: 		If new_steps > act_steps Then
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	MOVF 0x4F,W
	MOVWF R1L
	MOVF 0x50,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0208
; 674: 			steps = new_steps - act_steps
	MOVF 0x4F,W
	SUBWF 0x3F,W
	MOVWF 0x30
	MOVF 0x50,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x40,W
	MOVWF 0x31
; 675: 			direction = 1
	BSF 0x07,0
; 676: 			Gosub check_0_pass_allowed
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 677: 		Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0209
L0208:
; 678: 			steps = act_steps - new_steps
	MOVF 0x3F,W
	SUBWF 0x4F,W
	MOVWF 0x30
	MOVF 0x40,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x50,W
	MOVWF 0x31
; 679: 			direction = 0
	BCF 0x07,0
; 680: 			Gosub check_0_pass_allowed
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 681: 		Endif
L0209:
; 682: 		If steps > 0 Then  'motor must be activated
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0210
; 683: 			If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0211
; 684: 				steps = steps + free_space_steps
	MOVF 0x30,W
	ADDWF 0x3D,W
	MOVWF 0x30
	MOVF 0x31,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x31
; 685: 			Endif
L0211:
; 686: 			ramp_up = 1
	BSF 0x48,5
; 687: 			ramp_down_point = 0
	CLRF 0x55
	CLRF 0x56
; 688: 			half_steps = steps / 2
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x5C
	MOVF R0H,W
	MOVWF 0x5D
; 689: 			speed = speed_min
	MOVF 0x32,W
	MOVWF 0x4A
	MOVF 0x33,W
	MOVWF 0x4B
; 690: 			ena = 1  'set anable on
	BSF 0x07,2
; 691: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 692: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0212:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0213
; 693: 				clk = 1  'clock out
	BSF 0x07,1
; 694: 				WaitUs speed
	MOVF 0x4A,W
	MOVWF R4L
	MOVF 0x4B,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 695: 				clk = 0
	BCF 0x07,1
; 696: 				WaitUs speed
	MOVF 0x4A,W
	MOVWF R4L
	MOVF 0x4B,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 697: 				Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 698: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 699: 				If ctrl_type = 4 Then  'only for fiddle yard
	MOVF 0x3E,W
	SUBLW 0x04
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0214
; 700: 					If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0215
; 701: 						If max_end = 0 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x06,7
	GOTO L0216
; 702: 							Gosub stop_the_motor
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 703: 						Endif
L0216:
; 704: 					Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0217
L0215:
; 705: 						If zero = 0 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x06,6
	GOTO L0218
; 706: 							Gosub stop_the_motor
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 707: 						Endif
L0218:
; 708: 					Endif
L0217:
; 709: 				Endif
L0214:
; 710: 			Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0212
L0213:
; 711: 			If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0219
; 712: 				If free_space_steps > 0 Then
	MOVF 0x3D,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0220
; 713: 					WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 714: 					steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x30
	CLRF 0x31
; 715: 					direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 716: 					Call run_to_zero(speed_min, 0)
	MOVF 0x32,W
	MOVWF 0x53
	MOVF 0x33,W
	MOVWF 0x54
	BCF 0x48,6
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 717: 				Endif
L0220:
; 718: 			Endif
L0219:
; 719: 			ena = 0  'enable off
	BCF 0x07,2
; 720: 		Endif
L0210:
; 721: 	EndSelect
L0207:
L0205:
; 722: 	act_pos = new_pos
	MOVF 0x46,W
	MOVWF 0x34
; 723: 	Write mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0221:	BTFSC EECON1,WR
	GOTO L0221
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 724: 	bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x51
; 725: 	old_bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x5E
; 726: 	manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x38
; 727: 	old_manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x5A
; 728: 
; 729: Return
	RETURN
; 730: 
; 731: check_0_pass_allowed:
L0008:
; 732: 	If steps > one_round_half Then
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVF 0x57,W
	MOVWF R1L
	MOVF 0x58,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0222
; 733: 		Select Case ctrl_type
; 734: 		Case 2  'crossing zero possible but only if not too many turns in one direction
	MOVF 0x3E,W
	SUBLW 0x02
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0223
; 735: 			If steps > one_round_half Then
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVF 0x57,W
	MOVWF R1L
	MOVF 0x58,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0224
; 736: 				Read mem_turn_counter, turn_counter  'get the total turns
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x4E
; 737: 				If turn_counter > 124 And direction = 1 Then  'extra round in direction 0 allowed
	MOVF 0x4E,W
	SUBLW 0x7C
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0225
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0225
; 738: 					turn_counter = turn_counter - 1  'substract 1 pass
	MOVLW 0x01
	SUBWF 0x4E,W
	MOVWF 0x4E
; 739: 					Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x4E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0226:	BTFSC EECON1,WR
	GOTO L0226
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 740: 					direction = 0  'change direction
	BCF 0x07,0
; 741: 					steps = one_round - steps  'set the number of steps for the other direction
	MOVF 0x30,W
	SUBWF 0x3A,W
	MOVWF 0x30
	MOVF 0x31,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x31
; 742: 				Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0227
L0225:
; 743: 					If turn_counter < 130 And direction = 0 Then  'extra round in direction 1 allowed
	MOVLW 0x82
	SUBWF 0x4E,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0228
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x07,0
	GOTO L0228
; 744: 						turn_counter = turn_counter + 1
	MOVF 0x4E,W
	ADDLW 0x01
	MOVWF 0x4E
; 745: 						Write mem_turn_counter, turn_counter  'add 1 pass
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x4E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0229:	BTFSC EECON1,WR
	GOTO L0229
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 746: 						direction = 1  'change direction
	BSF 0x07,0
; 747: 						steps = one_round - steps  'set the number of steps for the other direction
	MOVF 0x30,W
	SUBWF 0x3A,W
	MOVWF 0x30
	MOVF 0x31,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x31
; 748: 					Endif
L0228:
; 749: 				Endif
L0227:
; 750: 			Endif
L0224:
; 751: 		Case 3  'crossing zero always possible
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0230
L0223:
	MOVF 0x3E,W
	SUBLW 0x03
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0231
; 752: 			direction = Not direction  'change direction
	MOVLW 0x01
	XORWF 0x07,F
; 753: 			steps = one_round - steps  'set the number of steps for the other direction
	MOVF 0x30,W
	SUBWF 0x3A,W
	MOVWF 0x30
	MOVF 0x31,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x31
; 754: 		Case Else  'no zero crossing allowed
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0232
L0231:
; 755: 		EndSelect
L0232:
L0230:
; 756: 	Endif
L0222:
; 757: Return
	RETURN
; 758: 
; 759: 
; 760: speed_calc:
L0009:
; 761: 	If steps < half_steps Then  'at this point  ramp up MUST end half way
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVF 0x5C,W
	MOVWF R1L
	MOVF 0x5D,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0233
; 762: 		ramp_up = 0
	BCF 0x48,5
; 763: 	Endif
L0233:
; 764: 	If ramp_up = 1 Then  'we were supposed to ramp up
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x48,5
	GOTO L0234
; 765: 		If speed > speed_max Then
	MOVF 0x4A,W
	MOVWF R0L
	MOVF 0x4B,W
	MOVWF R0H
	MOVF 0x36,W
	MOVWF R1L
	MOVF 0x37,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0235
; 766: 			speed = speed - speed_step
	MOVF 0x44,W
	SUBWF 0x4A,W
	MOVWF 0x4A
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x4B,W
	MOVWF 0x4B
; 767: 			ramp_down_point = ramp_down_point + 1  'this counts down with the steps
	MOVF 0x55,W
	ADDLW 0x01
	MOVWF 0x55
	MOVF 0x56,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x56
; 768: 		Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0236
L0235:
; 769: 			ramp_up = 0
	BCF 0x48,5
; 770: 		Endif
L0236:
; 771: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0237
L0234:
; 772: 		If steps < ramp_down_point Then  'this is the point tot start ramp down
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVF 0x55,W
	MOVWF R1L
	MOVF 0x56,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0238
; 773: 			If speed < speed_min Then
	MOVF 0x4A,W
	MOVWF R0L
	MOVF 0x4B,W
	MOVWF R0H
	MOVF 0x32,W
	MOVWF R1L
	MOVF 0x33,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0239
; 774: 				speed = speed + speed_step
	MOVF 0x4A,W
	ADDWF 0x44,W
	MOVWF 0x4A
	MOVF 0x4B,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x4B
; 775: 			Endif
L0239:
; 776: 		Endif
L0238:
; 777: 	Endif
L0237:
; 778: Return
	RETURN
; 779: 
; 780: 
; 781: 
; 782: init_values:
L0010:
; 783: 	value = 72  'version number
	MOVLW 0x48
	MOVWF 0x35
; 784: 	version = 0  'decimal point in display on
	BCF 0x48,3
; 785: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 786: 	WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 787: 	version = 1  'decimal point in display off
	BSF 0x48,3
; 788: 	encoder_count = 0
	CLRF 0x45
; 789: 	speed_min = 0
	CLRF 0x32
	CLRF 0x33
; 790: 	
; 791: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3E
; 792: 	If ctrl_type > 4 Or ctrl_type = 0 Then
	MOVF 0x3E,W
	SUBLW 0x04
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0242
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0241
L0242:
	MOVF 0x3E,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0240
L0241:
; 793: 		ctrl_type = 1
	MOVLW 0x01
	MOVWF 0x3E
; 794: 		Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0243:	BTFSC EECON1,WR
	GOTO L0243
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 795: 	Endif
L0240:
; 796: 	
; 797: 	Read mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 798: 	If speed_min.HB > 99 Then
	MOVF 0x33,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0244
; 799: 		speed_min.HB = 30
	MOVLW 0x1E
	MOVWF 0x33
; 800: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0245
L0244:
; 801: 		If speed_min.HB < 2 Then
	MOVLW 0x02
	SUBWF 0x33,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0246
; 802: 			speed_min.HB = 20
	MOVLW 0x14
	MOVWF 0x33
; 803: 		Endif
L0246:
; 804: 	Endif
L0245:
; 805: 
; 806: 	Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0247:	BTFSC EECON1,WR
	GOTO L0247
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 807: 	speed_max = 0
	CLRF 0x36
	CLRF 0x37
; 808: 	Read mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 809: 	If speed_max.HB > speed_min.HB Then
	MOVF 0x37,W
	SUBWF 0x33,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0248
; 810: 		speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x37
; 811: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0249
L0248:
; 812: 		If speed_max.HB < 2 Then
	MOVLW 0x02
	SUBWF 0x37,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0250
; 813: 			speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x37
; 814: 		Endif
L0250:
; 815: 	Endif
L0249:
; 816: 	Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0251:	BTFSC EECON1,WR
	GOTO L0251
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 817: 
; 818: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3A
; 819: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3B
; 820: 	If one_round = 0 Then
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0252
; 821: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x3A
	MOVLW 0x1F
	MOVWF 0x3B
; 822: 	Endif
L0252:
; 823: 	If one_round > 60000 Then
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0253
; 824: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x3A
	MOVLW 0x1F
	MOVWF 0x3B
; 825: 	Endif
L0253:
; 826: 	one_round_half = one_round / 2
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x57
	MOVF R0H,W
	MOVWF 0x58
; 827: 
; 828: 	Read mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3C
; 829: 	If max_pos > 48 Or max_pos < 2 Then
	MOVF 0x3C,W
	SUBLW 0x30
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0256
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0255
L0256:
	MOVLW 0x02
	SUBWF 0x3C,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0254
L0255:
; 830: 		max_pos = 20
	MOVLW 0x14
	MOVWF 0x3C
; 831: 		bridge_rev_pos = 10
	MOVLW 0x0A
	MOVWF 0x42
; 832: 		Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0257:	BTFSC EECON1,WR
	GOTO L0257
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 833: 		Write mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0258:	BTFSC EECON1,WR
	GOTO L0258
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 834: 	Endif
L0254:
; 835: 	
; 836: 	Read mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x42
; 837: 	If bridge_rev_pos > max_pos Then
	MOVF 0x42,W
	SUBWF 0x3C,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0259
; 838: 		bridge_rev_pos = max_pos / 2
	MOVF 0x3C,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x42
; 839: 		Write mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0260:	BTFSC EECON1,WR
	GOTO L0260
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 840: 	Endif
L0259:
; 841: 	
; 842: 	Read mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 843: 	If act_pos > max_pos Then
	MOVF 0x34,W
	SUBWF 0x3C,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0261
; 844: 		act_pos = 1
	MOVLW 0x01
	MOVWF 0x34
; 845: 		Write mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0262:	BTFSC EECON1,WR
	GOTO L0262
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 846: 	Endif
L0261:
; 847: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 848: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 849: 	Read mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3D
; 850: 	If free_space_steps > 99 Then
	MOVF 0x3D,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0263
; 851: 		free_space_steps = 50
	MOVLW 0x32
	MOVWF 0x3D
; 852: 	Endif
L0263:
; 853: 	Read mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 854: 	If pos_match_delay > 50 Then
	MOVF 0x41,W
	SUBLW 0x32
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0264
; 855: 		pos_match_delay = 10
	MOVLW 0x0A
	MOVWF 0x41
; 856: 	Endif
L0264:
; 857: 	
; 858: 	Read mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x44
; 859: 	If speed_step > 99 Then
	MOVF 0x44,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0265
; 860: 		speed_step = 20
	MOVLW 0x14
	MOVWF 0x44
; 861: 	Endif
L0265:
; 862: 	steps_set = 0
	BCF 0x48,1
; 863: 	new_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x46
; 864: 	bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x51
; 865: 	old_bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x5E
; 866: 	manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x38
; 867: 	old_manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x5A
; 868: 	old_pos_write = 1
	BSF 0x5B,0
; 869: Return
	RETURN
; 870: 
; 871: steps_reading:
L0011:
; 872: 	Select Case act_pos
; 873: 	Case 63, 62
	MOVF 0x34,W
	SUBLW 0x3F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0268
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0267
L0268:
	MOVF 0x34,W
	SUBLW 0x3E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0266
L0267:
; 874: 		act_steps = 0
	CLRF 0x4F
	CLRF 0x50
; 875: 	Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0269
L0266:
; 876: 		eprom_pointer = act_pos
	MOVF 0x34,W
	MOVWF 0x47
; 877: 		eprom_pointer = eprom_pointer + 48
	MOVF 0x47,W
	ADDLW 0x30
	MOVWF 0x47
; 878: 		Read act_pos, act_steps.LB
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x4F
; 879: 		Read eprom_pointer, act_steps.HB
	MOVF 0x47,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x50
; 880: 	EndSelect
L0269:
; 881: 	Select Case new_pos
; 882: 	Case 62, 63
	MOVF 0x46,W
	SUBLW 0x3E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0272
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0271
L0272:
	MOVF 0x46,W
	SUBLW 0x3F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0270
L0271:
; 883: 		new_steps = 0
	CLRF 0x3F
	CLRF 0x40
; 884: 	Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0273
L0270:
; 885: 		eprom_pointer = new_pos
	MOVF 0x46,W
	MOVWF 0x47
; 886: 		eprom_pointer = eprom_pointer + 48
	MOVF 0x47,W
	ADDLW 0x30
	MOVWF 0x47
; 887: 		Read new_pos, new_steps.LB
	MOVF 0x46,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 888: 		Read eprom_pointer, new_steps.HB
	MOVF 0x47,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 889: 	EndSelect
L0273:
; 890: Return
	RETURN
; 891: 
; 892: 
; 893: save_steps:
L0012:
; 894: 	eprom_pointer = act_pos
	MOVF 0x34,W
	MOVWF 0x47
; 895: 	eprom_pointer = eprom_pointer + 48
	MOVF 0x47,W
	ADDLW 0x30
	MOVWF 0x47
; 896: 	Write act_pos, new_steps.LB
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0274:	BTFSC EECON1,WR
	GOTO L0274
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 897: 	Write eprom_pointer, new_steps.HB
	MOVF 0x47,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0275:	BTFSC EECON1,WR
	GOTO L0275
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 898: Return
	RETURN
; 899: 
; 900: 
; 901: stop_the_motor:
L0013:
; 902: 	ena = 0  'set anable oFF
	BCF 0x07,2
; 903: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 904: 	version = 0  'decimal point in display on
	BCF 0x48,3
; 905: 	While ecsw = 1
L0276:
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,6
	GOTO L0277
; 906: 		WaitMs 250
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 907: 		Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 908: 		version = Not version
	MOVLW 0x08
	XORWF 0x48,F
; 909: 	Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0276
L0277:
; 910: 	version = 1  'decimal point off
	BSF 0x48,3
; 911: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 912: 	ena = 1  'set anable on
	BSF 0x07,2
; 913: Return
	RETURN
; 914: wait_pos_match:
L0014:
; 915: 	value = 99
	MOVLW 0x63
	MOVWF 0x35
; 916: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 917: 	steps = pos_match_delay * 100
	MOVF 0x41,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x30
	MOVF R2H,W
	MOVWF 0x31
; 918: 	WaitMs steps
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 919: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 920: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 921: 	pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 922: Return
	RETURN
; 923: Proc run_to_zero(speed As Word, calc As Bit)
L0015:
; 924: 	While steps > 0  'NOW RUN UNTIL STEPS = 0
L0278:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0279
; 925: 		If calc = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x48,6
	GOTO L0280
; 926: 			Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 927: 		Endif
L0280:
; 928: 		
; 929: 		clk = 1  'clock out
	BSF 0x07,1
; 930: 		WaitUs speed
	MOVF 0x53,W
	MOVWF R4L
	MOVF 0x54,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 931: 		clk = 0
	BCF 0x07,1
; 932: 		WaitUs speed
	MOVF 0x53,W
	MOVWF R4L
	MOVF 0x54,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 933: 		Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 934: 		steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 935: 	Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0278
L0279:
; 936: 
; 937: End Proc
	RETURN
; 938: Proc run_to_zero_switch(bitposition As Bit, counting As Bit)
L0016:
; 939: 	If counting = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x48,7
	GOTO L0281
; 940: 		While zero = bitposition  'NOW RUN UNTIL switch is activated
L0282:
	CLRW
	BTFSC 0x06,6
	ADDLW 0x01
	BTFSC 0x48,4
	SUBLW 0x01
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0283
; 941: 			clk = 1  'clock out
	BSF 0x07,1
; 942: 			WaitUs speed_max
	MOVF 0x36,W
	MOVWF R4L
	MOVF 0x37,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 943: 			clk = 0
	BCF 0x07,1
; 944: 			WaitUs speed_max
	MOVF 0x36,W
	MOVWF R4L
	MOVF 0x37,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 945: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 946: 			one_round = one_round + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
	MOVF 0x3B,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3B
; 947: 		Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0282
L0283:
; 948: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0284
L0281:
; 949: 		While zero = bitposition  'NOW RUN UNTIL switch is activated
L0285:
	CLRW
	BTFSC 0x06,6
	ADDLW 0x01
	BTFSC 0x48,4
	SUBLW 0x01
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0286
; 950: 			clk = 1  'clock out
	BSF 0x07,1
; 951: 			WaitUs speed_max
	MOVF 0x36,W
	MOVWF R4L
	MOVF 0x37,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 952: 			clk = 0
	BCF 0x07,1
; 953: 			WaitUs speed_max
	MOVF 0x36,W
	MOVWF R4L
	MOVF 0x37,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 954: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 955: 		Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0285
L0286:
; 956: 	Endif
L0284:
; 957: End Proc
	RETURN
; 958: 
; 959: Proc relays(onoff As Bit)
L0017:
; 960: 		If act_pos < bridge_rev_pos Or bridge_rev_pos = 0 Then  'just normal Bridge power (if allowed)
	MOVF 0x42,W
	SUBWF 0x34,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0289
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0288
L0289:
	MOVF 0x42,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0287
L0288:
; 961: 			swfw = 0
	BCF 0x06,0
; 962: 			WaitMs 100  'just wait for the relay to drop
	MOVLW 0x64
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 963: 			If onoff = 0 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x48,2
	GOTO L0290
; 964: 				swrev = bridge_power.0
	BTFSC 0x49,0
	BSF 0x06,1
	BTFSS 0x49,0
	BCF 0x06,1
; 965: 			Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0291
L0290:
; 966: 				swrev = 1
	BSF 0x06,1
; 967: 			Endif
L0291:
; 968: 		Else  'inverse bridge power (if allowed)
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0292
L0287:
; 969: 			swrev = 0
	BCF 0x06,1
; 970: 			WaitMs 100  'just wait for the relay to drop
	MOVLW 0x64
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 971: 			If onoff = 0 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x48,2
	GOTO L0293
; 972: 				swfw = bridge_power.0
	BTFSC 0x49,0
	BSF 0x06,0
	BTFSS 0x49,0
	BCF 0x06,0
; 973: 			Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0294
L0293:
; 974: 				swfw = 1
	BSF 0x06,0
; 975: 			Endif
L0294:
; 976: 		Endif
L0292:
; 977: End Proc
	RETURN
; 978: Proc check_encoder_count()
L0018:
; 979: 	If encoder_count < 6 Then
	MOVLW 0x06
	SUBWF 0x45,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0295
; 980: 		encoder_count = encoder_count + 1
	MOVF 0x45,W
	ADDLW 0x01
	MOVWF 0x45
; 981: 		proceed = 0
	BCF 0x48,0
; 982: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0296
L0295:
; 983: 		encoder_count = 0
	CLRF 0x45
; 984: 		proceed = 1
	BSF 0x48,0
; 985: 	Endif
L0296:
; 986: End Proc
	RETURN
; End of program
;       PAGE SELECT
	BSF PCLATH,3
L0297:	GOTO L0297
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
