; Compiled with: PIC Simulator IDE v6.92
; Microcontroller model: PIC16F873A
; Clock frequency: 4.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_act_pos' (global) is 127
;       The value of 'mem_turn_counter' (global) is 101
;       The value of 'mem_speed_min' (global) is 103
;       The value of 'mem_speed_max' (global) is 104
;       The value of 'mem_speed_step' (global) is 105
;       The value of 'mem_one_round_lb' (global) is 106
;       The value of 'mem_one_round_hb' (global) is 107
;       The value of 'mem_ctrl_type' (global) is 108
;       The value of 'mem_max_pos' (global) is 109
;       The value of 'mem_free_space' (global) is 110
;       The value of 'mem_rev_pos' (global) is 111
;       The value of 'mem_bridge_power' (global) is 112
;       The value of 'mem_pos_match_delay' (global) is 113
;       The value of 'mem_bridge_rev_pos' (global) is 114
;       The address of 'steps' (word) (global) is 0x30
	steps EQU 0x30
;       The address of 'speed_min' (word) (global) is 0x32
	speed_min EQU 0x32
;       The address of 'act_pos' (byte) (global) is 0x34
	act_pos EQU 0x34
;       The address of 'value' (byte) (global) is 0x35
	value EQU 0x35
;       The address of 'speed_max' (word) (global) is 0x36
	speed_max EQU 0x36
;       The address of 'manual_pos' (byte) (global) is 0x38
	manual_pos EQU 0x38
;       The address of 'result' (byte) (global) is 0x39
	result EQU 0x39
;       The address of 'one_round' (word) (global) is 0x3A
	one_round EQU 0x3A
;       The address of 'max_pos' (byte) (global) is 0x3C
	max_pos EQU 0x3C
;       The address of 'free_space_steps' (byte) (global) is 0x3D
	free_space_steps EQU 0x3D
;       The address of 'ctrl_type' (byte) (global) is 0x3E
	ctrl_type EQU 0x3E
;       The address of 'new_steps' (word) (global) is 0x3F
	new_steps EQU 0x3F
;       The address of 'pos_match_delay' (byte) (global) is 0x41
	pos_match_delay EQU 0x41
;       The address of 'bridge_rev_pos' (byte) (global) is 0x42
	bridge_rev_pos EQU 0x42
;       The address of 'program_set' (byte) (global) is 0x43
	program_set EQU 0x43
;       The address of 'speed_step' (byte) (global) is 0x44
	speed_step EQU 0x44
;       The address of 'encoder_count' (byte) (global) is 0x45
	encoder_count EQU 0x45
;       The address of 'new_pos' (byte) (global) is 0x46
	new_pos EQU 0x46
;       The address of 'eprom_pointer' (byte) (global) is 0x47
	eprom_pointer EQU 0x47
;       The address of 'proceed' (bit) (global) is 0x48,0
;       The address of 'bridge_power' (byte) (global) is 0x49
	bridge_power EQU 0x49
;       The address of 'speed' (word) (global) is 0x4A
	speed EQU 0x4A
;       The address of 'disp1_val' (byte) (global) is 0x4C
	disp1_val EQU 0x4C
;       The address of 'new_encoder' (byte) (global) is 0x4D
	new_encoder EQU 0x4D
;       The address of 'steps_set' (bit) (global) is 0x48,1
;       The address of 'turn_counter' (byte) (global) is 0x4E
	turn_counter EQU 0x4E
;       The address of 'onoff' (bit) (relays) is 0x48,2
;       The address of 'act_steps' (word) (global) is 0x4F
	act_steps EQU 0x4F
;       The address of 'bus_pos' (byte) (global) is 0x51
	bus_pos EQU 0x51
;       The address of 'disp2_val' (byte) (global) is 0x52
	disp2_val EQU 0x52
;       The address of 'version' (bit) (global) is 0x48,3
;       The address of 'bitposition' (bit) (run_to_zero_switch) is 0x48,4
;       The address of 'ramp_up' (bit) (global) is 0x48,5
;       The address of 'speed' (word) (run_to_zero) is 0x53
;       The address of 'calc' (bit) (run_to_zero) is 0x48,6
;       The address of 'counting' (bit) (run_to_zero_switch) is 0x48,7
;       The address of 'ramp_down_point' (word) (global) is 0x55
	ramp_down_point EQU 0x55
;       The address of 'one_round_half' (word) (global) is 0x57
	one_round_half EQU 0x57
;       The address of 'old_encoder' (byte) (global) is 0x59
	old_encoder EQU 0x59
;       The address of 'old_manual_pos' (byte) (global) is 0x5A
	old_manual_pos EQU 0x5A
;       The address of 'old_pos_write' (bit) (global) is 0x5B,0
;       The address of 'half_steps' (word) (global) is 0x5C
	half_steps EQU 0x5C
;       The address of 'old_bus_pos' (byte) (global) is 0x5E
	old_bus_pos EQU 0x5E
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x6,6
;       The address of 'max_end' (bit) (global) is 0x6,7
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
;       The address of 'adjust_en' (bit) (global) is 0x7,3
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0019
	ORG 0x0004
	RETFIE
; LookUp Table: (3, 2, 1, 3)
_lookup_lab_0001:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
; LookUp Table: (1, 3, 3, 2)
_lookup_lab_0002:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
; LookUp Table: (2, 3, 3, 1)
_lookup_lab_0003:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
; LookUp Table: (3, 1, 2, 3)
_lookup_lab_0004:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0005:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; LookUp Table: (%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111)
_lookup_lab_0006:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0007:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x12
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Word
Y001:	MOVLW 0x10
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x0A
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0019:
; 1: 
; 2: 
; 3: Define CONF_WORD = 0x3f72
; 4: 
; 5: 'program TT for PCBoard GCA145 / MGV145
; 6: 'Universal version 7.3
; 7: 'For sliding systems (FY) extra end switch is used.
; 8: 'RB7 on ICSP1 (pin3) is endswitch (pass last rail)
; 9: 'J4 is used as zero switch (pass first rail)
; 10: 'EEP1 jumper is used to enable pos 61 and 62
; 11: 
; 12: 'three extra position are possible:
; 13: '-  position 63 to go to zero switch and then to rail 1
; 14: '-  Position 62 to manually set all positions first time (Manual initialisation, only when eep1 is set)
; 15: 'programs :
; 16: '0  correction actual position
; 17: '1  Max positions
; 18: '2  min speed
; 19: '3  max speed
; 20: '4  incr/decr delay
; 21: '5  extra correction steps
; 22: '6  bridge power normal/ reversed (Pos) at this position and all higher ones, bridge power is reversed
; 23: '7  Bridge power on/off (1/0) while moving
; 24: '8  pos_match delay
; 25: '9  setting of control type (0..6)
; 26: '-  control types:
; 27: '-    1 |control is set For turntable NO 'shortest way option' means that running from highest to lowest position (or v.v.) will NOT pass 0 position.|
; 28: '-    2 |control is set For turntable with  'shortest way option' which means that running from one to next position (or v.v.) could pass 0 position.|
; 29: '-    3 |version for two rail tt, no restriction on 'short way'. This is special for TT with contact rings  (no cables).|
; 30: '-    4 |fiddle yard.railpower. End switch at the High position side is needed.|
; 31: 
; 32: '-      for control type see manual
; 33: '- V7.2  2 apr 2013  Delay after position set activated.
; 34: '- V7.3  May 20 2013 In fiddle yard function, max-limit swotch is now emergengy stop for both directions.
; 35: Dim steps As Word
; 36: Dim half_steps As Word
; 37: Dim ramp_down_point As Word
; 38: Dim program_set As Byte
; 39: Dim new_steps As Word
; 40: Dim act_steps As Word
; 41: Dim new_pos As Byte
; 42: Dim act_pos As Byte
; 43: Dim one_round As Word
; 44: Dim one_round_half As Word
; 45: Dim bus_pos As Byte
; 46: Dim old_bus_pos As Byte
; 47: Dim speed As Word
; 48: Dim speed_min As Word
; 49: Dim speed_max As Word
; 50: Dim new_encoder As Byte
; 51: Dim old_encoder As Byte
; 52: Dim manual_pos As Byte
; 53: Dim old_manual_pos As Byte
; 54: Dim result As Byte
; 55: Dim free_space_steps As Byte
; 56: Dim value As Byte
; 57: Dim eprom_pointer As Byte
; 58: Dim encoder_count As Byte
; 59: 'Dim onoff As Bit
; 60: Dim max_pos As Byte
; 61: Dim disp1_val As Byte
; 62: Dim disp2_val As Byte
; 63: Dim old_pos_write As Bit
; 64: Dim ramp_up As Bit
; 65: Dim speed_step As Byte
; 66: Dim version As Bit
; 67: Dim steps_set As Bit
; 68: Dim bridge_power As Byte
; 69: Dim pos_match_delay As Byte
; 70: Dim bridge_rev_pos As Byte
; 71: Dim ctrl_type As Byte
; 72: Dim turn_counter As Byte
; 73: Dim proceed As Bit
; 74: Const disp1 = 64
; 75: Const disp2 = 66
; 76: Const mem_act_pos = 127
; 77: Const mem_turn_counter = 101
; 78: Const mem_speed_min = 103
; 79: Const mem_speed_max = 104
; 80: Const mem_speed_step = 105
; 81: Const mem_one_round_lb = 106
; 82: Const mem_one_round_hb = 107
; 83: Const mem_ctrl_type = 108
; 84: Const mem_max_pos = 109
; 85: Const mem_free_space = 110
; 86: Const mem_rev_pos = 111
; 87: Const mem_bridge_power = 112
; 88: Const mem_pos_match_delay = 113
; 89: Const mem_bridge_rev_pos = 114
; 90: Symbol swfw = RB0
; 91: Symbol swrev = RB1
; 92: Symbol sck = RB2
; 93: Symbol sda = RB3
; 94: Symbol pos_match = RB4
; 95: Symbol pos_write = RB5
; 96: Symbol direction = RC0
; 97: Symbol clk = RC1
; 98: Symbol ena = RC2
; 99: Symbol zero = RB6
; 100: Symbol max_end = RB7
; 101: Symbol ec1 = RC4
; 102: Symbol ec2 = RC5
; 103: Symbol ecsw = RC6
; 104: Symbol pgm = RC7
; 105: Symbol adjust_en = RC3
; 106: 
; 107: ADCON1 = %0110
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 108: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 109: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 110: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 111: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 112: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 113: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 114: Gosub init_values
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0010
; 115: Call relays(1)
	BSF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 116: program_set = 0
	CLRF 0x43
; 117: max_end = 1
	BSF 0x06,7
; 118: 
; 119: main:
L0001:
; 120: 	If pgm = 0 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0020
; 121: 		Gosub adjust_settings
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0004
; 122: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 123: 	Endif
L0020:
; 124: 
; 125: 	Gosub get_new_position
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0002
; 126: 	If bus_pos <> old_bus_pos Then
	MOVF 0x51,W
	SUBWF 0x5E,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0021
; 127: 		Call relays(0)
	BCF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 128: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 129: 		steps = pos_match_delay * 100
	MOVF 0x41,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x30
	MOVF R2H,W
	MOVWF 0x31
; 130: 		WaitMs steps
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 131: 		new_pos = bus_pos
	MOVF 0x51,W
	MOVWF 0x46
; 132: 		Gosub stepmotor
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0007
; 133: 		Gosub wait_pos_match
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 134: 		Call relays(1)
	BSF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 135: 'onoff = 1
; 136: 'Gosub relays
; 137: 		Gosub wait_pos_match
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 138: 	Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0022
L0021:
; 139: 		If ecsw = 0 Then  'only when knob is pushed
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0023
; 140: 			If manual_pos <> old_manual_pos Then
	MOVF 0x38,W
	SUBWF 0x5A,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0024
; 141: 				Call relays(0)
	BCF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 142: 				pos_match = 1  'indicate not in position
	BSF 0x06,4
; 143: 				steps = pos_match_delay * 100
	MOVF 0x41,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x30
	MOVF R2H,W
	MOVWF 0x31
; 144: 				WaitMs steps
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 145: 				old_manual_pos = manual_pos
	MOVF 0x38,W
	MOVWF 0x5A
; 146: 				new_pos = manual_pos
	MOVF 0x38,W
	MOVWF 0x46
; 147: 				Gosub stepmotor
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0007
; 148: 				Gosub wait_pos_match
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 149: 				Call relays(1)
	BSF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 150: 			Endif
L0024:
; 151: 		Endif
L0023:
; 152: 	Endif
L0022:
; 153: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 154: 	Goto main
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0001
; 155: End
;       PAGE SELECT
	BCF PCLATH,3
L0025:	GOTO L0025
; 156: 
; 157: get_new_position:
L0002:
; 158: 	value = bus_pos  'remember the position
	MOVF 0x51,W
	MOVWF 0x35
; 159: 	If pos_write = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,5
	GOTO L0026
; 160: 		If old_pos_write = 0 Then  'react once on rising edge
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x5B,0
	GOTO L0027
; 161: 			old_pos_write = 1
	BSF 0x5B,0
; 162: 			value = PORTA And 63  'now get value from J5
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x35
; 163: 			Select Case value
; 164: 			Case 63  'position reset is desired
	MOVF 0x35,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0028
; 165: 				value = 63
	MOVLW 0x3F
	MOVWF 0x35
; 166: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0029
L0028:
; 167: 				If value > max_pos Then  'this is not allowed
	MOVF 0x35,W
	SUBWF 0x3C,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0030
; 168: 					value = bus_pos  'put it back to old situation
	MOVF 0x51,W
	MOVWF 0x35
; 169: 				Endif
L0030:
; 170: 			EndSelect
L0029:
; 171: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 172: 			If value = bus_pos Then  'no other position is set, just a response on pos_write is required
	MOVF 0x35,W
	SUBWF 0x51,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0031
; 173: 				pos_match = 1
	BSF 0x06,4
; 174: 				WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 175: 				pos_match = 0
	BCF 0x06,4
; 176: 			Endif
L0031:
; 177: 		Endif
L0027:
; 178: 	Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0032
L0026:
; 179: 		old_pos_write = 0
	BCF 0x5B,0
; 180: 	Endif
L0032:
; 181: 	bus_pos = value  'now take over the desired position
	MOVF 0x35,W
	MOVWF 0x51
; 182: 	Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 183: 	Select Case result
; 184: 	Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0033
; 185: 		If encoder_count < 6 Then
	MOVLW 0x06
	SUBWF 0x45,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0034
; 186: 			encoder_count = encoder_count + 1
	MOVF 0x45,W
	ADDLW 0x01
	MOVWF 0x45
; 187: 		Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0035
L0034:
; 188: 			encoder_count = 0
	CLRF 0x45
; 189: 			Select Case manual_pos
; 190: 			Case < max_pos
	MOVF 0x3C,W
	SUBWF 0x38,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0036
; 191: 				manual_pos = manual_pos + 1
	MOVF 0x38,W
	ADDLW 0x01
	MOVWF 0x38
; 192: 			Case max_pos
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0037
L0036:
	MOVF 0x38,W
	SUBWF 0x3C,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0038
; 193: 				If adjust_en = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0039
; 194: 					manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x38
; 195: 				Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0040
L0039:
; 196: 					manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x38
; 197: 				Endif
L0040:
; 198: 			Case 63
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0041
L0038:
	MOVF 0x38,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0042
; 199: 				manual_pos = 1
	MOVLW 0x01
	MOVWF 0x38
; 200: 			Case 62
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0043
L0042:
	MOVF 0x38,W
	SUBLW 0x3E
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0044
; 201: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x38
; 202: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0045
L0044:
; 203: 			EndSelect
L0045:
L0043:
L0041:
L0037:
; 204: 			value = manual_pos
	MOVF 0x38,W
	MOVWF 0x35
; 205: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 206: 		Endif
L0035:
; 207: 	Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0046
L0033:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0047
; 208: 		If encoder_count > 0 Then
	MOVF 0x45,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0048
; 209: 			encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x45,W
	MOVWF 0x45
; 210: 		Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0049
L0048:
; 211: 			encoder_count = 6
	MOVLW 0x06
	MOVWF 0x45
; 212: 			Select Case manual_pos
; 213: 			Case 62
	MOVF 0x38,W
	SUBLW 0x3E
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0050
; 214: 				manual_pos = max_pos
	MOVF 0x3C,W
	MOVWF 0x38
; 215: 			Case 63
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0051
L0050:
	MOVF 0x38,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0052
; 216: 				If adjust_en = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0053
; 217: 					manual_pos = max_pos
	MOVF 0x3C,W
	MOVWF 0x38
; 218: 				Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0054
L0053:
; 219: 					manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x38
; 220: 				Endif
L0054:
; 221: 			Case 1
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0055
L0052:
	MOVF 0x38,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0056
; 222: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x38
; 223: 			Case 0
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0057
L0056:
	MOVF 0x38,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0058
; 224: 				manual_pos = 1
	MOVLW 0x01
	MOVWF 0x38
; 225: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0059
L0058:
; 226: 				manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x38,W
	MOVWF 0x38
; 227: 			EndSelect
L0059:
L0057:
L0055:
L0051:
; 228: 			value = manual_pos
	MOVF 0x38,W
	MOVWF 0x35
; 229: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 230: 		Endif
L0049:
; 231: 	Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0060
L0047:
; 232: 	EndSelect
L0060:
L0046:
; 233: 	WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 234: 	
; 235: Return
	RETURN
; 236: 
; 237: 
; 238: 
; 239: calc_rotation:  'this routine checks the incrimental switch
L0003:
; 240: '1 = increasing value
; 241: '2 = decreasing value
; 242: '3 = no change
; 243: 		new_encoder = 0
	CLRF 0x4D
; 244: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x4D,0
	BTFSS 0x07,4
	BCF 0x4D,0
; 245: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x4D,1
	BTFSS 0x07,5
	BCF 0x4D,1
; 246: 		Select Case old_encoder
; 247: 		Case 0
	MOVF 0x59,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0061
; 248: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x4D,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0062
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0001
	MOVWF 0x39
L0062:
; 249: 		Case 1
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0063
L0061:
	MOVF 0x59,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0064
; 250: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x4D,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0065
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0002
	MOVWF 0x39
L0065:
; 251: 		Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0066
L0064:
	MOVF 0x59,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0067
; 252: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x4D,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0068
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0003
	MOVWF 0x39
L0068:
; 253: 		Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0069
L0067:
; 254: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x4D,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0070
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0004
	MOVWF 0x39
L0070:
; 255: 		EndSelect
L0069:
L0066:
L0063:
; 256: 		old_encoder = new_encoder
	MOVF 0x4D,W
	MOVWF 0x59
; 257: Return
	RETURN
; 258: 
; 259: 
; 260: adjust_settings:
L0004:
; 261: 	Gosub i2c_display_pgm
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0006
; 262: 	WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 263: 	Call relays(0)
	BCF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 264: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 265: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x4F,W
	MOVWF 0x3F
	MOVF 0x50,W
	MOVWF 0x40
; 266: 	While pgm = 0  'the program switch is still activated
L0071:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0072
; 267: 		If ecsw = 0 Then  'knob is pressed, inrease program_set
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0073
; 268: 			program_set = program_set + 1
	MOVF 0x43,W
	ADDLW 0x01
	MOVWF 0x43
; 269: 			If program_set > 9 Then  'no more than 9 items te change
	MOVF 0x43,W
	SUBLW 0x09
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0074
; 270: 				program_set = 0
	CLRF 0x43
; 271: 			Endif
L0074:
; 272: 			Gosub i2c_display_pgm
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0006
; 273: 			WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 274: 			While ecsw = 0  'be sure pushbutton is released
L0075:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0076
; 275: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 276: 			Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0075
L0076:
; 277: 		Endif
L0073:
; 278: 		Select Case program_set
; 279: 		Case 0  'correction of current position
	MOVF 0x43,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0077
; 280: 			value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 281: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 282: 			Gosub calc_rotation  'look for the knob to be turned
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 283: 			Select Case result
; 284: 			Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0078
; 285: 				If new_steps < 60000 Then
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0079
; 286: 					ena = 1  'motor on
	BSF 0x07,2
; 287: 					new_steps = new_steps + 1
	MOVF 0x3F,W
	ADDLW 0x01
	MOVWF 0x3F
	MOVF 0x40,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x40
; 288: 					direction = 1
	BSF 0x07,0
; 289: 					clk = 1  'clock out
	BSF 0x07,1
; 290: 					WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 291: 					clk = 0
	BCF 0x07,1
; 292: 					WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 293: 				Endif
L0079:
; 294: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0080
L0078:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0081
; 295: 				If new_steps > 0 Then
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0082
; 296: 					ena = 1  'motor on
	BSF 0x07,2
; 297: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x3F
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x40,W
	MOVWF 0x40
; 298: 					direction = 0
	BCF 0x07,0
; 299: 					clk = 1  'clock out
	BSF 0x07,1
; 300: 					WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 301: 					clk = 0
	BCF 0x07,1
; 302: 					WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 303: 				Endif
L0082:
; 304: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0083
L0081:
; 305: 			EndSelect
L0083:
L0080:
; 306: 		Case 1  'setting of maximum positions
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0084
L0077:
	MOVF 0x43,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0085
; 307: 			steps_set = 0
	BCF 0x48,1
; 308: 			ena = 0  'shut off motor
	BCF 0x07,2
; 309: 			value = max_pos
	MOVF 0x3C,W
	MOVWF 0x35
; 310: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 311: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 312: 			Select Case result
; 313: 			Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0086
; 314: 				Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 315: 				If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0087
; 316: 					If max_pos < 48 Then  'no more positions possible
	MOVLW 0x30
	SUBWF 0x3C,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0088
; 317: 						max_pos = max_pos + 1
	MOVF 0x3C,W
	ADDLW 0x01
	MOVWF 0x3C
; 318: 						Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0089:	BTFSC EECON1,WR
	GOTO L0089
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 319: 					Endif
L0088:
; 320: 				Endif
L0087:
; 321: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0090
L0086:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0091
; 322: 				Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 323: 				If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0092
; 324: 					If max_pos > 2 Then  'minimum 2 positions
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0093
; 325: 						max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x3C,W
	MOVWF 0x3C
; 326: 						Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0094:	BTFSC EECON1,WR
	GOTO L0094
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 327: 					Endif
L0093:
; 328: 				Endif
L0092:
; 329: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0095
L0091:
; 330: 			EndSelect
L0095:
L0090:
; 331: 		Case 2  'setting of speed interval Minimum
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0096
L0085:
	MOVF 0x43,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0097
; 332: 					'setting will be done in multiple of 256 uSecs
; 333: 					'minimum is usually not less then 5, and maximum is 99 (is real slow)
; 334: 			steps_set = 0
	BCF 0x48,1
; 335: 			ena = 0  'shut off motor
	BCF 0x07,2
; 336: 			value = speed_min.HB
	MOVF 0x33,W
	MOVWF 0x35
; 337: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 338: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 339: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 340: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0098
; 341: 				Select Case result
; 342: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0099
; 343: 					If speed_min.HB < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x33,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0100
; 344: 						speed_min.HB = speed_min.HB + 1
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x33
; 345: 						Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0101:	BTFSC EECON1,WR
	GOTO L0101
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 346: 					Endif
L0100:
; 347: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0102
L0099:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0103
; 348: 					If speed_min.HB > speed_max.HB Then
	MOVF 0x33,W
	SUBWF 0x37,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0104
; 349: 						speed_min.HB = speed_min.HB - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
; 350: 						Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0105:	BTFSC EECON1,WR
	GOTO L0105
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 351: 					Endif
L0104:
; 352: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0106
L0103:
; 353: 				EndSelect
L0106:
L0102:
; 354: 			Endif
L0098:
; 355: 		Case 3  'setting of speed interval Maximum
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0107
L0097:
	MOVF 0x43,W
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0108
; 356: 					'setting will be done in multiple of 256 uSecs
; 357: 					'minimum is 1 and maximum is 99 (is real slow)
; 358: 			steps_set = 0
	BCF 0x48,1
; 359: 			ena = 0  'shut off motor
	BCF 0x07,2
; 360: 			value = speed_max.HB
	MOVF 0x37,W
	MOVWF 0x35
; 361: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 362: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 363: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 364: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0109
; 365: 				Select Case result
; 366: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0110
; 367: 					If speed_max.HB < speed_min.HB Then  'not more then speed_min
	MOVF 0x33,W
	SUBWF 0x37,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0111
; 368: 						speed_max.HB = speed_max.HB + 1
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x37
; 369: 						Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0112:	BTFSC EECON1,WR
	GOTO L0112
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 370: 					Endif
L0111:
; 371: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0113
L0110:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0114
; 372: 					If speed_max.HB > 2 Then
	MOVF 0x37,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0115
; 373: 						speed_max.HB = speed_max.HB - 1
	MOVLW 0x01
	SUBWF 0x37,W
	MOVWF 0x37
; 374: 						Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0116:	BTFSC EECON1,WR
	GOTO L0116
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 375: 					Endif
L0115:
; 376: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0117
L0114:
; 377: 				EndSelect
L0117:
L0113:
; 378: 			Endif
L0109:
; 379: 		Case 4  'setting of ramp up and down speed
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0118
L0108:
	MOVF 0x43,W
	SUBLW 0x04
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0119
; 380: 					'speed will be the value that speed will be changed every step up and down
; 381: 			steps_set = 0
	BCF 0x48,1
; 382: 			ena = 0  'shut off motor
	BCF 0x07,2
; 383: 			value = speed_step
	MOVF 0x44,W
	MOVWF 0x35
; 384: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 385: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 386: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 387: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0120
; 388: 				Select Case result
; 389: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0121
; 390: 					If speed_step < 99 Then  'maximum 99 is possible
	MOVLW 0x63
	SUBWF 0x44,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0122
; 391: 						speed_step = speed_step + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
; 392: 						Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0123:	BTFSC EECON1,WR
	GOTO L0123
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 393: 					Endif
L0122:
; 394: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0124
L0121:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0125
; 395: 					If speed_step > 1 Then
	MOVF 0x44,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0126
; 396: 						speed_step = speed_step - 1
	MOVLW 0x01
	SUBWF 0x44,W
	MOVWF 0x44
; 397: 						Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0127:	BTFSC EECON1,WR
	GOTO L0127
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 398: 					Endif
L0126:
; 399: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0128
L0125:
; 400: 				EndSelect
L0128:
L0124:
; 401: 			Endif
L0120:
; 402: 	
; 403: 		Case 5  'setting of extra free space steps
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0129
L0119:
	MOVF 0x43,W
	SUBLW 0x05
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0130
; 404: 			steps_set = 0
	BCF 0x48,1
; 405: 			ena = 0  'shut off motor
	BCF 0x07,2
; 406: 			If free_space_steps > 250 Then
	MOVF 0x3D,W
	SUBLW 0xFA
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0131
; 407: 				free_space_steps = 250
	MOVLW 0xFA
	MOVWF 0x3D
; 408: 				Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0132:	BTFSC EECON1,WR
	GOTO L0132
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 409: 			Endif
L0131:
; 410: 			value = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x35
; 411: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 412: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 413: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 414: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0133
; 415: 				Select Case result
; 416: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0134
; 417: 					If free_space_steps < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x3D,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0135
; 418: 						free_space_steps = free_space_steps + 1
	MOVF 0x3D,W
	ADDLW 0x01
	MOVWF 0x3D
; 419: 						Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0136:	BTFSC EECON1,WR
	GOTO L0136
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 420: 					Endif
L0135:
; 421: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0137
L0134:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0138
; 422: 					If free_space_steps > 0 Then
	MOVF 0x3D,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0139
; 423: 						free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
; 424: 						Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0140:	BTFSC EECON1,WR
	GOTO L0140
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 425: 					Endif
L0139:
; 426: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0141
L0138:
; 427: 				EndSelect
L0141:
L0137:
; 428: 			Endif
L0133:
; 429: 		Case 6  'at which postion is in bridge reversed power
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0142
L0130:
	MOVF 0x43,W
	SUBLW 0x06
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0143
; 430: 			steps_set = 0
	BCF 0x48,1
; 431: 			ena = 0  'shut off motor
	BCF 0x07,2
; 432: 			steps_set = 0
	BCF 0x48,1
; 433: 			ena = 0  'shut off motor
	BCF 0x07,2
; 434: 			value = bridge_rev_pos
	MOVF 0x42,W
	MOVWF 0x35
; 435: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 436: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 437: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 438: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0144
; 439: 				Select Case result
; 440: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0145
; 441: 					If bridge_rev_pos < max_pos Then  'no more positions possible
	MOVF 0x3C,W
	SUBWF 0x42,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0146
; 442: 						bridge_rev_pos = bridge_rev_pos + 1
	MOVF 0x42,W
	ADDLW 0x01
	MOVWF 0x42
; 443: 						Write mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0147:	BTFSC EECON1,WR
	GOTO L0147
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 444: 					Endif
L0146:
; 445: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0148
L0145:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0149
; 446: 					If bridge_rev_pos > 0 Then  '0 does not effect reversing
	MOVF 0x42,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0150
; 447: 						bridge_rev_pos = bridge_rev_pos - 1
	MOVLW 0x01
	SUBWF 0x42,W
	MOVWF 0x42
; 448: 						Write mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0151:	BTFSC EECON1,WR
	GOTO L0151
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 449: 					Endif
L0150:
; 450: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0152
L0149:
; 451: 				EndSelect
L0152:
L0148:
; 452: 			Endif
L0144:
; 453: 		Case 7  'setting if power should be on or off while bridge is moving (0 = off)
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0153
L0143:
	MOVF 0x43,W
	SUBLW 0x07
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0154
; 454: 			Read mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x49
; 455: 			If bridge_power > 1 Then
	MOVF 0x49,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0155
; 456: 				bridge_power = 1
	MOVLW 0x01
	MOVWF 0x49
; 457: 			Endif
L0155:
; 458: 			value = bridge_power
	MOVF 0x49,W
	MOVWF 0x35
; 459: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 460: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 461: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 462: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0156
; 463: 				Select Case result
; 464: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0157
; 465: 					bridge_power = 1
	MOVLW 0x01
	MOVWF 0x49
; 466: 					Write mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x49,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0158:	BTFSC EECON1,WR
	GOTO L0158
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 467: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0159
L0157:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0160
; 468: 					bridge_power = 0
	CLRF 0x49
; 469: 					Write mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x49,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0161:	BTFSC EECON1,WR
	GOTO L0161
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 470: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0162
L0160:
; 471: 				EndSelect
L0162:
L0159:
; 472: 			Endif
L0156:
; 473: 		Case 8  'setting delay in millisecs before tt is ready is sent)
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0163
L0154:
	MOVF 0x43,W
	SUBLW 0x08
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0164
; 474: 			Read mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 475: 			If pos_match_delay > 50 Then
	MOVF 0x41,W
	SUBLW 0x32
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0165
; 476: 				pos_match_delay = 50
	MOVLW 0x32
	MOVWF 0x41
; 477: 			Endif
L0165:
; 478: 			value = pos_match_delay
	MOVF 0x41,W
	MOVWF 0x35
; 479: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 480: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 481: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 482: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0166
; 483: 				Select Case result
; 484: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0167
; 485: 					If pos_match_delay < 50 Then
	MOVLW 0x32
	SUBWF 0x41,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0168
; 486: 						pos_match_delay = pos_match_delay + 1
	MOVF 0x41,W
	ADDLW 0x01
	MOVWF 0x41
; 487: 					Endif
L0168:
; 488: 					Write mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0169:	BTFSC EECON1,WR
	GOTO L0169
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 489: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0170
L0167:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0171
; 490: 					If pos_match_delay > 0 Then
	MOVF 0x41,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0172
; 491: 						pos_match_delay = pos_match_delay - 1
	MOVLW 0x01
	SUBWF 0x41,W
	MOVWF 0x41
; 492: 					Endif
L0172:
; 493: 					Write mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0173:	BTFSC EECON1,WR
	GOTO L0173
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 494: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0174
L0171:
; 495: 				EndSelect
L0174:
L0170:
; 496: 			Endif
L0166:
; 497: 		Case Else  'menu 9 , setting control type
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0175
L0164:
; 498: 			steps_set = 0
	BCF 0x48,1
; 499: 			ena = 0  'shut off motor
	BCF 0x07,2
; 500: 			If ctrl_type > 4 Then
	MOVF 0x3E,W
	SUBLW 0x04
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0176
; 501: 				ctrl_type = 4
	MOVLW 0x04
	MOVWF 0x3E
; 502: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0177:	BTFSC EECON1,WR
	GOTO L0177
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 503: 			Endif
L0176:
; 504: 			value = ctrl_type
	MOVF 0x3E,W
	MOVWF 0x35
; 505: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 506: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 507: 			Call check_encoder_count()
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0018
; 508: 			If proceed = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x48,0
	GOTO L0178
; 509: 				Select Case result
; 510: 				Case 1
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0179
; 511: 					If ctrl_type < 4 Then
	MOVLW 0x04
	SUBWF 0x3E,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0180
; 512: 						ctrl_type = ctrl_type + 1
	MOVF 0x3E,W
	ADDLW 0x01
	MOVWF 0x3E
; 513: 						Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0181:	BTFSC EECON1,WR
	GOTO L0181
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 514: 					Endif
L0180:
; 515: 				Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0182
L0179:
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0183
; 516: 					If ctrl_type > 1 Then
	MOVF 0x3E,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0184
; 517: 						ctrl_type = ctrl_type - 1
	MOVLW 0x01
	SUBWF 0x3E,W
	MOVWF 0x3E
; 518: 						Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0185:	BTFSC EECON1,WR
	GOTO L0185
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 519: 					Endif
L0184:
; 520: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0186
L0183:
; 521: 				EndSelect
L0186:
L0182:
; 522: 			Endif
L0178:
; 523: 		EndSelect
L0175:
L0163:
L0153:
L0142:
L0129:
L0118:
L0107:
L0096:
L0084:
; 524: 		WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 525: 	Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0071
L0072:
; 526: 	ena = 0  'shut off motor
	BCF 0x07,2
; 527: 		'***************   now check if changes have to BE written in eeprom
; 528: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	MOVF 0x4F,W
	MOVWF R1L
	MOVF 0x50,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C002
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0187
; 529: 		Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 530: 	Endif
L0187:
; 531: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 532: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 533: 	Call relays(1)
	BSF 0x48,2
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0017
; 534: Return
	RETURN
; 535: 
; 536: i2c_display:
L0005:
; 537: 	Select Case value
; 538: 	Case 99
	MOVF 0x35,W
	SUBLW 0x63
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0188
; 539: 		disp1_val = %10111111
	MOVLW 0xBF
	MOVWF 0x4C
; 540: 		disp2_val = %10111111
	MOVLW 0xBF
	MOVWF 0x52
; 541: 	Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0189
L0188:
; 542: 		disp1_val = value
	MOVF 0x35,W
	MOVWF 0x4C
; 543: 		disp1_val = disp1_val Mod 10
	MOVF 0x4C,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x4C
; 544: 		disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x4C,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0190
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0005
	MOVWF 0x4C
L0190:
; 545: 		disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x4C,7
	BTFSS 0x07,7
	BCF 0x4C,7
; 546: 		disp2_val = value
	MOVF 0x35,W
	MOVWF 0x52
; 547: 		disp2_val = disp2_val / 10
	MOVF 0x52,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x52
; 548: 		disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x52,W
	MOVWF R0L
	SUBLW 0x0A
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0191
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0006
	MOVWF 0x52
L0191:
; 549: 		disp2_val.7 = version
	BTFSC 0x48,3
	BSF 0x52,7
	BTFSS 0x48,3
	BCF 0x52,7
; 550: 	EndSelect
L0189:
; 551: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 552: 	I2CSend disp1
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 553: 	I2CSend disp1_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x4C,W
	CALL IC01
; 554: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 555: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 556: 	I2CSend disp2
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 557: 	I2CSend disp2_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x52,W
	CALL IC01
; 558: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 559: Return
	RETURN
; 560: 
; 561: i2c_display_pgm:
L0006:
; 562: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), program_set
	MOVF 0x43,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0192
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0007
	MOVWF 0x4C
L0192:
; 563: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 564: 	I2CSend disp1
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 565: 	I2CSend disp1_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x4C,W
	CALL IC01
; 566: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 567: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 568: 	I2CSend disp2
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 569: 	I2CSend %10111111
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 570: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 571: Return
	RETURN
; 572: 
; 573: stepmotor:
L0007:
; 574: 	speed = 0
	CLRF 0x4A
	CLRF 0x4B
; 575: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 576: 	Select Case new_pos
; 577: 	Case 62  'this is the manual setting for each position
	MOVF 0x46,W
	SUBLW 0x3E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0193
; 578: 'this position is equal for all control types, except for max switch
; 579: 'in case of control type < 6 the zero switch is used for total steps calculation
; 580: 'and bridge will run one full round extra.
; 581: 		direction = 0  'first backward
	BCF 0x07,0
; 582: 		ena = 1  'motor on
	BSF 0x07,2
; 583: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 584: 		Call run_to_zero_switch(1, 0)
	BSF 0x48,4
	BCF 0x48,7
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 585: 		ena = 0  'motor off
	BCF 0x07,2
; 586: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 587: 		one_round = 0  'start counting steps to max pos
	CLRF 0x3A
	CLRF 0x3B
; 588: 		ena = 1  'motor on
	BSF 0x07,2
; 589: 		act_pos = 1
	MOVLW 0x01
	MOVWF 0x34
; 590: 		If ctrl_type < 4 Then  'now extra round to be made to calculate total steps
	MOVLW 0x04
	SUBWF 0x3E,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0194
; 591: 			Call run_to_zero_switch(0, 1)  'RUN TO ZERO SWITCH AND COUNT STEPS
	BCF 0x48,4
	BSF 0x48,7
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 592: 			Call run_to_zero_switch(1, 1)  'RUN TO ZERO SWITCH AND COUNT STEPS
	BSF 0x48,4
	BSF 0x48,7
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 593: 		Endif
L0194:
; 594: 		Write mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0195:	BTFSC EECON1,WR
	GOTO L0195
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 595: 		Write mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0196:	BTFSC EECON1,WR
	GOTO L0196
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 596: 		one_round_half = one_round / 2
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x57
	MOVF R0H,W
	MOVWF 0x58
; 597: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 598: 		direction = 1  'run forward
	BSF 0x07,0
; 599: 		value = 0  'WE ARE IN ZERO POSITION NOW
	CLRF 0x35
; 600: 		Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 601: 		one_round = 0  'temporary use variable to count individual postitions
	CLRF 0x3A
	CLRF 0x3B
; 602: 		While act_pos <= max_pos  'turn motor until max pos is reached
L0197:
	MOVF 0x34,W
	SUBWF 0x3C,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0198
; 603: 				clk = 1  'clock out
	BSF 0x07,1
; 604: 				WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 605: 				clk = 0
	BCF 0x07,1
; 606: 				WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 607: 				one_round = one_round + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
	MOVF 0x3B,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3B
; 608: 				If ecsw = 0 Then  'knob is pressed, save position and increase act_pos
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x07,6
	GOTO L0199
; 609: 					new_steps = one_round
	MOVF 0x3A,W
	MOVWF 0x3F
	MOVF 0x3B,W
	MOVWF 0x40
; 610: 					Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 611: 					value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 612: 					Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 613: 					act_pos = act_pos + 1
	MOVF 0x34,W
	ADDLW 0x01
	MOVWF 0x34
; 614: 					WaitMs 500  'give some time to breeze
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 615: 					While ecsw = 0  'Check If knob is Not pressed
L0200:
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x07,6
	GOTO L0201
; 616: 					Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0200
L0201:
; 617: 				Endif
L0199:
; 618: 				If ctrl_type = 4 Then  'for FY , max limit switch is to be checked.
	MOVF 0x3E,W
	SUBLW 0x04
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0202
; 619: 					If max_end = 0 Then  'end switch for fy is touched, end cycle
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x06,7
	GOTO L0203
; 620: 						act_pos = max_pos + 1  'cancel the procedure
	MOVF 0x3C,W
	ADDLW 0x01
	MOVWF 0x34
; 621: 						ena = 0
	BCF 0x07,2
; 622: 					Endif
L0203:
; 623: 				Endif
L0202:
; 624: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0197
L0198:
; 625: 		Write mem_turn_counter, 127  'reset turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x7F
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0204:	BTFSC EECON1,WR
	GOTO L0204
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 626: 		Read mem_one_round_lb, one_round.LB  'put stored value back in one_round
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3A
; 627: 		Read mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3B
; 628: 		direction = 0  'goto to zero switch
	BCF 0x07,0
; 629: 		ena = 1  'set anable on
	BSF 0x07,2
; 630: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 631: 		Call run_to_zero_switch(1, 0)
	BSF 0x48,4
	BCF 0x48,7
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 632: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 633: 		act_pos = 0
	CLRF 0x34
; 634: 		new_pos = 1
	MOVLW 0x01
	MOVWF 0x46
; 635: 		Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 636: 		direction = 1  'now forwards
	BSF 0x07,0
; 637: 		steps = new_steps + free_space_steps
	MOVF 0x3F,W
	ADDWF 0x3D,W
	MOVWF 0x30
	MOVF 0x40,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x31
; 638: 		ramp_up = 1
	BSF 0x48,5
; 639: 		ramp_down_point = 0
	CLRF 0x55
	CLRF 0x56
; 640: 		half_steps = steps / 2
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x5C
	MOVF R0H,W
	MOVWF 0x5D
; 641: 		ena = 1  'set Enable on
	BSF 0x07,2
; 642: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 643: 		Call run_to_zero(speed_min, 0)
	MOVF 0x32,W
	MOVWF 0x53
	MOVF 0x33,W
	MOVWF 0x54
	BCF 0x48,6
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 644: 		WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 645: 		steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x30
	CLRF 0x31
; 646: 		direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 647: 		Call run_to_zero(speed_min, 0)
	MOVF 0x32,W
	MOVWF 0x53
	MOVF 0x33,W
	MOVWF 0x54
	BCF 0x48,6
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 648: 		ena = 0  'enable off
	BCF 0x07,2
; 649: 	Case 63  'go to zero switch and then to 1st rail position (Pos 1)
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0205
L0193:
	MOVF 0x46,W
	SUBLW 0x3F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0206
; 650: 		direction = 0  'goto to zero switch
	BCF 0x07,0
; 651: 		ena = 1  'set anable on
	BSF 0x07,2
; 652: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 653: 		Call run_to_zero_switch(1, 0)
	BSF 0x48,4
	BCF 0x48,7
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 654: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 655: 		new_pos = 1
	MOVLW 0x01
	MOVWF 0x46
; 656: 		Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 657: 		direction = 1  'now forwards
	BSF 0x07,0
; 658: 		steps = new_steps + free_space_steps
	MOVF 0x3F,W
	ADDWF 0x3D,W
	MOVWF 0x30
	MOVF 0x40,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x31
; 659: 		ramp_up = 1
	BSF 0x48,5
; 660: 		ramp_down_point = 0
	CLRF 0x55
	CLRF 0x56
; 661: 		half_steps = steps / 2
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x5C
	MOVF R0H,W
	MOVWF 0x5D
; 662: 		speed = speed_min
	MOVF 0x32,W
	MOVWF 0x4A
	MOVF 0x33,W
	MOVWF 0x4B
; 663: 		ena = 1  'set Enable on
	BSF 0x07,2
; 664: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 665: 		Call run_to_zero(speed_min, 1)
	MOVF 0x32,W
	MOVWF 0x53
	MOVF 0x33,W
	MOVWF 0x54
	BSF 0x48,6
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 666: 		WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 667: 		steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x30
	CLRF 0x31
; 668: 		direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 669: 		Call run_to_zero(speed_min, 1)
	MOVF 0x32,W
	MOVWF 0x53
	MOVF 0x33,W
	MOVWF 0x54
	BSF 0x48,6
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 670: 		ena = 0  'enable off
	BCF 0x07,2
; 671: 	Case Else  'this is the normal position sequence
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0207
L0206:
; 672: 		steps = 0
	CLRF 0x30
	CLRF 0x31
; 673: 		one_round_half = one_round / 2
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x57
	MOVF R0H,W
	MOVWF 0x58
; 674: 		If new_steps > act_steps Then
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	MOVF 0x4F,W
	MOVWF R1L
	MOVF 0x50,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0208
; 675: 			steps = new_steps - act_steps
	MOVF 0x4F,W
	SUBWF 0x3F,W
	MOVWF 0x30
	MOVF 0x50,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x40,W
	MOVWF 0x31
; 676: 			direction = 1
	BSF 0x07,0
; 677: 			Gosub check_0_pass_allowed
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 678: 		Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0209
L0208:
; 679: 			steps = act_steps - new_steps
	MOVF 0x3F,W
	SUBWF 0x4F,W
	MOVWF 0x30
	MOVF 0x40,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x50,W
	MOVWF 0x31
; 680: 			direction = 0
	BCF 0x07,0
; 681: 			Gosub check_0_pass_allowed
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 682: 		Endif
L0209:
; 683: 		If steps > 0 Then  'motor must be activated
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0210
; 684: 			If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0211
; 685: 				steps = steps + free_space_steps
	MOVF 0x30,W
	ADDWF 0x3D,W
	MOVWF 0x30
	MOVF 0x31,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x31
; 686: 			Endif
L0211:
; 687: 			ramp_up = 1
	BSF 0x48,5
; 688: 			ramp_down_point = 0
	CLRF 0x55
	CLRF 0x56
; 689: 			half_steps = steps / 2
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x5C
	MOVF R0H,W
	MOVWF 0x5D
; 690: 			speed = speed_min
	MOVF 0x32,W
	MOVWF 0x4A
	MOVF 0x33,W
	MOVWF 0x4B
; 691: 			ena = 1  'set anable on
	BSF 0x07,2
; 692: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 693: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0212:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0213
; 694: 				clk = 1  'clock out
	BSF 0x07,1
; 695: 				WaitUs speed
	MOVF 0x4A,W
	MOVWF R4L
	MOVF 0x4B,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 696: 				clk = 0
	BCF 0x07,1
; 697: 				WaitUs speed
	MOVF 0x4A,W
	MOVWF R4L
	MOVF 0x4B,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 698: 				Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 699: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 700: 				If ctrl_type = 4 Then  'only for fiddle yard
	MOVF 0x3E,W
	SUBLW 0x04
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0214
; 701: 					If max_end = 0 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x06,7
	GOTO L0215
; 702: 						Gosub stop_the_motor
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 703: 					Endif
L0215:
; 704: 				Endif
L0214:
; 705: 			Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0212
L0213:
; 706: 			If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0216
; 707: 				If free_space_steps > 0 Then
	MOVF 0x3D,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0217
; 708: 					WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 709: 					steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x30
	CLRF 0x31
; 710: 					direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 711: 					Call run_to_zero(speed_min, 0)
	MOVF 0x32,W
	MOVWF 0x53
	MOVF 0x33,W
	MOVWF 0x54
	BCF 0x48,6
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 712: 				Endif
L0217:
; 713: 			Endif
L0216:
; 714: 			ena = 0  'enable off
	BCF 0x07,2
; 715: 		Endif
L0210:
; 716: 	EndSelect
L0207:
L0205:
; 717: 	act_pos = new_pos
	MOVF 0x46,W
	MOVWF 0x34
; 718: 	Write mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0218:	BTFSC EECON1,WR
	GOTO L0218
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 719: 	bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x51
; 720: 	old_bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x5E
; 721: 	manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x38
; 722: 	old_manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x5A
; 723: 
; 724: Return
	RETURN
; 725: 
; 726: check_0_pass_allowed:
L0008:
; 727: 	If steps > one_round_half Then
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVF 0x57,W
	MOVWF R1L
	MOVF 0x58,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0219
; 728: 		Select Case ctrl_type
; 729: 		Case 2  'crossing zero possible but only if not too many turns in one direction
	MOVF 0x3E,W
	SUBLW 0x02
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0220
; 730: 			If steps > one_round_half Then
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVF 0x57,W
	MOVWF R1L
	MOVF 0x58,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0221
; 731: 				Read mem_turn_counter, turn_counter  'get the total turns
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x4E
; 732: 				If turn_counter > 124 And direction = 1 Then  'extra round in direction 0 allowed
	MOVF 0x4E,W
	SUBLW 0x7C
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0222
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0222
; 733: 					turn_counter = turn_counter - 1  'substract 1 pass
	MOVLW 0x01
	SUBWF 0x4E,W
	MOVWF 0x4E
; 734: 					Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x4E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0223:	BTFSC EECON1,WR
	GOTO L0223
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 735: 					direction = 0  'change direction
	BCF 0x07,0
; 736: 					steps = one_round - steps  'set the number of steps for the other direction
	MOVF 0x30,W
	SUBWF 0x3A,W
	MOVWF 0x30
	MOVF 0x31,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x31
; 737: 				Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0224
L0222:
; 738: 					If turn_counter < 130 And direction = 0 Then  'extra round in direction 1 allowed
	MOVLW 0x82
	SUBWF 0x4E,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0225
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x07,0
	GOTO L0225
; 739: 						turn_counter = turn_counter + 1
	MOVF 0x4E,W
	ADDLW 0x01
	MOVWF 0x4E
; 740: 						Write mem_turn_counter, turn_counter  'add 1 pass
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x4E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0226:	BTFSC EECON1,WR
	GOTO L0226
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 741: 						direction = 1  'change direction
	BSF 0x07,0
; 742: 						steps = one_round - steps  'set the number of steps for the other direction
	MOVF 0x30,W
	SUBWF 0x3A,W
	MOVWF 0x30
	MOVF 0x31,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x31
; 743: 					Endif
L0225:
; 744: 				Endif
L0224:
; 745: 			Endif
L0221:
; 746: 		Case 3  'crossing zero always possible
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0227
L0220:
	MOVF 0x3E,W
	SUBLW 0x03
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0228
; 747: 			direction = Not direction  'change direction
	MOVLW 0x01
	XORWF 0x07,F
; 748: 			steps = one_round - steps  'set the number of steps for the other direction
	MOVF 0x30,W
	SUBWF 0x3A,W
	MOVWF 0x30
	MOVF 0x31,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x31
; 749: 		Case Else  'no zero crossing allowed
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0229
L0228:
; 750: 		EndSelect
L0229:
L0227:
; 751: 	Endif
L0219:
; 752: Return
	RETURN
; 753: 
; 754: 
; 755: speed_calc:
L0009:
; 756: 	If steps < half_steps Then  'at this point  ramp up MUST end half way
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVF 0x5C,W
	MOVWF R1L
	MOVF 0x5D,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0230
; 757: 		ramp_up = 0
	BCF 0x48,5
; 758: 	Endif
L0230:
; 759: 	If ramp_up = 1 Then  'we were supposed to ramp up
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x48,5
	GOTO L0231
; 760: 		If speed > speed_max Then
	MOVF 0x4A,W
	MOVWF R0L
	MOVF 0x4B,W
	MOVWF R0H
	MOVF 0x36,W
	MOVWF R1L
	MOVF 0x37,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0232
; 761: 			speed = speed - speed_step
	MOVF 0x44,W
	SUBWF 0x4A,W
	MOVWF 0x4A
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x4B,W
	MOVWF 0x4B
; 762: 			ramp_down_point = ramp_down_point + 1  'this counts down with the steps
	MOVF 0x55,W
	ADDLW 0x01
	MOVWF 0x55
	MOVF 0x56,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x56
; 763: 		Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0233
L0232:
; 764: 			ramp_up = 0
	BCF 0x48,5
; 765: 		Endif
L0233:
; 766: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0234
L0231:
; 767: 		If steps < ramp_down_point Then  'this is the point tot start ramp down
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVF 0x55,W
	MOVWF R1L
	MOVF 0x56,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0235
; 768: 			If speed < speed_min Then
	MOVF 0x4A,W
	MOVWF R0L
	MOVF 0x4B,W
	MOVWF R0H
	MOVF 0x32,W
	MOVWF R1L
	MOVF 0x33,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0236
; 769: 				speed = speed + speed_step
	MOVF 0x4A,W
	ADDWF 0x44,W
	MOVWF 0x4A
	MOVF 0x4B,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x4B
; 770: 			Endif
L0236:
; 771: 		Endif
L0235:
; 772: 	Endif
L0234:
; 773: Return
	RETURN
; 774: 
; 775: 
; 776: 
; 777: init_values:
L0010:
; 778: 	value = 73  'version number
	MOVLW 0x49
	MOVWF 0x35
; 779: 	version = 0  'decimal point in display on
	BCF 0x48,3
; 780: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 781: 	WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 782: 	version = 1  'decimal point in display off
	BSF 0x48,3
; 783: 	encoder_count = 0
	CLRF 0x45
; 784: 	speed_min = 0
	CLRF 0x32
	CLRF 0x33
; 785: 	
; 786: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3E
; 787: 	If ctrl_type > 4 Or ctrl_type = 0 Then
	MOVF 0x3E,W
	SUBLW 0x04
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0239
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0238
L0239:
	MOVF 0x3E,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0237
L0238:
; 788: 		ctrl_type = 1
	MOVLW 0x01
	MOVWF 0x3E
; 789: 		Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0240:	BTFSC EECON1,WR
	GOTO L0240
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 790: 	Endif
L0237:
; 791: 	
; 792: 	Read mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 793: 	If speed_min.HB > 99 Then
	MOVF 0x33,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0241
; 794: 		speed_min.HB = 30
	MOVLW 0x1E
	MOVWF 0x33
; 795: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0242
L0241:
; 796: 		If speed_min.HB < 2 Then
	MOVLW 0x02
	SUBWF 0x33,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0243
; 797: 			speed_min.HB = 20
	MOVLW 0x14
	MOVWF 0x33
; 798: 		Endif
L0243:
; 799: 	Endif
L0242:
; 800: 
; 801: 	Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0244:	BTFSC EECON1,WR
	GOTO L0244
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 802: 	speed_max = 0
	CLRF 0x36
	CLRF 0x37
; 803: 	Read mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 804: 	If speed_max.HB > speed_min.HB Then
	MOVF 0x37,W
	SUBWF 0x33,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0245
; 805: 		speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x37
; 806: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0246
L0245:
; 807: 		If speed_max.HB < 2 Then
	MOVLW 0x02
	SUBWF 0x37,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0247
; 808: 			speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x37
; 809: 		Endif
L0247:
; 810: 	Endif
L0246:
; 811: 	Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0248:	BTFSC EECON1,WR
	GOTO L0248
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 812: 
; 813: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3A
; 814: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3B
; 815: 	If one_round = 0 Then
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0249
; 816: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x3A
	MOVLW 0x1F
	MOVWF 0x3B
; 817: 	Endif
L0249:
; 818: 	If one_round > 60000 Then
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0250
; 819: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x3A
	MOVLW 0x1F
	MOVWF 0x3B
; 820: 	Endif
L0250:
; 821: 	one_round_half = one_round / 2
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x57
	MOVF R0H,W
	MOVWF 0x58
; 822: 
; 823: 	Read mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3C
; 824: 	If max_pos > 48 Or max_pos < 2 Then
	MOVF 0x3C,W
	SUBLW 0x30
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0253
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0252
L0253:
	MOVLW 0x02
	SUBWF 0x3C,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0251
L0252:
; 825: 		max_pos = 20
	MOVLW 0x14
	MOVWF 0x3C
; 826: 		bridge_rev_pos = 10
	MOVLW 0x0A
	MOVWF 0x42
; 827: 		Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0254:	BTFSC EECON1,WR
	GOTO L0254
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 828: 		Write mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0255:	BTFSC EECON1,WR
	GOTO L0255
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 829: 	Endif
L0251:
; 830: 	
; 831: 	Read mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x42
; 832: 	If bridge_rev_pos > max_pos Then
	MOVF 0x42,W
	SUBWF 0x3C,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0256
; 833: 		bridge_rev_pos = max_pos / 2
	MOVF 0x3C,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x42
; 834: 		Write mem_bridge_rev_pos, bridge_rev_pos
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0257:	BTFSC EECON1,WR
	GOTO L0257
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 835: 	Endif
L0256:
; 836: 	
; 837: 	Read mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 838: 	If act_pos > max_pos Then
	MOVF 0x34,W
	SUBWF 0x3C,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0258
; 839: 		act_pos = 1
	MOVLW 0x01
	MOVWF 0x34
; 840: 		Write mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0259:	BTFSC EECON1,WR
	GOTO L0259
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 841: 	Endif
L0258:
; 842: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 843: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 844: 	Read mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3D
; 845: 	If free_space_steps > 99 Then
	MOVF 0x3D,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0260
; 846: 		free_space_steps = 50
	MOVLW 0x32
	MOVWF 0x3D
; 847: 	Endif
L0260:
; 848: 	Read mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 849: 	If pos_match_delay > 50 Then
	MOVF 0x41,W
	SUBLW 0x32
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0261
; 850: 		pos_match_delay = 10
	MOVLW 0x0A
	MOVWF 0x41
; 851: 	Endif
L0261:
; 852: 	
; 853: 	Read mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x44
; 854: 	If speed_step > 99 Then
	MOVF 0x44,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0262
; 855: 		speed_step = 20
	MOVLW 0x14
	MOVWF 0x44
; 856: 	Endif
L0262:
; 857: 	steps_set = 0
	BCF 0x48,1
; 858: 	new_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x46
; 859: 	bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x51
; 860: 	old_bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x5E
; 861: 	manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x38
; 862: 	old_manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x5A
; 863: 	old_pos_write = 1
	BSF 0x5B,0
; 864: Return
	RETURN
; 865: 
; 866: steps_reading:
L0011:
; 867: 	Select Case act_pos
; 868: 	Case 63, 62
	MOVF 0x34,W
	SUBLW 0x3F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0265
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0264
L0265:
	MOVF 0x34,W
	SUBLW 0x3E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0263
L0264:
; 869: 		act_steps = 0
	CLRF 0x4F
	CLRF 0x50
; 870: 	Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0266
L0263:
; 871: 		eprom_pointer = act_pos
	MOVF 0x34,W
	MOVWF 0x47
; 872: 		eprom_pointer = eprom_pointer + 48
	MOVF 0x47,W
	ADDLW 0x30
	MOVWF 0x47
; 873: 		Read act_pos, act_steps.LB
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x4F
; 874: 		Read eprom_pointer, act_steps.HB
	MOVF 0x47,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x50
; 875: 	EndSelect
L0266:
; 876: 	Select Case new_pos
; 877: 	Case 62, 63
	MOVF 0x46,W
	SUBLW 0x3E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0269
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0268
L0269:
	MOVF 0x46,W
	SUBLW 0x3F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0267
L0268:
; 878: 		new_steps = 0
	CLRF 0x3F
	CLRF 0x40
; 879: 	Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0270
L0267:
; 880: 		eprom_pointer = new_pos
	MOVF 0x46,W
	MOVWF 0x47
; 881: 		eprom_pointer = eprom_pointer + 48
	MOVF 0x47,W
	ADDLW 0x30
	MOVWF 0x47
; 882: 		Read new_pos, new_steps.LB
	MOVF 0x46,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 883: 		Read eprom_pointer, new_steps.HB
	MOVF 0x47,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 884: 	EndSelect
L0270:
; 885: Return
	RETURN
; 886: 
; 887: 
; 888: save_steps:
L0012:
; 889: 	eprom_pointer = act_pos
	MOVF 0x34,W
	MOVWF 0x47
; 890: 	eprom_pointer = eprom_pointer + 48
	MOVF 0x47,W
	ADDLW 0x30
	MOVWF 0x47
; 891: 	Write act_pos, new_steps.LB
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0271:	BTFSC EECON1,WR
	GOTO L0271
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 892: 	Write eprom_pointer, new_steps.HB
	MOVF 0x47,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0272:	BTFSC EECON1,WR
	GOTO L0272
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 893: Return
	RETURN
; 894: 
; 895: 
; 896: stop_the_motor:
L0013:
; 897: 	ena = 0  'set anable oFF
	BCF 0x07,2
; 898: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 899: 	version = 0  'decimal point in display on
	BCF 0x48,3
; 900: 	While ecsw = 1
L0273:
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,6
	GOTO L0274
; 901: 		WaitMs 250
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 902: 		Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 903: 		version = Not version
	MOVLW 0x08
	XORWF 0x48,F
; 904: 	Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0273
L0274:
; 905: 	version = 1  'decimal point off
	BSF 0x48,3
; 906: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 907: 	ena = 1  'set anable on
	BSF 0x07,2
; 908: Return
	RETURN
; 909: wait_pos_match:
L0014:
; 910: 	value = 99
	MOVLW 0x63
	MOVWF 0x35
; 911: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 912: 	steps = pos_match_delay * 100
	MOVF 0x41,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x30
	MOVF R2H,W
	MOVWF 0x31
; 913: 	WaitMs steps
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 914: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 915: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 916: 	pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 917: Return
	RETURN
; 918: Proc run_to_zero(speed As Word, calc As Bit)
L0015:
; 919: 	While steps > 0  'NOW RUN UNTIL STEPS = 0
L0275:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0276
; 920: 		If calc = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x48,6
	GOTO L0277
; 921: 			Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 922: 		Endif
L0277:
; 923: 		
; 924: 		clk = 1  'clock out
	BSF 0x07,1
; 925: 		WaitUs speed
	MOVF 0x53,W
	MOVWF R4L
	MOVF 0x54,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 926: 		clk = 0
	BCF 0x07,1
; 927: 		WaitUs speed
	MOVF 0x53,W
	MOVWF R4L
	MOVF 0x54,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 928: 		Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 929: 		steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 930: 	Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0275
L0276:
; 931: 
; 932: End Proc
	RETURN
; 933: Proc run_to_zero_switch(bitposition As Bit, counting As Bit)
L0016:
; 934: 	If counting = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x48,7
	GOTO L0278
; 935: 		While zero = bitposition  'NOW RUN UNTIL switch is activated
L0279:
	CLRW
	BTFSC 0x06,6
	ADDLW 0x01
	BTFSC 0x48,4
	SUBLW 0x01
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0280
; 936: 			clk = 1  'clock out
	BSF 0x07,1
; 937: 			WaitUs speed_max
	MOVF 0x36,W
	MOVWF R4L
	MOVF 0x37,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 938: 			clk = 0
	BCF 0x07,1
; 939: 			WaitUs speed_max
	MOVF 0x36,W
	MOVWF R4L
	MOVF 0x37,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 940: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 941: 			one_round = one_round + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
	MOVF 0x3B,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3B
; 942: 		Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0279
L0280:
; 943: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0281
L0278:
; 944: 		While zero = bitposition  'NOW RUN UNTIL switch is activated
L0282:
	CLRW
	BTFSC 0x06,6
	ADDLW 0x01
	BTFSC 0x48,4
	SUBLW 0x01
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0283
; 945: 			clk = 1  'clock out
	BSF 0x07,1
; 946: 			WaitUs speed_max
	MOVF 0x36,W
	MOVWF R4L
	MOVF 0x37,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 947: 			clk = 0
	BCF 0x07,1
; 948: 			WaitUs speed_max
	MOVF 0x36,W
	MOVWF R4L
	MOVF 0x37,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 949: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 950: 		Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0282
L0283:
; 951: 	Endif
L0281:
; 952: End Proc
	RETURN
; 953: 
; 954: Proc relays(onoff As Bit)
L0017:
; 955: 		If act_pos < bridge_rev_pos Or bridge_rev_pos = 0 Then  'just normal Bridge power (if allowed)
	MOVF 0x42,W
	SUBWF 0x34,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0286
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0285
L0286:
	MOVF 0x42,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0284
L0285:
; 956: 			swfw = 0
	BCF 0x06,0
; 957: 			WaitMs 100  'just wait for the relay to drop
	MOVLW 0x64
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 958: 			If onoff = 0 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x48,2
	GOTO L0287
; 959: 				swrev = bridge_power.0
	BTFSC 0x49,0
	BSF 0x06,1
	BTFSS 0x49,0
	BCF 0x06,1
; 960: 			Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0288
L0287:
; 961: 				swrev = 1
	BSF 0x06,1
; 962: 			Endif
L0288:
; 963: 		Else  'inverse bridge power (if allowed)
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0289
L0284:
; 964: 			swrev = 0
	BCF 0x06,1
; 965: 			WaitMs 100  'just wait for the relay to drop
	MOVLW 0x64
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 966: 			If onoff = 0 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x48,2
	GOTO L0290
; 967: 				swfw = bridge_power.0
	BTFSC 0x49,0
	BSF 0x06,0
	BTFSS 0x49,0
	BCF 0x06,0
; 968: 			Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0291
L0290:
; 969: 				swfw = 1
	BSF 0x06,0
; 970: 			Endif
L0291:
; 971: 		Endif
L0289:
; 972: End Proc
	RETURN
; 973: Proc check_encoder_count()
L0018:
; 974: 	If encoder_count < 6 Then
	MOVLW 0x06
	SUBWF 0x45,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0292
; 975: 		encoder_count = encoder_count + 1
	MOVF 0x45,W
	ADDLW 0x01
	MOVWF 0x45
; 976: 		proceed = 0
	BCF 0x48,0
; 977: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0293
L0292:
; 978: 		encoder_count = 0
	CLRF 0x45
; 979: 		proceed = 1
	BSF 0x48,0
; 980: 	Endif
L0293:
; 981: End Proc
	RETURN
; End of program
;       PAGE SELECT
	BSF PCLATH,3
L0294:	GOTO L0294
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
