	list p=16f628
	#include <p16f628.inc>
	radix dec
; Compiled with: PIC Simulator IDE v6.71
; Microcontroller model: PIC16F628
; Clock frequency: 4.0 MHz
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0002
	ORG 0x0004
	RETFIE
L0002:
; 1:  'program bridge up/down
; 2:  'print MGV116
; 3: Define CONF_WORD = 0x3f50
; 4: AllDigital
	MOVLW 0x07
	MOVWF 0x1F
; 5: CMCON = 7
	MOVLW 0x07
	MOVWF 0x1F
; 6: TRISA = %00011001
	BSF STATUS,RP0
	MOVLW 0x19
	MOVWF 0x05
; 7: TRISB = %00000000
	CLRF 0x06
; 8: PORTA = 255
	BCF STATUS,RP0
	MOVLW 0xFF
	MOVWF 0x05
; 9: PORTB = 0
	CLRF 0x06
; 10: 
; 11: Symbol fwd = PORTB.4
;       The address of 'fwd' is 0x6,4
; 12: Symbol rev = PORTB.5
;       The address of 'rev' is 0x6,5
; 13: Symbol red_led = PORTB.6
;       The address of 'red_led' is 0x6,6
; 14: Symbol green_led = PORTB.7
;       The address of 'green_led' is 0x6,7
; 15: Symbol command = PORTA.0
;       The address of 'command' is 0x5,0
; 16: Symbol fbup = PORTA.1
;       The address of 'fbup' is 0x5,1
; 17: Symbol fbdn = PORTA.2
;       The address of 'fbdn' is 0x5,2
; 18: Symbol limit_up = PORTA.3
;       The address of 'limit_up' is 0x5,3
; 19: Symbol limit_dn = PORTA.4
;       The address of 'limit_dn' is 0x5,4
; 20: Symbol redsign = PORTA.5
;       The address of 'redsign' is 0x5,5
; 21: Symbol yellowsign = PORTA.6
;       The address of 'yellowsign' is 0x5,6
; 22: Symbol greensign = PORTA.7
;       The address of 'greensign' is 0x5,7
; 23: Dim direction As Byte
;       The address of 'direction' is 0x2C
	direction EQU 0x2C
; 24: PWMon 1, 1
	MOVLW 0xFF
	BSF STATUS,RP0
	MOVWF PR2
	BCF TRISB,3
	BCF STATUS,RP0
	CLRF CCPR1L
	BCF CCP1CON,CCP1X
	BCF CCP1CON,CCP1Y
	BCF T2CON,T2CKPS0
	BSF T2CON,T2CKPS1
	BSF T2CON,TMR2ON
	MOVLW 0x0C
	IORWF CCP1CON,F
; 25: PWMduty 1, 100 'speed of motor ,  can be between 1 and 1023
	BSF CCP1CON,CCP1Y
	BSF CCP1CON,CCP1X
	MOVLW 0x19
	MOVWF CCPR1L
; 26: 
; 27: main: 
L0001:
; 28: If command = 0 Then
	BTFSC 0x05,0
	GOTO L0003
; 29: direction = 1
	MOVLW 0x01
	MOVWF 0x2C
; 30: Else
	GOTO L0004
L0003:	MOVLW 0x1F
	ANDWF STATUS,F
; 31: direction = 0
	CLRF 0x2C
; 32: Endif
L0004:	MOVLW 0x1F
	ANDWF STATUS,F
; 33: Select Case direction
; 34: Case 1 'bridge should be up
	MOVF 0x2C,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0005
; 35: red_led = 1
	BSF 0x06,6
; 36: green_led = 0
	BCF 0x06,7
; 37: If limit_up = 0 Then 'bridge is upper most position
	BTFSC 0x05,3
	GOTO L0006
; 38: fwd = 0 'stop the motor
	BCF 0x06,4
; 39: rev = 0
	BCF 0x06,5
; 40: fbup = 0
	BCF 0x05,1
; 41: fbdn = 1
	BSF 0x05,2
; 42: redsign = 0
	BCF 0x05,5
; 43: yellowsign = 0
	BCF 0x05,6
; 44: greensign = 1
	BSF 0x05,7
; 45: Else
	GOTO L0007
L0006:	MOVLW 0x1F
	ANDWF STATUS,F
; 46: fbup = 1
	BSF 0x05,1
; 47: fbdn = 1
	BSF 0x05,2
; 48: fwd = 1 'run forward
	BSF 0x06,4
; 49: rev = 0
	BCF 0x06,5
; 50: redsign = 1
	BSF 0x05,5
; 51: yellowsign = 1
	BSF 0x05,6
; 52: greensign = 0
	BCF 0x05,7
; 53: Endif
L0007:	MOVLW 0x1F
	ANDWF STATUS,F
; 54: Case Else 'bridge must be in down position
	GOTO L0008
L0005:	MOVLW 0x1F
	ANDWF STATUS,F
; 55: red_led = 0
	BCF 0x06,6
; 56: green_led = 1
	BSF 0x06,7
; 57: redsign = 1
	BSF 0x05,5
; 58: yellowsign = 1
	BSF 0x05,6
; 59: greensign = 0
	BCF 0x05,7
; 60: If limit_dn = 0 Then 'bridge is lower most position
	BTFSC 0x05,4
	GOTO L0009
; 61: fbup = 1
	BSF 0x05,1
; 62: fbdn = 0
	BCF 0x05,2
; 63: fwd = 0 'stop the motor
	BCF 0x06,4
; 64: rev = 0
	BCF 0x06,5
; 65: fbup = 0
	BCF 0x05,1
; 66: fbdn = 1
	BSF 0x05,2
; 67: Else
	GOTO L0010
L0009:	MOVLW 0x1F
	ANDWF STATUS,F
; 68: fbup = 1
	BSF 0x05,1
; 69: fbdn = 1
	BSF 0x05,2
; 70: fwd = 0 'run backward
	BCF 0x06,4
; 71: rev = 1
	BSF 0x06,5
; 72: Endif
L0010:	MOVLW 0x1F
	ANDWF STATUS,F
; 73: EndSelect
L0008:	MOVLW 0x1F
	ANDWF STATUS,F
; 74: WaitMs 50 'there is no hurry
	MOVLW 0x32
	MOVWF R0L
	CLRF R0H
	CALL W001
; 75: 
; 76: Goto main
	GOTO L0001
; 77: End
L0011:	GOTO L0011
; End of program
L0012:	GOTO L0012
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x12
	MOVWF R1L
W005:	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
