	list p=16f628a
	#include <p16f628a.inc>
	radix dec
; Compiled with: PIC Simulator IDE v6.81
; Microcontroller model: PIC16F628A
; Clock frequency: 9.0 MHz
;
;       The address of 'fn1' (bit) (global) is 0x5,4
;       The address of 'fn2' (bit) (global) is 0x6,0
;       The address of 'fn3' (bit) (global) is 0x6,1
;       The address of 'fn4' (bit) (global) is 0x6,2
;       The address of 'irs1' (bit) (global) is 0x5,0
;       The address of 'irs2' (bit) (global) is 0x5,1
;       The address of 'irs3' (bit) (global) is 0x5,2
;       The address of 'irs4' (bit) (global) is 0x5,3
;       The address of 'ju1' (bit) (global) is 0x6,7
;       The address of 'ju2' (bit) (global) is 0x6,6
;       The address of 'ju3' (bit) (global) is 0x6,5
;       The address of 'ju4' (bit) (global) is 0x6,4
;       The address of 'ir_count_1' (byte) (global) is 0x2C
	ir_count_1 EQU 0x2C
;       The address of 'ir_count_2' (byte) (global) is 0x2D
	ir_count_2 EQU 0x2D
;       The address of 'ir_count_3' (byte) (global) is 0x2E
	ir_count_3 EQU 0x2E
;       The address of 'ir_count_4' (byte) (global) is 0x2F
	ir_count_4 EQU 0x2F
;       The value of 'check' (global) is 10
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0002
	ORG 0x0004
	RETFIE
L0002:
; 1: Define CONF_WORD = 0x3f42 'set config bits
; 2: 
; 3: 'quadruple IR gate
; 4: 'By Peter Giling
; 5: 'PCboard = MGV133
; 6: AllDigital
	MOVLW 0x07
	MOVWF 0x1F
; 7: CMCON = 7
	MOVLW 0x07
	MOVWF 0x1F
; 8: TRISA = %101111
	BSF STATUS,RP0
	MOVLW 0x2F
	MOVWF 0x05
; 9: TRISB = %11111000 'b3 = pwm
	MOVLW 0xF8
	MOVWF 0x06
; 10: PORTB = 255 'all outputs high
	BCF STATUS,RP0
	MOVLW 0xFF
	MOVWF 0x06
; 11: Symbol fn1 = PORTA.4
; 12: Symbol fn2 = PORTB.0
; 13: Symbol fn3 = PORTB.1
; 14: Symbol fn4 = PORTB.2
; 15: Symbol irs1 = PORTA.0
; 16: Symbol irs2 = PORTA.1
; 17: Symbol irs3 = PORTA.2
; 18: Symbol irs4 = PORTA.3
; 19: Symbol ju1 = PORTB.7
; 20: Symbol ju2 = PORTB.6
; 21: Symbol ju3 = PORTB.5
; 22: Symbol ju4 = PORTB.4
; 23: Dim ir_count_1 As Byte
	CLRF 0x2C
; 24: Dim ir_count_2 As Byte
	CLRF 0x2D
; 25: Dim ir_count_3 As Byte
	CLRF 0x2E
; 26: Dim ir_count_4 As Byte
	CLRF 0x2F
; 27: Const check = 10
; 28: PWMon 1, 9 'set to 36 kHz output at portb.3
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF PR2
	BCF TRISB,3
	BCF STATUS,RP0
	CLRF CCPR1L
	BCF CCP1CON,CCP1X
	BCF CCP1CON,CCP1Y
	BCF T2CON,T2CKPS0
	BCF T2CON,T2CKPS1
	BSF T2CON,TMR2ON
	MOVLW 0x0C
	IORWF CCP1CON,F
; 29: PWMduty 1, 127 'half duty cycle
	BSF CCP1CON,CCP1Y
	BSF CCP1CON,CCP1X
	MOVLW 0x20
	MOVWF CCPR1L
; 30: 
; 31: loop:
L0001:
; 32: 		If irs1 = 0 Then '1st sensor
	BTFSC 0x05,0
	GOTO L0003
; 33: 			If ir_count_1 < check Then
	MOVLW 0x0A
	SUBWF 0x2C,W
	BTFSC STATUS,C
	GOTO L0004
; 34: 				ir_count_1 = ir_count_1 + 1
	MOVF 0x2C,W
	ADDLW 0x01
	MOVWF 0x2C
; 35: 			Else
	GOTO L0005
L0004:	MOVLW 0x1F
	ANDWF STATUS,F
; 36: 				fn1 = ju1
	BTFSC 0x06,7
	BSF 0x05,4
	BTFSS 0x06,7
	BCF 0x05,4
; 37: 			Endif
L0005:	MOVLW 0x1F
	ANDWF STATUS,F
; 38: 		Else
	GOTO L0006
L0003:	MOVLW 0x1F
	ANDWF STATUS,F
; 39: 			If ir_count_1 > 0 Then
	MOVF 0x2C,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0007
; 40: 				ir_count_1 = ir_count_1 - 1
	MOVLW 0x01
	SUBWF 0x2C,W
	MOVWF 0x2C
; 41: 			Else
	GOTO L0008
L0007:	MOVLW 0x1F
	ANDWF STATUS,F
; 42: 				fn1 = Not ju1
	BTFSS 0x06,7
	BSF 0x05,4
	BTFSC 0x06,7
	BCF 0x05,4
; 43: 			Endif
L0008:	MOVLW 0x1F
	ANDWF STATUS,F
; 44: 		Endif
L0006:	MOVLW 0x1F
	ANDWF STATUS,F
; 45: 		If irs2 = 0 Then '2nd sensor
	BTFSC 0x05,1
	GOTO L0009
; 46: 			If ir_count_2 < check Then
	MOVLW 0x0A
	SUBWF 0x2D,W
	BTFSC STATUS,C
	GOTO L0010
; 47: 				ir_count_2 = ir_count_2 + 1
	MOVF 0x2D,W
	ADDLW 0x01
	MOVWF 0x2D
; 48: 			Else
	GOTO L0011
L0010:	MOVLW 0x1F
	ANDWF STATUS,F
; 49: 				fn2 = ju2
	BTFSC 0x06,6
	BSF 0x06,0
	BTFSS 0x06,6
	BCF 0x06,0
; 50: 			Endif
L0011:	MOVLW 0x1F
	ANDWF STATUS,F
; 51: 		Else
	GOTO L0012
L0009:	MOVLW 0x1F
	ANDWF STATUS,F
; 52: 			If ir_count_2 > 0 Then
	MOVF 0x2D,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0013
; 53: 				ir_count_2 = ir_count_2 - 1
	MOVLW 0x01
	SUBWF 0x2D,W
	MOVWF 0x2D
; 54: 			Else
	GOTO L0014
L0013:	MOVLW 0x1F
	ANDWF STATUS,F
; 55: 				fn2 = Not ju2
	BTFSS 0x06,6
	BSF 0x06,0
	BTFSC 0x06,6
	BCF 0x06,0
; 56: 			Endif
L0014:	MOVLW 0x1F
	ANDWF STATUS,F
; 57: 		Endif
L0012:	MOVLW 0x1F
	ANDWF STATUS,F
; 58: 		If irs3 = 0 Then '3rd sensor
	BTFSC 0x05,2
	GOTO L0015
; 59: 			If ir_count_3 < check Then
	MOVLW 0x0A
	SUBWF 0x2E,W
	BTFSC STATUS,C
	GOTO L0016
; 60: 				ir_count_3 = ir_count_3 + 1
	MOVF 0x2E,W
	ADDLW 0x01
	MOVWF 0x2E
; 61: 			Else
	GOTO L0017
L0016:	MOVLW 0x1F
	ANDWF STATUS,F
; 62: 				fn3 = ju3
	BTFSC 0x06,5
	BSF 0x06,1
	BTFSS 0x06,5
	BCF 0x06,1
; 63: 			Endif
L0017:	MOVLW 0x1F
	ANDWF STATUS,F
; 64: 		Else
	GOTO L0018
L0015:	MOVLW 0x1F
	ANDWF STATUS,F
; 65: 			If ir_count_3 > 0 Then
	MOVF 0x2E,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0019
; 66: 				ir_count_3 = ir_count_3 - 1
	MOVLW 0x01
	SUBWF 0x2E,W
	MOVWF 0x2E
; 67: 			Else
	GOTO L0020
L0019:	MOVLW 0x1F
	ANDWF STATUS,F
; 68: 				fn3 = Not ju3
	BTFSS 0x06,5
	BSF 0x06,1
	BTFSC 0x06,5
	BCF 0x06,1
; 69: 			Endif
L0020:	MOVLW 0x1F
	ANDWF STATUS,F
; 70: 		Endif
L0018:	MOVLW 0x1F
	ANDWF STATUS,F
; 71: 		If irs4 = 0 Then '4th sensor
	BTFSC 0x05,3
	GOTO L0021
; 72: 			If ir_count_4 < check Then
	MOVLW 0x0A
	SUBWF 0x2F,W
	BTFSC STATUS,C
	GOTO L0022
; 73: 				ir_count_4 = ir_count_4 + 1
	MOVF 0x2F,W
	ADDLW 0x01
	MOVWF 0x2F
; 74: 			Else
	GOTO L0023
L0022:	MOVLW 0x1F
	ANDWF STATUS,F
; 75: 				fn4 = ju4
	BTFSC 0x06,4
	BSF 0x06,2
	BTFSS 0x06,4
	BCF 0x06,2
; 76: 			Endif
L0023:	MOVLW 0x1F
	ANDWF STATUS,F
; 77: 		Else
	GOTO L0024
L0021:	MOVLW 0x1F
	ANDWF STATUS,F
; 78: 			If ir_count_4 > 0 Then
	MOVF 0x2F,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0025
; 79: 				ir_count_4 = ir_count_4 - 1
	MOVLW 0x01
	SUBWF 0x2F,W
	MOVWF 0x2F
; 80: 			Else
	GOTO L0026
L0025:	MOVLW 0x1F
	ANDWF STATUS,F
; 81: 				fn4 = Not ju4
	BTFSS 0x06,4
	BSF 0x06,2
	BTFSC 0x06,4
	BCF 0x06,2
; 82: 			Endif
L0026:	MOVLW 0x1F
	ANDWF STATUS,F
; 83: 		Endif
L0024:	MOVLW 0x1F
	ANDWF STATUS,F
; 84: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	CALL W001
; 85: Goto loop
	GOTO L0001
; 86: 
; 87: End
L0027:	GOTO L0027
; End of program
L0028:	GOTO L0028
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x2B
	MOVWF R1L
W005:	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x3F42
; End of listing
	END
