; Compiled with: PIC Simulator IDE v6.90
; Microcontroller model: PIC16F628A
; Clock frequency: 4.0 MHz
;
;       The address of 'pluskey' (bit) (global) is 0x6,6
;       The address of 'minuskey' (bit) (global) is 0x6,5
;       The address of 'shiftkey' (bit) (global) is 0x6,7
;       The address of 'stopleft' (bit) (global) is 0x5,0
;       The address of 'stopmid' (bit) (global) is 0x5,1
;       The address of 'stopright' (bit) (global) is 0x5,2
;       The address of 'leftled' (bit) (global) is 0x5,3
;       The address of 'rightled' (bit) (global) is 0x5,4
;       The address of 'flasher' (byte) (global) is 0x2D
	flasher EQU 0x2D
;       The address of 'route' (byte) (global) is 0x2E
	route EQU 0x2E
;       The address of 'speed' (byte) (global) is 0x2F
	speed EQU 0x2F
;       The address of 'maxspeed' (byte) (global) is 0x30
	maxspeed EQU 0x30
;       The address of 'run' (bit) (global) is 0x2C,0
;       The address of 'delay_right' (byte) (global) is 0x31
	delay_right EQU 0x31
;       The address of 'delay_mid' (byte) (global) is 0x32
	delay_mid EQU 0x32
;       The address of 'delay_left' (byte) (global) is 0x33
	delay_left EQU 0x33
;       The address of 'delay' (byte) (global) is 0x34
	delay EQU 0x34
;       The address of 'acc_time' (byte) (global) is 0x35
	acc_time EQU 0x35
;       The value of 'maxdelay' (global) is 50
; Procedure declaration: Proc motordirection(direction As Bit)
;       The address of 'direction' (bit) (motordirection) is 0x2C,1
; Procedure declaration: Proc calc_acc()
; Procedure declaration: Proc indicate_delay(time As Byte, which As Byte)
;       The address of 'time' (byte) (indicate_delay) is 0x36
;       The address of 'which' (byte) (indicate_delay) is 0x37
; Procedure declaration: Proc to_eeprom(place As Byte, value As Byte)
;       The address of 'place' (byte) (to_eeprom) is 0x38
;       The address of 'value' (byte) (to_eeprom) is 0x39
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0007
	ORG 0x0004
	RETFIE
; Begin of program
L0007:
; 1: Define CONF_WORD = 0x3f50
; 2: 
; 3: 'Commuter program for MGV140 unit definitve version with 3 pushbuttons
; 4: CMCON = 7
	MOVLW 0x07
	MOVWF 0x1F
; 5: TRISA = %11100111
	MOVLW 0xE7
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 6: TRISB = %11100000
	MOVLW 0xE0
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 7: PORTB = 255
	MOVLW 0xFF
	MOVWF 0x06
; 8: PORTA = 255
	MOVLW 0xFF
	MOVWF 0x05
; 9: 
; 10: Symbol pluskey = RB6
; 11: Symbol minuskey = RB5
; 12: Symbol shiftkey = RB7
; 13: Symbol stopleft = RA0
; 14: Symbol stopmid = RA1
; 15: Symbol stopright = RA2
; 16: 'Symbol stopextra = RA5
; 17: Symbol leftled = RA3
; 18: Symbol rightled = RA4
; 19: Dim flasher As Byte
; 20: Dim route As Byte
; 21: Dim speed As Byte
; 22: Dim maxspeed As Byte
; 23: Dim run As Bit
; 24: Dim delay_right As Byte
; 25: Dim delay_mid As Byte
; 26: Dim delay_left As Byte
; 27: Dim delay As Byte
; 28: Dim acc_time As Byte
; 29: 
; 30: Const maxdelay = 50
; 31: 'WaitMs 1000
; 32: Read 0, maxspeed
	MOVLW 0x00
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x30
; 33: If maxspeed > 240 Then
	MOVF 0x30,W
	SUBLW 0xF0
	BTFSC STATUS,C
	GOTO L0008
; 34: 	maxspeed = 125
	MOVLW 0x7D
	MOVWF 0x30
; 35: 	Call to_eeprom(0, 125)
	CLRF 0x38
	MOVLW 0x7D
	MOVWF 0x39
	CALL L0006
; 36: Endif
L0008:
; 37: If maxspeed < 30 Then
	MOVLW 0x1E
	SUBWF 0x30,W
	BTFSC STATUS,C
	GOTO L0009
; 38: 	maxspeed = 30
	MOVLW 0x1E
	MOVWF 0x30
; 39: 	Call to_eeprom(0, 30)
	CLRF 0x38
	MOVLW 0x1E
	MOVWF 0x39
	CALL L0006
; 40: Endif
L0009:
; 41: Read 1, delay_right
	MOVLW 0x01
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x31
; 42: If delay_right > 250 Then
	MOVF 0x31,W
	SUBLW 0xFA
	BTFSC STATUS,C
	GOTO L0010
; 43: 	delay_right = 16 '2 seconds to start with
	MOVLW 0x10
	MOVWF 0x31
; 44: 	Call to_eeprom(1, 16)
	MOVLW 0x01
	MOVWF 0x38
	MOVLW 0x10
	MOVWF 0x39
	CALL L0006
; 45: Endif
L0010:
; 46: Read 2, delay_mid
	MOVLW 0x02
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x32
; 47: If delay_mid > 250 Then
	MOVF 0x32,W
	SUBLW 0xFA
	BTFSC STATUS,C
	GOTO L0011
; 48: 	delay_mid = 16 '2 seconds to start with
	MOVLW 0x10
	MOVWF 0x32
; 49: 	Call to_eeprom(2, 16)
	MOVLW 0x02
	MOVWF 0x38
	MOVLW 0x10
	MOVWF 0x39
	CALL L0006
; 50: Endif
L0011:
; 51: Read 3, delay_left
	MOVLW 0x03
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x33
; 52: If delay_left > 250 Then
	MOVF 0x33,W
	SUBLW 0xFA
	BTFSC STATUS,C
	GOTO L0012
; 53: 	delay_left = 16 '2 seconds to start with
	MOVLW 0x10
	MOVWF 0x33
; 54: 	Call to_eeprom(3, 16)
	MOVLW 0x03
	MOVWF 0x38
	MOVLW 0x10
	MOVWF 0x39
	CALL L0006
; 55: Endif
L0012:
; 56: PWMon 1, 7
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF PR2
	BCF TRISB,3
	BCF STATUS,RP0
	CLRF CCPR1L
	BCF CCP1CON,CCP1X
	BCF CCP1CON,CCP1Y
	BCF T2CON,T2CKPS0
	BSF T2CON,T2CKPS1
	BSF T2CON,TMR2ON
	MOVLW 0x0C
	IORWF CCP1CON,F
; 57: PWMduty 1, 0
	BSF CCP1CON,CCP1Y
	BSF CCP1CON,CCP1X
	MOVLW 0x00
	MOVWF CCPR1L
; 58: route = 0
	CLRF 0x2E
; 59: If stopright = 0 Then
	BTFSC 0x05,2
	GOTO L0013
; 60: 	route = 4
	MOVLW 0x04
	MOVWF 0x2E
; 61: Endif
L0013:
; 62: If stopmid = 0 Then
	BTFSC 0x05,1
	GOTO L0014
; 63: 	route = 2
	MOVLW 0x02
	MOVWF 0x2E
; 64: Endif
L0014:
; 65: Call calc_acc()
	CALL L0004
; 66: main:
L0001:
; 67: 	Select Case route
; 68: 	Case 0 'loc = in left hand side position
	MOVF 0x2E,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0015
; 69: 		run = 0 'lok stopped
	BCF 0x2C,0
; 70: 		rightled = 1
	BSF 0x05,4
; 71: 		leftled = flasher.2
	BTFSC 0x2D,2
	BSF 0x05,3
	BTFSS 0x2D,2
	BCF 0x05,3
; 72: 		If delay > 0 Then 'lok waiting for timeout
	MOVF 0x34,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0016
; 73: 			If speed = 0 Then
	MOVF 0x2F,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0017
; 74: 				delay = delay - 1
	MOVLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 75: 			Endif
L0017:
; 76: 		Else 'time is up
	GOTO L0018
L0016:
; 77: 			route = 1 'next route step
	MOVLW 0x01
	MOVWF 0x2E
; 78: 			run = 1 'start lok
	BSF 0x2C,0
; 79: 			Call motordirection(0) 'set correect direction
	BCF 0x2C,1
	CALL L0002
; 80: 		Endif
L0018:
; 81: 	Case 1 'running 'right towards midsection
	GOTO L0019
L0015:
	MOVF 0x2E,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0020
; 82: 		run = 1 'lok running
	BSF 0x2C,0
; 83: 		leftled = 1 'left led off
	BSF 0x05,3
; 84: 		rightled = 0 'right led on
	BCF 0x05,4
; 85: 		Call motordirection(0) 'set correct direction
	BCF 0x2C,1
	CALL L0002
; 86: 		If stopmid = 0 Then 'arrival in station
	BTFSC 0x05,1
	GOTO L0021
; 87: 			run = 0 'stop loc
	BCF 0x2C,0
; 88: 			delay = delay_mid 'start timeout
	MOVF 0x32,W
	MOVWF 0x34
; 89: 			route = route + 1 'next route step
	MOVF 0x2E,W
	ADDLW 0x01
	MOVWF 0x2E
; 90: 		Endif
L0021:
; 91: 		If stopright = 0 Then 'arrival on left end position
	BTFSC 0x05,2
	GOTO L0022
; 92: 			run = 0 'stop engine
	BCF 0x2C,0
; 93: 			delay = delay_right 'start timeout
	MOVF 0x31,W
	MOVWF 0x34
; 94: 			route = 4 'stepover to correct next route
	MOVLW 0x04
	MOVWF 0x2E
; 95: 		Endif
L0022:
; 96: 	Case 2 'loc = in mid position to go right
	GOTO L0023
L0020:
	MOVF 0x2E,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0024
; 97: 		run = 0 'stop engine
	BCF 0x2C,0
; 98: 		leftled = 1 'lefd led off
	BSF 0x05,3
; 99: 		rightled = flasher.3 'blink right led
	BTFSC 0x2D,3
	BSF 0x05,4
	BTFSS 0x2D,3
	BCF 0x05,4
; 100: 		If delay > 0 Then 'loc waiting for timeout
	MOVF 0x34,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0025
; 101: 			If speed = 0 Then
	MOVF 0x2F,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0026
; 102: 				delay = delay - 1
	MOVLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 103: 			Endif
L0026:
; 104: 		Else 'time is up
	GOTO L0027
L0025:
; 105: 			route = 3 'next route step
	MOVLW 0x03
	MOVWF 0x2E
; 106: 			run = 1 'start loc
	BSF 0x2C,0
; 107: 			Call motordirection(0) 'select correct direction
	BCF 0x2C,1
	CALL L0002
; 108: 		Endif
L0027:
; 109: 	Case 3 'running 'right towards end
	GOTO L0028
L0024:
	MOVF 0x2E,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0029
; 110: 		run = 1 'start loc
	BSF 0x2C,0
; 111: 		leftled = 1 'left led off
	BSF 0x05,3
; 112: 		rightled = 0 'right led on
	BCF 0x05,4
; 113: 		Call motordirection(0) 'select correct direction
	BCF 0x2C,1
	CALL L0002
; 114: 		If stopright = 0 Then 'arrival in right had stop section?
	BTFSC 0x05,2
	GOTO L0030
; 115: 			run = 0 'stop engine
	BCF 0x2C,0
; 116: 			delay = delay_right 'set timeout
	MOVF 0x31,W
	MOVWF 0x34
; 117: 			route = 4 'set next route step
	MOVLW 0x04
	MOVWF 0x2E
; 118: 		Endif
L0030:
; 119: 	Case 4 'loc = in right hand side position
	GOTO L0031
L0029:
	MOVF 0x2E,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0032
; 120: 		run = 0 'stop engine
	BCF 0x2C,0
; 121: 		rightled = flasher.2 'right led off
	BTFSC 0x2D,2
	BSF 0x05,4
	BTFSS 0x2D,2
	BCF 0x05,4
; 122: 		leftled = 1 'blink left led
	BSF 0x05,3
; 123: 		If delay > 0 Then 'waiting for timeout
	MOVF 0x34,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0033
; 124: 			If speed = 0 Then
	MOVF 0x2F,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0034
; 125: 				delay = delay - 1
	MOVLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 126: 			Endif
L0034:
; 127: 		Else 'time is up
	GOTO L0035
L0033:
; 128: 			route = 5 'set next route
	MOVLW 0x05
	MOVWF 0x2E
; 129: 			run = 1 'start engine
	BSF 0x2C,0
; 130: 			Call motordirection(1) 'select correct direction
	BSF 0x2C,1
	CALL L0002
; 131: 		Endif
L0035:
; 132: 	Case 5 'running 'left towards midsection
	GOTO L0036
L0032:
	MOVF 0x2E,W
	SUBLW 0x05
	BTFSS STATUS,Z
	GOTO L0037
; 133: 		run = 1 'start engine
	BSF 0x2C,0
; 134: 		rightled = 1 'right led off
	BSF 0x05,4
; 135: 		leftled = 0 'left led on
	BCF 0x05,3
; 136: 		Call motordirection(1) 'set correct direction
	BSF 0x2C,1
	CALL L0002
; 137: 		If stopmid = 0 Then 'arrival in station?
	BTFSC 0x05,1
	GOTO L0038
; 138: 			run = 0 'stop loc
	BCF 0x2C,0
; 139: 			delay = delay_mid 'set timeout
	MOVF 0x32,W
	MOVWF 0x34
; 140: 			route = route + 1 'set next route step
	MOVF 0x2E,W
	ADDLW 0x01
	MOVWF 0x2E
; 141: 		Endif
L0038:
; 142: 		If stopleft = 0 Then 'arrival in left end station
	BTFSC 0x05,0
	GOTO L0039
; 143: 			run = 0 'stop loc
	BCF 0x2C,0
; 144: 			delay = delay_left 'set timeout
	MOVF 0x33,W
	MOVWF 0x34
; 145: 			route = 0 'loc is at left end position
	CLRF 0x2E
; 146: 		Endif
L0039:
; 147: 	Case 6 'loc = in mid position to go left
	GOTO L0040
L0037:
	MOVF 0x2E,W
	SUBLW 0x06
	BTFSS STATUS,Z
	GOTO L0041
; 148: 		run = 0 'stop engine
	BCF 0x2C,0
; 149: 		rightled = 1 'right led off
	BSF 0x05,4
; 150: 		leftled = flasher.3 'blink left led
	BTFSC 0x2D,3
	BSF 0x05,3
	BTFSS 0x2D,3
	BCF 0x05,3
; 151: 		If delay > 0 Then 'waiting for timeout
	MOVF 0x34,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0042
; 152: 			If speed = 0 Then
	MOVF 0x2F,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0043
; 153: 				delay = delay - 1
	MOVLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 154: 			Endif
L0043:
; 155: 		Else 'time is up
	GOTO L0044
L0042:
; 156: 			route = 7 'set next route step
	MOVLW 0x07
	MOVWF 0x2E
; 157: 			run = 1 'start loc
	BSF 0x2C,0
; 158: 			Call motordirection(1) 'set correct direction
	BSF 0x2C,1
	CALL L0002
; 159: 		Endif
L0044:
; 160: 	Case 7 'running left towards end
	GOTO L0045
L0041:
	MOVF 0x2E,W
	SUBLW 0x07
	BTFSS STATUS,Z
	GOTO L0046
; 161: 		run = 1 'start loc
	BSF 0x2C,0
; 162: 		leftled = 0 'left led On
	BCF 0x05,3
; 163: 		rightled = 1 'right led off
	BSF 0x05,4
; 164: 		Call motordirection(1) 'select correct direction
	BSF 0x2C,1
	CALL L0002
; 165: 		If stopleft = 0 Then 'arrival in left end station?
	BTFSC 0x05,0
	GOTO L0047
; 166: 			run = 0 'stop lok
	BCF 0x2C,0
; 167: 			delay = delay_left 'set timeout
	MOVF 0x33,W
	MOVWF 0x34
; 168: 			route = 0 'next route step
	CLRF 0x2E
; 169: 		Endif
L0047:
; 170: 	Case Else
	GOTO L0048
L0046:
; 171: 	EndSelect
L0048:
L0045:
L0040:
L0036:
L0031:
L0028:
L0023:
L0019:
; 172: 	If run = 0 Then 'controlling ramp up or ramp down speed
	BTFSC 0x2C,0
	GOTO L0049
; 173: 		If speed > 30 Then
	MOVF 0x2F,W
	SUBLW 0x1E
	BTFSC STATUS,C
	GOTO L0050
; 174: 			speed = speed - acc_time
	MOVF 0x35,W
	SUBWF 0x2F,W
	MOVWF 0x2F
; 175: 		Else
	GOTO L0051
L0050:
; 176: 			speed = 0
	CLRF 0x2F
; 177: 		Endif
L0051:
; 178: 	Else
	GOTO L0052
L0049:
; 179: 		If speed < maxspeed Then
	MOVF 0x30,W
	SUBWF 0x2F,W
	BTFSC STATUS,C
	GOTO L0053
; 180: 			If speed < 30 Then
	MOVLW 0x1E
	SUBWF 0x2F,W
	BTFSC STATUS,C
	GOTO L0054
; 181: 				speed = 30
	MOVLW 0x1E
	MOVWF 0x2F
; 182: 			Else
	GOTO L0055
L0054:
; 183: 				speed = speed + acc_time
	MOVF 0x2F,W
	ADDWF 0x35,W
	MOVWF 0x2F
; 184: 			Endif
L0055:
; 185: 		Else
	GOTO L0056
L0053:
; 186: 			speed = maxspeed
	MOVF 0x30,W
	MOVWF 0x2F
; 187: 		Endif
L0056:
; 188: 	Endif
L0052:
; 189: 	PWMduty 1, speed
	MOVF 0x2F,W
	MOVWF R0L
	BTFSC R0L,0
	BSF CCP1CON,CCP1Y
	BTFSS R0L,0
	BCF CCP1CON,CCP1Y
	BTFSC R0L,1
	BSF CCP1CON,CCP1X
	BTFSS R0L,1
	BCF CCP1CON,CCP1X
	BCF STATUS,C
	RRF R0L,F
	BCF STATUS,C
	RRF R0L,W
	MOVWF CCPR1L
; 190: 	Gosub readkey
	CALL L0003
; 191: 	flasher = flasher + 1
	MOVF 0x2D,W
	ADDLW 0x01
	MOVWF 0x2D
; 192: 	WaitMs 125
	MOVLW 0x7D
	MOVWF R0L
	CLRF R0H
	CALL W001
; 193: Goto main
	GOTO L0001
; 194: 
; 195: End
L0057:	GOTO L0057
; 196: Proc motordirection(direction As Bit)
L0002:
; 197: 	RB1 = direction
	BTFSC 0x2C,1
	BSF 0x06,1
	BTFSS 0x2C,1
	BCF 0x06,1
; 198: 	RB0 = Not direction
	BTFSS 0x2C,1
	BSF 0x06,0
	BTFSC 0x2C,1
	BCF 0x06,0
; 199: End Proc
	RETURN
; 200: readkey:
L0003:
; 201: 	While shiftkey = 0 'changing waittimes
L0058:
	BTFSC 0x06,7
	GOTO L0059
; 202: 		rightled = 1
	BSF 0x05,4
; 203: 		leftled = 1
	BSF 0x05,3
; 204: 		If pluskey = 0 Then
	BTFSC 0x06,6
	GOTO L0060
; 205: 			Select Case route
; 206: 			Case 4
	MOVF 0x2E,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0061
; 207: 				If delay_right < 241 Then 'maximum = 250 x 0.1 sec
	MOVLW 0xF1
	SUBWF 0x31,W
	BTFSC STATUS,C
	GOTO L0062
; 208: 					delay_right = delay_right + 10 '1 second more
	MOVF 0x31,W
	ADDLW 0x0A
	MOVWF 0x31
; 209: 					Call indicate_delay(delay_right, 2)
	MOVF 0x31,W
	MOVWF 0x36
	MOVLW 0x02
	MOVWF 0x37
	CALL L0005
; 210: 					Call to_eeprom(1, delay_right)
	MOVLW 0x01
	MOVWF 0x38
	MOVF 0x31,W
	MOVWF 0x39
	CALL L0006
; 211: 				Endif
L0062:
; 212: 			Case 2, 6
	GOTO L0063
L0061:
	MOVF 0x2E,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0066
	GOTO L0065
L0066:
	MOVF 0x2E,W
	SUBLW 0x06
	BTFSS STATUS,Z
	GOTO L0064
L0065:
; 213: 				If delay_mid < 241 Then 'maximum = 250 x 0.1 sec
	MOVLW 0xF1
	SUBWF 0x32,W
	BTFSC STATUS,C
	GOTO L0067
; 214: 					delay_mid = delay_mid + 10 '1 second more
	MOVF 0x32,W
	ADDLW 0x0A
	MOVWF 0x32
; 215: 					Call indicate_delay(delay_mid, 1)
	MOVF 0x32,W
	MOVWF 0x36
	MOVLW 0x01
	MOVWF 0x37
	CALL L0005
; 216: 					Call to_eeprom(2, delay_mid)
	MOVLW 0x02
	MOVWF 0x38
	MOVF 0x32,W
	MOVWF 0x39
	CALL L0006
; 217: 				Endif
L0067:
; 218: 			Case 0
	GOTO L0068
L0064:
	MOVF 0x2E,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0069
; 219: 				If delay_left < 241 Then 'maximum = 250 x 0.1 sec
	MOVLW 0xF1
	SUBWF 0x33,W
	BTFSC STATUS,C
	GOTO L0070
; 220: 					delay_left = delay_left + 10 '1 second more
	MOVF 0x33,W
	ADDLW 0x0A
	MOVWF 0x33
; 221: 					Call indicate_delay(delay_left, 1)
	MOVF 0x33,W
	MOVWF 0x36
	MOVLW 0x01
	MOVWF 0x37
	CALL L0005
; 222: 					Call to_eeprom(3, delay_left)
	MOVLW 0x03
	MOVWF 0x38
	MOVF 0x33,W
	MOVWF 0x39
	CALL L0006
; 223: 				Endif
L0070:
; 224: 			Case Else
	GOTO L0071
L0069:
; 225: 			EndSelect
L0071:
L0068:
L0063:
; 226: 			While pluskey = 0
L0072:
	BTFSC 0x06,6
	GOTO L0073
; 227: 				WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
	CALL W001
; 228: 			Wend
	GOTO L0072
L0073:
; 229: 		Endif
L0060:
; 230: 		If minuskey = 0 Then
	BTFSC 0x06,5
	GOTO L0074
; 231: 			Select Case route
; 232: 			Case 4
	MOVF 0x2E,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0075
; 233: 				If delay_right > 19 Then 'minimum = 10 x 0.1 sec
	MOVF 0x31,W
	SUBLW 0x13
	BTFSC STATUS,C
	GOTO L0076
; 234: 					delay_right = delay_right - 10 '1 second less
	MOVLW 0x0A
	SUBWF 0x31,W
	MOVWF 0x31
; 235: 					Call indicate_delay(delay_right, 2)
	MOVF 0x31,W
	MOVWF 0x36
	MOVLW 0x02
	MOVWF 0x37
	CALL L0005
; 236: 				Endif
L0076:
; 237: 			Case 2, 6
	GOTO L0077
L0075:
	MOVF 0x2E,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0080
	GOTO L0079
L0080:
	MOVF 0x2E,W
	SUBLW 0x06
	BTFSS STATUS,Z
	GOTO L0078
L0079:
; 238: 				If delay_mid > 19 Then 'minimum = 10 x 0.1 sec
	MOVF 0x32,W
	SUBLW 0x13
	BTFSC STATUS,C
	GOTO L0081
; 239: 					delay_mid = delay_mid - 10 '1 second less
	MOVLW 0x0A
	SUBWF 0x32,W
	MOVWF 0x32
; 240: 					Call indicate_delay(delay_mid, 1)
	MOVF 0x32,W
	MOVWF 0x36
	MOVLW 0x01
	MOVWF 0x37
	CALL L0005
; 241: 				Endif
L0081:
; 242: 			Case 0
	GOTO L0082
L0078:
	MOVF 0x2E,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0083
; 243: 				If delay_left > 19 Then 'minimum = 10 x 0.1 sec
	MOVF 0x33,W
	SUBLW 0x13
	BTFSC STATUS,C
	GOTO L0084
; 244: 					delay_left = delay_left - 10 '1 second less
	MOVLW 0x0A
	SUBWF 0x33,W
	MOVWF 0x33
; 245: 					Call indicate_delay(delay_left, 1)
	MOVF 0x33,W
	MOVWF 0x36
	MOVLW 0x01
	MOVWF 0x37
	CALL L0005
; 246: 				Endif
L0084:
; 247: 			Case Else
	GOTO L0085
L0083:
; 248: 			EndSelect
L0085:
L0082:
L0077:
; 249: 			While minuskey = 0
L0086:
	BTFSC 0x06,5
	GOTO L0087
; 250: 				WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
	CALL W001
; 251: 			Wend
	GOTO L0086
L0087:
; 252: 		Endif
L0074:
; 253: 		WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
	CALL W001
; 254: 	Wend
	GOTO L0058
L0059:
; 255: 	'just speed change
; 256: 	If pluskey = 0 Then
	BTFSC 0x06,6
	GOTO L0088
; 257: 		If maxspeed < 231 Then
	MOVLW 0xE7
	SUBWF 0x30,W
	BTFSC STATUS,C
	GOTO L0089
; 258: 			maxspeed = maxspeed + 10
	MOVF 0x30,W
	ADDLW 0x0A
	MOVWF 0x30
; 259: 			Write 0, maxspeed
	MOVLW 0x00
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x30,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0090:	BTFSC EECON1,WR
	GOTO L0090
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 260: 		Else
	GOTO L0091
L0089:
; 261: 			maxspeed = 240
	MOVLW 0xF0
	MOVWF 0x30
; 262: 		Endif
L0091:
; 263: 		Call calc_acc()
	CALL L0004
; 264: 		While pluskey = 0
L0092:
	BTFSC 0x06,6
	GOTO L0093
; 265: 			WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
	CALL W001
; 266: 		Wend
	GOTO L0092
L0093:
; 267: 	Endif
L0088:
; 268: 	If minuskey = 0 Then
	BTFSC 0x06,5
	GOTO L0094
; 269: 		If maxspeed > 59 Then
	MOVF 0x30,W
	SUBLW 0x3B
	BTFSC STATUS,C
	GOTO L0095
; 270: 			maxspeed = maxspeed - 10
	MOVLW 0x0A
	SUBWF 0x30,W
	MOVWF 0x30
; 271: 			Write 0, maxspeed
	MOVLW 0x00
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x30,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0096:	BTFSC EECON1,WR
	GOTO L0096
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 272: 		Else
	GOTO L0097
L0095:
; 273: 			maxspeed = 50
	MOVLW 0x32
	MOVWF 0x30
; 274: 		Endif
L0097:
; 275: 		Call calc_acc()
	CALL L0004
; 276: 		While minuskey = 0
L0098:
	BTFSC 0x06,5
	GOTO L0099
; 277: 			WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
	CALL W001
; 278: 		Wend
	GOTO L0098
L0099:
; 279: 	Endif
L0094:
; 280: Return
	RETURN
; 281: 
; 282: Proc calc_acc()
L0004:
; 283: 	acc_time = maxspeed - 30
	MOVLW 0x1E
	SUBWF 0x30,W
	MOVWF 0x35
; 284: 	acc_time = acc_time / 30 '3 secs acc / dec
	MOVF 0x35,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x1E
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x35
; 285: 	If acc_time < 1 Then
	MOVLW 0x01
	SUBWF 0x35,W
	BTFSC STATUS,C
	GOTO L0100
; 286: 		acc_time = 1
	MOVLW 0x01
	MOVWF 0x35
; 287: 	Endif
L0100:
; 288: 	If acc_time > 240 Then
	MOVF 0x35,W
	SUBLW 0xF0
	BTFSC STATUS,C
	GOTO L0101
; 289: 		acc_time = 1
	MOVLW 0x01
	MOVWF 0x35
; 290: 	Endif
L0101:
; 291: End Proc
	RETURN
; 292: 
; 293: Proc indicate_delay(time As Byte, which As Byte)
L0005:
; 294: 'led left , right or both will flash the amount of seconds as set.
; 295: 	For flasher = 0 To time Step 10
	CLRF 0x2D
L0102:
	MOVF 0x2D,W
	SUBWF 0x36,W
	BTFSS STATUS,C
	GOTO L0103
; 296: 		leftled = 1
	BSF 0x05,3
; 297: 		rightled = 1
	BSF 0x05,4
; 298: 		WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
	CALL W001
; 299: 		Select Case which
; 300: 		Case 0 'left hand flash
	MOVF 0x37,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0104
; 301: 			leftled = 0
	BCF 0x05,3
; 302: 		Case 1 'middle position
	GOTO L0105
L0104:
	MOVF 0x37,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0106
; 303: 			leftled = 0
	BCF 0x05,3
; 304: 			rightled = 0
	BCF 0x05,4
; 305: 		Case Else 'right hand position
	GOTO L0107
L0106:
; 306: 			rightled = 0
	BCF 0x05,4
; 307: 		EndSelect
L0107:
L0105:
; 308: 		WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
	CALL W001
; 309: 	Next flasher
	MOVLW 0x0A
	ADDWF 0x2D,F
	BTFSS STATUS,C
	GOTO L0102
L0103:
; 310: End Proc
	RETURN
; 311: 
; 312: Proc to_eeprom(place As Byte, value As Byte)
L0006:
; 313: 	Write place, value
	MOVF 0x38,W
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x39,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0108:	BTFSC EECON1,WR
	GOTO L0108
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 314: End Proc
	RETURN
; End of program
L0109:	GOTO L0109
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x12
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
