; Compiled with: PIC Simulator IDE v6.90
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The address of 'act_pos' (byte) (global) is 0x30
	act_pos EQU 0x30
;       The address of 'new_steps' (word) (global) is 0x31
	new_steps EQU 0x31
;       The address of 'max_pos' (byte) (global) is 0x33
	max_pos EQU 0x33
;       The address of 'act_steps' (word) (global) is 0x34
	act_steps EQU 0x34
;       The address of 'manual_pos' (byte) (global) is 0x36
	manual_pos EQU 0x36
;       The address of 'ff' (byte) (global) is 0x37
	ff EQU 0x37
;       The address of 'value' (byte) (global) is 0x38
	value EQU 0x38
;       The address of 'steps' (word) (global) is 0x39
	steps EQU 0x39
;       The address of 'one_round' (word) (global) is 0x3B
	one_round EQU 0x3B
;       The address of 'result' (byte) (global) is 0x3D
	result EQU 0x3D
;       The address of 'speed' (word) (global) is 0x3E
	speed EQU 0x3E
;       The address of 'new_encoder' (byte) (global) is 0x40
	new_encoder EQU 0x40
;       The address of 'encoder_count' (byte) (global) is 0x41
	encoder_count EQU 0x41
;       The address of 'new_pos' (byte) (global) is 0x42
	new_pos EQU 0x42
;       The address of 'bus_pos' (byte) (global) is 0x43
	bus_pos EQU 0x43
;       The address of 'onoff' (bit) (global) is 0x44,0
;       The address of 'speed_step' (byte) (global) is 0x45
	speed_step EQU 0x45
;       The address of 'eprom_pointer1' (byte) (global) is 0x46
	eprom_pointer1 EQU 0x46
;       The address of 'old_bus_pos' (byte) (global) is 0x47
	old_bus_pos EQU 0x47
;       The address of 'old_encoder' (byte) (global) is 0x48
	old_encoder EQU 0x48
;       The address of 'old_manual_pos' (byte) (global) is 0x49
	old_manual_pos EQU 0x49
;       The address of 'ecsw_temp' (bit) (global) is 0x44,1
;       The address of 'half_max_pos' (byte) (global) is 0x4A
	half_max_pos EQU 0x4A
;       The address of 'dp' (word) (global) is 0x4B
	dp EQU 0x4B
;       The address of 'eprom_pointer2' (byte) (global) is 0x4D
	eprom_pointer2 EQU 0x4D
;       The address of 'ip' (word) (global) is 0x4E
	ip EQU 0x4E
;       The address of 'half_steps' (word) (global) is 0x50
	half_steps EQU 0x50
;       The address of 'one_round_half' (word) (global) is 0x52
	one_round_half EQU 0x52
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'eep' (bit) (global) is 0x6,6
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x7,3
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0012
	ORG 0x0004
	RETFIE
; Begin of program
L0012:
; 1: 'program TT for PCBoard MGV145
; 2: 'version v1.1  Fiddle Yard version, also for turntables only turning to zero, not further.
; 3: Define CONF_WORD = 0x3f72
; 4: Define CLOCK_FREQUENCY = 20
; 5: Dim steps As Word
; 6: Dim half_steps As Word
; 7: Dim new_steps As Word
; 8: Dim act_steps As Word
; 9: Dim new_pos As Byte
; 10: Dim act_pos As Byte
; 11: Dim one_round As Word
; 12: Dim one_round_half As Word
; 13: Dim bus_pos As Byte
; 14: Dim old_bus_pos As Byte
; 15: Dim speed As Word
; 16: Dim new_encoder As Byte
; 17: Dim old_encoder As Byte
; 18: Dim manual_pos As Byte
; 19: Dim old_manual_pos As Byte
; 20: Dim result As Byte
; 21: Dim ff As Byte
; 22: Dim value As Byte
; 23: Dim eprom_pointer1 As Byte
; 24: Dim eprom_pointer2 As Byte
; 25: Dim encoder_count As Byte
; 26: Dim onoff As Bit
; 27: Dim ecsw_temp As Bit
; 28: Dim max_pos As Byte
; 29: Dim half_max_pos As Byte
; 30: Dim speed_step As Byte
; 31: Dim ip As Word
; 32: Dim dp As Word
; 33: Const disp1 = 64
; 34: Const disp2 = 66
; 35: 
; 36: Symbol swfw = RB0
; 37: Symbol swrev = RB1
; 38: Symbol sck = RB2
; 39: Symbol sda = RB3
; 40: Symbol pos_match = RB4
; 41: Symbol pos_write = RB5
; 42: Symbol eep = RB6
; 43: Symbol direction = RC0
; 44: Symbol clk = RC1
; 45: Symbol ena = RC2
; 46: Symbol zero = RC3
; 47: Symbol ec1 = RC4
; 48: Symbol ec2 = RC5
; 49: Symbol ecsw = RC6
; 50: Symbol pgm = RC7
; 51: encoder_count = 0
	CLRF 0x41
; 52: speed = 6000  'start with slow speed
	MOVLW 0x70
	MOVWF 0x3E
	MOVLW 0x17
	MOVWF 0x3F
; 53: If eep = 1 Then  'jumper set for imitialisation
	BTFSS 0x06,6
	GOTO L0013
; 54: 	Gosub init_eeprom
	CALL L0006
; 55: Endif
L0013:
; 56: Read 122, speed_step
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x45
; 57: If speed_step > 50 Then
	MOVF 0x45,W
	SUBLW 0x32
	BTFSC STATUS,C
	GOTO L0014
; 58: 	speed_step = 10
	MOVLW 0x0A
	MOVWF 0x45
; 59: 	Write 122, speed_step
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x45,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0015:	BTFSC EECON1,WR
	GOTO L0015
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 60: Endif
L0014:
; 61: Read 123, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3B
; 62: Read 124, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3C
; 63: If one_round = 0 Then
	MOVF 0x3B,W
	MOVWF R0L
	MOVF 0x3C,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C001
	BTFSS STATUS,Z
	GOTO L0016
; 64: 	one_round = 8000
	MOVLW 0x40
	MOVWF 0x3B
	MOVLW 0x1F
	MOVWF 0x3C
; 65: Endif
L0016:
; 66: If one_round > 64000 Then
	MOVF 0x3B,W
	MOVWF R0L
	MOVF 0x3C,W
	MOVWF R0H
	CLRF R1L
	MOVLW 0xFA
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0017
; 67: 	one_round = 8000
	MOVLW 0x40
	MOVWF 0x3B
	MOVLW 0x1F
	MOVWF 0x3C
; 68: Endif
L0017:
; 69: one_round_half = one_round / 2
	MOVF 0x3B,W
	MOVWF R0L
	MOVF 0x3C,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x52
	MOVF R0H,W
	MOVWF 0x53
; 70: Read 125, act_pos
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 71: Read 126, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 72: If act_pos > 60 Then
	MOVF 0x30,W
	SUBLW 0x3C
	BTFSC STATUS,C
	GOTO L0018
; 73: 	act_pos = 1
	MOVLW 0x01
	MOVWF 0x30
; 74: 	Write 125, act_pos
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0019:	BTFSC EECON1,WR
	GOTO L0019
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 75: Endif
L0018:
; 76: If max_pos > 60 Then
	MOVF 0x33,W
	SUBLW 0x3C
	BTFSC STATUS,C
	GOTO L0020
; 77: 	max_pos = 12
	MOVLW 0x0C
	MOVWF 0x33
; 78: 	Write 126, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0021:	BTFSC EECON1,WR
	GOTO L0021
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 79: Endif
L0020:
; 80: half_max_pos = max_pos / 2
	MOVF 0x33,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x4A
; 81: new_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x42
; 82: bus_pos = PORTA And 63  'cancel first input from MGV50
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x43
; 83: old_bus_pos = bus_pos
	MOVF 0x43,W
	MOVWF 0x47
; 84: manual_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x36
; 85: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 86: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 87: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 88: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 89: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 90: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
; 91: value = act_pos
	MOVF 0x30,W
	MOVWF 0x38
; 92: Gosub i2c_display_nml
	CALL L0008
; 93: onoff = 1
	BSF 0x44,0
; 94: Gosub relays
	CALL L0011
; 95: 
; 96: main:
L0001:
; 97: 	If pgm = 0 Then
	BTFSC 0x07,7
	GOTO L0022
; 98: 		Gosub adjust_settings
	CALL L0003
; 99: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	CALL W001
; 100: 	Endif
L0022:
; 101: 
; 102: 	Gosub get_new_position
	CALL L0002
; 103: 	If bus_pos <> old_bus_pos Then
	MOVF 0x43,W
	SUBWF 0x47,W
	BTFSC STATUS,Z
	GOTO L0023
; 104: 		onoff = 0
	BCF 0x44,0
; 105: 		Gosub relays
	CALL L0011
; 106: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 107: 		new_pos = bus_pos
	MOVF 0x43,W
	MOVWF 0x42
; 108: 		old_bus_pos = bus_pos
	MOVF 0x43,W
	MOVWF 0x47
; 109: 		Gosub steps_reading
	CALL L0005
; 110: 		Gosub stepmotor
	CALL L0010
; 111: 		act_pos = new_pos
	MOVF 0x42,W
	MOVWF 0x30
; 112: 		Write 125, act_pos
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0024:	BTFSC EECON1,WR
	GOTO L0024
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 113: 		value = act_pos
	MOVF 0x30,W
	MOVWF 0x38
; 114: 		Gosub i2c_display_nml
	CALL L0008
; 115: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 116: 		onoff = 1
	BSF 0x44,0
; 117: 
; 118: 	Else
	GOTO L0025
L0023:
; 119: 		If manual_pos <> old_manual_pos Then
	MOVF 0x36,W
	SUBWF 0x49,W
	BTFSC STATUS,Z
	GOTO L0026
; 120: 			onoff = 0
	BCF 0x44,0
; 121: 			Gosub relays
	CALL L0011
; 122: 			pos_match = 1  'indicate not in position
	BSF 0x06,4
; 123: 			old_manual_pos = manual_pos
	MOVF 0x36,W
	MOVWF 0x49
; 124: 			new_pos = manual_pos
	MOVF 0x36,W
	MOVWF 0x42
; 125: 			Gosub steps_reading
	CALL L0005
; 126: 			Gosub stepmotor
	CALL L0010
; 127: 			act_pos = new_pos
	MOVF 0x42,W
	MOVWF 0x30
; 128: 			Write 125, act_pos
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0027:	BTFSC EECON1,WR
	GOTO L0027
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 129: 			value = act_pos
	MOVF 0x30,W
	MOVWF 0x38
; 130: 			Gosub i2c_display_nml
	CALL L0008
; 131: 			pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 132: 			manual_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x36
; 133: 			old_manual_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x49
; 134: 			onoff = 1
	BSF 0x44,0
; 135: 		Endif
L0026:
; 136: 	Endif
L0025:
; 137: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	CALL W001
; 138: 	Gosub relays
	CALL L0011
; 139: 	Goto main
	GOTO L0001
; 140: End
L0028:	GOTO L0028
; 141: 
; 142: 
; 143: get_new_position:
L0002:
; 144: 	If pos_write = 0 Then
	BTFSC 0x06,5
	GOTO L0029
; 145: 		bus_pos = PORTA And 63
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x43
; 146: 		If bus_pos > max_pos Then
	MOVF 0x43,W
	SUBWF 0x33,W
	BTFSC STATUS,C
	GOTO L0030
; 147: 			old_bus_pos = bus_pos  'do not react on illegal value
	MOVF 0x43,W
	MOVWF 0x47
; 148: 		Endif
L0030:
; 149: 	Endif
L0029:
; 150: 	ecsw_temp = 1
	BSF 0x44,1
; 151: 	While ecsw_temp = 1
L0031:
	BTFSS 0x44,1
	GOTO L0032
; 152: 	'result will now be calculated
; 153: 		ecsw_temp = ecsw And pgm
	CLRW
	BTFSS 0x07,6
	ADDLW 0x01
	BTFSS 0x07,7
	ADDLW 0x01
	BTFSC STATUS,Z
	BSF 0x44,1
	BTFSS STATUS,Z
	BCF 0x44,1
; 154: 		Gosub calc_rotation
	CALL L0009
; 155: 		Select Case result
; 156: 		Case 1
	MOVF 0x3D,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0033
; 157: 			If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x41,W
	BTFSC STATUS,C
	GOTO L0034
; 158: 				encoder_count = encoder_count + 1
	MOVF 0x41,W
	ADDLW 0x01
	MOVWF 0x41
; 159: 			Else
	GOTO L0035
L0034:
; 160: 				encoder_count = 0
	CLRF 0x41
; 161: 				manual_pos = manual_pos + 1
	MOVF 0x36,W
	ADDLW 0x01
	MOVWF 0x36
; 162: 				If manual_pos > max_pos Then
	MOVF 0x36,W
	SUBWF 0x33,W
	BTFSC STATUS,C
	GOTO L0036
; 163: 					manual_pos = max_pos
	MOVF 0x33,W
	MOVWF 0x36
; 164: 				Endif
L0036:
; 165: 				value = manual_pos
	MOVF 0x36,W
	MOVWF 0x38
; 166: 				Gosub i2c_display_nml
	CALL L0008
; 167: 			Endif
L0035:
; 168: 		Case 2
	GOTO L0037
L0033:
	MOVF 0x3D,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0038
; 169: 			If encoder_count > 0 Then
	MOVF 0x41,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0039
; 170: 				encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x41,W
	MOVWF 0x41
; 171: 			Else
	GOTO L0040
L0039:
; 172: 				encoder_count = 4
	MOVLW 0x04
	MOVWF 0x41
; 173: 				If manual_pos > 0 Then
	MOVF 0x36,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0041
; 174: 					manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x36,W
	MOVWF 0x36
; 175: 				Endif
L0041:
; 176: 				value = manual_pos
	MOVF 0x36,W
	MOVWF 0x38
; 177: 				Gosub i2c_display_nml
	CALL L0008
; 178: 			Endif
L0040:
; 179: 		Case Else
	GOTO L0042
L0038:
; 180: 		EndSelect
L0042:
L0037:
; 181: 		WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	CALL W001
; 182: 	Wend
	GOTO L0031
L0032:
; 183: Return
	RETURN
; 184: 
; 185: adjust_settings:
L0003:
; 186: 	onoff = 0
	BCF 0x44,0
; 187: 	Gosub relays
	CALL L0011
; 188: 	Gosub steps_reading
	CALL L0005
; 189: 	value = act_pos
	MOVF 0x30,W
	MOVWF 0x38
; 190: 	Gosub i2c_display_nml
	CALL L0008
; 191: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x34,W
	MOVWF 0x31
	MOVF 0x35,W
	MOVWF 0x32
; 192: 		While pgm = 0
L0043:
	BTFSC 0x07,7
	GOTO L0044
; 193: 			If ecsw = 0 Then  'knob is pressed, adjust max positions
	BTFSC 0x07,6
	GOTO L0045
; 194: 				Gosub max_adjust
	CALL L0004
; 195: 			Endif
L0045:
; 196: 			ena = 1
	BSF 0x07,2
; 197: 			Gosub calc_rotation
	CALL L0009
; 198: 			Select Case result
; 199: 			Case 1
	MOVF 0x3D,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0046
; 200: 			'If encoder_count < 3 Then
; 201: 			'encoder_count = encoder_count + 1
; 202: 			'Else
; 203: 			'encoder_count = 0
; 204: 				If new_steps < 60000 Then
	MOVF 0x31,W
	MOVWF R0L
	MOVF 0x32,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0047
; 205: 					new_steps = new_steps + 1
	MOVF 0x31,W
	ADDLW 0x01
	MOVWF 0x31
	MOVF 0x32,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x32
; 206: 					direction = 1
	BSF 0x07,0
; 207: 					clk = 1  'clock out
	BSF 0x07,1
; 208: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	CALL W001
; 209: 					clk = 0
	BCF 0x07,1
; 210: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	CALL W001
; 211: 				Endif
L0047:
; 212: 			'Endif
; 213: 			Case 2
	GOTO L0048
L0046:
	MOVF 0x3D,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0049
; 214: 			'If encoder_count > 0 Then
; 215: 			'encoder_count = encoder_count - 1
; 216: 			'Else
; 217: 			'encoder_count = 3
; 218: 					If new_steps > 0 Then
	MOVF 0x31,W
	MOVWF R0L
	MOVF 0x32,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0050
; 219: 						new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x32,W
	MOVWF 0x32
; 220: 						direction = 0
	BCF 0x07,0
; 221: 						clk = 1  'clock out
	BSF 0x07,1
; 222: 						WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	CALL W001
; 223: 						clk = 0
	BCF 0x07,1
; 224: 						WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	CALL W001
; 225: 					Endif
L0050:
; 226: 				'Endif
; 227: 			Case Else
	GOTO L0051
L0049:
; 228: 			EndSelect
L0051:
L0048:
; 229: 		Wend
	GOTO L0043
L0044:
; 230: 		ena = 0
	BCF 0x07,2
; 231: 		If new_steps <> act_steps Then  'now change position
	MOVF 0x31,W
	MOVWF R0L
	MOVF 0x32,W
	MOVWF R0H
	MOVF 0x34,W
	MOVWF R1L
	MOVF 0x35,W
	MOVWF R1H
	CALL C002
	BTFSS STATUS,Z
	GOTO L0052
; 232: 			Write act_pos, new_steps.LB
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0053:	BTFSC EECON1,WR
	GOTO L0053
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 233: 			act_pos = act_pos + 60
	MOVF 0x30,W
	ADDLW 0x3C
	MOVWF 0x30
; 234: 			Write act_pos, new_steps.HB
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0054:	BTFSC EECON1,WR
	GOTO L0054
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 235: 			act_pos = act_pos - 60
	MOVLW 0x3C
	SUBWF 0x30,W
	MOVWF 0x30
; 236: 			act_steps = new_steps
	MOVF 0x31,W
	MOVWF 0x34
	MOVF 0x32,W
	MOVWF 0x35
; 237: 		Endif
L0052:
; 238: 		value = act_pos
	MOVF 0x30,W
	MOVWF 0x38
; 239: 		Gosub i2c_display_nml
	CALL L0008
; 240: 		onoff = 1
	BSF 0x44,0
; 241: 		Gosub relays
	CALL L0011
; 242: 
; 243: Return
	RETURN
; 244: 
; 245: max_adjust:
L0004:
; 246: 	While pgm = 0
L0055:
	BTFSC 0x07,7
	GOTO L0056
; 247: 			value = max_pos
	MOVF 0x33,W
	MOVWF 0x38
; 248: 			Gosub i2c_display_nml
	CALL L0008
; 249: 			Gosub calc_rotation
	CALL L0009
; 250: 			Select Case result
; 251: 			Case 1
	MOVF 0x3D,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0057
; 252: 				If max_pos < 60 Then
	MOVLW 0x3C
	SUBWF 0x33,W
	BTFSC STATUS,C
	GOTO L0058
; 253: 					max_pos = max_pos + 1
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x33
; 254: 				Endif
L0058:
; 255: 			Case 2
	GOTO L0059
L0057:
	MOVF 0x3D,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0060
; 256: 				If max_pos > 4 Then
	MOVF 0x33,W
	SUBLW 0x04
	BTFSC STATUS,C
	GOTO L0061
; 257: 					max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
; 258: 				Endif
L0061:
; 259: 			Case Else
	GOTO L0062
L0060:
; 260: 			EndSelect
L0062:
L0059:
; 261: 	Wend
	GOTO L0055
L0056:
; 262: 	Write 126, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0063:	BTFSC EECON1,WR
	GOTO L0063
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 263: 	half_max_pos = max_pos / 2
	MOVF 0x33,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x4A
; 264: 	
; 265: Return
	RETURN
; 266: 
; 267: steps_reading:
L0005:
; 268: 	eprom_pointer1 = act_pos + 60
	MOVF 0x30,W
	ADDLW 0x3C
	MOVWF 0x46
; 269: 	Read eprom_pointer1, act_steps.HB
	MOVF 0x46,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x35
; 270: 	Read act_pos, act_steps.LB
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 271: 	If new_pos = 0 Then
	MOVF 0x42,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0064
; 272: 		new_steps = 0
	CLRF 0x31
	CLRF 0x32
; 273: 	Else
	GOTO L0065
L0064:
; 274: 		eprom_pointer2 = new_pos + 60
	MOVF 0x42,W
	ADDLW 0x3C
	MOVWF 0x4D
; 275: 		Read eprom_pointer2, new_steps.HB
	MOVF 0x4D,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x32
; 276: 		Read new_pos, new_steps.LB
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 277: 	Endif
L0065:
; 278: Return
	RETURN
; 279: 
; 280: init_eeprom:
L0006:
; 281: 	act_steps = 0
	CLRF 0x34
	CLRF 0x35
; 282: 	act_pos = 0
	CLRF 0x30
; 283: 	eprom_pointer1 = 60
	MOVLW 0x3C
	MOVWF 0x46
; 284: 	For value = 0 To 60
	CLRF 0x38
L0066:
	MOVF 0x38,W
	SUBLW 0x3C
	BTFSS STATUS,C
	GOTO L0067
; 285: 		Write act_pos, act_steps.LB
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0068:	BTFSC EECON1,WR
	GOTO L0068
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 286: 		Write eprom_pointer1, act_steps.HB
	MOVF 0x46,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0069:	BTFSC EECON1,WR
	GOTO L0069
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 287: 		act_steps = act_steps + 256
	MOVF 0x34,W
	ADDLW 0x00
	MOVWF 0x34
	MOVF 0x35,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x01
	MOVWF 0x35
; 288: 		act_pos = act_pos + 1
	MOVF 0x30,W
	ADDLW 0x01
	MOVWF 0x30
; 289: 		eprom_pointer1 = eprom_pointer1 + 1
	MOVF 0x46,W
	ADDLW 0x01
	MOVWF 0x46
; 290: 	Next value
	MOVLW 0x01
	ADDWF 0x38,F
	BTFSS STATUS,C
	GOTO L0066
L0067:
; 291: 	speed_step = 10
	MOVLW 0x0A
	MOVWF 0x45
; 292: 	Write 122, speed_step
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x45,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0070:	BTFSC EECON1,WR
	GOTO L0070
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 293: 	one_round = 8000
	MOVLW 0x40
	MOVWF 0x3B
	MOVLW 0x1F
	MOVWF 0x3C
; 294: 	Write 123, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0071:	BTFSC EECON1,WR
	GOTO L0071
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 295: 	Write 124, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0072:	BTFSC EECON1,WR
	GOTO L0072
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 296: 	Write 125, 1  'act_pos
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x01
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0073:	BTFSC EECON1,WR
	GOTO L0073
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 297: 	Write 126, 60  'max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x3C
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0074:	BTFSC EECON1,WR
	GOTO L0074
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 298: 
; 299: Return
	RETURN
; 300: 
; 301: i2c_convert:
L0007:
; 302: 	ff = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), ff
	MOVF 0x37,W
	SUBLW 0x09
	BTFSS STATUS,C
	GOTO L0075
	CALL L0076
	MOVWF 0x37
	GOTO L0075
L0076:
	MOVLW 0x03
	MOVWF PCLATH
	MOVF 0x37,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
L0075:
; 303: 	ff.7 = pgm
	BTFSC 0x07,7
	BSF 0x37,7
	BTFSS 0x07,7
	BCF 0x37,7
; 304: Return
	RETURN
; 305: 
; 306: 
; 307: i2c_display_nml:
L0008:
; 308: 	If value > 60 Then
	MOVF 0x38,W
	SUBLW 0x3C
	BTFSC STATUS,C
	GOTO L0077
; 309: 		I2CStart
	CALL IC31
; 310: 		I2CSend disp1
	MOVLW 0x40
	CALL IC01
; 311: 		I2CSend %10111111
	MOVLW 0xBF
	CALL IC01
; 312: 		I2CStop
	CALL IC41
; 313: 		I2CStart
	CALL IC31
; 314: 		I2CSend disp2
	MOVLW 0x42
	CALL IC01
; 315: 		I2CSend %10111111
	MOVLW 0xBF
	CALL IC01
; 316: 		I2CStop
	CALL IC41
; 317: 	Else
	GOTO L0078
L0077:
; 318: 		ff = value
	MOVF 0x38,W
	MOVWF 0x37
; 319: 		ff = ff Mod 10
	MOVF 0x37,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x37
; 320: 		Gosub i2c_convert
	CALL L0007
; 321: 		I2CStart
	CALL IC31
; 322: 		I2CSend disp1
	MOVLW 0x40
	CALL IC01
; 323: 		I2CSend ff
	MOVF 0x37,W
	CALL IC01
; 324: 		I2CStop
	CALL IC41
; 325: 		ff = value
	MOVF 0x38,W
	MOVWF 0x37
; 326: 		ff = ff / 10
	MOVF 0x37,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x37
; 327: 		If ff = 0 Then
	MOVF 0x37,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0079
; 328: 			ff = 255
	MOVLW 0xFF
	MOVWF 0x37
; 329: 		Else
	GOTO L0080
L0079:
; 330: 			Gosub i2c_convert
	CALL L0007
; 331: 		Endif
L0080:
; 332: 		I2CStart
	CALL IC31
; 333: 		I2CSend disp2
	MOVLW 0x42
	CALL IC01
; 334: 		I2CSend ff
	MOVF 0x37,W
	CALL IC01
; 335: 		I2CStop
	CALL IC41
; 336: 	Endif
L0078:
; 337: Return
	RETURN
; 338: 
; 339: calc_rotation:
L0009:
; 340: '1 = increasing value
; 341: '2 = decreasing value
; 342: '3 = no change
; 343: 		new_encoder = 0
	CLRF 0x40
; 344: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x40,0
	BTFSS 0x07,4
	BCF 0x40,0
; 345: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x40,1
	BTFSS 0x07,5
	BCF 0x40,1
; 346: 		Select Case old_encoder
; 347: 		Case 0
	MOVF 0x48,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0081
; 348: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x40,W
	SUBLW 0x03
	BTFSS STATUS,C
	GOTO L0082
	CALL L0083
	MOVWF 0x3D
	GOTO L0082
L0083:
	MOVLW 0x03
	MOVWF PCLATH
	MOVF 0x40,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
L0082:
; 349: 		Case 1
	GOTO L0084
L0081:
	MOVF 0x48,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0085
; 350: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x40,W
	SUBLW 0x03
	BTFSS STATUS,C
	GOTO L0086
	CALL L0087
	MOVWF 0x3D
	GOTO L0086
L0087:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	MOVLW 0x04
	MOVWF PCLATH
	MOVF 0x40,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
L0086:
; 351: 		Case 2
	GOTO L0088
L0085:
	MOVF 0x48,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0089
; 352: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x40,W
	SUBLW 0x03
	BTFSS STATUS,C
	GOTO L0090
	CALL L0091
	MOVWF 0x3D
	GOTO L0090
L0091:
	MOVLW 0x04
	MOVWF PCLATH
	MOVF 0x40,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
L0090:
; 353: 		Case Else
	GOTO L0092
L0089:
; 354: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x40,W
	SUBLW 0x03
	BTFSS STATUS,C
	GOTO L0093
	CALL L0094
	MOVWF 0x3D
	GOTO L0093
L0094:
	MOVLW 0x04
	MOVWF PCLATH
	MOVF 0x40,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
L0093:
; 355: 		EndSelect
L0092:
L0088:
L0084:
; 356: 		old_encoder = new_encoder
	MOVF 0x40,W
	MOVWF 0x48
; 357: Return
	RETURN
; 358: 
; 359: stepmotor:
L0010:
; 360: 	speed = 6000
	MOVLW 0x70
	MOVWF 0x3E
	MOVLW 0x17
	MOVWF 0x3F
; 361: 	If new_steps = 0 Then
	MOVF 0x31,W
	MOVWF R0L
	MOVF 0x32,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C001
	BTFSS STATUS,Z
	GOTO L0095
; 362: 		direction = 0
	BCF 0x07,0
; 363: 		ena = 1  'set anable on
	BSF 0x07,2
; 364: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 365: 		While zero = 1  'turn motor until zero switch is activated
L0096:
	BTFSS 0x07,3
	GOTO L0097
; 366: 			clk = 1  'clock out
	BSF 0x07,1
; 367: 			WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	CALL W001
; 368: 			clk = 0
	BCF 0x07,1
; 369: 			WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	CALL W001
; 370: 		Wend
	GOTO L0096
L0097:
; 371: 		ena = 0  'set anable off
	BCF 0x07,2
; 372: 	Else
	GOTO L0098
L0095:
; 373: 		If new_steps > act_steps Then
	MOVF 0x31,W
	MOVWF R0L
	MOVF 0x32,W
	MOVWF R0H
	MOVF 0x34,W
	MOVWF R1L
	MOVF 0x35,W
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0099
; 374: 			steps = new_steps - act_steps
	MOVF 0x34,W
	SUBWF 0x31,W
	MOVWF 0x39
	MOVF 0x35,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x32,W
	MOVWF 0x3A
; 375: 			half_steps = steps / 2
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x50
	MOVF R0H,W
	MOVWF 0x51
; 376: 			direction = 1
	BSF 0x07,0
; 377: 		Else
	GOTO L0100
L0099:
; 378: 			steps = act_steps - new_steps
	MOVF 0x31,W
	SUBWF 0x34,W
	MOVWF 0x39
	MOVF 0x32,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x35,W
	MOVWF 0x3A
; 379: 			half_steps = steps / 2
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x50
	MOVF R0H,W
	MOVWF 0x51
; 380: 			direction = 0  'go reverse
	BCF 0x07,0
; 381: 		Endif
L0100:
; 382: 		If steps > 1200 Then  'calculate on what position speed change have to be done
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVLW 0xB0
	MOVWF R1L
	MOVLW 0x04
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0101
; 383: 			dp = 600
	MOVLW 0x58
	MOVWF 0x4B
	MOVLW 0x02
	MOVWF 0x4C
; 384: 			ip = steps - 600
	MOVLW 0x58
	SUBWF 0x39,W
	MOVWF 0x4E
	MOVLW 0x02
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3A,W
	MOVWF 0x4F
; 385: 		Else  'less speed change because of shorter time
	GOTO L0102
L0101:
; 386: 			dp = steps / 2
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x4B
	MOVF R0H,W
	MOVWF 0x4C
; 387: 			ip = dp
	MOVF 0x4B,W
	MOVWF 0x4E
	MOVF 0x4C,W
	MOVWF 0x4F
; 388: 		Endif
L0102:
; 389: 		ena = 1  'set anable on
	BSF 0x07,2
; 390: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 391: 		While steps > 0  'shortest step =500uSec longest step = 5000uSec
L0103:
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0104
; 392: 'the real values have to be calibrated later on pracical test
; 393: 			If steps > ip Then  'increase speed
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVF 0x4E,W
	MOVWF R1L
	MOVF 0x4F,W
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0105
; 394: 				If speed > 3000 Then
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVLW 0xB8
	MOVWF R1L
	MOVLW 0x0B
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0106
; 395: 					speed = speed - speed_step
	MOVF 0x45,W
	SUBWF 0x3E,W
	MOVWF 0x3E
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x3F
; 396: 				Endif
L0106:
; 397: 			Endif
L0105:
; 398: 			If steps < dp Then
	MOVF 0x39,W
	MOVWF R0L
	MOVF 0x3A,W
	MOVWF R0H
	MOVF 0x4B,W
	MOVWF R1L
	MOVF 0x4C,W
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0107
; 399: 				If speed < 6000 Then  'slow down
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVLW 0x70
	MOVWF R1L
	MOVLW 0x17
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0108
; 400: 					speed = speed + speed_step
	MOVF 0x3E,W
	ADDWF 0x45,W
	MOVWF 0x3E
	MOVF 0x3F,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x3F
; 401: 				Endif
L0108:
; 402: 			Endif
L0107:
; 403: 			clk = 1  'clock out
	BSF 0x07,1
; 404: 			WaitUs speed
	MOVF 0x3E,W
	MOVWF R4L
	MOVF 0x3F,W
	MOVWF R4H
	CALL Y001
; 405: 			clk = 0
	BCF 0x07,1
; 406: 			WaitUs speed
	MOVF 0x3E,W
	MOVWF R4L
	MOVF 0x3F,W
	MOVWF R4H
	CALL Y001
; 407: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x39,W
	MOVWF 0x39
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3A,W
	MOVWF 0x3A
; 408: 		Wend
	GOTO L0103
L0104:
; 409: 		ena = 0  'enable off
	BCF 0x07,2
; 410: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 411: 	Endif
L0098:
; 412: 
; 413: Return
	RETURN
; 414: 
; 415: 
; 416: relays:
L0011:
; 417: 	If onoff = 1 Then
	BTFSS 0x44,0
	GOTO L0109
; 418: 		If act_pos > half_max_pos Then  'select polarity rails on bridge
	MOVF 0x30,W
	SUBWF 0x4A,W
	BTFSC STATUS,C
	GOTO L0110
; 419: 			swfw = 0
	BCF 0x06,0
; 420: 			swrev = 1
	BSF 0x06,1
; 421: 		Else
	GOTO L0111
L0110:
; 422: 			swrev = 0
	BCF 0x06,1
; 423: 			swfw = 1
	BSF 0x06,0
; 424: 		Endif
L0111:
; 425: 	Else
	GOTO L0112
L0109:
; 426: 		swfw = 0
	BCF 0x06,0
; 427: 		swrev = 0
	BCF 0x06,1
; 428: 	Endif
L0112:
; 429: Return
	RETURN
; 430: 
; 431: 
; End of program
L0113:	GOTO L0113
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
