; Compiled with: PIC Simulator IDE v6.91
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_act_pos' (global) is 127
;       The value of 'mem_speed_min' (global) is 103
;       The value of 'mem_speed_max' (global) is 104
;       The value of 'mem_speed_step' (global) is 105
;       The value of 'mem_one_round_lb' (global) is 106
;       The value of 'mem_one_round_hb' (global) is 107
;       The value of 'mem_ctrl_type' (global) is 108
;       The value of 'mem_max_pos' (global) is 109
;       The value of 'mem_free_space' (global) is 110
;       The value of 'mem_rev_pos' (global) is 111
;       The value of 'mem_bridge_power' (global) is 112
;       The value of 'mem_pos_match_delay' (global) is 113
;       The address of 'steps' (word) (global) is 0x30
	steps EQU 0x30
;       The address of 'speed_min' (word) (global) is 0x32
	speed_min EQU 0x32
;       The address of 'act_pos' (byte) (global) is 0x34
	act_pos EQU 0x34
;       The address of 'value' (byte) (global) is 0x35
	value EQU 0x35
;       The address of 'speed_max' (word) (global) is 0x36
	speed_max EQU 0x36
;       The address of 'manual_pos' (byte) (global) is 0x38
	manual_pos EQU 0x38
;       The address of 'max_pos' (byte) (global) is 0x39
	max_pos EQU 0x39
;       The address of 'result' (byte) (global) is 0x3A
	result EQU 0x3A
;       The address of 'new_steps' (word) (global) is 0x3B
	new_steps EQU 0x3B
;       The address of 'free_space_steps' (byte) (global) is 0x3D
	free_space_steps EQU 0x3D
;       The address of 'pos_match_delay' (byte) (global) is 0x3E
	pos_match_delay EQU 0x3E
;       The address of 'one_round' (word) (global) is 0x3F
	one_round EQU 0x3F
;       The address of 'program_set' (byte) (global) is 0x41
	program_set EQU 0x41
;       The address of 'speed_step' (byte) (global) is 0x42
	speed_step EQU 0x42
;       The address of 'act_steps' (word) (global) is 0x43
	act_steps EQU 0x43
;       The address of 'new_pos' (byte) (global) is 0x45
	new_pos EQU 0x45
;       The address of 'eprom_pointer' (byte) (global) is 0x46
	eprom_pointer EQU 0x46
;       The address of 'speed' (word) (global) is 0x47
	speed EQU 0x47
;       The address of 'disp1_val' (byte) (global) is 0x49
	disp1_val EQU 0x49
;       The address of 'new_encoder' (byte) (global) is 0x4A
	new_encoder EQU 0x4A
;       The address of 'encoder_count' (byte) (global) is 0x4B
	encoder_count EQU 0x4B
;       The address of 'bridge_power' (byte) (global) is 0x4C
	bridge_power EQU 0x4C
;       The address of 'adjust_en' (byte) (global) is 0x4D
	adjust_en EQU 0x4D
;       The address of 'bus_pos' (byte) (global) is 0x4E
	bus_pos EQU 0x4E
;       The address of 'onoff' (bit) (global) is 0x4F,0
;       The address of 'disp2_val' (byte) (global) is 0x50
	disp2_val EQU 0x50
;       The address of 'version' (bit) (global) is 0x4F,1
;       The address of 'steps_set' (bit) (global) is 0x4F,2
;       The address of 'ramp_up' (bit) (global) is 0x4F,3
;       The address of 'ramp_down_point' (word) (global) is 0x51
	ramp_down_point EQU 0x51
;       The address of 'old_encoder' (byte) (global) is 0x53
	old_encoder EQU 0x53
;       The address of 'old_manual_pos' (byte) (global) is 0x54
	old_manual_pos EQU 0x54
;       The address of 'old_pos_write' (bit) (global) is 0x4F,4
;       The address of 'old_bus_pos' (byte) (global) is 0x55
	old_bus_pos EQU 0x55
;       The address of 'half_steps' (word) (global) is 0x56
	half_steps EQU 0x56
;       The address of 'one_round_half' (word) (global) is 0x58
	one_round_half EQU 0x58
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x6,6
;       The address of 'max_end' (bit) (global) is 0x6,7
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0015
	ORG 0x0004
	RETFIE
; LookUp Table: (3, 2, 1, 3)
_lookup_lab_0001:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
; LookUp Table: (1, 3, 3, 2)
_lookup_lab_0002:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
; LookUp Table: (2, 3, 3, 1)
_lookup_lab_0003:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
; LookUp Table: (3, 1, 2, 3)
_lookup_lab_0004:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0005:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; LookUp Table: (%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111)
_lookup_lab_0006:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0007:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0015:
; 1: Define CONF_WORD = 0x3f72
; 2: 
; 3: 'program TT for PCBoard MGV145
; 4: 'special version V9-1  small fiddle yard RDS
; 5: 'RB7 on ICSP1 (pin3) is endswitch (pass last rail)
; 6: 'RB6 on ICSP1 (pin2) is endswitch (pass first rail)
; 7: 'EEP jumper must always be at ON !
; 8: 'two extra position are possible:
; 9: '-  position 63 to go to zero switch and then to rail 0
; 10: '-  position 62 to reset and recalculate all values (only when menu 8 is set)
; 11: 'programs :
; 12: '0  correction actual position
; 13: '1  Max positions
; 14: '2  min speed
; 15: '3  max speed
; 16: '4  incr/decr delay
; 17: '5  extra correction steps
; 18: '6  bridge power on/off (1/0)
; 19: '7  pos_match delay
; 20: '8  adjust_position >>>: this enables / disables the choice of pos 62
; 21: Dim steps As Word
; 22: Dim half_steps As Word
; 23: Dim ramp_down_point As Word
; 24: Dim program_set As Byte
; 25: Dim new_steps As Word
; 26: Dim act_steps As Word
; 27: Dim new_pos As Byte
; 28: Dim act_pos As Byte
; 29: Dim one_round As Word
; 30: Dim one_round_half As Word
; 31: Dim bus_pos As Byte
; 32: Dim old_bus_pos As Byte
; 33: Dim speed As Word
; 34: Dim speed_min As Word
; 35: Dim speed_max As Word
; 36: Dim new_encoder As Byte
; 37: Dim old_encoder As Byte
; 38: Dim manual_pos As Byte
; 39: Dim old_manual_pos As Byte
; 40: Dim result As Byte
; 41: Dim free_space_steps As Byte
; 42: Dim value As Byte
; 43: Dim eprom_pointer As Byte
; 44: Dim encoder_count As Byte
; 45: Dim onoff As Bit
; 46: Dim max_pos As Byte
; 47: Dim disp1_val As Byte
; 48: Dim disp2_val As Byte
; 49: Dim old_pos_write As Bit
; 50: Dim ramp_up As Bit
; 51: Dim speed_step As Byte
; 52: Dim version As Bit
; 53: Dim steps_set As Bit
; 54: Dim bridge_power As Byte
; 55: Dim pos_match_delay As Byte
; 56: Dim adjust_en As Byte
; 57: 
; 58: Const disp1 = 64
; 59: Const disp2 = 66
; 60: Const mem_act_pos = 127
; 61: Const mem_speed_min = 103
; 62: Const mem_speed_max = 104
; 63: Const mem_speed_step = 105
; 64: Const mem_one_round_lb = 106
; 65: Const mem_one_round_hb = 107
; 66: Const mem_ctrl_type = 108
; 67: Const mem_max_pos = 109
; 68: Const mem_free_space = 110
; 69: Const mem_rev_pos = 111
; 70: Const mem_bridge_power = 112
; 71: Const mem_pos_match_delay = 113
; 72: 
; 73: Symbol swfw = RB0
; 74: Symbol sck = RB2
; 75: Symbol sda = RB3
; 76: Symbol pos_match = RB4
; 77: Symbol pos_write = RB5
; 78: Symbol direction = RC0
; 79: Symbol clk = RC1
; 80: Symbol ena = RC2
; 81: Symbol zero = RB6
; 82: Symbol max_end = RB7
; 83: Symbol ec1 = RC4
; 84: Symbol ec2 = RC5
; 85: Symbol ecsw = RC6
; 86: Symbol pgm = RC7
; 87: 
; 88: ADCON1 = %0110
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 89: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 90: TRISB = %11101110
	MOVLW 0xEE
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 91: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 92: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 93: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 94: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 95: Gosub init_values
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0010
; 96: onoff = 1
	BSF 0x4F,0
; 97: Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 98: program_set = 0
	CLRF 0x41
; 99: max_end = 1
	BSF 0x06,7
; 100: adjust_en = 0
	CLRF 0x4D
; 101: main:
L0001:
; 102: 	If pgm = 0 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0016
; 103: 		Gosub adjust_settings
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0004
; 104: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 105: 	Endif
L0016:
; 106: 
; 107: 	Gosub get_new_position
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0002
; 108: 	If bus_pos <> old_bus_pos Then
	MOVF 0x4E,W
	SUBWF 0x55,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0017
; 109: 		onoff = 0
	BCF 0x4F,0
; 110: 		Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 111: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 112: 		new_pos = bus_pos
	MOVF 0x4E,W
	MOVWF 0x45
; 113: 		Gosub stepmotor
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0007
; 114: 		Gosub wait_pos_match
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 115: 		onoff = 1
	BSF 0x4F,0
; 116: 	Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0018
L0017:
; 117: 		If ecsw = 0 Then  'only when knob is pushed
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0019
; 118: 			If manual_pos <> old_manual_pos Then
	MOVF 0x38,W
	SUBWF 0x54,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0020
; 119: 				onoff = 0
	BCF 0x4F,0
; 120: 				Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 121: 				pos_match = 1  'indicate not in position
	BSF 0x06,4
; 122: 				old_manual_pos = manual_pos
	MOVF 0x38,W
	MOVWF 0x54
; 123: 				new_pos = manual_pos
	MOVF 0x38,W
	MOVWF 0x45
; 124: 				Gosub stepmotor
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0007
; 125: 				Gosub wait_pos_match
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 126: 				onoff = 1
	BSF 0x4F,0
; 127: 			Endif
L0020:
; 128: 		Endif
L0019:
; 129: 	Endif
L0018:
; 130: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 131: 	Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 132: 	Goto main
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0001
; 133: End
;       PAGE SELECT
	BCF PCLATH,3
L0021:	GOTO L0021
; 134: 
; 135: 
; 136: get_new_position:
L0002:
; 137: 	value = bus_pos  'remember the position
	MOVF 0x4E,W
	MOVWF 0x35
; 138: 	If pos_write = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,5
	GOTO L0022
; 139: 		If old_pos_write = 0 Then  'react once on rising edge
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x4F,4
	GOTO L0023
; 140: 			old_pos_write = 1
	BSF 0x4F,4
; 141: 			value = PORTA And 63  'now get value from J5
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x35
; 142: 			Select Case value
; 143: 			Case 63  'position reset is desired
	MOVF 0x35,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0024
; 144: 				value = 63
	MOVLW 0x3F
	MOVWF 0x35
; 145: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0025
L0024:
; 146: 				If value > max_pos Then  'this is not allowed
	MOVF 0x35,W
	SUBWF 0x39,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0026
; 147: 					value = bus_pos  'put it back to old situation
	MOVF 0x4E,W
	MOVWF 0x35
; 148: 				Endif
L0026:
; 149: 			EndSelect
L0025:
; 150: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 151: 			If value = bus_pos Then  'no other position is set, just a response on pos_write is required
	MOVF 0x35,W
	SUBWF 0x4E,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0027
; 152: 				pos_match = 1
	BSF 0x06,4
; 153: 				WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 154: 				pos_match = 0
	BCF 0x06,4
; 155: 			Endif
L0027:
; 156: 		Endif
L0023:
; 157: 	Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0028
L0022:
; 158: 		old_pos_write = 0
	BCF 0x4F,4
; 159: 	Endif
L0028:
; 160: 	bus_pos = value  'now take over the desired position
	MOVF 0x35,W
	MOVWF 0x4E
; 161: 	Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 162: 	Select Case result
; 163: 	Case 1
	MOVF 0x3A,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0029
; 164: 		If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x4B,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0030
; 165: 			encoder_count = encoder_count + 1
	MOVF 0x4B,W
	ADDLW 0x01
	MOVWF 0x4B
; 166: 		Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0031
L0030:
; 167: 			encoder_count = 0
	CLRF 0x4B
; 168: 			Select Case manual_pos
; 169: 			Case < max_pos
	MOVF 0x39,W
	SUBWF 0x38,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0032
; 170: 				manual_pos = manual_pos + 1
	MOVF 0x38,W
	ADDLW 0x01
	MOVWF 0x38
; 171: 			Case max_pos
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0033
L0032:
	MOVF 0x38,W
	SUBWF 0x39,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0034
; 172: 				Select Case adjust_en
; 173: 				Case 0
	MOVF 0x4D,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0035
; 174: 					manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x38
; 175: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0036
L0035:
; 176: 					manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x38
; 177: 				EndSelect
L0036:
; 178: 			Case 63
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0037
L0034:
	MOVF 0x38,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0038
; 179: 				manual_pos = 0
	CLRF 0x38
; 180: 			Case 62
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0039
L0038:
	MOVF 0x38,W
	SUBLW 0x3E
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0040
; 181: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x38
; 182: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0041
L0040:
; 183: 			EndSelect
L0041:
L0039:
L0037:
L0033:
; 184: 			value = manual_pos
	MOVF 0x38,W
	MOVWF 0x35
; 185: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 186: 		Endif
L0031:
; 187: 	Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0042
L0029:
	MOVF 0x3A,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0043
; 188: 		If encoder_count > 0 Then
	MOVF 0x4B,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0044
; 189: 			encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x4B,W
	MOVWF 0x4B
; 190: 		Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0045
L0044:
; 191: 			encoder_count = 4
	MOVLW 0x04
	MOVWF 0x4B
; 192: 			Select Case manual_pos
; 193: 			Case 62
	MOVF 0x38,W
	SUBLW 0x3E
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0046
; 194: 				manual_pos = max_pos
	MOVF 0x39,W
	MOVWF 0x38
; 195: 			Case 63
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0047
L0046:
	MOVF 0x38,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0048
; 196: 				Select Case adjust_en
; 197: 				Case 0
	MOVF 0x4D,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0049
; 198: 					manual_pos = max_pos
	MOVF 0x39,W
	MOVWF 0x38
; 199: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0050
L0049:
; 200: 					manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x38
; 201: 				EndSelect
L0050:
; 202: 			Case 0
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0051
L0048:
	MOVF 0x38,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0052
; 203: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x38
; 204: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0053
L0052:
; 205: 				manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x38,W
	MOVWF 0x38
; 206: 			EndSelect
L0053:
L0051:
L0047:
; 207: 			value = manual_pos
	MOVF 0x38,W
	MOVWF 0x35
; 208: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 209: 		Endif
L0045:
; 210: 	Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0054
L0043:
; 211: 	EndSelect
L0054:
L0042:
; 212: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 213: 	
; 214: Return
	RETURN
; 215: 
; 216: calc_rotation:  'this routine checks the incrimental switch
L0003:
; 217: '1 = increasing value
; 218: '2 = decreasing value
; 219: '3 = no change
; 220: 		new_encoder = 0
	CLRF 0x4A
; 221: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x4A,0
	BTFSS 0x07,4
	BCF 0x4A,0
; 222: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x4A,1
	BTFSS 0x07,5
	BCF 0x4A,1
; 223: 		Select Case old_encoder
; 224: 		Case 0
	MOVF 0x53,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0055
; 225: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x4A,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0056
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0001
	MOVWF 0x3A
L0056:
; 226: 		Case 1
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0057
L0055:
	MOVF 0x53,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0058
; 227: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x4A,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0059
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0002
	MOVWF 0x3A
L0059:
; 228: 		Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0060
L0058:
	MOVF 0x53,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0061
; 229: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x4A,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0062
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0003
	MOVWF 0x3A
L0062:
; 230: 		Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0063
L0061:
; 231: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x4A,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0064
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0004
	MOVWF 0x3A
L0064:
; 232: 		EndSelect
L0063:
L0060:
L0057:
; 233: 		old_encoder = new_encoder
	MOVF 0x4A,W
	MOVWF 0x53
; 234: Return
	RETURN
; 235: 
; 236: 
; 237: adjust_settings:
L0004:
; 238: 	Gosub i2c_display_pgm
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0006
; 239: 	WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 240: 	onoff = 0
	BCF 0x4F,0
; 241: 	Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 242: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 243: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x43,W
	MOVWF 0x3B
	MOVF 0x44,W
	MOVWF 0x3C
; 244: 	While pgm = 0  'the program switch is still activated
L0065:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0066
; 245: 		If ecsw = 0 Then  'knob is pressed, inrease program_set
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0067
; 246: 			program_set = program_set + 1
	MOVF 0x41,W
	ADDLW 0x01
	MOVWF 0x41
; 247: 			If program_set > 8 Then  'no more than 8 items te change
	MOVF 0x41,W
	SUBLW 0x08
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0068
; 248: 				program_set = 0
	CLRF 0x41
; 249: 			Endif
L0068:
; 250: 			Gosub i2c_display_pgm
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0006
; 251: 			WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 252: 			While ecsw = 0  'be sure pushbutton is released
L0069:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0070
; 253: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 254: 			Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0069
L0070:
; 255: 		Endif
L0067:
; 256: 		Select Case program_set
; 257: 		Case 0  'correction of current position
	MOVF 0x41,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0071
; 258: 			value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 259: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 260: 			Gosub calc_rotation  'look for the knob to be turned
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 261: 			Select Case result
; 262: 			Case 1
	MOVF 0x3A,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0072
; 263: 				If new_steps < 60000 Then
	MOVF 0x3B,W
	MOVWF R0L
	MOVF 0x3C,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0073
; 264: 					ena = 1  'motor on
	BSF 0x07,2
; 265: 					new_steps = new_steps + 1
	MOVF 0x3B,W
	ADDLW 0x01
	MOVWF 0x3B
	MOVF 0x3C,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3C
; 266: 					direction = 1
	BSF 0x07,0
; 267: 					clk = 1  'clock out
	BSF 0x07,1
; 268: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 269: 					clk = 0
	BCF 0x07,1
; 270: 				Endif
L0073:
; 271: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0074
L0072:
	MOVF 0x3A,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0075
; 272: 				If new_steps > 0 Then
	MOVF 0x3B,W
	MOVWF R0L
	MOVF 0x3C,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0076
; 273: 					ena = 1  'motor on
	BSF 0x07,2
; 274: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x3B
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3C,W
	MOVWF 0x3C
; 275: 					direction = 0
	BCF 0x07,0
; 276: 					clk = 1  'clock out
	BSF 0x07,1
; 277: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 278: 					clk = 0
	BCF 0x07,1
; 279: 				Endif
L0076:
; 280: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0077
L0075:
; 281: 			EndSelect
L0077:
L0074:
; 282: 		Case 1  'setting of maximum positions
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0078
L0071:
	MOVF 0x41,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0079
; 283: 			steps_set = 0
	BCF 0x4F,2
; 284: 			ena = 0  'shut off motor
	BCF 0x07,2
; 285: 			value = max_pos
	MOVF 0x39,W
	MOVWF 0x35
; 286: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 287: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 288: 			Select Case result
; 289: 			Case 1
	MOVF 0x3A,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0080
; 290: 				If max_pos < 12 Then  'no more positions possible
	MOVLW 0x0C
	SUBWF 0x39,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0081
; 291: 					max_pos = max_pos + 1
	MOVF 0x39,W
	ADDLW 0x01
	MOVWF 0x39
; 292: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0082:	BTFSC EECON1,WR
	GOTO L0082
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 293: 				Endif
L0081:
; 294: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0083
L0080:
	MOVF 0x3A,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0084
; 295: 				If max_pos > 2 Then  'minum 2 positions
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0085
; 296: 					max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x39,W
	MOVWF 0x39
; 297: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0086:	BTFSC EECON1,WR
	GOTO L0086
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 298: 				Endif
L0085:
; 299: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0087
L0084:
; 300: 			EndSelect
L0087:
L0083:
; 301: 		Case 2  'setting of speed interval Minimum
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0088
L0079:
	MOVF 0x41,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0089
; 302: 					'setting will be done in multiple of 256 uSecs
; 303: 					'minimum is 2 and maximum is 99 (is real slow)
; 304: 			steps_set = 0
	BCF 0x4F,2
; 305: 			ena = 0  'shut off motor
	BCF 0x07,2
; 306: 			value = speed_min.HB
	MOVF 0x33,W
	MOVWF 0x35
; 307: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 308: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 309: 			Select Case result
; 310: 			Case 1
	MOVF 0x3A,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0090
; 311: 				If speed_min.HB < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x33,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0091
; 312: 					speed_min.HB = speed_min.HB + 1
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x33
; 313: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0092:	BTFSC EECON1,WR
	GOTO L0092
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 314: 				Endif
L0091:
; 315: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0093
L0090:
	MOVF 0x3A,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0094
; 316: 				If speed_min.HB > speed_max.HB Then
	MOVF 0x33,W
	SUBWF 0x37,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0095
; 317: 					speed_min.HB = speed_min.HB - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
; 318: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0096:	BTFSC EECON1,WR
	GOTO L0096
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 319: 				Endif
L0095:
; 320: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0097
L0094:
; 321: 			EndSelect
L0097:
L0093:
; 322: 		Case 3  'setting of speed interval Maximum
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0098
L0089:
	MOVF 0x41,W
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0099
; 323: 					'setting will be done in multiple of 256 uSecs
; 324: 					'minimum is 1 and maximum is 99 (is real slow)
; 325: 			steps_set = 0
	BCF 0x4F,2
; 326: 			ena = 0  'shut off motor
	BCF 0x07,2
; 327: 			value = speed_max.HB
	MOVF 0x37,W
	MOVWF 0x35
; 328: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 329: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 330: 			Select Case result
; 331: 			Case 1
	MOVF 0x3A,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0100
; 332: 				If speed_max.HB < speed_min.HB Then  'not more then speed_min
	MOVF 0x33,W
	SUBWF 0x37,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0101
; 333: 					speed_max.HB = speed_max.HB + 1
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x37
; 334: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0102:	BTFSC EECON1,WR
	GOTO L0102
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 335: 				Endif
L0101:
; 336: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0103
L0100:
	MOVF 0x3A,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0104
; 337: 				If speed_max.HB > 2 Then
	MOVF 0x37,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0105
; 338: 					speed_max.HB = speed_max.HB - 1
	MOVLW 0x01
	SUBWF 0x37,W
	MOVWF 0x37
; 339: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0106:	BTFSC EECON1,WR
	GOTO L0106
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 340: 				Endif
L0105:
; 341: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0107
L0104:
; 342: 			EndSelect
L0107:
L0103:
; 343: 		Case 4  'setting of ramp up and down speed
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0108
L0099:
	MOVF 0x41,W
	SUBLW 0x04
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0109
; 344: 					'speed will be the value that speed will be changed every step up and down
; 345: 			steps_set = 0
	BCF 0x4F,2
; 346: 			ena = 0  'shut off motor
	BCF 0x07,2
; 347: 			value = speed_step
	MOVF 0x42,W
	MOVWF 0x35
; 348: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 349: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 350: 			Select Case result
; 351: 			Case 1
	MOVF 0x3A,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0110
; 352: 				If speed_step < 99 Then  'maximum 99 is possible
	MOVLW 0x63
	SUBWF 0x42,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0111
; 353: 					speed_step = speed_step + 1
	MOVF 0x42,W
	ADDLW 0x01
	MOVWF 0x42
; 354: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0112:	BTFSC EECON1,WR
	GOTO L0112
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 355: 				Endif
L0111:
; 356: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0113
L0110:
	MOVF 0x3A,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0114
; 357: 				If speed_step > 1 Then
	MOVF 0x42,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0115
; 358: 					speed_step = speed_step - 1
	MOVLW 0x01
	SUBWF 0x42,W
	MOVWF 0x42
; 359: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0116:	BTFSC EECON1,WR
	GOTO L0116
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 360: 				Endif
L0115:
; 361: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0117
L0114:
; 362: 			EndSelect
L0117:
L0113:
; 363: 	
; 364: 		Case 5  'setting of extra free space steps
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0118
L0109:
	MOVF 0x41,W
	SUBLW 0x05
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0119
; 365: 			steps_set = 0
	BCF 0x4F,2
; 366: 			ena = 0  'shut off motor
	BCF 0x07,2
; 367: 			If free_space_steps > 250 Then
	MOVF 0x3D,W
	SUBLW 0xFA
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0120
; 368: 				free_space_steps = 250
	MOVLW 0xFA
	MOVWF 0x3D
; 369: 				Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0121:	BTFSC EECON1,WR
	GOTO L0121
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 370: 			Endif
L0120:
; 371: 			value = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x35
; 372: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 373: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 374: 			Select Case result
; 375: 			Case 1
	MOVF 0x3A,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0122
; 376: 				If free_space_steps < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x3D,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0123
; 377: 					free_space_steps = free_space_steps + 1
	MOVF 0x3D,W
	ADDLW 0x01
	MOVWF 0x3D
; 378: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0124:	BTFSC EECON1,WR
	GOTO L0124
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 379: 				Endif
L0123:
; 380: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0125
L0122:
	MOVF 0x3A,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0126
; 381: 				If free_space_steps > 0 Then
	MOVF 0x3D,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0127
; 382: 					free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
; 383: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0128:	BTFSC EECON1,WR
	GOTO L0128
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 384: 				Endif
L0127:
; 385: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0129
L0126:
; 386: 			EndSelect
L0129:
L0125:
; 387: 		Case 6  'setting if power should be on or off while bridge is moving (0 = off)
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0130
L0119:
	MOVF 0x41,W
	SUBLW 0x06
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0131
; 388: 			Read mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x4C
; 389: 			If bridge_power > 1 Then
	MOVF 0x4C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0132
; 390: 				bridge_power = 1
	MOVLW 0x01
	MOVWF 0x4C
; 391: 			Endif
L0132:
; 392: 			value = bridge_power
	MOVF 0x4C,W
	MOVWF 0x35
; 393: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 394: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 395: 			Select Case result
; 396: 			Case 1
	MOVF 0x3A,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0133
; 397: 				bridge_power = 1
	MOVLW 0x01
	MOVWF 0x4C
; 398: 				Write mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x4C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0134:	BTFSC EECON1,WR
	GOTO L0134
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 399: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0135
L0133:
	MOVF 0x3A,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0136
; 400: 				bridge_power = 0
	CLRF 0x4C
; 401: 				Write mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x4C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0137:	BTFSC EECON1,WR
	GOTO L0137
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 402: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0138
L0136:
; 403: 			EndSelect
L0138:
L0135:
; 404: 		Case 7  'setting delay in millisecs before tt is ready is sent)
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0139
L0131:
	MOVF 0x41,W
	SUBLW 0x07
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0140
; 405: 			Read mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3E
; 406: 			If pos_match_delay > 50 Then
	MOVF 0x3E,W
	SUBLW 0x32
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0141
; 407: 				pos_match_delay = 50
	MOVLW 0x32
	MOVWF 0x3E
; 408: 			Endif
L0141:
; 409: 			value = pos_match_delay
	MOVF 0x3E,W
	MOVWF 0x35
; 410: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 411: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 412: 			Select Case result
; 413: 			Case 1
	MOVF 0x3A,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0142
; 414: 				If pos_match_delay < 50 Then
	MOVLW 0x32
	SUBWF 0x3E,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0143
; 415: 					pos_match_delay = pos_match_delay + 1
	MOVF 0x3E,W
	ADDLW 0x01
	MOVWF 0x3E
; 416: 				Endif
L0143:
; 417: 				Write mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0144:	BTFSC EECON1,WR
	GOTO L0144
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 418: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0145
L0142:
	MOVF 0x3A,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0146
; 419: 				If pos_match_delay > 0 Then
	MOVF 0x3E,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0147
; 420: 					pos_match_delay = pos_match_delay - 1
	MOVLW 0x01
	SUBWF 0x3E,W
	MOVWF 0x3E
; 421: 				Endif
L0147:
; 422: 				Write mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0148:	BTFSC EECON1,WR
	GOTO L0148
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 423: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0149
L0146:
; 424: 			EndSelect
L0149:
L0145:
; 425: 		Case Else  'menu 8 , setting if postion 62 is possible to reset and calculate all positions
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0150
L0140:
; 426: 			If adjust_en > 1 Then
	MOVF 0x4D,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0151
; 427: 				adjust_en = 1
	MOVLW 0x01
	MOVWF 0x4D
; 428: 			Endif
L0151:
; 429: 			value = adjust_en
	MOVF 0x4D,W
	MOVWF 0x35
; 430: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 431: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 432: 			Select Case result
; 433: 			Case 1
	MOVF 0x3A,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0152
; 434: 				adjust_en = 1
	MOVLW 0x01
	MOVWF 0x4D
; 435: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0153
L0152:
	MOVF 0x3A,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0154
; 436: 				adjust_en = 0
	CLRF 0x4D
; 437: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0155
L0154:
; 438: 			EndSelect
L0155:
L0153:
; 439: 		EndSelect
L0150:
L0139:
L0130:
L0118:
L0108:
L0098:
L0088:
L0078:
; 440: 	Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0065
L0066:
; 441: 	ena = 0  'shut off motor
	BCF 0x07,2
; 442: 		'***************   now check if changes have to BE written in eeprom
; 443: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x3B,W
	MOVWF R0L
	MOVF 0x3C,W
	MOVWF R0H
	MOVF 0x43,W
	MOVWF R1L
	MOVF 0x44,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C002
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0156
; 444: 		Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 445: 	Endif
L0156:
; 446: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 447: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 448: 	onoff = 1
	BSF 0x4F,0
; 449: 	Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 450: Return
	RETURN
; 451: 
; 452: i2c_display:
L0005:
; 453: 	Select Case value
; 454: 	Case 99
	MOVF 0x35,W
	SUBLW 0x63
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0157
; 455: 		disp1_val = %10111111
	MOVLW 0xBF
	MOVWF 0x49
; 456: 		disp2_val = %10111111
	MOVLW 0xBF
	MOVWF 0x50
; 457: 	Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0158
L0157:
; 458: 		disp1_val = value
	MOVF 0x35,W
	MOVWF 0x49
; 459: 		disp1_val = disp1_val Mod 10
	MOVF 0x49,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x49
; 460: 		disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x49,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0159
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0005
	MOVWF 0x49
L0159:
; 461: 		disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x49,7
	BTFSS 0x07,7
	BCF 0x49,7
; 462: 		disp2_val = value
	MOVF 0x35,W
	MOVWF 0x50
; 463: 		disp2_val = disp2_val / 10
	MOVF 0x50,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x50
; 464: 		disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x50,W
	MOVWF R0L
	SUBLW 0x0A
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0160
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0006
	MOVWF 0x50
L0160:
; 465: 		disp2_val.7 = version
	BTFSC 0x4F,1
	BSF 0x50,7
	BTFSS 0x4F,1
	BCF 0x50,7
; 466: 	EndSelect
L0158:
; 467: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 468: 	I2CSend disp1
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 469: 	I2CSend disp1_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x49,W
	CALL IC01
; 470: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 471: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 472: 	I2CSend disp2
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 473: 	I2CSend disp2_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x50,W
	CALL IC01
; 474: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 475: Return
	RETURN
; 476: 
; 477: i2c_display_pgm:
L0006:
; 478: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), program_set
	MOVF 0x41,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0161
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0007
	MOVWF 0x49
L0161:
; 479: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 480: 	I2CSend disp1
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 481: 	I2CSend disp1_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x49,W
	CALL IC01
; 482: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 483: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 484: 	I2CSend disp2
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 485: 	I2CSend %10111111
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 486: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 487: Return
	RETURN
; 488: 
; 489: stepmotor:
L0007:
; 490: 	speed = 0
	CLRF 0x47
	CLRF 0x48
; 491: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 492: 	Select Case new_pos
; 493: 	Case 62  'this is the complete correction setting
	MOVF 0x45,W
	SUBLW 0x3E
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0162
; 494: 		direction = 1  'first forward
	BSF 0x07,0
; 495: 		ena = 1  'set anable on
	BSF 0x07,2
; 496: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 497: 		While max_end = 1  'turn motor until end switch is activated
L0163:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,7
	GOTO L0164
; 498: 			clk = 1  'clock out
	BSF 0x07,1
; 499: 			WaitUs speed_max
	MOVF 0x36,W
	MOVWF R4L
	MOVF 0x37,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 500: 			clk = 0
	BCF 0x07,1
; 501: 'WaitUs speed_max
; 502: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0163
L0164:
; 503: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 504: 		one_round = 0  'start counting one round steps
	CLRF 0x3F
	CLRF 0x40
; 505: 		ena = 1  'set anable on
	BSF 0x07,2
; 506: 		direction = 0  'now backwards
	BCF 0x07,0
; 507: 		While zero = 1  'turn motor until zero switch is activated
L0165:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0166
; 508: 			clk = 1  'clock out
	BSF 0x07,1
; 509: 			WaitUs speed_max
	MOVF 0x36,W
	MOVWF R4L
	MOVF 0x37,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 510: 			clk = 0
	BCF 0x07,1
; 511: 'WaitUs speed_max
; 512: 			one_round = one_round + 1
	MOVF 0x3F,W
	ADDLW 0x01
	MOVWF 0x3F
	MOVF 0x40,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x40
; 513: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0165
L0166:
; 514: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 515: 		one_round = one_round - 500  'rail position 0 is a bit further from switch
	MOVLW 0xF4
	SUBWF 0x3F,W
	MOVWF 0x3F
	MOVLW 0x01
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x40,W
	MOVWF 0x40
; 516: 		act_steps = 0
	CLRF 0x43
	CLRF 0x44
; 517: 		new_steps = 250 + free_space_steps
	MOVLW 0xFA
	ADDWF 0x3D,W
	MOVWF 0x3B
	MOVLW 0x00
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x3C
; 518: 		direction = 1  'first forward
	BSF 0x07,0
; 519: 		ena = 1  'set anable on
	BSF 0x07,2
; 520: 		While act_steps < new_steps
L0167:
	MOVF 0x43,W
	MOVWF R0L
	MOVF 0x44,W
	MOVWF R0H
	MOVF 0x3B,W
	MOVWF R1L
	MOVF 0x3C,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0168
; 521: 			clk = 1  'clock out
	BSF 0x07,1
; 522: 			WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 523: 			clk = 0
	BCF 0x07,1
; 524: 'WaitUs speed_min
; 525: 			act_steps = act_steps + 1
	MOVF 0x43,W
	ADDLW 0x01
	MOVWF 0x43
	MOVF 0x44,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x44
; 526: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0167
L0168:
; 527: 		WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 528: 		steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x30
	CLRF 0x31
; 529: 		direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 530: 		While steps > 0  'NOW RUN UNTIL STEPS = 0
L0169:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0170
; 531: 			clk = 1  'clock out
	BSF 0x07,1
; 532: 			WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 533: 			clk = 0
	BCF 0x07,1
; 534: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 535: 'WaitUs speed_min
; 536: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0169
L0170:
; 537: 		new_pos = 0
	CLRF 0x45
; 538: 		act_pos = 0
	CLRF 0x34
; 539: 		one_round = one_round - 250  'substract also the space between last rail and end-switch
	MOVLW 0xFA
	SUBWF 0x3F,W
	MOVWF 0x3F
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x40,W
	MOVWF 0x40
; 540: 		'now calculate the steps  and save steps.
; 541: 		new_steps = 250
	MOVLW 0xFA
	MOVWF 0x3B
	CLRF 0x3C
; 542: 		Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 543: 		max_pos = max_pos + 1
	MOVF 0x39,W
	ADDLW 0x01
	MOVWF 0x39
; 544: 		steps = one_round / max_pos
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	MOVF 0x39,W
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x30
	MOVF R0H,W
	MOVWF 0x31
; 545: 		For act_pos = 1 To max_pos
	MOVLW 0x01
	MOVWF 0x34
L0171:
	MOVF 0x34,W
	SUBWF 0x39,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0172
; 546: 			new_steps = new_steps + steps
	MOVF 0x3B,W
	ADDWF 0x30,W
	MOVWF 0x3B
	MOVF 0x3C,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x31,W
	MOVWF 0x3C
; 547: 			Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 548: 		Next act_pos
	MOVLW 0x01
	ADDWF 0x34,F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0171
L0172:
; 549: 		max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x39,W
	MOVWF 0x39
; 550: 		act_pos = 0
	CLRF 0x34
; 551: 		adjust_en = 0
	CLRF 0x4D
; 552: 	Case 63  'go to zero switch and then to 1st rail position (Pos 0)
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0173
L0162:
	MOVF 0x45,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0174
; 553: 		direction = 0  'goto to zero switch
	BCF 0x07,0
; 554: 		ena = 1  'set anable on
	BSF 0x07,2
; 555: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 556: 		While zero = 1  'turn motor until end switch is activated
L0175:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0176
; 557: 			clk = 1  'clock out
	BSF 0x07,1
; 558: 			WaitUs speed_max
	MOVF 0x36,W
	MOVWF R4L
	MOVF 0x37,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 559: 			clk = 0
	BCF 0x07,1
; 560: 'WaitUs speed_max
; 561: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0175
L0176:
; 562: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 563: 		new_pos = 0
	CLRF 0x45
; 564: 		Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 565: 		direction = 1  'now forwards
	BSF 0x07,0
; 566: 		steps = steps + new_steps + free_space_steps
;       The address of 'oshonsoft_temp_1' (word) (global) is 0x5A
	oshonsoft_temp_1 EQU 0x5A
	MOVF 0x30,W
	ADDWF 0x3B,W
	MOVWF 0x5A
	MOVF 0x31,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x3C,W
	MOVWF 0x5B
	MOVF 0x5A,W
	ADDWF 0x3D,W
	MOVWF 0x5A
	MOVF 0x5B,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x5B
	MOVF 0x5A,W
	MOVWF 0x30
	MOVF 0x5B,W
	MOVWF 0x31
; 567: 		ramp_up = 1
	BSF 0x4F,3
; 568: 		ramp_down_point = 0
	CLRF 0x51
	CLRF 0x52
; 569: 		half_steps = steps / 2
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x56
	MOVF R0H,W
	MOVWF 0x57
; 570: 		speed = speed_min
	MOVF 0x32,W
	MOVWF 0x47
	MOVF 0x33,W
	MOVWF 0x48
; 571: 		ena = 1  'set Enable on
	BSF 0x07,2
; 572: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 573: 		While steps > 0  'NOW RUN UNTIL STEPS = 0
L0177:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0178
; 574: 			clk = 1  'clock out
	BSF 0x07,1
; 575: 			WaitUs speed
	MOVF 0x47,W
	MOVWF R4L
	MOVF 0x48,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 576: 			clk = 0
	BCF 0x07,1
; 577: 'WaitUs speed
; 578: 			Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 579: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 580: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0177
L0178:
; 581: 		WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 582: 		steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x30
	CLRF 0x31
; 583: 		direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 584: 		While steps > 0  'NOW RUN UNTIL STEPS = 0
L0179:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0180
; 585: 			clk = 1  'clock out
	BSF 0x07,1
; 586: 			WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 587: 			clk = 0
	BCF 0x07,1
; 588: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 589: 'WaitUs speed_min
; 590: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0179
L0180:
; 591: 		ena = 0  'enable off
	BCF 0x07,2
; 592: 	Case Else  'this is the normal position sequence
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0181
L0174:
; 593: 		steps = 0
	CLRF 0x30
	CLRF 0x31
; 594: 		If new_steps > act_steps Then
	MOVF 0x3B,W
	MOVWF R0L
	MOVF 0x3C,W
	MOVWF R0H
	MOVF 0x43,W
	MOVWF R1L
	MOVF 0x44,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0182
; 595: 			steps = new_steps - act_steps
	MOVF 0x43,W
	SUBWF 0x3B,W
	MOVWF 0x30
	MOVF 0x44,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3C,W
	MOVWF 0x31
; 596: 			direction = 1
	BSF 0x07,0
; 597: 		Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0183
L0182:
; 598: 			steps = act_steps - new_steps
	MOVF 0x3B,W
	SUBWF 0x43,W
	MOVWF 0x30
	MOVF 0x3C,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x44,W
	MOVWF 0x31
; 599: 			direction = 0
	BCF 0x07,0
; 600: 		Endif
L0183:
; 601: 		If steps > 0 Then  'motor must be activated
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0184
; 602: 			If direction = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0185
; 603: 				steps = steps + free_space_steps
	MOVF 0x30,W
	ADDWF 0x3D,W
	MOVWF 0x30
	MOVF 0x31,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x31
; 604: 			Endif
L0185:
; 605: 			ramp_up = 1
	BSF 0x4F,3
; 606: 			ramp_down_point = 0
	CLRF 0x51
	CLRF 0x52
; 607: 			half_steps = steps / 2
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x56
	MOVF R0H,W
	MOVWF 0x57
; 608: 			speed = speed_min
	MOVF 0x32,W
	MOVWF 0x47
	MOVF 0x33,W
	MOVWF 0x48
; 609: 			ena = 1  'set anable on
	BSF 0x07,2
; 610: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 611: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0186:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0187
; 612: 				clk = 1  'clock out
	BSF 0x07,1
; 613: 				WaitUs speed
	MOVF 0x47,W
	MOVWF R4L
	MOVF 0x48,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 614: 				clk = 0
	BCF 0x07,1
; 615: 'WaitUs speed
; 616: 				Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 617: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 618: 				If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0188
; 619: 					If max_end = 0 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x06,7
	GOTO L0189
; 620: 						Gosub stop_the_motor
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 621: 					Endif
L0189:
; 622: 				Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0190
L0188:
; 623: 					If zero = 0 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x06,6
	GOTO L0191
; 624: 						Gosub stop_the_motor
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 625: 					Endif
L0191:
; 626: 				Endif
L0190:
; 627: 			Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0186
L0187:
; 628: 			If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0192
; 629: 				If free_space_steps > 0 Then
	MOVF 0x3D,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0193
; 630: 					WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 631: 					steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x30
	CLRF 0x31
; 632: 					direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 633: 					While steps > 0  'NOW RUN UNTIL STEPS = 0
L0194:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0195
; 634: 						clk = 1  'clock out
	BSF 0x07,1
; 635: 						WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 636: 						clk = 0
	BCF 0x07,1
; 637: 						steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 638: 						WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 639: 					Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0194
L0195:
; 640: 				Endif
L0193:
; 641: 			Endif
L0192:
; 642: 			ena = 0  'enable off
	BCF 0x07,2
; 643: 		Endif
L0184:
; 644: 	EndSelect
L0181:
L0173:
; 645: 	act_pos = new_pos
	MOVF 0x45,W
	MOVWF 0x34
; 646: 	Write mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0196:	BTFSC EECON1,WR
	GOTO L0196
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 647: 	bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x4E
; 648: 	old_bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x55
; 649: 	manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x38
; 650: 	old_manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x54
; 651: 
; 652: Return
	RETURN
; 653: 
; 654: 
; 655: 
; 656: 
; 657: speed_calc:
L0008:
; 658: 	If steps < half_steps Then  'at this point  ramp up MUST end
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVF 0x56,W
	MOVWF R1L
	MOVF 0x57,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0197
; 659: 		ramp_up = 0
	BCF 0x4F,3
; 660: 	Endif
L0197:
; 661: 	If ramp_up = 1 Then  'we were supposed to ramp up
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x4F,3
	GOTO L0198
; 662: 		If speed > speed_max Then
	MOVF 0x47,W
	MOVWF R0L
	MOVF 0x48,W
	MOVWF R0H
	MOVF 0x36,W
	MOVWF R1L
	MOVF 0x37,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0199
; 663: 			speed = speed - speed_step
	MOVF 0x42,W
	SUBWF 0x47,W
	MOVWF 0x47
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x48,W
	MOVWF 0x48
; 664: 			ramp_down_point = ramp_down_point + 1  'this counts down with the steps
	MOVF 0x51,W
	ADDLW 0x01
	MOVWF 0x51
	MOVF 0x52,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x52
; 665: 		Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0200
L0199:
; 666: 			ramp_up = 0
	BCF 0x4F,3
; 667: 		Endif
L0200:
; 668: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0201
L0198:
; 669: 		If steps < ramp_down_point Then  'this is the point tot start ramp down
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVF 0x51,W
	MOVWF R1L
	MOVF 0x52,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0202
; 670: 			If speed < speed_min Then
	MOVF 0x47,W
	MOVWF R0L
	MOVF 0x48,W
	MOVWF R0H
	MOVF 0x32,W
	MOVWF R1L
	MOVF 0x33,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0203
; 671: 				speed = speed + speed_step
	MOVF 0x47,W
	ADDWF 0x42,W
	MOVWF 0x47
	MOVF 0x48,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x48
; 672: 			Endif
L0203:
; 673: 		Endif
L0202:
; 674: 	Endif
L0201:
; 675: Return
	RETURN
; 676: 
; 677: 
; 678: relays:
L0009:
; 679: 	If bridge_power = 0 Then
	MOVF 0x4C,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0204
; 680: 		If onoff = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x4F,0
	GOTO L0205
; 681: 			swfw = 1
	BSF 0x06,0
; 682: 		Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0206
L0205:
; 683: 			swfw = 0
	BCF 0x06,0
; 684: 		Endif
L0206:
; 685: 	Else  'bridge remains under power
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0207
L0204:
; 686: 		swfw = 1
	BSF 0x06,0
; 687: 	Endif
L0207:
; 688: Return
	RETURN
; 689: 
; 690: 
; 691: init_values:
L0010:
; 692: 	value = 84  'version number
	MOVLW 0x54
	MOVWF 0x35
; 693: 	version = 0  'decimal point in display on
	BCF 0x4F,1
; 694: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 695: 	WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 696: 	version = 1  'decimal point in display off
	BSF 0x4F,1
; 697: 	encoder_count = 0
	CLRF 0x4B
; 698: 	speed_min = 0
	CLRF 0x32
	CLRF 0x33
; 699: 	Read mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 700: 	If speed_min.HB > 99 Then
	MOVF 0x33,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0208
; 701: 		speed_min.HB = 40
	MOVLW 0x28
	MOVWF 0x33
; 702: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0209
L0208:
; 703: 		If speed_min.HB < 2 Then
	MOVLW 0x02
	SUBWF 0x33,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0210
; 704: 			speed_min.HB = 20
	MOVLW 0x14
	MOVWF 0x33
; 705: 		Endif
L0210:
; 706: 	Endif
L0209:
; 707: 	speed_max = 0
	CLRF 0x36
	CLRF 0x37
; 708: 	Read mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 709: 	If speed_max.HB > speed_min.HB Then
	MOVF 0x37,W
	SUBWF 0x33,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0211
; 710: 		speed_max.HB = speed_min.HB
	MOVF 0x33,W
	MOVWF 0x37
; 711: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0212
L0211:
; 712: 		If speed_max.HB < 2 Then
	MOVLW 0x02
	SUBWF 0x37,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0213
; 713: 			speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x37
; 714: 		Endif
L0213:
; 715: 	Endif
L0212:
; 716: 
; 717: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 718: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 719: 	If one_round = 0 Then
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0214
; 720: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x3F
	MOVLW 0x1F
	MOVWF 0x40
; 721: 	Endif
L0214:
; 722: 	If one_round > 60000 Then
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0215
; 723: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x3F
	MOVLW 0x1F
	MOVWF 0x40
; 724: 	Endif
L0215:
; 725: 	one_round_half = one_round / 2
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x58
	MOVF R0H,W
	MOVWF 0x59
; 726: 
; 727: 	Read mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 728: 	If max_pos > 47 Then
	MOVF 0x39,W
	SUBLW 0x2F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0216
; 729: 		max_pos = 11
	MOVLW 0x0B
	MOVWF 0x39
; 730: 	Endif
L0216:
; 731: 	Read mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 732: 	If act_pos > max_pos Then
	MOVF 0x34,W
	SUBWF 0x39,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0217
; 733: 		act_pos = 0
	CLRF 0x34
; 734: 		Write mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0218:	BTFSC EECON1,WR
	GOTO L0218
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 735: 	Endif
L0217:
; 736: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 737: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 738: 	Read mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3D
; 739: 	If free_space_steps > 99 Then
	MOVF 0x3D,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0219
; 740: 		free_space_steps = 50
	MOVLW 0x32
	MOVWF 0x3D
; 741: 	Endif
L0219:
; 742: 	Read mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3E
; 743: 	If pos_match_delay > 50 Then
	MOVF 0x3E,W
	SUBLW 0x32
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0220
; 744: 		pos_match_delay = 10
	MOVLW 0x0A
	MOVWF 0x3E
; 745: 	Endif
L0220:
; 746: 	
; 747: 	Read mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x42
; 748: 	If speed_step > 99 Then
	MOVF 0x42,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0221
; 749: 		speed_step = 20
	MOVLW 0x14
	MOVWF 0x42
; 750: 	Endif
L0221:
; 751: 	steps_set = 0
	BCF 0x4F,2
; 752: 	new_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x45
; 753: 	bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x4E
; 754: 	old_bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x55
; 755: 	manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x38
; 756: 	old_manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x54
; 757: 	old_pos_write = 1
	BSF 0x4F,4
; 758: Return
	RETURN
; 759: 
; 760: steps_reading:
L0011:
; 761: 	Select Case act_pos
; 762: 	Case 63, 62
	MOVF 0x34,W
	SUBLW 0x3F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0224
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0223
L0224:
	MOVF 0x34,W
	SUBLW 0x3E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0222
L0223:
; 763: 		act_steps = 0
	CLRF 0x43
	CLRF 0x44
; 764: 	Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0225
L0222:
; 765: 		eprom_pointer = act_pos
	MOVF 0x34,W
	MOVWF 0x46
; 766: 		eprom_pointer = eprom_pointer + 48
	MOVF 0x46,W
	ADDLW 0x30
	MOVWF 0x46
; 767: 		Read act_pos, act_steps.LB
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x43
; 768: 		Read eprom_pointer, act_steps.HB
	MOVF 0x46,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x44
; 769: 	EndSelect
L0225:
; 770: 	Select Case new_pos
; 771: 	Case 62, 63
	MOVF 0x45,W
	SUBLW 0x3E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0228
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0227
L0228:
	MOVF 0x45,W
	SUBLW 0x3F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0226
L0227:
; 772: 		new_steps = 0
	CLRF 0x3B
	CLRF 0x3C
; 773: 	Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0229
L0226:
; 774: 		eprom_pointer = new_pos
	MOVF 0x45,W
	MOVWF 0x46
; 775: 		eprom_pointer = eprom_pointer + 48
	MOVF 0x46,W
	ADDLW 0x30
	MOVWF 0x46
; 776: 		Read new_pos, new_steps.LB
	MOVF 0x45,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3B
; 777: 		Read eprom_pointer, new_steps.HB
	MOVF 0x46,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3C
; 778: 	Endif
L0229:
; 779: Return
	RETURN
; 780: 
; 781: 
; 782: save_steps:
L0012:
; 783: 	eprom_pointer = act_pos
	MOVF 0x34,W
	MOVWF 0x46
; 784: 	eprom_pointer = eprom_pointer + 48
	MOVF 0x46,W
	ADDLW 0x30
	MOVWF 0x46
; 785: 	Write act_pos, new_steps.LB
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0230:	BTFSC EECON1,WR
	GOTO L0230
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 786: 	Write eprom_pointer, new_steps.HB
	MOVF 0x46,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0231:	BTFSC EECON1,WR
	GOTO L0231
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 787: Return
	RETURN
; 788: 
; 789: 
; 790: stop_the_motor:
L0013:
; 791: 	ena = 0  'set anable oFF
	BCF 0x07,2
; 792: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 793: 	version = 0  'decimal point in display on
	BCF 0x4F,1
; 794: 	While ecsw = 1
L0232:
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,6
	GOTO L0233
; 795: 		WaitMs 250
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 796: 		Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 797: 		version = Not version
	MOVLW 0x02
	XORWF 0x4F,F
; 798: 	Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0232
L0233:
; 799: 	version = 1  'decimal point off
	BSF 0x4F,1
; 800: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 801: 	ena = 1  'set anable on
	BSF 0x07,2
; 802: Return
	RETURN
; 803: wait_pos_match:
L0014:
; 804: 	value = 99
	MOVLW 0x63
	MOVWF 0x35
; 805: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 806: 	steps = pos_match_delay * 100
	MOVF 0x3E,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x30
	MOVF R2H,W
	MOVWF 0x31
; 807: 	WaitMs steps
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 808: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x35
; 809: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 810: 	pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 811: Return
	RETURN
; End of program
;       PAGE SELECT
	BSF PCLATH,3
L0234:	GOTO L0234
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
