; Compiled with: PIC Simulator IDE v6.91
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_act_pos' (global) is 127
;       The value of 'mem_speed_min' (global) is 103
;       The value of 'mem_speed_max' (global) is 104
;       The value of 'mem_speed_step' (global) is 105
;       The value of 'mem_one_round_lb' (global) is 106
;       The value of 'mem_one_round_hb' (global) is 107
;       The value of 'mem_ctrl_type' (global) is 108
;       The value of 'mem_max_pos' (global) is 109
;       The value of 'mem_free_space' (global) is 110
;       The value of 'mem_rev_pos' (global) is 111
;       The value of 'mem_bridge_power' (global) is 112
;       The value of 'mem_pos_match_delay' (global) is 113
;       The address of 'steps' (word) (global) is 0x30
	steps EQU 0x30
;       The address of 'act_pos' (byte) (global) is 0x32
	act_pos EQU 0x32
;       The address of 'speed_min' (word) (global) is 0x33
	speed_min EQU 0x33
;       The address of 'manual_pos' (byte) (global) is 0x35
	manual_pos EQU 0x35
;       The address of 'value' (byte) (global) is 0x36
	value EQU 0x36
;       The address of 'speed_max' (word) (global) is 0x37
	speed_max EQU 0x37
;       The address of 'max_pos' (byte) (global) is 0x39
	max_pos EQU 0x39
;       The address of 'new_steps' (word) (global) is 0x3A
	new_steps EQU 0x3A
;       The address of 'result' (byte) (global) is 0x3C
	result EQU 0x3C
;       The address of 'free_space_steps' (byte) (global) is 0x3D
	free_space_steps EQU 0x3D
;       The address of 'one_round' (word) (global) is 0x3E
	one_round EQU 0x3E
;       The address of 'pos_match_delay' (byte) (global) is 0x40
	pos_match_delay EQU 0x40
;       The address of 'new_pos' (byte) (global) is 0x41
	new_pos EQU 0x41
;       The address of 'program_set' (byte) (global) is 0x42
	program_set EQU 0x42
;       The address of 'speed_step' (byte) (global) is 0x43
	speed_step EQU 0x43
;       The address of 'act_steps' (word) (global) is 0x44
	act_steps EQU 0x44
;       The address of 'speed' (word) (global) is 0x46
	speed EQU 0x46
;       The address of 'eprom_pointer' (byte) (global) is 0x48
	eprom_pointer EQU 0x48
;       The address of 'disp1_val' (byte) (global) is 0x49
	disp1_val EQU 0x49
;       The address of 'adjust_en' (byte) (global) is 0x4A
	adjust_en EQU 0x4A
;       The address of 'new_encoder' (byte) (global) is 0x4B
	new_encoder EQU 0x4B
;       The address of 'encoder_count' (byte) (global) is 0x4C
	encoder_count EQU 0x4C
;       The address of 'bridge_power' (byte) (global) is 0x4D
	bridge_power EQU 0x4D
;       The address of 'bus_pos' (byte) (global) is 0x4E
	bus_pos EQU 0x4E
;       The address of 'onoff' (bit) (global) is 0x4F,0
;       The address of 'disp2_val' (byte) (global) is 0x50
	disp2_val EQU 0x50
;       The address of 'version' (bit) (global) is 0x4F,1
;       The address of 'ramp_up' (bit) (global) is 0x4F,2
;       The address of 'steps_set' (bit) (global) is 0x4F,3
;       The address of 'ramp_down_point' (word) (global) is 0x51
	ramp_down_point EQU 0x51
;       The address of 'old_encoder' (byte) (global) is 0x53
	old_encoder EQU 0x53
;       The address of 'old_manual_pos' (byte) (global) is 0x54
	old_manual_pos EQU 0x54
;       The address of 'old_pos_write' (bit) (global) is 0x4F,4
;       The address of 'half_steps' (word) (global) is 0x55
	half_steps EQU 0x55
;       The address of 'old_bus_pos' (byte) (global) is 0x57
	old_bus_pos EQU 0x57
;       The address of 'one_round_half' (word) (global) is 0x58
	one_round_half EQU 0x58
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x6,6
;       The address of 'max_end' (bit) (global) is 0x6,7
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0015
	ORG 0x0004
	RETFIE
; LookUp Table: (3, 2, 1, 3)
_lookup_lab_0001:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
; LookUp Table: (1, 3, 3, 2)
_lookup_lab_0002:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
; LookUp Table: (2, 3, 3, 1)
_lookup_lab_0003:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
; LookUp Table: (3, 1, 2, 3)
_lookup_lab_0004:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0005:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; LookUp Table: (%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111)
_lookup_lab_0006:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0007:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0015:
; 1: Define CONF_WORD = 0x3f72
; 2: 
; 3: 'program TT for PCBoard MGV145
; 4: 'special version 8-4  small fiddle yard RDS
; 5: 'version 8-5 with extra position 61 . This position will run to zero switch, and then, by hitting the
; 6: '-     incremental knob on every position, , the program will store that position, and increment the display
; 7: '-     to the next. After reaching the last position, the motor will run back to zero switch and then
; 8: '-     position 0.
; 9: 'RB7 on ICSP1 (pin3) is endswitch (pass last rail)
; 10: 'RB6 on ICSP1 (pin2) is endswitch (pass first rail)
; 11: 'EEP jumper must always be at ON !
; 12: 'two extra position are possible:
; 13: '-  position 63 to go to zero switch and then to rail 0
; 14: '-  position 62 to reset and recalculate all values (only when menu 8 is set)
; 15: 'programs :
; 16: '0  correction actual position
; 17: '1  Max positions
; 18: '2  min speed
; 19: '3  max speed
; 20: '4  incr/decr delay
; 21: '5  extra correction steps
; 22: '6  bridge power on/off (1/0)
; 23: '7  pos_match delay
; 24: '8  adjust_position >>>: this enables / disables the choice of pos 62
; 25: Dim steps As Word
; 26: Dim half_steps As Word
; 27: Dim ramp_down_point As Word
; 28: Dim program_set As Byte
; 29: Dim new_steps As Word
; 30: Dim act_steps As Word
; 31: Dim new_pos As Byte
; 32: Dim act_pos As Byte
; 33: Dim one_round As Word
; 34: Dim one_round_half As Word
; 35: Dim bus_pos As Byte
; 36: Dim old_bus_pos As Byte
; 37: Dim speed As Word
; 38: Dim speed_min As Word
; 39: Dim speed_max As Word
; 40: Dim new_encoder As Byte
; 41: Dim old_encoder As Byte
; 42: Dim manual_pos As Byte
; 43: Dim old_manual_pos As Byte
; 44: Dim result As Byte
; 45: Dim free_space_steps As Byte
; 46: Dim value As Byte
; 47: Dim eprom_pointer As Byte
; 48: Dim encoder_count As Byte
; 49: Dim onoff As Bit
; 50: Dim max_pos As Byte
; 51: Dim disp1_val As Byte
; 52: Dim disp2_val As Byte
; 53: Dim old_pos_write As Bit
; 54: Dim ramp_up As Bit
; 55: Dim speed_step As Byte
; 56: Dim version As Bit
; 57: Dim steps_set As Bit
; 58: Dim bridge_power As Byte
; 59: Dim pos_match_delay As Byte
; 60: Dim adjust_en As Byte
; 61: 
; 62: Const disp1 = 64
; 63: Const disp2 = 66
; 64: Const mem_act_pos = 127
; 65: Const mem_speed_min = 103
; 66: Const mem_speed_max = 104
; 67: Const mem_speed_step = 105
; 68: Const mem_one_round_lb = 106
; 69: Const mem_one_round_hb = 107
; 70: Const mem_ctrl_type = 108
; 71: Const mem_max_pos = 109
; 72: Const mem_free_space = 110
; 73: Const mem_rev_pos = 111
; 74: Const mem_bridge_power = 112
; 75: Const mem_pos_match_delay = 113
; 76: 
; 77: Symbol swfw = RB0
; 78: Symbol sck = RB2
; 79: Symbol sda = RB3
; 80: Symbol pos_match = RB4
; 81: Symbol pos_write = RB5
; 82: Symbol direction = RC0
; 83: Symbol clk = RC1
; 84: Symbol ena = RC2
; 85: Symbol zero = RB6
; 86: Symbol max_end = RB7
; 87: Symbol ec1 = RC4
; 88: Symbol ec2 = RC5
; 89: Symbol ecsw = RC6
; 90: Symbol pgm = RC7
; 91: 
; 92: ADCON1 = %0110
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 93: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 94: TRISB = %11101110
	MOVLW 0xEE
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 95: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 96: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 97: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 98: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 99: Gosub init_values
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0010
; 100: onoff = 1
	BSF 0x4F,0
; 101: Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 102: program_set = 0
	CLRF 0x42
; 103: max_end = 1
	BSF 0x06,7
; 104: adjust_en = 0
	CLRF 0x4A
; 105: main:
L0001:
; 106: 	If pgm = 0 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0016
; 107: 		Gosub adjust_settings
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0004
; 108: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 109: 	Endif
L0016:
; 110: 
; 111: 	Gosub get_new_position
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0002
; 112: 	If bus_pos <> old_bus_pos Then
	MOVF 0x4E,W
	SUBWF 0x57,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0017
; 113: 		onoff = 0
	BCF 0x4F,0
; 114: 		Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 115: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 116: 		new_pos = bus_pos
	MOVF 0x4E,W
	MOVWF 0x41
; 117: 		Gosub stepmotor
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0007
; 118: 		Gosub wait_pos_match
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 119: 		onoff = 1
	BSF 0x4F,0
; 120: 	Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0018
L0017:
; 121: 		If ecsw = 0 Then  'only when knob is pushed
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0019
; 122: 			If manual_pos <> old_manual_pos Then
	MOVF 0x35,W
	SUBWF 0x54,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0020
; 123: 				onoff = 0
	BCF 0x4F,0
; 124: 				Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 125: 				pos_match = 1  'indicate not in position
	BSF 0x06,4
; 126: 				old_manual_pos = manual_pos
	MOVF 0x35,W
	MOVWF 0x54
; 127: 				new_pos = manual_pos
	MOVF 0x35,W
	MOVWF 0x41
; 128: 				Gosub stepmotor
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0007
; 129: 				Gosub wait_pos_match
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 130: 				onoff = 1
	BSF 0x4F,0
; 131: 			Endif
L0020:
; 132: 		Endif
L0019:
; 133: 	Endif
L0018:
; 134: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 135: 	Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 136: 	Goto main
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0001
; 137: End
;       PAGE SELECT
	BCF PCLATH,3
L0021:	GOTO L0021
; 138: 
; 139: 
; 140: get_new_position:
L0002:
; 141: 	value = bus_pos  'remember the position
	MOVF 0x4E,W
	MOVWF 0x36
; 142: 	If pos_write = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,5
	GOTO L0022
; 143: 		If old_pos_write = 0 Then  'react once on rising edge
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x4F,4
	GOTO L0023
; 144: 			old_pos_write = 1
	BSF 0x4F,4
; 145: 			value = PORTA And 63  'now get value from J5
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x36
; 146: 			Select Case value
; 147: 			Case 63  'position reset is desired
	MOVF 0x36,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0024
; 148: 				value = 63
	MOVLW 0x3F
	MOVWF 0x36
; 149: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0025
L0024:
; 150: 				If value > max_pos Then  'this is not allowed
	MOVF 0x36,W
	SUBWF 0x39,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0026
; 151: 					value = bus_pos  'put it back to old situation
	MOVF 0x4E,W
	MOVWF 0x36
; 152: 				Endif
L0026:
; 153: 			EndSelect
L0025:
; 154: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 155: 			If value = bus_pos Then  'no other position is set, just a response on pos_write is required
	MOVF 0x36,W
	SUBWF 0x4E,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0027
; 156: 				pos_match = 1
	BSF 0x06,4
; 157: 				WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 158: 				pos_match = 0
	BCF 0x06,4
; 159: 			Endif
L0027:
; 160: 		Endif
L0023:
; 161: 	Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0028
L0022:
; 162: 		old_pos_write = 0
	BCF 0x4F,4
; 163: 	Endif
L0028:
; 164: 	bus_pos = value  'now take over the desired position
	MOVF 0x36,W
	MOVWF 0x4E
; 165: 	Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 166: 	Select Case result
; 167: 	Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0029
; 168: 		If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x4C,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0030
; 169: 			encoder_count = encoder_count + 1
	MOVF 0x4C,W
	ADDLW 0x01
	MOVWF 0x4C
; 170: 		Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0031
L0030:
; 171: 			encoder_count = 0
	CLRF 0x4C
; 172: 			Select Case manual_pos
; 173: 			Case < max_pos
	MOVF 0x39,W
	SUBWF 0x35,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0032
; 174: 				manual_pos = manual_pos + 1
	MOVF 0x35,W
	ADDLW 0x01
	MOVWF 0x35
; 175: 			Case max_pos
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0033
L0032:
	MOVF 0x35,W
	SUBWF 0x39,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0034
; 176: 				Select Case adjust_en
; 177: 				Case 0
	MOVF 0x4A,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0035
; 178: 					manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x35
; 179: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0036
L0035:
; 180: 					manual_pos = 61
	MOVLW 0x3D
	MOVWF 0x35
; 181: 				EndSelect
L0036:
; 182: 			Case 63
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0037
L0034:
	MOVF 0x35,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0038
; 183: 				manual_pos = 0
	CLRF 0x35
; 184: 			Case 62
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0039
L0038:
	MOVF 0x35,W
	SUBLW 0x3E
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0040
; 185: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x35
; 186: 			Case 61
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0041
L0040:
	MOVF 0x35,W
	SUBLW 0x3D
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0042
; 187: 				manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x35
; 188: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0043
L0042:
; 189: 			EndSelect
L0043:
L0041:
L0039:
L0037:
L0033:
; 190: 			value = manual_pos
	MOVF 0x35,W
	MOVWF 0x36
; 191: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 192: 		Endif
L0031:
; 193: 	Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0044
L0029:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0045
; 194: 		If encoder_count > 0 Then
	MOVF 0x4C,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0046
; 195: 			encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x4C,W
	MOVWF 0x4C
; 196: 		Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0047
L0046:
; 197: 			encoder_count = 4
	MOVLW 0x04
	MOVWF 0x4C
; 198: 			Select Case manual_pos
; 199: 			Case 61
	MOVF 0x35,W
	SUBLW 0x3D
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0048
; 200: 				manual_pos = max_pos
	MOVF 0x39,W
	MOVWF 0x35
; 201: 			Case 62
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0049
L0048:
	MOVF 0x35,W
	SUBLW 0x3E
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0050
; 202: 				manual_pos = 61
	MOVLW 0x3D
	MOVWF 0x35
; 203: 			Case 63
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0051
L0050:
	MOVF 0x35,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0052
; 204: 				Select Case adjust_en
; 205: 				Case 0
	MOVF 0x4A,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0053
; 206: 					manual_pos = max_pos
	MOVF 0x39,W
	MOVWF 0x35
; 207: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0054
L0053:
; 208: 					manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x35
; 209: 				EndSelect
L0054:
; 210: 			Case 0
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0055
L0052:
	MOVF 0x35,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0056
; 211: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x35
; 212: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0057
L0056:
; 213: 				manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x35,W
	MOVWF 0x35
; 214: 			EndSelect
L0057:
L0055:
L0051:
L0049:
; 215: 			value = manual_pos
	MOVF 0x35,W
	MOVWF 0x36
; 216: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 217: 		Endif
L0047:
; 218: 	Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0058
L0045:
; 219: 	EndSelect
L0058:
L0044:
; 220: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 221: 	
; 222: Return
	RETURN
; 223: 
; 224: calc_rotation:  'this routine checks the incrimental switch
L0003:
; 225: '1 = increasing value
; 226: '2 = decreasing value
; 227: '3 = no change
; 228: 		new_encoder = 0
	CLRF 0x4B
; 229: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x4B,0
	BTFSS 0x07,4
	BCF 0x4B,0
; 230: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x4B,1
	BTFSS 0x07,5
	BCF 0x4B,1
; 231: 		Select Case old_encoder
; 232: 		Case 0
	MOVF 0x53,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0059
; 233: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x4B,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0060
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0001
	MOVWF 0x3C
L0060:
; 234: 		Case 1
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0061
L0059:
	MOVF 0x53,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0062
; 235: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x4B,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0063
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0002
	MOVWF 0x3C
L0063:
; 236: 		Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0064
L0062:
	MOVF 0x53,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0065
; 237: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x4B,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0066
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0003
	MOVWF 0x3C
L0066:
; 238: 		Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0067
L0065:
; 239: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x4B,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0068
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0004
	MOVWF 0x3C
L0068:
; 240: 		EndSelect
L0067:
L0064:
L0061:
; 241: 		old_encoder = new_encoder
	MOVF 0x4B,W
	MOVWF 0x53
; 242: Return
	RETURN
; 243: 
; 244: 
; 245: adjust_settings:
L0004:
; 246: 	Gosub i2c_display_pgm
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0006
; 247: 	WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 248: 	onoff = 0
	BCF 0x4F,0
; 249: 	Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 250: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 251: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x44,W
	MOVWF 0x3A
	MOVF 0x45,W
	MOVWF 0x3B
; 252: 	While pgm = 0  'the program switch is still activated
L0069:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0070
; 253: 		If ecsw = 0 Then  'knob is pressed, inrease program_set
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0071
; 254: 			program_set = program_set + 1
	MOVF 0x42,W
	ADDLW 0x01
	MOVWF 0x42
; 255: 			If program_set > 8 Then  'no more than 8 items te change
	MOVF 0x42,W
	SUBLW 0x08
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0072
; 256: 				program_set = 0
	CLRF 0x42
; 257: 			Endif
L0072:
; 258: 			Gosub i2c_display_pgm
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0006
; 259: 			WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 260: 			While ecsw = 0  'be sure pushbutton is released
L0073:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0074
; 261: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 262: 			Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0073
L0074:
; 263: 		Endif
L0071:
; 264: 		Select Case program_set
; 265: 		Case 0  'correction of current position
	MOVF 0x42,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0075
; 266: 			value = act_pos
	MOVF 0x32,W
	MOVWF 0x36
; 267: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 268: 			Gosub calc_rotation  'look for the knob to be turned
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 269: 			Select Case result
; 270: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0076
; 271: 				If new_steps < 60000 Then
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0077
; 272: 					ena = 1  'motor on
	BSF 0x07,2
; 273: 					new_steps = new_steps + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
	MOVF 0x3B,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3B
; 274: 					direction = 1
	BSF 0x07,0
; 275: 					clk = 1  'clock out
	BSF 0x07,1
; 276: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 277: 					clk = 0
	BCF 0x07,1
; 278: 				Endif
L0077:
; 279: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0078
L0076:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0079
; 280: 				If new_steps > 0 Then
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0080
; 281: 					ena = 1  'motor on
	BSF 0x07,2
; 282: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x3A,W
	MOVWF 0x3A
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x3B
; 283: 					direction = 0
	BCF 0x07,0
; 284: 					clk = 1  'clock out
	BSF 0x07,1
; 285: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 286: 					clk = 0
	BCF 0x07,1
; 287: 				Endif
L0080:
; 288: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0081
L0079:
; 289: 			EndSelect
L0081:
L0078:
; 290: 		Case 1  'setting of maximum positions
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0082
L0075:
	MOVF 0x42,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0083
; 291: 			steps_set = 0
	BCF 0x4F,3
; 292: 			ena = 0  'shut off motor
	BCF 0x07,2
; 293: 			value = max_pos
	MOVF 0x39,W
	MOVWF 0x36
; 294: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 295: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 296: 			Select Case result
; 297: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0084
; 298: 				If max_pos < 12 Then  'no more positions possible
	MOVLW 0x0C
	SUBWF 0x39,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0085
; 299: 					max_pos = max_pos + 1
	MOVF 0x39,W
	ADDLW 0x01
	MOVWF 0x39
; 300: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0086:	BTFSC EECON1,WR
	GOTO L0086
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 301: 				Endif
L0085:
; 302: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0087
L0084:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0088
; 303: 				If max_pos > 2 Then  'minum 2 positions
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0089
; 304: 					max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x39,W
	MOVWF 0x39
; 305: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0090:	BTFSC EECON1,WR
	GOTO L0090
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 306: 				Endif
L0089:
; 307: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0091
L0088:
; 308: 			EndSelect
L0091:
L0087:
; 309: 		Case 2  'setting of speed interval Minimum
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0092
L0083:
	MOVF 0x42,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0093
; 310: 					'setting will be done in multiple of 256 uSecs
; 311: 					'minimum is 2 and maximum is 99 (is real slow)
; 312: 			steps_set = 0
	BCF 0x4F,3
; 313: 			ena = 0  'shut off motor
	BCF 0x07,2
; 314: 			value = speed_min.HB
	MOVF 0x34,W
	MOVWF 0x36
; 315: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 316: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 317: 			Select Case result
; 318: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0094
; 319: 				If speed_min.HB < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x34,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0095
; 320: 					speed_min.HB = speed_min.HB + 1
	MOVF 0x34,W
	ADDLW 0x01
	MOVWF 0x34
; 321: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0096:	BTFSC EECON1,WR
	GOTO L0096
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 322: 				Endif
L0095:
; 323: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0097
L0094:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0098
; 324: 				If speed_min.HB > speed_max.HB Then
	MOVF 0x34,W
	SUBWF 0x38,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0099
; 325: 					speed_min.HB = speed_min.HB - 1
	MOVLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 326: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0100:	BTFSC EECON1,WR
	GOTO L0100
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 327: 				Endif
L0099:
; 328: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0101
L0098:
; 329: 			EndSelect
L0101:
L0097:
; 330: 		Case 3  'setting of speed interval Maximum
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0102
L0093:
	MOVF 0x42,W
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0103
; 331: 					'setting will be done in multiple of 256 uSecs
; 332: 					'minimum is 1 and maximum is 99 (is real slow)
; 333: 			steps_set = 0
	BCF 0x4F,3
; 334: 			ena = 0  'shut off motor
	BCF 0x07,2
; 335: 			value = speed_max.HB
	MOVF 0x38,W
	MOVWF 0x36
; 336: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 337: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 338: 			Select Case result
; 339: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0104
; 340: 				If speed_max.HB < speed_min.HB Then  'not more then speed_min
	MOVF 0x34,W
	SUBWF 0x38,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0105
; 341: 					speed_max.HB = speed_max.HB + 1
	MOVF 0x38,W
	ADDLW 0x01
	MOVWF 0x38
; 342: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0106:	BTFSC EECON1,WR
	GOTO L0106
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 343: 				Endif
L0105:
; 344: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0107
L0104:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0108
; 345: 				If speed_max.HB > 2 Then
	MOVF 0x38,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0109
; 346: 					speed_max.HB = speed_max.HB - 1
	MOVLW 0x01
	SUBWF 0x38,W
	MOVWF 0x38
; 347: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0110:	BTFSC EECON1,WR
	GOTO L0110
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 348: 				Endif
L0109:
; 349: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0111
L0108:
; 350: 			EndSelect
L0111:
L0107:
; 351: 		Case 4  'setting of ramp up and down speed
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0112
L0103:
	MOVF 0x42,W
	SUBLW 0x04
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0113
; 352: 					'speed will be the value that speed will be changed every step up and down
; 353: 			steps_set = 0
	BCF 0x4F,3
; 354: 			ena = 0  'shut off motor
	BCF 0x07,2
; 355: 			value = speed_step
	MOVF 0x43,W
	MOVWF 0x36
; 356: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 357: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 358: 			Select Case result
; 359: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0114
; 360: 				If speed_step < 99 Then  'maximum 99 is possible
	MOVLW 0x63
	SUBWF 0x43,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0115
; 361: 					speed_step = speed_step + 1
	MOVF 0x43,W
	ADDLW 0x01
	MOVWF 0x43
; 362: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0116:	BTFSC EECON1,WR
	GOTO L0116
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 363: 				Endif
L0115:
; 364: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0117
L0114:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0118
; 365: 				If speed_step > 1 Then
	MOVF 0x43,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0119
; 366: 					speed_step = speed_step - 1
	MOVLW 0x01
	SUBWF 0x43,W
	MOVWF 0x43
; 367: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0120:	BTFSC EECON1,WR
	GOTO L0120
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 368: 				Endif
L0119:
; 369: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0121
L0118:
; 370: 			EndSelect
L0121:
L0117:
; 371: 	
; 372: 		Case 5  'setting of extra free space steps
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0122
L0113:
	MOVF 0x42,W
	SUBLW 0x05
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0123
; 373: 			steps_set = 0
	BCF 0x4F,3
; 374: 			ena = 0  'shut off motor
	BCF 0x07,2
; 375: 			If free_space_steps > 250 Then
	MOVF 0x3D,W
	SUBLW 0xFA
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0124
; 376: 				free_space_steps = 250
	MOVLW 0xFA
	MOVWF 0x3D
; 377: 				Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0125:	BTFSC EECON1,WR
	GOTO L0125
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 378: 			Endif
L0124:
; 379: 			value = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x36
; 380: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 381: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 382: 			Select Case result
; 383: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0126
; 384: 				If free_space_steps < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x3D,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0127
; 385: 					free_space_steps = free_space_steps + 1
	MOVF 0x3D,W
	ADDLW 0x01
	MOVWF 0x3D
; 386: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0128:	BTFSC EECON1,WR
	GOTO L0128
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 387: 				Endif
L0127:
; 388: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0129
L0126:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0130
; 389: 				If free_space_steps > 0 Then
	MOVF 0x3D,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0131
; 390: 					free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
; 391: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0132:	BTFSC EECON1,WR
	GOTO L0132
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 392: 				Endif
L0131:
; 393: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0133
L0130:
; 394: 			EndSelect
L0133:
L0129:
; 395: 		Case 6  'setting if power should be on or off while bridge is moving (0 = off)
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0134
L0123:
	MOVF 0x42,W
	SUBLW 0x06
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0135
; 396: 			Read mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x4D
; 397: 			If bridge_power > 1 Then
	MOVF 0x4D,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0136
; 398: 				bridge_power = 1
	MOVLW 0x01
	MOVWF 0x4D
; 399: 			Endif
L0136:
; 400: 			value = bridge_power
	MOVF 0x4D,W
	MOVWF 0x36
; 401: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 402: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 403: 			Select Case result
; 404: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0137
; 405: 				bridge_power = 1
	MOVLW 0x01
	MOVWF 0x4D
; 406: 				Write mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x4D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0138:	BTFSC EECON1,WR
	GOTO L0138
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 407: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0139
L0137:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0140
; 408: 				bridge_power = 0
	CLRF 0x4D
; 409: 				Write mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x4D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0141:	BTFSC EECON1,WR
	GOTO L0141
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 410: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0142
L0140:
; 411: 			EndSelect
L0142:
L0139:
; 412: 		Case 7  'setting delay in millisecs before tt is ready is sent)
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0143
L0135:
	MOVF 0x42,W
	SUBLW 0x07
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0144
; 413: 			Read mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 414: 			If pos_match_delay > 50 Then
	MOVF 0x40,W
	SUBLW 0x32
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0145
; 415: 				pos_match_delay = 50
	MOVLW 0x32
	MOVWF 0x40
; 416: 			Endif
L0145:
; 417: 			value = pos_match_delay
	MOVF 0x40,W
	MOVWF 0x36
; 418: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 419: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 420: 			Select Case result
; 421: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0146
; 422: 				If pos_match_delay < 50 Then
	MOVLW 0x32
	SUBWF 0x40,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0147
; 423: 					pos_match_delay = pos_match_delay + 1
	MOVF 0x40,W
	ADDLW 0x01
	MOVWF 0x40
; 424: 				Endif
L0147:
; 425: 				Write mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0148:	BTFSC EECON1,WR
	GOTO L0148
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 426: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0149
L0146:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0150
; 427: 				If pos_match_delay > 0 Then
	MOVF 0x40,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0151
; 428: 					pos_match_delay = pos_match_delay - 1
	MOVLW 0x01
	SUBWF 0x40,W
	MOVWF 0x40
; 429: 				Endif
L0151:
; 430: 				Write mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0152:	BTFSC EECON1,WR
	GOTO L0152
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 431: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0153
L0150:
; 432: 			EndSelect
L0153:
L0149:
; 433: 		Case Else  'menu 8 , setting if postion 62 is possible to reset and calculate all positions
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0154
L0144:
; 434: 			If adjust_en > 1 Then
	MOVF 0x4A,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0155
; 435: 				adjust_en = 1
	MOVLW 0x01
	MOVWF 0x4A
; 436: 			Endif
L0155:
; 437: 			value = adjust_en
	MOVF 0x4A,W
	MOVWF 0x36
; 438: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 439: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 440: 			Select Case result
; 441: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0156
; 442: 				adjust_en = 1
	MOVLW 0x01
	MOVWF 0x4A
; 443: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0157
L0156:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0158
; 444: 				adjust_en = 0
	CLRF 0x4A
; 445: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0159
L0158:
; 446: 			EndSelect
L0159:
L0157:
; 447: 		EndSelect
L0154:
L0143:
L0134:
L0122:
L0112:
L0102:
L0092:
L0082:
; 448: 	Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0069
L0070:
; 449: 	ena = 0  'shut off motor
	BCF 0x07,2
; 450: 		'***************   now check if changes have to BE written in eeprom
; 451: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVF 0x44,W
	MOVWF R1L
	MOVF 0x45,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C002
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0160
; 452: 		Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 453: 	Endif
L0160:
; 454: 	value = act_pos
	MOVF 0x32,W
	MOVWF 0x36
; 455: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 456: 	onoff = 1
	BSF 0x4F,0
; 457: 	Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 458: Return
	RETURN
; 459: 
; 460: i2c_display:
L0005:
; 461: 	Select Case value
; 462: 	Case 99
	MOVF 0x36,W
	SUBLW 0x63
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0161
; 463: 		disp1_val = %10111111
	MOVLW 0xBF
	MOVWF 0x49
; 464: 		disp2_val = %10111111
	MOVLW 0xBF
	MOVWF 0x50
; 465: 	Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0162
L0161:
; 466: 		disp1_val = value
	MOVF 0x36,W
	MOVWF 0x49
; 467: 		disp1_val = disp1_val Mod 10
	MOVF 0x49,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x49
; 468: 		disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x49,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0163
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0005
	MOVWF 0x49
L0163:
; 469: 		disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x49,7
	BTFSS 0x07,7
	BCF 0x49,7
; 470: 		disp2_val = value
	MOVF 0x36,W
	MOVWF 0x50
; 471: 		disp2_val = disp2_val / 10
	MOVF 0x50,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x50
; 472: 		disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x50,W
	MOVWF R0L
	SUBLW 0x0A
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0164
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0006
	MOVWF 0x50
L0164:
; 473: 		disp2_val.7 = version
	BTFSC 0x4F,1
	BSF 0x50,7
	BTFSS 0x4F,1
	BCF 0x50,7
; 474: 	EndSelect
L0162:
; 475: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 476: 	I2CSend disp1
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 477: 	I2CSend disp1_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x49,W
	CALL IC01
; 478: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 479: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 480: 	I2CSend disp2
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 481: 	I2CSend disp2_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x50,W
	CALL IC01
; 482: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 483: Return
	RETURN
; 484: 
; 485: i2c_display_pgm:
L0006:
; 486: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), program_set
	MOVF 0x42,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0165
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0007
	MOVWF 0x49
L0165:
; 487: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 488: 	I2CSend disp1
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 489: 	I2CSend disp1_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x49,W
	CALL IC01
; 490: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 491: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 492: 	I2CSend disp2
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 493: 	I2CSend %10111111
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 494: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 495: Return
	RETURN
; 496: 
; 497: stepmotor:
L0007:
; 498: 	speed = 0
	CLRF 0x46
	CLRF 0x47
; 499: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 500: 	Select Case new_pos
; 501: 	Case 61  'this is the manual setting for each position
	MOVF 0x41,W
	SUBLW 0x3D
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0166
; 502: 		direction = 0  'first backwards
	BCF 0x07,0
; 503: 		ena = 1  'set anable on
	BSF 0x07,2
; 504: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 505: 		While zero = 1  'turn motor until zero switch is activated
L0167:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0168
; 506: 			clk = 1  'clock out
	BSF 0x07,1
; 507: 			WaitUs speed_max
	MOVF 0x37,W
	MOVWF R4L
	MOVF 0x38,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 508: 			clk = 0
	BCF 0x07,1
; 509: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0167
L0168:
; 510: 		ena = 0  'set anable off
	BCF 0x07,2
; 511: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 512: 		one_round = 0  'start counting one round steps
	CLRF 0x3E
	CLRF 0x3F
; 513: 		direction = 1  'run forward
	BSF 0x07,0
; 514: 		ena = 1  'set anable on
	BSF 0x07,2
; 515: 		act_pos = 0
	CLRF 0x32
; 516: 		value = act_pos
	MOVF 0x32,W
	MOVWF 0x36
; 517: 		Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 518: 		While max_end = 1  'turn motor until zero switch is activated
L0169:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,7
	GOTO L0170
; 519: 			clk = 1  'clock out
	BSF 0x07,1
; 520: 			WaitUs speed_max
	MOVF 0x37,W
	MOVWF R4L
	MOVF 0x38,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 521: 			clk = 0
	BCF 0x07,1
; 522: 			one_round = one_round + 1
	MOVF 0x3E,W
	ADDLW 0x01
	MOVWF 0x3E
	MOVF 0x3F,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3F
; 523: 			If ecsw = 0 Then  'knob is pressed, save position and increase act_pos
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0171
; 524: 				new_steps = one_round
	MOVF 0x3E,W
	MOVWF 0x3A
	MOVF 0x3F,W
	MOVWF 0x3B
; 525: 				Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 526: 				act_pos = act_pos + 1
	MOVF 0x32,W
	ADDLW 0x01
	MOVWF 0x32
; 527: 				value = act_pos
	MOVF 0x32,W
	MOVWF 0x36
; 528: 				Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 529: 				WaitMs 1000  'just indicate that program reacts on the ecsw switch
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 530: 				While ecsw = 0
L0172:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0173
; 531: 				Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0172
L0173:
; 532: 			Endif
L0171:
; 533: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0169
L0170:
; 534: 
; 535: 		direction = 0  'goto to zero switch
	BCF 0x07,0
; 536: 		ena = 1  'set anable on
	BSF 0x07,2
; 537: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 538: 		While zero = 1  'turn motor until ZERO switch is activated
L0174:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0175
; 539: 			clk = 1  'clock out
	BSF 0x07,1
; 540: 			WaitUs speed_max
	MOVF 0x37,W
	MOVWF R4L
	MOVF 0x38,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 541: 			clk = 0
	BCF 0x07,1
; 542: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0174
L0175:
; 543: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 544: 		new_pos = 0
	CLRF 0x41
; 545: 		steps = 0
	CLRF 0x30
	CLRF 0x31
; 546: 		Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 547: 		direction = 1  'now forwards
	BSF 0x07,0
; 548: 		steps = new_steps + free_space_steps
	MOVF 0x3A,W
	ADDWF 0x3D,W
	MOVWF 0x30
	MOVF 0x3B,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x31
; 549: 		ramp_up = 1
	BSF 0x4F,2
; 550: 		ramp_down_point = 0
	CLRF 0x51
	CLRF 0x52
; 551: 		half_steps = steps / 2
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x55
	MOVF R0H,W
	MOVWF 0x56
; 552: 		speed = speed_min
	MOVF 0x33,W
	MOVWF 0x46
	MOVF 0x34,W
	MOVWF 0x47
; 553: 		ena = 1  'set Enable on
	BSF 0x07,2
; 554: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 555: 		While steps > 0  'NOW RUN UNTIL STEPS = 0
L0176:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0177
; 556: 			clk = 1  'clock out
	BSF 0x07,1
; 557: 			WaitUs speed
	MOVF 0x46,W
	MOVWF R4L
	MOVF 0x47,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 558: 			clk = 0
	BCF 0x07,1
; 559: 			Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 560: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 561: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0176
L0177:
; 562: 		WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 563: 		steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x30
	CLRF 0x31
; 564: 		direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 565: 		While steps > 0  'NOW RUN UNTIL STEPS = 0
L0178:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0179
; 566: 			clk = 1  'clock out
	BSF 0x07,1
; 567: 			WaitUs speed_min
	MOVF 0x33,W
	MOVWF R4L
	MOVF 0x34,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 568: 			clk = 0
	BCF 0x07,1
; 569: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 570: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0178
L0179:
; 571: 		ena = 0  'enable off
	BCF 0x07,2
; 572: 		adjust_en = 0
	CLRF 0x4A
; 573: 	
; 574: 	Case 62  'this is the automatic position calculation
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0180
L0166:
	MOVF 0x41,W
	SUBLW 0x3E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0181
; 575: 		direction = 1  'first forward
	BSF 0x07,0
; 576: 		ena = 1  'set anable on
	BSF 0x07,2
; 577: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 578: 		While max_end = 1  'turn motor until end switch is activated
L0182:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,7
	GOTO L0183
; 579: 			clk = 1  'clock out
	BSF 0x07,1
; 580: 			WaitUs speed_max
	MOVF 0x37,W
	MOVWF R4L
	MOVF 0x38,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 581: 			clk = 0
	BCF 0x07,1
; 582: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0182
L0183:
; 583: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 584: 		one_round = 0  'start counting one round steps
	CLRF 0x3E
	CLRF 0x3F
; 585: 		ena = 1  'set anable on
	BSF 0x07,2
; 586: 		direction = 0  'now backwards
	BCF 0x07,0
; 587: 		While zero = 1  'turn motor until zero switch is activated
L0184:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0185
; 588: 			clk = 1  'clock out
	BSF 0x07,1
; 589: 			WaitUs speed_max
	MOVF 0x37,W
	MOVWF R4L
	MOVF 0x38,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 590: 			clk = 0
	BCF 0x07,1
; 591: 			one_round = one_round + 1
	MOVF 0x3E,W
	ADDLW 0x01
	MOVWF 0x3E
	MOVF 0x3F,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3F
; 592: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0184
L0185:
; 593: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 594: 		one_round = one_round - 500  'rail position 0 is a bit further from switch
	MOVLW 0xF4
	SUBWF 0x3E,W
	MOVWF 0x3E
	MOVLW 0x01
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x3F
; 595: 		act_steps = 0
	CLRF 0x44
	CLRF 0x45
; 596: 		new_steps = 250 + free_space_steps
	MOVLW 0xFA
	ADDWF 0x3D,W
	MOVWF 0x3A
	MOVLW 0x00
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x3B
; 597: 		direction = 1  'first forward
	BSF 0x07,0
; 598: 		ena = 1  'set anable on
	BSF 0x07,2
; 599: 		While act_steps < new_steps
L0186:
	MOVF 0x44,W
	MOVWF R0L
	MOVF 0x45,W
	MOVWF R0H
	MOVF 0x3A,W
	MOVWF R1L
	MOVF 0x3B,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0187
; 600: 			clk = 1  'clock out
	BSF 0x07,1
; 601: 			WaitUs speed_min
	MOVF 0x33,W
	MOVWF R4L
	MOVF 0x34,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 602: 			clk = 0
	BCF 0x07,1
; 603: 			act_steps = act_steps + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
	MOVF 0x45,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x45
; 604: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0186
L0187:
; 605: 		WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 606: 		steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x30
	CLRF 0x31
; 607: 		direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 608: 		While steps > 0  'NOW RUN UNTIL STEPS = 0
L0188:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0189
; 609: 			clk = 1  'clock out
	BSF 0x07,1
; 610: 			WaitUs speed_min
	MOVF 0x33,W
	MOVWF R4L
	MOVF 0x34,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 611: 			clk = 0
	BCF 0x07,1
; 612: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 613: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0188
L0189:
; 614: 		new_pos = 0
	CLRF 0x41
; 615: 		act_pos = 0
	CLRF 0x32
; 616: 		one_round = one_round - 250  'substract also the space between last rail and end-switch
	MOVLW 0xFA
	SUBWF 0x3E,W
	MOVWF 0x3E
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x3F
; 617: 		'now calculate the steps  and save steps.
; 618: 		new_steps = 250
	MOVLW 0xFA
	MOVWF 0x3A
	CLRF 0x3B
; 619: 		Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 620: 		max_pos = max_pos + 1
	MOVF 0x39,W
	ADDLW 0x01
	MOVWF 0x39
; 621: 		steps = one_round / max_pos
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVF 0x39,W
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x30
	MOVF R0H,W
	MOVWF 0x31
; 622: 		For act_pos = 1 To max_pos
	MOVLW 0x01
	MOVWF 0x32
L0190:
	MOVF 0x32,W
	SUBWF 0x39,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0191
; 623: 			new_steps = new_steps + steps
	MOVF 0x3A,W
	ADDWF 0x30,W
	MOVWF 0x3A
	MOVF 0x3B,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x31,W
	MOVWF 0x3B
; 624: 			Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 625: 		Next act_pos
	MOVLW 0x01
	ADDWF 0x32,F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0190
L0191:
; 626: 		max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x39,W
	MOVWF 0x39
; 627: 		act_pos = 0
	CLRF 0x32
; 628: 		adjust_en = 0
	CLRF 0x4A
; 629: 	Case 63  'go to zero switch and then to 1st rail position (Pos 0)
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0192
L0181:
	MOVF 0x41,W
	SUBLW 0x3F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0193
; 630: 		direction = 0  'goto to zero switch
	BCF 0x07,0
; 631: 		ena = 1  'set anable on
	BSF 0x07,2
; 632: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 633: 		While zero = 1  'turn motor until ZERO switch is activated
L0194:
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x06,6
	GOTO L0195
; 634: 			clk = 1  'clock out
	BSF 0x07,1
; 635: 			WaitUs speed_max
	MOVF 0x37,W
	MOVWF R4L
	MOVF 0x38,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 636: 			clk = 0
	BCF 0x07,1
; 637: 		Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0194
L0195:
; 638: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 639: 		new_pos = 0
	CLRF 0x41
; 640: 		Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 641: 		direction = 1  'now forwards
	BSF 0x07,0
; 642: 		steps = steps + new_steps + free_space_steps
;       The address of 'oshonsoft_temp_1' (word) (global) is 0x5A
	oshonsoft_temp_1 EQU 0x5A
	MOVF 0x30,W
	ADDWF 0x3A,W
	MOVWF 0x5A
	MOVF 0x31,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x3B,W
	MOVWF 0x5B
	MOVF 0x5A,W
	ADDWF 0x3D,W
	MOVWF 0x5A
	MOVF 0x5B,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x5B
	MOVF 0x5A,W
	MOVWF 0x30
	MOVF 0x5B,W
	MOVWF 0x31
; 643: 		ramp_up = 1
	BSF 0x4F,2
; 644: 		ramp_down_point = 0
	CLRF 0x51
	CLRF 0x52
; 645: 		half_steps = steps / 2
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x55
	MOVF R0H,W
	MOVWF 0x56
; 646: 		speed = speed_min
	MOVF 0x33,W
	MOVWF 0x46
	MOVF 0x34,W
	MOVWF 0x47
; 647: 		ena = 1  'set Enable on
	BSF 0x07,2
; 648: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 649: 		While steps > 0  'NOW RUN UNTIL STEPS = 0
L0196:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0197
; 650: 			clk = 1  'clock out
	BSF 0x07,1
; 651: 			WaitUs speed
	MOVF 0x46,W
	MOVWF R4L
	MOVF 0x47,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 652: 			clk = 0
	BCF 0x07,1
; 653: 			Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 654: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 655: 		Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0196
L0197:
; 656: 		WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 657: 		steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x30
	CLRF 0x31
; 658: 		direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 659: 		While steps > 0  'NOW RUN UNTIL STEPS = 0
L0198:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0199
; 660: 			clk = 1  'clock out
	BSF 0x07,1
; 661: 			WaitUs speed_min
	MOVF 0x33,W
	MOVWF R4L
	MOVF 0x34,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 662: 			clk = 0
	BCF 0x07,1
; 663: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 664: 'WaitUs speed_min
; 665: 		Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0198
L0199:
; 666: 		ena = 0  'enable off
	BCF 0x07,2
; 667: 	Case Else  'this is the normal position sequence
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0200
L0193:
; 668: 		steps = 0
	CLRF 0x30
	CLRF 0x31
; 669: 		If new_steps > act_steps Then
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVF 0x44,W
	MOVWF R1L
	MOVF 0x45,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0201
; 670: 			steps = new_steps - act_steps
	MOVF 0x44,W
	SUBWF 0x3A,W
	MOVWF 0x30
	MOVF 0x45,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x31
; 671: 			direction = 1
	BSF 0x07,0
; 672: 		Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0202
L0201:
; 673: 			steps = act_steps - new_steps
	MOVF 0x3A,W
	SUBWF 0x44,W
	MOVWF 0x30
	MOVF 0x3B,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x45,W
	MOVWF 0x31
; 674: 			direction = 0
	BCF 0x07,0
; 675: 		Endif
L0202:
; 676: 		If steps > 0 Then  'motor must be activated
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0203
; 677: 			If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0204
; 678: 				steps = steps + free_space_steps
	MOVF 0x30,W
	ADDWF 0x3D,W
	MOVWF 0x30
	MOVF 0x31,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x31
; 679: 			Endif
L0204:
; 680: 			ramp_up = 1
	BSF 0x4F,2
; 681: 			ramp_down_point = 0
	CLRF 0x51
	CLRF 0x52
; 682: 			half_steps = steps / 2
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x55
	MOVF R0H,W
	MOVWF 0x56
; 683: 			speed = speed_min
	MOVF 0x33,W
	MOVWF 0x46
	MOVF 0x34,W
	MOVWF 0x47
; 684: 			ena = 1  'set anable on
	BSF 0x07,2
; 685: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 686: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0205:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0206
; 687: 				clk = 1  'clock out
	BSF 0x07,1
; 688: 				WaitUs speed
	MOVF 0x46,W
	MOVWF R4L
	MOVF 0x47,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 689: 				clk = 0
	BCF 0x07,1
; 690: 'WaitUs speed
; 691: 				Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 692: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 693: 				If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0207
; 694: 					If max_end = 0 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x06,7
	GOTO L0208
; 695: 						Gosub stop_the_motor
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 696: 					Endif
L0208:
; 697: 				Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0209
L0207:
; 698: 					If zero = 0 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x06,6
	GOTO L0210
; 699: 						Gosub stop_the_motor
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 700: 					Endif
L0210:
; 701: 				Endif
L0209:
; 702: 			Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0205
L0206:
; 703: 			If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0211
; 704: 				If free_space_steps > 0 Then
	MOVF 0x3D,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0212
; 705: 					WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 706: 					steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x30
	CLRF 0x31
; 707: 					direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 708: 					While steps > 0  'NOW RUN UNTIL STEPS = 0
L0213:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0214
; 709: 						clk = 1  'clock out
	BSF 0x07,1
; 710: 						WaitUs speed_min
	MOVF 0x33,W
	MOVWF R4L
	MOVF 0x34,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 711: 						clk = 0
	BCF 0x07,1
; 712: 						steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 713: 						WaitUs speed_min
	MOVF 0x33,W
	MOVWF R4L
	MOVF 0x34,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 714: 					Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0213
L0214:
; 715: 				Endif
L0212:
; 716: 			Endif
L0211:
; 717: 			ena = 0  'enable off
	BCF 0x07,2
; 718: 		Endif
L0203:
; 719: 	EndSelect
L0200:
L0192:
L0180:
; 720: 	act_pos = new_pos
	MOVF 0x41,W
	MOVWF 0x32
; 721: 	Write mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0215:	BTFSC EECON1,WR
	GOTO L0215
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 722: 	bus_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x4E
; 723: 	old_bus_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x57
; 724: 	manual_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x35
; 725: 	old_manual_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x54
; 726: 
; 727: Return
	RETURN
; 728: 
; 729: 
; 730: 
; 731: 
; 732: speed_calc:
L0008:
; 733: 	If steps < half_steps Then  'at this point  ramp up MUST end
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVF 0x55,W
	MOVWF R1L
	MOVF 0x56,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0216
; 734: 		ramp_up = 0
	BCF 0x4F,2
; 735: 	Endif
L0216:
; 736: 	If ramp_up = 1 Then  'we were supposed to ramp up
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x4F,2
	GOTO L0217
; 737: 		If speed > speed_max Then
	MOVF 0x46,W
	MOVWF R0L
	MOVF 0x47,W
	MOVWF R0H
	MOVF 0x37,W
	MOVWF R1L
	MOVF 0x38,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0218
; 738: 			speed = speed - speed_step
	MOVF 0x43,W
	SUBWF 0x46,W
	MOVWF 0x46
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x47,W
	MOVWF 0x47
; 739: 			ramp_down_point = ramp_down_point + 1  'this counts down with the steps
	MOVF 0x51,W
	ADDLW 0x01
	MOVWF 0x51
	MOVF 0x52,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x52
; 740: 		Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0219
L0218:
; 741: 			ramp_up = 0
	BCF 0x4F,2
; 742: 		Endif
L0219:
; 743: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0220
L0217:
; 744: 		If steps < ramp_down_point Then  'this is the point tot start ramp down
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVF 0x51,W
	MOVWF R1L
	MOVF 0x52,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0221
; 745: 			If speed < speed_min Then
	MOVF 0x46,W
	MOVWF R0L
	MOVF 0x47,W
	MOVWF R0H
	MOVF 0x33,W
	MOVWF R1L
	MOVF 0x34,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0222
; 746: 				speed = speed + speed_step
	MOVF 0x46,W
	ADDWF 0x43,W
	MOVWF 0x46
	MOVF 0x47,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x47
; 747: 			Endif
L0222:
; 748: 		Endif
L0221:
; 749: 	Endif
L0220:
; 750: Return
	RETURN
; 751: 
; 752: 
; 753: relays:
L0009:
; 754: 	If bridge_power = 0 Then
	MOVF 0x4D,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0223
; 755: 		If onoff = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x4F,0
	GOTO L0224
; 756: 			swfw = 1
	BSF 0x06,0
; 757: 		Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0225
L0224:
; 758: 			swfw = 0
	BCF 0x06,0
; 759: 		Endif
L0225:
; 760: 	Else  'bridge remains under power
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0226
L0223:
; 761: 		swfw = 1
	BSF 0x06,0
; 762: 	Endif
L0226:
; 763: Return
	RETURN
; 764: 
; 765: 
; 766: init_values:
L0010:
; 767: 	value = 85  'version number
	MOVLW 0x55
	MOVWF 0x36
; 768: 	version = 0  'decimal point in display on
	BCF 0x4F,1
; 769: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 770: 	WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 771: 	version = 1  'decimal point in display off
	BSF 0x4F,1
; 772: 	encoder_count = 0
	CLRF 0x4C
; 773: 	speed_min = 0
	CLRF 0x33
	CLRF 0x34
; 774: 	Read mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 775: 	If speed_min.HB > 99 Then
	MOVF 0x34,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0227
; 776: 		speed_min.HB = 40
	MOVLW 0x28
	MOVWF 0x34
; 777: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0228
L0227:
; 778: 		If speed_min.HB < 2 Then
	MOVLW 0x02
	SUBWF 0x34,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0229
; 779: 			speed_min.HB = 20
	MOVLW 0x14
	MOVWF 0x34
; 780: 		Endif
L0229:
; 781: 	Endif
L0228:
; 782: 	speed_max = 0
	CLRF 0x37
	CLRF 0x38
; 783: 	Read mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x38
; 784: 	If speed_max.HB > speed_min.HB Then
	MOVF 0x38,W
	SUBWF 0x34,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0230
; 785: 		speed_max.HB = speed_min.HB
	MOVF 0x34,W
	MOVWF 0x38
; 786: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0231
L0230:
; 787: 		If speed_max.HB < 2 Then
	MOVLW 0x02
	SUBWF 0x38,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0232
; 788: 			speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x38
; 789: 		Endif
L0232:
; 790: 	Endif
L0231:
; 791: 
; 792: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3E
; 793: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 794: 	If one_round = 0 Then
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0233
; 795: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x3E
	MOVLW 0x1F
	MOVWF 0x3F
; 796: 	Endif
L0233:
; 797: 	If one_round > 60000 Then
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0234
; 798: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x3E
	MOVLW 0x1F
	MOVWF 0x3F
; 799: 	Endif
L0234:
; 800: 	one_round_half = one_round / 2
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x58
	MOVF R0H,W
	MOVWF 0x59
; 801: 
; 802: 	Read mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 803: 	If max_pos > 47 Then
	MOVF 0x39,W
	SUBLW 0x2F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0235
; 804: 		max_pos = 11
	MOVLW 0x0B
	MOVWF 0x39
; 805: 	Endif
L0235:
; 806: 	Read mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x32
; 807: 	If act_pos > max_pos Then
	MOVF 0x32,W
	SUBWF 0x39,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0236
; 808: 		act_pos = 0
	CLRF 0x32
; 809: 		Write mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0237:	BTFSC EECON1,WR
	GOTO L0237
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 810: 	Endif
L0236:
; 811: 	value = act_pos
	MOVF 0x32,W
	MOVWF 0x36
; 812: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 813: 	Read mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3D
; 814: 	If free_space_steps > 99 Then
	MOVF 0x3D,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0238
; 815: 		free_space_steps = 50
	MOVLW 0x32
	MOVWF 0x3D
; 816: 	Endif
L0238:
; 817: 	Read mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 818: 	If pos_match_delay > 50 Then
	MOVF 0x40,W
	SUBLW 0x32
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0239
; 819: 		pos_match_delay = 10
	MOVLW 0x0A
	MOVWF 0x40
; 820: 	Endif
L0239:
; 821: 	
; 822: 	Read mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x43
; 823: 	If speed_step > 99 Then
	MOVF 0x43,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0240
; 824: 		speed_step = 20
	MOVLW 0x14
	MOVWF 0x43
; 825: 	Endif
L0240:
; 826: 	steps_set = 0
	BCF 0x4F,3
; 827: 	new_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x41
; 828: 	bus_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x4E
; 829: 	old_bus_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x57
; 830: 	manual_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x35
; 831: 	old_manual_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x54
; 832: 	old_pos_write = 1
	BSF 0x4F,4
; 833: Return
	RETURN
; 834: 
; 835: steps_reading:
L0011:
; 836: 	Select Case act_pos
; 837: 	Case 61, 63, 62
	MOVF 0x32,W
	SUBLW 0x3D
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0243
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0242
L0243:
	MOVF 0x32,W
	SUBLW 0x3F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0244
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0242
L0244:
	MOVF 0x32,W
	SUBLW 0x3E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0241
L0242:
; 838: 		act_steps = 0
	CLRF 0x44
	CLRF 0x45
; 839: 	Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0245
L0241:
; 840: 		eprom_pointer = act_pos
	MOVF 0x32,W
	MOVWF 0x48
; 841: 		eprom_pointer = eprom_pointer + 48
	MOVF 0x48,W
	ADDLW 0x30
	MOVWF 0x48
; 842: 		Read act_pos, act_steps.LB
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x44
; 843: 		Read eprom_pointer, act_steps.HB
	MOVF 0x48,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x45
; 844: 	EndSelect
L0245:
; 845: 	Select Case new_pos
; 846: 	Case 61, 62, 63
	MOVF 0x41,W
	SUBLW 0x3D
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0248
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0247
L0248:
	MOVF 0x41,W
	SUBLW 0x3E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0249
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0247
L0249:
	MOVF 0x41,W
	SUBLW 0x3F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0246
L0247:
; 847: 		new_steps = 0
	CLRF 0x3A
	CLRF 0x3B
; 848: 	Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0250
L0246:
; 849: 		eprom_pointer = new_pos
	MOVF 0x41,W
	MOVWF 0x48
; 850: 		eprom_pointer = eprom_pointer + 48
	MOVF 0x48,W
	ADDLW 0x30
	MOVWF 0x48
; 851: 		Read new_pos, new_steps.LB
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3A
; 852: 		Read eprom_pointer, new_steps.HB
	MOVF 0x48,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3B
; 853: 	Endif
L0250:
; 854: Return
	RETURN
; 855: 
; 856: 
; 857: save_steps:
L0012:
; 858: 	eprom_pointer = act_pos
	MOVF 0x32,W
	MOVWF 0x48
; 859: 	eprom_pointer = eprom_pointer + 48
	MOVF 0x48,W
	ADDLW 0x30
	MOVWF 0x48
; 860: 	Write act_pos, new_steps.LB
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0251:	BTFSC EECON1,WR
	GOTO L0251
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 861: 	Write eprom_pointer, new_steps.HB
	MOVF 0x48,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0252:	BTFSC EECON1,WR
	GOTO L0252
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 862: Return
	RETURN
; 863: 
; 864: 
; 865: stop_the_motor:
L0013:
; 866: 	ena = 0  'set anable oFF
	BCF 0x07,2
; 867: 	value = act_pos
	MOVF 0x32,W
	MOVWF 0x36
; 868: 	version = 0  'decimal point in display on
	BCF 0x4F,1
; 869: 	While ecsw = 1
L0253:
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,6
	GOTO L0254
; 870: 		WaitMs 250
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 871: 		Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 872: 		version = Not version
	MOVLW 0x02
	XORWF 0x4F,F
; 873: 	Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0253
L0254:
; 874: 	version = 1  'decimal point off
	BSF 0x4F,1
; 875: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 876: 	ena = 1  'set anable on
	BSF 0x07,2
; 877: Return
	RETURN
; 878: wait_pos_match:
L0014:
; 879: 	value = 99
	MOVLW 0x63
	MOVWF 0x36
; 880: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 881: 	steps = pos_match_delay * 100
	MOVF 0x40,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x30
	MOVF R2H,W
	MOVWF 0x31
; 882: 	WaitMs steps
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 883: 	value = act_pos
	MOVF 0x32,W
	MOVWF 0x36
; 884: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 885: 	pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 886: Return
	RETURN
; End of program
;       PAGE SELECT
	BSF PCLATH,3
L0255:	GOTO L0255
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
