; Compiled with: PIC Simulator IDE v6.92
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_act_pos' (global) is 127
;       The value of 'mem_speed_min' (global) is 103
;       The value of 'mem_speed_max' (global) is 104
;       The value of 'mem_speed_step' (global) is 105
;       The value of 'mem_one_round_lb' (global) is 106
;       The value of 'mem_one_round_hb' (global) is 107
;       The value of 'mem_ctrl_type' (global) is 108
;       The value of 'mem_max_pos' (global) is 109
;       The value of 'mem_free_space' (global) is 110
;       The value of 'mem_rev_pos' (global) is 111
;       The value of 'mem_bridge_power' (global) is 112
;       The value of 'mem_pos_match_delay' (global) is 113
;       The address of 'steps' (word) (global) is 0x30
	steps EQU 0x30
;       The address of 'speed_min' (word) (global) is 0x32
	speed_min EQU 0x32
;       The address of 'act_pos' (byte) (global) is 0x34
	act_pos EQU 0x34
;       The address of 'speed_max' (word) (global) is 0x35
	speed_max EQU 0x35
;       The address of 'manual_pos' (byte) (global) is 0x37
	manual_pos EQU 0x37
;       The address of 'value' (byte) (global) is 0x38
	value EQU 0x38
;       The address of 'max_pos' (byte) (global) is 0x39
	max_pos EQU 0x39
;       The address of 'new_steps' (word) (global) is 0x3A
	new_steps EQU 0x3A
;       The address of 'result' (byte) (global) is 0x3C
	result EQU 0x3C
;       The address of 'free_space_steps' (byte) (global) is 0x3D
	free_space_steps EQU 0x3D
;       The address of 'one_round' (word) (global) is 0x3E
	one_round EQU 0x3E
;       The address of 'pos_match_delay' (byte) (global) is 0x40
	pos_match_delay EQU 0x40
;       The address of 'new_pos' (byte) (global) is 0x41
	new_pos EQU 0x41
;       The address of 'speed' (word) (global) is 0x42
	speed EQU 0x42
;       The address of 'program_set' (byte) (global) is 0x44
	program_set EQU 0x44
;       The address of 'speed_step' (byte) (global) is 0x45
	speed_step EQU 0x45
;       The address of 'act_steps' (word) (global) is 0x46
	act_steps EQU 0x46
;       The address of 'eprom_pointer' (byte) (global) is 0x48
	eprom_pointer EQU 0x48
;       The address of 'decoder_pulses' (bit) (global) is 0x49,0
;       The address of 'disp1_val' (byte) (global) is 0x4A
	disp1_val EQU 0x4A
;       The address of 'adjust_en' (byte) (global) is 0x4B
	adjust_en EQU 0x4B
;       The address of 'new_encoder' (byte) (global) is 0x4C
	new_encoder EQU 0x4C
;       The address of 'encoder_count' (byte) (global) is 0x4D
	encoder_count EQU 0x4D
;       The address of 'bus_pos' (byte) (global) is 0x4E
	bus_pos EQU 0x4E
;       The address of 'onoff' (bit) (global) is 0x49,1
;       The address of 'disp2_val' (byte) (global) is 0x4F
	disp2_val EQU 0x4F
;       The address of 'bridge_power' (byte) (global) is 0x50
	bridge_power EQU 0x50
;       The address of 'version' (bit) (global) is 0x49,2
;       The address of 'ramp_up' (bit) (global) is 0x49,3
;       The address of 'steps_set' (bit) (global) is 0x49,4
;       The address of 'ramp_down_point' (word) (global) is 0x51
	ramp_down_point EQU 0x51
;       The address of 'old_encoder' (byte) (global) is 0x53
	old_encoder EQU 0x53
;       The address of 'old_manual_pos' (byte) (global) is 0x54
	old_manual_pos EQU 0x54
;       The address of 'old_pos_write' (bit) (global) is 0x49,5
;       The address of 'half_steps' (word) (global) is 0x55
	half_steps EQU 0x55
;       The address of 'old_bus_pos' (byte) (global) is 0x57
	old_bus_pos EQU 0x57
;       The address of 'one_round_half' (word) (global) is 0x58
	one_round_half EQU 0x58
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x6,6
;       The address of 'max_end' (bit) (global) is 0x6,7
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0015
	ORG 0x0004
	RETFIE
; LookUp Table: (3, 2, 1, 3)
_lookup_lab_0001:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
; LookUp Table: (1, 3, 3, 2)
_lookup_lab_0002:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
; LookUp Table: (2, 3, 3, 1)
_lookup_lab_0003:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
; LookUp Table: (3, 1, 2, 3)
_lookup_lab_0004:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0005:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; LookUp Table: (%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111)
_lookup_lab_0006:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0007:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0015:
; 1: 
; 2: 
; 3: Define CONF_WORD = 0x3f72
; 4: 
; 5: 'program TT for PCBoard MGV145
; 6: 'special version 8-4  small fiddle yard RDS
; 7: 'version 8-5 with extra position 61 . This position will run to zero switch, and then, by hitting the
; 8: '-     incremental knob on every position, , the program will store that position, and increment the display
; 9: '-     to the next. After reaching the last position, the motor will run back to zero switch and then
; 10: '-     position 0.
; 11: 'Version 8.6 Bridge will be switched off at startup, and a new position has to be set to set bridge on power.
; 12: 'RB7 on ICSP1 (pin3) is endswitch (pass last rail)
; 13: 'RB6 on ICSP1 (pin2) is endswitch (pass first rail)
; 14: 'EEP jumper must always be at ON !
; 15: 'two extra position are possible:
; 16: '-  position 63 to go to zero switch and then to rail 0
; 17: '-  position 62 to reset and recalculate all values (only when menu 8 is set)
; 18: 'programs :
; 19: '0  correction actual position
; 20: '1  Max positions
; 21: '2  min speed
; 22: '3  max speed
; 23: '4  incr/decr delay
; 24: '5  extra correction steps
; 25: '6  bridge power on/off (1/0)
; 26: '7  pos_match delay
; 27: '8  adjust_position >>>: this enables / disables the choice of pos 62
; 28: Dim steps As Word
; 29: Dim half_steps As Word
; 30: Dim ramp_down_point As Word
; 31: Dim program_set As Byte
; 32: Dim new_steps As Word
; 33: Dim act_steps As Word
; 34: Dim new_pos As Byte
; 35: Dim act_pos As Byte
; 36: Dim one_round As Word
; 37: Dim one_round_half As Word
; 38: Dim bus_pos As Byte
; 39: Dim old_bus_pos As Byte
; 40: Dim speed As Word
; 41: Dim speed_min As Word
; 42: Dim speed_max As Word
; 43: Dim new_encoder As Byte
; 44: Dim old_encoder As Byte
; 45: Dim manual_pos As Byte
; 46: Dim old_manual_pos As Byte
; 47: Dim result As Byte
; 48: Dim free_space_steps As Byte
; 49: Dim value As Byte
; 50: Dim eprom_pointer As Byte
; 51: Dim encoder_count As Byte
; 52: Dim onoff As Bit
; 53: Dim max_pos As Byte
; 54: Dim disp1_val As Byte
; 55: Dim disp2_val As Byte
; 56: Dim old_pos_write As Bit
; 57: Dim ramp_up As Bit
; 58: Dim speed_step As Byte
; 59: Dim version As Bit
; 60: Dim steps_set As Bit
; 61: Dim bridge_power As Byte
; 62: Dim pos_match_delay As Byte
; 63: Dim adjust_en As Byte
; 64: Dim decoder_pulses As Bit
; 65: 
; 66: Const disp1 = 64
; 67: Const disp2 = 66
; 68: Const mem_act_pos = 127
; 69: Const mem_speed_min = 103
; 70: Const mem_speed_max = 104
; 71: Const mem_speed_step = 105
; 72: Const mem_one_round_lb = 106
; 73: Const mem_one_round_hb = 107
; 74: Const mem_ctrl_type = 108
; 75: Const mem_max_pos = 109
; 76: Const mem_free_space = 110
; 77: Const mem_rev_pos = 111
; 78: Const mem_bridge_power = 112
; 79: Const mem_pos_match_delay = 113
; 80: 
; 81: Symbol swfw = RB0
; 82: Symbol swrev = RB1
; 83: Symbol sck = RB2
; 84: Symbol sda = RB3
; 85: Symbol pos_match = RB4
; 86: Symbol pos_write = RB5
; 87: Symbol direction = RC0
; 88: Symbol clk = RC1
; 89: Symbol ena = RC2
; 90: Symbol zero = RB6
; 91: Symbol max_end = RB7
; 92: Symbol ec1 = RC4
; 93: Symbol ec2 = RC5
; 94: Symbol ecsw = RC6
; 95: Symbol pgm = RC7
; 96: 
; 97: ADCON1 = %0110
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 98: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 99: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 100: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 101: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 102: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 103: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 104: Gosub init_values
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0010
; 105: onoff = 1
	BSF 0x49,1
; 106: Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 107: program_set = 0
	CLRF 0x44
; 108: max_end = 1
	BSF 0x06,7
; 109: adjust_en = 0
	CLRF 0x4B
; 110: main:
L0001:
; 111: 	If pgm = 0 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0016
; 112: 		Gosub adjust_settings
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0004
; 113: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 114: 	Endif
L0016:
; 115: 
; 116: 	Gosub get_new_position
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0002
; 117: 	If bus_pos <> old_bus_pos Then
	MOVF 0x4E,W
	SUBWF 0x57,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0017
; 118: 		onoff = 0
	BCF 0x49,1
; 119: 		Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 120: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 121: 		new_pos = bus_pos
	MOVF 0x4E,W
	MOVWF 0x41
; 122: 		Gosub stepmotor
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0007
; 123: 		Gosub wait_pos_match
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 124: 		onoff = 1
	BSF 0x49,1
; 125: 	Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0018
L0017:
; 126: 		If ecsw = 0 Then  'only when knob is pushed
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0019
; 127: 			If manual_pos <> old_manual_pos Then
	MOVF 0x37,W
	SUBWF 0x54,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0020
; 128: 				onoff = 0
	BCF 0x49,1
; 129: 				Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 130: 				pos_match = 1  'indicate not in position
	BSF 0x06,4
; 131: 				old_manual_pos = manual_pos
	MOVF 0x37,W
	MOVWF 0x54
; 132: 				new_pos = manual_pos
	MOVF 0x37,W
	MOVWF 0x41
; 133: 				Gosub stepmotor
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0007
; 134: 				Gosub wait_pos_match
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 135: 				onoff = 1
	BSF 0x49,1
; 136: 			Endif
L0020:
; 137: 		Endif
L0019:
; 138: 	Endif
L0018:
; 139: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 140: 	Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 141: 	Goto main
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0001
; 142: End
;       PAGE SELECT
	BCF PCLATH,3
L0021:	GOTO L0021
; 143: 
; 144: 
; 145: get_new_position:
L0002:
; 146: 	value = bus_pos  'remember the position
	MOVF 0x4E,W
	MOVWF 0x38
; 147: 	If pos_write = 1 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,5
	GOTO L0022
; 148: 		If old_pos_write = 0 Then  'react once on rising edge
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x49,5
	GOTO L0023
; 149: 			old_pos_write = 1
	BSF 0x49,5
; 150: 			value = PORTA And 63  'now get value from J5
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x38
; 151: 			Select Case value
; 152: 			Case 63  'position reset is desired
	MOVF 0x38,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0024
; 153: 				value = 63
	MOVLW 0x3F
	MOVWF 0x38
; 154: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0025
L0024:
; 155: 				If value > max_pos Then  'this is not allowed
	MOVF 0x38,W
	SUBWF 0x39,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0026
; 156: 					value = bus_pos  'put it back to old situation
	MOVF 0x4E,W
	MOVWF 0x38
; 157: 				Endif
L0026:
; 158: 			EndSelect
L0025:
; 159: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 160: 			If value = bus_pos Then  'no other position is set, just a response on pos_write is required
	MOVF 0x38,W
	SUBWF 0x4E,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0027
; 161: 				pos_match = 1
	BSF 0x06,4
; 162: 				WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 163: 				pos_match = 0
	BCF 0x06,4
; 164: 			Endif
L0027:
; 165: 		Endif
L0023:
; 166: 	Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0028
L0022:
; 167: 		old_pos_write = 0
	BCF 0x49,5
; 168: 	Endif
L0028:
; 169: 	bus_pos = value  'now take over the desired position
	MOVF 0x38,W
	MOVWF 0x4E
; 170: 	Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 171: 	Select Case result
; 172: 	Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0029
; 173: 		If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x4D,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0030
; 174: 			encoder_count = encoder_count + 1
	MOVF 0x4D,W
	ADDLW 0x01
	MOVWF 0x4D
; 175: 		Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0031
L0030:
; 176: 			encoder_count = 0
	CLRF 0x4D
; 177: 			Select Case manual_pos
; 178: 			Case < max_pos
	MOVF 0x39,W
	SUBWF 0x37,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0032
; 179: 				manual_pos = manual_pos + 1
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x37
; 180: 			Case max_pos
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0033
L0032:
	MOVF 0x37,W
	SUBWF 0x39,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0034
; 181: 				Select Case adjust_en
; 182: 				Case 0
	MOVF 0x4B,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0035
; 183: 					manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x37
; 184: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0036
L0035:
; 185: 					manual_pos = 61
	MOVLW 0x3D
	MOVWF 0x37
; 186: 				EndSelect
L0036:
; 187: 			Case 63
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0037
L0034:
	MOVF 0x37,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0038
; 188: 				manual_pos = 0
	CLRF 0x37
; 189: 			Case 62
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0039
L0038:
	MOVF 0x37,W
	SUBLW 0x3E
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0040
; 190: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x37
; 191: 			Case 61
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0041
L0040:
	MOVF 0x37,W
	SUBLW 0x3D
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0042
; 192: 				manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x37
; 193: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0043
L0042:
; 194: 			EndSelect
L0043:
L0041:
L0039:
L0037:
L0033:
; 195: 			value = manual_pos
	MOVF 0x37,W
	MOVWF 0x38
; 196: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 197: 		Endif
L0031:
; 198: 	Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0044
L0029:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0045
; 199: 		If encoder_count > 0 Then
	MOVF 0x4D,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0046
; 200: 			encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x4D,W
	MOVWF 0x4D
; 201: 		Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0047
L0046:
; 202: 			encoder_count = 4
	MOVLW 0x04
	MOVWF 0x4D
; 203: 			Select Case manual_pos
; 204: 			Case 61
	MOVF 0x37,W
	SUBLW 0x3D
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0048
; 205: 				manual_pos = max_pos
	MOVF 0x39,W
	MOVWF 0x37
; 206: 			Case 62
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0049
L0048:
	MOVF 0x37,W
	SUBLW 0x3E
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0050
; 207: 				manual_pos = 61
	MOVLW 0x3D
	MOVWF 0x37
; 208: 			Case 63
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0051
L0050:
	MOVF 0x37,W
	SUBLW 0x3F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0052
; 209: 				Select Case adjust_en
; 210: 				Case 0
	MOVF 0x4B,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0053
; 211: 					manual_pos = max_pos
	MOVF 0x39,W
	MOVWF 0x37
; 212: 				Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0054
L0053:
; 213: 					manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x37
; 214: 				EndSelect
L0054:
; 215: 			Case 0
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0055
L0052:
	MOVF 0x37,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0056
; 216: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x37
; 217: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0057
L0056:
; 218: 				manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x37,W
	MOVWF 0x37
; 219: 			EndSelect
L0057:
L0055:
L0051:
L0049:
; 220: 			value = manual_pos
	MOVF 0x37,W
	MOVWF 0x38
; 221: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 222: 		Endif
L0047:
; 223: 	Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0058
L0045:
; 224: 	EndSelect
L0058:
L0044:
; 225: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 226: 	
; 227: Return
	RETURN
; 228: 
; 229: calc_rotation:  'this routine checks the incrimental switch
L0003:
; 230: '1 = increasing value
; 231: '2 = decreasing value
; 232: '3 = no change
; 233: 		new_encoder = 0
	CLRF 0x4C
; 234: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x4C,0
	BTFSS 0x07,4
	BCF 0x4C,0
; 235: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x4C,1
	BTFSS 0x07,5
	BCF 0x4C,1
; 236: 		Select Case old_encoder
; 237: 		Case 0
	MOVF 0x53,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0059
; 238: 			If decoder_pulses = 0 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x49,0
	GOTO L0060
; 239: 				decoder_pulses = 1
	BSF 0x49,0
; 240: 			Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0061
L0060:
; 241: 				decoder_pulses = 0
	BCF 0x49,0
; 242: 				result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x4C,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0062
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0001
	MOVWF 0x3C
L0062:
; 243: 			Endif
L0061:
; 244: 		Case 1
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0063
L0059:
	MOVF 0x53,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0064
; 245: 			If decoder_pulses = 0 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x49,0
	GOTO L0065
; 246: 				decoder_pulses = 1
	BSF 0x49,0
; 247: 			Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0066
L0065:
; 248: 				result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x4C,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0067
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0002
	MOVWF 0x3C
L0067:
; 249: 				decoder_pulses = 0
	BCF 0x49,0
; 250: 			Endif
L0066:
; 251: 		Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0068
L0064:
	MOVF 0x53,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0069
; 252: 			If decoder_pulses = 0 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x49,0
	GOTO L0070
; 253: 				decoder_pulses = 1
	BSF 0x49,0
; 254: 			Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0071
L0070:
; 255: 				result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x4C,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0072
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0003
	MOVWF 0x3C
L0072:
; 256: 				decoder_pulses = 0
	BCF 0x49,0
; 257: 			Endif
L0071:
; 258: 		Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0073
L0069:
; 259: 			If decoder_pulses = 0 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x49,0
	GOTO L0074
; 260: 				decoder_pulses = 1
	BSF 0x49,0
; 261: 			Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0075
L0074:
; 262: 				result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x4C,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0076
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0004
	MOVWF 0x3C
L0076:
; 263: 				decoder_pulses = 0
	BCF 0x49,0
; 264: 			Endif
L0075:
; 265: 		EndSelect
L0073:
L0068:
L0063:
; 266: 		old_encoder = new_encoder
	MOVF 0x4C,W
	MOVWF 0x53
; 267: Return
	RETURN
; 268: 
; 269: 
; 270: adjust_settings:
L0004:
; 271: 	Gosub i2c_display_pgm
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0006
; 272: 	WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 273: 	onoff = 0
	BCF 0x49,1
; 274: 	Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 275: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 276: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x46,W
	MOVWF 0x3A
	MOVF 0x47,W
	MOVWF 0x3B
; 277: 	While pgm = 0  'the program switch is still activated
L0077:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0078
; 278: 		If ecsw = 0 Then  'knob is pressed, inrease program_set
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0079
; 279: 			program_set = program_set + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
; 280: 			If program_set > 8 Then  'no more than 8 items te change
	MOVF 0x44,W
	SUBLW 0x08
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0080
; 281: 				program_set = 0
	CLRF 0x44
; 282: 			Endif
L0080:
; 283: 			Gosub i2c_display_pgm
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0006
; 284: 			WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 285: 			While ecsw = 0  'be sure pushbutton is released
L0081:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0082
; 286: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 287: 			Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0081
L0082:
; 288: 		Endif
L0079:
; 289: 		Select Case program_set
; 290: 		Case 0  'correction of current position
	MOVF 0x44,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0083
; 291: 			value = act_pos
	MOVF 0x34,W
	MOVWF 0x38
; 292: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 293: 			Gosub calc_rotation  'look for the knob to be turned
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 294: 			Select Case result
; 295: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0084
; 296: 				If new_steps < 60000 Then
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0085
; 297: 					ena = 1  'motor on
	BSF 0x07,2
; 298: 					new_steps = new_steps + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
	MOVF 0x3B,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3B
; 299: 					direction = 1
	BSF 0x07,0
; 300: 					clk = 1  'clock out
	BSF 0x07,1
; 301: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 302: 					clk = 0
	BCF 0x07,1
; 303: 				Endif
L0085:
; 304: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0086
L0084:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0087
; 305: 				If new_steps > 0 Then
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0088
; 306: 					ena = 1  'motor on
	BSF 0x07,2
; 307: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x3A,W
	MOVWF 0x3A
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x3B
; 308: 					direction = 0
	BCF 0x07,0
; 309: 					clk = 1  'clock out
	BSF 0x07,1
; 310: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 311: 					clk = 0
	BCF 0x07,1
; 312: 				Endif
L0088:
; 313: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0089
L0087:
; 314: 			EndSelect
L0089:
L0086:
; 315: 		Case 1  'setting of maximum positions
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0090
L0083:
	MOVF 0x44,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0091
; 316: 			steps_set = 0
	BCF 0x49,4
; 317: 			ena = 0  'shut off motor
	BCF 0x07,2
; 318: 			value = max_pos
	MOVF 0x39,W
	MOVWF 0x38
; 319: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 320: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 321: 			Select Case result
; 322: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0092
; 323: 				If max_pos < 47 Then  'no more positions possible
	MOVLW 0x2F
	SUBWF 0x39,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0093
; 324: 					max_pos = max_pos + 1
	MOVF 0x39,W
	ADDLW 0x01
	MOVWF 0x39
; 325: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0094:	BTFSC EECON1,WR
	GOTO L0094
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 326: 				Endif
L0093:
; 327: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0095
L0092:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0096
; 328: 				If max_pos > 2 Then  'minum 2 positions
	MOVF 0x39,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0097
; 329: 					max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x39,W
	MOVWF 0x39
; 330: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0098:	BTFSC EECON1,WR
	GOTO L0098
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 331: 				Endif
L0097:
; 332: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0099
L0096:
; 333: 			EndSelect
L0099:
L0095:
; 334: 		Case 2  'setting of speed interval Minimum
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0100
L0091:
	MOVF 0x44,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0101
; 335: 					'setting will be done in multiple of 256 uSecs
; 336: 					'minimum is usually not less then 5, and maximum is 99 (is real slow)
; 337: 			steps_set = 0
	BCF 0x49,4
; 338: 			ena = 0  'shut off motor
	BCF 0x07,2
; 339: 			value = speed_min.HB
	MOVF 0x33,W
	MOVWF 0x38
; 340: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 341: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 342: 			Select Case result
; 343: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0102
; 344: 				If speed_min.HB < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x33,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0103
; 345: 					speed_min.HB = speed_min.HB + 1
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x33
; 346: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0104:	BTFSC EECON1,WR
	GOTO L0104
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 347: 				Endif
L0103:
; 348: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0105
L0102:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0106
; 349: 				If speed_min.HB > speed_max.HB Then
	MOVF 0x33,W
	SUBWF 0x36,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0107
; 350: 					speed_min.HB = speed_min.HB - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
; 351: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0108:	BTFSC EECON1,WR
	GOTO L0108
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 352: 				Endif
L0107:
; 353: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0109
L0106:
; 354: 			EndSelect
L0109:
L0105:
; 355: 		Case 3  'setting of speed interval Maximum
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0110
L0101:
	MOVF 0x44,W
	SUBLW 0x03
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0111
; 356: 					'setting will be done in multiple of 256 uSecs
; 357: 					'minimum is 1 and maximum is 99 (is real slow)
; 358: 			steps_set = 0
	BCF 0x49,4
; 359: 			ena = 0  'shut off motor
	BCF 0x07,2
; 360: 			value = speed_max.HB
	MOVF 0x36,W
	MOVWF 0x38
; 361: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 362: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 363: 			Select Case result
; 364: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0112
; 365: 				If speed_max.HB < speed_min.HB Then  'not more then speed_min
	MOVF 0x33,W
	SUBWF 0x36,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0113
; 366: 					speed_max.HB = speed_max.HB + 1
	MOVF 0x36,W
	ADDLW 0x01
	MOVWF 0x36
; 367: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0114:	BTFSC EECON1,WR
	GOTO L0114
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 368: 				Endif
L0113:
; 369: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0115
L0112:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0116
; 370: 				If speed_max.HB > 2 Then
	MOVF 0x36,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0117
; 371: 					speed_max.HB = speed_max.HB - 1
	MOVLW 0x01
	SUBWF 0x36,W
	MOVWF 0x36
; 372: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0118:	BTFSC EECON1,WR
	GOTO L0118
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 373: 				Endif
L0117:
; 374: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0119
L0116:
; 375: 			EndSelect
L0119:
L0115:
; 376: 		Case 4  'setting of ramp up and down speed
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0120
L0111:
	MOVF 0x44,W
	SUBLW 0x04
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0121
; 377: 					'speed will be the value that speed will be changed every step up and down
; 378: 			steps_set = 0
	BCF 0x49,4
; 379: 			ena = 0  'shut off motor
	BCF 0x07,2
; 380: 			value = speed_step
	MOVF 0x45,W
	MOVWF 0x38
; 381: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 382: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 383: 			Select Case result
; 384: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0122
; 385: 				If speed_step < 99 Then  'maximum 99 is possible
	MOVLW 0x63
	SUBWF 0x45,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0123
; 386: 					speed_step = speed_step + 1
	MOVF 0x45,W
	ADDLW 0x01
	MOVWF 0x45
; 387: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x45,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0124:	BTFSC EECON1,WR
	GOTO L0124
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 388: 				Endif
L0123:
; 389: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0125
L0122:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0126
; 390: 				If speed_step > 1 Then
	MOVF 0x45,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0127
; 391: 					speed_step = speed_step - 1
	MOVLW 0x01
	SUBWF 0x45,W
	MOVWF 0x45
; 392: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x45,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0128:	BTFSC EECON1,WR
	GOTO L0128
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 393: 				Endif
L0127:
; 394: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0129
L0126:
; 395: 			EndSelect
L0129:
L0125:
; 396: 	
; 397: 		Case 5  'setting of extra free space steps
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0130
L0121:
	MOVF 0x44,W
	SUBLW 0x05
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0131
; 398: 			steps_set = 0
	BCF 0x49,4
; 399: 			ena = 0  'shut off motor
	BCF 0x07,2
; 400: 			If free_space_steps > 250 Then
	MOVF 0x3D,W
	SUBLW 0xFA
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0132
; 401: 				free_space_steps = 250
	MOVLW 0xFA
	MOVWF 0x3D
; 402: 				Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0133:	BTFSC EECON1,WR
	GOTO L0133
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 403: 			Endif
L0132:
; 404: 			value = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x38
; 405: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 406: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 407: 			Select Case result
; 408: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0134
; 409: 				If free_space_steps < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x3D,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0135
; 410: 					free_space_steps = free_space_steps + 1
	MOVF 0x3D,W
	ADDLW 0x01
	MOVWF 0x3D
; 411: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0136:	BTFSC EECON1,WR
	GOTO L0136
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 412: 				Endif
L0135:
; 413: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0137
L0134:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0138
; 414: 				If free_space_steps > 0 Then
	MOVF 0x3D,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0139
; 415: 					free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
; 416: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0140:	BTFSC EECON1,WR
	GOTO L0140
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 417: 				Endif
L0139:
; 418: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0141
L0138:
; 419: 			EndSelect
L0141:
L0137:
; 420: 		Case 6  'setting if power should be on or off while bridge is moving (0 = off)
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0142
L0131:
	MOVF 0x44,W
	SUBLW 0x06
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0143
; 421: 			Read mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x50
; 422: 			If bridge_power > 1 Then
	MOVF 0x50,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0144
; 423: 				bridge_power = 1
	MOVLW 0x01
	MOVWF 0x50
; 424: 			Endif
L0144:
; 425: 			value = bridge_power
	MOVF 0x50,W
	MOVWF 0x38
; 426: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 427: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 428: 			Select Case result
; 429: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0145
; 430: 				bridge_power = 1
	MOVLW 0x01
	MOVWF 0x50
; 431: 				Write mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x50,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0146:	BTFSC EECON1,WR
	GOTO L0146
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 432: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0147
L0145:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0148
; 433: 				bridge_power = 0
	CLRF 0x50
; 434: 				Write mem_bridge_power, bridge_power
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x50,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0149:	BTFSC EECON1,WR
	GOTO L0149
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 435: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0150
L0148:
; 436: 			EndSelect
L0150:
L0147:
; 437: 		Case 7  'setting delay in millisecs before tt is ready is sent)
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0151
L0143:
	MOVF 0x44,W
	SUBLW 0x07
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0152
; 438: 			Read mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 439: 			If pos_match_delay > 50 Then
	MOVF 0x40,W
	SUBLW 0x32
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0153
; 440: 				pos_match_delay = 50
	MOVLW 0x32
	MOVWF 0x40
; 441: 			Endif
L0153:
; 442: 			value = pos_match_delay
	MOVF 0x40,W
	MOVWF 0x38
; 443: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 444: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 445: 			Select Case result
; 446: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0154
; 447: 				If pos_match_delay < 50 Then
	MOVLW 0x32
	SUBWF 0x40,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0155
; 448: 					pos_match_delay = pos_match_delay + 1
	MOVF 0x40,W
	ADDLW 0x01
	MOVWF 0x40
; 449: 				Endif
L0155:
; 450: 				Write mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0156:	BTFSC EECON1,WR
	GOTO L0156
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 451: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0157
L0154:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0158
; 452: 				If pos_match_delay > 0 Then
	MOVF 0x40,W
	SUBLW 0x00
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0159
; 453: 					pos_match_delay = pos_match_delay - 1
	MOVLW 0x01
	SUBWF 0x40,W
	MOVWF 0x40
; 454: 				Endif
L0159:
; 455: 				Write mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BCF PCLATH,3
L0160:	BTFSC EECON1,WR
	GOTO L0160
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 456: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0161
L0158:
; 457: 			EndSelect
L0161:
L0157:
; 458: 		Case Else  'menu 8 , setting if postion 62 is possible to reset and calculate all positions
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0162
L0152:
; 459: 			If adjust_en > 1 Then
	MOVF 0x4B,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0163
; 460: 				adjust_en = 1
	MOVLW 0x01
	MOVWF 0x4B
; 461: 			Endif
L0163:
; 462: 			value = adjust_en
	MOVF 0x4B,W
	MOVWF 0x38
; 463: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 464: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 465: 			Select Case result
; 466: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0164
; 467: 				adjust_en = 1
	MOVLW 0x01
	MOVWF 0x4B
; 468: 			Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0165
L0164:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0166
; 469: 				adjust_en = 0
	CLRF 0x4B
; 470: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0167
L0166:
; 471: 			EndSelect
L0167:
L0165:
; 472: 		EndSelect
L0162:
L0151:
L0142:
L0130:
L0120:
L0110:
L0100:
L0090:
; 473: 	Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0077
L0078:
; 474: 	ena = 0  'shut off motor
	BCF 0x07,2
; 475: 		'***************   now check if changes have to BE written in eeprom
; 476: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVF 0x46,W
	MOVWF R1L
	MOVF 0x47,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C002
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0168
; 477: 		Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 478: 	Endif
L0168:
; 479: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x38
; 480: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 481: 	onoff = 1
	BSF 0x49,1
; 482: 	Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 483: Return
	RETURN
; 484: 
; 485: i2c_display:
L0005:
; 486: 	Select Case value
; 487: 	Case 99
	MOVF 0x38,W
	SUBLW 0x63
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0169
; 488: 		disp1_val = %10111111
	MOVLW 0xBF
	MOVWF 0x4A
; 489: 		disp2_val = %10111111
	MOVLW 0xBF
	MOVWF 0x4F
; 490: 	Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0170
L0169:
; 491: 		disp1_val = value
	MOVF 0x38,W
	MOVWF 0x4A
; 492: 		disp1_val = disp1_val Mod 10
	MOVF 0x4A,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x4A
; 493: 		disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x4A,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0171
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0005
	MOVWF 0x4A
L0171:
; 494: 		disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x4A,7
	BTFSS 0x07,7
	BCF 0x4A,7
; 495: 		disp2_val = value
	MOVF 0x38,W
	MOVWF 0x4F
; 496: 		disp2_val = disp2_val / 10
	MOVF 0x4F,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4F
; 497: 		disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x4F,W
	MOVWF R0L
	SUBLW 0x0A
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0172
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0006
	MOVWF 0x4F
L0172:
; 498: 		disp2_val.7 = version
	BTFSC 0x49,2
	BSF 0x4F,7
	BTFSS 0x49,2
	BCF 0x4F,7
; 499: 	EndSelect
L0170:
; 500: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 501: 	I2CSend disp1
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 502: 	I2CSend disp1_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x4A,W
	CALL IC01
; 503: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 504: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 505: 	I2CSend disp2
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 506: 	I2CSend disp2_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x4F,W
	CALL IC01
; 507: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 508: Return
	RETURN
; 509: 
; 510: i2c_display_pgm:
L0006:
; 511: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), program_set
	MOVF 0x44,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0173
;       PAGE SELECT
	BCF PCLATH,3
	CALL _lookup_lab_0007
	MOVWF 0x4A
L0173:
; 512: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 513: 	I2CSend disp1
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 514: 	I2CSend disp1_val
;       PAGE SELECT
	BCF PCLATH,3
	MOVF 0x4A,W
	CALL IC01
; 515: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 516: 	I2CStart
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC31
; 517: 	I2CSend disp2
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 518: 	I2CSend %10111111
;       PAGE SELECT
	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 519: 	I2CStop
;       PAGE SELECT
	BCF PCLATH,3
	CALL IC41
; 520: Return
	RETURN
; 521: 
; 522: stepmotor:
L0007:
; 523: 	speed = 0
	CLRF 0x42
	CLRF 0x43
; 524: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 525: 	Select Case new_pos
; 526: 	Case 61  'this is the manual setting for each position
	MOVF 0x41,W
	SUBLW 0x3D
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0174
; 527: 		direction = 0  'first backward
	BCF 0x07,0
; 528: 		ena = 1  'set anable on
	BSF 0x07,2
; 529: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 530: 		While zero = 1  'turn motor until zero switch is activated
L0175:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0176
; 531: 			clk = 1  'clock out
	BSF 0x07,1
; 532: 			WaitUs speed_max
	MOVF 0x35,W
	MOVWF R4L
	MOVF 0x36,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 533: 			clk = 0
	BCF 0x07,1
; 534: 			WaitUs speed_max
	MOVF 0x35,W
	MOVWF R4L
	MOVF 0x36,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 535: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0175
L0176:
; 536: 		ena = 0  'set anable off
	BCF 0x07,2
; 537: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 538: 		one_round = 0  'start counting steps to zero pos
	CLRF 0x3E
	CLRF 0x3F
; 539: 		direction = 1  'run forward
	BSF 0x07,0
; 540: 		ena = 1  'set anable on
	BSF 0x07,2
; 541: 		act_pos = 0
	CLRF 0x34
; 542: 		value = act_pos
	MOVF 0x34,W
	MOVWF 0x38
; 543: 		Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 544: 		While max_end = 1  'turn motor until max limit switch is activated
L0177:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,7
	GOTO L0178
; 545: 			clk = 1  'clock out
	BSF 0x07,1
; 546: 			WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 547: 			clk = 0
	BCF 0x07,1
; 548: 			WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 549: 			one_round = one_round + 1
	MOVF 0x3E,W
	ADDLW 0x01
	MOVWF 0x3E
	MOVF 0x3F,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3F
; 550: 			If ecsw = 0 Then  'knob is pressed, save position and increase act_pos
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0179
; 551: 				new_steps = one_round
	MOVF 0x3E,W
	MOVWF 0x3A
	MOVF 0x3F,W
	MOVWF 0x3B
; 552: 				Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 553: 				act_pos = act_pos + 1
	MOVF 0x34,W
	ADDLW 0x01
	MOVWF 0x34
; 554: 				value = act_pos
	MOVF 0x34,W
	MOVWF 0x38
; 555: 				Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 556: 				WaitMs 1000  'just indicate that program reacts on the ecsw switch
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 557: 				While ecsw = 0
L0180:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0181
; 558: 				Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0180
L0181:
; 559: 			Endif
L0179:
; 560: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0177
L0178:
; 561: 
; 562: 		direction = 0  'goto to zero switch
	BCF 0x07,0
; 563: 		ena = 1  'set anable on
	BSF 0x07,2
; 564: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 565: 		While zero = 1  'turn motor until ZERO switch is activated
L0182:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0183
; 566: 			clk = 1  'clock out
	BSF 0x07,1
; 567: 			WaitUs speed_max
	MOVF 0x35,W
	MOVWF R4L
	MOVF 0x36,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 568: 			clk = 0
	BCF 0x07,1
; 569: 			WaitUs speed_max
	MOVF 0x35,W
	MOVWF R4L
	MOVF 0x36,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 570: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0182
L0183:
; 571: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 572: 		new_pos = 0
	CLRF 0x41
; 573: 		steps = 0
	CLRF 0x30
	CLRF 0x31
; 574: 		Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 575: 		direction = 1  'now forwards
	BSF 0x07,0
; 576: 		steps = new_steps + free_space_steps
	MOVF 0x3A,W
	ADDWF 0x3D,W
	MOVWF 0x30
	MOVF 0x3B,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x31
; 577: 		ramp_up = 1
	BSF 0x49,3
; 578: 		ramp_down_point = 0
	CLRF 0x51
	CLRF 0x52
; 579: 		half_steps = steps / 2
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x55
	MOVF R0H,W
	MOVWF 0x56
; 580: 		speed = speed_min
	MOVF 0x32,W
	MOVWF 0x42
	MOVF 0x33,W
	MOVWF 0x43
; 581: 		ena = 1  'set Enable on
	BSF 0x07,2
; 582: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 583: 		While steps > 0  'NOW RUN UNTIL STEPS = 0
L0184:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0185
; 584: 			clk = 1  'clock out
	BSF 0x07,1
; 585: 			WaitUs speed
	MOVF 0x42,W
	MOVWF R4L
	MOVF 0x43,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 586: 			clk = 0
	BCF 0x07,1
; 587: 			WaitUs speed
	MOVF 0x42,W
	MOVWF R4L
	MOVF 0x43,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 588: 			Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 589: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 590: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0184
L0185:
; 591: 		WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 592: 		steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x30
	CLRF 0x31
; 593: 		direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 594: 		While steps > 0  'NOW RUN UNTIL STEPS = 0
L0186:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0187
; 595: 			clk = 1  'clock out
	BSF 0x07,1
; 596: 			WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 597: 			clk = 0
	BCF 0x07,1
; 598: 			WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 599: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 600: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0186
L0187:
; 601: 		ena = 0  'enable off
	BCF 0x07,2
; 602: 		adjust_en = 0
	CLRF 0x4B
; 603: 	
; 604: 	Case 62  'this is the automatic position calculation
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0188
L0174:
	MOVF 0x41,W
	SUBLW 0x3E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0189
; 605: 		direction = 1  'first forward
	BSF 0x07,0
; 606: 		ena = 1  'set anable on
	BSF 0x07,2
; 607: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 608: 		While max_end = 1  'turn motor until end switch is activated
L0190:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,7
	GOTO L0191
; 609: 			clk = 1  'clock out
	BSF 0x07,1
; 610: 			WaitUs speed_max
	MOVF 0x35,W
	MOVWF R4L
	MOVF 0x36,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 611: 			clk = 0
	BCF 0x07,1
; 612: 			WaitUs speed_max
	MOVF 0x35,W
	MOVWF R4L
	MOVF 0x36,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 613: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0190
L0191:
; 614: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 615: 		one_round = 0  'start counting one round steps
	CLRF 0x3E
	CLRF 0x3F
; 616: 		ena = 1  'set anable on
	BSF 0x07,2
; 617: 		direction = 0  'now backwards
	BCF 0x07,0
; 618: 		While zero = 1  'turn motor until zero switch is activated
L0192:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0193
; 619: 			clk = 1  'clock out
	BSF 0x07,1
; 620: 			WaitUs speed_max
	MOVF 0x35,W
	MOVWF R4L
	MOVF 0x36,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 621: 			clk = 0
	BCF 0x07,1
; 622: 			WaitUs speed_max
	MOVF 0x35,W
	MOVWF R4L
	MOVF 0x36,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 623: 			one_round = one_round + 1
	MOVF 0x3E,W
	ADDLW 0x01
	MOVWF 0x3E
	MOVF 0x3F,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3F
; 624: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0192
L0193:
; 625: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 626: 		one_round = one_round - 100  'rail position 0 is a bit further from switch
	MOVLW 0x64
	SUBWF 0x3E,W
	MOVWF 0x3E
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x3F
; 627: 		act_steps = 0
	CLRF 0x46
	CLRF 0x47
; 628: 		new_steps = 50 + free_space_steps
	MOVLW 0x32
	ADDWF 0x3D,W
	MOVWF 0x3A
	MOVLW 0x00
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x3B
; 629: 		direction = 1  'first forward
	BSF 0x07,0
; 630: 		ena = 1  'set anable on
	BSF 0x07,2
; 631: 		While act_steps < new_steps
L0194:
	MOVF 0x46,W
	MOVWF R0L
	MOVF 0x47,W
	MOVWF R0H
	MOVF 0x3A,W
	MOVWF R1L
	MOVF 0x3B,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0195
; 632: 			clk = 1  'clock out
	BSF 0x07,1
; 633: 			WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 634: 			clk = 0
	BCF 0x07,1
; 635: 			WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 636: 			act_steps = act_steps + 1
	MOVF 0x46,W
	ADDLW 0x01
	MOVWF 0x46
	MOVF 0x47,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x47
; 637: 		Wend
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0194
L0195:
; 638: 		WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 639: 		steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x30
	CLRF 0x31
; 640: 		direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 641: 		While steps > 0  'NOW RUN UNTIL STEPS = 0
L0196:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0197
; 642: 			clk = 1  'clock out
	BSF 0x07,1
; 643: 			WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 644: 			clk = 0
	BCF 0x07,1
; 645: 			WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 646: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 647: 		Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0196
L0197:
; 648: 		new_pos = 0
	CLRF 0x41
; 649: 		act_pos = 0
	CLRF 0x34
; 650: 		one_round = one_round - 50  'substract also the space between last rail and end-switch
	MOVLW 0x32
	SUBWF 0x3E,W
	MOVWF 0x3E
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x3F
; 651: 		'now calculate the steps  and save steps.
; 652: 		new_steps = 50
	MOVLW 0x32
	MOVWF 0x3A
	CLRF 0x3B
; 653: 		Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 654: 		max_pos = max_pos + 1
	MOVF 0x39,W
	ADDLW 0x01
	MOVWF 0x39
; 655: 		steps = one_round / max_pos
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVF 0x39,W
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x30
	MOVF R0H,W
	MOVWF 0x31
; 656: 		For act_pos = 1 To max_pos
	MOVLW 0x01
	MOVWF 0x34
L0198:
	MOVF 0x34,W
	SUBWF 0x39,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0199
; 657: 			new_steps = new_steps + steps
	MOVF 0x3A,W
	ADDWF 0x30,W
	MOVWF 0x3A
	MOVF 0x3B,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x31,W
	MOVWF 0x3B
; 658: 			Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 659: 		Next act_pos
	MOVLW 0x01
	ADDWF 0x34,F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0198
L0199:
; 660: 		max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x39,W
	MOVWF 0x39
; 661: 		act_pos = 0
	CLRF 0x34
; 662: 		adjust_en = 0
	CLRF 0x4B
; 663: 	Case 63  'go to zero switch and then to 1st rail position (Pos 0)
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0200
L0189:
	MOVF 0x41,W
	SUBLW 0x3F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0201
; 664: 		direction = 0  'goto to zero switch
	BCF 0x07,0
; 665: 		ena = 1  'set anable on
	BSF 0x07,2
; 666: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 667: 		While zero = 1  'turn motor until ZERO switch is activated
L0202:
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x06,6
	GOTO L0203
; 668: 			clk = 1  'clock out
	BSF 0x07,1
; 669: 			WaitUs speed_max
	MOVF 0x35,W
	MOVWF R4L
	MOVF 0x36,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 670: 			clk = 0
	BCF 0x07,1
; 671: 			WaitUs speed_max
	MOVF 0x35,W
	MOVWF R4L
	MOVF 0x36,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 672: 		Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0202
L0203:
; 673: 		WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 674: 		new_pos = 0
	CLRF 0x41
; 675: 		Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 676: 		direction = 1  'now forwards
	BSF 0x07,0
; 677: 		steps = steps + new_steps + free_space_steps
;       The address of 'oshonsoft_temp_1' (word) (global) is 0x5A
	oshonsoft_temp_1 EQU 0x5A
	MOVF 0x30,W
	ADDWF 0x3A,W
	MOVWF 0x5A
	MOVF 0x31,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x3B,W
	MOVWF 0x5B
	MOVF 0x5A,W
	ADDWF 0x3D,W
	MOVWF 0x5A
	MOVF 0x5B,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x5B
	MOVF 0x5A,W
	MOVWF 0x30
	MOVF 0x5B,W
	MOVWF 0x31
; 678: 		ramp_up = 1
	BSF 0x49,3
; 679: 		ramp_down_point = 0
	CLRF 0x51
	CLRF 0x52
; 680: 		half_steps = steps / 2
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x55
	MOVF R0H,W
	MOVWF 0x56
; 681: 		speed = speed_min
	MOVF 0x32,W
	MOVWF 0x42
	MOVF 0x33,W
	MOVWF 0x43
; 682: 		ena = 1  'set Enable on
	BSF 0x07,2
; 683: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 684: 		While steps > 0  'NOW RUN UNTIL STEPS = 0
L0204:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0205
; 685: 			clk = 1  'clock out
	BSF 0x07,1
; 686: 			WaitUs speed
	MOVF 0x42,W
	MOVWF R4L
	MOVF 0x43,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 687: 			clk = 0
	BCF 0x07,1
; 688: 			WaitUs speed
	MOVF 0x42,W
	MOVWF R4L
	MOVF 0x43,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 689: 			Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 690: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 691: 		Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0204
L0205:
; 692: 		WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 693: 		steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x30
	CLRF 0x31
; 694: 		direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 695: 		While steps > 0  'NOW RUN UNTIL STEPS = 0
L0206:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0207
; 696: 			clk = 1  'clock out
	BSF 0x07,1
; 697: 			WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 698: 			clk = 0
	BCF 0x07,1
; 699: 			WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 700: 			steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 701: 		Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0206
L0207:
; 702: 		ena = 0  'enable off
	BCF 0x07,2
; 703: 	Case Else  'this is the normal position sequence
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0208
L0201:
; 704: 		steps = 0
	CLRF 0x30
	CLRF 0x31
; 705: 		If new_steps > act_steps Then
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVF 0x46,W
	MOVWF R1L
	MOVF 0x47,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0209
; 706: 			steps = new_steps - act_steps
	MOVF 0x46,W
	SUBWF 0x3A,W
	MOVWF 0x30
	MOVF 0x47,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x31
; 707: 			direction = 1
	BSF 0x07,0
; 708: 		Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0210
L0209:
; 709: 			steps = act_steps - new_steps
	MOVF 0x3A,W
	SUBWF 0x46,W
	MOVWF 0x30
	MOVF 0x3B,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x47,W
	MOVWF 0x31
; 710: 			direction = 0
	BCF 0x07,0
; 711: 		Endif
L0210:
; 712: 		If steps > 0 Then  'motor must be activated
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0211
; 713: 			If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0212
; 714: 				steps = steps + free_space_steps
	MOVF 0x30,W
	ADDWF 0x3D,W
	MOVWF 0x30
	MOVF 0x31,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x31
; 715: 			Endif
L0212:
; 716: 			ramp_up = 1
	BSF 0x49,3
; 717: 			ramp_down_point = 0
	CLRF 0x51
	CLRF 0x52
; 718: 			half_steps = steps / 2
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x55
	MOVF R0H,W
	MOVWF 0x56
; 719: 			speed = speed_min
	MOVF 0x32,W
	MOVWF 0x42
	MOVF 0x33,W
	MOVWF 0x43
; 720: 			ena = 1  'set anable on
	BSF 0x07,2
; 721: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 722: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0213:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0214
; 723: 				clk = 1  'clock out
	BSF 0x07,1
; 724: 				WaitUs speed
	MOVF 0x42,W
	MOVWF R4L
	MOVF 0x43,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 725: 				clk = 0
	BCF 0x07,1
; 726: 				WaitUs speed
	MOVF 0x42,W
	MOVWF R4L
	MOVF 0x43,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 727: 				Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 728: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 729: 				If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0215
; 730: 					If max_end = 0 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x06,7
	GOTO L0216
; 731: 						Gosub stop_the_motor
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 732: 					Endif
L0216:
; 733: 				Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0217
L0215:
; 734: 					If zero = 0 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x06,6
	GOTO L0218
; 735: 						Gosub stop_the_motor
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 736: 					Endif
L0218:
; 737: 				Endif
L0217:
; 738: 			Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0213
L0214:
; 739: 			If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0219
; 740: 				If free_space_steps > 0 Then
	MOVF 0x3D,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0220
; 741: 					WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 742: 					steps = free_space_steps
	MOVF 0x3D,W
	MOVWF 0x30
	CLRF 0x31
; 743: 					direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 744: 					While steps > 0  'NOW RUN UNTIL STEPS = 0
L0221:
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0222
; 745: 						clk = 1  'clock out
	BSF 0x07,1
; 746: 						WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 747: 						clk = 0
	BCF 0x07,1
; 748: 						WaitUs speed_min
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 749: 						steps = steps - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 750: 					Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0221
L0222:
; 751: 				Endif
L0220:
; 752: 			Endif
L0219:
; 753: 			ena = 0  'enable off
	BCF 0x07,2
; 754: 		Endif
L0211:
; 755: 	EndSelect
L0208:
L0200:
L0188:
; 756: 	act_pos = new_pos
	MOVF 0x41,W
	MOVWF 0x34
; 757: 	Write mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0223:	BTFSC EECON1,WR
	GOTO L0223
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 758: 	bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x4E
; 759: 	old_bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x57
; 760: 	manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x37
; 761: 	old_manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x54
; 762: 
; 763: Return
	RETURN
; 764: 
; 765: 
; 766: 
; 767: 
; 768: speed_calc:
L0008:
; 769: 	If steps < half_steps Then  'at this point  ramp up MUST end
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVF 0x55,W
	MOVWF R1L
	MOVF 0x56,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0224
; 770: 		ramp_up = 0
	BCF 0x49,3
; 771: 	Endif
L0224:
; 772: 	If ramp_up = 1 Then  'we were supposed to ramp up
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x49,3
	GOTO L0225
; 773: 		If speed > speed_max Then
	MOVF 0x42,W
	MOVWF R0L
	MOVF 0x43,W
	MOVWF R0H
	MOVF 0x35,W
	MOVWF R1L
	MOVF 0x36,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0226
; 774: 			speed = speed - speed_step
	MOVF 0x45,W
	SUBWF 0x42,W
	MOVWF 0x42
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x43,W
	MOVWF 0x43
; 775: 			ramp_down_point = ramp_down_point + 1  'this counts down with the steps
	MOVF 0x51,W
	ADDLW 0x01
	MOVWF 0x51
	MOVF 0x52,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x52
; 776: 		Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0227
L0226:
; 777: 			ramp_up = 0
	BCF 0x49,3
; 778: 		Endif
L0227:
; 779: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0228
L0225:
; 780: 		If steps < ramp_down_point Then  'this is the point tot start ramp down
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVF 0x51,W
	MOVWF R1L
	MOVF 0x52,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0229
; 781: 			If speed < speed_min Then
	MOVF 0x42,W
	MOVWF R0L
	MOVF 0x43,W
	MOVWF R0H
	MOVF 0x32,W
	MOVWF R1L
	MOVF 0x33,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0230
; 782: 				speed = speed + speed_step
	MOVF 0x42,W
	ADDWF 0x45,W
	MOVWF 0x42
	MOVF 0x43,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x43
; 783: 			Endif
L0230:
; 784: 		Endif
L0229:
; 785: 	Endif
L0228:
; 786: Return
	RETURN
; 787: 
; 788: 
; 789: relays:
L0009:
; 790: 	swfw = 0
	BCF 0x06,0
; 791: 	swrev = onoff
	BTFSC 0x49,1
	BSF 0x06,1
	BTFSS 0x49,1
	BCF 0x06,1
; 792: Return
	RETURN
; 793: 
; 794: 
; 795: init_values:
L0010:
; 796: 	value = 86  'version number
	MOVLW 0x56
	MOVWF 0x38
; 797: 	version = 0  'decimal point in display on
	BCF 0x49,2
; 798: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 799: 	WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 800: 	version = 1  'decimal point in display off
	BSF 0x49,2
; 801: 	encoder_count = 0
	CLRF 0x4D
; 802: 	speed_min = 0
	CLRF 0x32
	CLRF 0x33
; 803: 	Read mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 804: 	If speed_min.HB > 99 Then
	MOVF 0x33,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0231
; 805: 		speed_min.HB = 40
	MOVLW 0x28
	MOVWF 0x33
; 806: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0232
L0231:
; 807: 		If speed_min.HB < 2 Then
	MOVLW 0x02
	SUBWF 0x33,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0233
; 808: 			speed_min.HB = 20
	MOVLW 0x14
	MOVWF 0x33
; 809: 		Endif
L0233:
; 810: 	Endif
L0232:
; 811: 	speed_max = 0
	CLRF 0x35
	CLRF 0x36
; 812: 	Read mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 813: 	If speed_max.HB > speed_min.HB Then
	MOVF 0x36,W
	SUBWF 0x33,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0234
; 814: 		speed_max.HB = speed_min.HB
	MOVF 0x33,W
	MOVWF 0x36
; 815: 	Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0235
L0234:
; 816: 		If speed_max.HB < 2 Then
	MOVLW 0x02
	SUBWF 0x36,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0236
; 817: 			speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x36
; 818: 		Endif
L0236:
; 819: 	Endif
L0235:
; 820: 
; 821: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3E
; 822: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 823: 	If one_round = 0 Then
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0237
; 824: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x3E
	MOVLW 0x1F
	MOVWF 0x3F
; 825: 	Endif
L0237:
; 826: 	If one_round > 60000 Then
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0238
; 827: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x3E
	MOVLW 0x1F
	MOVWF 0x3F
; 828: 	Endif
L0238:
; 829: 	one_round_half = one_round / 2
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x58
	MOVF R0H,W
	MOVWF 0x59
; 830: 
; 831: 	Read mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 832: 	If max_pos > 47 Then
	MOVF 0x39,W
	SUBLW 0x2F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0239
; 833: 		max_pos = 11
	MOVLW 0x0B
	MOVWF 0x39
; 834: 	Endif
L0239:
; 835: 	Read mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 836: 	If act_pos > max_pos Then
	MOVF 0x34,W
	SUBWF 0x39,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0240
; 837: 		act_pos = 0
	CLRF 0x34
; 838: 		Write mem_act_pos, act_pos
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0241:	BTFSC EECON1,WR
	GOTO L0241
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 839: 	Endif
L0240:
; 840: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x38
; 841: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 842: 	Read mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3D
; 843: 	If free_space_steps > 99 Then
	MOVF 0x3D,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0242
; 844: 		free_space_steps = 50
	MOVLW 0x32
	MOVWF 0x3D
; 845: 	Endif
L0242:
; 846: 	Read mem_pos_match_delay, pos_match_delay
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 847: 	If pos_match_delay > 50 Then
	MOVF 0x40,W
	SUBLW 0x32
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0243
; 848: 		pos_match_delay = 10
	MOVLW 0x0A
	MOVWF 0x40
; 849: 	Endif
L0243:
; 850: 	
; 851: 	Read mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x45
; 852: 	If speed_step > 99 Then
	MOVF 0x45,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0244
; 853: 		speed_step = 20
	MOVLW 0x14
	MOVWF 0x45
; 854: 	Endif
L0244:
; 855: 	steps_set = 0
	BCF 0x49,4
; 856: 	new_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x41
; 857: 	bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x4E
; 858: 	old_bus_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x57
; 859: 	manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x37
; 860: 	old_manual_pos = act_pos
	MOVF 0x34,W
	MOVWF 0x54
; 861: 	old_pos_write = 1
	BSF 0x49,5
; 862: Return
	RETURN
; 863: 
; 864: steps_reading:
L0011:
; 865: 	Select Case act_pos
; 866: 	Case 61, 63, 62
	MOVF 0x34,W
	SUBLW 0x3D
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0247
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0246
L0247:
	MOVF 0x34,W
	SUBLW 0x3F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0248
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0246
L0248:
	MOVF 0x34,W
	SUBLW 0x3E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0245
L0246:
; 867: 		act_steps = 0
	CLRF 0x46
	CLRF 0x47
; 868: 	Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0249
L0245:
; 869: 		eprom_pointer = act_pos
	MOVF 0x34,W
	MOVWF 0x48
; 870: 		eprom_pointer = eprom_pointer + 48
	MOVF 0x48,W
	ADDLW 0x30
	MOVWF 0x48
; 871: 		Read act_pos, act_steps.LB
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x46
; 872: 		Read eprom_pointer, act_steps.HB
	MOVF 0x48,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x47
; 873: 	EndSelect
L0249:
; 874: 	Select Case new_pos
; 875: 	Case 61, 62, 63
	MOVF 0x41,W
	SUBLW 0x3D
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0252
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0251
L0252:
	MOVF 0x41,W
	SUBLW 0x3E
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0253
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0251
L0253:
	MOVF 0x41,W
	SUBLW 0x3F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0250
L0251:
; 876: 		new_steps = 0
	CLRF 0x3A
	CLRF 0x3B
; 877: 	Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0254
L0250:
; 878: 		eprom_pointer = new_pos
	MOVF 0x41,W
	MOVWF 0x48
; 879: 		eprom_pointer = eprom_pointer + 48
	MOVF 0x48,W
	ADDLW 0x30
	MOVWF 0x48
; 880: 		Read new_pos, new_steps.LB
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3A
; 881: 		Read eprom_pointer, new_steps.HB
	MOVF 0x48,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3B
; 882: 	Endif
L0254:
; 883: Return
	RETURN
; 884: 
; 885: 
; 886: save_steps:
L0012:
; 887: 	eprom_pointer = act_pos
	MOVF 0x34,W
	MOVWF 0x48
; 888: 	eprom_pointer = eprom_pointer + 48
	MOVF 0x48,W
	ADDLW 0x30
	MOVWF 0x48
; 889: 	Write act_pos, new_steps.LB
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0255:	BTFSC EECON1,WR
	GOTO L0255
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 890: 	Write eprom_pointer, new_steps.HB
	MOVF 0x48,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0256:	BTFSC EECON1,WR
	GOTO L0256
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 891: Return
	RETURN
; 892: 
; 893: 
; 894: stop_the_motor:
L0013:
; 895: 	ena = 0  'set anable oFF
	BCF 0x07,2
; 896: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x38
; 897: 	version = 0  'decimal point in display on
	BCF 0x49,2
; 898: 	While ecsw = 1
L0257:
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,6
	GOTO L0258
; 899: 		WaitMs 250
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 900: 		Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 901: 		version = Not version
	MOVLW 0x04
	XORWF 0x49,F
; 902: 	Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0257
L0258:
; 903: 	version = 1  'decimal point off
	BSF 0x49,2
; 904: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 905: 	ena = 1  'set anable on
	BSF 0x07,2
; 906: Return
	RETURN
; 907: wait_pos_match:
L0014:
; 908: 	value = 99
	MOVLW 0x63
	MOVWF 0x38
; 909: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 910: 	steps = pos_match_delay * 100
	MOVF 0x40,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x30
	MOVF R2H,W
	MOVWF 0x31
; 911: 	WaitMs steps
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 912: 	value = act_pos
	MOVF 0x34,W
	MOVWF 0x38
; 913: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 914: 	pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 915: Return
	RETURN
; End of program
;       PAGE SELECT
	BSF PCLATH,3
L0259:	GOTO L0259
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
