

Define CONF_WORD = 0x3f72

'program TT for PCBoard MGV145
'special version 8-4  small fiddle yard RDS
'version 8-5 with extra position 61 . This position will run to zero switch, and then, by hitting the
'-     incremental knob on every position, , the program will store that position, and increment the display
'-     to the next. After reaching the last position, the motor will run back to zero switch and then
'-     position 0.
'Version 8.6 Bridge will be switched off at startup, and a new position has to be set to set bridge on power.
'RB7 on ICSP1 (pin3) is endswitch (pass last rail)
'RB6 on ICSP1 (pin2) is endswitch (pass first rail)
'EEP jumper must always be at ON !
'two extra position are possible:
'-  position 63 to go to zero switch and then to rail 0
'-  position 62 to reset and recalculate all values (only when menu 8 is set)
'programs :
'0  correction actual position
'1  Max positions
'2  min speed
'3  max speed
'4  incr/decr delay
'5  extra correction steps
'6  bridge power on/off (1/0)
'7  pos_match delay
'8  adjust_position >>>: this enables / disables the choice of pos 62
Dim steps As Word
Dim half_steps As Word
Dim ramp_down_point As Word
Dim program_set As Byte
Dim new_steps As Word
Dim act_steps As Word
Dim new_pos As Byte
Dim act_pos As Byte
Dim one_round As Word
Dim one_round_half As Word
Dim bus_pos As Byte
Dim old_bus_pos As Byte
Dim speed As Word
Dim speed_min As Word
Dim speed_max As Word
Dim new_encoder As Byte
Dim old_encoder As Byte
Dim manual_pos As Byte
Dim old_manual_pos As Byte
Dim result As Byte
Dim free_space_steps As Byte
Dim value As Byte
Dim eprom_pointer As Byte
Dim encoder_count As Byte
Dim onoff As Bit
Dim max_pos As Byte
Dim disp1_val As Byte
Dim disp2_val As Byte
Dim old_pos_write As Bit
Dim ramp_up As Bit
Dim speed_step As Byte
Dim version As Bit
Dim steps_set As Bit
Dim bridge_power As Byte
Dim pos_match_delay As Byte
Dim adjust_en As Byte
Dim decoder_pulses As Bit

Const disp1 = 64
Const disp2 = 66
Const mem_act_pos = 127
Const mem_speed_min = 103
Const mem_speed_max = 104
Const mem_speed_step = 105
Const mem_one_round_lb = 106
Const mem_one_round_hb = 107
Const mem_ctrl_type = 108
Const mem_max_pos = 109
Const mem_free_space = 110
Const mem_rev_pos = 111
Const mem_bridge_power = 112
Const mem_pos_match_delay = 113

Symbol swfw = RB0
Symbol swrev = RB1
Symbol sck = RB2
Symbol sda = RB3
Symbol pos_match = RB4
Symbol pos_write = RB5
Symbol direction = RC0
Symbol clk = RC1
Symbol ena = RC2
Symbol zero = RB6
Symbol max_end = RB7
Symbol ec1 = RC4
Symbol ec2 = RC5
Symbol ecsw = RC6
Symbol pgm = RC7

ADCON1 = %0110
TRISA = %111111
TRISB = %11101100
TRISC = %11111000
PORTB = %11101100
PORTC = %11111000
I2CPrepare sda, sck
Gosub init_values
onoff = 1
Gosub relays
program_set = 0
max_end = 1
adjust_en = 0
main:
	If pgm = 0 Then
		Gosub adjust_settings
		WaitMs 500
	Endif

	Gosub get_new_position
	If bus_pos <> old_bus_pos Then
		onoff = 0
		Gosub relays
		pos_match = 1  'indicate not in position
		new_pos = bus_pos
		Gosub stepmotor
		Gosub wait_pos_match
		onoff = 1
	Else
		If ecsw = 0 Then  'only when knob is pushed
			If manual_pos <> old_manual_pos Then
				onoff = 0
				Gosub relays
				pos_match = 1  'indicate not in position
				old_manual_pos = manual_pos
				new_pos = manual_pos
				Gosub stepmotor
				Gosub wait_pos_match
				onoff = 1
			Endif
		Endif
	Endif
	WaitMs 10
	Gosub relays
	Goto main
End                                               


get_new_position:
	value = bus_pos  'remember the position
	If pos_write = 1 Then
		If old_pos_write = 0 Then  'react once on rising edge
			old_pos_write = 1
			value = PORTA And 63  'now get value from J5
			Select Case value
			Case 63  'position reset is desired
				value = 63
			Case Else
				If value > max_pos Then  'this is not allowed
					value = bus_pos  'put it back to old situation
				Endif
			EndSelect
			Gosub i2c_display
			If value = bus_pos Then  'no other position is set, just a response on pos_write is required
				pos_match = 1
				WaitMs 1000
				pos_match = 0
			Endif
		Endif
	Else
		old_pos_write = 0
	Endif
	bus_pos = value  'now take over the desired position
	Gosub calc_rotation
	Select Case result
	Case 1
		If encoder_count < 4 Then
			encoder_count = encoder_count + 1
		Else
			encoder_count = 0
			Select Case manual_pos
			Case < max_pos
				manual_pos = manual_pos + 1
			Case max_pos
				Select Case adjust_en
				Case 0
					manual_pos = 63
				Case Else
					manual_pos = 61
				EndSelect
			Case 63
				manual_pos = 0
			Case 62
				manual_pos = 63
			Case 61
				manual_pos = 62
			Case Else
			EndSelect
			value = manual_pos
			Gosub i2c_display
		Endif
	Case 2
		If encoder_count > 0 Then
			encoder_count = encoder_count - 1
		Else
			encoder_count = 4
			Select Case manual_pos
			Case 61
				manual_pos = max_pos
			Case 62
				manual_pos = 61
			Case 63
				Select Case adjust_en
				Case 0
					manual_pos = max_pos
				Case Else
					manual_pos = 62
				EndSelect
			Case 0
				manual_pos = 63
			Case Else
				manual_pos = manual_pos - 1
			EndSelect
			value = manual_pos
			Gosub i2c_display
		Endif
	Case Else
	EndSelect
	WaitMs 1
	
Return                                            

calc_rotation:  'this routine checks the incrimental switch
'1 = increasing value
'2 = decreasing value
'3 = no change
		new_encoder = 0
		new_encoder.0 = ec1
		new_encoder.1 = ec2
		Select Case old_encoder
		Case 0
			If decoder_pulses = 0 Then
				decoder_pulses = 1
			Else
				decoder_pulses = 0
				result = LookUp(3, 2, 1, 3), new_encoder
			Endif
		Case 1
			If decoder_pulses = 0 Then
				decoder_pulses = 1
			Else
				result = LookUp(1, 3, 3, 2), new_encoder
				decoder_pulses = 0
			Endif
		Case 2
			If decoder_pulses = 0 Then
				decoder_pulses = 1
			Else
				result = LookUp(2, 3, 3, 1), new_encoder
				decoder_pulses = 0
			Endif
		Case Else
			If decoder_pulses = 0 Then
				decoder_pulses = 1
			Else
				result = LookUp(3, 1, 2, 3), new_encoder
				decoder_pulses = 0
			Endif
		EndSelect
		old_encoder = new_encoder
Return                                            


adjust_settings:
	Gosub i2c_display_pgm
	WaitMs 800  'give some time for display to be read
	onoff = 0
	Gosub relays
	Gosub steps_reading
	new_steps = act_steps  'nothing is changed yet
	While pgm = 0  'the program switch is still activated
		If ecsw = 0 Then  'knob is pressed, inrease program_set
			program_set = program_set + 1
			If program_set > 8 Then  'no more than 8 items te change
				program_set = 0
			Endif
			Gosub i2c_display_pgm
			WaitMs 800  'give some time for display to be read
			While ecsw = 0  'be sure pushbutton is released
				WaitMs 250  'cancel contact dender
			Wend
		Endif
		Select Case program_set
		Case 0  'correction of current position
			value = act_pos
			Gosub i2c_display
			Gosub calc_rotation  'look for the knob to be turned
			Select Case result
			Case 1
				If new_steps < 60000 Then
					ena = 1  'motor on
					new_steps = new_steps + 1
					direction = 1
					clk = 1  'clock out
					WaitMs 5
					clk = 0
				Endif
			Case 2
				If new_steps > 0 Then
					ena = 1  'motor on
					new_steps = new_steps - 1
					direction = 0
					clk = 1  'clock out
					WaitMs 5
					clk = 0
				Endif
			Case Else
			EndSelect
		Case 1  'setting of maximum positions
			steps_set = 0
			ena = 0  'shut off motor
			value = max_pos
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1
				If max_pos < 47 Then  'no more positions possible
					max_pos = max_pos + 1
					Write mem_max_pos, max_pos
				Endif
			Case 2
				If max_pos > 2 Then  'minum 2 positions
					max_pos = max_pos - 1
					Write mem_max_pos, max_pos
				Endif
			Case Else
			EndSelect
		Case 2  'setting of speed interval Minimum
					'setting will be done in multiple of 256 uSecs
					'minimum is usually not less then 5, and maximum is 99 (is real slow)
			steps_set = 0
			ena = 0  'shut off motor
			value = speed_min.HB
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1
				If speed_min.HB < 99 Then  'display is limited to 99
					speed_min.HB = speed_min.HB + 1
					Write mem_speed_min, speed_min.HB
				Endif
			Case 2
				If speed_min.HB > speed_max.HB Then
					speed_min.HB = speed_min.HB - 1
					Write mem_speed_min, speed_min.HB
				Endif
			Case Else
			EndSelect
		Case 3  'setting of speed interval Maximum
					'setting will be done in multiple of 256 uSecs
					'minimum is 1 and maximum is 99 (is real slow)
			steps_set = 0
			ena = 0  'shut off motor
			value = speed_max.HB
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1
				If speed_max.HB < speed_min.HB Then  'not more then speed_min
					speed_max.HB = speed_max.HB + 1
					Write mem_speed_max, speed_max.HB
				Endif
			Case 2
				If speed_max.HB > 2 Then
					speed_max.HB = speed_max.HB - 1
					Write mem_speed_max, speed_max.HB
				Endif
			Case Else
			EndSelect
		Case 4  'setting of ramp up and down speed
					'speed will be the value that speed will be changed every step up and down
			steps_set = 0
			ena = 0  'shut off motor
			value = speed_step
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1
				If speed_step < 99 Then  'maximum 99 is possible
					speed_step = speed_step + 1
					Write mem_speed_step, speed_step
				Endif
			Case 2
				If speed_step > 1 Then
					speed_step = speed_step - 1
					Write mem_speed_step, speed_step
				Endif
			Case Else
			EndSelect
	
		Case 5  'setting of extra free space steps
			steps_set = 0
			ena = 0  'shut off motor
			If free_space_steps > 250 Then
				free_space_steps = 250
				Write mem_free_space, free_space_steps
			Endif
			value = free_space_steps
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1
				If free_space_steps < 99 Then  'display is limited to 99
					free_space_steps = free_space_steps + 1
					Write mem_free_space, free_space_steps
				Endif
			Case 2
				If free_space_steps > 0 Then
					free_space_steps = free_space_steps - 1
					Write mem_free_space, free_space_steps
				Endif
			Case Else
			EndSelect
		Case 6  'setting if power should be on or off while bridge is moving (0 = off)
			Read mem_bridge_power, bridge_power
			If bridge_power > 1 Then
				bridge_power = 1
			Endif
			value = bridge_power
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1
				bridge_power = 1
				Write mem_bridge_power, bridge_power
			Case 2
				bridge_power = 0
				Write mem_bridge_power, bridge_power
			Case Else
			EndSelect
		Case 7  'setting delay in millisecs before tt is ready is sent)
			Read mem_pos_match_delay, pos_match_delay
			If pos_match_delay > 50 Then
				pos_match_delay = 50
			Endif
			value = pos_match_delay
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1
				If pos_match_delay < 50 Then
					pos_match_delay = pos_match_delay + 1
				Endif
				Write mem_pos_match_delay, pos_match_delay
			Case 2
				If pos_match_delay > 0 Then
					pos_match_delay = pos_match_delay - 1
				Endif
				Write mem_pos_match_delay, pos_match_delay
			Case Else
			EndSelect
		Case Else  'menu 8 , setting if postion 62 is possible to reset and calculate all positions
			If adjust_en > 1 Then
				adjust_en = 1
			Endif
			value = adjust_en
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1
				adjust_en = 1
			Case 2
				adjust_en = 0
			Case Else
			EndSelect
		EndSelect
	Wend
	ena = 0  'shut off motor
		'***************   now check if changes have to BE written in eeprom
	If new_steps <> act_steps Then  'now save new position
		Gosub save_steps
	Endif
	value = act_pos
	Gosub i2c_display
	onoff = 1
	Gosub relays
Return                                            

i2c_display:
	Select Case value
	Case 99
		disp1_val = %10111111
		disp2_val = %10111111
	Case Else
		disp1_val = value
		disp1_val = disp1_val Mod 10
		disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
		disp1_val.7 = pgm
		disp2_val = value
		disp2_val = disp2_val / 10
		disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
		disp2_val.7 = version
	EndSelect
	I2CStart
	I2CSend disp1
	I2CSend disp1_val
	I2CStop
	I2CStart
	I2CSend disp2
	I2CSend disp2_val
	I2CStop
Return                                            

i2c_display_pgm:
	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), program_set
	I2CStart
	I2CSend disp1
	I2CSend disp1_val
	I2CStop
	I2CStart
	I2CSend disp2
	I2CSend %10111111
	I2CStop
Return                                            

stepmotor:
	speed = 0
	Gosub steps_reading
	Select Case new_pos
	Case 61  'this is the manual setting for each position
		direction = 0  'first backward
		ena = 1  'set anable on
		pos_match = 1  'not indicate pos_match
		While zero = 1  'turn motor until zero switch is activated
			clk = 1  'clock out
			WaitUs speed_max
			clk = 0
			WaitUs speed_max
		Wend
		ena = 0  'set anable off
		WaitMs 1000
		one_round = 0  'start counting steps to zero pos
		direction = 1  'run forward
		ena = 1  'set anable on
		act_pos = 0
		value = act_pos
		Gosub i2c_display
		While max_end = 1  'turn motor until max limit switch is activated
			clk = 1  'clock out
			WaitUs speed_min
			clk = 0
			WaitUs speed_min
			one_round = one_round + 1
			If ecsw = 0 Then  'knob is pressed, save position and increase act_pos
				new_steps = one_round
				Gosub save_steps
				act_pos = act_pos + 1
				value = act_pos
				Gosub i2c_display
				WaitMs 1000  'just indicate that program reacts on the ecsw switch
				While ecsw = 0
				Wend
			Endif
		Wend

		direction = 0  'goto to zero switch
		ena = 1  'set anable on
		pos_match = 1  'not indicate pos_match
		While zero = 1  'turn motor until ZERO switch is activated
			clk = 1  'clock out
			WaitUs speed_max
			clk = 0
			WaitUs speed_max
		Wend
		WaitMs 1000
		new_pos = 0
		steps = 0
		Gosub steps_reading
		direction = 1  'now forwards
		steps = new_steps + free_space_steps
		ramp_up = 1
		ramp_down_point = 0
		half_steps = steps / 2
		speed = speed_min
		ena = 1  'set Enable on
		pos_match = 1  'not indicate pos_match
		While steps > 0  'NOW RUN UNTIL STEPS = 0
			clk = 1  'clock out
			WaitUs speed
			clk = 0
			WaitUs speed
			Gosub speed_calc
			steps = steps - 1
		Wend
		WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
		steps = free_space_steps
		direction = 0  'now go back the free-space correction
		While steps > 0  'NOW RUN UNTIL STEPS = 0
			clk = 1  'clock out
			WaitUs speed_min
			clk = 0
			WaitUs speed_min
			steps = steps - 1
		Wend
		ena = 0  'enable off
		adjust_en = 0
	
	Case 62  'this is the automatic position calculation
		direction = 1  'first forward
		ena = 1  'set anable on
		pos_match = 1  'not indicate pos_match
		While max_end = 1  'turn motor until end switch is activated
			clk = 1  'clock out
			WaitUs speed_max
			clk = 0
			WaitUs speed_max
		Wend
		WaitMs 1000
		one_round = 0  'start counting one round steps
		ena = 1  'set anable on
		direction = 0  'now backwards
		While zero = 1  'turn motor until zero switch is activated
			clk = 1  'clock out
			WaitUs speed_max
			clk = 0
			WaitUs speed_max
			one_round = one_round + 1
		Wend
		WaitMs 1000
		one_round = one_round - 100  'rail position 0 is a bit further from switch
		act_steps = 0
		new_steps = 50 + free_space_steps
		direction = 1  'first forward
		ena = 1  'set anable on
		While act_steps < new_steps
			clk = 1  'clock out
			WaitUs speed_min
			clk = 0
			WaitUs speed_min
			act_steps = act_steps + 1
		Wend
		WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
		steps = free_space_steps
		direction = 0  'now go back the free-space correction
		While steps > 0  'NOW RUN UNTIL STEPS = 0
			clk = 1  'clock out
			WaitUs speed_min
			clk = 0
			WaitUs speed_min
			steps = steps - 1
		Wend
		new_pos = 0
		act_pos = 0
		one_round = one_round - 50  'substract also the space between last rail and end-switch
		'now calculate the steps  and save steps.
		new_steps = 50
		Gosub save_steps
		max_pos = max_pos + 1
		steps = one_round / max_pos
		For act_pos = 1 To max_pos
			new_steps = new_steps + steps
			Gosub save_steps
		Next act_pos
		max_pos = max_pos - 1
		act_pos = 0
		adjust_en = 0
	Case 63  'go to zero switch and then to 1st rail position (Pos 0)
		direction = 0  'goto to zero switch
		ena = 1  'set anable on
		pos_match = 1  'not indicate pos_match
		While zero = 1  'turn motor until ZERO switch is activated
			clk = 1  'clock out
			WaitUs speed_max
			clk = 0
			WaitUs speed_max
		Wend
		WaitMs 1000
		new_pos = 0
		Gosub steps_reading
		direction = 1  'now forwards
		steps = steps + new_steps + free_space_steps
		ramp_up = 1
		ramp_down_point = 0
		half_steps = steps / 2
		speed = speed_min
		ena = 1  'set Enable on
		pos_match = 1  'not indicate pos_match
		While steps > 0  'NOW RUN UNTIL STEPS = 0
			clk = 1  'clock out
			WaitUs speed
			clk = 0
			WaitUs speed
			Gosub speed_calc
			steps = steps - 1
		Wend
		WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
		steps = free_space_steps
		direction = 0  'now go back the free-space correction
		While steps > 0  'NOW RUN UNTIL STEPS = 0
			clk = 1  'clock out
			WaitUs speed_min
			clk = 0
			WaitUs speed_min
			steps = steps - 1
		Wend
		ena = 0  'enable off
	Case Else  'this is the normal position sequence
		steps = 0
		If new_steps > act_steps Then
			steps = new_steps - act_steps
			direction = 1
		Else
			steps = act_steps - new_steps
			direction = 0
		Endif
		If steps > 0 Then  'motor must be activated
			If direction = 1 Then
				steps = steps + free_space_steps
			Endif
			ramp_up = 1
			ramp_down_point = 0
			half_steps = steps / 2
			speed = speed_min
			ena = 1  'set anable on
			pos_match = 1  'not indicate pos_match
			While steps > 0  'NOW RUN UNTIL STEPS = 0
				clk = 1  'clock out
				WaitUs speed
				clk = 0
				WaitUs speed
				Gosub speed_calc
				steps = steps - 1
				If direction = 1 Then
					If max_end = 0 Then
						Gosub stop_the_motor
					Endif
				Else
					If zero = 0 Then
						Gosub stop_the_motor
					Endif
				Endif
			Wend
			If direction = 1 Then
				If free_space_steps > 0 Then
					WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
					steps = free_space_steps
					direction = 0  'now go back the free-space correction
					While steps > 0  'NOW RUN UNTIL STEPS = 0
						clk = 1  'clock out
						WaitUs speed_min
						clk = 0
						WaitUs speed_min
						steps = steps - 1
					Wend
				Endif
			Endif
			ena = 0  'enable off
		Endif
	EndSelect
	act_pos = new_pos
	Write mem_act_pos, act_pos
	bus_pos = act_pos
	old_bus_pos = act_pos
	manual_pos = act_pos
	old_manual_pos = act_pos

Return                                            




speed_calc:
	If steps < half_steps Then  'at this point  ramp up MUST end
		ramp_up = 0
	Endif
	If ramp_up = 1 Then  'we were supposed to ramp up
		If speed > speed_max Then
			speed = speed - speed_step
			ramp_down_point = ramp_down_point + 1  'this counts down with the steps
		Else
			ramp_up = 0
		Endif
	Else
		If steps < ramp_down_point Then  'this is the point tot start ramp down
			If speed < speed_min Then
				speed = speed + speed_step
			Endif
		Endif
	Endif
Return                                            


relays:
	swfw = 0
	swrev = onoff
Return                                            


init_values:
	value = 86  'version number
	version = 0  'decimal point in display on
	Gosub i2c_display
	WaitMs 3000
	version = 1  'decimal point in display off
	encoder_count = 0
	speed_min = 0
	Read mem_speed_min, speed_min.HB
	If speed_min.HB > 99 Then
		speed_min.HB = 40
	Else
		If speed_min.HB < 2 Then
			speed_min.HB = 20
		Endif
	Endif
	speed_max = 0
	Read mem_speed_max, speed_max.HB
	If speed_max.HB > speed_min.HB Then
		speed_max.HB = speed_min.HB
	Else
		If speed_max.HB < 2 Then
			speed_max.HB = 6
		Endif
	Endif

	Read mem_one_round_lb, one_round.LB
	Read mem_one_round_hb, one_round.HB
	If one_round = 0 Then
		one_round = 8000
	Endif
	If one_round > 60000 Then
		one_round = 8000
	Endif
	one_round_half = one_round / 2

	Read mem_max_pos, max_pos
	If max_pos > 47 Then
		max_pos = 11
	Endif
	Read mem_act_pos, act_pos
	If act_pos > max_pos Then
		act_pos = 0
		Write mem_act_pos, act_pos
	Endif
	value = act_pos
	Gosub i2c_display
	Read mem_free_space, free_space_steps
	If free_space_steps > 99 Then
		free_space_steps = 50
	Endif
	Read mem_pos_match_delay, pos_match_delay
	If pos_match_delay > 50 Then
		pos_match_delay = 10
	Endif
	
	Read mem_speed_step, speed_step
	If speed_step > 99 Then
		speed_step = 20
	Endif
	steps_set = 0
	new_pos = act_pos
	bus_pos = act_pos
	old_bus_pos = act_pos
	manual_pos = act_pos
	old_manual_pos = act_pos
	old_pos_write = 1
Return                                            

steps_reading:
	Select Case act_pos
	Case 61, 63, 62
		act_steps = 0
	Case Else
		eprom_pointer = act_pos
		eprom_pointer = eprom_pointer + 48
		Read act_pos, act_steps.LB
		Read eprom_pointer, act_steps.HB
	EndSelect
	Select Case new_pos
	Case 61, 62, 63
		new_steps = 0
	Case Else
		eprom_pointer = new_pos
		eprom_pointer = eprom_pointer + 48
		Read new_pos, new_steps.LB
		Read eprom_pointer, new_steps.HB
	Endif
Return                                            


save_steps:
	eprom_pointer = act_pos
	eprom_pointer = eprom_pointer + 48
	Write act_pos, new_steps.LB
	Write eprom_pointer, new_steps.HB
Return                                            


stop_the_motor:
	ena = 0  'set anable oFF
	value = act_pos
	version = 0  'decimal point in display on
	While ecsw = 1
		WaitMs 250
		Gosub i2c_display
		version = Not version
	Wend
	version = 1  'decimal point off
	Gosub i2c_display
	ena = 1  'set anable on
Return                                            
wait_pos_match:
	value = 99
	Gosub i2c_display
	steps = pos_match_delay * 100
	WaitMs steps
	value = act_pos
	Gosub i2c_display
	pos_match = 0  'indicate pos_match
Return                                            
