; Compiled with: PIC Simulator IDE v6.90
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The address of 'speed' (word) (global) is 0x30
	speed EQU 0x30
;       The address of 'act_pos' (byte) (global) is 0x32
	act_pos EQU 0x32
;       The address of 'value' (byte) (global) is 0x33
	value EQU 0x33
;       The address of 'new_steps' (word) (global) is 0x34
	new_steps EQU 0x34
;       The address of 'free_space_steps' (byte) (global) is 0x36
	free_space_steps EQU 0x36
;       The address of 'max_pos' (byte) (global) is 0x37
	max_pos EQU 0x37
;       The address of 'act_steps' (word) (global) is 0x38
	act_steps EQU 0x38
;       The address of 'manual_pos' (byte) (global) is 0x3A
	manual_pos EQU 0x3A
;       The address of 'result' (byte) (global) is 0x3B
	result EQU 0x3B
;       The address of 'steps' (word) (global) is 0x3C
	steps EQU 0x3C
;       The address of 'disp1_val' (byte) (global) is 0x3E
	disp1_val EQU 0x3E
;       The address of 'one_round' (word) (global) is 0x3F
	one_round EQU 0x3F
;       The address of 'program_set' (byte) (global) is 0x41
	program_set EQU 0x41
;       The address of 'disp2_val' (byte) (global) is 0x42
	disp2_val EQU 0x42
;       The address of 'new_encoder' (byte) (global) is 0x43
	new_encoder EQU 0x43
;       The address of 'encoder_count' (byte) (global) is 0x44
	encoder_count EQU 0x44
;       The address of 'new_pos' (byte) (global) is 0x45
	new_pos EQU 0x45
;       The address of 'bus_pos' (byte) (global) is 0x46
	bus_pos EQU 0x46
;       The address of 'onoff' (bit) (global) is 0x47,0
;       The address of 'eprom_pointer1' (byte) (global) is 0x48
	eprom_pointer1 EQU 0x48
;       The address of 'old_bus_pos' (byte) (global) is 0x49
	old_bus_pos EQU 0x49
;       The address of 'old_encoder' (byte) (global) is 0x4A
	old_encoder EQU 0x4A
;       The address of 'old_manual_pos' (byte) (global) is 0x4B
	old_manual_pos EQU 0x4B
;       The address of 'ecsw_temp' (bit) (global) is 0x47,1
;       The address of 'old_speed' (byte) (global) is 0x4C
	old_speed EQU 0x4C
;       The address of 'old_free_space_steps' (byte) (global) is 0x4D
	old_free_space_steps EQU 0x4D
;       The address of 'eprom_pointer2' (byte) (global) is 0x4E
	eprom_pointer2 EQU 0x4E
;       The address of 'old_max_pos' (byte) (global) is 0x4F
	old_max_pos EQU 0x4F
;       The address of 'one_round_half' (word) (global) is 0x50
	one_round_half EQU 0x50
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'eep' (bit) (global) is 0x6,6
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x7,3
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0011
	ORG 0x0004
	RETFIE
; Begin of program
L0011:
; 1: 'program TT for PCBoard MGV145
; 2: 'version v1.1  Fiddle Yard version, also for turntables only turning to zero, not further.
; 3: 'this version has only one speed and (on right hand turn > not towards 0) will run 20 steps too far, and then run 20 steps back.
; 4: Define CONF_WORD = 0x3f72
; 5: Define CLOCK_FREQUENCY = 20
; 6: Dim steps As Word
; 7: Dim program_set As Byte
; 8: Dim new_steps As Word
; 9: Dim act_steps As Word
; 10: Dim new_pos As Byte
; 11: Dim act_pos As Byte
; 12: Dim one_round As Word
; 13: Dim one_round_half As Word
; 14: Dim bus_pos As Byte
; 15: Dim old_bus_pos As Byte
; 16: Dim speed As Word
; 17: Dim old_speed As Byte
; 18: Dim new_encoder As Byte
; 19: Dim old_encoder As Byte
; 20: Dim manual_pos As Byte
; 21: Dim old_manual_pos As Byte
; 22: Dim result As Byte
; 23: Dim free_space_steps As Byte
; 24: Dim old_free_space_steps As Byte
; 25: Dim value As Byte
; 26: Dim eprom_pointer1 As Byte
; 27: Dim eprom_pointer2 As Byte
; 28: Dim encoder_count As Byte
; 29: Dim onoff As Bit
; 30: Dim ecsw_temp As Bit
; 31: Dim max_pos As Byte
; 32: Dim old_max_pos As Byte
; 33: Dim disp1_val As Byte
; 34: Dim disp2_val As Byte
; 35: Const disp1 = 64
; 36: Const disp2 = 66
; 37: 
; 38: Symbol swfw = RB0
; 39: Symbol swrev = RB1
; 40: Symbol sck = RB2
; 41: Symbol sda = RB3
; 42: Symbol pos_match = RB4
; 43: Symbol pos_write = RB5
; 44: Symbol eep = RB6
; 45: Symbol direction = RC0
; 46: Symbol clk = RC1
; 47: Symbol ena = RC2
; 48: Symbol zero = RC3
; 49: Symbol ec1 = RC4
; 50: Symbol ec2 = RC5
; 51: Symbol ecsw = RC6
; 52: Symbol pgm = RC7
; 53: encoder_count = 0
	CLRF 0x44
; 54: speed = 0
	CLRF 0x30
	CLRF 0x31
; 55: If eep = 1 Then  'jumper set for imitialisation
	BTFSS 0x06,6
	GOTO L0012
; 56: 	Gosub init_eeprom
	CALL L0005
; 57: Endif
L0012:
; 58: Read 122, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 59: If speed < 512 Then
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	MOVLW 0x02
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0013
; 60: 	speed = 4096
	CLRF 0x30
	MOVLW 0x10
	MOVWF 0x31
; 61: 	Write 122, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0014:	BTFSC EECON1,WR
	GOTO L0014
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 62: Endif
L0013:
; 63: Read 123, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 64: Read 124, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 65: If one_round = 0 Then
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C001
	BTFSS STATUS,Z
	GOTO L0015
; 66: 	one_round = 8000
	MOVLW 0x40
	MOVWF 0x3F
	MOVLW 0x1F
	MOVWF 0x40
; 67: Endif
L0015:
; 68: If one_round > 64000 Then
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	CLRF R1L
	MOVLW 0xFA
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0016
; 69: 	one_round = 8000
	MOVLW 0x40
	MOVWF 0x3F
	MOVLW 0x1F
	MOVWF 0x40
; 70: Endif
L0016:
; 71: one_round_half = one_round / 2
	MOVF 0x3F,W
	MOVWF R0L
	MOVF 0x40,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x50
	MOVF R0H,W
	MOVWF 0x51
; 72: Read 125, act_pos
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x32
; 73: Read 126, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 74: If act_pos > 60 Then
	MOVF 0x32,W
	SUBLW 0x3C
	BTFSC STATUS,C
	GOTO L0017
; 75: 	act_pos = 1
	MOVLW 0x01
	MOVWF 0x32
; 76: 	Write 125, act_pos
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0018:	BTFSC EECON1,WR
	GOTO L0018
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 77: Endif
L0017:
; 78: If max_pos > 60 Then
	MOVF 0x37,W
	SUBLW 0x3C
	BTFSC STATUS,C
	GOTO L0019
; 79: 	max_pos = 12
	MOVLW 0x0C
	MOVWF 0x37
; 80: 	Write 126, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0020:	BTFSC EECON1,WR
	GOTO L0020
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 81: Endif
L0019:
; 82: Read 127, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 83: If free_space_steps > 60 Then
	MOVF 0x36,W
	SUBLW 0x3C
	BTFSC STATUS,C
	GOTO L0021
; 84: 	free_space_steps = 20
	MOVLW 0x14
	MOVWF 0x36
; 85: 	Write 127, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0022:	BTFSC EECON1,WR
	GOTO L0022
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 86: Endif
L0021:
; 87: new_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x45
; 88: bus_pos = PORTA And 63  'cancel first input from MGV50
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x46
; 89: old_bus_pos = bus_pos
	MOVF 0x46,W
	MOVWF 0x49
; 90: manual_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x3A
; 91: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 92: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 93: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 94: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 95: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 96: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
; 97: value = act_pos
	MOVF 0x32,W
	MOVWF 0x33
; 98: Gosub i2c_display
	CALL L0007
; 99: onoff = 1
	BSF 0x47,0
; 100: Gosub relays
	CALL L0010
; 101: 
; 102: main:
L0001:
; 103: 	If pgm = 0 Then
	BTFSC 0x07,7
	GOTO L0023
; 104: 		Gosub adjust_settings
	CALL L0003
; 105: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	CALL W001
; 106: 	Endif
L0023:
; 107: 
; 108: 	Gosub get_new_position
	CALL L0002
; 109: 	If bus_pos <> old_bus_pos Then
	MOVF 0x46,W
	SUBWF 0x49,W
	BTFSC STATUS,Z
	GOTO L0024
; 110: 		onoff = 0
	BCF 0x47,0
; 111: 		Gosub relays
	CALL L0010
; 112: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 113: 		new_pos = bus_pos
	MOVF 0x46,W
	MOVWF 0x45
; 114: 		old_bus_pos = bus_pos
	MOVF 0x46,W
	MOVWF 0x49
; 115: 		Gosub steps_reading
	CALL L0004
; 116: 		Gosub stepmotor
	CALL L0009
; 117: 		act_pos = new_pos
	MOVF 0x45,W
	MOVWF 0x32
; 118: 		Write 125, act_pos
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0025:	BTFSC EECON1,WR
	GOTO L0025
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 119: 		value = act_pos
	MOVF 0x32,W
	MOVWF 0x33
; 120: 		Gosub i2c_display
	CALL L0007
; 121: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 122: 		onoff = 1
	BSF 0x47,0
; 123: 	Else
	GOTO L0026
L0024:
; 124: 		If manual_pos <> old_manual_pos Then
	MOVF 0x3A,W
	SUBWF 0x4B,W
	BTFSC STATUS,Z
	GOTO L0027
; 125: 			onoff = 0
	BCF 0x47,0
; 126: 			Gosub relays
	CALL L0010
; 127: 			pos_match = 1  'indicate not in position
	BSF 0x06,4
; 128: 			old_manual_pos = manual_pos
	MOVF 0x3A,W
	MOVWF 0x4B
; 129: 			new_pos = manual_pos
	MOVF 0x3A,W
	MOVWF 0x45
; 130: 			Gosub steps_reading
	CALL L0004
; 131: 			Gosub stepmotor
	CALL L0009
; 132: 			act_pos = new_pos
	MOVF 0x45,W
	MOVWF 0x32
; 133: 			Write 125, act_pos
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0028:	BTFSC EECON1,WR
	GOTO L0028
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 134: 			value = act_pos
	MOVF 0x32,W
	MOVWF 0x33
; 135: 			Gosub i2c_display
	CALL L0007
; 136: 			pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 137: 			manual_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x3A
; 138: 			old_manual_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x4B
; 139: 			onoff = 1
	BSF 0x47,0
; 140: 		Endif
L0027:
; 141: 	Endif
L0026:
; 142: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	CALL W001
; 143: 	Gosub relays
	CALL L0010
; 144: 	Goto main
	GOTO L0001
; 145: End
L0029:	GOTO L0029
; 146: 
; 147: 
; 148: get_new_position:
L0002:
; 149: 	If pos_write = 0 Then
	BTFSC 0x06,5
	GOTO L0030
; 150: 		bus_pos = PORTA And 63
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x46
; 151: 		If bus_pos > max_pos Then
	MOVF 0x46,W
	SUBWF 0x37,W
	BTFSC STATUS,C
	GOTO L0031
; 152: 			old_bus_pos = bus_pos  'do not react on illegal value
	MOVF 0x46,W
	MOVWF 0x49
; 153: 		Endif
L0031:
; 154: 	Endif
L0030:
; 155: 	ecsw_temp = 1
	BSF 0x47,1
; 156: 	While ecsw_temp = 1
L0032:
	BTFSS 0x47,1
	GOTO L0033
; 157: 	'result will now be calculated
; 158: 		ecsw_temp = ecsw And pgm
	CLRW
	BTFSS 0x07,6
	ADDLW 0x01
	BTFSS 0x07,7
	ADDLW 0x01
	BTFSC STATUS,Z
	BSF 0x47,1
	BTFSS STATUS,Z
	BCF 0x47,1
; 159: 		Gosub calc_rotation
	CALL L0008
; 160: 		Select Case result
; 161: 		Case 1
	MOVF 0x3B,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0034
; 162: 			If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x44,W
	BTFSC STATUS,C
	GOTO L0035
; 163: 				encoder_count = encoder_count + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
; 164: 			Else
	GOTO L0036
L0035:
; 165: 				encoder_count = 0
	CLRF 0x44
; 166: 				manual_pos = manual_pos + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
; 167: 				If manual_pos > max_pos Then
	MOVF 0x3A,W
	SUBWF 0x37,W
	BTFSC STATUS,C
	GOTO L0037
; 168: 					manual_pos = max_pos
	MOVF 0x37,W
	MOVWF 0x3A
; 169: 				Endif
L0037:
; 170: 				value = manual_pos
	MOVF 0x3A,W
	MOVWF 0x33
; 171: 				Gosub i2c_display
	CALL L0007
; 172: 			Endif
L0036:
; 173: 		Case 2
	GOTO L0038
L0034:
	MOVF 0x3B,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0039
; 174: 			If encoder_count > 0 Then
	MOVF 0x44,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0040
; 175: 				encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x44,W
	MOVWF 0x44
; 176: 			Else
	GOTO L0041
L0040:
; 177: 				encoder_count = 4
	MOVLW 0x04
	MOVWF 0x44
; 178: 				If manual_pos > 0 Then
	MOVF 0x3A,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0042
; 179: 					manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x3A,W
	MOVWF 0x3A
; 180: 				Endif
L0042:
; 181: 				value = manual_pos
	MOVF 0x3A,W
	MOVWF 0x33
; 182: 				Gosub i2c_display
	CALL L0007
; 183: 			Endif
L0041:
; 184: 		Case Else
	GOTO L0043
L0039:
; 185: 		EndSelect
L0043:
L0038:
; 186: 		WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	CALL W001
; 187: 	Wend
	GOTO L0032
L0033:
; 188: Return
	RETURN
; 189: 
; 190: adjust_settings:
L0003:
; 191: 	onoff = 0
	BCF 0x47,0
; 192: 	Gosub relays
	CALL L0010
; 193: 	Gosub steps_reading
	CALL L0004
; 194: 	program_set = 61  'this is the setting for position correction
	MOVLW 0x3D
	MOVWF 0x41
; 195: 	value = program_set
	MOVF 0x41,W
	MOVWF 0x33
; 196: 	Gosub i2c_display
	CALL L0007
; 197: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x38,W
	MOVWF 0x34
	MOVF 0x39,W
	MOVWF 0x35
; 198: 	old_max_pos = max_pos
	MOVF 0x37,W
	MOVWF 0x4F
; 199: 	old_speed = speed.HB
	MOVF 0x31,W
	MOVWF 0x4C
; 200: 	old_free_space_steps = free_space_steps
	MOVF 0x36,W
	MOVWF 0x4D
; 201: 	While pgm = 0
L0044:
	BTFSC 0x07,7
	GOTO L0045
; 202: 		If ecsw = 0 Then  'knob is pressed, adjust max positions
	BTFSC 0x07,6
	GOTO L0046
; 203: 			program_set = program_set + 1
	MOVF 0x41,W
	ADDLW 0x01
	MOVWF 0x41
; 204: 			If program_set > 64 Then
	MOVF 0x41,W
	SUBLW 0x40
	BTFSC STATUS,C
	GOTO L0047
; 205: 				program_set = 61
	MOVLW 0x3D
	MOVWF 0x41
; 206: 			Endif
L0047:
; 207: 			value = program_set
	MOVF 0x41,W
	MOVWF 0x33
; 208: 			Gosub i2c_display
	CALL L0007
; 209: 			WaitMs 1000  'give some time for dispaly to be read
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 210: 			While ecsw = 0  'be sure pushbutton is released
L0048:
	BTFSC 0x07,6
	GOTO L0049
; 211: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
	CALL W001
; 212: 			Wend
	GOTO L0048
L0049:
; 213: 		Endif
L0046:
; 214: 		Select Case program_set
; 215: 		Case 61  'correction position
	MOVF 0x41,W
	SUBLW 0x3D
	BTFSS STATUS,Z
	GOTO L0050
; 216: 			Gosub calc_rotation
	CALL L0008
; 217: 			Select Case result
; 218: 			Case 1
	MOVF 0x3B,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0051
; 219: 				If new_steps < 60000 Then
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0052
; 220: 					ena = 1  'motor on
	BSF 0x07,2
; 221: 					new_steps = new_steps + 1
	MOVF 0x34,W
	ADDLW 0x01
	MOVWF 0x34
	MOVF 0x35,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x35
; 222: 					direction = 1
	BSF 0x07,0
; 223: 					clk = 1  'clock out
	BSF 0x07,1
; 224: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	CALL W001
; 225: 					clk = 0
	BCF 0x07,1
; 226: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	CALL W001
; 227: 				Endif
L0052:
; 228: 			Case 2
	GOTO L0053
L0051:
	MOVF 0x3B,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0054
; 229: 				If new_steps > 0 Then
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0055
; 230: 					ena = 1  'motor on
	BSF 0x07,2
; 231: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x35,W
	MOVWF 0x35
; 232: 					direction = 0
	BCF 0x07,0
; 233: 					clk = 1  'clock out
	BSF 0x07,1
; 234: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	CALL W001
; 235: 					clk = 0
	BCF 0x07,1
; 236: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	CALL W001
; 237: 				Endif
L0055:
; 238: 			Case Else
	GOTO L0056
L0054:
; 239: 			EndSelect
L0056:
L0053:
; 240: 		Case 62  'setting of maximum positions
	GOTO L0057
L0050:
	MOVF 0x41,W
	SUBLW 0x3E
	BTFSS STATUS,Z
	GOTO L0058
; 241: 			ena = 0  'shut off motor
	BCF 0x07,2
; 242: 			value = max_pos
	MOVF 0x37,W
	MOVWF 0x33
; 243: 			Gosub i2c_display
	CALL L0007
; 244: 			Gosub calc_rotation
	CALL L0008
; 245: 			Select Case result
; 246: 			Case 1
	MOVF 0x3B,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0059
; 247: 				If max_pos < 60 Then  'display is limited to 60
	MOVLW 0x3C
	SUBWF 0x37,W
	BTFSC STATUS,C
	GOTO L0060
; 248: 					max_pos = max_pos + 1
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x37
; 249: 				Endif
L0060:
; 250: 			Case 2
	GOTO L0061
L0059:
	MOVF 0x3B,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0062
; 251: 				If max_pos > 4 Then
	MOVF 0x37,W
	SUBLW 0x04
	BTFSC STATUS,C
	GOTO L0063
; 252: 					max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x37,W
	MOVWF 0x37
; 253: 				Endif
L0063:
; 254: 			Case Else
	GOTO L0064
L0062:
; 255: 			EndSelect
L0064:
L0061:
; 256: 		Case 63  'setting of speed interval
	GOTO L0065
L0058:
	MOVF 0x41,W
	SUBLW 0x3F
	BTFSS STATUS,Z
	GOTO L0066
; 257: 					'setting will be done in multiple of 100 uSecs
; 258: 					'minimum is 2 and maximum is 50 (is real slow)
; 259: 			ena = 0  'shut off motor
	BCF 0x07,2
; 260: 			value = speed.HB
	MOVF 0x31,W
	MOVWF 0x33
; 261: 			Gosub i2c_display
	CALL L0007
; 262: 			Gosub calc_rotation
	CALL L0008
; 263: 			Select Case result
; 264: 			Case 1
	MOVF 0x3B,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0067
; 265: 				If speed.HB < 60 Then  'display is limited to 60
	MOVLW 0x3C
	SUBWF 0x31,W
	BTFSC STATUS,C
	GOTO L0068
; 266: 					speed.HB = speed.HB + 1
	MOVF 0x31,W
	ADDLW 0x01
	MOVWF 0x31
; 267: 				Endif
L0068:
; 268: 			Case 2
	GOTO L0069
L0067:
	MOVF 0x3B,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0070
; 269: 				If speed.HB > 2 Then
	MOVF 0x31,W
	SUBLW 0x02
	BTFSC STATUS,C
	GOTO L0071
; 270: 					speed.HB = speed.HB - 1
	MOVLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 271: 				Endif
L0071:
; 272: 			Case Else
	GOTO L0072
L0070:
; 273: 			EndSelect
L0072:
L0069:
; 274: 		Case Else  'setting of extra free space steps
	GOTO L0073
L0066:
; 275: 			ena = 0  'shut off motor
	BCF 0x07,2
; 276: 			value = free_space_steps
	MOVF 0x36,W
	MOVWF 0x33
; 277: 			Gosub i2c_display
	CALL L0007
; 278: 			Gosub calc_rotation
	CALL L0008
; 279: 			Select Case result
; 280: 			Case 1
	MOVF 0x3B,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0074
; 281: 				If free_space_steps < 60 Then  'display is limited to 60
	MOVLW 0x3C
	SUBWF 0x36,W
	BTFSC STATUS,C
	GOTO L0075
; 282: 					free_space_steps = free_space_steps + 1
	MOVF 0x36,W
	ADDLW 0x01
	MOVWF 0x36
; 283: 				Endif
L0075:
; 284: 			Case 2
	GOTO L0076
L0074:
	MOVF 0x3B,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0077
; 285: 				If free_space_steps > 0 Then
	MOVF 0x36,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0078
; 286: 					free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x36,W
	MOVWF 0x36
; 287: 				Endif
L0078:
; 288: 			Case Else
	GOTO L0079
L0077:
; 289: 			EndSelect
L0079:
L0076:
; 290: 		EndSelect
L0073:
L0065:
L0057:
; 291: 		
; 292: 	Wend
	GOTO L0044
L0045:
; 293: 	ena = 0  'shut off motor
	BCF 0x07,2
; 294: 		'***************   now check if changes have to written in eeprom
; 295: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVF 0x38,W
	MOVWF R1L
	MOVF 0x39,W
	MOVWF R1H
	CALL C002
	BTFSS STATUS,Z
	GOTO L0080
; 296: 		Write act_pos, new_steps.LB
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0081:	BTFSC EECON1,WR
	GOTO L0081
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 297: 		act_pos = act_pos + 60
	MOVF 0x32,W
	ADDLW 0x3C
	MOVWF 0x32
; 298: 		Write act_pos, new_steps.HB
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0082:	BTFSC EECON1,WR
	GOTO L0082
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 299: 		act_pos = act_pos - 60
	MOVLW 0x3C
	SUBWF 0x32,W
	MOVWF 0x32
; 300: 		act_steps = new_steps
	MOVF 0x34,W
	MOVWF 0x38
	MOVF 0x35,W
	MOVWF 0x39
; 301: 	Endif
L0080:
; 302: 	If old_max_pos <> max_pos Then  'save new max postitions
	MOVF 0x4F,W
	SUBWF 0x37,W
	BTFSC STATUS,Z
	GOTO L0083
; 303: 		Write 126, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0084:	BTFSC EECON1,WR
	GOTO L0084
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 304: 	Endif
L0083:
; 305: 	If old_speed <> speed.HB Then  'save speed
	MOVF 0x4C,W
	SUBWF 0x31,W
	BTFSC STATUS,Z
	GOTO L0085
; 306: 		Write 122, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0086:	BTFSC EECON1,WR
	GOTO L0086
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 307: 	Endif
L0085:
; 308: 	If old_free_space_steps <> free_space_steps Then  'save free_space_steps
	MOVF 0x4D,W
	SUBWF 0x36,W
	BTFSC STATUS,Z
	GOTO L0087
; 309: 		Write 127, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0088:	BTFSC EECON1,WR
	GOTO L0088
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 310: 	Endif
L0087:
; 311: 	value = act_pos
	MOVF 0x32,W
	MOVWF 0x33
; 312: 	Gosub i2c_display
	CALL L0007
; 313: 	onoff = 1
	BSF 0x47,0
; 314: 	Gosub relays
	CALL L0010
; 315: Return
	RETURN
; 316: 
; 317: steps_reading:
L0004:
; 318: 	eprom_pointer1 = act_pos + 60
	MOVF 0x32,W
	ADDLW 0x3C
	MOVWF 0x48
; 319: 	Read eprom_pointer1, act_steps.HB
	MOVF 0x48,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 320: 	Read act_pos, act_steps.LB
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x38
; 321: 	If new_pos = 0 Then
	MOVF 0x45,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0089
; 322: 		new_steps = 0
	CLRF 0x34
	CLRF 0x35
; 323: 	Else
	GOTO L0090
L0089:
; 324: 		eprom_pointer2 = new_pos + 60
	MOVF 0x45,W
	ADDLW 0x3C
	MOVWF 0x4E
; 325: 		Read eprom_pointer2, new_steps.HB
	MOVF 0x4E,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x35
; 326: 		Read new_pos, new_steps.LB
	MOVF 0x45,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 327: 	Endif
L0090:
; 328: Return
	RETURN
; 329: 
; 330: init_eeprom:
L0005:
; 331: 	act_steps = 0
	CLRF 0x38
	CLRF 0x39
; 332: 	act_pos = 0
	CLRF 0x32
; 333: 	eprom_pointer1 = 60
	MOVLW 0x3C
	MOVWF 0x48
; 334: 	For value = 0 To 60
	CLRF 0x33
L0091:
	MOVF 0x33,W
	SUBLW 0x3C
	BTFSS STATUS,C
	GOTO L0092
; 335: 		Write act_pos, act_steps.LB
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0093:	BTFSC EECON1,WR
	GOTO L0093
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 336: 		Write eprom_pointer1, act_steps.HB
	MOVF 0x48,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0094:	BTFSC EECON1,WR
	GOTO L0094
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 337: 		act_steps = act_steps + 256
	MOVF 0x38,W
	ADDLW 0x00
	MOVWF 0x38
	MOVF 0x39,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x01
	MOVWF 0x39
; 338: 		act_pos = act_pos + 1
	MOVF 0x32,W
	ADDLW 0x01
	MOVWF 0x32
; 339: 		eprom_pointer1 = eprom_pointer1 + 1
	MOVF 0x48,W
	ADDLW 0x01
	MOVWF 0x48
; 340: 	Next value
	MOVLW 0x01
	ADDWF 0x33,F
	BTFSS STATUS,C
	GOTO L0091
L0092:
; 341: 	speed = 0
	CLRF 0x30
	CLRF 0x31
; 342: 	speed.HB = 20
	MOVLW 0x14
	MOVWF 0x31
; 343: 	Write 122, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0095:	BTFSC EECON1,WR
	GOTO L0095
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 344: 	one_round = 8000
	MOVLW 0x40
	MOVWF 0x3F
	MOVLW 0x1F
	MOVWF 0x40
; 345: 	Write 123, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0096:	BTFSC EECON1,WR
	GOTO L0096
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 346: 	Write 124, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0097:	BTFSC EECON1,WR
	GOTO L0097
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 347: 	Write 125, 1  'act_pos
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x01
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0098:	BTFSC EECON1,WR
	GOTO L0098
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 348: 	Write 126, 60  'max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x3C
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0099:	BTFSC EECON1,WR
	GOTO L0099
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 349: 	free_space_steps = 20
	MOVLW 0x14
	MOVWF 0x36
; 350: 	Write 127, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0100:	BTFSC EECON1,WR
	GOTO L0100
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 351: 
; 352: Return
	RETURN
; 353: 
; 354: i2c_convert:
L0006:
; 355: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x3E,W
	SUBLW 0x09
	BTFSS STATUS,C
	GOTO L0101
	CALL L0102
	MOVWF 0x3E
	GOTO L0101
L0102:
	MOVLW 0x04
	MOVWF PCLATH
	MOVF 0x3E,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
L0101:
; 356: 	disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x3E,7
	BTFSS 0x07,7
	BCF 0x3E,7
; 357: 	disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x42,W
	SUBLW 0x0A
	BTFSS STATUS,C
	GOTO L0103
	CALL L0104
	MOVWF 0x42
	GOTO L0103
L0104:
	MOVLW 0x04
	MOVWF PCLATH
	MOVF 0x42,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
L0103:
; 358: 
; 359: Return
	RETURN
; 360: 
; 361: i2c_display:
L0007:
; 362: 	Select Case value
; 363: 	Case < 61  'normal display
	MOVLW 0x3D
	SUBWF 0x33,W
	BTFSC STATUS,C
	GOTO L0105
; 364: 		disp1_val = value
	MOVF 0x33,W
	MOVWF 0x3E
; 365: 		disp1_val = disp1_val Mod 10
	MOVF 0x3E,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x3E
; 366: 		disp2_val = value
	MOVF 0x33,W
	MOVWF 0x42
; 367: 		disp2_val = disp2_val / 10
	MOVF 0x42,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x42
; 368: 	Case 61  'this is program 1 setting max positions
	GOTO L0106
L0105:
	MOVF 0x33,W
	SUBLW 0x3D
	BTFSS STATUS,Z
	GOTO L0107
; 369: 		disp1_val = 1
	MOVLW 0x01
	MOVWF 0x3E
; 370: 		disp2_val = 10
	MOVLW 0x0A
	MOVWF 0x42
; 371: 	Case 62  'setting of maximum positions
	GOTO L0108
L0107:
	MOVF 0x33,W
	SUBLW 0x3E
	BTFSS STATUS,Z
	GOTO L0109
; 372: 		disp1_val = 2
	MOVLW 0x02
	MOVWF 0x3E
; 373: 		disp2_val = 10
	MOVLW 0x0A
	MOVWF 0x42
; 374: 	Case 63  'setting of speed interval
	GOTO L0110
L0109:
	MOVF 0x33,W
	SUBLW 0x3F
	BTFSS STATUS,Z
	GOTO L0111
; 375: 		disp1_val = 3
	MOVLW 0x03
	MOVWF 0x3E
; 376: 		disp2_val = 10
	MOVLW 0x0A
	MOVWF 0x42
; 377: 	Case Else  'setting of extra free space steps
	GOTO L0112
L0111:
; 378: 		disp1_val = 4
	MOVLW 0x04
	MOVWF 0x3E
; 379: 		disp2_val = 10
	MOVLW 0x0A
	MOVWF 0x42
; 380: 	EndSelect
L0112:
L0110:
L0108:
L0106:
; 381: 	Gosub i2c_convert
	CALL L0006
; 382: 	I2CStart
	CALL IC31
; 383: 	I2CSend disp1
	MOVLW 0x40
	CALL IC01
; 384: 	I2CSend disp1_val
	MOVF 0x3E,W
	CALL IC01
; 385: 	I2CStop
	CALL IC41
; 386: 	I2CStart
	CALL IC31
; 387: 	I2CSend disp2
	MOVLW 0x42
	CALL IC01
; 388: 	I2CSend disp2_val
	MOVF 0x42,W
	CALL IC01
; 389: 	I2CStop
	CALL IC41
; 390: Return
	RETURN
; 391: 
; 392: 
; 393: calc_rotation:
L0008:
; 394: '1 = increasing value
; 395: '2 = decreasing value
; 396: '3 = no change
; 397: 		new_encoder = 0
	CLRF 0x43
; 398: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x43,0
	BTFSS 0x07,4
	BCF 0x43,0
; 399: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x43,1
	BTFSS 0x07,5
	BCF 0x43,1
; 400: 		Select Case old_encoder
; 401: 		Case 0
	MOVF 0x4A,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0113
; 402: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x43,W
	SUBLW 0x03
	BTFSS STATUS,C
	GOTO L0114
	CALL L0115
	MOVWF 0x3B
	GOTO L0114
L0115:
	MOVLW 0x04
	MOVWF PCLATH
	MOVF 0x43,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
L0114:
; 403: 		Case 1
	GOTO L0116
L0113:
	MOVF 0x4A,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0117
; 404: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x43,W
	SUBLW 0x03
	BTFSS STATUS,C
	GOTO L0118
	CALL L0119
	MOVWF 0x3B
	GOTO L0118
L0119:
	MOVLW 0x04
	MOVWF PCLATH
	MOVF 0x43,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
L0118:
; 405: 		Case 2
	GOTO L0120
L0117:
	MOVF 0x4A,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0121
; 406: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x43,W
	SUBLW 0x03
	BTFSS STATUS,C
	GOTO L0122
	CALL L0123
	MOVWF 0x3B
	GOTO L0122
L0123:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x43,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
L0122:
; 407: 		Case Else
	GOTO L0124
L0121:
; 408: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x43,W
	SUBLW 0x03
	BTFSS STATUS,C
	GOTO L0125
	CALL L0126
	MOVWF 0x3B
	GOTO L0125
L0126:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x43,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
L0125:
; 409: 		EndSelect
L0124:
L0120:
L0116:
; 410: 		old_encoder = new_encoder
	MOVF 0x43,W
	MOVWF 0x4A
; 411: Return
	RETURN
; 412: 
; 413: stepmotor:
L0009:
; 414: 	speed = 0
	CLRF 0x30
	CLRF 0x31
; 415: 	Read 123, speed.HB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 416: 	Read 127, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 417: 	If new_steps = 0 Then
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C001
	BTFSS STATUS,Z
	GOTO L0127
; 418: 		direction = 0
	BCF 0x07,0
; 419: 		ena = 1  'set anable on
	BSF 0x07,2
; 420: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 421: 		While zero = 1  'turn motor until zero switch is activated
L0128:
	BTFSS 0x07,3
	GOTO L0129
; 422: 			clk = 1  'clock out
	BSF 0x07,1
; 423: 			WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	CALL W001
; 424: 			clk = 0
	BCF 0x07,1
; 425: 			WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	CALL W001
; 426: 		Wend
	GOTO L0128
L0129:
; 427: 		ena = 0  'set anable off
	BCF 0x07,2
; 428: 	Else
	GOTO L0130
L0127:
; 429: 		If new_steps > act_steps Then
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVF 0x38,W
	MOVWF R1L
	MOVF 0x39,W
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0131
; 430: 			steps = new_steps - act_steps
	MOVF 0x38,W
	SUBWF 0x34,W
	MOVWF 0x3C
	MOVF 0x39,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x35,W
	MOVWF 0x3D
; 431: 			steps = steps + free_space_steps
	MOVF 0x3C,W
	ADDWF 0x36,W
	MOVWF 0x3C
	MOVF 0x3D,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x3D
; 432: 			direction = 1
	BSF 0x07,0
; 433: 			ena = 1  'set anable on
	BSF 0x07,2
; 434: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 435: 			While steps > 0  'shortest step =500uSec longest step = 5000uSec
L0132:
	MOVF 0x3C,W
	MOVWF R0L
	MOVF 0x3D,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0133
; 436: 				clk = 1  'clock out
	BSF 0x07,1
; 437: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	CALL Y001
; 438: 				clk = 0
	BCF 0x07,1
; 439: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	CALL Y001
; 440: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x3C,W
	MOVWF 0x3C
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
; 441: 			Wend
	GOTO L0132
L0133:
; 442: 			WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 443: 			steps = free_space_steps
	MOVF 0x36,W
	MOVWF 0x3C
	CLRF 0x3D
; 444: 			direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 445: 			While steps > 0  'shortest step =512uSec
L0134:
	MOVF 0x3C,W
	MOVWF R0L
	MOVF 0x3D,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0135
; 446: 				clk = 1  'clock out
	BSF 0x07,1
; 447: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	CALL Y001
; 448: 				clk = 0
	BCF 0x07,1
; 449: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	CALL Y001
; 450: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x3C,W
	MOVWF 0x3C
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
; 451: 			Wend
	GOTO L0134
L0135:
; 452: 		Else
	GOTO L0136
L0131:
; 453: 			steps = act_steps - new_steps
	MOVF 0x34,W
	SUBWF 0x38,W
	MOVWF 0x3C
	MOVF 0x35,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x39,W
	MOVWF 0x3D
; 454: 			direction = 0  'go reverse
	BCF 0x07,0
; 455: 			ena = 1  'set anable on
	BSF 0x07,2
; 456: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 457: 			While steps > 0  'shortest step =500uSec longest step = 5000uSec
L0137:
	MOVF 0x3C,W
	MOVWF R0L
	MOVF 0x3D,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0138
; 458: 				clk = 1  'clock out
	BSF 0x07,1
; 459: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	CALL Y001
; 460: 				clk = 0
	BCF 0x07,1
; 461: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	CALL Y001
; 462: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x3C,W
	MOVWF 0x3C
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
; 463: 			Wend
	GOTO L0137
L0138:
; 464: 			ena = 0  'enable off
	BCF 0x07,2
; 465: 			pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 466: 		Endif
L0136:
; 467: 	Endif
L0130:
; 468: 
; 469: Return
	RETURN
; 470: 
; 471: 
; 472: relays:
L0010:
; 473: 	If onoff = 1 Then
	BTFSS 0x47,0
	GOTO L0139
; 474: 		value = max_pos + 1
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x33
; 475: 		value = value / 2  'calulation of half max positions
	MOVF 0x33,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x33
; 476: 		If act_pos > value Then  'select polarity rails on bridge
	MOVF 0x32,W
	SUBWF 0x33,W
	BTFSC STATUS,C
	GOTO L0140
; 477: 			swfw = 0
	BCF 0x06,0
; 478: 			swrev = 1
	BSF 0x06,1
; 479: 		Else
	GOTO L0141
L0140:
; 480: 			swrev = 0
	BCF 0x06,1
; 481: 			swfw = 1
	BSF 0x06,0
; 482: 		Endif
L0141:
; 483: 	Else
	GOTO L0142
L0139:
; 484: 		swfw = 0
	BCF 0x06,0
; 485: 		swrev = 0
	BCF 0x06,1
; 486: 	Endif
L0142:
; 487: Return
	RETURN
; 488: 
; 489: 
; End of program
L0143:	GOTO L0143
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
