'program TT for PCBoard MGV145
'version v1.1  Fiddle Yard version, also for turntables only turning to zero, not further.
'this version has only one speed and (on right hand turn > not towards 0) will run 20 steps too far, and then run 20 steps back.
Define CONF_WORD = 0x3f72
Define CLOCK_FREQUENCY = 20
Dim steps As Word
Dim program_set As Byte
Dim new_steps As Word
Dim act_steps As Word
Dim new_pos As Byte
Dim act_pos As Byte
Dim one_round As Word
Dim one_round_half As Word
Dim bus_pos As Byte
Dim old_bus_pos As Byte
Dim speed As Word
Dim old_speed As Byte
Dim new_encoder As Byte
Dim old_encoder As Byte
Dim manual_pos As Byte
Dim old_manual_pos As Byte
Dim result As Byte
Dim free_space_steps As Byte
Dim old_free_space_steps As Byte
Dim value As Byte
Dim eprom_pointer1 As Byte
Dim eprom_pointer2 As Byte
Dim encoder_count As Byte
Dim onoff As Bit
Dim ecsw_temp As Bit
Dim max_pos As Byte
Dim old_max_pos As Byte
Dim disp1_val As Byte
Dim disp2_val As Byte
Const disp1 = 64
Const disp2 = 66

Symbol swfw = RB0
Symbol swrev = RB1
Symbol sck = RB2
Symbol sda = RB3
Symbol pos_match = RB4
Symbol pos_write = RB5
Symbol eep = RB6
Symbol direction = RC0
Symbol clk = RC1
Symbol ena = RC2
Symbol zero = RC3
Symbol ec1 = RC4
Symbol ec2 = RC5
Symbol ecsw = RC6
Symbol pgm = RC7
encoder_count = 0
speed = 0
If eep = 1 Then  'jumper set for imitialisation
	Gosub init_eeprom
Endif
Read 122, speed.HB
If speed < 512 Then
	speed = 4096
	Write 122, speed.HB
Endif
Read 123, one_round.LB
Read 124, one_round.HB
If one_round = 0 Then
	one_round = 8000
Endif
If one_round > 64000 Then
	one_round = 8000
Endif
one_round_half = one_round / 2
Read 125, act_pos
Read 126, max_pos
If act_pos > 60 Then
	act_pos = 1
	Write 125, act_pos
Endif
If max_pos > 60 Then
	max_pos = 12
	Write 126, max_pos
Endif
Read 127, free_space_steps
If free_space_steps > 60 Then
	free_space_steps = 20
	Write 127, free_space_steps
Endif
new_pos = act_pos
bus_pos = PORTA And 63  'cancel first input from MGV50
old_bus_pos = bus_pos
manual_pos = act_pos
TRISA = %111111
TRISB = %11101100
TRISC = %11111000
PORTB = %11101100
PORTC = %11111000
I2CPrepare sda, sck
value = act_pos
Gosub i2c_display
onoff = 1
Gosub relays

main:
	If pgm = 0 Then
		Gosub adjust_settings
		WaitMs 500
	Endif

	Gosub get_new_position
	If bus_pos <> old_bus_pos Then
		onoff = 0
		Gosub relays
		pos_match = 1  'indicate not in position
		new_pos = bus_pos
		old_bus_pos = bus_pos
		Gosub steps_reading
		Gosub stepmotor
		act_pos = new_pos
		Write 125, act_pos
		value = act_pos
		Gosub i2c_display
		pos_match = 0  'indicate pos_match
		onoff = 1
	Else
		If manual_pos <> old_manual_pos Then
			onoff = 0
			Gosub relays
			pos_match = 1  'indicate not in position
			old_manual_pos = manual_pos
			new_pos = manual_pos
			Gosub steps_reading
			Gosub stepmotor
			act_pos = new_pos
			Write 125, act_pos
			value = act_pos
			Gosub i2c_display
			pos_match = 0  'indicate pos_match
			manual_pos = act_pos
			old_manual_pos = act_pos
			onoff = 1
		Endif
	Endif
	WaitMs 10
	Gosub relays
	Goto main
End                                               


get_new_position:
	If pos_write = 0 Then
		bus_pos = PORTA And 63
		If bus_pos > max_pos Then
			old_bus_pos = bus_pos  'do not react on illegal value
		Endif
	Endif
	ecsw_temp = 1
	While ecsw_temp = 1
	'result will now be calculated
		ecsw_temp = ecsw And pgm
		Gosub calc_rotation
		Select Case result
		Case 1
			If encoder_count < 4 Then
				encoder_count = encoder_count + 1
			Else
				encoder_count = 0
				manual_pos = manual_pos + 1
				If manual_pos > max_pos Then
					manual_pos = max_pos
				Endif
				value = manual_pos
				Gosub i2c_display
			Endif
		Case 2
			If encoder_count > 0 Then
				encoder_count = encoder_count - 1
			Else
				encoder_count = 4
				If manual_pos > 0 Then
					manual_pos = manual_pos - 1
				Endif
				value = manual_pos
				Gosub i2c_display
			Endif
		Case Else
		EndSelect
		WaitMs 1
	Wend
Return                                            

adjust_settings:
	onoff = 0
	Gosub relays
	Gosub steps_reading
	program_set = 61  'this is the setting for position correction
	value = program_set
	Gosub i2c_display
	new_steps = act_steps  'nothing is changed yet
	old_max_pos = max_pos
	old_speed = speed.HB
	old_free_space_steps = free_space_steps
	While pgm = 0
		If ecsw = 0 Then  'knob is pressed, adjust max positions
			program_set = program_set + 1
			If program_set > 64 Then
				program_set = 61
			Endif
			value = program_set
			Gosub i2c_display
			WaitMs 1000  'give some time for dispaly to be read
			While ecsw = 0  'be sure pushbutton is released
				WaitMs 250  'cancel contact dender
			Wend
		Endif
		Select Case program_set
		Case 61  'correction position
			Gosub calc_rotation
			Select Case result
			Case 1
				If new_steps < 60000 Then
					ena = 1  'motor on
					new_steps = new_steps + 1
					direction = 1
					clk = 1  'clock out
					WaitMs 5
					clk = 0
					WaitMs 5
				Endif
			Case 2
				If new_steps > 0 Then
					ena = 1  'motor on
					new_steps = new_steps - 1
					direction = 0
					clk = 1  'clock out
					WaitMs 5
					clk = 0
					WaitMs 5
				Endif
			Case Else
			EndSelect
		Case 62  'setting of maximum positions
			ena = 0  'shut off motor
			value = max_pos
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1
				If max_pos < 60 Then  'display is limited to 60
					max_pos = max_pos + 1
				Endif
			Case 2
				If max_pos > 4 Then
					max_pos = max_pos - 1
				Endif
			Case Else
			EndSelect
		Case 63  'setting of speed interval
					'setting will be done in multiple of 100 uSecs
					'minimum is 2 and maximum is 50 (is real slow)
			ena = 0  'shut off motor
			value = speed.HB
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1
				If speed.HB < 60 Then  'display is limited to 60
					speed.HB = speed.HB + 1
				Endif
			Case 2
				If speed.HB > 2 Then
					speed.HB = speed.HB - 1
				Endif
			Case Else
			EndSelect
		Case Else  'setting of extra free space steps
			ena = 0  'shut off motor
			value = free_space_steps
			Gosub i2c_display
			Gosub calc_rotation
			Select Case result
			Case 1
				If free_space_steps < 60 Then  'display is limited to 60
					free_space_steps = free_space_steps + 1
				Endif
			Case 2
				If free_space_steps > 0 Then
					free_space_steps = free_space_steps - 1
				Endif
			Case Else
			EndSelect
		EndSelect
		
	Wend
	ena = 0  'shut off motor
		'***************   now check if changes have to written in eeprom
	If new_steps <> act_steps Then  'now save new position
		Write act_pos, new_steps.LB
		act_pos = act_pos + 60
		Write act_pos, new_steps.HB
		act_pos = act_pos - 60
		act_steps = new_steps
	Endif
	If old_max_pos <> max_pos Then  'save new max postitions
		Write 126, max_pos
	Endif
	If old_speed <> speed.HB Then  'save speed
		Write 122, speed.HB
	Endif
	If old_free_space_steps <> free_space_steps Then  'save free_space_steps
		Write 127, free_space_steps
	Endif
	value = act_pos
	Gosub i2c_display
	onoff = 1
	Gosub relays
Return                                            

steps_reading:
	eprom_pointer1 = act_pos + 60
	Read eprom_pointer1, act_steps.HB
	Read act_pos, act_steps.LB
	If new_pos = 0 Then
		new_steps = 0
	Else
		eprom_pointer2 = new_pos + 60
		Read eprom_pointer2, new_steps.HB
		Read new_pos, new_steps.LB
	Endif
Return                                            

init_eeprom:
	act_steps = 0
	act_pos = 0
	eprom_pointer1 = 60
	For value = 0 To 60
		Write act_pos, act_steps.LB
		Write eprom_pointer1, act_steps.HB
		act_steps = act_steps + 256
		act_pos = act_pos + 1
		eprom_pointer1 = eprom_pointer1 + 1
	Next value
	speed = 0
	speed.HB = 20
	Write 122, speed.HB
	one_round = 8000
	Write 123, one_round.LB
	Write 124, one_round.HB
	Write 125, 1  'act_pos
	Write 126, 60  'max_pos
	free_space_steps = 20
	Write 127, free_space_steps

Return                                            

i2c_convert:
	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	disp1_val.7 = pgm
	disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val

Return                                            

i2c_display:
	Select Case value
	Case < 61  'normal display
		disp1_val = value
		disp1_val = disp1_val Mod 10
		disp2_val = value
		disp2_val = disp2_val / 10
	Case 61  'this is program 1 setting max positions
		disp1_val = 1
		disp2_val = 10
	Case 62  'setting of maximum positions
		disp1_val = 2
		disp2_val = 10
	Case 63  'setting of speed interval
		disp1_val = 3
		disp2_val = 10
	Case Else  'setting of extra free space steps
		disp1_val = 4
		disp2_val = 10
	EndSelect
	Gosub i2c_convert
	I2CStart
	I2CSend disp1
	I2CSend disp1_val
	I2CStop
	I2CStart
	I2CSend disp2
	I2CSend disp2_val
	I2CStop
Return                                            


calc_rotation:
'1 = increasing value
'2 = decreasing value
'3 = no change
		new_encoder = 0
		new_encoder.0 = ec1
		new_encoder.1 = ec2
		Select Case old_encoder
		Case 0
			result = LookUp(3, 2, 1, 3), new_encoder
		Case 1
			result = LookUp(1, 3, 3, 2), new_encoder
		Case 2
			result = LookUp(2, 3, 3, 1), new_encoder
		Case Else
			result = LookUp(3, 1, 2, 3), new_encoder
		EndSelect
		old_encoder = new_encoder
Return                                            

stepmotor:
	speed = 0
	Read 123, speed.HB
	Read 127, free_space_steps
	If new_steps = 0 Then
		direction = 0
		ena = 1  'set anable on
		pos_match = 1  'not indicate pos_match
		While zero = 1  'turn motor until zero switch is activated
			clk = 1  'clock out
			WaitMs 2
			clk = 0
			WaitMs 2
		Wend
		ena = 0  'set anable off
	Else
		If new_steps > act_steps Then
			steps = new_steps - act_steps
			steps = steps + free_space_steps
			direction = 1
			ena = 1  'set anable on
			pos_match = 1  'not indicate pos_match
			While steps > 0  'shortest step =500uSec longest step = 5000uSec
				clk = 1  'clock out
				WaitUs speed
				clk = 0
				WaitUs speed
				steps = steps - 1
			Wend
			WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
			steps = free_space_steps
			direction = 0  'now go back the free-space correction
			While steps > 0  'shortest step =512uSec
				clk = 1  'clock out
				WaitUs speed
				clk = 0
				WaitUs speed
				steps = steps - 1
			Wend
		Else
			steps = act_steps - new_steps
			direction = 0  'go reverse
			ena = 1  'set anable on
			pos_match = 1  'not indicate pos_match
			While steps > 0  'shortest step =500uSec longest step = 5000uSec
				clk = 1  'clock out
				WaitUs speed
				clk = 0
				WaitUs speed
				steps = steps - 1
			Wend
			ena = 0  'enable off
			pos_match = 0  'indicate pos_match
		Endif
	Endif

Return                                            


relays:
	If onoff = 1 Then
		value = max_pos + 1
		value = value / 2  'calulation of half max positions
		If act_pos > value Then  'select polarity rails on bridge
			swfw = 0
			swrev = 1
		Else
			swrev = 0
			swfw = 1
		Endif
	Else
		swfw = 0
		swrev = 0
	Endif
Return                                            


