; Compiled with: PIC Simulator IDE v6.90
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_speed' (global) is 122
;       The value of 'mem_max_pos' (global) is 126
;       The value of 'mem_free_space' (global) is 127
;       The value of 'mem_act_pos' (global) is 121
;       The address of 'speed' (word) (global) is 0x30
	speed EQU 0x30
;       The address of 'act_pos' (byte) (global) is 0x32
	act_pos EQU 0x32
;       The address of 'new_steps' (word) (global) is 0x33
	new_steps EQU 0x33
;       The address of 'max_pos' (byte) (global) is 0x35
	max_pos EQU 0x35
;       The address of 'free_space_steps' (byte) (global) is 0x36
	free_space_steps EQU 0x36
;       The address of 'value' (byte) (global) is 0x37
	value EQU 0x37
;       The address of 'act_steps' (word) (global) is 0x38
	act_steps EQU 0x38
;       The address of 'eprom_pointer1' (byte) (global) is 0x3A
	eprom_pointer1 EQU 0x3A
;       The address of 'manual_pos' (byte) (global) is 0x3B
	manual_pos EQU 0x3B
;       The address of 'result' (byte) (global) is 0x3C
	result EQU 0x3C
;       The address of 'steps' (word) (global) is 0x3D
	steps EQU 0x3D
;       The address of 'disp1_val' (byte) (global) is 0x3F
	disp1_val EQU 0x3F
;       The address of 'program_set' (byte) (global) is 0x40
	program_set EQU 0x40
;       The address of 'one_round' (word) (global) is 0x41
	one_round EQU 0x41
;       The address of 'new_encoder' (byte) (global) is 0x43
	new_encoder EQU 0x43
;       The address of 'encoder_count' (byte) (global) is 0x44
	encoder_count EQU 0x44
;       The address of 'new_pos' (byte) (global) is 0x45
	new_pos EQU 0x45
;       The address of 'bus_pos' (byte) (global) is 0x46
	bus_pos EQU 0x46
;       The address of 'onoff' (bit) (global) is 0x47,0
;       The address of 'eprom_pointer2' (byte) (global) is 0x48
	eprom_pointer2 EQU 0x48
;       The address of 'disp2_val' (byte) (global) is 0x49
	disp2_val EQU 0x49
;       The address of 'old_bus_pos' (byte) (global) is 0x4A
	old_bus_pos EQU 0x4A
;       The address of 'old_encoder' (byte) (global) is 0x4B
	old_encoder EQU 0x4B
;       The address of 'old_manual_pos' (byte) (global) is 0x4C
	old_manual_pos EQU 0x4C
;       The address of 'ecsw_temp' (bit) (global) is 0x47,1
;       The address of 'one_round_half' (word) (global) is 0x4D
	one_round_half EQU 0x4D
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'eep' (bit) (global) is 0x6,6
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x7,3
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0014
	ORG 0x0004
	RETFIE
; Begin of program
L0014:
; 1: 'program TT for PCBoard MGV145
; 2: 'version v1.1  Fiddle Yard version, also for turntables only turning to zero, not further.
; 3: 'this version has only one speed and (on right hand turn > not towards 0) will run 20 steps too far, and then run 20 steps back.
; 4: Define CONF_WORD = 0x3f72
; 5: Define CLOCK_FREQUENCY = 20
; 6: Dim steps As Word
; 7: Dim program_set As Byte
; 8: Dim new_steps As Word
; 9: Dim act_steps As Word
; 10: Dim new_pos As Byte
; 11: Dim act_pos As Byte
; 12: Dim one_round As Word
; 13: Dim one_round_half As Word
; 14: Dim bus_pos As Byte
; 15: Dim old_bus_pos As Byte
; 16: Dim speed As Word
; 17: Dim new_encoder As Byte
; 18: Dim old_encoder As Byte
; 19: Dim manual_pos As Byte
; 20: Dim old_manual_pos As Byte
; 21: Dim result As Byte
; 22: Dim free_space_steps As Byte
; 23: Dim value As Byte
; 24: Dim eprom_pointer1 As Byte
; 25: Dim eprom_pointer2 As Byte
; 26: Dim encoder_count As Byte
; 27: Dim onoff As Bit
; 28: Dim ecsw_temp As Bit
; 29: Dim max_pos As Byte
; 30: Dim disp1_val As Byte
; 31: Dim disp2_val As Byte
; 32: Const disp1 = 64
; 33: Const disp2 = 66
; 34: Const mem_speed = 122
; 35: Const mem_max_pos = 126
; 36: Const mem_free_space = 127
; 37: Const mem_act_pos = 121
; 38: Symbol swfw = RB0
; 39: Symbol swrev = RB1
; 40: Symbol sck = RB2
; 41: Symbol sda = RB3
; 42: Symbol pos_match = RB4
; 43: Symbol pos_write = RB5
; 44: Symbol eep = RB6
; 45: Symbol direction = RC0
; 46: Symbol clk = RC1
; 47: Symbol ena = RC2
; 48: Symbol zero = RC3
; 49: Symbol ec1 = RC4
; 50: Symbol ec2 = RC5
; 51: Symbol ecsw = RC6
; 52: Symbol pgm = RC7
; 53: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 54: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 55: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 56: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 57: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 58: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
; 59: Gosub init_values
	CALL L0013
; 60: value = act_pos
	MOVF 0x32,W
	MOVWF 0x37
; 61: Gosub i2c_display
	CALL L0006
; 62: onoff = 1
	BSF 0x47,0
; 63: Gosub relays
	CALL L0010
; 64: 
; 65: main:
L0001:
; 66: 	If pgm = 0 Then
	BTFSC 0x07,7
	GOTO L0015
; 67: 		Gosub adjust_settings
	CALL L0003
; 68: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	CALL W001
; 69: 	Endif
L0015:
; 70: 
; 71: 	Gosub get_new_position
	CALL L0002
; 72: 	If bus_pos <> old_bus_pos Then
	MOVF 0x46,W
	SUBWF 0x4A,W
	BTFSC STATUS,Z
	GOTO L0016
; 73: 		onoff = 0
	BCF 0x47,0
; 74: 		Gosub relays
	CALL L0010
; 75: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 76: 		new_pos = bus_pos
	MOVF 0x46,W
	MOVWF 0x45
; 77: 		old_bus_pos = bus_pos
	MOVF 0x46,W
	MOVWF 0x4A
; 78: 		Gosub steps_reading
	CALL L0004
; 79: 		Gosub stepmotor
	CALL L0009
; 80: 		act_pos = new_pos
	MOVF 0x45,W
	MOVWF 0x32
; 81: 		Write mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0017:	BTFSC EECON1,WR
	GOTO L0017
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 82: 		value = act_pos
	MOVF 0x32,W
	MOVWF 0x37
; 83: 		Gosub i2c_display
	CALL L0006
; 84: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 85: 		onoff = 1
	BSF 0x47,0
; 86: 	Else
	GOTO L0018
L0016:
; 87: 		If manual_pos <> old_manual_pos Then
	MOVF 0x3B,W
	SUBWF 0x4C,W
	BTFSC STATUS,Z
	GOTO L0019
; 88: 			onoff = 0
	BCF 0x47,0
; 89: 			Gosub relays
	CALL L0010
; 90: 			pos_match = 1  'indicate not in position
	BSF 0x06,4
; 91: 			old_manual_pos = manual_pos
	MOVF 0x3B,W
	MOVWF 0x4C
; 92: 			new_pos = manual_pos
	MOVF 0x3B,W
	MOVWF 0x45
; 93: 			Gosub steps_reading
	CALL L0004
; 94: 			Gosub stepmotor
	CALL L0009
; 95: 			act_pos = new_pos
	MOVF 0x45,W
	MOVWF 0x32
; 96: 			Write mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0020:	BTFSC EECON1,WR
	GOTO L0020
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 97: 			value = act_pos
	MOVF 0x32,W
	MOVWF 0x37
; 98: 			Gosub i2c_display
	CALL L0006
; 99: 			pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 100: 			manual_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x3B
; 101: 			old_manual_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x4C
; 102: 			onoff = 1
	BSF 0x47,0
; 103: 		Endif
L0019:
; 104: 	Endif
L0018:
; 105: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	CALL W001
; 106: 	Gosub relays
	CALL L0010
; 107: 	Goto main
	GOTO L0001
; 108: End
L0021:	GOTO L0021
; 109: 
; 110: 
; 111: get_new_position:
L0002:
; 112: 	If pos_write = 0 Then
	BTFSC 0x06,5
	GOTO L0022
; 113: 		bus_pos = PORTA And 63
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x46
; 114: 		If bus_pos > max_pos Then
	MOVF 0x46,W
	SUBWF 0x35,W
	BTFSC STATUS,C
	GOTO L0023
; 115: 			old_bus_pos = bus_pos  'do not react on illegal value
	MOVF 0x46,W
	MOVWF 0x4A
; 116: 		Endif
L0023:
; 117: 	Endif
L0022:
; 118: 	ecsw_temp = 1
	BSF 0x47,1
; 119: 	While ecsw_temp = 1
L0024:
	BTFSS 0x47,1
	GOTO L0025
; 120: 	'result will now be calculated
; 121: 		ecsw_temp = ecsw And pgm
	CLRW
	BTFSS 0x07,6
	ADDLW 0x01
	BTFSS 0x07,7
	ADDLW 0x01
	BTFSC STATUS,Z
	BSF 0x47,1
	BTFSS STATUS,Z
	BCF 0x47,1
; 122: 		Gosub calc_rotation
	CALL L0008
; 123: 		Select Case result
; 124: 		Case 1
	MOVF 0x3C,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0026
; 125: 			If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x44,W
	BTFSC STATUS,C
	GOTO L0027
; 126: 				encoder_count = encoder_count + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
; 127: 			Else
	GOTO L0028
L0027:
; 128: 				encoder_count = 0
	CLRF 0x44
; 129: 				manual_pos = manual_pos + 1
	MOVF 0x3B,W
	ADDLW 0x01
	MOVWF 0x3B
; 130: 				If manual_pos > max_pos Then
	MOVF 0x3B,W
	SUBWF 0x35,W
	BTFSC STATUS,C
	GOTO L0029
; 131: 					manual_pos = max_pos
	MOVF 0x35,W
	MOVWF 0x3B
; 132: 				Endif
L0029:
; 133: 				value = manual_pos
	MOVF 0x3B,W
	MOVWF 0x37
; 134: 				Gosub i2c_display
	CALL L0006
; 135: 			Endif
L0028:
; 136: 		Case 2
	GOTO L0030
L0026:
	MOVF 0x3C,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0031
; 137: 			If encoder_count > 0 Then
	MOVF 0x44,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0032
; 138: 				encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x44,W
	MOVWF 0x44
; 139: 			Else
	GOTO L0033
L0032:
; 140: 				encoder_count = 4
	MOVLW 0x04
	MOVWF 0x44
; 141: 				If manual_pos > 0 Then
	MOVF 0x3B,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0034
; 142: 					manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x3B
; 143: 				Endif
L0034:
; 144: 				value = manual_pos
	MOVF 0x3B,W
	MOVWF 0x37
; 145: 				Gosub i2c_display
	CALL L0006
; 146: 			Endif
L0033:
; 147: 		Case Else
	GOTO L0035
L0031:
; 148: 		EndSelect
L0035:
L0030:
; 149: 		WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	CALL W001
; 150: 	Wend
	GOTO L0024
L0025:
; 151: Return
	RETURN
; 152: 
; 153: adjust_settings:
L0003:
; 154: 	onoff = 0
	BCF 0x47,0
; 155: 	Gosub relays
	CALL L0010
; 156: 	Gosub steps_reading
	CALL L0004
; 157: 	program_set = 1  'this is the setting for position correction
	MOVLW 0x01
	MOVWF 0x40
; 158: 	Gosub i2c_display_pgm
	CALL L0007
; 159: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x38,W
	MOVWF 0x33
	MOVF 0x39,W
	MOVWF 0x34
; 160: 	Read mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 161: 	Read mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 162: 	Read mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x35
; 163: 	While pgm = 0
L0036:
	BTFSC 0x07,7
	GOTO L0037
; 164: 		If ecsw = 0 Then  'knob is pressed, adjust max positions
	BTFSC 0x07,6
	GOTO L0038
; 165: 			program_set = program_set + 1
	MOVF 0x40,W
	ADDLW 0x01
	MOVWF 0x40
; 166: 			If program_set > 4 Then
	MOVF 0x40,W
	SUBLW 0x04
	BTFSC STATUS,C
	GOTO L0039
; 167: 				program_set = 1
	MOVLW 0x01
	MOVWF 0x40
; 168: 			Endif
L0039:
; 169: 			Gosub i2c_display_pgm
	CALL L0007
; 170: 			WaitMs 1500  'give some time for display to be read
	MOVLW 0xDC
	MOVWF R0L
	MOVLW 0x05
	MOVWF R0H
	CALL W001
; 171: 			While ecsw = 0  'be sure pushbutton is released
L0040:
	BTFSC 0x07,6
	GOTO L0041
; 172: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
	CALL W001
; 173: 			Wend
	GOTO L0040
L0041:
; 174: 		Endif
L0038:
; 175: 		Select Case program_set
; 176: 		Case 1  'correction position
	MOVF 0x40,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0042
; 177: 			value = act_pos
	MOVF 0x32,W
	MOVWF 0x37
; 178: 			Gosub i2c_display
	CALL L0006
; 179: 			Gosub calc_rotation
	CALL L0008
; 180: 			Select Case result
; 181: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0043
; 182: 				If new_steps < 60000 Then
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0044
; 183: 					ena = 1  'motor on
	BSF 0x07,2
; 184: 					new_steps = new_steps + 1
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x33
	MOVF 0x34,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x34
; 185: 					direction = 1
	BSF 0x07,0
; 186: 					clk = 1  'clock out
	BSF 0x07,1
; 187: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	CALL W001
; 188: 					clk = 0
	BCF 0x07,1
; 189: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	CALL W001
; 190: 				Endif
L0044:
; 191: 			Case 2
	GOTO L0045
L0043:
	MOVF 0x3C,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0046
; 192: 				If new_steps > 0 Then
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0047
; 193: 					ena = 1  'motor on
	BSF 0x07,2
; 194: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 195: 					direction = 0
	BCF 0x07,0
; 196: 					clk = 1  'clock out
	BSF 0x07,1
; 197: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	CALL W001
; 198: 					clk = 0
	BCF 0x07,1
; 199: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	CALL W001
; 200: 				Endif
L0047:
; 201: 			Case Else
	GOTO L0048
L0046:
; 202: 			EndSelect
L0048:
L0045:
; 203: 		Case 2  'setting of maximum positions
	GOTO L0049
L0042:
	MOVF 0x40,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0050
; 204: 			ena = 0  'shut off motor
	BCF 0x07,2
; 205: 			If max_pos > 60 Then
	MOVF 0x35,W
	SUBLW 0x3C
	BTFSC STATUS,C
	GOTO L0051
; 206: 				max_pos = 60
	MOVLW 0x3C
	MOVWF 0x35
; 207: 			Endif
L0051:
; 208: 			value = max_pos
	MOVF 0x35,W
	MOVWF 0x37
; 209: 			Gosub i2c_display
	CALL L0006
; 210: 			Gosub calc_rotation
	CALL L0008
; 211: 			Select Case result
; 212: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0052
; 213: 				If max_pos < 60 Then  'display is limited to 60
	MOVLW 0x3C
	SUBWF 0x35,W
	BTFSC STATUS,C
	GOTO L0053
; 214: 					max_pos = max_pos + 1
	MOVF 0x35,W
	ADDLW 0x01
	MOVWF 0x35
; 215: 					Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0054:	BTFSC EECON1,WR
	GOTO L0054
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 216: 				Endif
L0053:
; 217: 			Case 2
	GOTO L0055
L0052:
	MOVF 0x3C,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0056
; 218: 				If max_pos > 4 Then
	MOVF 0x35,W
	SUBLW 0x04
	BTFSC STATUS,C
	GOTO L0057
; 219: 					max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x35,W
	MOVWF 0x35
; 220: 					Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0058:	BTFSC EECON1,WR
	GOTO L0058
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 221: 				Endif
L0057:
; 222: 			Case Else
	GOTO L0059
L0056:
; 223: 			EndSelect
L0059:
L0055:
; 224: 		
; 225: 		Case 3  'setting of speed interval
	GOTO L0060
L0050:
	MOVF 0x40,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0061
; 226: 					'setting will be done in multiple of 256 uSecs
; 227: 					'minimum is 2 and maximum is 60 (is real slow)
; 228: 			ena = 0  'shut off motor
	BCF 0x07,2
; 229: 			value = speed.HB
	MOVF 0x31,W
	MOVWF 0x37
; 230: 			If speed.HB > 60 Then
	MOVF 0x31,W
	SUBLW 0x3C
	BTFSC STATUS,C
	GOTO L0062
; 231: 				speed.HB = 60
	MOVLW 0x3C
	MOVWF 0x31
; 232: 				Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0063:	BTFSC EECON1,WR
	GOTO L0063
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 233: 			Endif
L0062:
; 234: 			Gosub i2c_display
	CALL L0006
; 235: 			Gosub calc_rotation
	CALL L0008
; 236: 			Select Case result
; 237: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0064
; 238: 				If speed.HB < 60 Then  'display is limited to 60
	MOVLW 0x3C
	SUBWF 0x31,W
	BTFSC STATUS,C
	GOTO L0065
; 239: 					speed.HB = speed.HB + 1
	MOVF 0x31,W
	ADDLW 0x01
	MOVWF 0x31
; 240: 					Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0066:	BTFSC EECON1,WR
	GOTO L0066
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 241: 				Endif
L0065:
; 242: 			Case 2
	GOTO L0067
L0064:
	MOVF 0x3C,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0068
; 243: 				If speed.HB > 2 Then
	MOVF 0x31,W
	SUBLW 0x02
	BTFSC STATUS,C
	GOTO L0069
; 244: 					speed.HB = speed.HB - 1
	MOVLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 245: 					Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0070:	BTFSC EECON1,WR
	GOTO L0070
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 246: 				Endif
L0069:
; 247: 			Case Else
	GOTO L0071
L0068:
; 248: 			EndSelect
L0071:
L0067:
; 249: 	
; 250: 		Case Else  'setting of extra free space steps
	GOTO L0072
L0061:
; 251: 			ena = 0  'shut off motor
	BCF 0x07,2
; 252: 			If free_space_steps > 250 Then
	MOVF 0x36,W
	SUBLW 0xFA
	BTFSC STATUS,C
	GOTO L0073
; 253: 				free_space_steps = 250
	MOVLW 0xFA
	MOVWF 0x36
; 254: 				Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0074:	BTFSC EECON1,WR
	GOTO L0074
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 255: 			Endif
L0073:
; 256: 			value = free_space_steps
	MOVF 0x36,W
	MOVWF 0x37
; 257: 			Gosub i2c_display
	CALL L0006
; 258: 			Gosub calc_rotation
	CALL L0008
; 259: 			Select Case result
; 260: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0075
; 261: 				If free_space_steps < 60 Then  'display is limited to 60
	MOVLW 0x3C
	SUBWF 0x36,W
	BTFSC STATUS,C
	GOTO L0076
; 262: 					free_space_steps = free_space_steps + 1
	MOVF 0x36,W
	ADDLW 0x01
	MOVWF 0x36
; 263: 					Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0077:	BTFSC EECON1,WR
	GOTO L0077
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 264: 				Endif
L0076:
; 265: 			Case 2
	GOTO L0078
L0075:
	MOVF 0x3C,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0079
; 266: 				If free_space_steps > 0 Then
	MOVF 0x36,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0080
; 267: 					free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x36,W
	MOVWF 0x36
; 268: 					Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0081:	BTFSC EECON1,WR
	GOTO L0081
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 269: 				Endif
L0080:
; 270: 			Case Else
	GOTO L0082
L0079:
; 271: 			EndSelect
L0082:
L0078:
; 272: 		
; 273: 		EndSelect
L0072:
L0060:
L0049:
; 274: 		
; 275: 	Wend
	GOTO L0036
L0037:
; 276: 	ena = 0  'shut off motor
	BCF 0x07,2
; 277: 		'***************   now check if changes have to written in eeprom
; 278: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x38,W
	MOVWF R1L
	MOVF 0x39,W
	MOVWF R1H
	CALL C002
	BTFSS STATUS,Z
	GOTO L0083
; 279: 		Write act_pos, new_steps.LB
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0084:	BTFSC EECON1,WR
	GOTO L0084
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 280: 		eprom_pointer1 = act_pos
	MOVF 0x32,W
	MOVWF 0x3A
; 281: 		eprom_pointer1 = eprom_pointer1 + 60
	MOVF 0x3A,W
	ADDLW 0x3C
	MOVWF 0x3A
; 282: 		Write eprom_pointer1, new_steps.HB
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0085:	BTFSC EECON1,WR
	GOTO L0085
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 283: 		act_steps = new_steps
	MOVF 0x33,W
	MOVWF 0x38
	MOVF 0x34,W
	MOVWF 0x39
; 284: 		Gosub check_next_steps
	CALL L0011
; 285: 	Endif
L0083:
; 286: 	value = act_pos
	MOVF 0x32,W
	MOVWF 0x37
; 287: 	Gosub i2c_display
	CALL L0006
; 288: 	onoff = 1
	BSF 0x47,0
; 289: 	Gosub relays
	CALL L0010
; 290: Return
	RETURN
; 291: 
; 292: steps_reading:
L0004:
; 293: 	eprom_pointer1 = act_pos + 60
	MOVF 0x32,W
	ADDLW 0x3C
	MOVWF 0x3A
; 294: 	Read eprom_pointer1, act_steps.HB
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 295: 	Read act_pos, act_steps.LB
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x38
; 296: 	If new_pos = 0 Then
	MOVF 0x45,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0086
; 297: 		new_steps = 0
	CLRF 0x33
	CLRF 0x34
; 298: 	Else
	GOTO L0087
L0086:
; 299: 		eprom_pointer2 = new_pos + 60
	MOVF 0x45,W
	ADDLW 0x3C
	MOVWF 0x48
; 300: 		Read eprom_pointer2, new_steps.HB
	MOVF 0x48,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 301: 		Read new_pos, new_steps.LB
	MOVF 0x45,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 302: 	Endif
L0087:
; 303: Return
	RETURN
; 304: i2c_convert:
L0005:
; 305: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x3F,W
	SUBLW 0x09
	BTFSS STATUS,C
	GOTO L0088
	CALL L0089
	MOVWF 0x3F
	GOTO L0088
L0089:
	MOVLW 0x03
	MOVWF PCLATH
	MOVF 0x3F,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
L0088:
; 306: 	disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x3F,7
	BTFSS 0x07,7
	BCF 0x3F,7
; 307: 	disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x49,W
	SUBLW 0x0A
	BTFSS STATUS,C
	GOTO L0090
	CALL L0091
	MOVWF 0x49
	GOTO L0090
L0091:
	MOVLW 0x03
	MOVWF PCLATH
	MOVF 0x49,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
L0090:
; 308: 
; 309: Return
	RETURN
; 310: 
; 311: i2c_display:
L0006:
; 312: 	disp1_val = value
	MOVF 0x37,W
	MOVWF 0x3F
; 313: 	disp1_val = disp1_val Mod 10
	MOVF 0x3F,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x3F
; 314: 	disp2_val = value
	MOVF 0x37,W
	MOVWF 0x49
; 315: 	disp2_val = disp2_val / 10
	MOVF 0x49,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x49
; 316: 	Gosub i2c_convert
	CALL L0005
; 317: 	I2CStart
	CALL IC31
; 318: 	I2CSend disp1
	MOVLW 0x40
	CALL IC01
; 319: 	I2CSend disp1_val
	MOVF 0x3F,W
	CALL IC01
; 320: 	I2CStop
	CALL IC41
; 321: 	I2CStart
	CALL IC31
; 322: 	I2CSend disp2
	MOVLW 0x42
	CALL IC01
; 323: 	I2CSend disp2_val
	MOVF 0x49,W
	CALL IC01
; 324: 	I2CStop
	CALL IC41
; 325: Return
	RETURN
; 326: i2c_display_pgm:
L0007:
; 327: 	Select Case program_set
; 328: 	Case 1  'this is program 1 setting max positions
	MOVF 0x40,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0092
; 329: 		disp1_val = %11111001
	MOVLW 0xF9
	MOVWF 0x3F
; 330: 	Case 2  'setting of maximum positions
	GOTO L0093
L0092:
	MOVF 0x40,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0094
; 331: 		disp1_val = %10100100
	MOVLW 0xA4
	MOVWF 0x3F
; 332: 	Case 3  'setting of speed interval
	GOTO L0095
L0094:
	MOVF 0x40,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0096
; 333: 		disp1_val = %10110000
	MOVLW 0xB0
	MOVWF 0x3F
; 334: 	Case Else  'setting of extra free space steps
	GOTO L0097
L0096:
; 335: 		disp1_val = %10011001
	MOVLW 0x99
	MOVWF 0x3F
; 336: 	EndSelect
L0097:
L0095:
L0093:
; 337: 	I2CStart
	CALL IC31
; 338: 	I2CSend disp1
	MOVLW 0x40
	CALL IC01
; 339: 	I2CSend disp1_val
	MOVF 0x3F,W
	CALL IC01
; 340: 	I2CStop
	CALL IC41
; 341: 	I2CStart
	CALL IC31
; 342: 	I2CSend disp2
	MOVLW 0x42
	CALL IC01
; 343: 	I2CSend %10111111
	MOVLW 0xBF
	CALL IC01
; 344: 	I2CStop
	CALL IC41
; 345: Return
	RETURN
; 346: 
; 347: calc_rotation:
L0008:
; 348: '1 = increasing value
; 349: '2 = decreasing value
; 350: '3 = no change
; 351: 		new_encoder = 0
	CLRF 0x43
; 352: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x43,0
	BTFSS 0x07,4
	BCF 0x43,0
; 353: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x43,1
	BTFSS 0x07,5
	BCF 0x43,1
; 354: 		Select Case old_encoder
; 355: 		Case 0
	MOVF 0x4B,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0098
; 356: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x43,W
	SUBLW 0x03
	BTFSS STATUS,C
	GOTO L0099
	CALL L0100
	MOVWF 0x3C
	GOTO L0099
L0100:
	MOVLW 0x03
	MOVWF PCLATH
	MOVF 0x43,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
L0099:
; 357: 		Case 1
	GOTO L0101
L0098:
	MOVF 0x4B,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0102
; 358: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x43,W
	SUBLW 0x03
	BTFSS STATUS,C
	GOTO L0103
	CALL L0104
	MOVWF 0x3C
	GOTO L0103
L0104:
	MOVLW 0x03
	MOVWF PCLATH
	MOVF 0x43,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
L0103:
; 359: 		Case 2
	GOTO L0105
L0102:
	MOVF 0x4B,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0106
; 360: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x43,W
	SUBLW 0x03
	BTFSS STATUS,C
	GOTO L0107
	CALL L0108
	MOVWF 0x3C
	GOTO L0107
L0108:
	MOVLW 0x03
	MOVWF PCLATH
	MOVF 0x43,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
L0107:
; 361: 		Case Else
	GOTO L0109
L0106:
; 362: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x43,W
	SUBLW 0x03
	BTFSS STATUS,C
	GOTO L0110
	CALL L0111
	MOVWF 0x3C
	GOTO L0110
L0111:
	MOVLW 0x03
	MOVWF PCLATH
	MOVF 0x43,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
L0110:
; 363: 		EndSelect
L0109:
L0105:
L0101:
; 364: 		old_encoder = new_encoder
	MOVF 0x43,W
	MOVWF 0x4B
; 365: Return
	RETURN
; 366: 
; 367: stepmotor:
L0009:
; 368: 	speed = 0
	CLRF 0x30
	CLRF 0x31
; 369: 	Read mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 370: 	Read mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 371: 	If new_steps = 0 Then
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C001
	BTFSS STATUS,Z
	GOTO L0112
; 372: 		direction = 0
	BCF 0x07,0
; 373: 		ena = 1  'set anable on
	BSF 0x07,2
; 374: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 375: 		While zero = 1  'turn motor until zero switch is activated
L0113:
	BTFSS 0x07,3
	GOTO L0114
; 376: 			clk = 1  'clock out
	BSF 0x07,1
; 377: 			WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	CALL W001
; 378: 			clk = 0
	BCF 0x07,1
; 379: 			WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	CALL W001
; 380: 		Wend
	GOTO L0113
L0114:
; 381: 		ena = 0  'set anable off
	BCF 0x07,2
; 382: 		act_pos = 0
	CLRF 0x32
; 383: 		Write mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0115:	BTFSC EECON1,WR
	GOTO L0115
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 384: 	Else
	GOTO L0116
L0112:
; 385: 		If new_steps > act_steps Then
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x38,W
	MOVWF R1L
	MOVF 0x39,W
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0117
; 386: 			steps = new_steps - act_steps
	MOVF 0x38,W
	SUBWF 0x33,W
	MOVWF 0x3D
	MOVF 0x39,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x34,W
	MOVWF 0x3E
; 387: 			steps = steps + free_space_steps
	MOVF 0x3D,W
	ADDWF 0x36,W
	MOVWF 0x3D
	MOVF 0x3E,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x3E
; 388: 			direction = 1
	BSF 0x07,0
; 389: 			ena = 1  'set anable on
	BSF 0x07,2
; 390: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 391: 			While steps > 0  'shortest step =500uSec longest step = 5000uSec
L0118:
	MOVF 0x3D,W
	MOVWF R0L
	MOVF 0x3E,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0119
; 392: 				clk = 1  'clock out
	BSF 0x07,1
; 393: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	CALL Y001
; 394: 				clk = 0
	BCF 0x07,1
; 395: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	CALL Y001
; 396: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3E,W
	MOVWF 0x3E
; 397: 			Wend
	GOTO L0118
L0119:
; 398: 			WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 399: 			steps = free_space_steps
	MOVF 0x36,W
	MOVWF 0x3D
	CLRF 0x3E
; 400: 			direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 401: 			While steps > 0  'shortest step =512uSec
L0120:
	MOVF 0x3D,W
	MOVWF R0L
	MOVF 0x3E,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0121
; 402: 				clk = 1  'clock out
	BSF 0x07,1
; 403: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	CALL Y001
; 404: 				clk = 0
	BCF 0x07,1
; 405: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	CALL Y001
; 406: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3E,W
	MOVWF 0x3E
; 407: 			Wend
	GOTO L0120
L0121:
; 408: 			ena = 0  'enable off
	BCF 0x07,2
; 409: 			pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 410: 		Else
	GOTO L0122
L0117:
; 411: 			steps = act_steps - new_steps
	MOVF 0x33,W
	SUBWF 0x38,W
	MOVWF 0x3D
	MOVF 0x34,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x39,W
	MOVWF 0x3E
; 412: 			direction = 0  'go reverse
	BCF 0x07,0
; 413: 			ena = 1  'set anable on
	BSF 0x07,2
; 414: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 415: 			While steps > 0  'shortest step =500uSec longest step = 5000uSec
L0123:
	MOVF 0x3D,W
	MOVWF R0L
	MOVF 0x3E,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0124
; 416: 				clk = 1  'clock out
	BSF 0x07,1
; 417: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	CALL Y001
; 418: 				clk = 0
	BCF 0x07,1
; 419: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	CALL Y001
; 420: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3E,W
	MOVWF 0x3E
; 421: 			Wend
	GOTO L0123
L0124:
; 422: 			ena = 0  'enable off
	BCF 0x07,2
; 423: 			pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 424: 		Endif
L0122:
; 425: 	Endif
L0116:
; 426: 
; 427: Return
	RETURN
; 428: 
; 429: 
; 430: relays:
L0010:
; 431: 	If onoff = 1 Then
	BTFSS 0x47,0
	GOTO L0125
; 432: 		value = max_pos + 1
	MOVF 0x35,W
	ADDLW 0x01
	MOVWF 0x37
; 433: 		value = value / 2  'calulation of half max positions
	MOVF 0x37,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x37
; 434: 		If act_pos > value Then  'select polarity rails on bridge
	MOVF 0x32,W
	SUBWF 0x37,W
	BTFSC STATUS,C
	GOTO L0126
; 435: 			swfw = 0
	BCF 0x06,0
; 436: 			swrev = 1
	BSF 0x06,1
; 437: 		Else
	GOTO L0127
L0126:
; 438: 			swrev = 0
	BCF 0x06,1
; 439: 			swfw = 1
	BSF 0x06,0
; 440: 		Endif
L0127:
; 441: 	Else
	GOTO L0128
L0125:
; 442: 		swfw = 0
	BCF 0x06,0
; 443: 		swrev = 0
	BCF 0x06,1
; 444: 	Endif
L0128:
; 445: Return
	RETURN
; 446: 
; 447: 
; 448: check_next_steps:
L0011:
; 449: 	'this is ment to check all follwowing steps after readjusting one position.
; 450: 	'simply to avoid that i.e. tt will go backwards when set for the next (higher) position.
; 451: 	If act_pos < max_pos Then
	MOVF 0x35,W
	SUBWF 0x32,W
	BTFSC STATUS,C
	GOTO L0129
; 452: 		eprom_pointer1 = act_pos
	MOVF 0x32,W
	MOVWF 0x3A
; 453: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x3A,W
	ADDLW 0x3C
	MOVWF 0x48
; 454: 		For value = act_pos To max_pos
	MOVF 0x32,W
	MOVWF 0x37
L0130:
	MOVF 0x37,W
	SUBWF 0x35,W
	BTFSS STATUS,C
	GOTO L0131
; 455: 			Read eprom_pointer1, act_steps.LB
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x38
; 456: 			Read eprom_pointer1, act_steps.HB
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 457: 			eprom_pointer1 = eprom_pointer1 + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
; 458: 			eprom_pointer2 = eprom_pointer2 + 1
	MOVF 0x48,W
	ADDLW 0x01
	MOVWF 0x48
; 459: 			Read eprom_pointer1, new_steps.LB
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 460: 			Read eprom_pointer2, new_steps.HB
	MOVF 0x48,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 461: 			If new_steps < act_steps Then
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x38,W
	MOVWF R1L
	MOVF 0x39,W
	MOVWF R1H
	CALL C004
	BTFSS STATUS,Z
	GOTO L0132
; 462: 				new_steps = new_steps + 50
	MOVF 0x33,W
	ADDLW 0x32
	MOVWF 0x33
	MOVF 0x34,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x34
; 463: 				Write eprom_pointer1, new_steps.LB
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0133:	BTFSC EECON1,WR
	GOTO L0133
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 464: 				Write eprom_pointer2, new_steps.HB
	MOVF 0x48,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0134:	BTFSC EECON1,WR
	GOTO L0134
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 465: 			Endif
L0132:
; 466: 		Next value
	MOVLW 0x01
	ADDWF 0x37,F
	BTFSS STATUS,C
	GOTO L0130
L0131:
; 467: 	Endif
L0129:
; 468: Return
	RETURN
; 469: 
; 470: 
; 471: init_eeprom:
L0012:
; 472: 	act_steps = 0
	CLRF 0x38
	CLRF 0x39
; 473: 	act_pos = 0
	CLRF 0x32
; 474: 	eprom_pointer1 = 60
	MOVLW 0x3C
	MOVWF 0x3A
; 475: 	For value = 0 To 60
	CLRF 0x37
L0135:
	MOVF 0x37,W
	SUBLW 0x3C
	BTFSS STATUS,C
	GOTO L0136
; 476: 		Write act_pos, act_steps.LB
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0137:	BTFSC EECON1,WR
	GOTO L0137
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 477: 		Write eprom_pointer1, act_steps.HB
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0138:	BTFSC EECON1,WR
	GOTO L0138
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 478: 		act_steps = act_steps + 256
	MOVF 0x38,W
	ADDLW 0x00
	MOVWF 0x38
	MOVF 0x39,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x01
	MOVWF 0x39
; 479: 		act_pos = act_pos + 1
	MOVF 0x32,W
	ADDLW 0x01
	MOVWF 0x32
; 480: 		eprom_pointer1 = eprom_pointer1 + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
; 481: 	Next value
	MOVLW 0x01
	ADDWF 0x37,F
	BTFSS STATUS,C
	GOTO L0135
L0136:
; 482: 	speed = 0
	CLRF 0x30
	CLRF 0x31
; 483: 	speed.HB = 20
	MOVLW 0x14
	MOVWF 0x31
; 484: 	Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0139:	BTFSC EECON1,WR
	GOTO L0139
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 485: 	one_round = 8000
	MOVLW 0x40
	MOVWF 0x41
	MOVLW 0x1F
	MOVWF 0x42
; 486: 	Write 123, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0140:	BTFSC EECON1,WR
	GOTO L0140
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 487: 	Write 124, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0141:	BTFSC EECON1,WR
	GOTO L0141
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 488: 	Write mem_act_pos, 1  'act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x01
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0142:	BTFSC EECON1,WR
	GOTO L0142
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 489: 	Write mem_max_pos, 60  'max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x3C
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0143:	BTFSC EECON1,WR
	GOTO L0143
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 490: 	free_space_steps = 20
	MOVLW 0x14
	MOVWF 0x36
; 491: 	Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0144:	BTFSC EECON1,WR
	GOTO L0144
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 492: 
; 493: Return
	RETURN
; 494: 
; 495: 
; 496: 
; 497: init_values:
L0013:
; 498: encoder_count = 0
	CLRF 0x44
; 499: speed = 0
	CLRF 0x30
	CLRF 0x31
; 500: If eep = 1 Then  'jumper set for imitialisation
	BTFSS 0x06,6
	GOTO L0145
; 501: 	Gosub init_eeprom
	CALL L0012
; 502: Endif
L0145:
; 503: speed = 0
	CLRF 0x30
	CLRF 0x31
; 504: Read mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 505: If speed.HB > 50 Then
	MOVF 0x31,W
	SUBLW 0x32
	BTFSC STATUS,C
	GOTO L0146
; 506: 	speed.HB = 50
	MOVLW 0x32
	MOVWF 0x31
; 507: 	Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0147:	BTFSC EECON1,WR
	GOTO L0147
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 508: Endif
L0146:
; 509: 
; 510: Read 123, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 511: Read 124, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x42
; 512: If one_round = 0 Then
	MOVF 0x41,W
	MOVWF R0L
	MOVF 0x42,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	CALL C001
	BTFSS STATUS,Z
	GOTO L0148
; 513: 	one_round = 8000
	MOVLW 0x40
	MOVWF 0x41
	MOVLW 0x1F
	MOVWF 0x42
; 514: Endif
L0148:
; 515: If one_round > 64000 Then
	MOVF 0x41,W
	MOVWF R0L
	MOVF 0x42,W
	MOVWF R0H
	CLRF R1L
	MOVLW 0xFA
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0149
; 516: 	one_round = 8000
	MOVLW 0x40
	MOVWF 0x41
	MOVLW 0x1F
	MOVWF 0x42
; 517: Endif
L0149:
; 518: one_round_half = one_round / 2
	MOVF 0x41,W
	MOVWF R0L
	MOVF 0x42,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x4D
	MOVF R0H,W
	MOVWF 0x4E
; 519: 
; 520: Read mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x32
; 521: If act_pos > 60 Then
	MOVF 0x32,W
	SUBLW 0x3C
	BTFSC STATUS,C
	GOTO L0150
; 522: 	act_pos = 1
	MOVLW 0x01
	MOVWF 0x32
; 523: 	Write mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0151:	BTFSC EECON1,WR
	GOTO L0151
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 524: Endif
L0150:
; 525: 
; 526: Read mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x35
; 527: If max_pos > 60 Then
	MOVF 0x35,W
	SUBLW 0x3C
	BTFSC STATUS,C
	GOTO L0152
; 528: 	max_pos = 12
	MOVLW 0x0C
	MOVWF 0x35
; 529: 	Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0153:	BTFSC EECON1,WR
	GOTO L0153
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 530: Endif
L0152:
; 531: 
; 532: Read mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 533: If free_space_steps > 60 Then
	MOVF 0x36,W
	SUBLW 0x3C
	BTFSC STATUS,C
	GOTO L0154
; 534: 	free_space_steps = 20
	MOVLW 0x14
	MOVWF 0x36
; 535: 	Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0155:	BTFSC EECON1,WR
	GOTO L0155
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 536: Endif
L0154:
; 537: 
; 538: new_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x45
; 539: bus_pos = PORTA And 63  'cancel first input from MGV50
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x46
; 540: old_bus_pos = bus_pos
	MOVF 0x46,W
	MOVWF 0x4A
; 541: manual_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x3B
; 542: 
; 543: Return
	RETURN
; End of program
L0156:	GOTO L0156
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
