; Compiled with: PIC Simulator IDE v6.90
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_turn_counter' (global) is 0
;       The value of 'mem_act_pos' (global) is 121
;       The value of 'mem_speed' (global) is 122
;       The value of 'mem_one_round_lb' (global) is 123
;       The value of 'mem_one_round_hb' (global) is 124
;       The value of 'mem_ctrl_type' (global) is 125
;       The value of 'mem_max_pos' (global) is 126
;       The value of 'mem_free_space' (global) is 127
;       The address of 'speed' (word) (global) is 0x30
	speed EQU 0x30
;       The address of 'act_pos' (byte) (global) is 0x32
	act_pos EQU 0x32
;       The address of 'new_steps' (word) (global) is 0x33
	new_steps EQU 0x33
;       The address of 'one_round' (word) (global) is 0x35
	one_round EQU 0x35
;       The address of 'max_pos' (byte) (global) is 0x37
	max_pos EQU 0x37
;       The address of 'eprom_pointer1' (byte) (global) is 0x38
	eprom_pointer1 EQU 0x38
;       The address of 'free_space_steps' (byte) (global) is 0x39
	free_space_steps EQU 0x39
;       The address of 'ctrl_type' (byte) (global) is 0x3A
	ctrl_type EQU 0x3A
;       The address of 'value' (byte) (global) is 0x3B
	value EQU 0x3B
;       The address of 'act_steps' (word) (global) is 0x3C
	act_steps EQU 0x3C
;       The address of 'steps' (word) (global) is 0x3E
	steps EQU 0x3E
;       The address of 'result' (byte) (global) is 0x40
	result EQU 0x40
;       The address of 'manual_pos' (byte) (global) is 0x41
	manual_pos EQU 0x41
;       The address of 'turn_counter' (byte) (global) is 0x42
	turn_counter EQU 0x42
;       The address of 'eprom_pointer2' (byte) (global) is 0x43
	eprom_pointer2 EQU 0x43
;       The address of 'program_set' (byte) (global) is 0x44
	program_set EQU 0x44
;       The address of 'disp1_val' (byte) (global) is 0x45
	disp1_val EQU 0x45
;       The address of 'new_encoder' (byte) (global) is 0x46
	new_encoder EQU 0x46
;       The address of 'encoder_count' (byte) (global) is 0x47
	encoder_count EQU 0x47
;       The address of 'bus_pos' (byte) (global) is 0x48
	bus_pos EQU 0x48
;       The address of 'onoff' (bit) (global) is 0x49,0
;       The address of 'new_pos' (byte) (global) is 0x4A
	new_pos EQU 0x4A
;       The address of 'disp2_val' (byte) (global) is 0x4B
	disp2_val EQU 0x4B
;       The address of 'old_bus_pos' (byte) (global) is 0x4C
	old_bus_pos EQU 0x4C
;       The address of 'old_encoder' (byte) (global) is 0x4D
	old_encoder EQU 0x4D
;       The address of 'one_round_half' (word) (global) is 0x4E
	one_round_half EQU 0x4E
;       The address of 'old_manual_pos' (byte) (global) is 0x50
	old_manual_pos EQU 0x50
;       The address of 'ecsw_temp' (bit) (global) is 0x49,1
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'eep' (bit) (global) is 0x6,6
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x7,3
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0013
	ORG 0x0004
	RETFIE
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0013:
; 1: 'program TT for PCBoard MGV145
; 2: 'version V3-1  Fiddle Yard version, for turntables and fiddle yard
; 3: 'this version has all possibilities changeable by menue's.
; 4: Define CONF_WORD = 0x3f72
; 5: Define CLOCK_FREQUENCY = 20
; 6: Dim steps As Word
; 7: Dim program_set As Byte
; 8: Dim new_steps As Word
; 9: Dim act_steps As Word
; 10: Dim new_pos As Byte
; 11: Dim act_pos As Byte
; 12: Dim one_round As Word
; 13: Dim one_round_half As Word
; 14: Dim bus_pos As Byte
; 15: Dim old_bus_pos As Byte
; 16: Dim speed As Word
; 17: Dim new_encoder As Byte
; 18: Dim old_encoder As Byte
; 19: Dim manual_pos As Byte
; 20: Dim old_manual_pos As Byte
; 21: Dim result As Byte
; 22: Dim free_space_steps As Byte
; 23: Dim value As Byte
; 24: Dim eprom_pointer1 As Byte
; 25: Dim eprom_pointer2 As Byte
; 26: Dim encoder_count As Byte
; 27: Dim turn_counter As Byte
; 28: Dim onoff As Bit
; 29: Dim ecsw_temp As Bit
; 30: Dim max_pos As Byte
; 31: Dim disp1_val As Byte
; 32: Dim disp2_val As Byte
; 33: Dim ctrl_type As Byte
; 34: Const disp1 = 64
; 35: Const disp2 = 66
; 36: Const mem_turn_counter = 0
; 37: Const mem_act_pos = 121
; 38: Const mem_speed = 122
; 39: Const mem_one_round_lb = 123
; 40: Const mem_one_round_hb = 124
; 41: Const mem_ctrl_type = 125
; 42: Const mem_max_pos = 126
; 43: Const mem_free_space = 127
; 44: Symbol swfw = RB0
; 45: Symbol swrev = RB1
; 46: Symbol sck = RB2
; 47: Symbol sda = RB3
; 48: Symbol pos_match = RB4
; 49: Symbol pos_write = RB5
; 50: Symbol eep = RB6
; 51: Symbol direction = RC0
; 52: Symbol clk = RC1
; 53: Symbol ena = RC2
; 54: Symbol zero = RC3
; 55: Symbol ec1 = RC4
; 56: Symbol ec2 = RC5
; 57: Symbol ecsw = RC6
; 58: Symbol pgm = RC7
; 59: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 60: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 61: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 62: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 63: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 64: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 65: EEPROM mem_act_pos, 3
; 66: Gosub init_values
	BSF PCLATH,3
	CALL L0012
; 67: value = act_pos
	MOVF 0x32,W
	MOVWF 0x3B
; 68: Gosub i2c_display
	BCF PCLATH,3
	CALL L0004
; 69: onoff = 1
	BSF 0x49,0
; 70: Gosub relays
	BCF PCLATH,3
	CALL L0009
; 71: program_set = 1
	MOVLW 0x01
	MOVWF 0x44
; 72: main:
L0001:
; 73: 	If pgm = 0 Then
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0014
; 74: 		Gosub adjust_settings
	BCF PCLATH,3
	CALL L0003
; 75: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 76: 	Endif
L0014:
; 77: 
; 78: 	Gosub get_new_position
	BCF PCLATH,3
	CALL L0002
; 79: 	If bus_pos <> old_bus_pos Then
	MOVF 0x48,W
	SUBWF 0x4C,W
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0015
; 80: 		onoff = 0
	BCF 0x49,0
; 81: 		Gosub relays
	BCF PCLATH,3
	CALL L0009
; 82: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 83: 		new_pos = bus_pos
	MOVF 0x48,W
	MOVWF 0x4A
; 84: 		old_bus_pos = bus_pos
	MOVF 0x48,W
	MOVWF 0x4C
; 85: 		Gosub steps_reading
	BCF PCLATH,3
	CALL L0007
; 86: 		Gosub stepmotor
	BCF PCLATH,3
	CALL L0008
; 87: 		act_pos = new_pos
	MOVF 0x4A,W
	MOVWF 0x32
; 88: 		Write mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0016:	BTFSC EECON1,WR
	GOTO L0016
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 89: 		value = act_pos
	MOVF 0x32,W
	MOVWF 0x3B
; 90: 		Gosub i2c_display
	BCF PCLATH,3
	CALL L0004
; 91: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 92: 		onoff = 1
	BSF 0x49,0
; 93: 	Else
	BCF PCLATH,3
	GOTO L0017
L0015:
; 94: 		If manual_pos <> old_manual_pos Then
	MOVF 0x41,W
	SUBWF 0x50,W
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0018
; 95: 			onoff = 0
	BCF 0x49,0
; 96: 			Gosub relays
	BCF PCLATH,3
	CALL L0009
; 97: 			pos_match = 1  'indicate not in position
	BSF 0x06,4
; 98: 			old_manual_pos = manual_pos
	MOVF 0x41,W
	MOVWF 0x50
; 99: 			new_pos = manual_pos
	MOVF 0x41,W
	MOVWF 0x4A
; 100: 			Gosub steps_reading
	BCF PCLATH,3
	CALL L0007
; 101: 			Gosub stepmotor
	BCF PCLATH,3
	CALL L0008
; 102: 			act_pos = new_pos
	MOVF 0x4A,W
	MOVWF 0x32
; 103: 			Write mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0019:	BTFSC EECON1,WR
	GOTO L0019
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 104: 			value = act_pos
	MOVF 0x32,W
	MOVWF 0x3B
; 105: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0004
; 106: 			pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 107: 			manual_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x41
; 108: 			old_manual_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x50
; 109: 			onoff = 1
	BSF 0x49,0
; 110: 		Endif
L0018:
; 111: 	Endif
L0017:
; 112: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 113: 	Gosub relays
	BCF PCLATH,3
	CALL L0009
; 114: 	Goto main
	BCF PCLATH,3
	GOTO L0001
; 115: End
	BCF PCLATH,3
L0020:	GOTO L0020
; 116: 
; 117: 
; 118: get_new_position:
L0002:
; 119: 	If pos_write = 0 Then
	BCF PCLATH,3
	BTFSC 0x06,5
	GOTO L0021
; 120: 		bus_pos = PORTA And 63
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x48
; 121: 		If bus_pos > max_pos Then
	MOVF 0x48,W
	SUBWF 0x37,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0022
; 122: 			old_bus_pos = bus_pos  'do not react on illegal value
	MOVF 0x48,W
	MOVWF 0x4C
; 123: 		Endif
L0022:
; 124: 	Endif
L0021:
; 125: 	ecsw_temp = 1
	BSF 0x49,1
; 126: 	While ecsw_temp = 1
L0023:
	BCF PCLATH,3
	BTFSS 0x49,1
	GOTO L0024
; 127: 	'result will now be calculated
; 128: 		ecsw_temp = ecsw And pgm
	CLRW
	BTFSS 0x07,6
	ADDLW 0x01
	BTFSS 0x07,7
	ADDLW 0x01
	BTFSC STATUS,Z
	BSF 0x49,1
	BTFSS STATUS,Z
	BCF 0x49,1
; 129: 		Gosub calc_rotation
	BCF PCLATH,3
	CALL L0006
; 130: 		Select Case result
; 131: 		Case 1
	MOVF 0x40,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0025
; 132: 			If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x47,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0026
; 133: 				encoder_count = encoder_count + 1
	MOVF 0x47,W
	ADDLW 0x01
	MOVWF 0x47
; 134: 			Else
	BCF PCLATH,3
	GOTO L0027
L0026:
; 135: 				encoder_count = 0
	CLRF 0x47
; 136: 				manual_pos = manual_pos + 1
	MOVF 0x41,W
	ADDLW 0x01
	MOVWF 0x41
; 137: 				If manual_pos > max_pos Then
	MOVF 0x41,W
	SUBWF 0x37,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0028
; 138: 					manual_pos = max_pos
	MOVF 0x37,W
	MOVWF 0x41
; 139: 				Endif
L0028:
; 140: 				value = manual_pos
	MOVF 0x41,W
	MOVWF 0x3B
; 141: 				Gosub i2c_display
	BCF PCLATH,3
	CALL L0004
; 142: 			Endif
L0027:
; 143: 		Case 2
	BCF PCLATH,3
	GOTO L0029
L0025:
	MOVF 0x40,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0030
; 144: 			If encoder_count > 0 Then
	MOVF 0x47,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0031
; 145: 				encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x47,W
	MOVWF 0x47
; 146: 			Else
	BCF PCLATH,3
	GOTO L0032
L0031:
; 147: 				encoder_count = 4
	MOVLW 0x04
	MOVWF 0x47
; 148: 				If manual_pos > 0 Then
	MOVF 0x41,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0033
; 149: 					manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x41,W
	MOVWF 0x41
; 150: 				Endif
L0033:
; 151: 				value = manual_pos
	MOVF 0x41,W
	MOVWF 0x3B
; 152: 				Gosub i2c_display
	BCF PCLATH,3
	CALL L0004
; 153: 			Endif
L0032:
; 154: 		Case Else
	BCF PCLATH,3
	GOTO L0034
L0030:
; 155: 		EndSelect
L0034:
L0029:
; 156: 		WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 157: 	Wend
	BCF PCLATH,3
	GOTO L0023
L0024:
; 158: Return
	RETURN
; 159: 
; 160: adjust_settings:
L0003:
; 161: 	onoff = 0
	BCF 0x49,0
; 162: 	Gosub relays
	BCF PCLATH,3
	CALL L0009
; 163: 	Gosub steps_reading
	BCF PCLATH,3
	CALL L0007
; 164: 	Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0005
; 165: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x3C,W
	MOVWF 0x33
	MOVF 0x3D,W
	MOVWF 0x34
; 166: 	Read mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 167: 	Read mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 168: 	Read mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 169: 	Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0005
; 170: 	WaitMs 1500  'give some time for display to be read
	MOVLW 0xDC
	MOVWF R0L
	MOVLW 0x05
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 171: 	While pgm = 0
L0035:
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0036
; 172: 		If ecsw = 0 Then  'knob is pressed, adjust max positions
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0037
; 173: 			program_set = program_set + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
; 174: 			If program_set > 5 Then
	MOVF 0x44,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0038
; 175: 				program_set = 1
	MOVLW 0x01
	MOVWF 0x44
; 176: 			Endif
L0038:
; 177: 			Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0005
; 178: 			WaitMs 1500  'give some time for display to be read
	MOVLW 0xDC
	MOVWF R0L
	MOVLW 0x05
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 179: 			While ecsw = 0  'be sure pushbutton is released
L0039:
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0040
; 180: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 181: 			Wend
	BCF PCLATH,3
	GOTO L0039
L0040:
; 182: 		Endif
L0037:
; 183: 		Select Case program_set
; 184: 		Case 1  'correction position
	MOVF 0x44,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0041
; 185: 			value = act_pos
	MOVF 0x32,W
	MOVWF 0x3B
; 186: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0004
; 187: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0006
; 188: 			Select Case result
; 189: 			Case 1
	MOVF 0x40,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0042
; 190: 				If new_steps < 60000 Then
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0043
; 191: 					ena = 1  'motor on
	BSF 0x07,2
; 192: 					new_steps = new_steps + 1
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x33
	MOVF 0x34,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x34
; 193: 					direction = 1
	BSF 0x07,0
; 194: 					clk = 1  'clock out
	BSF 0x07,1
; 195: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 196: 					clk = 0
	BCF 0x07,1
; 197: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 198: 				Endif
L0043:
; 199: 			Case 2
	BCF PCLATH,3
	GOTO L0044
L0042:
	MOVF 0x40,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0045
; 200: 				If new_steps > 0 Then
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0046
; 201: 					ena = 1  'motor on
	BSF 0x07,2
; 202: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 203: 					direction = 0
	BCF 0x07,0
; 204: 					clk = 1  'clock out
	BSF 0x07,1
; 205: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 206: 					clk = 0
	BCF 0x07,1
; 207: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 208: 				Endif
L0046:
; 209: 			Case Else
	BCF PCLATH,3
	GOTO L0047
L0045:
; 210: 			EndSelect
L0047:
L0044:
; 211: 		Case 2  'setting of maximum positions
	BCF PCLATH,3
	GOTO L0048
L0041:
	MOVF 0x44,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0049
; 212: 			ena = 0  'shut off motor
	BCF 0x07,2
; 213: 			If max_pos > 60 Then
	MOVF 0x37,W
	SUBLW 0x3C
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0050
; 214: 				max_pos = 60
	MOVLW 0x3C
	MOVWF 0x37
; 215: 			Endif
L0050:
; 216: 			value = max_pos
	MOVF 0x37,W
	MOVWF 0x3B
; 217: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0004
; 218: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0006
; 219: 			Select Case result
; 220: 			Case 1
	MOVF 0x40,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0051
; 221: 				If max_pos < 60 Then  'display is limited to 60
	MOVLW 0x3C
	SUBWF 0x37,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0052
; 222: 					max_pos = max_pos + 1
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x37
; 223: 					Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0053:	BTFSC EECON1,WR
	GOTO L0053
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 224: 				Endif
L0052:
; 225: 			Case 2
	BCF PCLATH,3
	GOTO L0054
L0051:
	MOVF 0x40,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0055
; 226: 				If max_pos > 4 Then
	MOVF 0x37,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0056
; 227: 					max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x37,W
	MOVWF 0x37
; 228: 					Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0057:	BTFSC EECON1,WR
	GOTO L0057
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 229: 				Endif
L0056:
; 230: 			Case Else
	BCF PCLATH,3
	GOTO L0058
L0055:
; 231: 			EndSelect
L0058:
L0054:
; 232: 		
; 233: 		Case 3  'setting of speed interval
	BCF PCLATH,3
	GOTO L0059
L0049:
	MOVF 0x44,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0060
; 234: 					'setting will be done in multiple of 256 uSecs
; 235: 					'minimum is 2 and maximum is 60 (is real slow)
; 236: 			ena = 0  'shut off motor
	BCF 0x07,2
; 237: 			If speed.HB > 60 Then
	MOVF 0x31,W
	SUBLW 0x3C
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0061
; 238: 				speed.HB = 60
	MOVLW 0x3C
	MOVWF 0x31
; 239: 				Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0062:	BTFSC EECON1,WR
	GOTO L0062
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 240: 			Endif
L0061:
; 241: 			value = speed.HB
	MOVF 0x31,W
	MOVWF 0x3B
; 242: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0004
; 243: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0006
; 244: 			Select Case result
; 245: 			Case 1
	MOVF 0x40,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0063
; 246: 				If speed.HB < 100 Then  'display is limited to 100
	MOVLW 0x64
	SUBWF 0x31,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0064
; 247: 					speed.HB = speed.HB + 1
	MOVF 0x31,W
	ADDLW 0x01
	MOVWF 0x31
; 248: 					Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0065:	BTFSC EECON1,WR
	GOTO L0065
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 249: 				Endif
L0064:
; 250: 			Case 2
	BCF PCLATH,3
	GOTO L0066
L0063:
	MOVF 0x40,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0067
; 251: 				If speed.HB > 2 Then
	MOVF 0x31,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0068
; 252: 					speed.HB = speed.HB - 1
	MOVLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 253: 					Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0069:	BTFSC EECON1,WR
	GOTO L0069
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 254: 				Endif
L0068:
; 255: 			Case Else
	BCF PCLATH,3
	GOTO L0070
L0067:
; 256: 			EndSelect
L0070:
L0066:
; 257: 	
; 258: 		Case 4  'setting of extra free space steps
	BCF PCLATH,3
	GOTO L0071
L0060:
	MOVF 0x44,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0072
; 259: 			ena = 0  'shut off motor
	BCF 0x07,2
; 260: 			If free_space_steps > 250 Then
	MOVF 0x39,W
	SUBLW 0xFA
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0073
; 261: 				free_space_steps = 250
	MOVLW 0xFA
	MOVWF 0x39
; 262: 				Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0074:	BTFSC EECON1,WR
	GOTO L0074
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 263: 			Endif
L0073:
; 264: 			value = free_space_steps
	MOVF 0x39,W
	MOVWF 0x3B
; 265: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0004
; 266: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0006
; 267: 			Select Case result
; 268: 			Case 1
	MOVF 0x40,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0075
; 269: 				If free_space_steps < 60 Then  'display is limited to 60
	MOVLW 0x3C
	SUBWF 0x39,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0076
; 270: 					free_space_steps = free_space_steps + 1
	MOVF 0x39,W
	ADDLW 0x01
	MOVWF 0x39
; 271: 					Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0077:	BTFSC EECON1,WR
	GOTO L0077
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 272: 				Endif
L0076:
; 273: 			Case 2
	BCF PCLATH,3
	GOTO L0078
L0075:
	MOVF 0x40,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0079
; 274: 				If free_space_steps > 0 Then
	MOVF 0x39,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0080
; 275: 					free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x39,W
	MOVWF 0x39
; 276: 					Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0081:	BTFSC EECON1,WR
	GOTO L0081
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 277: 				Endif
L0080:
; 278: 			Case Else
	BCF PCLATH,3
	GOTO L0082
L0079:
; 279: 			EndSelect
L0082:
L0078:
; 280: 		Case Else  'setting of control type
	BCF PCLATH,3
	GOTO L0083
L0072:
; 281: 			ena = 0  'shut off motor
	BCF 0x07,2
; 282: 			If ctrl_type > 3 Then
	MOVF 0x3A,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0084
; 283: 				ctrl_type = 0
	CLRF 0x3A
; 284: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0085:	BTFSC EECON1,WR
	GOTO L0085
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 285: 			Endif
L0084:
; 286: 			value = ctrl_type
	MOVF 0x3A,W
	MOVWF 0x3B
; 287: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0004
; 288: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0006
; 289: 			Select Case result
; 290: 			Case 1
	MOVF 0x40,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0086
; 291: 				If ctrl_type < 3 Then  'display is limited to 60
	MOVLW 0x03
	SUBWF 0x3A,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0087
; 292: 					ctrl_type = ctrl_type + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
; 293: 					Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0088:	BTFSC EECON1,WR
	GOTO L0088
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 294: 				Endif
L0087:
; 295: 			Case 2
	BCF PCLATH,3
	GOTO L0089
L0086:
	MOVF 0x40,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0090
; 296: 				If ctrl_type > 0 Then
	MOVF 0x3A,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0091
; 297: 					ctrl_type = ctrl_type - 1
	MOVLW 0x01
	SUBWF 0x3A,W
	MOVWF 0x3A
; 298: 					Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0092:	BTFSC EECON1,WR
	GOTO L0092
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 299: 				Endif
L0091:
; 300: 			Case Else
	BCF PCLATH,3
	GOTO L0093
L0090:
; 301: 			EndSelect
L0093:
L0089:
; 302: 						
; 303: 		EndSelect
L0083:
L0071:
L0059:
L0048:
; 304: 		
; 305: 	Wend
	BCF PCLATH,3
	GOTO L0035
L0036:
; 306: 	ena = 0  'shut off motor
	BCF 0x07,2
; 307: 		'***************   now check if changes have to written in eeprom
; 308: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x3C,W
	MOVWF R1L
	MOVF 0x3D,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C002
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0094
; 309: 		Write act_pos, new_steps.LB
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0095:	BTFSC EECON1,WR
	GOTO L0095
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 310: 		eprom_pointer1 = act_pos
	MOVF 0x32,W
	MOVWF 0x38
; 311: 		eprom_pointer1 = eprom_pointer1 + 60
	MOVF 0x38,W
	ADDLW 0x3C
	MOVWF 0x38
; 312: 		Write eprom_pointer1, new_steps.HB
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0096:	BTFSC EECON1,WR
	GOTO L0096
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 313: 		act_steps = new_steps
	MOVF 0x33,W
	MOVWF 0x3C
	MOVF 0x34,W
	MOVWF 0x3D
; 314: 		Gosub check_next_steps
	BCF PCLATH,3
	CALL L0010
; 315: 	Endif
L0094:
; 316: 	value = act_pos
	MOVF 0x32,W
	MOVWF 0x3B
; 317: 	Gosub i2c_display
	BCF PCLATH,3
	CALL L0004
; 318: 	onoff = 1
	BSF 0x49,0
; 319: 	Gosub relays
	BCF PCLATH,3
	CALL L0009
; 320: Return
	RETURN
; 321: 
; 322: i2c_display:
L0004:
; 323: 	disp1_val = value
	MOVF 0x3B,W
	MOVWF 0x45
; 324: 	disp1_val = disp1_val Mod 10
	MOVF 0x45,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x45
; 325: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x45,W
	SUBLW 0x09
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0097
	BCF PCLATH,3
	CALL L0098
	MOVWF 0x45
	BCF PCLATH,3
	GOTO L0097
L0098:
	MOVLW 0x04
	MOVWF PCLATH
	MOVF 0x45,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
L0097:
; 326: 	disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x45,7
	BTFSS 0x07,7
	BCF 0x45,7
; 327: 	disp2_val = value
	MOVF 0x3B,W
	MOVWF 0x4B
; 328: 	disp2_val = disp2_val / 10
	MOVF 0x4B,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4B
; 329: 	disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x4B,W
	SUBLW 0x0A
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0099
	BCF PCLATH,3
	CALL L0100
	MOVWF 0x4B
	BCF PCLATH,3
	GOTO L0099
L0100:
	MOVLW 0x04
	MOVWF PCLATH
	MOVF 0x4B,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
L0099:
; 330: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 331: 	I2CSend disp1
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 332: 	I2CSend disp1_val
	BCF PCLATH,3
	MOVF 0x45,W
	CALL IC01
; 333: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 334: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 335: 	I2CSend disp2
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 336: 	I2CSend disp2_val
	BCF PCLATH,3
	MOVF 0x4B,W
	CALL IC01
; 337: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 338: Return
	RETURN
; 339: 
; 340: i2c_display_pgm:
L0005:
; 341: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010), program_set
	MOVF 0x44,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0101
	BCF PCLATH,3
	CALL L0102
	MOVWF 0x45
	BCF PCLATH,3
	GOTO L0101
L0102:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x44,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
L0101:
; 342: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 343: 	I2CSend disp1
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 344: 	I2CSend disp1_val
	BCF PCLATH,3
	MOVF 0x45,W
	CALL IC01
; 345: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 346: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 347: 	I2CSend disp2
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 348: 	I2CSend %10111111
	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 349: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 350: Return
	RETURN
; 351: 
; 352: calc_rotation:
L0006:
; 353: '1 = increasing value
; 354: '2 = decreasing value
; 355: '3 = no change
; 356: 		new_encoder = 0
	CLRF 0x46
; 357: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x46,0
	BTFSS 0x07,4
	BCF 0x46,0
; 358: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x46,1
	BTFSS 0x07,5
	BCF 0x46,1
; 359: 		Select Case old_encoder
; 360: 		Case 0
	MOVF 0x4D,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0103
; 361: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x46,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0104
	BCF PCLATH,3
	CALL L0105
	MOVWF 0x40
	BCF PCLATH,3
	GOTO L0104
L0105:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x46,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
L0104:
; 362: 		Case 1
	BCF PCLATH,3
	GOTO L0106
L0103:
	MOVF 0x4D,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0107
; 363: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x46,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0108
	BCF PCLATH,3
	CALL L0109
	MOVWF 0x40
	BCF PCLATH,3
	GOTO L0108
L0109:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x46,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
L0108:
; 364: 		Case 2
	BCF PCLATH,3
	GOTO L0110
L0107:
	MOVF 0x4D,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0111
; 365: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x46,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0112
	BCF PCLATH,3
	CALL L0113
	MOVWF 0x40
	BCF PCLATH,3
	GOTO L0112
L0113:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x46,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
L0112:
; 366: 		Case Else
	BCF PCLATH,3
	GOTO L0114
L0111:
; 367: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x46,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0115
	BCF PCLATH,3
	CALL L0116
	MOVWF 0x40
	BCF PCLATH,3
	GOTO L0115
L0116:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x46,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
L0115:
; 368: 		EndSelect
L0114:
L0110:
L0106:
; 369: 		old_encoder = new_encoder
	MOVF 0x46,W
	MOVWF 0x4D
; 370: Return
	RETURN
; 371: 
; 372: steps_reading:
L0007:
; 373: 	If act_pos = 0 Then
	MOVF 0x32,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0117
; 374: 		act_steps = 0
	CLRF 0x3C
	CLRF 0x3D
; 375: 	Else
	BCF PCLATH,3
	GOTO L0118
L0117:
; 376: 		eprom_pointer1 = act_pos
	MOVF 0x32,W
	MOVWF 0x38
; 377: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x38,W
	ADDLW 0x3C
	MOVWF 0x43
; 378: 		Read eprom_pointer1, act_steps.LB
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3C
; 379: 		Read eprom_pointer2, act_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3D
; 380: 	Endif
L0118:
; 381: 	If new_pos = 0 Then
	MOVF 0x4A,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0119
; 382: 		new_steps = 0
	CLRF 0x33
	CLRF 0x34
; 383: 	Else
	BCF PCLATH,3
	GOTO L0120
L0119:
; 384: 		eprom_pointer1 = new_pos
	MOVF 0x4A,W
	MOVWF 0x38
; 385: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x38,W
	ADDLW 0x3C
	MOVWF 0x43
; 386: 		Read eprom_pointer1, new_steps.LB
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 387: 		Read eprom_pointer2, new_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 388: 	Endif
L0120:
; 389: Return
	RETURN
; 390: 
; 391: stepmotor:
L0008:
; 392: 	speed = 0
	CLRF 0x30
	CLRF 0x31
; 393: 	Read mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 394: 	Read mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 395: 	If new_steps = 0 Then
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C001
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0121
; 396: 		direction = 0
	BCF 0x07,0
; 397: 		ena = 1  'set anable on
	BSF 0x07,2
; 398: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 399: 		While zero = 1  'turn motor until zero switch is activated
L0122:
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0123
; 400: 			clk = 1  'clock out
	BSF 0x07,1
; 401: 			WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 402: 			clk = 0
	BCF 0x07,1
; 403: 			WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 404: 		Wend
	BCF PCLATH,3
	GOTO L0122
L0123:
; 405: 		act_pos = 0
	CLRF 0x32
; 406: 		Write mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0124:	BTFSC EECON1,WR
	GOTO L0124
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 407: 		If ctrl_type > 1 Then  'NOW GO ONE MORE COMPLETE ROUND FOR COUNTING STEPS
	MOVF 0x3A,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0125
; 408: 			one_round = 0
	CLRF 0x35
	CLRF 0x36
; 409: 			ena = 1  'set anable on
	BSF 0x07,2
; 410: 			While zero = 0  'turn motor until zero switch is activated
L0126:
	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0127
; 411: 				clk = 1  'clock out
	BSF 0x07,1
; 412: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 413: 				clk = 0
	BCF 0x07,1
; 414: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 415: 				one_round = one_round + 1
	MOVF 0x35,W
	ADDLW 0x01
	MOVWF 0x35
	MOVF 0x36,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x36
; 416: 			Wend
	BCF PCLATH,3
	GOTO L0126
L0127:
; 417: 			While zero = 1  'turn motor until zero switch is activated
L0128:
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0129
; 418: 				clk = 1  'clock out
	BSF 0x07,1
; 419: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 420: 				clk = 0
	BCF 0x07,1
; 421: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 422: 				one_round = one_round + 1
	MOVF 0x35,W
	ADDLW 0x01
	MOVWF 0x35
	MOVF 0x36,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x36
; 423: 			Wend
	BCF PCLATH,3
	GOTO L0128
L0129:
; 424: 			one_round_half = one_round / 2
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4E
	MOVF R0H,W
	MOVWF 0x4F
; 425: 			Write mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0130:	BTFSC EECON1,WR
	GOTO L0130
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 426: 			Write mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0131:	BTFSC EECON1,WR
	GOTO L0131
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 427: 		Endif
L0125:
; 428: 		ena = 0  'set anable off
	BCF 0x07,2
; 429: 	Else
	BCF PCLATH,3
	GOTO L0132
L0121:
; 430: 		steps = 0
	CLRF 0x3E
	CLRF 0x3F
; 431: 		If new_steps > act_steps Then
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x3C,W
	MOVWF R1L
	MOVF 0x3D,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0133
; 432: 			steps = new_steps - act_steps
	MOVF 0x3C,W
	SUBWF 0x33,W
	MOVWF 0x3E
	MOVF 0x3D,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x34,W
	MOVWF 0x3F
; 433: 			direction = 1
	BSF 0x07,0
; 434: 			If steps > one_round_half Then
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVF 0x4E,W
	MOVWF R1L
	MOVF 0x4F,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0134
; 435: 				Read mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x42
; 436: 				If turn_counter > 126 Then  'check if shortest way is allowed
	MOVF 0x42,W
	SUBLW 0x7E
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0135
; 437: 					turn_counter = turn_counter - 1  'yes it is, so substract one pass
	MOVLW 0x01
	SUBWF 0x42,W
	MOVWF 0x42
; 438: 					steps = one_round - steps  'go shortest way
	MOVF 0x3E,W
	SUBWF 0x35,W
	MOVWF 0x3E
	MOVF 0x3F,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x36,W
	MOVWF 0x3F
; 439: 					direction = 0  'change  direction
	BCF 0x07,0
; 440: 					Write mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0136:	BTFSC EECON1,WR
	GOTO L0136
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 441: 				Endif
L0135:
; 442: 			Endif
L0134:
; 443: 		Else
	BCF PCLATH,3
	GOTO L0137
L0133:
; 444: 			steps = act_steps - new_steps
	MOVF 0x33,W
	SUBWF 0x3C,W
	MOVWF 0x3E
	MOVF 0x34,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3F
; 445: 			direction = 0
	BCF 0x07,0
; 446: 			If steps > one_round_half Then
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVF 0x4E,W
	MOVWF R1L
	MOVF 0x4F,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0138
; 447: 				Read mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x42
; 448: 				If turn_counter < 130 Then  'check if shortest way is allowed
	MOVLW 0x82
	SUBWF 0x42,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0139
; 449: 					turn_counter = turn_counter + 1  'yes it is, so add one pass
	MOVF 0x42,W
	ADDLW 0x01
	MOVWF 0x42
; 450: 					steps = one_round - steps  'go shortest way
	MOVF 0x3E,W
	SUBWF 0x35,W
	MOVWF 0x3E
	MOVF 0x3F,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x36,W
	MOVWF 0x3F
; 451: 					direction = 1  'change direction
	BSF 0x07,0
; 452: 					Write mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0140:	BTFSC EECON1,WR
	GOTO L0140
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 453: 				Endif
L0139:
; 454: 			Endif
L0138:
; 455: 		Endif
L0137:
; 456: 		If steps > 0 Then  'tt must be activated
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0141
; 457: 			If direction = 1 Then
	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0142
; 458: 				steps = steps + free_space_steps
	MOVF 0x3E,W
	ADDWF 0x39,W
	MOVWF 0x3E
	MOVF 0x3F,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x3F
; 459: 			Endif
L0142:
; 460: 			ena = 1  'set anable on
	BSF 0x07,2
; 461: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 462: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0143:
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0144
; 463: 				clk = 1  'clock out
	BSF 0x07,1
; 464: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 465: 				clk = 0
	BCF 0x07,1
; 466: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 467: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x3E,W
	MOVWF 0x3E
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x3F
; 468: 			Wend
	BCF PCLATH,3
	GOTO L0143
L0144:
; 469: 			WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 470: 			If direction = 1 Then
	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0145
; 471: 				steps = free_space_steps
	MOVF 0x39,W
	MOVWF 0x3E
	CLRF 0x3F
; 472: 				direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 473: 				While steps > 0  'NOW RUN UNTIL STEPS = 0
L0146:
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0147
; 474: 					clk = 1  'clock out
	BSF 0x07,1
; 475: 					WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 476: 					clk = 0
	BCF 0x07,1
; 477: 					WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 478: 					steps = steps - 1
	MOVLW 0x01
	SUBWF 0x3E,W
	MOVWF 0x3E
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x3F
; 479: 				Wend
	BCF PCLATH,3
	GOTO L0146
L0147:
; 480: 			Endif
L0145:
; 481: 			ena = 0  'enable off
	BCF 0x07,2
; 482: 			pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 483: 		Endif
L0141:
; 484: 	Endif
L0132:
; 485: Return
	RETURN
; 486: 
; 487: 
; 488: relays:
L0009:
; 489: 	If onoff = 1 Then
	BCF PCLATH,3
	BTFSS 0x49,0
	GOTO L0148
; 490: 		value = max_pos + 1
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x3B
; 491: 		value = value / 2  'calulation of half max positions
	MOVF 0x3B,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x3B
; 492: 		Select Case ctrl_type
; 493: 		Case 1, 3
	MOVF 0x3A,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0151
	BCF PCLATH,3
	GOTO L0150
L0151:
	MOVF 0x3A,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0149
L0150:
; 494: 			swfw = 1
	BSF 0x06,0
; 495: 			swrev = 0
	BCF 0x06,1
; 496: 		Case Else
	BCF PCLATH,3
	GOTO L0152
L0149:
; 497: 			If act_pos > value Then  'select polarity rails on bridge
	MOVF 0x32,W
	SUBWF 0x3B,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0153
; 498: 				swfw = 0
	BCF 0x06,0
; 499: 				swrev = 1
	BSF 0x06,1
; 500: 			Else
	BCF PCLATH,3
	GOTO L0154
L0153:
; 501: 				swrev = 0
	BCF 0x06,1
; 502: 				swfw = 1
	BSF 0x06,0
; 503: 			Endif
L0154:
; 504: 		EndSelect
L0152:
; 505: 	Else
	BCF PCLATH,3
	GOTO L0155
L0148:
; 506: 		swfw = 0
	BCF 0x06,0
; 507: 		swrev = 0
	BCF 0x06,1
; 508: 	Endif
L0155:
; 509: Return
	RETURN
; 510: 
; 511: 
; 512: check_next_steps:
L0010:
; 513: 	'this is ment to check all follwowing steps after readjusting one position.
; 514: 	'simply to avoid that i.e. tt will go backwards when set for the next (higher) position.
; 515: 	If act_pos < max_pos Then
	MOVF 0x37,W
	SUBWF 0x32,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0156
; 516: 		eprom_pointer1 = act_pos
	MOVF 0x32,W
	MOVWF 0x38
; 517: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x38,W
	ADDLW 0x3C
	MOVWF 0x43
; 518: 		For value = act_pos To max_pos
	MOVF 0x32,W
	MOVWF 0x3B
L0157:
	MOVF 0x3B,W
	SUBWF 0x37,W
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0158
; 519: 			Read eprom_pointer1, act_steps.LB
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3C
; 520: 			Read eprom_pointer1, act_steps.HB
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3D
; 521: 			eprom_pointer1 = eprom_pointer1 + 1
	MOVF 0x38,W
	ADDLW 0x01
	MOVWF 0x38
; 522: 			eprom_pointer2 = eprom_pointer2 + 1
	MOVF 0x43,W
	ADDLW 0x01
	MOVWF 0x43
; 523: 			Read eprom_pointer1, new_steps.LB
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 524: 			Read eprom_pointer2, new_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 525: 			If new_steps < act_steps Then
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x3C,W
	MOVWF R1L
	MOVF 0x3D,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0159
; 526: 				new_steps = new_steps + 50
	MOVF 0x33,W
	ADDLW 0x32
	MOVWF 0x33
	MOVF 0x34,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x34
; 527: 				Write eprom_pointer1, new_steps.LB
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0160:	BTFSC EECON1,WR
	GOTO L0160
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 528: 				Write eprom_pointer2, new_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0161:	BTFSC EECON1,WR
	GOTO L0161
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 529: 			Endif
L0159:
; 530: 		Next value
	MOVLW 0x01
	ADDWF 0x3B,F
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0157
L0158:
; 531: 	Endif
L0156:
; 532: Return
	RETURN
; 533: 
; 534: 
; 535: init_eeprom:
L0011:
; 536: 	act_steps = 0
	CLRF 0x3C
	CLRF 0x3D
; 537: 	act_pos = 1
	MOVLW 0x01
	MOVWF 0x32
; 538: 	For eprom_pointer1 = 1 To 60
	MOVLW 0x01
	MOVWF 0x38
L0162:
	MOVF 0x38,W
	SUBLW 0x3C
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0163
; 539: 		act_steps = act_steps + 132
	MOVF 0x3C,W
	ADDLW 0x84
	MOVWF 0x3C
	MOVF 0x3D,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3D
; 540: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x38,W
	ADDLW 0x3C
	MOVWF 0x43
; 541: 		Write eprom_pointer1, act_steps.LB
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0164:	BTFSC EECON1,WR
	GOTO L0164
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 542: 		Write eprom_pointer2, act_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0165:	BTFSC EECON1,WR
	GOTO L0165
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 543: 	Next eprom_pointer1
	MOVLW 0x01
	ADDWF 0x38,F
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0162
L0163:
; 544: 
; 545: 	speed = 20 * 256
	MOVLW 0x14
	MOVWF R3L
	CLRF R3H
	CLRF R1L
	MOVLW 0x01
	MOVWF R1H
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x30
	MOVF R2H,W
	MOVWF 0x31
; 546: 	one_round = 8000
	MOVLW 0x40
	MOVWF 0x35
	MOVLW 0x1F
	MOVWF 0x36
; 547: 	Write mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0166:	BTFSC EECON1,WR
	GOTO L0166
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 548: 	Write mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0167:	BTFSC EECON1,WR
	GOTO L0167
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 549: 	Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0168:	BTFSC EECON1,WR
	GOTO L0168
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 550: 	Write mem_act_pos, 1  'act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x01
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0169:	BTFSC EECON1,WR
	GOTO L0169
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 551: 	Write mem_max_pos, 12  'max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x0C
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0170:	BTFSC EECON1,WR
	GOTO L0170
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 552: 	free_space_steps = 20
	MOVLW 0x14
	MOVWF 0x39
; 553: 	Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0171:	BTFSC EECON1,WR
	GOTO L0171
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 554: 	ctrl_type = 0
	CLRF 0x3A
; 555: 	Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0172:	BTFSC EECON1,WR
	GOTO L0172
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 556: 	turn_counter = 128
	MOVLW 0x80
	MOVWF 0x42
; 557: 	Write mem_turn_counter, turn_counter  'this for the wires to the bridge >> not too many turnings
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0173:	BTFSC EECON1,WR
	GOTO L0173
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 558: Return
	RETURN
; 559: 
; 560: init_values:
L0012:
; 561: 
; 562: 	encoder_count = 0
	CLRF 0x47
; 563: 	speed = 0
	CLRF 0x30
	CLRF 0x31
; 564: 	If eep = 1 Then  'jumper set for imitialisation
	BSF PCLATH,3
	BTFSS 0x06,6
	GOTO L0174
; 565: 		Gosub init_eeprom
	BSF PCLATH,3
	CALL L0011
; 566: 	Endif
L0174:
; 567: 	speed = 0
	CLRF 0x30
	CLRF 0x31
; 568: 	Read mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 569: 	If speed.HB > 100 Then
	MOVF 0x31,W
	SUBLW 0x64
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0175
; 570: 		speed.HB = 100
	MOVLW 0x64
	MOVWF 0x31
; 571: 		Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0176:	BTFSC EECON1,WR
	GOTO L0176
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 572: 	Endif
L0175:
; 573: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x35
; 574: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 575: 	If one_round = 0 Then
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C001
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0177
; 576: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x35
	MOVLW 0x1F
	MOVWF 0x36
; 577: 		Write mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0178:	BTFSC EECON1,WR
	GOTO L0178
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 578: 		Write mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0179:	BTFSC EECON1,WR
	GOTO L0179
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 579: 	Endif
L0177:
; 580: 	If one_round > 64000 Then
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	CLRF R1L
	MOVLW 0xFA
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0180
; 581: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x35
	MOVLW 0x1F
	MOVWF 0x36
; 582: 		Write mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0181:	BTFSC EECON1,WR
	GOTO L0181
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 583: 		Write mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0182:	BTFSC EECON1,WR
	GOTO L0182
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 584: 	Endif
L0180:
; 585: 	one_round_half = one_round / 2
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4E
	MOVF R0H,W
	MOVWF 0x4F
; 586: 	Read mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 587: 	If max_pos > 60 Then
	MOVF 0x37,W
	SUBLW 0x3C
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0183
; 588: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x37
; 589: 		Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0184:	BTFSC EECON1,WR
	GOTO L0184
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 590: 	Endif
L0183:
; 591: 	Read mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x32
; 592: 	If act_pos > max_pos Then
	MOVF 0x32,W
	SUBWF 0x37,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0185
; 593: 		act_pos = 1
	MOVLW 0x01
	MOVWF 0x32
; 594: 		Write mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0186:	BTFSC EECON1,WR
	GOTO L0186
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 595: 	Endif
L0185:
; 596: 	Read mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 597: 	If free_space_steps > 60 Then
	MOVF 0x39,W
	SUBLW 0x3C
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0187
; 598: 		free_space_steps = 20
	MOVLW 0x14
	MOVWF 0x39
; 599: 		Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0188:	BTFSC EECON1,WR
	GOTO L0188
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 600: 	Endif
L0187:
; 601: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3A
; 602: 	If ctrl_type > 3 Then
	MOVF 0x3A,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0189
; 603: 		ctrl_type = 0
	CLRF 0x3A
; 604: 		Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0190:	BTFSC EECON1,WR
	GOTO L0190
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 605: 	Endif
L0189:
; 606: 	new_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x4A
; 607: 	bus_pos = PORTA And 63  'cancel first input from MGV50
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x48
; 608: 	old_bus_pos = bus_pos
	MOVF 0x48,W
	MOVWF 0x4C
; 609: 	manual_pos = act_pos
	MOVF 0x32,W
	MOVWF 0x41
; 610: Return
	RETURN
; End of program
	BSF PCLATH,3
L0191:	GOTO L0191
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; EEPROM data
	ORG 0x2100
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0xFF
	DW 0x03
; End of listing
	END
