; Compiled with: PIC Simulator IDE v6.90
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_turn_counter' (global) is 0
;       The value of 'mem_act_pos' (global) is 121
;       The value of 'mem_speed' (global) is 122
;       The value of 'mem_one_round_lb' (global) is 123
;       The value of 'mem_one_round_hb' (global) is 124
;       The value of 'mem_ctrl_type' (global) is 125
;       The value of 'mem_max_pos' (global) is 126
;       The value of 'mem_free_space' (global) is 127
;       The address of 'speed' (word) (global) is 0x30
	speed EQU 0x30
;       The address of 'one_round' (word) (global) is 0x32
	one_round EQU 0x32
;       The address of 'max_pos' (byte) (global) is 0x34
	max_pos EQU 0x34
;       The address of 'new_steps' (word) (global) is 0x35
	new_steps EQU 0x35
;       The address of 'act_pos' (byte) (global) is 0x37
	act_pos EQU 0x37
;       The address of 'value' (byte) (global) is 0x38
	value EQU 0x38
;       The address of 'ctrl_type' (byte) (global) is 0x39
	ctrl_type EQU 0x39
;       The address of 'bus_pos' (byte) (global) is 0x3A
	bus_pos EQU 0x3A
;       The address of 'free_space_steps' (byte) (global) is 0x3B
	free_space_steps EQU 0x3B
;       The address of 'eprom_pointer1' (byte) (global) is 0x3C
	eprom_pointer1 EQU 0x3C
;       The address of 'steps' (word) (global) is 0x3D
	steps EQU 0x3D
;       The address of 'act_steps' (word) (global) is 0x3F
	act_steps EQU 0x3F
;       The address of 'turn_counter' (byte) (global) is 0x41
	turn_counter EQU 0x41
;       The address of 'result' (byte) (global) is 0x42
	result EQU 0x42
;       The address of 'manual_pos' (byte) (global) is 0x43
	manual_pos EQU 0x43
;       The address of 'eprom_pointer2' (byte) (global) is 0x44
	eprom_pointer2 EQU 0x44
;       The address of 'program_set' (byte) (global) is 0x45
	program_set EQU 0x45
;       The address of 'disp1_val' (byte) (global) is 0x46
	disp1_val EQU 0x46
;       The address of 'new_encoder' (byte) (global) is 0x47
	new_encoder EQU 0x47
;       The address of 'encoder_count' (byte) (global) is 0x48
	encoder_count EQU 0x48
;       The address of 'onoff' (bit) (global) is 0x49,0
;       The address of 'new_pos' (byte) (global) is 0x4A
	new_pos EQU 0x4A
;       The address of 'disp2_val' (byte) (global) is 0x4B
	disp2_val EQU 0x4B
;       The address of 'old_bus_pos' (byte) (global) is 0x4C
	old_bus_pos EQU 0x4C
;       The address of 'old_encoder' (byte) (global) is 0x4D
	old_encoder EQU 0x4D
;       The address of 'one_round_half' (word) (global) is 0x4E
	one_round_half EQU 0x4E
;       The address of 'old_manual_pos' (byte) (global) is 0x50
	old_manual_pos EQU 0x50
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'eep' (bit) (global) is 0x6,6
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x7,3
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0013
	ORG 0x0004
	RETFIE
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0013:
; 1: 'program TT for PCBoard MGV145
; 2: 'version V3-1  Fiddle Yard version, for turntables and fiddle yard
; 3: 'this version has all possibilities changeable by menue's.
; 4: 'V3-2 counter for twisting cables tored at eeprom pos zero.
; 5: 'the value of the counter can be anything between 125 and 131. 128 is zero point.
; 6: 'V3-3 eeprom startup improved. Reprogramming PIC can now be done without reprogramming data
; 7: Define CONF_WORD = 0x3f72
; 8: Define CLOCK_FREQUENCY = 20
; 9: Dim steps As Word
; 10: Dim program_set As Byte
; 11: Dim new_steps As Word
; 12: Dim act_steps As Word
; 13: Dim new_pos As Byte
; 14: Dim act_pos As Byte
; 15: Dim one_round As Word
; 16: Dim one_round_half As Word
; 17: Dim bus_pos As Byte
; 18: Dim old_bus_pos As Byte
; 19: Dim speed As Word
; 20: Dim new_encoder As Byte
; 21: Dim old_encoder As Byte
; 22: Dim manual_pos As Byte
; 23: Dim old_manual_pos As Byte
; 24: Dim result As Byte
; 25: Dim free_space_steps As Byte
; 26: Dim value As Byte
; 27: Dim eprom_pointer1 As Byte
; 28: Dim eprom_pointer2 As Byte
; 29: Dim encoder_count As Byte
; 30: Dim turn_counter As Byte
; 31: Dim onoff As Bit
; 32: Dim max_pos As Byte
; 33: Dim disp1_val As Byte
; 34: Dim disp2_val As Byte
; 35: Dim ctrl_type As Byte
; 36: Const disp1 = 64
; 37: Const disp2 = 66
; 38: Const mem_turn_counter = 0
; 39: Const mem_act_pos = 121
; 40: Const mem_speed = 122
; 41: Const mem_one_round_lb = 123
; 42: Const mem_one_round_hb = 124
; 43: Const mem_ctrl_type = 125
; 44: Const mem_max_pos = 126
; 45: Const mem_free_space = 127
; 46: Symbol swfw = RB0
; 47: Symbol swrev = RB1
; 48: Symbol sck = RB2
; 49: Symbol sda = RB3
; 50: Symbol pos_match = RB4
; 51: Symbol pos_write = RB5
; 52: Symbol eep = RB6
; 53: Symbol direction = RC0
; 54: Symbol clk = RC1
; 55: Symbol ena = RC2
; 56: Symbol zero = RC3
; 57: Symbol ec1 = RC4
; 58: Symbol ec2 = RC5
; 59: Symbol ecsw = RC6
; 60: Symbol pgm = RC7
; 61: ADCON1 = %0110
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 62: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 63: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 64: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 65: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 66: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 67: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 68: Gosub init_values
	BSF PCLATH,3
	CALL L0012
; 69: value = act_pos
	MOVF 0x37,W
	MOVWF 0x38
; 70: Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 71: onoff = 1
	BSF 0x49,0
; 72: Gosub relays
	BCF PCLATH,3
	CALL L0009
; 73: program_set = 1
	MOVLW 0x01
	MOVWF 0x45
; 74: main:
L0001:
; 75: 	If pgm = 0 Then
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0014
; 76: 		Gosub adjust_settings
	BCF PCLATH,3
	CALL L0004
; 77: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 78: 	Endif
L0014:
; 79: 
; 80: 	Gosub get_new_position
	BCF PCLATH,3
	CALL L0002
; 81: 	If bus_pos <> old_bus_pos Then
	MOVF 0x3A,W
	SUBWF 0x4C,W
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0015
; 82: 		onoff = 0
	BCF 0x49,0
; 83: 		Gosub relays
	BCF PCLATH,3
	CALL L0009
; 84: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 85: 		new_pos = bus_pos
	MOVF 0x3A,W
	MOVWF 0x4A
; 86: 		Gosub stepmotor
	BCF PCLATH,3
	CALL L0008
; 87: 		value = act_pos
	MOVF 0x37,W
	MOVWF 0x38
; 88: 		Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 89: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 90: 		onoff = 1
	BSF 0x49,0
; 91: 	Else
	BCF PCLATH,3
	GOTO L0016
L0015:
; 92: 		If ecsw = 0 Then  'only when knob is pushed
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0017
; 93: 			If manual_pos <> old_manual_pos Then
	MOVF 0x43,W
	SUBWF 0x50,W
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0018
; 94: 				onoff = 0
	BCF 0x49,0
; 95: 				Gosub relays
	BCF PCLATH,3
	CALL L0009
; 96: 				pos_match = 1  'indicate not in position
	BSF 0x06,4
; 97: 				old_manual_pos = manual_pos
	MOVF 0x43,W
	MOVWF 0x50
; 98: 				new_pos = manual_pos
	MOVF 0x43,W
	MOVWF 0x4A
; 99: 				Gosub stepmotor
	BCF PCLATH,3
	CALL L0008
; 100: 				value = act_pos
	MOVF 0x37,W
	MOVWF 0x38
; 101: 				Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 102: 				pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 103: 				onoff = 1
	BSF 0x49,0
; 104: 			Endif
L0018:
; 105: 		Endif
L0017:
; 106: 	Endif
L0016:
; 107: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 108: 	Gosub relays
	BCF PCLATH,3
	CALL L0009
; 109: 	Goto main
	BCF PCLATH,3
	GOTO L0001
; 110: End
	BCF PCLATH,3
L0019:	GOTO L0019
; 111: 
; 112: 
; 113: get_new_position:
L0002:
; 114: 	
; 115: 	While pos_write = 0  'This info comes from J5
L0020:
	BCF PCLATH,3
	BTFSC 0x06,5
	GOTO L0021
; 116: 		bus_pos.0 = RA0
	BTFSC 0x05,0
	BSF 0x3A,0
	BTFSS 0x05,0
	BCF 0x3A,0
; 117: 		bus_pos.1 = RA1
	BTFSC 0x05,1
	BSF 0x3A,1
	BTFSS 0x05,1
	BCF 0x3A,1
; 118: 		bus_pos.2 = RA2
	BTFSC 0x05,2
	BSF 0x3A,2
	BTFSS 0x05,2
	BCF 0x3A,2
; 119: 		bus_pos.3 = RA3
	BTFSC 0x05,3
	BSF 0x3A,3
	BTFSS 0x05,3
	BCF 0x3A,3
; 120: 		bus_pos.4 = RA4
	BTFSC 0x05,4
	BSF 0x3A,4
	BTFSS 0x05,4
	BCF 0x3A,4
; 121: 		bus_pos.5 = RA5
	BTFSC 0x05,5
	BSF 0x3A,5
	BTFSS 0x05,5
	BCF 0x3A,5
; 122: 		bus_pos.6 = 0
	BCF 0x3A,6
; 123: 		bus_pos.7 = 0
	BCF 0x3A,7
; 124: 		value = bus_pos
	MOVF 0x3A,W
	MOVWF 0x38
; 125: 		Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 126: 		If bus_pos > max_pos Then  'this is not allowed
	MOVF 0x3A,W
	SUBWF 0x34,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0022
; 127: 			bus_pos = old_bus_pos
	MOVF 0x4C,W
	MOVWF 0x3A
; 128: 		Endif
L0022:
; 129: 		If bus_pos = 0 Then  'do not accept 0
	MOVF 0x3A,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0023
; 130: 			bus_pos = old_bus_pos
	MOVF 0x4C,W
	MOVWF 0x3A
; 131: 		Endif
L0023:
; 132: 	Wend
	BCF PCLATH,3
	GOTO L0020
L0021:
; 133: 
; 134: 	Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 135: 	Select Case result
; 136: 	Case 1
	MOVF 0x42,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0024
; 137: 		If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x48,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0025
; 138: 			encoder_count = encoder_count + 1
	MOVF 0x48,W
	ADDLW 0x01
	MOVWF 0x48
; 139: 		Else
	BCF PCLATH,3
	GOTO L0026
L0025:
; 140: 			encoder_count = 0
	CLRF 0x48
; 141: 			manual_pos = manual_pos + 1
	MOVF 0x43,W
	ADDLW 0x01
	MOVWF 0x43
; 142: 			If manual_pos > max_pos Then
	MOVF 0x43,W
	SUBWF 0x34,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0027
; 143: 				manual_pos = max_pos
	MOVF 0x34,W
	MOVWF 0x43
; 144: 			Endif
L0027:
; 145: 			value = manual_pos
	MOVF 0x43,W
	MOVWF 0x38
; 146: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 147: 		Endif
L0026:
; 148: 	Case 2
	BCF PCLATH,3
	GOTO L0028
L0024:
	MOVF 0x42,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0029
; 149: 		If encoder_count > 0 Then
	MOVF 0x48,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0030
; 150: 			encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x48,W
	MOVWF 0x48
; 151: 		Else
	BCF PCLATH,3
	GOTO L0031
L0030:
; 152: 			encoder_count = 4
	MOVLW 0x04
	MOVWF 0x48
; 153: 			If manual_pos > 0 Then
	MOVF 0x43,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0032
; 154: 				manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x43,W
	MOVWF 0x43
; 155: 			Endif
L0032:
; 156: 			value = manual_pos
	MOVF 0x43,W
	MOVWF 0x38
; 157: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 158: 		Endif
L0031:
; 159: 	Case Else
	BCF PCLATH,3
	GOTO L0033
L0029:
; 160: 	EndSelect
L0033:
L0028:
; 161: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 162: 	
; 163: Return
	RETURN
; 164: 
; 165: calc_rotation:
L0003:
; 166: '1 = increasing value
; 167: '2 = decreasing value
; 168: '3 = no change
; 169: 		new_encoder = 0
	CLRF 0x47
; 170: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x47,0
	BTFSS 0x07,4
	BCF 0x47,0
; 171: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x47,1
	BTFSS 0x07,5
	BCF 0x47,1
; 172: 		Select Case old_encoder
; 173: 		Case 0
	MOVF 0x4D,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0034
; 174: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x47,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0035
	BCF PCLATH,3
	CALL L0036
	MOVWF 0x42
	BCF PCLATH,3
	GOTO L0035
L0036:
	MOVLW 0x01
	MOVWF PCLATH
	MOVF 0x47,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
L0035:
; 175: 		Case 1
	BCF PCLATH,3
	GOTO L0037
L0034:
	MOVF 0x4D,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0038
; 176: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x47,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0039
	BCF PCLATH,3
	CALL L0040
	MOVWF 0x42
	BCF PCLATH,3
	GOTO L0039
L0040:
	MOVLW 0x01
	MOVWF PCLATH
	MOVF 0x47,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
L0039:
; 177: 		Case 2
	BCF PCLATH,3
	GOTO L0041
L0038:
	MOVF 0x4D,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0042
; 178: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x47,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0043
	BCF PCLATH,3
	CALL L0044
	MOVWF 0x42
	BCF PCLATH,3
	GOTO L0043
L0044:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x47,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
L0043:
; 179: 		Case Else
	BCF PCLATH,3
	GOTO L0045
L0042:
; 180: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x47,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0046
	BCF PCLATH,3
	CALL L0047
	MOVWF 0x42
	BCF PCLATH,3
	GOTO L0046
L0047:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x47,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
L0046:
; 181: 		EndSelect
L0045:
L0041:
L0037:
; 182: 		old_encoder = new_encoder
	MOVF 0x47,W
	MOVWF 0x4D
; 183: Return
	RETURN
; 184: 
; 185: 
; 186: adjust_settings:
L0004:
; 187: 	onoff = 0
	BCF 0x49,0
; 188: 	Gosub relays
	BCF PCLATH,3
	CALL L0009
; 189: 	Gosub steps_reading
	BCF PCLATH,3
	CALL L0007
; 190: 	Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 191: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x3F,W
	MOVWF 0x35
	MOVF 0x40,W
	MOVWF 0x36
; 192: 	Read mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3B
; 193: 	Read mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 194: 	Read mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 195: 	Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 196: 	WaitMs 1500  'give some time for display to be read
	MOVLW 0xDC
	MOVWF R0L
	MOVLW 0x05
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 197: 	While pgm = 0
L0048:
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0049
; 198: 		If ecsw = 0 Then  'knob is pressed, adjust max positions
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0050
; 199: 			program_set = program_set + 1
	MOVF 0x45,W
	ADDLW 0x01
	MOVWF 0x45
; 200: 			If program_set > 5 Then
	MOVF 0x45,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0051
; 201: 				program_set = 1
	MOVLW 0x01
	MOVWF 0x45
; 202: 			Endif
L0051:
; 203: 			Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 204: 			WaitMs 1500  'give some time for display to be read
	MOVLW 0xDC
	MOVWF R0L
	MOVLW 0x05
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 205: 			While ecsw = 0  'be sure pushbutton is released
L0052:
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0053
; 206: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 207: 			Wend
	BCF PCLATH,3
	GOTO L0052
L0053:
; 208: 		Endif
L0050:
; 209: 		Select Case program_set
; 210: 		Case 1  'correction position
	MOVF 0x45,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0054
; 211: 			value = act_pos
	MOVF 0x37,W
	MOVWF 0x38
; 212: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 213: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 214: 			Select Case result
; 215: 			Case 1
	MOVF 0x42,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0055
; 216: 				If new_steps < 60000 Then
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0056
; 217: 					ena = 1  'motor on
	BSF 0x07,2
; 218: 					new_steps = new_steps + 1
	MOVF 0x35,W
	ADDLW 0x01
	MOVWF 0x35
	MOVF 0x36,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x36
; 219: 					direction = 1
	BSF 0x07,0
; 220: 					clk = 1  'clock out
	BSF 0x07,1
; 221: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 222: 					clk = 0
	BCF 0x07,1
; 223: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 224: 				Endif
L0056:
; 225: 			Case 2
	BCF PCLATH,3
	GOTO L0057
L0055:
	MOVF 0x42,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0058
; 226: 				If new_steps > 0 Then
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0059
; 227: 					ena = 1  'motor on
	BSF 0x07,2
; 228: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x35,W
	MOVWF 0x35
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x36,W
	MOVWF 0x36
; 229: 					direction = 0
	BCF 0x07,0
; 230: 					clk = 1  'clock out
	BSF 0x07,1
; 231: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 232: 					clk = 0
	BCF 0x07,1
; 233: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 234: 				Endif
L0059:
; 235: 			Case Else
	BCF PCLATH,3
	GOTO L0060
L0058:
; 236: 			EndSelect
L0060:
L0057:
; 237: 		Case 2  'setting of maximum positions
	BCF PCLATH,3
	GOTO L0061
L0054:
	MOVF 0x45,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0062
; 238: 			ena = 0  'shut off motor
	BCF 0x07,2
; 239: 			If max_pos > 60 Then
	MOVF 0x34,W
	SUBLW 0x3C
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0063
; 240: 				max_pos = 60
	MOVLW 0x3C
	MOVWF 0x34
; 241: 			Endif
L0063:
; 242: 			value = max_pos
	MOVF 0x34,W
	MOVWF 0x38
; 243: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 244: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 245: 			Select Case result
; 246: 			Case 1
	MOVF 0x42,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0064
; 247: 				If max_pos < 60 Then  'display is limited to 60
	MOVLW 0x3C
	SUBWF 0x34,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0065
; 248: 					max_pos = max_pos + 1
	MOVF 0x34,W
	ADDLW 0x01
	MOVWF 0x34
; 249: 					Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0066:	BTFSC EECON1,WR
	GOTO L0066
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 250: 				Endif
L0065:
; 251: 			Case 2
	BCF PCLATH,3
	GOTO L0067
L0064:
	MOVF 0x42,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0068
; 252: 				If max_pos > 4 Then
	MOVF 0x34,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0069
; 253: 					max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 254: 					Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0070:	BTFSC EECON1,WR
	GOTO L0070
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 255: 				Endif
L0069:
; 256: 			Case Else
	BCF PCLATH,3
	GOTO L0071
L0068:
; 257: 			EndSelect
L0071:
L0067:
; 258: 		
; 259: 		Case 3  'setting of speed interval
	BCF PCLATH,3
	GOTO L0072
L0062:
	MOVF 0x45,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0073
; 260: 					'setting will be done in multiple of 256 uSecs
; 261: 					'minimum is 2 and maximum is 60 (is real slow)
; 262: 			ena = 0  'shut off motor
	BCF 0x07,2
; 263: 			If speed.HB > 60 Then
	MOVF 0x31,W
	SUBLW 0x3C
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0074
; 264: 				speed.HB = 60
	MOVLW 0x3C
	MOVWF 0x31
; 265: 				Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0075:	BTFSC EECON1,WR
	GOTO L0075
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 266: 			Endif
L0074:
; 267: 			value = speed.HB
	MOVF 0x31,W
	MOVWF 0x38
; 268: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 269: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 270: 			Select Case result
; 271: 			Case 1
	MOVF 0x42,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0076
; 272: 				If speed.HB < 100 Then  'display is limited to 100
	MOVLW 0x64
	SUBWF 0x31,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0077
; 273: 					speed.HB = speed.HB + 1
	MOVF 0x31,W
	ADDLW 0x01
	MOVWF 0x31
; 274: 					Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0078:	BTFSC EECON1,WR
	GOTO L0078
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 275: 				Endif
L0077:
; 276: 			Case 2
	BCF PCLATH,3
	GOTO L0079
L0076:
	MOVF 0x42,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0080
; 277: 				If speed.HB > 2 Then
	MOVF 0x31,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0081
; 278: 					speed.HB = speed.HB - 1
	MOVLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 279: 					Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0082:	BTFSC EECON1,WR
	GOTO L0082
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 280: 				Endif
L0081:
; 281: 			Case Else
	BCF PCLATH,3
	GOTO L0083
L0080:
; 282: 			EndSelect
L0083:
L0079:
; 283: 	
; 284: 		Case 4  'setting of extra free space steps
	BCF PCLATH,3
	GOTO L0084
L0073:
	MOVF 0x45,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0085
; 285: 			ena = 0  'shut off motor
	BCF 0x07,2
; 286: 			If free_space_steps > 250 Then
	MOVF 0x3B,W
	SUBLW 0xFA
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0086
; 287: 				free_space_steps = 250
	MOVLW 0xFA
	MOVWF 0x3B
; 288: 				Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0087:	BTFSC EECON1,WR
	GOTO L0087
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 289: 			Endif
L0086:
; 290: 			value = free_space_steps
	MOVF 0x3B,W
	MOVWF 0x38
; 291: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 292: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 293: 			Select Case result
; 294: 			Case 1
	MOVF 0x42,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0088
; 295: 				If free_space_steps < 60 Then  'display is limited to 60
	MOVLW 0x3C
	SUBWF 0x3B,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0089
; 296: 					free_space_steps = free_space_steps + 1
	MOVF 0x3B,W
	ADDLW 0x01
	MOVWF 0x3B
; 297: 					Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0090:	BTFSC EECON1,WR
	GOTO L0090
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 298: 				Endif
L0089:
; 299: 			Case 2
	BCF PCLATH,3
	GOTO L0091
L0088:
	MOVF 0x42,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0092
; 300: 				If free_space_steps > 0 Then
	MOVF 0x3B,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0093
; 301: 					free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x3B
; 302: 					Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0094:	BTFSC EECON1,WR
	GOTO L0094
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 303: 				Endif
L0093:
; 304: 			Case Else
	BCF PCLATH,3
	GOTO L0095
L0092:
; 305: 			EndSelect
L0095:
L0091:
; 306: 		Case Else  'setting of control type
	BCF PCLATH,3
	GOTO L0096
L0085:
; 307: 			ena = 0  'shut off motor
	BCF 0x07,2
; 308: 			If ctrl_type > 3 Then
	MOVF 0x39,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0097
; 309: 				ctrl_type = 0
	CLRF 0x39
; 310: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0098:	BTFSC EECON1,WR
	GOTO L0098
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 311: 			Endif
L0097:
; 312: 			value = ctrl_type
	MOVF 0x39,W
	MOVWF 0x38
; 313: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 314: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 315: 			Select Case result
; 316: 			Case 1
	MOVF 0x42,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0099
; 317: 				If ctrl_type < 3 Then  'display is limited to 60
	MOVLW 0x03
	SUBWF 0x39,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0100
; 318: 					ctrl_type = ctrl_type + 1
	MOVF 0x39,W
	ADDLW 0x01
	MOVWF 0x39
; 319: 					Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0101:	BTFSC EECON1,WR
	GOTO L0101
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 320: 				Endif
L0100:
; 321: 			Case 2
	BCF PCLATH,3
	GOTO L0102
L0099:
	MOVF 0x42,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0103
; 322: 				If ctrl_type > 0 Then
	MOVF 0x39,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0104
; 323: 					ctrl_type = ctrl_type - 1
	MOVLW 0x01
	SUBWF 0x39,W
	MOVWF 0x39
; 324: 					Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0105:	BTFSC EECON1,WR
	GOTO L0105
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 325: 				Endif
L0104:
; 326: 			Case Else
	BCF PCLATH,3
	GOTO L0106
L0103:
; 327: 			EndSelect
L0106:
L0102:
; 328: 						
; 329: 		EndSelect
L0096:
L0084:
L0072:
L0061:
; 330: 		
; 331: 	Wend
	BCF PCLATH,3
	GOTO L0048
L0049:
; 332: 	ena = 0  'shut off motor
	BCF 0x07,2
; 333: 		'***************   now check if changes have to written in eeprom
; 334: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	MOVF 0x3F,W
	MOVWF R1L
	MOVF 0x40,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C002
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0107
; 335: 		eprom_pointer1 = act_pos
	MOVF 0x37,W
	MOVWF 0x3C
; 336: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x3C,W
	ADDLW 0x3C
	MOVWF 0x44
; 337: 		Write eprom_pointer1, new_steps.LB
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0108:	BTFSC EECON1,WR
	GOTO L0108
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 338: 		Write eprom_pointer2, new_steps.HB
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0109:	BTFSC EECON1,WR
	GOTO L0109
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 339: 		Gosub check_next_steps
	BCF PCLATH,3
	CALL L0010
; 340: 	Endif
L0107:
; 341: 	value = act_pos
	MOVF 0x37,W
	MOVWF 0x38
; 342: 	Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 343: 	onoff = 1
	BSF 0x49,0
; 344: 	Gosub relays
	BCF PCLATH,3
	CALL L0009
; 345: Return
	RETURN
; 346: 
; 347: i2c_display:
L0005:
; 348: 	disp1_val = value
	MOVF 0x38,W
	MOVWF 0x46
; 349: 	disp1_val = disp1_val Mod 10
	MOVF 0x46,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x46
; 350: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x46,W
	SUBLW 0x09
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0110
	BCF PCLATH,3
	CALL L0111
	MOVWF 0x46
	BCF PCLATH,3
	GOTO L0110
L0111:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x46,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
L0110:
; 351: 	disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x46,7
	BTFSS 0x07,7
	BCF 0x46,7
; 352: 	disp2_val = value
	MOVF 0x38,W
	MOVWF 0x4B
; 353: 	disp2_val = disp2_val / 10
	MOVF 0x4B,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4B
; 354: 	disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x4B,W
	SUBLW 0x0A
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0112
	BCF PCLATH,3
	CALL L0113
	MOVWF 0x4B
	BCF PCLATH,3
	GOTO L0112
L0113:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x4B,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
L0112:
; 355: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 356: 	I2CSend disp1
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 357: 	I2CSend disp1_val
	BCF PCLATH,3
	MOVF 0x46,W
	CALL IC01
; 358: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 359: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 360: 	I2CSend disp2
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 361: 	I2CSend disp2_val
	BCF PCLATH,3
	MOVF 0x4B,W
	CALL IC01
; 362: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 363: Return
	RETURN
; 364: 
; 365: i2c_display_pgm:
L0006:
; 366: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010), program_set
	MOVF 0x45,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0114
	BCF PCLATH,3
	CALL L0115
	MOVWF 0x46
	BCF PCLATH,3
	GOTO L0114
L0115:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x45,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
L0114:
; 367: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 368: 	I2CSend disp1
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 369: 	I2CSend disp1_val
	BCF PCLATH,3
	MOVF 0x46,W
	CALL IC01
; 370: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 371: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 372: 	I2CSend disp2
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 373: 	I2CSend %10111111
	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 374: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 375: Return
	RETURN
; 376: 
; 377: steps_reading:
L0007:
; 378: 	If act_pos = 0 Then
	MOVF 0x37,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0116
; 379: 		act_steps = 0
	CLRF 0x3F
	CLRF 0x40
; 380: 	Else
	BCF PCLATH,3
	GOTO L0117
L0116:
; 381: 		eprom_pointer1 = act_pos
	MOVF 0x37,W
	MOVWF 0x3C
; 382: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x3C,W
	ADDLW 0x3C
	MOVWF 0x44
; 383: 		Read eprom_pointer1, act_steps.LB
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 384: 		Read eprom_pointer2, act_steps.HB
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 385: 	Endif
L0117:
; 386: 	If new_pos = 0 Then
	MOVF 0x4A,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0118
; 387: 		new_steps = 0
	CLRF 0x35
	CLRF 0x36
; 388: 	Else
	BCF PCLATH,3
	GOTO L0119
L0118:
; 389: 		eprom_pointer1 = new_pos
	MOVF 0x4A,W
	MOVWF 0x3C
; 390: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x3C,W
	ADDLW 0x3C
	MOVWF 0x44
; 391: 		Read eprom_pointer1, new_steps.LB
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x35
; 392: 		Read eprom_pointer2, new_steps.HB
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 393: 	Endif
L0119:
; 394: Return
	RETURN
; 395: 
; 396: stepmotor:
L0008:
; 397: 	speed = 0
	CLRF 0x30
	CLRF 0x31
; 398: 	Read mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 399: 	Read mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3B
; 400: 	Gosub steps_reading
	BCF PCLATH,3
	CALL L0007
; 401: 	If new_steps = 0 Then
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C001
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0120
; 402: 		direction = 0
	BCF 0x07,0
; 403: 		ena = 1  'set anable on
	BSF 0x07,2
; 404: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 405: 		While zero = 1  'turn motor until zero switch is activated
L0121:
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0122
; 406: 			clk = 1  'clock out
	BSF 0x07,1
; 407: 			WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 408: 			clk = 0
	BCF 0x07,1
; 409: 			WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 410: 		Wend
	BCF PCLATH,3
	GOTO L0121
L0122:
; 411: 		act_pos = 0
	CLRF 0x37
; 412: 		Write mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0123:	BTFSC EECON1,WR
	GOTO L0123
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 413: 		If ctrl_type > 1 Then  'NOW GO ONE MORE COMPLETE ROUND FOR COUNTING STEPS
	MOVF 0x39,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0124
; 414: 			one_round = 0
	CLRF 0x32
	CLRF 0x33
; 415: 			ena = 1  'set anable on
	BSF 0x07,2
; 416: 			While zero = 0  'turn motor until zero switch is activated
L0125:
	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0126
; 417: 				clk = 1  'clock out
	BSF 0x07,1
; 418: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 419: 				clk = 0
	BCF 0x07,1
; 420: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 421: 				one_round = one_round + 1
	MOVF 0x32,W
	ADDLW 0x01
	MOVWF 0x32
	MOVF 0x33,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x33
; 422: 			Wend
	BCF PCLATH,3
	GOTO L0125
L0126:
; 423: 			While zero = 1  'turn motor until zero switch is activated
L0127:
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0128
; 424: 				clk = 1  'clock out
	BSF 0x07,1
; 425: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 426: 				clk = 0
	BCF 0x07,1
; 427: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 428: 				one_round = one_round + 1
	MOVF 0x32,W
	ADDLW 0x01
	MOVWF 0x32
	MOVF 0x33,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x33
; 429: 			Wend
	BCF PCLATH,3
	GOTO L0127
L0128:
; 430: 			one_round_half = one_round / 2
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4E
	MOVF R0H,W
	MOVWF 0x4F
; 431: 			Write mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0129:	BTFSC EECON1,WR
	GOTO L0129
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 432: 			Write mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0130:	BTFSC EECON1,WR
	GOTO L0130
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 433: 		Endif
L0124:
; 434: 		ena = 0  'set anable off
	BCF 0x07,2
; 435: 		act_pos = 0
	CLRF 0x37
; 436: 	Else
	BCF PCLATH,3
	GOTO L0131
L0120:
; 437: 		steps = 0
	CLRF 0x3D
	CLRF 0x3E
; 438: 		If new_steps > act_steps Then
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	MOVF 0x3F,W
	MOVWF R1L
	MOVF 0x40,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0132
; 439: 			steps = new_steps - act_steps
	MOVF 0x3F,W
	SUBWF 0x35,W
	MOVWF 0x3D
	MOVF 0x40,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x36,W
	MOVWF 0x3E
; 440: 			direction = 1
	BSF 0x07,0
; 441: 			If steps > one_round_half Then
	MOVF 0x3D,W
	MOVWF R0L
	MOVF 0x3E,W
	MOVWF R0H
	MOVF 0x4E,W
	MOVWF R1L
	MOVF 0x4F,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0133
; 442: 				Read mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 443: 				If turn_counter > 126 Then  'check if shortest way is allowed
	MOVF 0x41,W
	SUBLW 0x7E
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0134
; 444: 					turn_counter = turn_counter - 1  'yes it is, so substract one pass
	MOVLW 0x01
	SUBWF 0x41,W
	MOVWF 0x41
; 445: 					steps = one_round - steps  'go shortest way
	MOVF 0x3D,W
	SUBWF 0x32,W
	MOVWF 0x3D
	MOVF 0x3E,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x33,W
	MOVWF 0x3E
; 446: 					direction = 0  'change  direction
	BCF 0x07,0
; 447: 					Write mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0135:	BTFSC EECON1,WR
	GOTO L0135
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 448: 				Endif
L0134:
; 449: 			Endif
L0133:
; 450: 		Else
	BCF PCLATH,3
	GOTO L0136
L0132:
; 451: 			steps = act_steps - new_steps
	MOVF 0x35,W
	SUBWF 0x3F,W
	MOVWF 0x3D
	MOVF 0x36,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x40,W
	MOVWF 0x3E
; 452: 			direction = 0
	BCF 0x07,0
; 453: 			If steps > one_round_half Then
	MOVF 0x3D,W
	MOVWF R0L
	MOVF 0x3E,W
	MOVWF R0H
	MOVF 0x4E,W
	MOVWF R1L
	MOVF 0x4F,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0137
; 454: 				Read mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 455: 				If turn_counter < 130 Then  'check if shortest way is allowed
	MOVLW 0x82
	SUBWF 0x41,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0138
; 456: 					turn_counter = turn_counter + 1  'yes it is, so add one pass
	MOVF 0x41,W
	ADDLW 0x01
	MOVWF 0x41
; 457: 					steps = one_round - steps  'go shortest way
	MOVF 0x3D,W
	SUBWF 0x32,W
	MOVWF 0x3D
	MOVF 0x3E,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x33,W
	MOVWF 0x3E
; 458: 					direction = 1  'change direction
	BSF 0x07,0
; 459: 					Write mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0139:	BTFSC EECON1,WR
	GOTO L0139
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 460: 				Endif
L0138:
; 461: 			Endif
L0137:
; 462: 		Endif
L0136:
; 463: 		If steps > 0 Then  'tt must be activated
	MOVF 0x3D,W
	MOVWF R0L
	MOVF 0x3E,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0140
; 464: 			If direction = 1 Then
	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0141
; 465: 				steps = steps + free_space_steps
	MOVF 0x3D,W
	ADDWF 0x3B,W
	MOVWF 0x3D
	MOVF 0x3E,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x3E
; 466: 			Endif
L0141:
; 467: 			ena = 1  'set anable on
	BSF 0x07,2
; 468: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 469: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0142:
	MOVF 0x3D,W
	MOVWF R0L
	MOVF 0x3E,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0143
; 470: 				clk = 1  'clock out
	BSF 0x07,1
; 471: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 472: 				clk = 0
	BCF 0x07,1
; 473: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 474: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3E,W
	MOVWF 0x3E
; 475: 			Wend
	BCF PCLATH,3
	GOTO L0142
L0143:
; 476: 			WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 477: 			If direction = 1 Then
	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0144
; 478: 				steps = free_space_steps
	MOVF 0x3B,W
	MOVWF 0x3D
	CLRF 0x3E
; 479: 				direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 480: 				While steps > 0  'NOW RUN UNTIL STEPS = 0
L0145:
	MOVF 0x3D,W
	MOVWF R0L
	MOVF 0x3E,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0146
; 481: 					clk = 1  'clock out
	BSF 0x07,1
; 482: 					WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 483: 					clk = 0
	BCF 0x07,1
; 484: 					WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 485: 					steps = steps - 1
	MOVLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3E,W
	MOVWF 0x3E
; 486: 				Wend
	BCF PCLATH,3
	GOTO L0145
L0146:
; 487: 			Endif
L0144:
; 488: 			ena = 0  'enable off
	BCF 0x07,2
; 489: 			pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 490: 		Endif
L0140:
; 491: 	Endif
L0131:
; 492: 	act_pos = new_pos
	MOVF 0x4A,W
	MOVWF 0x37
; 493: 	Write mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0147:	BTFSC EECON1,WR
	GOTO L0147
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 494: 	bus_pos = act_pos
	MOVF 0x37,W
	MOVWF 0x3A
; 495: 	old_bus_pos = act_pos
	MOVF 0x37,W
	MOVWF 0x4C
; 496: 	manual_pos = act_pos
	MOVF 0x37,W
	MOVWF 0x43
; 497: 	old_manual_pos = act_pos
	MOVF 0x37,W
	MOVWF 0x50
; 498: Return
	RETURN
; 499: 
; 500: 
; 501: relays:
L0009:
; 502: 	If onoff = 1 Then
	BCF PCLATH,3
	BTFSS 0x49,0
	GOTO L0148
; 503: 		value = max_pos + 1
	MOVF 0x34,W
	ADDLW 0x01
	MOVWF 0x38
; 504: 		value = value / 2  'calulation of half max positions
	MOVF 0x38,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x38
; 505: 		Select Case ctrl_type
; 506: 		Case 1, 3
	MOVF 0x39,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0151
	BCF PCLATH,3
	GOTO L0150
L0151:
	MOVF 0x39,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0149
L0150:
; 507: 			swfw = 1
	BSF 0x06,0
; 508: 			swrev = 0
	BCF 0x06,1
; 509: 		Case Else
	BCF PCLATH,3
	GOTO L0152
L0149:
; 510: 			If act_pos > value Then  'select polarity rails on bridge
	MOVF 0x37,W
	SUBWF 0x38,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0153
; 511: 				swfw = 0
	BCF 0x06,0
; 512: 				swrev = 1
	BSF 0x06,1
; 513: 			Else
	BCF PCLATH,3
	GOTO L0154
L0153:
; 514: 				swrev = 0
	BCF 0x06,1
; 515: 				swfw = 1
	BSF 0x06,0
; 516: 			Endif
L0154:
; 517: 		EndSelect
L0152:
; 518: 	Else
	BCF PCLATH,3
	GOTO L0155
L0148:
; 519: 		swfw = 0
	BCF 0x06,0
; 520: 		swrev = 0
	BCF 0x06,1
; 521: 	Endif
L0155:
; 522: Return
	RETURN
; 523: 
; 524: 
; 525: check_next_steps:
L0010:
; 526: 	'this is ment to check all following steps after readjusting one position.
; 527: 	'simply to avoid that tt will go backwards when set for the next (higher) position.
; 528: 	value = act_pos
	MOVF 0x37,W
	MOVWF 0x38
; 529: 	While value < max_pos
L0156:
	MOVF 0x34,W
	SUBWF 0x38,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0157
; 530: 		eprom_pointer1 = value
	MOVF 0x38,W
	MOVWF 0x3C
; 531: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x3C,W
	ADDLW 0x3C
	MOVWF 0x44
; 532: 		Read eprom_pointer1, act_steps.LB
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 533: 		Read eprom_pointer2, act_steps.HB
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 534: 		eprom_pointer1 = eprom_pointer1 + 1
	MOVF 0x3C,W
	ADDLW 0x01
	MOVWF 0x3C
; 535: 		eprom_pointer2 = eprom_pointer2 + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
; 536: 		Read eprom_pointer1, new_steps.LB
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x35
; 537: 		Read eprom_pointer2, new_steps.HB
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 538: 		While new_steps < act_steps
L0158:
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	MOVF 0x3F,W
	MOVWF R1L
	MOVF 0x40,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0159
; 539: 			new_steps = new_steps + 50
	MOVF 0x35,W
	ADDLW 0x32
	MOVWF 0x35
	MOVF 0x36,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x36
; 540: 		Wend
	BSF PCLATH,3
	GOTO L0158
L0159:
; 541: 		Write eprom_pointer1, new_steps.LB
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0160:	BTFSC EECON1,WR
	GOTO L0160
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 542: 		Write eprom_pointer2, new_steps.HB
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0161:	BTFSC EECON1,WR
	GOTO L0161
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 543: 		value = value + 1
	MOVF 0x38,W
	ADDLW 0x01
	MOVWF 0x38
; 544: 	Wend
	BCF PCLATH,3
	GOTO L0156
L0157:
; 545: Return
	RETURN
; 546: 
; 547: 
; 548: init_eeprom:
L0011:
; 549: 			'check if acceptable value is in eeprom
; 550: 	Read mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 551: 	If max_pos < 2 Then
	MOVLW 0x02
	SUBWF 0x34,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0162
; 552: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x34
; 553: 		Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0163:	BTFSC EECON1,WR
	GOTO L0163
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 554: 	Endif
L0162:
; 555: 	If max_pos > 60 Then
	MOVF 0x34,W
	SUBLW 0x3C
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0164
; 556: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x34
; 557: 		Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0165:	BTFSC EECON1,WR
	GOTO L0165
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 558: 	Endif
L0164:
; 559: 	act_pos = 1
	MOVLW 0x01
	MOVWF 0x37
; 560: 	Write mem_act_pos, 1  'act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x01
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0166:	BTFSC EECON1,WR
	GOTO L0166
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 561: 	act_steps = 0
	CLRF 0x3F
	CLRF 0x40
; 562: 	one_round = 8000
	MOVLW 0x40
	MOVWF 0x32
	MOVLW 0x1F
	MOVWF 0x33
; 563: 		'check memory for correct total steps
; 564: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x32
; 565: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 566: 	If one_round > 40000 Then
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVLW 0x40
	MOVWF R1L
	MOVLW 0x9C
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0167
; 567: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x32
	MOVLW 0x1F
	MOVWF 0x33
; 568: 		Write mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0168:	BTFSC EECON1,WR
	GOTO L0168
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 569: 		Write mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0169:	BTFSC EECON1,WR
	GOTO L0169
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 570: 	Endif
L0167:
; 571: 
; 572: 	For eprom_pointer1 = 1 To max_pos
	MOVLW 0x01
	MOVWF 0x3C
L0170:
	MOVF 0x3C,W
	SUBWF 0x34,W
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0171
; 573: 		new_steps = one_round / max_pos  'devide the steps between min and max
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVF 0x34,W
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x35
	MOVF R0H,W
	MOVWF 0x36
; 574: 		act_steps = act_steps + new_steps
	MOVF 0x3F,W
	ADDWF 0x35,W
	MOVWF 0x3F
	MOVF 0x40,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x36,W
	MOVWF 0x40
; 575: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x3C,W
	ADDLW 0x3C
	MOVWF 0x44
; 576: 		Write eprom_pointer1, act_steps.LB
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0172:	BTFSC EECON1,WR
	GOTO L0172
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 577: 		Write eprom_pointer2, act_steps.HB
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0173:	BTFSC EECON1,WR
	GOTO L0173
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 578: 	Next eprom_pointer1
	MOVLW 0x01
	ADDWF 0x3C,F
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0170
L0171:
; 579: 
; 580: 	speed = 20 * 256
	MOVLW 0x14
	MOVWF R3L
	CLRF R3H
	CLRF R1L
	MOVLW 0x01
	MOVWF R1H
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x30
	MOVF R2H,W
	MOVWF 0x31
; 581: 	Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0174:	BTFSC EECON1,WR
	GOTO L0174
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 582: 
; 583: 	free_space_steps = 20
	MOVLW 0x14
	MOVWF 0x3B
; 584: 	Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0175:	BTFSC EECON1,WR
	GOTO L0175
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 585: 			'check for correct control type
; 586: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 587: 	If ctrl_type > 3 Then
	MOVF 0x39,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0176
; 588: 		ctrl_type = 0
	CLRF 0x39
; 589: 		Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0177:	BTFSC EECON1,WR
	GOTO L0177
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 590: 	Endif
L0176:
; 591: 			'now check for correct amount of 0-point passes
; 592: 	Read mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 593: 	If turn_counter > 131 Then  'in program impossible value
	MOVF 0x41,W
	SUBLW 0x83
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0178
; 594: 		turn_counter = 128
	MOVLW 0x80
	MOVWF 0x41
; 595: 		Write mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0179:	BTFSC EECON1,WR
	GOTO L0179
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 596: 	Else
	BSF PCLATH,3
	GOTO L0180
L0178:
; 597: 		If turn_counter < 125 Then  'in program impossible value
	MOVLW 0x7D
	SUBWF 0x41,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0181
; 598: 			turn_counter = 128
	MOVLW 0x80
	MOVWF 0x41
; 599: 			Write mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0182:	BTFSC EECON1,WR
	GOTO L0182
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 600: 		Endif
L0181:
; 601: 	Endif
L0180:
; 602: 
; 603: Return
	RETURN
; 604: 
; 605: init_values:
L0012:
; 606: 
; 607: 	encoder_count = 0
	CLRF 0x48
; 608: 	speed = 0
	CLRF 0x30
	CLRF 0x31
; 609: 	If eep = 1 Then  'jumper set for initialisation
	BSF PCLATH,3
	BTFSS 0x06,6
	GOTO L0183
; 610: 		Gosub init_eeprom
	BSF PCLATH,3
	CALL L0011
; 611: 	Endif
L0183:
; 612: 	speed = 0
	CLRF 0x30
	CLRF 0x31
; 613: 	Read mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 614: 	If speed.HB > 100 Then
	MOVF 0x31,W
	SUBLW 0x64
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0184
; 615: 		speed.HB = 100
	MOVLW 0x64
	MOVWF 0x31
; 616: 		Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0185:	BTFSC EECON1,WR
	GOTO L0185
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 617: 	Endif
L0184:
; 618: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x32
; 619: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 620: 	If one_round = 0 Then
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C001
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0186
; 621: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x32
	MOVLW 0x1F
	MOVWF 0x33
; 622: 		Write mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0187:	BTFSC EECON1,WR
	GOTO L0187
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 623: 		Write mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0188:	BTFSC EECON1,WR
	GOTO L0188
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 624: 	Endif
L0186:
; 625: 	If one_round > 40000 Then
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVLW 0x40
	MOVWF R1L
	MOVLW 0x9C
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0189
; 626: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x32
	MOVLW 0x1F
	MOVWF 0x33
; 627: 		Write mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0190:	BTFSC EECON1,WR
	GOTO L0190
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 628: 		Write mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0191:	BTFSC EECON1,WR
	GOTO L0191
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 629: 	Endif
L0189:
; 630: 	one_round_half = one_round / 2
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4E
	MOVF R0H,W
	MOVWF 0x4F
; 631: 	Read mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 632: 	If max_pos > 60 Then
	MOVF 0x34,W
	SUBLW 0x3C
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0192
; 633: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x34
; 634: 		Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0193:	BTFSC EECON1,WR
	GOTO L0193
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 635: 	Endif
L0192:
; 636: 	Read mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 637: 	If act_pos > max_pos Then
	MOVF 0x37,W
	SUBWF 0x34,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0194
; 638: 		act_pos = 1
	MOVLW 0x01
	MOVWF 0x37
; 639: 		Write mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0195:	BTFSC EECON1,WR
	GOTO L0195
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 640: 	Endif
L0194:
; 641: 	Read mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3B
; 642: 	If free_space_steps > 250 Then
	MOVF 0x3B,W
	SUBLW 0xFA
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0196
; 643: 		free_space_steps = 20
	MOVLW 0x14
	MOVWF 0x3B
; 644: 		Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0197:	BTFSC EECON1,WR
	GOTO L0197
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 645: 	Endif
L0196:
; 646: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 647: 	If ctrl_type > 3 Then
	MOVF 0x39,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0198
; 648: 		ctrl_type = 0
	CLRF 0x39
; 649: 		Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0199:	BTFSC EECON1,WR
	GOTO L0199
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 650: 	Endif
L0198:
; 651: 	new_pos = act_pos
	MOVF 0x37,W
	MOVWF 0x4A
; 652: 	bus_pos = PORTA And 63  'cancel first input from MGV50
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x3A
; 653: 	old_bus_pos = bus_pos
	MOVF 0x3A,W
	MOVWF 0x4C
; 654: 	manual_pos = act_pos
	MOVF 0x37,W
	MOVWF 0x43
; 655: Return
	RETURN
; End of program
	BSF PCLATH,3
L0200:	GOTO L0200
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
