; Compiled with: PIC Simulator IDE v6.90
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_turn_counter' (global) is 0
;       The value of 'mem_act_pos' (global) is 121
;       The value of 'mem_speed' (global) is 122
;       The value of 'mem_one_round_lb' (global) is 123
;       The value of 'mem_one_round_hb' (global) is 124
;       The value of 'mem_ctrl_type' (global) is 125
;       The value of 'mem_max_pos' (global) is 126
;       The value of 'mem_free_space' (global) is 127
;       The address of 'speed' (word) (global) is 0x30
	speed EQU 0x30
;       The address of 'one_round' (word) (global) is 0x32
	one_round EQU 0x32
;       The address of 'max_pos' (byte) (global) is 0x34
	max_pos EQU 0x34
;       The address of 'new_steps' (word) (global) is 0x35
	new_steps EQU 0x35
;       The address of 'value' (byte) (global) is 0x37
	value EQU 0x37
;       The address of 'act_pos' (byte) (global) is 0x38
	act_pos EQU 0x38
;       The address of 'ctrl_type' (byte) (global) is 0x39
	ctrl_type EQU 0x39
;       The address of 'free_space_steps' (byte) (global) is 0x3A
	free_space_steps EQU 0x3A
;       The address of 'eprom_pointer1' (byte) (global) is 0x3B
	eprom_pointer1 EQU 0x3B
;       The address of 'steps' (word) (global) is 0x3C
	steps EQU 0x3C
;       The address of 'act_steps' (word) (global) is 0x3E
	act_steps EQU 0x3E
;       The address of 'turn_counter' (byte) (global) is 0x40
	turn_counter EQU 0x40
;       The address of 'result' (byte) (global) is 0x41
	result EQU 0x41
;       The address of 'manual_pos' (byte) (global) is 0x42
	manual_pos EQU 0x42
;       The address of 'eprom_pointer2' (byte) (global) is 0x43
	eprom_pointer2 EQU 0x43
;       The address of 'program_set' (byte) (global) is 0x44
	program_set EQU 0x44
;       The address of 'disp1_val' (byte) (global) is 0x45
	disp1_val EQU 0x45
;       The address of 'bus_pos' (byte) (global) is 0x46
	bus_pos EQU 0x46
;       The address of 'new_encoder' (byte) (global) is 0x47
	new_encoder EQU 0x47
;       The address of 'encoder_count' (byte) (global) is 0x48
	encoder_count EQU 0x48
;       The address of 'onoff' (bit) (global) is 0x49,0
;       The address of 'new_pos' (byte) (global) is 0x4A
	new_pos EQU 0x4A
;       The address of 'disp2_val' (byte) (global) is 0x4B
	disp2_val EQU 0x4B
;       The address of 'old_encoder' (byte) (global) is 0x4C
	old_encoder EQU 0x4C
;       The address of 'one_round_half' (word) (global) is 0x4D
	one_round_half EQU 0x4D
;       The address of 'old_bus_pos' (byte) (global) is 0x4F
	old_bus_pos EQU 0x4F
;       The address of 'old_manual_pos' (byte) (global) is 0x50
	old_manual_pos EQU 0x50
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'eep' (bit) (global) is 0x6,6
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x7,3
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0013
	ORG 0x0004
	RETFIE
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0013:
; 1: 'program TT for PCBoard MGV145
; 2: 'version V3-1  Fiddle Yard version, for turntables and fiddle yard
; 3: 'this version has all possibilities changeable by menue's.
; 4: 'V3-2 counter for twisting cables tored at eeprom pos zero.
; 5: 'the value of the counter can be anything between 125 and 131. 128 is zero point.
; 6: 'V3-3 eeprom startup improved. Reprogramming PIC can now be done without reprogramming data
; 7: Define CONF_WORD = 0x3f72
; 8: Define CLOCK_FREQUENCY = 20
; 9: Dim steps As Word
; 10: Dim program_set As Byte
; 11: Dim new_steps As Word
; 12: Dim act_steps As Word
; 13: Dim new_pos As Byte
; 14: Dim act_pos As Byte
; 15: Dim one_round As Word
; 16: Dim one_round_half As Word
; 17: Dim bus_pos As Byte
; 18: Dim old_bus_pos As Byte
; 19: Dim speed As Word
; 20: Dim new_encoder As Byte
; 21: Dim old_encoder As Byte
; 22: Dim manual_pos As Byte
; 23: Dim old_manual_pos As Byte
; 24: Dim result As Byte
; 25: Dim free_space_steps As Byte
; 26: Dim value As Byte
; 27: Dim eprom_pointer1 As Byte
; 28: Dim eprom_pointer2 As Byte
; 29: Dim encoder_count As Byte
; 30: Dim turn_counter As Byte
; 31: Dim onoff As Bit
; 32: Dim max_pos As Byte
; 33: Dim disp1_val As Byte
; 34: Dim disp2_val As Byte
; 35: Dim ctrl_type As Byte
; 36: Const disp1 = 64
; 37: Const disp2 = 66
; 38: Const mem_turn_counter = 0
; 39: Const mem_act_pos = 121
; 40: Const mem_speed = 122
; 41: Const mem_one_round_lb = 123
; 42: Const mem_one_round_hb = 124
; 43: Const mem_ctrl_type = 125
; 44: Const mem_max_pos = 126
; 45: Const mem_free_space = 127
; 46: Symbol swfw = RB0
; 47: Symbol swrev = RB1
; 48: Symbol sck = RB2
; 49: Symbol sda = RB3
; 50: Symbol pos_match = RB4
; 51: Symbol pos_write = RB5
; 52: Symbol eep = RB6
; 53: Symbol direction = RC0
; 54: Symbol clk = RC1
; 55: Symbol ena = RC2
; 56: Symbol zero = RC3
; 57: Symbol ec1 = RC4
; 58: Symbol ec2 = RC5
; 59: Symbol ecsw = RC6
; 60: Symbol pgm = RC7
; 61: ADCON1 = %0110
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 62: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 63: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 64: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 65: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 66: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 67: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 68: Gosub init_values
	BSF PCLATH,3
	CALL L0012
; 69: value = act_pos
	MOVF 0x38,W
	MOVWF 0x37
; 70: Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 71: onoff = 1
	BSF 0x49,0
; 72: Gosub relays
	BCF PCLATH,3
	CALL L0009
; 73: program_set = 1
	MOVLW 0x01
	MOVWF 0x44
; 74: main:
L0001:
; 75: 	If pgm = 0 Then
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0014
; 76: 		Gosub adjust_settings
	BCF PCLATH,3
	CALL L0004
; 77: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 78: 	Endif
L0014:
; 79: 
; 80: 	Gosub get_new_position
	BCF PCLATH,3
	CALL L0002
; 81: 	If bus_pos <> old_bus_pos Then
	MOVF 0x46,W
	SUBWF 0x4F,W
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0015
; 82: 		onoff = 0
	BCF 0x49,0
; 83: 		Gosub relays
	BCF PCLATH,3
	CALL L0009
; 84: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 85: 		new_pos = bus_pos
	MOVF 0x46,W
	MOVWF 0x4A
; 86: 		Gosub stepmotor
	BCF PCLATH,3
	CALL L0008
; 87: 		value = act_pos
	MOVF 0x38,W
	MOVWF 0x37
; 88: 		Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 89: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 90: 		onoff = 1
	BSF 0x49,0
; 91: 	Else
	BCF PCLATH,3
	GOTO L0016
L0015:
; 92: 		If ecsw = 0 Then  'only when knob is pushed
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0017
; 93: 			If manual_pos <> old_manual_pos Then
	MOVF 0x42,W
	SUBWF 0x50,W
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0018
; 94: 				onoff = 0
	BCF 0x49,0
; 95: 				Gosub relays
	BCF PCLATH,3
	CALL L0009
; 96: 				pos_match = 1  'indicate not in position
	BSF 0x06,4
; 97: 				old_manual_pos = manual_pos
	MOVF 0x42,W
	MOVWF 0x50
; 98: 				new_pos = manual_pos
	MOVF 0x42,W
	MOVWF 0x4A
; 99: 				Gosub stepmotor
	BCF PCLATH,3
	CALL L0008
; 100: 				value = act_pos
	MOVF 0x38,W
	MOVWF 0x37
; 101: 				Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 102: 				pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 103: 				onoff = 1
	BSF 0x49,0
; 104: 			Endif
L0018:
; 105: 		Endif
L0017:
; 106: 	Endif
L0016:
; 107: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 108: 	Gosub relays
	BCF PCLATH,3
	CALL L0009
; 109: 	Goto main
	BCF PCLATH,3
	GOTO L0001
; 110: End
	BCF PCLATH,3
L0019:	GOTO L0019
; 111: 
; 112: 
; 113: get_new_position:
L0002:
; 114: 	value = bus_pos  'remember the position
	MOVF 0x46,W
	MOVWF 0x37
; 115: 	While pos_write = 0  'This info comes from J5
L0020:
	BCF PCLATH,3
	BTFSC 0x06,5
	GOTO L0021
; 116: 		value = PORTA And 63  'now get value from J5
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x37
; 117: 		If value > max_pos Then  'this is not allowed
	MOVF 0x37,W
	SUBWF 0x34,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0022
; 118: 			value = bus_pos  'put it back to old situation
	MOVF 0x46,W
	MOVWF 0x37
; 119: 		Endif
L0022:
; 120: 		If value = 0 Then  'do not accept 0
	MOVF 0x37,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0023
; 121: 			value = bus_pos  'put it back to old situation
	MOVF 0x46,W
	MOVWF 0x37
; 122: 		Endif
L0023:
; 123: 		Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 124: 	Wend
	BCF PCLATH,3
	GOTO L0020
L0021:
; 125: 	bus_pos = value  'now take over the dseired position
	MOVF 0x37,W
	MOVWF 0x46
; 126: 	Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 127: 	Select Case result
; 128: 	Case 1
	MOVF 0x41,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0024
; 129: 		If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x48,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0025
; 130: 			encoder_count = encoder_count + 1
	MOVF 0x48,W
	ADDLW 0x01
	MOVWF 0x48
; 131: 		Else
	BCF PCLATH,3
	GOTO L0026
L0025:
; 132: 			encoder_count = 0
	CLRF 0x48
; 133: 			manual_pos = manual_pos + 1
	MOVF 0x42,W
	ADDLW 0x01
	MOVWF 0x42
; 134: 			If manual_pos > max_pos Then
	MOVF 0x42,W
	SUBWF 0x34,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0027
; 135: 				manual_pos = max_pos
	MOVF 0x34,W
	MOVWF 0x42
; 136: 			Endif
L0027:
; 137: 			value = manual_pos
	MOVF 0x42,W
	MOVWF 0x37
; 138: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 139: 		Endif
L0026:
; 140: 	Case 2
	BCF PCLATH,3
	GOTO L0028
L0024:
	MOVF 0x41,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0029
; 141: 		If encoder_count > 0 Then
	MOVF 0x48,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0030
; 142: 			encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x48,W
	MOVWF 0x48
; 143: 		Else
	BCF PCLATH,3
	GOTO L0031
L0030:
; 144: 			encoder_count = 4
	MOVLW 0x04
	MOVWF 0x48
; 145: 			If manual_pos > 0 Then
	MOVF 0x42,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0032
; 146: 				manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x42,W
	MOVWF 0x42
; 147: 			Endif
L0032:
; 148: 			value = manual_pos
	MOVF 0x42,W
	MOVWF 0x37
; 149: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 150: 		Endif
L0031:
; 151: 	Case Else
	BCF PCLATH,3
	GOTO L0033
L0029:
; 152: 	EndSelect
L0033:
L0028:
; 153: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 154: 	
; 155: Return
	RETURN
; 156: 
; 157: calc_rotation:  'this routine checks the incrimental switch
L0003:
; 158: '1 = increasing value
; 159: '2 = decreasing value
; 160: '3 = no change
; 161: 		new_encoder = 0
	CLRF 0x47
; 162: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x47,0
	BTFSS 0x07,4
	BCF 0x47,0
; 163: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x47,1
	BTFSS 0x07,5
	BCF 0x47,1
; 164: 		Select Case old_encoder
; 165: 		Case 0
	MOVF 0x4C,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0034
; 166: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x47,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0035
	BCF PCLATH,3
	CALL L0036
	MOVWF 0x41
	BCF PCLATH,3
	GOTO L0035
L0036:
	MOVLW 0x01
	MOVWF PCLATH
	MOVF 0x47,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
L0035:
; 167: 		Case 1
	BCF PCLATH,3
	GOTO L0037
L0034:
	MOVF 0x4C,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0038
; 168: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x47,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0039
	BCF PCLATH,3
	CALL L0040
	MOVWF 0x41
	BCF PCLATH,3
	GOTO L0039
L0040:
	MOVLW 0x01
	MOVWF PCLATH
	MOVF 0x47,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
L0039:
; 169: 		Case 2
	BCF PCLATH,3
	GOTO L0041
L0038:
	MOVF 0x4C,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0042
; 170: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x47,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0043
	BCF PCLATH,3
	CALL L0044
	MOVWF 0x41
	BCF PCLATH,3
	GOTO L0043
L0044:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x47,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
L0043:
; 171: 		Case Else
	BCF PCLATH,3
	GOTO L0045
L0042:
; 172: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x47,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0046
	BCF PCLATH,3
	CALL L0047
	MOVWF 0x41
	BCF PCLATH,3
	GOTO L0046
L0047:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x47,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
L0046:
; 173: 		EndSelect
L0045:
L0041:
L0037:
; 174: 		old_encoder = new_encoder
	MOVF 0x47,W
	MOVWF 0x4C
; 175: Return
	RETURN
; 176: 
; 177: 
; 178: adjust_settings:
L0004:
; 179: 	onoff = 0
	BCF 0x49,0
; 180: 	Gosub relays
	BCF PCLATH,3
	CALL L0009
; 181: 	Gosub steps_reading
	BCF PCLATH,3
	CALL L0007
; 182: 	Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 183: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x3E,W
	MOVWF 0x35
	MOVF 0x3F,W
	MOVWF 0x36
; 184: 	Read mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3A
; 185: 	Read mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 186: 	Read mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 187: 	Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 188: 	WaitMs 1500  'give some time for display to be read
	MOVLW 0xDC
	MOVWF R0L
	MOVLW 0x05
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 189: 	While pgm = 0
L0048:
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0049
; 190: 		If ecsw = 0 Then  'knob is pressed, adjust max positions
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0050
; 191: 			program_set = program_set + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
; 192: 			If program_set > 5 Then
	MOVF 0x44,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0051
; 193: 				program_set = 1
	MOVLW 0x01
	MOVWF 0x44
; 194: 			Endif
L0051:
; 195: 			Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 196: 			WaitMs 1500  'give some time for display to be read
	MOVLW 0xDC
	MOVWF R0L
	MOVLW 0x05
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 197: 			While ecsw = 0  'be sure pushbutton is released
L0052:
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0053
; 198: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 199: 			Wend
	BCF PCLATH,3
	GOTO L0052
L0053:
; 200: 		Endif
L0050:
; 201: 		Select Case program_set
; 202: 		Case 1  'correction position
	MOVF 0x44,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0054
; 203: 			value = act_pos
	MOVF 0x38,W
	MOVWF 0x37
; 204: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 205: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 206: 			Select Case result
; 207: 			Case 1
	MOVF 0x41,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0055
; 208: 				If new_steps < 60000 Then
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0056
; 209: 					ena = 1  'motor on
	BSF 0x07,2
; 210: 					new_steps = new_steps + 1
	MOVF 0x35,W
	ADDLW 0x01
	MOVWF 0x35
	MOVF 0x36,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x36
; 211: 					direction = 1
	BSF 0x07,0
; 212: 					clk = 1  'clock out
	BSF 0x07,1
; 213: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 214: 					clk = 0
	BCF 0x07,1
; 215: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 216: 				Endif
L0056:
; 217: 			Case 2
	BCF PCLATH,3
	GOTO L0057
L0055:
	MOVF 0x41,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0058
; 218: 				If new_steps > 0 Then
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0059
; 219: 					ena = 1  'motor on
	BSF 0x07,2
; 220: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x35,W
	MOVWF 0x35
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x36,W
	MOVWF 0x36
; 221: 					direction = 0
	BCF 0x07,0
; 222: 					clk = 1  'clock out
	BSF 0x07,1
; 223: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 224: 					clk = 0
	BCF 0x07,1
; 225: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 226: 				Endif
L0059:
; 227: 			Case Else
	BCF PCLATH,3
	GOTO L0060
L0058:
; 228: 			EndSelect
L0060:
L0057:
; 229: 		Case 2  'setting of maximum positions
	BCF PCLATH,3
	GOTO L0061
L0054:
	MOVF 0x44,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0062
; 230: 			ena = 0  'shut off motor
	BCF 0x07,2
; 231: 			If max_pos > 60 Then
	MOVF 0x34,W
	SUBLW 0x3C
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0063
; 232: 				max_pos = 60
	MOVLW 0x3C
	MOVWF 0x34
; 233: 			Endif
L0063:
; 234: 			value = max_pos
	MOVF 0x34,W
	MOVWF 0x37
; 235: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 236: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 237: 			Select Case result
; 238: 			Case 1
	MOVF 0x41,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0064
; 239: 				If max_pos < 60 Then  'display is limited to 60
	MOVLW 0x3C
	SUBWF 0x34,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0065
; 240: 					max_pos = max_pos + 1
	MOVF 0x34,W
	ADDLW 0x01
	MOVWF 0x34
; 241: 					Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0066:	BTFSC EECON1,WR
	GOTO L0066
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 242: 				Endif
L0065:
; 243: 			Case 2
	BCF PCLATH,3
	GOTO L0067
L0064:
	MOVF 0x41,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0068
; 244: 				If max_pos > 4 Then
	MOVF 0x34,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0069
; 245: 					max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 246: 					Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0070:	BTFSC EECON1,WR
	GOTO L0070
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 247: 				Endif
L0069:
; 248: 			Case Else
	BCF PCLATH,3
	GOTO L0071
L0068:
; 249: 			EndSelect
L0071:
L0067:
; 250: 		
; 251: 		Case 3  'setting of speed interval
	BCF PCLATH,3
	GOTO L0072
L0062:
	MOVF 0x44,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0073
; 252: 					'setting will be done in multiple of 256 uSecs
; 253: 					'minimum is 2 and maximum is 60 (is real slow)
; 254: 			ena = 0  'shut off motor
	BCF 0x07,2
; 255: 			If speed.HB > 60 Then
	MOVF 0x31,W
	SUBLW 0x3C
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0074
; 256: 				speed.HB = 60
	MOVLW 0x3C
	MOVWF 0x31
; 257: 				Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0075:	BTFSC EECON1,WR
	GOTO L0075
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 258: 			Endif
L0074:
; 259: 			value = speed.HB
	MOVF 0x31,W
	MOVWF 0x37
; 260: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 261: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 262: 			Select Case result
; 263: 			Case 1
	MOVF 0x41,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0076
; 264: 				If speed.HB < 100 Then  'display is limited to 100
	MOVLW 0x64
	SUBWF 0x31,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0077
; 265: 					speed.HB = speed.HB + 1
	MOVF 0x31,W
	ADDLW 0x01
	MOVWF 0x31
; 266: 					Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0078:	BTFSC EECON1,WR
	GOTO L0078
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 267: 				Endif
L0077:
; 268: 			Case 2
	BCF PCLATH,3
	GOTO L0079
L0076:
	MOVF 0x41,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0080
; 269: 				If speed.HB > 2 Then
	MOVF 0x31,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0081
; 270: 					speed.HB = speed.HB - 1
	MOVLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 271: 					Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0082:	BTFSC EECON1,WR
	GOTO L0082
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 272: 				Endif
L0081:
; 273: 			Case Else
	BCF PCLATH,3
	GOTO L0083
L0080:
; 274: 			EndSelect
L0083:
L0079:
; 275: 	
; 276: 		Case 4  'setting of extra free space steps
	BCF PCLATH,3
	GOTO L0084
L0073:
	MOVF 0x44,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0085
; 277: 			ena = 0  'shut off motor
	BCF 0x07,2
; 278: 			If free_space_steps > 250 Then
	MOVF 0x3A,W
	SUBLW 0xFA
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0086
; 279: 				free_space_steps = 250
	MOVLW 0xFA
	MOVWF 0x3A
; 280: 				Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0087:	BTFSC EECON1,WR
	GOTO L0087
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 281: 			Endif
L0086:
; 282: 			value = free_space_steps
	MOVF 0x3A,W
	MOVWF 0x37
; 283: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 284: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 285: 			Select Case result
; 286: 			Case 1
	MOVF 0x41,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0088
; 287: 				If free_space_steps < 60 Then  'display is limited to 60
	MOVLW 0x3C
	SUBWF 0x3A,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0089
; 288: 					free_space_steps = free_space_steps + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
; 289: 					Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0090:	BTFSC EECON1,WR
	GOTO L0090
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 290: 				Endif
L0089:
; 291: 			Case 2
	BCF PCLATH,3
	GOTO L0091
L0088:
	MOVF 0x41,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0092
; 292: 				If free_space_steps > 0 Then
	MOVF 0x3A,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0093
; 293: 					free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x3A,W
	MOVWF 0x3A
; 294: 					Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0094:	BTFSC EECON1,WR
	GOTO L0094
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 295: 				Endif
L0093:
; 296: 			Case Else
	BCF PCLATH,3
	GOTO L0095
L0092:
; 297: 			EndSelect
L0095:
L0091:
; 298: 		Case Else  'setting of control type
	BCF PCLATH,3
	GOTO L0096
L0085:
; 299: 			ena = 0  'shut off motor
	BCF 0x07,2
; 300: 			If ctrl_type > 3 Then
	MOVF 0x39,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0097
; 301: 				ctrl_type = 0
	CLRF 0x39
; 302: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0098:	BTFSC EECON1,WR
	GOTO L0098
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 303: 			Endif
L0097:
; 304: 			value = ctrl_type
	MOVF 0x39,W
	MOVWF 0x37
; 305: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 306: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 307: 			Select Case result
; 308: 			Case 1
	MOVF 0x41,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0099
; 309: 				If ctrl_type < 3 Then  'display is limited to 60
	MOVLW 0x03
	SUBWF 0x39,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0100
; 310: 					ctrl_type = ctrl_type + 1
	MOVF 0x39,W
	ADDLW 0x01
	MOVWF 0x39
; 311: 					Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0101:	BTFSC EECON1,WR
	GOTO L0101
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 312: 				Endif
L0100:
; 313: 			Case 2
	BCF PCLATH,3
	GOTO L0102
L0099:
	MOVF 0x41,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0103
; 314: 				If ctrl_type > 0 Then
	MOVF 0x39,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0104
; 315: 					ctrl_type = ctrl_type - 1
	MOVLW 0x01
	SUBWF 0x39,W
	MOVWF 0x39
; 316: 					Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0105:	BTFSC EECON1,WR
	GOTO L0105
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 317: 				Endif
L0104:
; 318: 			Case Else
	BCF PCLATH,3
	GOTO L0106
L0103:
; 319: 			EndSelect
L0106:
L0102:
; 320: 						
; 321: 		EndSelect
L0096:
L0084:
L0072:
L0061:
; 322: 		
; 323: 	Wend
	BCF PCLATH,3
	GOTO L0048
L0049:
; 324: 	ena = 0  'shut off motor
	BCF 0x07,2
; 325: 		'***************   now check if changes have to written in eeprom
; 326: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	MOVF 0x3E,W
	MOVWF R1L
	MOVF 0x3F,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C002
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0107
; 327: 		eprom_pointer1 = act_pos
	MOVF 0x38,W
	MOVWF 0x3B
; 328: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x3B,W
	ADDLW 0x3C
	MOVWF 0x43
; 329: 		Write eprom_pointer1, new_steps.LB
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0108:	BTFSC EECON1,WR
	GOTO L0108
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 330: 		Write eprom_pointer2, new_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0109:	BTFSC EECON1,WR
	GOTO L0109
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 331: 		Gosub check_next_steps
	BCF PCLATH,3
	CALL L0010
; 332: 	Endif
L0107:
; 333: 	value = act_pos
	MOVF 0x38,W
	MOVWF 0x37
; 334: 	Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 335: 	onoff = 1
	BSF 0x49,0
; 336: 	Gosub relays
	BCF PCLATH,3
	CALL L0009
; 337: Return
	RETURN
; 338: 
; 339: i2c_display:
L0005:
; 340: 	disp1_val = value
	MOVF 0x37,W
	MOVWF 0x45
; 341: 	disp1_val = disp1_val Mod 10
	MOVF 0x45,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x45
; 342: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x45,W
	SUBLW 0x09
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0110
	BCF PCLATH,3
	CALL L0111
	MOVWF 0x45
	BCF PCLATH,3
	GOTO L0110
L0111:
	MOVLW 0x04
	MOVWF PCLATH
	MOVF 0x45,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
L0110:
; 343: 	disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x45,7
	BTFSS 0x07,7
	BCF 0x45,7
; 344: 	disp2_val = value
	MOVF 0x37,W
	MOVWF 0x4B
; 345: 	disp2_val = disp2_val / 10
	MOVF 0x4B,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4B
; 346: 	disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x4B,W
	SUBLW 0x0A
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0112
	BCF PCLATH,3
	CALL L0113
	MOVWF 0x4B
	BCF PCLATH,3
	GOTO L0112
L0113:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x4B,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
L0112:
; 347: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 348: 	I2CSend disp1
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 349: 	I2CSend disp1_val
	BCF PCLATH,3
	MOVF 0x45,W
	CALL IC01
; 350: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 351: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 352: 	I2CSend disp2
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 353: 	I2CSend disp2_val
	BCF PCLATH,3
	MOVF 0x4B,W
	CALL IC01
; 354: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 355: Return
	RETURN
; 356: 
; 357: i2c_display_pgm:
L0006:
; 358: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010), program_set
	MOVF 0x44,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0114
	BCF PCLATH,3
	CALL L0115
	MOVWF 0x45
	BCF PCLATH,3
	GOTO L0114
L0115:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x44,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
L0114:
; 359: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 360: 	I2CSend disp1
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 361: 	I2CSend disp1_val
	BCF PCLATH,3
	MOVF 0x45,W
	CALL IC01
; 362: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 363: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 364: 	I2CSend disp2
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 365: 	I2CSend %10111111
	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 366: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 367: Return
	RETURN
; 368: 
; 369: steps_reading:
L0007:
; 370: 	If act_pos = 0 Then
	MOVF 0x38,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0116
; 371: 		act_steps = 0
	CLRF 0x3E
	CLRF 0x3F
; 372: 	Else
	BCF PCLATH,3
	GOTO L0117
L0116:
; 373: 		eprom_pointer1 = act_pos
	MOVF 0x38,W
	MOVWF 0x3B
; 374: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x3B,W
	ADDLW 0x3C
	MOVWF 0x43
; 375: 		Read eprom_pointer1, act_steps.LB
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3E
; 376: 		Read eprom_pointer2, act_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 377: 	Endif
L0117:
; 378: 	If new_pos = 0 Then
	MOVF 0x4A,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0118
; 379: 		new_steps = 0
	CLRF 0x35
	CLRF 0x36
; 380: 	Else
	BCF PCLATH,3
	GOTO L0119
L0118:
; 381: 		eprom_pointer1 = new_pos
	MOVF 0x4A,W
	MOVWF 0x3B
; 382: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x3B,W
	ADDLW 0x3C
	MOVWF 0x43
; 383: 		Read eprom_pointer1, new_steps.LB
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x35
; 384: 		Read eprom_pointer2, new_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 385: 	Endif
L0119:
; 386: Return
	RETURN
; 387: 
; 388: stepmotor:
L0008:
; 389: 	speed = 0
	CLRF 0x30
	CLRF 0x31
; 390: 	Read mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 391: 	Read mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3A
; 392: 	Gosub steps_reading
	BCF PCLATH,3
	CALL L0007
; 393: 	If new_steps = 0 Then
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C001
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0120
; 394: 		direction = 0
	BCF 0x07,0
; 395: 		ena = 1  'set anable on
	BSF 0x07,2
; 396: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 397: 		While zero = 1  'turn motor until zero switch is activated
L0121:
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0122
; 398: 			clk = 1  'clock out
	BSF 0x07,1
; 399: 			WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 400: 			clk = 0
	BCF 0x07,1
; 401: 			WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 402: 		Wend
	BCF PCLATH,3
	GOTO L0121
L0122:
; 403: 		act_pos = 0
	CLRF 0x38
; 404: 		Write mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0123:	BTFSC EECON1,WR
	GOTO L0123
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 405: 		If ctrl_type > 1 Then  'NOW GO ONE MORE COMPLETE ROUND FOR COUNTING STEPS
	MOVF 0x39,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0124
; 406: 			one_round = 0
	CLRF 0x32
	CLRF 0x33
; 407: 			ena = 1  'set anable on
	BSF 0x07,2
; 408: 			While zero = 0  'turn motor until zero switch is activated
L0125:
	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0126
; 409: 				clk = 1  'clock out
	BSF 0x07,1
; 410: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 411: 				clk = 0
	BCF 0x07,1
; 412: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 413: 				one_round = one_round + 1
	MOVF 0x32,W
	ADDLW 0x01
	MOVWF 0x32
	MOVF 0x33,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x33
; 414: 			Wend
	BCF PCLATH,3
	GOTO L0125
L0126:
; 415: 			While zero = 1  'turn motor until zero switch is activated
L0127:
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0128
; 416: 				clk = 1  'clock out
	BSF 0x07,1
; 417: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 418: 				clk = 0
	BCF 0x07,1
; 419: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 420: 				one_round = one_round + 1
	MOVF 0x32,W
	ADDLW 0x01
	MOVWF 0x32
	MOVF 0x33,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x33
; 421: 			Wend
	BCF PCLATH,3
	GOTO L0127
L0128:
; 422: 			one_round_half = one_round / 2
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4D
	MOVF R0H,W
	MOVWF 0x4E
; 423: 			Write mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0129:	BTFSC EECON1,WR
	GOTO L0129
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 424: 			Write mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0130:	BTFSC EECON1,WR
	GOTO L0130
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 425: 		Endif
L0124:
; 426: 		ena = 0  'set anable off
	BCF 0x07,2
; 427: 		act_pos = 0
	CLRF 0x38
; 428: 	Else
	BCF PCLATH,3
	GOTO L0131
L0120:
; 429: 		steps = 0
	CLRF 0x3C
	CLRF 0x3D
; 430: 		If new_steps > act_steps Then
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	MOVF 0x3E,W
	MOVWF R1L
	MOVF 0x3F,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0132
; 431: 			steps = new_steps - act_steps
	MOVF 0x3E,W
	SUBWF 0x35,W
	MOVWF 0x3C
	MOVF 0x3F,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x36,W
	MOVWF 0x3D
; 432: 			direction = 1
	BSF 0x07,0
; 433: 			If steps > one_round_half Then  'is other direction shorter?
	MOVF 0x3C,W
	MOVWF R0L
	MOVF 0x3D,W
	MOVWF R0H
	MOVF 0x4D,W
	MOVWF R1L
	MOVF 0x4E,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0133
; 434: 				If ctrl_type > 1 Then  'check If short way is set
	MOVF 0x39,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0134
; 435: 					Read mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 436: 					If turn_counter > 126 Then  'check if shortest way is allowed
	MOVF 0x40,W
	SUBLW 0x7E
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0135
; 437: 						turn_counter = turn_counter - 1  'yes it is, so substract one pass
	MOVLW 0x01
	SUBWF 0x40,W
	MOVWF 0x40
; 438: 						steps = one_round - steps  'go shortest way
	MOVF 0x3C,W
	SUBWF 0x32,W
	MOVWF 0x3C
	MOVF 0x3D,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x33,W
	MOVWF 0x3D
; 439: 						direction = 0  'change  direction
	BCF 0x07,0
; 440: 						Write mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0136:	BTFSC EECON1,WR
	GOTO L0136
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 441: 					Endif
L0135:
; 442: 				Endif
L0134:
; 443: 			Endif
L0133:
; 444: 		Else
	BCF PCLATH,3
	GOTO L0137
L0132:
; 445: 			steps = act_steps - new_steps
	MOVF 0x35,W
	SUBWF 0x3E,W
	MOVWF 0x3C
	MOVF 0x36,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x3D
; 446: 			direction = 0
	BCF 0x07,0
; 447: 			If steps > one_round_half Then  'other direction shorter?
	MOVF 0x3C,W
	MOVWF R0L
	MOVF 0x3D,W
	MOVWF R0H
	MOVF 0x4D,W
	MOVWF R1L
	MOVF 0x4E,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0138
; 448: 				If ctrl_type > 1 Then  'check If short way is set
	MOVF 0x39,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0139
; 449: 					Read mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 450: 					If turn_counter < 130 Then  'check if shortest way is allowed
	MOVLW 0x82
	SUBWF 0x40,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0140
; 451: 						turn_counter = turn_counter + 1  'yes it is, so add one pass
	MOVF 0x40,W
	ADDLW 0x01
	MOVWF 0x40
; 452: 						steps = one_round - steps  'go shortest way
	MOVF 0x3C,W
	SUBWF 0x32,W
	MOVWF 0x3C
	MOVF 0x3D,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x33,W
	MOVWF 0x3D
; 453: 						direction = 1  'change direction
	BSF 0x07,0
; 454: 						Write mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0141:	BTFSC EECON1,WR
	GOTO L0141
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 455: 					Endif
L0140:
; 456: 				Endif
L0139:
; 457: 			Endif
L0138:
; 458: 		Endif
L0137:
; 459: 		If steps > 0 Then  'tt must be activated
	MOVF 0x3C,W
	MOVWF R0L
	MOVF 0x3D,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0142
; 460: 			If direction = 1 Then
	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0143
; 461: 				steps = steps + free_space_steps
	MOVF 0x3C,W
	ADDWF 0x3A,W
	MOVWF 0x3C
	MOVF 0x3D,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x3D
; 462: 			Endif
L0143:
; 463: 			ena = 1  'set anable on
	BSF 0x07,2
; 464: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 465: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0144:
	MOVF 0x3C,W
	MOVWF R0L
	MOVF 0x3D,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0145
; 466: 				clk = 1  'clock out
	BSF 0x07,1
; 467: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 468: 				clk = 0
	BCF 0x07,1
; 469: 				WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 470: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x3C,W
	MOVWF 0x3C
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
; 471: 			Wend
	BCF PCLATH,3
	GOTO L0144
L0145:
; 472: 			WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 473: 			If direction = 1 Then
	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0146
; 474: 				steps = free_space_steps
	MOVF 0x3A,W
	MOVWF 0x3C
	CLRF 0x3D
; 475: 				direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 476: 				While steps > 0  'NOW RUN UNTIL STEPS = 0
L0147:
	MOVF 0x3C,W
	MOVWF R0L
	MOVF 0x3D,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0148
; 477: 					clk = 1  'clock out
	BSF 0x07,1
; 478: 					WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 479: 					clk = 0
	BCF 0x07,1
; 480: 					WaitUs speed
	MOVF 0x30,W
	MOVWF R4L
	MOVF 0x31,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 481: 					steps = steps - 1
	MOVLW 0x01
	SUBWF 0x3C,W
	MOVWF 0x3C
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
; 482: 				Wend
	BCF PCLATH,3
	GOTO L0147
L0148:
; 483: 			Endif
L0146:
; 484: 			ena = 0  'enable off
	BCF 0x07,2
; 485: 			pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 486: 		Endif
L0142:
; 487: 	Endif
L0131:
; 488: 	act_pos = new_pos
	MOVF 0x4A,W
	MOVWF 0x38
; 489: 	Write mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0149:	BTFSC EECON1,WR
	GOTO L0149
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 490: 	bus_pos = act_pos
	MOVF 0x38,W
	MOVWF 0x46
; 491: 	old_bus_pos = act_pos
	MOVF 0x38,W
	MOVWF 0x4F
; 492: 	manual_pos = act_pos
	MOVF 0x38,W
	MOVWF 0x42
; 493: 	old_manual_pos = act_pos
	MOVF 0x38,W
	MOVWF 0x50
; 494: Return
	RETURN
; 495: 
; 496: 
; 497: relays:
L0009:
; 498: 	If onoff = 1 Then
	BCF PCLATH,3
	BTFSS 0x49,0
	GOTO L0150
; 499: 		value = max_pos + 1
	MOVF 0x34,W
	ADDLW 0x01
	MOVWF 0x37
; 500: 		value = value / 2  'calulation of half max positions
	MOVF 0x37,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x37
; 501: 		Select Case ctrl_type
; 502: 		Case 1, 3
	MOVF 0x39,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0153
	BCF PCLATH,3
	GOTO L0152
L0153:
	MOVF 0x39,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0151
L0152:
; 503: 			swfw = 1
	BSF 0x06,0
; 504: 			swrev = 0
	BCF 0x06,1
; 505: 		Case Else
	BCF PCLATH,3
	GOTO L0154
L0151:
; 506: 			If act_pos > value Then  'select polarity rails on bridge
	MOVF 0x38,W
	SUBWF 0x37,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0155
; 507: 				swfw = 0
	BCF 0x06,0
; 508: 				swrev = 1
	BSF 0x06,1
; 509: 			Else
	BCF PCLATH,3
	GOTO L0156
L0155:
; 510: 				swrev = 0
	BCF 0x06,1
; 511: 				swfw = 1
	BSF 0x06,0
; 512: 			Endif
L0156:
; 513: 		EndSelect
L0154:
; 514: 	Else
	BCF PCLATH,3
	GOTO L0157
L0150:
; 515: 		swfw = 0
	BCF 0x06,0
; 516: 		swrev = 0
	BCF 0x06,1
; 517: 	Endif
L0157:
; 518: Return
	RETURN
; 519: 
; 520: 
; 521: check_next_steps:
L0010:
; 522: 	'this is ment to check all following steps after readjusting one position.
; 523: 	'simply to avoid that tt will go backwards when set for the next (higher) position.
; 524: 	value = act_pos
	MOVF 0x38,W
	MOVWF 0x37
; 525: 	While value < max_pos
L0158:
	MOVF 0x34,W
	SUBWF 0x37,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0159
; 526: 		eprom_pointer1 = value
	MOVF 0x37,W
	MOVWF 0x3B
; 527: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x3B,W
	ADDLW 0x3C
	MOVWF 0x43
; 528: 		Read eprom_pointer1, act_steps.LB
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3E
; 529: 		Read eprom_pointer2, act_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 530: 		eprom_pointer1 = eprom_pointer1 + 1
	MOVF 0x3B,W
	ADDLW 0x01
	MOVWF 0x3B
; 531: 		eprom_pointer2 = eprom_pointer2 + 1
	MOVF 0x43,W
	ADDLW 0x01
	MOVWF 0x43
; 532: 		Read eprom_pointer1, new_steps.LB
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x35
; 533: 		Read eprom_pointer2, new_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 534: 		While new_steps < act_steps
L0160:
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	MOVF 0x3E,W
	MOVWF R1L
	MOVF 0x3F,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0161
; 535: 			new_steps = new_steps + 50
	MOVF 0x35,W
	ADDLW 0x32
	MOVWF 0x35
	MOVF 0x36,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x36
; 536: 		Wend
	BSF PCLATH,3
	GOTO L0160
L0161:
; 537: 		Write eprom_pointer1, new_steps.LB
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0162:	BTFSC EECON1,WR
	GOTO L0162
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 538: 		Write eprom_pointer2, new_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0163:	BTFSC EECON1,WR
	GOTO L0163
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 539: 		value = value + 1
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x37
; 540: 	Wend
	BCF PCLATH,3
	GOTO L0158
L0159:
; 541: Return
	RETURN
; 542: 
; 543: 
; 544: init_eeprom:
L0011:
; 545: 			'check if acceptable value is in eeprom
; 546: 	Read mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 547: 	If max_pos < 2 Then
	MOVLW 0x02
	SUBWF 0x34,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0164
; 548: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x34
; 549: 		Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0165:	BTFSC EECON1,WR
	GOTO L0165
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 550: 	Endif
L0164:
; 551: 	If max_pos > 60 Then
	MOVF 0x34,W
	SUBLW 0x3C
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0166
; 552: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x34
; 553: 		Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0167:	BTFSC EECON1,WR
	GOTO L0167
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 554: 	Endif
L0166:
; 555: 	act_pos = 1
	MOVLW 0x01
	MOVWF 0x38
; 556: 	Write mem_act_pos, 1  'act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x01
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0168:	BTFSC EECON1,WR
	GOTO L0168
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 557: 	act_steps = 0
	CLRF 0x3E
	CLRF 0x3F
; 558: 	one_round = 8000
	MOVLW 0x40
	MOVWF 0x32
	MOVLW 0x1F
	MOVWF 0x33
; 559: 		'check memory for correct total steps
; 560: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x32
; 561: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 562: 	If one_round > 40000 Then
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVLW 0x40
	MOVWF R1L
	MOVLW 0x9C
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0169
; 563: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x32
	MOVLW 0x1F
	MOVWF 0x33
; 564: 		Write mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0170:	BTFSC EECON1,WR
	GOTO L0170
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 565: 		Write mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0171:	BTFSC EECON1,WR
	GOTO L0171
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 566: 	Endif
L0169:
; 567: 
; 568: 	For eprom_pointer1 = 1 To max_pos
	MOVLW 0x01
	MOVWF 0x3B
L0172:
	MOVF 0x3B,W
	SUBWF 0x34,W
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0173
; 569: 		new_steps = one_round / max_pos  'devide the steps between min and max
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVF 0x34,W
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x35
	MOVF R0H,W
	MOVWF 0x36
; 570: 		act_steps = act_steps + new_steps
	MOVF 0x3E,W
	ADDWF 0x35,W
	MOVWF 0x3E
	MOVF 0x3F,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x36,W
	MOVWF 0x3F
; 571: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x3B,W
	ADDLW 0x3C
	MOVWF 0x43
; 572: 		Write eprom_pointer1, act_steps.LB
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0174:	BTFSC EECON1,WR
	GOTO L0174
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 573: 		Write eprom_pointer2, act_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0175:	BTFSC EECON1,WR
	GOTO L0175
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 574: 	Next eprom_pointer1
	MOVLW 0x01
	ADDWF 0x3B,F
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0172
L0173:
; 575: 
; 576: 	speed = 20 * 256
	MOVLW 0x14
	MOVWF R3L
	CLRF R3H
	CLRF R1L
	MOVLW 0x01
	MOVWF R1H
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x30
	MOVF R2H,W
	MOVWF 0x31
; 577: 	Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0176:	BTFSC EECON1,WR
	GOTO L0176
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 578: 
; 579: 	free_space_steps = 20
	MOVLW 0x14
	MOVWF 0x3A
; 580: 	Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0177:	BTFSC EECON1,WR
	GOTO L0177
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 581: 			'check for correct control type
; 582: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 583: 	If ctrl_type > 3 Then
	MOVF 0x39,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0178
; 584: 		ctrl_type = 0
	CLRF 0x39
; 585: 		Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0179:	BTFSC EECON1,WR
	GOTO L0179
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 586: 	Endif
L0178:
; 587: 			'now check for correct amount of 0-point passes
; 588: 	Read mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 589: 	If turn_counter > 131 Then  'in program impossible value
	MOVF 0x40,W
	SUBLW 0x83
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0180
; 590: 		turn_counter = 128
	MOVLW 0x80
	MOVWF 0x40
; 591: 		Write mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0181:	BTFSC EECON1,WR
	GOTO L0181
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 592: 	Else
	BSF PCLATH,3
	GOTO L0182
L0180:
; 593: 		If turn_counter < 125 Then  'in program impossible value
	MOVLW 0x7D
	SUBWF 0x40,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0183
; 594: 			turn_counter = 128
	MOVLW 0x80
	MOVWF 0x40
; 595: 			Write mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0184:	BTFSC EECON1,WR
	GOTO L0184
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 596: 		Endif
L0183:
; 597: 	Endif
L0182:
; 598: 
; 599: Return
	RETURN
; 600: 
; 601: init_values:
L0012:
; 602: 
; 603: 	encoder_count = 0
	CLRF 0x48
; 604: 	speed = 0
	CLRF 0x30
	CLRF 0x31
; 605: 	If eep = 1 Then  'jumper set for initialisation
	BSF PCLATH,3
	BTFSS 0x06,6
	GOTO L0185
; 606: 		Gosub init_eeprom
	BSF PCLATH,3
	CALL L0011
; 607: 	Endif
L0185:
; 608: 	speed = 0
	CLRF 0x30
	CLRF 0x31
; 609: 	Read mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 610: 	If speed.HB > 100 Then
	MOVF 0x31,W
	SUBLW 0x64
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0186
; 611: 		speed.HB = 100
	MOVLW 0x64
	MOVWF 0x31
; 612: 		Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0187:	BTFSC EECON1,WR
	GOTO L0187
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 613: 	Endif
L0186:
; 614: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x32
; 615: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 616: 	If one_round = 0 Then
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C001
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0188
; 617: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x32
	MOVLW 0x1F
	MOVWF 0x33
; 618: 		Write mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0189:	BTFSC EECON1,WR
	GOTO L0189
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 619: 		Write mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0190:	BTFSC EECON1,WR
	GOTO L0190
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 620: 	Endif
L0188:
; 621: 	If one_round > 40000 Then
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVLW 0x40
	MOVWF R1L
	MOVLW 0x9C
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0191
; 622: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x32
	MOVLW 0x1F
	MOVWF 0x33
; 623: 		Write mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0192:	BTFSC EECON1,WR
	GOTO L0192
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 624: 		Write mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0193:	BTFSC EECON1,WR
	GOTO L0193
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 625: 	Endif
L0191:
; 626: 	one_round_half = one_round / 2
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4D
	MOVF R0H,W
	MOVWF 0x4E
; 627: 	Read mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 628: 	If max_pos > 60 Then
	MOVF 0x34,W
	SUBLW 0x3C
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0194
; 629: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x34
; 630: 		Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0195:	BTFSC EECON1,WR
	GOTO L0195
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 631: 	Endif
L0194:
; 632: 	Read mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x38
; 633: 	If act_pos > max_pos Then
	MOVF 0x38,W
	SUBWF 0x34,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0196
; 634: 		act_pos = 1
	MOVLW 0x01
	MOVWF 0x38
; 635: 		Write mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0197:	BTFSC EECON1,WR
	GOTO L0197
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 636: 	Endif
L0196:
; 637: 	Read mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3A
; 638: 	If free_space_steps > 250 Then
	MOVF 0x3A,W
	SUBLW 0xFA
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0198
; 639: 		free_space_steps = 20
	MOVLW 0x14
	MOVWF 0x3A
; 640: 		Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0199:	BTFSC EECON1,WR
	GOTO L0199
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 641: 	Endif
L0198:
; 642: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 643: 	If ctrl_type > 3 Then
	MOVF 0x39,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0200
; 644: 		ctrl_type = 0
	CLRF 0x39
; 645: 		Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0201:	BTFSC EECON1,WR
	GOTO L0201
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 646: 	Endif
L0200:
; 647: 	new_pos = act_pos
	MOVF 0x38,W
	MOVWF 0x4A
; 648: 	bus_pos = PORTA And 63  'cancel first input from MGV50
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x46
; 649: 	old_bus_pos = bus_pos
	MOVF 0x46,W
	MOVWF 0x4F
; 650: 	manual_pos = act_pos
	MOVF 0x38,W
	MOVWF 0x42
; 651: Return
	RETURN
; End of program
	BSF PCLATH,3
L0202:	GOTO L0202
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
