; Compiled with: PIC Simulator IDE v6.90
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_turn_counter' (global) is 0
;       The value of 'mem_act_pos' (global) is 121
;       The value of 'mem_speed' (global) is 122
;       The value of 'mem_one_round_lb' (global) is 123
;       The value of 'mem_one_round_hb' (global) is 124
;       The value of 'mem_ctrl_type' (global) is 125
;       The value of 'mem_max_pos' (global) is 126
;       The value of 'mem_free_space' (global) is 127
;       The address of 'one_round' (word) (global) is 0x30
	one_round EQU 0x30
;       The address of 'speed' (word) (global) is 0x32
	speed EQU 0x32
;       The address of 'ctrl_type' (byte) (global) is 0x34
	ctrl_type EQU 0x34
;       The address of 'max_pos' (byte) (global) is 0x35
	max_pos EQU 0x35
;       The address of 'value' (byte) (global) is 0x36
	value EQU 0x36
;       The address of 'new_steps' (word) (global) is 0x37
	new_steps EQU 0x37
;       The address of 'act_pos' (byte) (global) is 0x39
	act_pos EQU 0x39
;       The address of 'steps' (word) (global) is 0x3A
	steps EQU 0x3A
;       The address of 'free_space_steps' (byte) (global) is 0x3C
	free_space_steps EQU 0x3C
;       The address of 'eprom_pointer1' (byte) (global) is 0x3D
	eprom_pointer1 EQU 0x3D
;       The address of 'act_steps' (word) (global) is 0x3E
	act_steps EQU 0x3E
;       The address of 'turn_counter' (byte) (global) is 0x40
	turn_counter EQU 0x40
;       The address of 'result' (byte) (global) is 0x41
	result EQU 0x41
;       The address of 'manual_pos' (byte) (global) is 0x42
	manual_pos EQU 0x42
;       The address of 'eprom_pointer2' (byte) (global) is 0x43
	eprom_pointer2 EQU 0x43
;       The address of 'program_set' (byte) (global) is 0x44
	program_set EQU 0x44
;       The address of 'disp1_val' (byte) (global) is 0x45
	disp1_val EQU 0x45
;       The address of 'new_encoder' (byte) (global) is 0x46
	new_encoder EQU 0x46
;       The address of 'encoder_count' (byte) (global) is 0x47
	encoder_count EQU 0x47
;       The address of 'bus_pos' (byte) (global) is 0x48
	bus_pos EQU 0x48
;       The address of 'onoff' (bit) (global) is 0x49,0
;       The address of 'disp2_val' (byte) (global) is 0x4A
	disp2_val EQU 0x4A
;       The address of 'new_pos' (byte) (global) is 0x4B
	new_pos EQU 0x4B
;       The address of 'old_encoder' (byte) (global) is 0x4C
	old_encoder EQU 0x4C
;       The address of 'old_manual_pos' (byte) (global) is 0x4D
	old_manual_pos EQU 0x4D
;       The address of 'one_round_half' (word) (global) is 0x4E
	one_round_half EQU 0x4E
;       The address of 'old_bus_pos' (byte) (global) is 0x50
	old_bus_pos EQU 0x50
;       The address of 'old_pos_write' (bit) (global) is 0x49,1
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'eep' (bit) (global) is 0x6,6
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x7,3
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0013
	ORG 0x0004
	RETFIE
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0013:
; 1: 'program TT for PCBoard MGV145
; 2: 'version V3-1  Fiddle Yard version, for turntables and fiddle yard
; 3: 'this version has all possibilities changeable by menue's.
; 4: 'V3-2 counter for twisting cables tored at eeprom pos zero.
; 5: 'the value of the counter can be anything between 125 and 131. 128 is zero point.
; 6: 'V3-3 eeprom startup improved. Reprogramming PIC can now be done without reprogramming data
; 7: 'V3.6 startup delayed, to avoid wrong positions
; 8: Define CONF_WORD = 0x3f72
; 9: Define CLOCK_FREQUENCY = 20
; 10: Dim steps As Word
; 11: Dim program_set As Byte
; 12: Dim new_steps As Word
; 13: Dim act_steps As Word
; 14: Dim new_pos As Byte
; 15: Dim act_pos As Byte
; 16: Dim one_round As Word
; 17: Dim one_round_half As Word
; 18: Dim bus_pos As Byte
; 19: Dim old_bus_pos As Byte
; 20: Dim speed As Word
; 21: Dim new_encoder As Byte
; 22: Dim old_encoder As Byte
; 23: Dim manual_pos As Byte
; 24: Dim old_manual_pos As Byte
; 25: Dim result As Byte
; 26: Dim free_space_steps As Byte
; 27: Dim value As Byte
; 28: Dim eprom_pointer1 As Byte
; 29: Dim eprom_pointer2 As Byte
; 30: Dim encoder_count As Byte
; 31: Dim turn_counter As Byte
; 32: Dim onoff As Bit
; 33: Dim max_pos As Byte
; 34: Dim disp1_val As Byte
; 35: Dim disp2_val As Byte
; 36: Dim ctrl_type As Byte
; 37: Dim old_pos_write As Bit
; 38: Const disp1 = 64
; 39: Const disp2 = 66
; 40: Const mem_turn_counter = 0
; 41: Const mem_act_pos = 121
; 42: Const mem_speed = 122
; 43: Const mem_one_round_lb = 123
; 44: Const mem_one_round_hb = 124
; 45: Const mem_ctrl_type = 125
; 46: Const mem_max_pos = 126
; 47: Const mem_free_space = 127
; 48: Symbol swfw = RB0
; 49: Symbol swrev = RB1
; 50: Symbol sck = RB2
; 51: Symbol sda = RB3
; 52: Symbol pos_match = RB4
; 53: Symbol pos_write = RB5
; 54: Symbol eep = RB6
; 55: Symbol direction = RC0
; 56: Symbol clk = RC1
; 57: Symbol ena = RC2
; 58: Symbol zero = RC3
; 59: Symbol ec1 = RC4
; 60: Symbol ec2 = RC5
; 61: Symbol ecsw = RC6
; 62: Symbol pgm = RC7
; 63: ADCON1 = %0110
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 64: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 65: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 66: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 67: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 68: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 69: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 70: Gosub init_values
	BSF PCLATH,3
	CALL L0012
; 71: value = act_pos
	MOVF 0x39,W
	MOVWF 0x36
; 72: Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 73: onoff = 1
	BSF 0x49,0
; 74: Gosub relays
	BSF PCLATH,3
	CALL L0009
; 75: program_set = 1
	MOVLW 0x01
	MOVWF 0x44
; 76: main:
L0001:
; 77: 	If pgm = 0 Then
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0014
; 78: 		Gosub adjust_settings
	BCF PCLATH,3
	CALL L0004
; 79: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 80: 	Endif
L0014:
; 81: 
; 82: 	Gosub get_new_position
	BCF PCLATH,3
	CALL L0002
; 83: 	If bus_pos <> old_bus_pos Then
	MOVF 0x48,W
	SUBWF 0x50,W
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0015
; 84: 		onoff = 0
	BCF 0x49,0
; 85: 		Gosub relays
	BSF PCLATH,3
	CALL L0009
; 86: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 87: 		new_pos = bus_pos
	MOVF 0x48,W
	MOVWF 0x4B
; 88: 		Gosub stepmotor
	BCF PCLATH,3
	CALL L0008
; 89: 		value = act_pos
	MOVF 0x39,W
	MOVWF 0x36
; 90: 		Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 91: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 92: 		onoff = 1
	BSF 0x49,0
; 93: 	Else
	BCF PCLATH,3
	GOTO L0016
L0015:
; 94: 		If ecsw = 0 Then  'only when knob is pushed
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0017
; 95: 			If manual_pos <> old_manual_pos Then
	MOVF 0x42,W
	SUBWF 0x4D,W
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0018
; 96: 				onoff = 0
	BCF 0x49,0
; 97: 				Gosub relays
	BSF PCLATH,3
	CALL L0009
; 98: 				pos_match = 1  'indicate not in position
	BSF 0x06,4
; 99: 				old_manual_pos = manual_pos
	MOVF 0x42,W
	MOVWF 0x4D
; 100: 				new_pos = manual_pos
	MOVF 0x42,W
	MOVWF 0x4B
; 101: 				Gosub stepmotor
	BCF PCLATH,3
	CALL L0008
; 102: 				value = act_pos
	MOVF 0x39,W
	MOVWF 0x36
; 103: 				Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 104: 				pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 105: 				onoff = 1
	BSF 0x49,0
; 106: 			Endif
L0018:
; 107: 		Endif
L0017:
; 108: 	Endif
L0016:
; 109: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 110: 	Gosub relays
	BSF PCLATH,3
	CALL L0009
; 111: 	Goto main
	BCF PCLATH,3
	GOTO L0001
; 112: End
	BCF PCLATH,3
L0019:	GOTO L0019
; 113: 
; 114: 
; 115: get_new_position:
L0002:
; 116: 	value = bus_pos  'remember the position
	MOVF 0x48,W
	MOVWF 0x36
; 117: 	If pos_write = 1 Then
	BCF PCLATH,3
	BTFSS 0x06,5
	GOTO L0020
; 118: 		If old_pos_write = 0 Then  'react only once on rising edge
	BCF PCLATH,3
	BTFSC 0x49,1
	GOTO L0021
; 119: 			old_pos_write = 1
	BSF 0x49,1
; 120: 			value = PORTA And 63  'now get value from J5
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x36
; 121: 			If value > max_pos Then  'this is not allowed
	MOVF 0x36,W
	SUBWF 0x35,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0022
; 122: 				value = bus_pos  'put it back to old situation
	MOVF 0x48,W
	MOVWF 0x36
; 123: 			Endif
L0022:
; 124: 			If value = 0 Then  'do not accept 0
	MOVF 0x36,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0023
; 125: 				value = bus_pos  'put it back to old situation
	MOVF 0x48,W
	MOVWF 0x36
; 126: 			Endif
L0023:
; 127: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 128: 		Endif
L0021:
; 129: 	Else
	BCF PCLATH,3
	GOTO L0024
L0020:
; 130: 		old_pos_write = 0
	BCF 0x49,1
; 131: 	Endif
L0024:
; 132: 	bus_pos = value  'now take over the dseired position
	MOVF 0x36,W
	MOVWF 0x48
; 133: 	Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 134: 	Select Case result
; 135: 	Case 1
	MOVF 0x41,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0025
; 136: 		If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x47,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0026
; 137: 			encoder_count = encoder_count + 1
	MOVF 0x47,W
	ADDLW 0x01
	MOVWF 0x47
; 138: 		Else
	BCF PCLATH,3
	GOTO L0027
L0026:
; 139: 			encoder_count = 0
	CLRF 0x47
; 140: 			manual_pos = manual_pos + 1
	MOVF 0x42,W
	ADDLW 0x01
	MOVWF 0x42
; 141: 			If manual_pos > max_pos Then
	MOVF 0x42,W
	SUBWF 0x35,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0028
; 142: 				manual_pos = max_pos
	MOVF 0x35,W
	MOVWF 0x42
; 143: 			Endif
L0028:
; 144: 			value = manual_pos
	MOVF 0x42,W
	MOVWF 0x36
; 145: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 146: 		Endif
L0027:
; 147: 	Case 2
	BCF PCLATH,3
	GOTO L0029
L0025:
	MOVF 0x41,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0030
; 148: 		If encoder_count > 0 Then
	MOVF 0x47,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0031
; 149: 			encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x47,W
	MOVWF 0x47
; 150: 		Else
	BCF PCLATH,3
	GOTO L0032
L0031:
; 151: 			encoder_count = 4
	MOVLW 0x04
	MOVWF 0x47
; 152: 			If manual_pos > 0 Then
	MOVF 0x42,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0033
; 153: 				manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x42,W
	MOVWF 0x42
; 154: 			Endif
L0033:
; 155: 			value = manual_pos
	MOVF 0x42,W
	MOVWF 0x36
; 156: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 157: 		Endif
L0032:
; 158: 	Case Else
	BCF PCLATH,3
	GOTO L0034
L0030:
; 159: 	EndSelect
L0034:
L0029:
; 160: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 161: 	
; 162: Return
	RETURN
; 163: 
; 164: calc_rotation:  'this routine checks the incrimental switch
L0003:
; 165: '1 = increasing value
; 166: '2 = decreasing value
; 167: '3 = no change
; 168: 		new_encoder = 0
	CLRF 0x46
; 169: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x46,0
	BTFSS 0x07,4
	BCF 0x46,0
; 170: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x46,1
	BTFSS 0x07,5
	BCF 0x46,1
; 171: 		Select Case old_encoder
; 172: 		Case 0
	MOVF 0x4C,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0035
; 173: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x46,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0036
	BCF PCLATH,3
	CALL L0037
	MOVWF 0x41
	BCF PCLATH,3
	GOTO L0036
L0037:
	MOVLW 0x01
	MOVWF PCLATH
	MOVF 0x46,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
L0036:
; 174: 		Case 1
	BCF PCLATH,3
	GOTO L0038
L0035:
	MOVF 0x4C,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0039
; 175: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x46,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0040
	BCF PCLATH,3
	CALL L0041
	MOVWF 0x41
	BCF PCLATH,3
	GOTO L0040
L0041:
	MOVLW 0x01
	MOVWF PCLATH
	MOVF 0x46,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
L0040:
; 176: 		Case 2
	BCF PCLATH,3
	GOTO L0042
L0039:
	MOVF 0x4C,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0043
; 177: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x46,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0044
	BCF PCLATH,3
	CALL L0045
	MOVWF 0x41
	BCF PCLATH,3
	GOTO L0044
L0045:
	NOP
	NOP
	NOP
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x46,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
L0044:
; 178: 		Case Else
	BCF PCLATH,3
	GOTO L0046
L0043:
; 179: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x46,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0047
	BCF PCLATH,3
	CALL L0048
	MOVWF 0x41
	BCF PCLATH,3
	GOTO L0047
L0048:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x46,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
L0047:
; 180: 		EndSelect
L0046:
L0042:
L0038:
; 181: 		old_encoder = new_encoder
	MOVF 0x46,W
	MOVWF 0x4C
; 182: Return
	RETURN
; 183: 
; 184: 
; 185: adjust_settings:
L0004:
; 186: 	onoff = 0
	BCF 0x49,0
; 187: 	Gosub relays
	BSF PCLATH,3
	CALL L0009
; 188: 	Gosub steps_reading
	BCF PCLATH,3
	CALL L0007
; 189: 	Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 190: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x3E,W
	MOVWF 0x37
	MOVF 0x3F,W
	MOVWF 0x38
; 191: 	Read mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3C
; 192: 	Read mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 193: 	Read mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x35
; 194: 	Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 195: 	WaitMs 1500  'give some time for display to be read
	MOVLW 0xDC
	MOVWF R0L
	MOVLW 0x05
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 196: 	While pgm = 0
L0049:
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0050
; 197: 		If ecsw = 0 Then  'knob is pressed, adjust max positions
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0051
; 198: 			program_set = program_set + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
; 199: 			If program_set > 5 Then
	MOVF 0x44,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0052
; 200: 				program_set = 1
	MOVLW 0x01
	MOVWF 0x44
; 201: 			Endif
L0052:
; 202: 			Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 203: 			WaitMs 1500  'give some time for display to be read
	MOVLW 0xDC
	MOVWF R0L
	MOVLW 0x05
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 204: 			While ecsw = 0  'be sure pushbutton is released
L0053:
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0054
; 205: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 206: 			Wend
	BCF PCLATH,3
	GOTO L0053
L0054:
; 207: 		Endif
L0051:
; 208: 		Select Case program_set
; 209: 		Case 1  'correction position
	MOVF 0x44,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0055
; 210: 			value = act_pos
	MOVF 0x39,W
	MOVWF 0x36
; 211: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 212: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 213: 			Select Case result
; 214: 			Case 1
	MOVF 0x41,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0056
; 215: 				If new_steps < 60000 Then
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0057
; 216: 					ena = 1  'motor on
	BSF 0x07,2
; 217: 					new_steps = new_steps + 1
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x37
	MOVF 0x38,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x38
; 218: 					direction = 1
	BSF 0x07,0
; 219: 					clk = 1  'clock out
	BSF 0x07,1
; 220: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 221: 					clk = 0
	BCF 0x07,1
; 222: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 223: 				Endif
L0057:
; 224: 			Case 2
	BCF PCLATH,3
	GOTO L0058
L0056:
	MOVF 0x41,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0059
; 225: 				If new_steps > 0 Then
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0060
; 226: 					ena = 1  'motor on
	BSF 0x07,2
; 227: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x37,W
	MOVWF 0x37
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x38,W
	MOVWF 0x38
; 228: 					direction = 0
	BCF 0x07,0
; 229: 					clk = 1  'clock out
	BSF 0x07,1
; 230: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 231: 					clk = 0
	BCF 0x07,1
; 232: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 233: 				Endif
L0060:
; 234: 			Case Else
	BCF PCLATH,3
	GOTO L0061
L0059:
; 235: 			EndSelect
L0061:
L0058:
; 236: 		Case 2  'setting of maximum positions
	BCF PCLATH,3
	GOTO L0062
L0055:
	MOVF 0x44,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0063
; 237: 			ena = 0  'shut off motor
	BCF 0x07,2
; 238: 			If max_pos > 60 Then
	MOVF 0x35,W
	SUBLW 0x3C
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0064
; 239: 				max_pos = 60
	MOVLW 0x3C
	MOVWF 0x35
; 240: 			Endif
L0064:
; 241: 			value = max_pos
	MOVF 0x35,W
	MOVWF 0x36
; 242: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 243: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 244: 			Select Case result
; 245: 			Case 1
	MOVF 0x41,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0065
; 246: 				If max_pos < 60 Then  'display is limited to 60
	MOVLW 0x3C
	SUBWF 0x35,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0066
; 247: 					max_pos = max_pos + 1
	MOVF 0x35,W
	ADDLW 0x01
	MOVWF 0x35
; 248: 					Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0067:	BTFSC EECON1,WR
	GOTO L0067
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 249: 				Endif
L0066:
; 250: 			Case 2
	BCF PCLATH,3
	GOTO L0068
L0065:
	MOVF 0x41,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0069
; 251: 				If max_pos > 4 Then
	MOVF 0x35,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0070
; 252: 					max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x35,W
	MOVWF 0x35
; 253: 					Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0071:	BTFSC EECON1,WR
	GOTO L0071
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 254: 				Endif
L0070:
; 255: 			Case Else
	BCF PCLATH,3
	GOTO L0072
L0069:
; 256: 			EndSelect
L0072:
L0068:
; 257: 		
; 258: 		Case 3  'setting of speed interval
	BCF PCLATH,3
	GOTO L0073
L0063:
	MOVF 0x44,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0074
; 259: 					'setting will be done in multiple of 256 uSecs
; 260: 					'minimum is 2 and maximum is 60 (is real slow)
; 261: 			ena = 0  'shut off motor
	BCF 0x07,2
; 262: 			If speed.HB > 60 Then
	MOVF 0x33,W
	SUBLW 0x3C
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0075
; 263: 				speed.HB = 60
	MOVLW 0x3C
	MOVWF 0x33
; 264: 				Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0076:	BTFSC EECON1,WR
	GOTO L0076
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 265: 			Endif
L0075:
; 266: 			value = speed.HB
	MOVF 0x33,W
	MOVWF 0x36
; 267: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 268: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 269: 			Select Case result
; 270: 			Case 1
	MOVF 0x41,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0077
; 271: 				If speed.HB < 100 Then  'display is limited to 100
	MOVLW 0x64
	SUBWF 0x33,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0078
; 272: 					speed.HB = speed.HB + 1
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x33
; 273: 					Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0079:	BTFSC EECON1,WR
	GOTO L0079
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 274: 				Endif
L0078:
; 275: 			Case 2
	BCF PCLATH,3
	GOTO L0080
L0077:
	MOVF 0x41,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0081
; 276: 				If speed.HB > 2 Then
	MOVF 0x33,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0082
; 277: 					speed.HB = speed.HB - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
; 278: 					Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0083:	BTFSC EECON1,WR
	GOTO L0083
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 279: 				Endif
L0082:
; 280: 			Case Else
	BCF PCLATH,3
	GOTO L0084
L0081:
; 281: 			EndSelect
L0084:
L0080:
; 282: 	
; 283: 		Case 4  'setting of extra free space steps
	BCF PCLATH,3
	GOTO L0085
L0074:
	MOVF 0x44,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0086
; 284: 			ena = 0  'shut off motor
	BCF 0x07,2
; 285: 			If free_space_steps > 250 Then
	MOVF 0x3C,W
	SUBLW 0xFA
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0087
; 286: 				free_space_steps = 250
	MOVLW 0xFA
	MOVWF 0x3C
; 287: 				Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0088:	BTFSC EECON1,WR
	GOTO L0088
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 288: 			Endif
L0087:
; 289: 			value = free_space_steps
	MOVF 0x3C,W
	MOVWF 0x36
; 290: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 291: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 292: 			Select Case result
; 293: 			Case 1
	MOVF 0x41,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0089
; 294: 				If free_space_steps < 60 Then  'display is limited to 60
	MOVLW 0x3C
	SUBWF 0x3C,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0090
; 295: 					free_space_steps = free_space_steps + 1
	MOVF 0x3C,W
	ADDLW 0x01
	MOVWF 0x3C
; 296: 					Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0091:	BTFSC EECON1,WR
	GOTO L0091
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 297: 				Endif
L0090:
; 298: 			Case 2
	BCF PCLATH,3
	GOTO L0092
L0089:
	MOVF 0x41,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0093
; 299: 				If free_space_steps > 0 Then
	MOVF 0x3C,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0094
; 300: 					free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x3C,W
	MOVWF 0x3C
; 301: 					Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0095:	BTFSC EECON1,WR
	GOTO L0095
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 302: 				Endif
L0094:
; 303: 			Case Else
	BCF PCLATH,3
	GOTO L0096
L0093:
; 304: 			EndSelect
L0096:
L0092:
; 305: 		Case Else  'setting of control type
	BCF PCLATH,3
	GOTO L0097
L0086:
; 306: 			ena = 0  'shut off motor
	BCF 0x07,2
; 307: 			If ctrl_type > 5 Then
	MOVF 0x34,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0098
; 308: 				ctrl_type = 0
	CLRF 0x34
; 309: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0099:	BTFSC EECON1,WR
	GOTO L0099
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 310: 			Endif
L0098:
; 311: 			value = ctrl_type
	MOVF 0x34,W
	MOVWF 0x36
; 312: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 313: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 314: 			Select Case result
; 315: 			Case 1
	MOVF 0x41,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0100
; 316: 				If ctrl_type < 5 Then  'display is limited to 60
	MOVLW 0x05
	SUBWF 0x34,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0101
; 317: 					ctrl_type = ctrl_type + 1
	MOVF 0x34,W
	ADDLW 0x01
	MOVWF 0x34
; 318: 					Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0102:	BTFSC EECON1,WR
	GOTO L0102
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 319: 				Endif
L0101:
; 320: 			Case 2
	BCF PCLATH,3
	GOTO L0103
L0100:
	MOVF 0x41,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0104
; 321: 				If ctrl_type > 0 Then
	MOVF 0x34,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0105
; 322: 					ctrl_type = ctrl_type - 1
	MOVLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 323: 					Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0106:	BTFSC EECON1,WR
	GOTO L0106
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 324: 				Endif
L0105:
; 325: 			Case Else
	BCF PCLATH,3
	GOTO L0107
L0104:
; 326: 			EndSelect
L0107:
L0103:
; 327: 						
; 328: 		EndSelect
L0097:
L0085:
L0073:
L0062:
; 329: 		
; 330: 	Wend
	BCF PCLATH,3
	GOTO L0049
L0050:
; 331: 	ena = 0  'shut off motor
	BCF 0x07,2
; 332: 		'***************   now check if changes have to written in eeprom
; 333: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	MOVF 0x3E,W
	MOVWF R1L
	MOVF 0x3F,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C002
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0108
; 334: 		eprom_pointer1 = act_pos
	MOVF 0x39,W
	MOVWF 0x3D
; 335: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x3D,W
	ADDLW 0x3C
	MOVWF 0x43
; 336: 		Write eprom_pointer1, new_steps.LB
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0109:	BTFSC EECON1,WR
	GOTO L0109
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 337: 		Write eprom_pointer2, new_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0110:	BTFSC EECON1,WR
	GOTO L0110
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 338: 		Gosub check_next_steps
	BSF PCLATH,3
	CALL L0010
; 339: 	Endif
L0108:
; 340: 	value = act_pos
	MOVF 0x39,W
	MOVWF 0x36
; 341: 	Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 342: 	onoff = 1
	BSF 0x49,0
; 343: 	Gosub relays
	BSF PCLATH,3
	CALL L0009
; 344: Return
	RETURN
; 345: 
; 346: i2c_display:
L0005:
; 347: 	disp1_val = value
	MOVF 0x36,W
	MOVWF 0x45
; 348: 	Select Case value
; 349: 	Case 99  'intro version display
	MOVF 0x36,W
	SUBLW 0x63
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0111
; 350: 		disp1_val = %10000010
	MOVLW 0x82
	MOVWF 0x45
; 351: 		disp2_val = %00110000
	MOVLW 0x30
	MOVWF 0x4A
; 352: 	Case Else
	BCF PCLATH,3
	GOTO L0112
L0111:
; 353: 		disp1_val = disp1_val Mod 10
	MOVF 0x45,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x45
; 354: 		disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x45,W
	SUBLW 0x09
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0113
	BCF PCLATH,3
	CALL L0114
	MOVWF 0x45
	BCF PCLATH,3
	GOTO L0113
L0114:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x45,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
L0113:
; 355: 		disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x45,7
	BTFSS 0x07,7
	BCF 0x45,7
; 356: 		disp2_val = value
	MOVF 0x36,W
	MOVWF 0x4A
; 357: 		disp2_val = disp2_val / 10
	MOVF 0x4A,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4A
; 358: 		disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x4A,W
	SUBLW 0x0A
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0115
	BCF PCLATH,3
	CALL L0116
	MOVWF 0x4A
	BCF PCLATH,3
	GOTO L0115
L0116:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x4A,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
L0115:
; 359: 	EndSelect
L0112:
; 360: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 361: 	I2CSend disp1
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 362: 	I2CSend disp1_val
	BCF PCLATH,3
	MOVF 0x45,W
	CALL IC01
; 363: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 364: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 365: 	I2CSend disp2
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 366: 	I2CSend disp2_val
	BCF PCLATH,3
	MOVF 0x4A,W
	CALL IC01
; 367: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 368: Return
	RETURN
; 369: 
; 370: i2c_display_pgm:
L0006:
; 371: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010), program_set
	MOVF 0x44,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0117
	BCF PCLATH,3
	CALL L0118
	MOVWF 0x45
	BCF PCLATH,3
	GOTO L0117
L0118:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x44,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
L0117:
; 372: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 373: 	I2CSend disp1
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 374: 	I2CSend disp1_val
	BCF PCLATH,3
	MOVF 0x45,W
	CALL IC01
; 375: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 376: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 377: 	I2CSend disp2
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 378: 	I2CSend %10111111
	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 379: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 380: Return
	RETURN
; 381: 
; 382: steps_reading:
L0007:
; 383: 	If act_pos = 0 Then
	MOVF 0x39,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0119
; 384: 		act_steps = 0
	CLRF 0x3E
	CLRF 0x3F
; 385: 	Else
	BCF PCLATH,3
	GOTO L0120
L0119:
; 386: 		eprom_pointer1 = act_pos
	MOVF 0x39,W
	MOVWF 0x3D
; 387: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x3D,W
	ADDLW 0x3C
	MOVWF 0x43
; 388: 		Read eprom_pointer1, act_steps.LB
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3E
; 389: 		Read eprom_pointer2, act_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 390: 	Endif
L0120:
; 391: 	If new_pos = 0 Then
	MOVF 0x4B,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0121
; 392: 		new_steps = 0
	CLRF 0x37
	CLRF 0x38
; 393: 	Else
	BCF PCLATH,3
	GOTO L0122
L0121:
; 394: 		eprom_pointer1 = new_pos
	MOVF 0x4B,W
	MOVWF 0x3D
; 395: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x3D,W
	ADDLW 0x3C
	MOVWF 0x43
; 396: 		Read eprom_pointer1, new_steps.LB
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 397: 		Read eprom_pointer2, new_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x38
; 398: 	Endif
L0122:
; 399: Return
	RETURN
; 400: 
; 401: stepmotor:
L0008:
; 402: 	speed = 0
	CLRF 0x32
	CLRF 0x33
; 403: 	Read mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 404: 	Read mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3C
; 405: 	Gosub steps_reading
	BCF PCLATH,3
	CALL L0007
; 406: 	If new_steps = 0 Then
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C001
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0123
; 407: 		direction = 0
	BCF 0x07,0
; 408: 		ena = 1  'set anable on
	BSF 0x07,2
; 409: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 410: 		While zero = 1  'turn motor until zero switch is activated
L0124:
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0125
; 411: 			clk = 1  'clock out
	BSF 0x07,1
; 412: 			WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 413: 			clk = 0
	BCF 0x07,1
; 414: 			WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 415: 		Wend
	BCF PCLATH,3
	GOTO L0124
L0125:
; 416: 		act_pos = 0
	CLRF 0x39
; 417: 		Write mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0126:	BTFSC EECON1,WR
	GOTO L0126
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 418: 		If ctrl_type > 1 Then  'NOW GO ONE MORE COMPLETE ROUND FOR COUNTING STEPS
	MOVF 0x34,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0127
; 419: 			one_round = 0
	CLRF 0x30
	CLRF 0x31
; 420: 			ena = 1  'set anable on
	BSF 0x07,2
; 421: 			While zero = 0  'turn motor until zero switch is activated
L0128:
	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0129
; 422: 				clk = 1  'clock out
	BSF 0x07,1
; 423: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 424: 				clk = 0
	BCF 0x07,1
; 425: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 426: 				one_round = one_round + 1
	MOVF 0x30,W
	ADDLW 0x01
	MOVWF 0x30
	MOVF 0x31,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x31
; 427: 			Wend
	BCF PCLATH,3
	GOTO L0128
L0129:
; 428: 			While zero = 1  'turn motor until zero switch is activated
L0130:
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0131
; 429: 				clk = 1  'clock out
	BSF 0x07,1
; 430: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 431: 				clk = 0
	BCF 0x07,1
; 432: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 433: 				one_round = one_round + 1
	MOVF 0x30,W
	ADDLW 0x01
	MOVWF 0x30
	MOVF 0x31,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x31
; 434: 			Wend
	BCF PCLATH,3
	GOTO L0130
L0131:
; 435: 			one_round_half = one_round / 2
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4E
	MOVF R0H,W
	MOVWF 0x4F
; 436: 			Write mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0132:	BTFSC EECON1,WR
	GOTO L0132
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 437: 			Write mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0133:	BTFSC EECON1,WR
	GOTO L0133
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 438: 		Endif
L0127:
; 439: 		ena = 0  'set anable off
	BCF 0x07,2
; 440: 		act_pos = 0
	CLRF 0x39
; 441: 	Else
	BCF PCLATH,3
	GOTO L0134
L0123:
; 442: 		steps = 0
	CLRF 0x3A
	CLRF 0x3B
; 443: 		If new_steps > act_steps Then
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	MOVF 0x3E,W
	MOVWF R1L
	MOVF 0x3F,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0135
; 444: 			steps = new_steps - act_steps
	MOVF 0x3E,W
	SUBWF 0x37,W
	MOVWF 0x3A
	MOVF 0x3F,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x38,W
	MOVWF 0x3B
; 445: 			direction = 1
	BSF 0x07,0
; 446: 			If steps > one_round_half Then  'is other direction shorter?
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVF 0x4E,W
	MOVWF R1L
	MOVF 0x4F,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0136
; 447: 				Select Case ctrl_type
; 448: 				Case 2, 3
	MOVF 0x34,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0139
	BCF PCLATH,3
	GOTO L0138
L0139:
	MOVF 0x34,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0137
L0138:
; 449: 					If ctrl_type > 1 Then  'check If short way is set
	MOVF 0x34,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0140
; 450: 						Read mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 451: 						If turn_counter > 126 Then  'check if shortest way is allowed
	MOVF 0x40,W
	SUBLW 0x7E
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0141
; 452: 							turn_counter = turn_counter - 1  'yes it is, so substract one pass
	MOVLW 0x01
	SUBWF 0x40,W
	MOVWF 0x40
; 453: 							steps = one_round - steps  'go shortest way
	MOVF 0x3A,W
	SUBWF 0x30,W
	MOVWF 0x3A
	MOVF 0x3B,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x3B
; 454: 							direction = 0  'change  direction
	BCF 0x07,0
; 455: 							Write mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0142:	BTFSC EECON1,WR
	GOTO L0142
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 456: 						Endif
L0141:
; 457: 					Endif
L0140:
; 458: 				Case 4, 5  'type with contact sliders, no twisting cables
	BCF PCLATH,3
	GOTO L0143
L0137:
	MOVF 0x34,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0146
	BCF PCLATH,3
	GOTO L0145
L0146:
	MOVF 0x34,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0144
L0145:
; 459: 					steps = one_round - steps
	MOVF 0x3A,W
	SUBWF 0x30,W
	MOVWF 0x3A
	MOVF 0x3B,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x3B
; 460: 					direction = 0
	BCF 0x07,0
; 461: 				Case Else  'no short way possible
	BCF PCLATH,3
	GOTO L0147
L0144:
; 462: 				EndSelect
L0147:
L0143:
; 463: 			Endif
L0136:
; 464: 		Else
	BCF PCLATH,3
	GOTO L0148
L0135:
; 465: 			steps = act_steps - new_steps
	MOVF 0x37,W
	SUBWF 0x3E,W
	MOVWF 0x3A
	MOVF 0x38,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x3B
; 466: 			direction = 0
	BCF 0x07,0
; 467: 			If steps > one_round_half Then  'other direction shorter?
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVF 0x4E,W
	MOVWF R1L
	MOVF 0x4F,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0149
; 468: 				Select Case ctrl_type
; 469: 				Case 2, 3  'cable connected bridges
	MOVF 0x34,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0152
	BCF PCLATH,3
	GOTO L0151
L0152:
	MOVF 0x34,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0150
L0151:
; 470: 					Read mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 471: 					If turn_counter < 130 Then  'check if shortest way is allowed
	MOVLW 0x82
	SUBWF 0x40,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0153
; 472: 						turn_counter = turn_counter + 1  'yes it is, so add one pass
	MOVF 0x40,W
	ADDLW 0x01
	MOVWF 0x40
; 473: 						steps = one_round - steps  'go shortest way
	MOVF 0x3A,W
	SUBWF 0x30,W
	MOVWF 0x3A
	MOVF 0x3B,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x3B
; 474: 						direction = 1  'change direction
	BSF 0x07,0
; 475: 						Write mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0154:	BTFSC EECON1,WR
	GOTO L0154
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 476: 					Endif
L0153:
; 477: 				Case 4, 5  'type with contact sliders, no twisting cables
	BCF PCLATH,3
	GOTO L0155
L0150:
	MOVF 0x34,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0158
	BCF PCLATH,3
	GOTO L0157
L0158:
	MOVF 0x34,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0156
L0157:
; 478: 					steps = one_round - steps
	MOVF 0x3A,W
	SUBWF 0x30,W
	MOVWF 0x3A
	MOVF 0x3B,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x31,W
	MOVWF 0x3B
; 479: 					direction = 1
	BSF 0x07,0
; 480: 				Case Else  'no short way possible
	BCF PCLATH,3
	GOTO L0159
L0156:
; 481: 				EndSelect
L0159:
L0155:
; 482: 			Endif
L0149:
; 483: 		Endif
L0148:
; 484: 		If steps > 0 Then  'motor must be activated
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0160
; 485: 			If direction = 1 Then
	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0161
; 486: 				steps = steps + free_space_steps
	MOVF 0x3A,W
	ADDWF 0x3C,W
	MOVWF 0x3A
	MOVF 0x3B,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x3B
; 487: 			Endif
L0161:
; 488: 			ena = 1  'set anable on
	BSF 0x07,2
; 489: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 490: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0162:
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0163
; 491: 				clk = 1  'clock out
	BSF 0x07,1
; 492: 				WaitUs speed
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 493: 				clk = 0
	BCF 0x07,1
; 494: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x3A,W
	MOVWF 0x3A
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x3B
; 495: 			Wend
	BCF PCLATH,3
	GOTO L0162
L0163:
; 496: 			WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 497: 			If direction = 1 Then
	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0164
; 498: 				steps = free_space_steps
	MOVF 0x3C,W
	MOVWF 0x3A
	CLRF 0x3B
; 499: 				direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 500: 				While steps > 0  'NOW RUN UNTIL STEPS = 0
L0165:
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0166
; 501: 					clk = 1  'clock out
	BSF 0x07,1
; 502: 					WaitUs speed
	MOVF 0x32,W
	MOVWF R4L
	MOVF 0x33,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 503: 					clk = 0
	BCF 0x07,1
; 504: 					steps = steps - 1
	MOVLW 0x01
	SUBWF 0x3A,W
	MOVWF 0x3A
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x3B
; 505: 				Wend
	BCF PCLATH,3
	GOTO L0165
L0166:
; 506: 			Endif
L0164:
; 507: 			ena = 0  'enable off
	BCF 0x07,2
; 508: 			pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 509: 		Else
	BCF PCLATH,3
	GOTO L0167
L0160:
; 510: 			WaitMs 1000  'give some extra time for feed-back if no change of postion is made.
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 511: 			pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 512: 		Endif
L0167:
; 513: 	Endif
L0134:
; 514: 	act_pos = new_pos
	MOVF 0x4B,W
	MOVWF 0x39
; 515: 	Write mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0168:	BTFSC EECON1,WR
	GOTO L0168
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 516: 	bus_pos = act_pos
	MOVF 0x39,W
	MOVWF 0x48
; 517: 	old_bus_pos = act_pos
	MOVF 0x39,W
	MOVWF 0x50
; 518: 	manual_pos = act_pos
	MOVF 0x39,W
	MOVWF 0x42
; 519: 	old_manual_pos = act_pos
	MOVF 0x39,W
	MOVWF 0x4D
; 520: Return
	RETURN
; 521: 
; 522: 
; 523: relays:
L0009:
; 524: 	If onoff = 1 Then
	BSF PCLATH,3
	BTFSS 0x49,0
	GOTO L0169
; 525: 		value = max_pos + 1
	MOVF 0x35,W
	ADDLW 0x01
	MOVWF 0x36
; 526: 		value = value / 2  'calulation of half max positions
	MOVF 0x36,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x36
; 527: 		Select Case ctrl_type
; 528: 		Case 1, 3, 5
	MOVF 0x34,W
	SUBLW 0x01
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0172
	BSF PCLATH,3
	GOTO L0171
L0172:
	MOVF 0x34,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0173
	BSF PCLATH,3
	GOTO L0171
L0173:
	MOVF 0x34,W
	SUBLW 0x05
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0170
L0171:
; 529: 			swfw = 1
	BSF 0x06,0
; 530: 			swrev = 0
	BCF 0x06,1
; 531: 		Case Else
	BSF PCLATH,3
	GOTO L0174
L0170:
; 532: 			If act_pos > value Then  'select polarity rails on bridge
	MOVF 0x39,W
	SUBWF 0x36,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0175
; 533: 				swfw = 0
	BCF 0x06,0
; 534: 				swrev = 1
	BSF 0x06,1
; 535: 			Else
	BSF PCLATH,3
	GOTO L0176
L0175:
; 536: 				swrev = 0
	BCF 0x06,1
; 537: 				swfw = 1
	BSF 0x06,0
; 538: 			Endif
L0176:
; 539: 		EndSelect
L0174:
; 540: 	Else
	BSF PCLATH,3
	GOTO L0177
L0169:
; 541: 		swfw = 0
	BCF 0x06,0
; 542: 		swrev = 0
	BCF 0x06,1
; 543: 	Endif
L0177:
; 544: Return
	RETURN
; 545: 
; 546: 
; 547: check_next_steps:
L0010:
; 548: 	'this is ment to check all following steps after readjusting one position.
; 549: 	'simply to avoid that tt will go backwards when set for the next (higher) position.
; 550: 	value = act_pos
	MOVF 0x39,W
	MOVWF 0x36
; 551: 	While value < max_pos
L0178:
	MOVF 0x35,W
	SUBWF 0x36,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0179
; 552: 		eprom_pointer1 = value
	MOVF 0x36,W
	MOVWF 0x3D
; 553: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x3D,W
	ADDLW 0x3C
	MOVWF 0x43
; 554: 		Read eprom_pointer1, act_steps.LB
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3E
; 555: 		Read eprom_pointer2, act_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 556: 		eprom_pointer1 = eprom_pointer1 + 1
	MOVF 0x3D,W
	ADDLW 0x01
	MOVWF 0x3D
; 557: 		eprom_pointer2 = eprom_pointer2 + 1
	MOVF 0x43,W
	ADDLW 0x01
	MOVWF 0x43
; 558: 		Read eprom_pointer1, new_steps.LB
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 559: 		Read eprom_pointer2, new_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x38
; 560: 		While new_steps < act_steps
L0180:
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	MOVF 0x3E,W
	MOVWF R1L
	MOVF 0x3F,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0181
; 561: 			new_steps = new_steps + 50
	MOVF 0x37,W
	ADDLW 0x32
	MOVWF 0x37
	MOVF 0x38,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x38
; 562: 		Wend
	BSF PCLATH,3
	GOTO L0180
L0181:
; 563: 		Write eprom_pointer1, new_steps.LB
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0182:	BTFSC EECON1,WR
	GOTO L0182
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 564: 		Write eprom_pointer2, new_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0183:	BTFSC EECON1,WR
	GOTO L0183
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 565: 		value = value + 1
	MOVF 0x36,W
	ADDLW 0x01
	MOVWF 0x36
; 566: 	Wend
	BSF PCLATH,3
	GOTO L0178
L0179:
; 567: Return
	RETURN
; 568: 
; 569: 
; 570: init_eeprom:
L0011:
; 571: 			'check if acceptable value is in eeprom
; 572: 	Read mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x35
; 573: 	If max_pos < 2 Then
	MOVLW 0x02
	SUBWF 0x35,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0184
; 574: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x35
; 575: 		Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0185:	BTFSC EECON1,WR
	GOTO L0185
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 576: 	Endif
L0184:
; 577: 	If max_pos > 60 Then
	MOVF 0x35,W
	SUBLW 0x3C
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0186
; 578: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x35
; 579: 		Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0187:	BTFSC EECON1,WR
	GOTO L0187
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 580: 	Endif
L0186:
; 581: 	act_pos = 1
	MOVLW 0x01
	MOVWF 0x39
; 582: 	Write mem_act_pos, 1  'act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x01
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0188:	BTFSC EECON1,WR
	GOTO L0188
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 583: 	act_steps = 0
	CLRF 0x3E
	CLRF 0x3F
; 584: 	one_round = 8000
	MOVLW 0x40
	MOVWF 0x30
	MOVLW 0x1F
	MOVWF 0x31
; 585: 		'check memory for correct total steps
; 586: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 587: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 588: 	If one_round > 40000 Then
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x40
	MOVWF R1L
	MOVLW 0x9C
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0189
; 589: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x30
	MOVLW 0x1F
	MOVWF 0x31
; 590: 		Write mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0190:	BTFSC EECON1,WR
	GOTO L0190
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 591: 		Write mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0191:	BTFSC EECON1,WR
	GOTO L0191
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 592: 	Endif
L0189:
; 593: 
; 594: 	For eprom_pointer1 = 1 To max_pos
	MOVLW 0x01
	MOVWF 0x3D
L0192:
	MOVF 0x3D,W
	SUBWF 0x35,W
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0193
; 595: 		new_steps = one_round / max_pos  'devide the steps between min and max
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVF 0x35,W
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x37
	MOVF R0H,W
	MOVWF 0x38
; 596: 		act_steps = act_steps + new_steps
	MOVF 0x3E,W
	ADDWF 0x37,W
	MOVWF 0x3E
	MOVF 0x3F,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x38,W
	MOVWF 0x3F
; 597: 		eprom_pointer2 = eprom_pointer1 + 60
	MOVF 0x3D,W
	ADDLW 0x3C
	MOVWF 0x43
; 598: 		Write eprom_pointer1, act_steps.LB
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0194:	BTFSC EECON1,WR
	GOTO L0194
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 599: 		Write eprom_pointer2, act_steps.HB
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0195:	BTFSC EECON1,WR
	GOTO L0195
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 600: 	Next eprom_pointer1
	MOVLW 0x01
	ADDWF 0x3D,F
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0192
L0193:
; 601: 
; 602: 	speed = 20 * 256
	MOVLW 0x14
	MOVWF R3L
	CLRF R3H
	CLRF R1L
	MOVLW 0x01
	MOVWF R1H
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x32
	MOVF R2H,W
	MOVWF 0x33
; 603: 	Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0196:	BTFSC EECON1,WR
	GOTO L0196
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 604: 
; 605: 	free_space_steps = 20
	MOVLW 0x14
	MOVWF 0x3C
; 606: 	Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0197:	BTFSC EECON1,WR
	GOTO L0197
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 607: 			'check for correct control type
; 608: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 609: 	If ctrl_type > 3 Then
	MOVF 0x34,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0198
; 610: 		ctrl_type = 0
	CLRF 0x34
; 611: 		Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0199:	BTFSC EECON1,WR
	GOTO L0199
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 612: 	Endif
L0198:
; 613: 			'now check for correct amount of 0-point passes
; 614: 	Read mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 615: 	If turn_counter > 131 Then  'in program impossible value
	MOVF 0x40,W
	SUBLW 0x83
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0200
; 616: 		turn_counter = 128
	MOVLW 0x80
	MOVWF 0x40
; 617: 		Write mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0201:	BTFSC EECON1,WR
	GOTO L0201
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 618: 	Else
	BSF PCLATH,3
	GOTO L0202
L0200:
; 619: 		If turn_counter < 125 Then  'in program impossible value
	MOVLW 0x7D
	SUBWF 0x40,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0203
; 620: 			turn_counter = 128
	MOVLW 0x80
	MOVWF 0x40
; 621: 			Write mem_turn_counter, turn_counter
	MOVLW 0x00
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0204:	BTFSC EECON1,WR
	GOTO L0204
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 622: 		Endif
L0203:
; 623: 	Endif
L0202:
; 624: 
; 625: Return
	RETURN
; 626: 
; 627: init_values:
L0012:
; 628: 
; 629: 	encoder_count = 0
	CLRF 0x47
; 630: 	speed = 0
	CLRF 0x32
	CLRF 0x33
; 631: 	If eep = 1 Then  'jumper set for initialisation
	BSF PCLATH,3
	BTFSS 0x06,6
	GOTO L0205
; 632: 		Gosub init_eeprom
	BSF PCLATH,3
	CALL L0011
; 633: 	Endif
L0205:
; 634: 	speed = 0
	CLRF 0x32
	CLRF 0x33
; 635: 	Read mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 636: 	If speed.HB > 100 Then
	MOVF 0x33,W
	SUBLW 0x64
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0206
; 637: 		speed.HB = 100
	MOVLW 0x64
	MOVWF 0x33
; 638: 		Write mem_speed, speed.HB
	MOVLW 0x7A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0207:	BTFSC EECON1,WR
	GOTO L0207
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 639: 	Endif
L0206:
; 640: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 641: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 642: 	If one_round = 0 Then
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C001
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0208
; 643: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x30
	MOVLW 0x1F
	MOVWF 0x31
; 644: 		Write mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0209:	BTFSC EECON1,WR
	GOTO L0209
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 645: 		Write mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0210:	BTFSC EECON1,WR
	GOTO L0210
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 646: 	Endif
L0208:
; 647: 	If one_round > 40000 Then
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x40
	MOVWF R1L
	MOVLW 0x9C
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0211
; 648: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x30
	MOVLW 0x1F
	MOVWF 0x31
; 649: 		Write mem_one_round_lb, one_round.LB
	MOVLW 0x7B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0212:	BTFSC EECON1,WR
	GOTO L0212
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 650: 		Write mem_one_round_hb, one_round.HB
	MOVLW 0x7C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0213:	BTFSC EECON1,WR
	GOTO L0213
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 651: 	Endif
L0211:
; 652: 	one_round_half = one_round / 2
	MOVF 0x30,W
	MOVWF R0L
	MOVF 0x31,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4E
	MOVF R0H,W
	MOVWF 0x4F
; 653: 	Read mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x35
; 654: 	If max_pos > 60 Then
	MOVF 0x35,W
	SUBLW 0x3C
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0214
; 655: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x35
; 656: 		Write mem_max_pos, max_pos
	MOVLW 0x7E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0215:	BTFSC EECON1,WR
	GOTO L0215
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 657: 	Endif
L0214:
; 658: 	Read mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 659: 	If act_pos > max_pos Then
	MOVF 0x39,W
	SUBWF 0x35,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0216
; 660: 		act_pos = 1
	MOVLW 0x01
	MOVWF 0x39
; 661: 		Write mem_act_pos, act_pos
	MOVLW 0x79
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0217:	BTFSC EECON1,WR
	GOTO L0217
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 662: 	Endif
L0216:
; 663: 	Read mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3C
; 664: 	If free_space_steps > 250 Then
	MOVF 0x3C,W
	SUBLW 0xFA
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0218
; 665: 		free_space_steps = 20
	MOVLW 0x14
	MOVWF 0x3C
; 666: 		Write mem_free_space, free_space_steps
	MOVLW 0x7F
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0219:	BTFSC EECON1,WR
	GOTO L0219
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 667: 	Endif
L0218:
; 668: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 669: 	If ctrl_type > 3 Then
	MOVF 0x34,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0220
; 670: 		ctrl_type = 0
	CLRF 0x34
; 671: 		Write mem_ctrl_type, ctrl_type
	MOVLW 0x7D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0221:	BTFSC EECON1,WR
	GOTO L0221
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 672: 	Endif
L0220:
; 673: 	new_pos = act_pos
	MOVF 0x39,W
	MOVWF 0x4B
; 674: 	bus_pos = act_pos
	MOVF 0x39,W
	MOVWF 0x48
; 675: 	old_bus_pos = act_pos
	MOVF 0x39,W
	MOVWF 0x50
; 676: 	manual_pos = act_pos
	MOVF 0x39,W
	MOVWF 0x42
; 677: 	old_manual_pos = act_pos
	MOVF 0x39,W
	MOVWF 0x4D
; 678: 	value = 99
	MOVLW 0x63
	MOVWF 0x36
; 679: 	Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 680: 	WaitMs 3000  'extra delay to settle down all inputs
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 681: Return
	RETURN
; End of program
	BSF PCLATH,3
L0222:	GOTO L0222
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
