; Compiled with: PIC Simulator IDE v6.90
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_turn_counter' (global) is 101
;       The value of 'mem_act_pos' (global) is 102
;       The value of 'mem_speed_min' (global) is 103
;       The value of 'mem_speed_max' (global) is 104
;       The value of 'mem_speed_step' (global) is 105
;       The value of 'mem_one_round_lb' (global) is 106
;       The value of 'mem_one_round_hb' (global) is 107
;       The value of 'mem_ctrl_type' (global) is 108
;       The value of 'mem_max_pos' (global) is 109
;       The value of 'mem_free_space' (global) is 110
;       The address of 'value' (byte) (global) is 0x30
	value EQU 0x30
;       The address of 'act_pos' (byte) (global) is 0x31
	act_pos EQU 0x31
;       The address of 'steps' (word) (global) is 0x32
	steps EQU 0x32
;       The address of 'one_round' (word) (global) is 0x34
	one_round EQU 0x34
;       The address of 'ctrl_type' (byte) (global) is 0x36
	ctrl_type EQU 0x36
;       The address of 'new_steps' (word) (global) is 0x37
	new_steps EQU 0x37
;       The address of 'speed_max' (word) (global) is 0x39
	speed_max EQU 0x39
;       The address of 'speed_min' (word) (global) is 0x3B
	speed_min EQU 0x3B
;       The address of 'max_pos' (byte) (global) is 0x3D
	max_pos EQU 0x3D
;       The address of 'result' (byte) (global) is 0x3E
	result EQU 0x3E
;       The address of 'free_space_steps' (byte) (global) is 0x3F
	free_space_steps EQU 0x3F
;       The address of 'act_steps' (word) (global) is 0x40
	act_steps EQU 0x40
;       The address of 'eprom_pointer2' (byte) (global) is 0x42
	eprom_pointer2 EQU 0x42
;       The address of 'turn_counter' (byte) (global) is 0x43
	turn_counter EQU 0x43
;       The address of 'manual_pos' (byte) (global) is 0x44
	manual_pos EQU 0x44
;       The address of 'eprom_pointer1' (byte) (global) is 0x45
	eprom_pointer1 EQU 0x45
;       The address of 'speed_step' (byte) (global) is 0x46
	speed_step EQU 0x46
;       The address of 'program_set' (byte) (global) is 0x47
	program_set EQU 0x47
;       The address of 'disp1_val' (byte) (global) is 0x48
	disp1_val EQU 0x48
;       The address of 'bus_pos' (byte) (global) is 0x49
	bus_pos EQU 0x49
;       The address of 'new_encoder' (byte) (global) is 0x4A
	new_encoder EQU 0x4A
;       The address of 'encoder_count' (byte) (global) is 0x4B
	encoder_count EQU 0x4B
;       The address of 'speed' (word) (global) is 0x4C
	speed EQU 0x4C
;       The address of 'onoff' (bit) (global) is 0x4E,0
;       The address of 'disp2_val' (byte) (global) is 0x4F
	disp2_val EQU 0x4F
;       The address of 'new_pos' (byte) (global) is 0x50
	new_pos EQU 0x50
;       The address of 'old_encoder' (byte) (global) is 0x51
	old_encoder EQU 0x51
;       The address of 'old_manual_pos' (byte) (global) is 0x52
	old_manual_pos EQU 0x52
;       The address of 'ramp_up' (bit) (global) is 0x4E,1
;       The address of 'ramp_down_point' (word) (global) is 0x53
	ramp_down_point EQU 0x53
;       The address of 'one_round_half' (word) (global) is 0x55
	one_round_half EQU 0x55
;       The address of 'old_bus_pos' (byte) (global) is 0x57
	old_bus_pos EQU 0x57
;       The address of 'old_pos_write' (bit) (global) is 0x4E,2
;       The address of 'version' (bit) (global) is 0x4E,3
;       The address of 'half_steps' (word) (global) is 0x58
	half_steps EQU 0x58
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'eep' (bit) (global) is 0x6,6
;       The address of 'max_end' (bit) (global) is 0x6,7
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x7,3
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0014
	ORG 0x0004
	RETFIE
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Byte
X001:	MOVLW 0x02
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
X002:	MOVLW 0x02
	SUBWF R4L,F
	NOP
	NOP
	NOP
	NOP
	BTFSS STATUS,C
	RETURN
	GOTO X002
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0014:
; 1: 'program TT for PCBoard MGV145
; 2: 'version V3-1  Fiddle Yard version, for turntables and fiddle yard
; 3: 'this version has all possibilities changeable by menue's.
; 4: 'V3-2 counter for twisting cables tored at eeprom pos zero.
; 5: 'the value of the counter can be anything between 125 and 131. 128 is zero point.
; 6: 'V3-3 eeprom startup improved. Reprogramming PIC can now be done without reprogramming data
; 7: 'V3.6 startup delayed, to avoid wrong positions
; 8: 'V3.10 extra separate positions for FY and TT with contact sliders.
; 9: Define CONF_WORD = 0x3f72
; 10: Define CLOCK_FREQUENCY = 20
; 11: Dim steps As Word
; 12: Dim half_steps As Word
; 13: Dim ramp_down_point As Word
; 14: Dim program_set As Byte
; 15: Dim new_steps As Word
; 16: Dim act_steps As Word
; 17: Dim new_pos As Byte
; 18: Dim act_pos As Byte
; 19: Dim one_round As Word
; 20: Dim one_round_half As Word
; 21: Dim bus_pos As Byte
; 22: Dim old_bus_pos As Byte
; 23: Dim speed As Word
; 24: Dim speed_min As Word
; 25: Dim speed_max As Word
; 26: Dim new_encoder As Byte
; 27: Dim old_encoder As Byte
; 28: Dim manual_pos As Byte
; 29: Dim old_manual_pos As Byte
; 30: Dim result As Byte
; 31: Dim free_space_steps As Byte
; 32: Dim value As Byte
; 33: Dim eprom_pointer1 As Byte
; 34: Dim eprom_pointer2 As Byte
; 35: Dim encoder_count As Byte
; 36: Dim turn_counter As Byte
; 37: Dim onoff As Bit
; 38: Dim max_pos As Byte
; 39: Dim disp1_val As Byte
; 40: Dim disp2_val As Byte
; 41: Dim ctrl_type As Byte
; 42: Dim old_pos_write As Bit
; 43: Dim ramp_up As Bit
; 44: Dim speed_step As Byte
; 45: Dim version As Bit
; 46: Const disp1 = 64
; 47: Const disp2 = 66
; 48: Const mem_turn_counter = 101
; 49: Const mem_act_pos = 102
; 50: Const mem_speed_min = 103
; 51: Const mem_speed_max = 104
; 52: Const mem_speed_step = 105
; 53: Const mem_one_round_lb = 106
; 54: Const mem_one_round_hb = 107
; 55: Const mem_ctrl_type = 108
; 56: Const mem_max_pos = 109
; 57: Const mem_free_space = 110
; 58: Symbol swfw = RB0
; 59: Symbol swrev = RB1
; 60: Symbol sck = RB2
; 61: Symbol sda = RB3
; 62: Symbol pos_match = RB4
; 63: Symbol pos_write = RB5
; 64: Symbol eep = RB6
; 65: Symbol max_end = RB7
; 66: Symbol direction = RC0
; 67: Symbol clk = RC1
; 68: Symbol ena = RC2
; 69: Symbol zero = RC3
; 70: Symbol ec1 = RC4
; 71: Symbol ec2 = RC5
; 72: Symbol ecsw = RC6
; 73: Symbol pgm = RC7
; 74: 
; 75: ADCON1 = %0110
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 76: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 77: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 78: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 79: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 80: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 81: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 82: Gosub init_values
	BSF PCLATH,3
	CALL L0013
; 83: value = 37  'version number
	MOVLW 0x25
	MOVWF 0x30
; 84: version = 0
	BCF 0x4E,3
; 85: Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 86: WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 87: value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 88: version = 1
	BSF 0x4E,3
; 89: Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 90: onoff = 1
	BSF 0x4E,0
; 91: Gosub relays
	BSF PCLATH,3
	CALL L0010
; 92: program_set = 4
	MOVLW 0x04
	MOVWF 0x47
; 93: main:
L0001:
; 94: 	If pgm = 0 Then
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0015
; 95: 		Gosub adjust_settings
	BCF PCLATH,3
	CALL L0004
; 96: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 97: 	Endif
L0015:
; 98: 
; 99: 	Gosub get_new_position
	BCF PCLATH,3
	CALL L0002
; 100: 	If bus_pos <> old_bus_pos Then
	MOVF 0x49,W
	SUBWF 0x57,W
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0016
; 101: 		onoff = 0
	BCF 0x4E,0
; 102: 		Gosub relays
	BSF PCLATH,3
	CALL L0010
; 103: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 104: 		new_pos = bus_pos
	MOVF 0x49,W
	MOVWF 0x50
; 105: 		Gosub stepmotor
	BCF PCLATH,3
	CALL L0008
; 106: 		value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 107: 		Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 108: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 109: 		onoff = 1
	BSF 0x4E,0
; 110: 	Else
	BCF PCLATH,3
	GOTO L0017
L0016:
; 111: 		If ecsw = 0 Then  'only when knob is pushed
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0018
; 112: 			If manual_pos <> old_manual_pos Then
	MOVF 0x44,W
	SUBWF 0x52,W
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0019
; 113: 				onoff = 0
	BCF 0x4E,0
; 114: 				Gosub relays
	BSF PCLATH,3
	CALL L0010
; 115: 				pos_match = 1  'indicate not in position
	BSF 0x06,4
; 116: 				old_manual_pos = manual_pos
	MOVF 0x44,W
	MOVWF 0x52
; 117: 				new_pos = manual_pos
	MOVF 0x44,W
	MOVWF 0x50
; 118: 				Gosub stepmotor
	BCF PCLATH,3
	CALL L0008
; 119: 				value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 120: 				Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 121: 				pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 122: 				onoff = 1
	BSF 0x4E,0
; 123: 			Endif
L0019:
; 124: 		Endif
L0018:
; 125: 	Endif
L0017:
; 126: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 127: 	Gosub relays
	BSF PCLATH,3
	CALL L0010
; 128: 	Goto main
	BCF PCLATH,3
	GOTO L0001
; 129: End
	BCF PCLATH,3
L0020:	GOTO L0020
; 130: 
; 131: 
; 132: get_new_position:
L0002:
; 133: 	value = bus_pos  'remember the position
	MOVF 0x49,W
	MOVWF 0x30
; 134: 	If pos_write = 1 Then
	BCF PCLATH,3
	BTFSS 0x06,5
	GOTO L0021
; 135: 		If old_pos_write = 0 Then  'react only once on rising edge
	BCF PCLATH,3
	BTFSC 0x4E,2
	GOTO L0022
; 136: 			old_pos_write = 1
	BSF 0x4E,2
; 137: 			value = PORTA And 63  'now get value from J5
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x30
; 138: 			If value > max_pos Then  'this is not allowed
	MOVF 0x30,W
	SUBWF 0x3D,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0023
; 139: 				value = bus_pos  'put it back to old situation
	MOVF 0x49,W
	MOVWF 0x30
; 140: 			Endif
L0023:
; 141: 			If value = 0 Then  'do not accept 0
	MOVF 0x30,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0024
; 142: 				value = bus_pos  'put it back to old situation
	MOVF 0x49,W
	MOVWF 0x30
; 143: 			Endif
L0024:
; 144: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 145: 			If value = bus_pos Then  'no other position is set, RR needs pos_match changes
	MOVF 0x30,W
	SUBWF 0x49,W
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0025
; 146: 				pos_match = 1
	BSF 0x06,4
; 147: 				WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 148: 				pos_match = 0
	BCF 0x06,4
; 149: 			Endif
L0025:
; 150: 		Endif
L0022:
; 151: 	Else
	BCF PCLATH,3
	GOTO L0026
L0021:
; 152: 		old_pos_write = 0
	BCF 0x4E,2
; 153: 	Endif
L0026:
; 154: 	bus_pos = value  'now take over the dseired position
	MOVF 0x30,W
	MOVWF 0x49
; 155: 	Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 156: 	Select Case result
; 157: 	Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0027
; 158: 		If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x4B,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0028
; 159: 			encoder_count = encoder_count + 1
	MOVF 0x4B,W
	ADDLW 0x01
	MOVWF 0x4B
; 160: 		Else
	BCF PCLATH,3
	GOTO L0029
L0028:
; 161: 			encoder_count = 0
	CLRF 0x4B
; 162: 			manual_pos = manual_pos + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
; 163: 			If manual_pos > max_pos Then
	MOVF 0x44,W
	SUBWF 0x3D,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0030
; 164: 				manual_pos = max_pos
	MOVF 0x3D,W
	MOVWF 0x44
; 165: 			Endif
L0030:
; 166: 			value = manual_pos
	MOVF 0x44,W
	MOVWF 0x30
; 167: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 168: 		Endif
L0029:
; 169: 	Case 2
	BCF PCLATH,3
	GOTO L0031
L0027:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0032
; 170: 		If encoder_count > 0 Then
	MOVF 0x4B,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0033
; 171: 			encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x4B,W
	MOVWF 0x4B
; 172: 		Else
	BCF PCLATH,3
	GOTO L0034
L0033:
; 173: 			encoder_count = 4
	MOVLW 0x04
	MOVWF 0x4B
; 174: 			If manual_pos > 0 Then
	MOVF 0x44,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0035
; 175: 				manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x44,W
	MOVWF 0x44
; 176: 			Endif
L0035:
; 177: 			value = manual_pos
	MOVF 0x44,W
	MOVWF 0x30
; 178: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 179: 		Endif
L0034:
; 180: 	Case Else
	BCF PCLATH,3
	GOTO L0036
L0032:
; 181: 	EndSelect
L0036:
L0031:
; 182: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 183: 	
; 184: Return
	RETURN
; 185: 
; 186: calc_rotation:  'this routine checks the incrimental switch
L0003:
; 187: '1 = increasing value
; 188: '2 = decreasing value
; 189: '3 = no change
; 190: 		new_encoder = 0
	CLRF 0x4A
; 191: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x4A,0
	BTFSS 0x07,4
	BCF 0x4A,0
; 192: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x4A,1
	BTFSS 0x07,5
	BCF 0x4A,1
; 193: 		Select Case old_encoder
; 194: 		Case 0
	MOVF 0x51,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0037
; 195: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x4A,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0038
	BCF PCLATH,3
	CALL L0039
	MOVWF 0x3E
	BCF PCLATH,3
	GOTO L0038
L0039:
	MOVLW 0x01
	MOVWF PCLATH
	MOVF 0x4A,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
L0038:
; 196: 		Case 1
	BCF PCLATH,3
	GOTO L0040
L0037:
	MOVF 0x51,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0041
; 197: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x4A,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0042
	BCF PCLATH,3
	CALL L0043
	MOVWF 0x3E
	BCF PCLATH,3
	GOTO L0042
L0043:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x4A,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
L0042:
; 198: 		Case 2
	BCF PCLATH,3
	GOTO L0044
L0041:
	MOVF 0x51,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0045
; 199: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x4A,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0046
	BCF PCLATH,3
	CALL L0047
	MOVWF 0x3E
	BCF PCLATH,3
	GOTO L0046
L0047:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x4A,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
L0046:
; 200: 		Case Else
	BCF PCLATH,3
	GOTO L0048
L0045:
; 201: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x4A,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0049
	BCF PCLATH,3
	CALL L0050
	MOVWF 0x3E
	BCF PCLATH,3
	GOTO L0049
L0050:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x4A,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
L0049:
; 202: 		EndSelect
L0048:
L0044:
L0040:
; 203: 		old_encoder = new_encoder
	MOVF 0x4A,W
	MOVWF 0x51
; 204: Return
	RETURN
; 205: 
; 206: 
; 207: adjust_settings:
L0004:
; 208: 	onoff = 0
	BCF 0x4E,0
; 209: 	Gosub relays
	BSF PCLATH,3
	CALL L0010
; 210: 	Gosub steps_reading
	BCF PCLATH,3
	CALL L0007
; 211: 	Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 212: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x40,W
	MOVWF 0x37
	MOVF 0x41,W
	MOVWF 0x38
; 213: 	Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 214: 	WaitMs 1500  'give some time for display to be read
	MOVLW 0xDC
	MOVWF R0L
	MOVLW 0x05
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 215: 	While pgm = 0
L0051:
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0052
; 216: 		If ecsw = 0 Then  'knob is pressed, adjust max positions
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0053
; 217: 			program_set = program_set + 1
	MOVF 0x47,W
	ADDLW 0x01
	MOVWF 0x47
; 218: 			If program_set > 7 Then
	MOVF 0x47,W
	SUBLW 0x07
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0054
; 219: 				program_set = 1
	MOVLW 0x01
	MOVWF 0x47
; 220: 			Endif
L0054:
; 221: 			Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 222: 			WaitMs 1500  'give some time for display to be read
	MOVLW 0xDC
	MOVWF R0L
	MOVLW 0x05
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 223: 			While ecsw = 0  'be sure pushbutton is released
L0055:
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0056
; 224: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 225: 			Wend
	BCF PCLATH,3
	GOTO L0055
L0056:
; 226: 		Endif
L0053:
; 227: 		Select Case program_set
; 228: 		Case 1  'correction position
	MOVF 0x47,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0057
; 229: 			value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 230: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 231: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 232: 			Select Case result
; 233: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0058
; 234: 				If new_steps < 60000 Then
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0059
; 235: 					ena = 1  'motor on
	BSF 0x07,2
; 236: 					new_steps = new_steps + 1
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x37
	MOVF 0x38,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x38
; 237: 					direction = 1
	BSF 0x07,0
; 238: 					clk = 1  'clock out
	BSF 0x07,1
; 239: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 240: 					clk = 0
	BCF 0x07,1
; 241: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 242: 				Endif
L0059:
; 243: 			Case 2
	BCF PCLATH,3
	GOTO L0060
L0058:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0061
; 244: 				If new_steps > 0 Then
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0062
; 245: 					ena = 1  'motor on
	BSF 0x07,2
; 246: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x37,W
	MOVWF 0x37
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x38,W
	MOVWF 0x38
; 247: 					direction = 0
	BCF 0x07,0
; 248: 					clk = 1  'clock out
	BSF 0x07,1
; 249: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 250: 					clk = 0
	BCF 0x07,1
; 251: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 252: 				Endif
L0062:
; 253: 			Case Else
	BCF PCLATH,3
	GOTO L0063
L0061:
; 254: 			EndSelect
L0063:
L0060:
; 255: 		Case 2  'setting of maximum positions
	BCF PCLATH,3
	GOTO L0064
L0057:
	MOVF 0x47,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0065
; 256: 			ena = 0  'shut off motor
	BCF 0x07,2
; 257: 			value = max_pos
	MOVF 0x3D,W
	MOVWF 0x30
; 258: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 259: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 260: 			Select Case result
; 261: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0066
; 262: 				If max_pos < 48 Then  'no more positions possible
	MOVLW 0x30
	SUBWF 0x3D,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0067
; 263: 					max_pos = max_pos + 1
	MOVF 0x3D,W
	ADDLW 0x01
	MOVWF 0x3D
; 264: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0068:	BTFSC EECON1,WR
	GOTO L0068
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 265: 				Endif
L0067:
; 266: 			Case 2
	BCF PCLATH,3
	GOTO L0069
L0066:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0070
; 267: 				If max_pos > 4 Then  'minum 4 positions
	MOVF 0x3D,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0071
; 268: 					max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
; 269: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0072:	BTFSC EECON1,WR
	GOTO L0072
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 270: 				Endif
L0071:
; 271: 			Case Else
	BCF PCLATH,3
	GOTO L0073
L0070:
; 272: 			EndSelect
L0073:
L0069:
; 273: 		Case 3  'setting control type
	BCF PCLATH,3
	GOTO L0074
L0065:
	MOVF 0x47,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0075
; 274: 			ena = 0  'shut off motor
	BCF 0x07,2
; 275: 			If ctrl_type > 6 Then
	MOVF 0x36,W
	SUBLW 0x06
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0076
; 276: 				ctrl_type = 0
	CLRF 0x36
; 277: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0077:	BTFSC EECON1,WR
	GOTO L0077
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 278: 			Endif
L0076:
; 279: 			value = ctrl_type
	MOVF 0x36,W
	MOVWF 0x30
; 280: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 281: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 282: 			Select Case result
; 283: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0078
; 284: 				If ctrl_type < 6 Then
	MOVLW 0x06
	SUBWF 0x36,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0079
; 285: 					ctrl_type = ctrl_type + 1
	MOVF 0x36,W
	ADDLW 0x01
	MOVWF 0x36
; 286: 					Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0080:	BTFSC EECON1,WR
	GOTO L0080
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 287: 				Endif
L0079:
; 288: 			Case 2
	BCF PCLATH,3
	GOTO L0081
L0078:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0082
; 289: 				If ctrl_type > 0 Then
	MOVF 0x36,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0083
; 290: 					ctrl_type = ctrl_type - 1
	MOVLW 0x01
	SUBWF 0x36,W
	MOVWF 0x36
; 291: 					Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0084:	BTFSC EECON1,WR
	GOTO L0084
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 292: 				Endif
L0083:
; 293: 			Case Else
	BCF PCLATH,3
	GOTO L0085
L0082:
; 294: 			EndSelect
L0085:
L0081:
; 295: 		Case 4  'setting of speed interval Minimum
	BCF PCLATH,3
	GOTO L0086
L0075:
	MOVF 0x47,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0087
; 296: 					'setting will be done in multiple of 256 uSecs
; 297: 					'minimum is 2 and maximum is 99 (is real slow)
; 298: 			ena = 0  'shut off motor
	BCF 0x07,2
; 299: 			value = speed_min.HB
	MOVF 0x3C,W
	MOVWF 0x30
; 300: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 301: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 302: 			Select Case result
; 303: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0088
; 304: 				If speed_min.HB < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x3C,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0089
; 305: 					speed_min = speed_min + 256
	MOVF 0x3B,W
	ADDLW 0x00
	MOVWF 0x3B
	MOVF 0x3C,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x01
	MOVWF 0x3C
; 306: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0090:	BTFSC EECON1,WR
	GOTO L0090
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 307: 				Endif
L0089:
; 308: 			Case 2
	BCF PCLATH,3
	GOTO L0091
L0088:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0092
; 309: 				If speed_min > speed_max Then
	MOVF 0x3B,W
	MOVWF R0L
	MOVF 0x3C,W
	MOVWF R0H
	MOVF 0x39,W
	MOVWF R1L
	MOVF 0x3A,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0093
; 310: 					speed_min = speed_min - 256
	MOVLW 0x00
	SUBWF 0x3B,W
	MOVWF 0x3B
	MOVLW 0x01
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3C,W
	MOVWF 0x3C
; 311: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0094:	BTFSC EECON1,WR
	GOTO L0094
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 312: 				Endif
L0093:
; 313: 			Case Else
	BCF PCLATH,3
	GOTO L0095
L0092:
; 314: 			EndSelect
L0095:
L0091:
; 315: 		Case 5  'setting of speed interval Maximum
	BCF PCLATH,3
	GOTO L0096
L0087:
	MOVF 0x47,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0097
; 316: 					'setting will be done in multiple of 256 uSecs
; 317: 					'minimum is 1 and maximum is 99 (is real slow)
; 318: 			ena = 0  'shut off motor
	BCF 0x07,2
; 319: 			value = speed_max.HB
	MOVF 0x3A,W
	MOVWF 0x30
; 320: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 321: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 322: 			Select Case result
; 323: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0098
; 324: 				If speed_max.HB < speed_min.HB Then  'not more then speed_min
	MOVF 0x3C,W
	SUBWF 0x3A,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0099
; 325: 					speed_max.HB = speed_max.HB + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
; 326: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0100:	BTFSC EECON1,WR
	GOTO L0100
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 327: 				Endif
L0099:
; 328: 			Case 2
	BCF PCLATH,3
	GOTO L0101
L0098:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0102
; 329: 				If speed_max.HB > 1 Then
	MOVF 0x3A,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0103
; 330: 					speed_max.HB = speed_max.HB - 1
	MOVLW 0x01
	SUBWF 0x3A,W
	MOVWF 0x3A
; 331: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0104:	BTFSC EECON1,WR
	GOTO L0104
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 332: 				Endif
L0103:
; 333: 			Case Else
	BCF PCLATH,3
	GOTO L0105
L0102:
; 334: 			EndSelect
L0105:
L0101:
; 335: 		Case 6  'setting of ramp up and down speed
	BCF PCLATH,3
	GOTO L0106
L0097:
	MOVF 0x47,W
	SUBLW 0x06
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0107
; 336: 					'speed will be the value that speed will be changed every step up and down
; 337: 			ena = 0  'shut off motor
	BCF 0x07,2
; 338: 			value = speed_step
	MOVF 0x46,W
	MOVWF 0x30
; 339: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 340: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 341: 			Select Case result
; 342: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0108
; 343: 				If speed_step < 99 Then  'maximum 99 is possible
	MOVLW 0x63
	SUBWF 0x46,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0109
; 344: 					speed_step = speed_step + 1
	MOVF 0x46,W
	ADDLW 0x01
	MOVWF 0x46
; 345: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x46,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0110:	BTFSC EECON1,WR
	GOTO L0110
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 346: 				Endif
L0109:
; 347: 			Case 2
	BCF PCLATH,3
	GOTO L0111
L0108:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0112
; 348: 				If speed_step > 1 Then
	MOVF 0x46,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0113
; 349: 					speed_step = speed_step - 1
	MOVLW 0x01
	SUBWF 0x46,W
	MOVWF 0x46
; 350: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x46,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0114:	BTFSC EECON1,WR
	GOTO L0114
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 351: 				Endif
L0113:
; 352: 			Case Else
	BCF PCLATH,3
	GOTO L0115
L0112:
; 353: 			EndSelect
L0115:
L0111:
; 354: 	
; 355: 		Case Else  'setting of extra free space steps
	BCF PCLATH,3
	GOTO L0116
L0107:
; 356: 			ena = 0  'shut off motor
	BCF 0x07,2
; 357: 			If free_space_steps > 250 Then
	MOVF 0x3F,W
	SUBLW 0xFA
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0117
; 358: 				free_space_steps = 250
	MOVLW 0xFA
	MOVWF 0x3F
; 359: 				Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0118:	BTFSC EECON1,WR
	GOTO L0118
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 360: 			Endif
L0117:
; 361: 			value = free_space_steps
	MOVF 0x3F,W
	MOVWF 0x30
; 362: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 363: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 364: 			Select Case result
; 365: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0119
; 366: 				If free_space_steps < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x3F,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0120
; 367: 					free_space_steps = free_space_steps + 1
	MOVF 0x3F,W
	ADDLW 0x01
	MOVWF 0x3F
; 368: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0121:	BTFSC EECON1,WR
	GOTO L0121
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 369: 				Endif
L0120:
; 370: 			Case 2
	BCF PCLATH,3
	GOTO L0122
L0119:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0123
; 371: 				If free_space_steps > 0 Then
	MOVF 0x3F,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0124
; 372: 					free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x3F
; 373: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0125:	BTFSC EECON1,WR
	GOTO L0125
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 374: 				Endif
L0124:
; 375: 			Case Else
	BCF PCLATH,3
	GOTO L0126
L0123:
; 376: 			EndSelect
L0126:
L0122:
; 377: 		EndSelect
L0116:
L0106:
L0096:
L0086:
L0074:
L0064:
; 378: 	Wend
	BCF PCLATH,3
	GOTO L0051
L0052:
; 379: 	ena = 0  'shut off motor
	BCF 0x07,2
; 380: 		'***************   now check if changes have to BE written in eeprom
; 381: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	MOVF 0x40,W
	MOVWF R1L
	MOVF 0x41,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C002
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0127
; 382: 		eprom_pointer1 = act_pos
	MOVF 0x31,W
	MOVWF 0x45
; 383: 		eprom_pointer2 = eprom_pointer1 + 48
	MOVF 0x45,W
	ADDLW 0x30
	MOVWF 0x42
; 384: 		Write eprom_pointer1, new_steps.LB
	MOVF 0x45,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0128:	BTFSC EECON1,WR
	GOTO L0128
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 385: 		Write eprom_pointer2, new_steps.HB
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0129:	BTFSC EECON1,WR
	GOTO L0129
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 386: 		Gosub check_next_steps
	BSF PCLATH,3
	CALL L0011
; 387: 	Endif
L0127:
; 388: 	value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 389: 	Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 390: 	onoff = 1
	BSF 0x4E,0
; 391: 	Gosub relays
	BSF PCLATH,3
	CALL L0010
; 392: Return
	RETURN
; 393: 
; 394: i2c_display:
L0005:
; 395: 	disp1_val = value
	MOVF 0x30,W
	MOVWF 0x48
; 396: 	disp1_val = disp1_val Mod 10
	MOVF 0x48,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x48
; 397: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x48,W
	SUBLW 0x09
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0130
	BCF PCLATH,3
	CALL L0131
	MOVWF 0x48
	BCF PCLATH,3
	GOTO L0130
L0131:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x48,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
L0130:
; 398: 	disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x48,7
	BTFSS 0x07,7
	BCF 0x48,7
; 399: 	disp2_val = value
	MOVF 0x30,W
	MOVWF 0x4F
; 400: 	disp2_val = disp2_val / 10
	MOVF 0x4F,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4F
; 401: 	disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x4F,W
	SUBLW 0x0A
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0132
	BCF PCLATH,3
	CALL L0133
	MOVWF 0x4F
	BCF PCLATH,3
	GOTO L0132
L0133:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x4F,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
L0132:
; 402: 	disp2_val.7 = version
	BTFSC 0x4E,3
	BSF 0x4F,7
	BTFSS 0x4E,3
	BCF 0x4F,7
; 403: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 404: 	I2CSend disp1
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 405: 	I2CSend disp1_val
	BCF PCLATH,3
	MOVF 0x48,W
	CALL IC01
; 406: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 407: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 408: 	I2CSend disp2
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 409: 	I2CSend disp2_val
	BCF PCLATH,3
	MOVF 0x4F,W
	CALL IC01
; 410: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 411: Return
	RETURN
; 412: 
; 413: i2c_display_pgm:
L0006:
; 414: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000), program_set
	MOVF 0x47,W
	SUBLW 0x07
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0134
	BCF PCLATH,3
	CALL L0135
	MOVWF 0x48
	BCF PCLATH,3
	GOTO L0134
L0135:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x47,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
L0134:
; 415: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 416: 	I2CSend disp1
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 417: 	I2CSend disp1_val
	BCF PCLATH,3
	MOVF 0x48,W
	CALL IC01
; 418: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 419: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 420: 	I2CSend disp2
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 421: 	I2CSend %10111111
	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 422: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 423: Return
	RETURN
; 424: 
; 425: steps_reading:
L0007:
; 426: 	If act_pos = 0 Then
	MOVF 0x31,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0136
; 427: 		act_steps = 0
	CLRF 0x40
	CLRF 0x41
; 428: 	Else
	BCF PCLATH,3
	GOTO L0137
L0136:
; 429: 		eprom_pointer1 = act_pos
	MOVF 0x31,W
	MOVWF 0x45
; 430: 		eprom_pointer2 = eprom_pointer1 + 48
	MOVF 0x45,W
	ADDLW 0x30
	MOVWF 0x42
; 431: 		Read eprom_pointer1, act_steps.LB
	MOVF 0x45,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 432: 		Read eprom_pointer2, act_steps.HB
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 433: 	Endif
L0137:
; 434: 	If new_pos = 0 Then
	MOVF 0x50,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0138
; 435: 		new_steps = 0
	CLRF 0x37
	CLRF 0x38
; 436: 	Else
	BCF PCLATH,3
	GOTO L0139
L0138:
; 437: 		eprom_pointer1 = new_pos
	MOVF 0x50,W
	MOVWF 0x45
; 438: 		eprom_pointer2 = eprom_pointer1 + 48
	MOVF 0x45,W
	ADDLW 0x30
	MOVWF 0x42
; 439: 		Read eprom_pointer1, new_steps.LB
	MOVF 0x45,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 440: 		Read eprom_pointer2, new_steps.HB
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x38
; 441: 	Endif
L0139:
; 442: Return
	RETURN
; 443: 
; 444: stepmotor:
L0008:
; 445: 	speed = 0
	CLRF 0x4C
	CLRF 0x4D
; 446: 	Gosub steps_reading
	BCF PCLATH,3
	CALL L0007
; 447: 	If new_steps = 0 Then
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C001
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0140
; 448: 		direction = 0
	BCF 0x07,0
; 449: 		ena = 1  'set anable on
	BSF 0x07,2
; 450: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 451: 		While zero = 1  'turn motor until zero switch is activated
L0141:
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0142
; 452: 			clk = 1  'clock out
	BSF 0x07,1
; 453: 			WaitUs speed_max
	MOVF 0x39,W
	MOVWF R4L
	MOVF 0x3A,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 454: 			clk = 0
	BCF 0x07,1
; 455: 			WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 456: 		Wend
	BCF PCLATH,3
	GOTO L0141
L0142:
; 457: 		act_pos = 0
	CLRF 0x31
; 458: 		Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0143:	BTFSC EECON1,WR
	GOTO L0143
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 459: 		Select Case ctrl_type
; 460: 		Case 2, 3, 4, 5  'NOW GO ONE MORE COMPLETE ROUND FOR COUNTING STEPS
	MOVF 0x36,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0146
	BCF PCLATH,3
	GOTO L0145
L0146:
	MOVF 0x36,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0147
	BCF PCLATH,3
	GOTO L0145
L0147:
	MOVF 0x36,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0148
	BCF PCLATH,3
	GOTO L0145
L0148:
	MOVF 0x36,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0144
L0145:
; 461: 			one_round = 0
	CLRF 0x34
	CLRF 0x35
; 462: 			ena = 1  'set anable on
	BSF 0x07,2
; 463: 			While zero = 0  'turn motor until zero switch is DISactivated
L0149:
	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0150
; 464: 				clk = 1  'clock out
	BSF 0x07,1
; 465: 				WaitUs speed_max
	MOVF 0x39,W
	MOVWF R4L
	MOVF 0x3A,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 466: 				clk = 0
	BCF 0x07,1
; 467: 				one_round = one_round + 1
	MOVF 0x34,W
	ADDLW 0x01
	MOVWF 0x34
	MOVF 0x35,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x35
; 468: 				WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 469: 			Wend
	BCF PCLATH,3
	GOTO L0149
L0150:
; 470: 			For value = 1 To 100  'SOME MORE STEPS TO AVOID CONTACT DENDER.
	MOVLW 0x01
	MOVWF 0x30
L0151:
	MOVF 0x30,W
	SUBLW 0x64
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0152
; 471: 				clk = 1  'clock out
	BSF 0x07,1
; 472: 				WaitUs speed_max
	MOVF 0x39,W
	MOVWF R4L
	MOVF 0x3A,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 473: 				clk = 0
	BCF 0x07,1
; 474: 				WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 475: 				one_round = one_round + 1
	MOVF 0x34,W
	ADDLW 0x01
	MOVWF 0x34
	MOVF 0x35,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x35
; 476: 			Next value
	MOVLW 0x01
	ADDWF 0x30,F
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0151
L0152:
; 477: 			While zero = 1  'turn motor until zero switch is activated
L0153:
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0154
; 478: 				clk = 1  'clock out
	BSF 0x07,1
; 479: 				WaitUs speed_max
	MOVF 0x39,W
	MOVWF R4L
	MOVF 0x3A,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 480: 				clk = 0
	BCF 0x07,1
; 481: 				WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 482: 				one_round = one_round + 1
	MOVF 0x34,W
	ADDLW 0x01
	MOVWF 0x34
	MOVF 0x35,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x35
; 483: 			Wend
	BCF PCLATH,3
	GOTO L0153
L0154:
; 484: 			one_round_half = one_round / 2
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x55
	MOVF R0H,W
	MOVWF 0x56
; 485: 			Write mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0155:	BTFSC EECON1,WR
	GOTO L0155
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 486: 			Write mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0156:	BTFSC EECON1,WR
	GOTO L0156
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 487: 			act_pos = 0
	CLRF 0x31
; 488: 			Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0157:	BTFSC EECON1,WR
	GOTO L0157
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 489: 		Case 6  'Fiddle yard control, go the other way to end switch.
	BSF PCLATH,3
	GOTO L0158
L0144:
	MOVF 0x36,W
	SUBLW 0x06
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0159
; 490: 			one_round = 0
	CLRF 0x34
	CLRF 0x35
; 491: 			ena = 1  'set anable on
	BSF 0x07,2
; 492: 			direction = 1  'go To max position
	BSF 0x07,0
; 493: 			While max_end = 1  'turn motor until end switch activated
L0160:
	BCF PCLATH,3
	BTFSS 0x06,7
	GOTO L0161
; 494: 				clk = 1  'clock out
	BSF 0x07,1
; 495: 				WaitUs speed_max
	MOVF 0x39,W
	MOVWF R4L
	MOVF 0x3A,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 496: 				clk = 0
	BCF 0x07,1
; 497: 				one_round = one_round + 1
	MOVF 0x34,W
	ADDLW 0x01
	MOVWF 0x34
	MOVF 0x35,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x35
; 498: 				WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 499: 			Wend
	BCF PCLATH,3
	GOTO L0160
L0161:
; 500: 			Write mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0162:	BTFSC EECON1,WR
	GOTO L0162
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 501: 			Write mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0163:	BTFSC EECON1,WR
	GOTO L0163
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 502: 			act_pos = max_pos + 1
	MOVF 0x3D,W
	ADDLW 0x01
	MOVWF 0x31
; 503: 			If eep = 1 Then
	BSF PCLATH,3
	BTFSS 0x06,6
	GOTO L0164
; 504: 				For value = 1 To max_pos
	MOVLW 0x01
	MOVWF 0x30
L0165:
	MOVF 0x30,W
	SUBWF 0x3D,W
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0166
; 505: 					steps = one_round / 12
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVLW 0x0C
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x32
	MOVF R0H,W
	MOVWF 0x33
; 506: 					steps = value * steps
	MOVF 0x30,W
	MOVWF R3L
	CLRF R3H
	MOVF 0x32,W
	MOVWF R1L
	MOVF 0x33,W
	MOVWF R1H
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x32
	MOVF R2H,W
	MOVWF 0x33
; 507: 					eprom_pointer2 = value + 48
	MOVF 0x30,W
	ADDLW 0x30
	MOVWF 0x42
; 508: 					Write value, steps.LB
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0167:	BTFSC EECON1,WR
	GOTO L0167
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 509: 					Write eprom_pointer2, steps.HB
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0168:	BTFSC EECON1,WR
	GOTO L0168
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 510: 				Next value
	MOVLW 0x01
	ADDWF 0x30,F
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0165
L0166:
; 511: 				value = max_pos + 1
	MOVF 0x3D,W
	ADDLW 0x01
	MOVWF 0x30
; 512: 				eprom_pointer2 = value + 48
	MOVF 0x30,W
	ADDLW 0x30
	MOVWF 0x42
; 513: 				Write value, one_round.LB
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x34,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0169:	BTFSC EECON1,WR
	GOTO L0169
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 514: 				Write eprom_pointer2, one_round.HB
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0170:	BTFSC EECON1,WR
	GOTO L0170
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 515: 			Endif
L0164:
; 516: 			act_pos = 13
	MOVLW 0x0D
	MOVWF 0x31
; 517: 			Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0171:	BTFSC EECON1,WR
	GOTO L0171
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 518: 		Case Else
	BSF PCLATH,3
	GOTO L0172
L0159:
; 519: 			act_pos = 0
	CLRF 0x31
; 520: 			Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0173:	BTFSC EECON1,WR
	GOTO L0173
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 521: 		EndSelect
L0172:
L0158:
; 522: 		ena = 0  'set anable off
	BCF 0x07,2
; 523: 	Else  'this is the normal position sequence
	BSF PCLATH,3
	GOTO L0174
L0140:
; 524: 		steps = 0
	CLRF 0x32
	CLRF 0x33
; 525: 		If new_steps > act_steps Then
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	MOVF 0x40,W
	MOVWF R1L
	MOVF 0x41,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0175
; 526: 			steps = new_steps - act_steps
	MOVF 0x40,W
	SUBWF 0x37,W
	MOVWF 0x32
	MOVF 0x41,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x38,W
	MOVWF 0x33
; 527: 			direction = 1
	BSF 0x07,0
; 528: 			If steps > one_round_half Then  'is other direction shorter?
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVF 0x55,W
	MOVWF R1L
	MOVF 0x56,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0176
; 529: 				Select Case ctrl_type
; 530: 				Case 2, 3
	MOVF 0x36,W
	SUBLW 0x02
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0179
	BSF PCLATH,3
	GOTO L0178
L0179:
	MOVF 0x36,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0177
L0178:
; 531: 					If ctrl_type > 1 Then  'check If short way is set
	MOVF 0x36,W
	SUBLW 0x01
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0180
; 532: 						Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x43
; 533: 						If turn_counter > 126 Then  'check if shortest way is allowed
	MOVF 0x43,W
	SUBLW 0x7E
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0181
; 534: 							turn_counter = turn_counter - 1  'yes it is, so substract one pass
	MOVLW 0x01
	SUBWF 0x43,W
	MOVWF 0x43
; 535: 							steps = one_round - steps  'go shortest way
	MOVF 0x32,W
	SUBWF 0x34,W
	MOVWF 0x32
	MOVF 0x33,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x35,W
	MOVWF 0x33
; 536: 							direction = 0  'change  direction
	BCF 0x07,0
; 537: 							Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0182:	BTFSC EECON1,WR
	GOTO L0182
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 538: 						Endif
L0181:
; 539: 					Endif
L0180:
; 540: 				Case 4, 5  'type with contact sliders, no twisting cables
	BSF PCLATH,3
	GOTO L0183
L0177:
	MOVF 0x36,W
	SUBLW 0x04
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0186
	BSF PCLATH,3
	GOTO L0185
L0186:
	MOVF 0x36,W
	SUBLW 0x05
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0184
L0185:
; 541: 					steps = one_round - steps
	MOVF 0x32,W
	SUBWF 0x34,W
	MOVWF 0x32
	MOVF 0x33,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x35,W
	MOVWF 0x33
; 542: 					direction = 0
	BCF 0x07,0
; 543: 				Case Else  'no short way possible
	BSF PCLATH,3
	GOTO L0187
L0184:
; 544: 				EndSelect
L0187:
L0183:
; 545: 			Endif
L0176:
; 546: 		Else
	BSF PCLATH,3
	GOTO L0188
L0175:
; 547: 			steps = act_steps - new_steps
	MOVF 0x37,W
	SUBWF 0x40,W
	MOVWF 0x32
	MOVF 0x38,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x41,W
	MOVWF 0x33
; 548: 			direction = 0
	BCF 0x07,0
; 549: 			If steps > one_round_half Then  'other direction shorter?
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVF 0x55,W
	MOVWF R1L
	MOVF 0x56,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0189
; 550: 				Select Case ctrl_type
; 551: 				Case 2, 3  'cable connected bridges
	MOVF 0x36,W
	SUBLW 0x02
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0192
	BSF PCLATH,3
	GOTO L0191
L0192:
	MOVF 0x36,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0190
L0191:
; 552: 					Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x43
; 553: 					If turn_counter < 130 Then  'check if shortest way is allowed
	MOVLW 0x82
	SUBWF 0x43,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0193
; 554: 						turn_counter = turn_counter + 1  'yes it is, so add one pass
	MOVF 0x43,W
	ADDLW 0x01
	MOVWF 0x43
; 555: 						steps = one_round - steps  'go shortest way
	MOVF 0x32,W
	SUBWF 0x34,W
	MOVWF 0x32
	MOVF 0x33,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x35,W
	MOVWF 0x33
; 556: 						direction = 1  'change direction
	BSF 0x07,0
; 557: 						Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x43,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0194:	BTFSC EECON1,WR
	GOTO L0194
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 558: 					Endif
L0193:
; 559: 				Case 4, 5  'type with contact sliders, no twisting cables
	BSF PCLATH,3
	GOTO L0195
L0190:
	MOVF 0x36,W
	SUBLW 0x04
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0198
	BSF PCLATH,3
	GOTO L0197
L0198:
	MOVF 0x36,W
	SUBLW 0x05
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0196
L0197:
; 560: 					steps = one_round - steps
	MOVF 0x32,W
	SUBWF 0x34,W
	MOVWF 0x32
	MOVF 0x33,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x35,W
	MOVWF 0x33
; 561: 					direction = 1
	BSF 0x07,0
; 562: 				Case Else  'no short way possible
	BSF PCLATH,3
	GOTO L0199
L0196:
; 563: 				EndSelect
L0199:
L0195:
; 564: 			Endif
L0189:
; 565: 		Endif
L0188:
; 566: 		If steps > 0 Then  'motor must be activated
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0200
; 567: 			If direction = 1 Then
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0201
; 568: 				steps = steps + free_space_steps
	MOVF 0x32,W
	ADDWF 0x3F,W
	MOVWF 0x32
	MOVF 0x33,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x33
; 569: 			Endif
L0201:
; 570: 			ramp_up = 1
	BSF 0x4E,1
; 571: 			ramp_down_point = 0
	CLRF 0x53
	CLRF 0x54
; 572: 			half_steps = steps / 2
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x58
	MOVF R0H,W
	MOVWF 0x59
; 573: 			speed = speed_min
	MOVF 0x3B,W
	MOVWF 0x4C
	MOVF 0x3C,W
	MOVWF 0x4D
; 574: 			ena = 1  'set anable on
	BSF 0x07,2
; 575: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 576: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0202:
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0203
; 577: 				clk = 1  'clock out
	BSF 0x07,1
; 578: 				WaitUs speed
	MOVF 0x4C,W
	MOVWF R4L
	MOVF 0x4D,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 579: 				clk = 0
	BCF 0x07,1
; 580: 				Gosub speed_calc
	BSF PCLATH,3
	CALL L0009
; 581: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x32,W
	MOVWF 0x32
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
; 582: 			Wend
	BSF PCLATH,3
	GOTO L0202
L0203:
; 583: 			WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 584: 			If direction = 1 Then
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0204
; 585: 				steps = free_space_steps
	MOVF 0x3F,W
	MOVWF 0x32
	CLRF 0x33
; 586: 				direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 587: 				While steps > 0  'NOW RUN UNTIL STEPS = 0
L0205:
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0206
; 588: 					clk = 1  'clock out
	BSF 0x07,1
; 589: 					WaitUs speed_min
	MOVF 0x3B,W
	MOVWF R4L
	MOVF 0x3C,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 590: 					clk = 0
	BCF 0x07,1
; 591: 					steps = steps - 1
	MOVLW 0x01
	SUBWF 0x32,W
	MOVWF 0x32
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
; 592: 					WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 593: 				Wend
	BSF PCLATH,3
	GOTO L0205
L0206:
; 594: 			Endif
L0204:
; 595: 			ena = 0  'enable off
	BCF 0x07,2
; 596: 		Endif
L0200:
; 597: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 598: 	Endif
L0174:
; 599: 	act_pos = new_pos
	MOVF 0x50,W
	MOVWF 0x31
; 600: 	Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0207:	BTFSC EECON1,WR
	GOTO L0207
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 601: 	bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x49
; 602: 	old_bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x57
; 603: 	manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x44
; 604: 	old_manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x52
; 605: Return
	RETURN
; 606: 
; 607: 
; 608: speed_calc:
L0009:
; 609: 	If steps < half_steps Then  'at this point  ramp up MUST end
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVF 0x58,W
	MOVWF R1L
	MOVF 0x59,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0208
; 610: 		ramp_up = 0
	BCF 0x4E,1
; 611: 	Endif
L0208:
; 612: 	If ramp_up = 1 Then  'we were supposed to ramp up
	BSF PCLATH,3
	BTFSS 0x4E,1
	GOTO L0209
; 613: 		If speed > speed_max Then
	MOVF 0x4C,W
	MOVWF R0L
	MOVF 0x4D,W
	MOVWF R0H
	MOVF 0x39,W
	MOVWF R1L
	MOVF 0x3A,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0210
; 614: 			speed = speed - speed_step
	MOVF 0x46,W
	SUBWF 0x4C,W
	MOVWF 0x4C
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x4D,W
	MOVWF 0x4D
; 615: 			ramp_down_point = ramp_down_point + 1  'this counts down with the steps
	MOVF 0x53,W
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x54
; 616: 		Else
	BSF PCLATH,3
	GOTO L0211
L0210:
; 617: 			ramp_up = 0
	BCF 0x4E,1
; 618: 		Endif
L0211:
; 619: 	Else
	BSF PCLATH,3
	GOTO L0212
L0209:
; 620: 		If steps < ramp_down_point Then  'this is the point tot start ramp down
	MOVF 0x32,W
	MOVWF R0L
	MOVF 0x33,W
	MOVWF R0H
	MOVF 0x53,W
	MOVWF R1L
	MOVF 0x54,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0213
; 621: 			If speed < speed_min Then
	MOVF 0x4C,W
	MOVWF R0L
	MOVF 0x4D,W
	MOVWF R0H
	MOVF 0x3B,W
	MOVWF R1L
	MOVF 0x3C,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0214
; 622: 				speed = speed + speed_step
	MOVF 0x4C,W
	ADDWF 0x46,W
	MOVWF 0x4C
	MOVF 0x4D,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x4D
; 623: 			Endif
L0214:
; 624: 		Endif
L0213:
; 625: 	Endif
L0212:
; 626: Return
	RETURN
; 627: 
; 628: 
; 629: relays:
L0010:
; 630: 	If onoff = 1 Then
	BSF PCLATH,3
	BTFSS 0x4E,0
	GOTO L0215
; 631: 		value = max_pos + 1
	MOVF 0x3D,W
	ADDLW 0x01
	MOVWF 0x30
; 632: 		value = value / 2  'calulation of half max positions
	MOVF 0x30,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x30
; 633: 		Select Case ctrl_type
; 634: 		Case 1, 3, 5, 6
	MOVF 0x36,W
	SUBLW 0x01
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0218
	BSF PCLATH,3
	GOTO L0217
L0218:
	MOVF 0x36,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0219
	BSF PCLATH,3
	GOTO L0217
L0219:
	MOVF 0x36,W
	SUBLW 0x05
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0220
	BSF PCLATH,3
	GOTO L0217
L0220:
	MOVF 0x36,W
	SUBLW 0x06
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0216
L0217:
; 635: 			swfw = 0
	BCF 0x06,0
; 636: 			swrev = 1
	BSF 0x06,1
; 637: 		Case Else
	BSF PCLATH,3
	GOTO L0221
L0216:
; 638: 			If act_pos > value Then  'select polarity rails on bridge
	MOVF 0x31,W
	SUBWF 0x30,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0222
; 639: 				swfw = 0
	BCF 0x06,0
; 640: 				swrev = 1
	BSF 0x06,1
; 641: 			Else
	BSF PCLATH,3
	GOTO L0223
L0222:
; 642: 				swrev = 0
	BCF 0x06,1
; 643: 				swfw = 1
	BSF 0x06,0
; 644: 			Endif
L0223:
; 645: 		EndSelect
L0221:
; 646: 	Else
	BSF PCLATH,3
	GOTO L0224
L0215:
; 647: 		swfw = 0
	BCF 0x06,0
; 648: 		swrev = 0
	BCF 0x06,1
; 649: 	Endif
L0224:
; 650: Return
	RETURN
; 651: 
; 652: 
; 653: check_next_steps:
L0011:
; 654: 	'this is ment to check all following steps after readjusting one position.
; 655: 	'simply to avoid that tt will go backwards when set for the next (higher) position.
; 656: 	value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 657: 	If value > 1 Then
	MOVF 0x30,W
	SUBLW 0x01
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0225
; 658: 		Read 2, new_steps.LB
	MOVLW 0x02
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 659: 		Read 50, new_steps.HB
	MOVLW 0x32
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x38
; 660: 		Read 1, act_steps.LB
	MOVLW 0x01
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 661: 		Read 49, act_steps.HB
	MOVLW 0x31
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 662: 		steps = new_steps - act_steps  'calculate the steps between 1 And 2 ,
	MOVF 0x40,W
	SUBWF 0x37,W
	MOVWF 0x32
	MOVF 0x41,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x38,W
	MOVWF 0x33
; 663: 												'steps will be approx equal between all positionseps
; 664: 	Endif
L0225:
; 665: 	While value < max_pos
L0226:
	MOVF 0x3D,W
	SUBWF 0x30,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0227
; 666: 		value = value + 1
	MOVF 0x30,W
	ADDLW 0x01
	MOVWF 0x30
; 667: 		eprom_pointer2 = value + 48
	MOVF 0x30,W
	ADDLW 0x30
	MOVWF 0x42
; 668: 		Read value, new_steps.LB
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 669: 		Read eprom_pointer2, new_steps.HB
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x38
; 670: 		new_steps = new_steps + steps
	MOVF 0x37,W
	ADDWF 0x32,W
	MOVWF 0x37
	MOVF 0x38,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x33,W
	MOVWF 0x38
; 671: 		Write value, new_steps.LB
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0228:	BTFSC EECON1,WR
	GOTO L0228
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 672: 		Write eprom_pointer2, new_steps.HB
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0229:	BTFSC EECON1,WR
	GOTO L0229
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 673: 	Wend
	BSF PCLATH,3
	GOTO L0226
L0227:
; 674: Return
	RETURN
; 675: 
; 676: 
; 677: init_eeprom:
L0012:
; 678: 			'check if acceptable value is in eeprom
; 679: 	act_pos = 1
	MOVLW 0x01
	MOVWF 0x31
; 680: 	Write mem_act_pos, 1  'act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x01
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0230:	BTFSC EECON1,WR
	GOTO L0230
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 681: 	act_steps = 0
	CLRF 0x40
	CLRF 0x41
; 682: 		'check memory for correct total steps
; 683: 
; 684: 	For eprom_pointer1 = 1 To max_pos
	MOVLW 0x01
	MOVWF 0x45
L0231:
	MOVF 0x45,W
	SUBWF 0x3D,W
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0232
; 685: 		new_steps = one_round / max_pos  'devide the steps between min and max
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVF 0x3D,W
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x37
	MOVF R0H,W
	MOVWF 0x38
; 686: 		act_steps = act_steps + new_steps
	MOVF 0x40,W
	ADDWF 0x37,W
	MOVWF 0x40
	MOVF 0x41,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x38,W
	MOVWF 0x41
; 687: 		eprom_pointer2 = eprom_pointer1 + 48
	MOVF 0x45,W
	ADDLW 0x30
	MOVWF 0x42
; 688: 		Write eprom_pointer1, act_steps.LB
	MOVF 0x45,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0233:	BTFSC EECON1,WR
	GOTO L0233
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 689: 		Write eprom_pointer2, act_steps.HB
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0234:	BTFSC EECON1,WR
	GOTO L0234
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 690: 	Next eprom_pointer1
	MOVLW 0x01
	ADDWF 0x45,F
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0231
L0232:
; 691: 	free_space_steps = 20
	MOVLW 0x14
	MOVWF 0x3F
; 692: 	Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0235:	BTFSC EECON1,WR
	GOTO L0235
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 693: 			'check for correct control type
; 694: 			'now check for correct amount of 0-point passes
; 695: 
; 696: Return
	RETURN
; 697: init_values:
L0013:
; 698: 
; 699: 	encoder_count = 0
	CLRF 0x4B
; 700: 	speed_min = 0
	CLRF 0x3B
	CLRF 0x3C
; 701: 	Read mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3C
; 702: 	If speed_min.HB > 99 Then
	MOVF 0x3C,W
	SUBLW 0x63
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0236
; 703: 		speed_min.HB = 99
	MOVLW 0x63
	MOVWF 0x3C
; 704: 	Else
	BSF PCLATH,3
	GOTO L0237
L0236:
; 705: 		If speed_min.HB < 1 Then
	MOVLW 0x01
	SUBWF 0x3C,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0238
; 706: 			speed_min.HB = 1
	MOVLW 0x01
	MOVWF 0x3C
; 707: 		Endif
L0238:
; 708: 	Endif
L0237:
; 709: 	speed_max = 0
	CLRF 0x39
	CLRF 0x3A
; 710: 	Read mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3A
; 711: 	If speed_max.HB > speed_min.HB Then
	MOVF 0x3A,W
	SUBWF 0x3C,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0239
; 712: 		speed_max.HB = speed_min.HB
	MOVF 0x3C,W
	MOVWF 0x3A
; 713: 	Else
	BSF PCLATH,3
	GOTO L0240
L0239:
; 714: 		If speed_max.HB < 1 Then
	MOVLW 0x01
	SUBWF 0x3A,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0241
; 715: 			speed_max.HB = 1
	MOVLW 0x01
	MOVWF 0x3A
; 716: 		Endif
L0241:
; 717: 	Endif
L0240:
; 718: 
; 719: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x34
; 720: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x35
; 721: 	If one_round = 0 Then
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C001
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0242
; 722: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x34
	MOVLW 0x1F
	MOVWF 0x35
; 723: 	Endif
L0242:
; 724: 	If one_round > 60000 Then
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0243
; 725: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x34
	MOVLW 0x1F
	MOVWF 0x35
; 726: 	Endif
L0243:
; 727: 	one_round_half = one_round / 2
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x55
	MOVF R0H,W
	MOVWF 0x56
; 728: 
; 729: 	Read mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3D
; 730: 	If max_pos > 48 Then
	MOVF 0x3D,W
	SUBLW 0x30
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0244
; 731: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x3D
; 732: 	Endif
L0244:
; 733: 	Read mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 734: 	If act_pos > max_pos Then
	MOVF 0x31,W
	SUBWF 0x3D,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0245
; 735: 		act_pos = 1
	MOVLW 0x01
	MOVWF 0x31
; 736: 	Endif
L0245:
; 737: 	Read mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 738: 	If free_space_steps > 99 Then
	MOVF 0x3F,W
	SUBLW 0x63
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0246
; 739: 		free_space_steps = 20
	MOVLW 0x14
	MOVWF 0x3F
; 740: 	Endif
L0246:
; 741: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 742: 	If ctrl_type > 6 Then
	MOVF 0x36,W
	SUBLW 0x06
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0247
; 743: 		ctrl_type = 6
	MOVLW 0x06
	MOVWF 0x36
; 744: 	Endif
L0247:
; 745: 
; 746: 	Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x43
; 747: 	If turn_counter > 131 Then  'in program impossible value
	MOVF 0x43,W
	SUBLW 0x83
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0248
; 748: 		turn_counter = 128
	MOVLW 0x80
	MOVWF 0x43
; 749: 	Else
	BSF PCLATH,3
	GOTO L0249
L0248:
; 750: 		If turn_counter < 125 Then  'in program impossible value
	MOVLW 0x7D
	SUBWF 0x43,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0250
; 751: 			turn_counter = 128
	MOVLW 0x80
	MOVWF 0x43
; 752: 		Endif
L0250:
; 753: 	Endif
L0249:
; 754: 	
; 755: 	Read mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x46
; 756: 	If speed_step > 99 Then
	MOVF 0x46,W
	SUBLW 0x63
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0251
; 757: 		speed_step = 50
	MOVLW 0x32
	MOVWF 0x46
; 758: 	Endif
L0251:
; 759: 	
; 760: 	If eep = 1 Then  'jumper set for initialisation
	BSF PCLATH,3
	BTFSS 0x06,6
	GOTO L0252
; 761: 		Gosub init_eeprom
	BSF PCLATH,3
	CALL L0012
; 762: 	Endif
L0252:
; 763: 
; 764: 	new_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x50
; 765: 	bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x49
; 766: 	old_bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x57
; 767: 	manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x44
; 768: 	old_manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x52
; 769: Return
	RETURN
; End of program
	BSF PCLATH,3
L0253:	GOTO L0253
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
