; Compiled with: PIC Simulator IDE v6.91
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_turn_counter' (global) is 101
;       The value of 'mem_act_pos' (global) is 102
;       The value of 'mem_speed_min' (global) is 103
;       The value of 'mem_speed_max' (global) is 104
;       The value of 'mem_speed_step' (global) is 105
;       The value of 'mem_one_round_lb' (global) is 106
;       The value of 'mem_one_round_hb' (global) is 107
;       The value of 'mem_ctrl_type' (global) is 108
;       The value of 'mem_max_pos' (global) is 109
;       The value of 'mem_free_space' (global) is 110
;       The value of 'mem_bridge_power' (global) is 112
;       The value of 'mem_bridge_switch1' (global) is 113
;       The value of 'mem_bridge_switch2' (global) is 114
;       The value of 'mem_bridge_switch3' (global) is 115
;       The value of 'mem_bridge_switch4' (global) is 116
;       The value of 'mem_bridge_switch5' (global) is 117
;       The value of 'mem_bridge_switch6' (global) is 118
;       The address of 'value' (byte) (global) is 0x30
	value EQU 0x30
;       The address of 'act_pos' (byte) (global) is 0x31
	act_pos EQU 0x31
;       The address of 'ctrl_type' (byte) (global) is 0x32
	ctrl_type EQU 0x32
;       The address of 'steps' (word) (global) is 0x33
	steps EQU 0x33
;       The address of 'max_pos' (byte) (global) is 0x35
	max_pos EQU 0x35
;       The address of 'new_steps' (word) (global) is 0x36
	new_steps EQU 0x36
;       The address of 'speed_max' (word) (global) is 0x38
	speed_max EQU 0x38
;       The address of 'speed_min' (word) (global) is 0x3A
	speed_min EQU 0x3A
;       The address of 'result' (byte) (global) is 0x3C
	result EQU 0x3C
;       The address of 'bridge_switch' (bit) (global) is 0x3D,0
;       The address of 'one_round' (word) (global) is 0x3E
	one_round EQU 0x3E
;       The address of 'manual_pos' (byte) (global) is 0x40
	manual_pos EQU 0x40
;       The address of 'turn_counter' (byte) (global) is 0x41
	turn_counter EQU 0x41
;       The address of 'value2' (byte) (global) is 0x42
	value2 EQU 0x42
;       The address of 'program_set' (byte) (global) is 0x43
	program_set EQU 0x43
;       The address of 'free_space_steps' (byte) (global) is 0x44
	free_space_steps EQU 0x44
;       The address of 'speed_step' (byte) (global) is 0x45
	speed_step EQU 0x45
;       The address of 'act_steps' (word) (global) is 0x46
	act_steps EQU 0x46
;       The address of 'steps_set' (bit) (global) is 0x3D,1
;       The address of 'new_pos' (byte) (global) is 0x48
	new_pos EQU 0x48
;       The address of 'disp1_val' (byte) (global) is 0x49
	disp1_val EQU 0x49
;       The address of 'new_encoder' (byte) (global) is 0x4A
	new_encoder EQU 0x4A
;       The address of 'encoder_count' (byte) (global) is 0x4B
	encoder_count EQU 0x4B
;       The address of 'bus_pos' (byte) (global) is 0x4C
	bus_pos EQU 0x4C
;       The address of 'speed' (word) (global) is 0x4D
	speed EQU 0x4D
;       The address of 'onoff' (bit) (global) is 0x3D,2
;       The address of 'disp2_val' (byte) (global) is 0x4F
	disp2_val EQU 0x4F
;       The address of 'eprom_pointer' (byte) (global) is 0x50
	eprom_pointer EQU 0x50
;       The address of 'bridge_power' (bit) (global) is 0x3D,3
;       The address of 'old_encoder' (byte) (global) is 0x51
	old_encoder EQU 0x51
;       The address of 'old_manual_pos' (byte) (global) is 0x52
	old_manual_pos EQU 0x52
;       The address of 'ramp_up' (bit) (global) is 0x3D,4
;       The address of 'version' (bit) (global) is 0x3D,5
;       The address of 'ramp_down_point' (word) (global) is 0x53
	ramp_down_point EQU 0x53
;       The address of 'one_round_half' (word) (global) is 0x55
	one_round_half EQU 0x55
;       The address of 'old_bus_pos' (byte) (global) is 0x57
	old_bus_pos EQU 0x57
;       The address of 'old_pos_write' (bit) (global) is 0x3D,6
;       The address of 'free_space_word' (word) (global) is 0x58
	free_space_word EQU 0x58
;       The address of 'half_steps' (word) (global) is 0x5A
	half_steps EQU 0x5A
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'eep' (bit) (global) is 0x6,6
;       The address of 'max_end' (bit) (global) is 0x6,7
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x7,3
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
;       The address of 'fy_stop' (bit) (global) is 0x5,5
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,3
	GOTO L0017
	ORG 0x0004
	RETFIE
; LookUp Table: (3, 2, 1, 3)
_lookup_lab_0001:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
; LookUp Table: (1, 3, 3, 2)
_lookup_lab_0002:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
; LookUp Table: (2, 3, 3, 1)
_lookup_lab_0003:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
; LookUp Table: (3, 1, 2, 3)
_lookup_lab_0004:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0005:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; LookUp Table: (%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111)
_lookup_lab_0006:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0007:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Byte
X001:	MOVLW 0x02
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
X002:	MOVLW 0x02
	SUBWF R4L,F
	NOP
	NOP
	NOP
	NOP
	BTFSS STATUS,C
	RETURN
	GOTO X002
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0017:
; 1: 'program TT for PCBoard MGV145
; 2: 'version V3-1  Fiddle Yard version, for turntables and fiddle yard
; 3: 'this version has all possibilities changeable by menue's.
; 4: 'V3-2 counter for twisting cables tored at eeprom pos zero.
; 5: 'the value of the counter can be anything between 125 and 131. 128 is zero point.
; 6: 'V3-3 eeprom startup improved. Reprogramming PIC can now be done without reprogramming data
; 7: 'V3.6 startup delayed, to avoid wrong positions
; 8: 'V3.7 extra separate positions for FY and TT with contact sliders.
; 9: '-----MGV50 input changed, ramp-up and ramp-down activated, including separate settings for min and max speed
; 10: 'V4.1 inital setting for FY, set pos 1 and pos 2 correct, rest will be automatic.
; 11: 'V4.4 initial setting freespace dafaults to 0.
; 12: '-    positions 0 and 63 are allowed from I/O input >>>> 63 will be seen as 0
; 13: '-    manual position setting can be turned through zero
; 14: 'V4.5 extra menu 8 for setting the first position where rail power should be reversed
; 15: 'V4.6 0 point will also control cable twist
; 16: 'V4.7 Fiddle yard (ctrl type 6) has only 5 selection lines.(max 30 positions , 31 = zero adjust)
; 17: '-    pos.req 6 is set as input, MGV50 should be set as block output
; 18: '-    the two connection rails in and out are connected to current detection
; 19: '-    any train on these tracks will give siganl,where FY will stop immediately (same as endswitch)
; 20: 'V4.8 Extra menu added for settings of reverse/not per position (only for 0,2,4 )
; 21: '-    These bits (bridge_switch) are stored and read in 6 bytes
; 22: 'V4.9 Free_space_steps multiplied by 10 , 990 correction steps available
; 23: '-    Positions are changed to 0-47
; 24: '-    Maximum positons can be as low as two
; 25: 'V5.0 Correction for init eprom routine position change to 0-47
; 26: '-    Free_space_steps multiplier changed to 4
; 27: '-    Added position 62 for recalibration, turn in direction 0 until 0 detector reached and set position to 0
; 28: '-    Added menu option 9 to operate the stepper motor without changing the stored steps
; 29: 'V5.1 Correction for bug that when a position is at 0 steps (perfectly aligned zero detector)
; 30: '-    the "determine one round" routine is called when selecting that position
; 31: Define CONF_WORD = 0x3f72
; 32: Define CLOCK_FREQUENCY = 20
; 33: 'Define SIMULATION_WAITuS_VALUE = 1
; 34: Dim steps As Word
; 35: Dim half_steps As Word
; 36: Dim ramp_down_point As Word
; 37: Dim program_set As Byte
; 38: Dim new_steps As Word
; 39: Dim act_steps As Word
; 40: Dim new_pos As Byte
; 41: Dim act_pos As Byte
; 42: Dim one_round As Word
; 43: Dim one_round_half As Word
; 44: Dim bus_pos As Byte
; 45: Dim old_bus_pos As Byte
; 46: Dim speed As Word
; 47: Dim speed_min As Word
; 48: Dim speed_max As Word
; 49: Dim new_encoder As Byte
; 50: Dim old_encoder As Byte
; 51: Dim manual_pos As Byte
; 52: Dim old_manual_pos As Byte
; 53: Dim result As Byte
; 54: Dim free_space_steps As Byte
; 55: Dim free_space_word As Word
; 56: Dim value As Byte
; 57: Dim value2 As Byte
; 58: Dim eprom_pointer As Byte
; 59: Dim encoder_count As Byte
; 60: Dim turn_counter As Byte
; 61: Dim onoff As Bit
; 62: Dim max_pos As Byte
; 63: Dim disp1_val As Byte
; 64: Dim disp2_val As Byte
; 65: Dim ctrl_type As Byte
; 66: Dim old_pos_write As Bit
; 67: Dim ramp_up As Bit
; 68: Dim speed_step As Byte
; 69: Dim version As Bit
; 70: Dim steps_set As Bit
; 71: Dim bridge_power As Bit
; 72: Dim bridge_switch As Bit
; 73: Const disp1 = 64
; 74: Const disp2 = 66
; 75: Const mem_turn_counter = 101
; 76: Const mem_act_pos = 102
; 77: Const mem_speed_min = 103
; 78: Const mem_speed_max = 104
; 79: Const mem_speed_step = 105
; 80: Const mem_one_round_lb = 106
; 81: Const mem_one_round_hb = 107
; 82: Const mem_ctrl_type = 108
; 83: Const mem_max_pos = 109
; 84: Const mem_free_space = 110
; 85: 
; 86: Const mem_bridge_power = 112
; 87: Const mem_bridge_switch1 = 113
; 88: Const mem_bridge_switch2 = 114
; 89: Const mem_bridge_switch3 = 115
; 90: Const mem_bridge_switch4 = 116
; 91: Const mem_bridge_switch5 = 117
; 92: Const mem_bridge_switch6 = 118
; 93: Symbol swfw = RB0
; 94: Symbol swrev = RB1
; 95: Symbol sck = RB2
; 96: Symbol sda = RB3
; 97: Symbol pos_match = RB4
; 98: Symbol pos_write = RB5
; 99: Symbol eep = RB6
; 100: Symbol max_end = RB7
; 101: Symbol direction = RC0
; 102: Symbol clk = RC1
; 103: Symbol ena = RC2
; 104: Symbol zero = RC3
; 105: Symbol ec1 = RC4
; 106: Symbol ec2 = RC5
; 107: Symbol ecsw = RC6
; 108: Symbol pgm = RC7
; 109: Symbol fy_stop = RA5
; 110: ADCON1 = %0110
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 111: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 112: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 113: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 114: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 115: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 116: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 117: value = 51  'version number
	MOVLW 0x33
	MOVWF 0x30
; 118: Gosub init_values
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 119: value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 120: version = 1
	BSF 0x3D,5
; 121: Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 122: onoff = 1
	BSF 0x3D,2
; 123: Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 124: program_set = 1
	MOVLW 0x01
	MOVWF 0x43
; 125: main:
L0001:
; 126: 	If pgm = 0 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0018
; 127: 		Gosub adjust_settings
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0004
; 128: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 129: 	Endif
L0018:
; 130: 
; 131: 	Gosub get_new_position
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0002
; 132: 	If bus_pos <> old_bus_pos Then
	MOVF 0x4C,W
	SUBWF 0x57,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0019
; 133: 		onoff = 0
	BCF 0x3D,2
; 134: 		Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 135: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 136: 		new_pos = bus_pos
	MOVF 0x4C,W
	MOVWF 0x48
; 137: 		Gosub stepmotor
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0007
; 138: 		value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 139: 		Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 140: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 141: 		onoff = 1
	BSF 0x3D,2
; 142: 	Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0020
L0019:
; 143: 		If ecsw = 0 Then  'only when knob is pushed
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0021
; 144: 			If manual_pos <> old_manual_pos Then
	MOVF 0x40,W
	SUBWF 0x52,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0022
; 145: 				onoff = 0
	BCF 0x3D,2
; 146: 				Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 147: 				pos_match = 1  'indicate not in position
	BSF 0x06,4
; 148: 				old_manual_pos = manual_pos
	MOVF 0x40,W
	MOVWF 0x52
; 149: 				new_pos = manual_pos
	MOVF 0x40,W
	MOVWF 0x48
; 150: 				Gosub stepmotor
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0007
; 151: 				value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 152: 				Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 153: 				pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 154: 				onoff = 1
	BSF 0x3D,2
; 155: 			Endif
L0022:
; 156: 		Endif
L0021:
; 157: 	Endif
L0020:
; 158: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 159: 	Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 160: 	Goto main
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0001
; 161: End
;       PAGE SELECT
;	BCF PCLATH,3
L0023:	GOTO L0023
; 162: 
; 163: 
; 164: get_new_position:
L0002:
; 165: 	value = bus_pos  'remember the position
	MOVF 0x4C,W
	MOVWF 0x30
; 166: 	If pos_write = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x06,5
	GOTO L0024
; 167: 		If old_pos_write = 0 Then  'react only once on rising edge
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x3D,6
	GOTO L0025
; 168: 			old_pos_write = 1
	BSF 0x3D,6
; 169: 			value = PORTA And 63  'now get value from J5
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x30
; 170: 			If ctrl_type = 6 Then  'fiddle yard max = 30
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0026
; 171: 				value = value And 31
	MOVF 0x30,W
	MOVWF R0L
	MOVLW 0x1F
	ANDWF R0L,W
	MOVWF 0x30
; 172: 				If value = 31 Then  '31 is for zero adjust, maybe only 5 bits are available
	MOVF 0x30,W
	SUBLW 0x1F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0027
; 173: 					value = 63
	MOVLW 0x3F
	MOVWF 0x30
; 174: 				Endif
L0027:
; 175: 			Endif
L0026:
; 176: 			Select Case value
; 177: 			Case 63  'make zero adjust
	MOVF 0x30,W
	SUBLW 0x3F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0028
; 178: 				value = 0
	CLRF 0x30
; 179: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0029
L0028:
; 180: 				If value > max_pos Then  'this is not allowed
	MOVF 0x30,W
	SUBWF 0x35,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0030
; 181: 					value = bus_pos  'put it back to old situation
	MOVF 0x4C,W
	MOVWF 0x30
; 182: 				Endif
L0030:
; 183: 			EndSelect
L0029:
; 184: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 185: 			If value = bus_pos Then  'no other position is set, just a response on pos_write is required
	MOVF 0x30,W
	SUBWF 0x4C,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0031
; 186: 				pos_match = 1
	BSF 0x06,4
; 187: 				WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 188: 				pos_match = 0
	BCF 0x06,4
; 189: 			Endif
L0031:
; 190: 		Endif
L0025:
; 191: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0032
L0024:
; 192: 		old_pos_write = 0
	BCF 0x3D,6
; 193: 	Endif
L0032:
; 194: 	bus_pos = value  'now take over the desired position
	MOVF 0x30,W
	MOVWF 0x4C
; 195: 	Gosub calc_rotation
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0003
; 196: 	Select Case result
; 197: 	Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0033
; 198: 		If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x4B,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0034
; 199: 			encoder_count = encoder_count + 1
	MOVF 0x4B,W
	ADDLW 0x01
	MOVWF 0x4B
; 200: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0035
L0034:
; 201: 			encoder_count = 0
	CLRF 0x4B
; 202: 			Select Case manual_pos
; 203: 			Case 63
	MOVF 0x40,W
	SUBLW 0x3F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0036
; 204: 				manual_pos = 0
	CLRF 0x40
; 205: 			Case 62
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0037
L0036:
	MOVF 0x40,W
	SUBLW 0x3E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0038
; 206: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x40
; 207: 			Case max_pos
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0039
L0038:
	MOVF 0x40,W
	SUBWF 0x35,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0040
; 208: 				manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x40
; 209: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0041
L0040:
; 210: 				manual_pos = manual_pos + 1
	MOVF 0x40,W
	ADDLW 0x01
	MOVWF 0x40
; 211: 			EndSelect
L0041:
L0039:
L0037:
; 212: 			value = manual_pos
	MOVF 0x40,W
	MOVWF 0x30
; 213: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 214: 		Endif
L0035:
; 215: 	Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0042
L0033:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0043
; 216: 		If encoder_count > 0 Then
	MOVF 0x4B,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0044
; 217: 			encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x4B,W
	MOVWF 0x4B
; 218: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0045
L0044:
; 219: 			encoder_count = 4
	MOVLW 0x04
	MOVWF 0x4B
; 220: 			Select Case manual_pos
; 221: 			Case 63
	MOVF 0x40,W
	SUBLW 0x3F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0046
; 222: 				manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x40
; 223: 			Case 62
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0047
L0046:
	MOVF 0x40,W
	SUBLW 0x3E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0048
; 224: 				manual_pos = max_pos
	MOVF 0x35,W
	MOVWF 0x40
; 225: 			Case 0
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0049
L0048:
	MOVF 0x40,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0050
; 226: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x40
; 227: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0051
L0050:
; 228: 				manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x40,W
	MOVWF 0x40
; 229: 			EndSelect
L0051:
L0049:
L0047:
; 230: 			value = manual_pos
	MOVF 0x40,W
	MOVWF 0x30
; 231: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 232: 		Endif
L0045:
; 233: 	Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0052
L0043:
; 234: 	EndSelect
L0052:
L0042:
; 235: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 236: 	
; 237: Return
	RETURN
; 238: 
; 239: calc_rotation:  'this routine checks the incrimental switch
L0003:
; 240: '1 = increasing value
; 241: '2 = decreasing value
; 242: '3 = no change
; 243: 		new_encoder = 0
	CLRF 0x4A
; 244: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x4A,0
	BTFSS 0x07,4
	BCF 0x4A,0
; 245: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x4A,1
	BTFSS 0x07,5
	BCF 0x4A,1
; 246: 		Select Case old_encoder
; 247: 		Case 0
	MOVF 0x51,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0053
; 248: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x4A,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0054
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0001
	MOVWF 0x3C
L0054:
; 249: 		Case 1
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0055
L0053:
	MOVF 0x51,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0056
; 250: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x4A,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0057
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0002
	MOVWF 0x3C
L0057:
; 251: 		Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0058
L0056:
	MOVF 0x51,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0059
; 252: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x4A,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0060
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0003
	MOVWF 0x3C
L0060:
; 253: 		Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0061
L0059:
; 254: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x4A,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0062
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0004
	MOVWF 0x3C
L0062:
; 255: 		EndSelect
L0061:
L0058:
L0055:
; 256: 		old_encoder = new_encoder
	MOVF 0x4A,W
	MOVWF 0x51
; 257: Return
	RETURN
; 258: 
; 259: 
; 260: adjust_settings:
L0004:
; 261: 	Gosub i2c_display_pgm
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0006
; 262: 	WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 263: 	onoff = 0
	BCF 0x3D,2
; 264: 	Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 265: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 266: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x46,W
	MOVWF 0x36
	MOVF 0x47,W
	MOVWF 0x37
; 267: 	While pgm = 0  'the program switch is still activated
L0063:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0064
; 268: 		If ecsw = 0 Then  'knob is pressed, inrease program_set
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0065
; 269: 			program_set = program_set + 1
	MOVF 0x43,W
	ADDLW 0x01
	MOVWF 0x43
; 270: 			If program_set > 9 Then  'no more than 9 items te change
	MOVF 0x43,W
	SUBLW 0x09
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0066
; 271: 				program_set = 0
	CLRF 0x43
; 272: 			Endif
L0066:
; 273: 			Gosub i2c_display_pgm
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0006
; 274: 			WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 275: 			While ecsw = 0  'be sure pushbutton is released
L0067:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0068
; 276: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 277: 			Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0067
L0068:
; 278: 		Endif
L0065:
; 279: 		Select Case program_set
; 280: 		Case 0  'correction of current position
	MOVF 0x43,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0069
; 281: 			value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 282: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 283: 			Gosub calc_rotation  'look for the knob to be turned
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 284: 			Select Case result
; 285: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0070
; 286: 				If new_steps < 60000 Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0071
; 287: 					ena = 1  'motor on
	BSF 0x07,2
; 288: 					new_steps = new_steps + 1
	MOVF 0x36,W
	ADDLW 0x01
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x37
; 289: 					direction = 1
	BSF 0x07,0
; 290: 					clk = 1  'clock out
	BSF 0x07,1
; 291: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 292: 					clk = 0
	BCF 0x07,1
; 293: 				Endif
L0071:
; 294: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0072
L0070:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0073
; 295: 				If new_steps > 0 Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0074
; 296: 					ena = 1  'motor on
	BSF 0x07,2
; 297: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x36,W
	MOVWF 0x36
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x37
; 298: 					direction = 0
	BCF 0x07,0
; 299: 					clk = 1  'clock out
	BSF 0x07,1
; 300: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 301: 					clk = 0
	BCF 0x07,1
; 302: 				Endif
L0074:
; 303: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0075
L0073:
; 304: 			EndSelect
L0075:
L0072:
; 305: 			Select Case act_pos
; 306: 			Case 1
	MOVF 0x31,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0076
; 307: 				steps_set = 1
	BSF 0x3D,1
; 308: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0077
L0076:
	MOVF 0x31,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0078
; 309: 				If steps_set = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x3D,1
	GOTO L0079
; 310: 					If eep = 1 Then  'iF jumper eep1 is set to on
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0080
; 311: 											'routine to set steps for pos 3 to max_pos
; 312: 						value = 63
	MOVLW 0x3F
	MOVWF 0x30
; 313: 						Gosub i2c_display  'show 63 to indicate adjusting is proceeded
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 314: 						If act_steps <> new_steps Then
	MOVF 0x46,W
	MOVWF R0L
	MOVF 0x47,W
	MOVWF R0H
	MOVF 0x36,W
	MOVWF R1L
	MOVF 0x37,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C002
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0081
; 315: 							Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 316: 						Endif
L0081:
; 317: 						act_pos = 1
	MOVLW 0x01
	MOVWF 0x31
; 318: 						new_pos = 2
	MOVLW 0x02
	MOVWF 0x48
; 319: 						Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 320: 						steps = new_steps - act_steps  'calculate difference between one and two
	MOVF 0x46,W
	SUBWF 0x36,W
	MOVWF 0x33
	MOVF 0x47,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x34
; 321: 						For act_pos = 3 To max_pos
	MOVLW 0x03
	MOVWF 0x31
L0082:
	MOVF 0x31,W
	SUBWF 0x35,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0083
; 322: 							new_steps = new_steps + steps
	MOVF 0x36,W
	ADDWF 0x33,W
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x34,W
	MOVWF 0x37
; 323: 							Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 324: 						Next act_pos
	MOVLW 0x01
	ADDWF 0x31,F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0082
L0083:
; 325: 						WaitMs 2000  'give some timne to read display
	MOVLW 0xD0
	MOVWF R0L
	MOVLW 0x07
	MOVWF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 326: 						act_pos = 2  'we were at this position
	MOVLW 0x02
	MOVWF 0x31
; 327: 						steps_set = 0  'do this routine only once
	BCF 0x3D,1
; 328: 					Endif
L0080:
; 329: 				Endif
L0079:
; 330: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0084
L0078:
; 331: 				steps_set = 0
	BCF 0x3D,1
; 332: 			EndSelect  'act_pos
L0084:
L0077:
; 333: 		Case 1  'setting of inverse / not inverse bridge rail power
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0085
L0069:
	MOVF 0x43,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0086
; 334: 			Gosub read_bridge_switch
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 335: 			value = 0
	CLRF 0x30
; 336: 			value.0 = bridge_switch
	BTFSC 0x3D,0
	BSF 0x30,0
	BTFSS 0x3D,0
	BCF 0x30,0
; 337: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 338: 			Gosub calc_rotation  'look for the knob to be turned
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 339: 			Select Case result
; 340: 			Case 1, 2
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0089
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0088
L0089:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0087
L0088:
; 341: 				bridge_switch = Not bridge_switch
	MOVLW 0x01
	XORWF 0x3D,F
; 342: 				Gosub store_bridge_switch
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 343: 				swfw = 0  'first both relays off
	BCF 0x06,0
; 344: 				swrev = 0
	BCF 0x06,1
; 345: 				WaitMs 20
	MOVLW 0x14
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 346: 				swfw = bridge_switch
	BTFSC 0x3D,0
	BSF 0x06,0
	BTFSS 0x3D,0
	BCF 0x06,0
; 347: 				swrev = Not bridge_switch
	BTFSS 0x3D,0
	BSF 0x06,1
	BTFSC 0x3D,0
	BCF 0x06,1
; 348: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0090
L0087:
; 349: 			EndSelect
L0090:
; 350: 		Case 2  'setting of maximum positions
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0091
L0086:
	MOVF 0x43,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0092
; 351: 			steps_set = 0
	BCF 0x3D,1
; 352: 			ena = 0  'shut off motor
	BCF 0x07,2
; 353: 			value = max_pos
	MOVF 0x35,W
	MOVWF 0x30
; 354: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 355: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 356: 			Select Case result
; 357: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0093
; 358: 				max_pos = max_pos + 1
	MOVF 0x35,W
	ADDLW 0x01
	MOVWF 0x35
; 359: 				Select Case ctrl_type
; 360: 				Case 6
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0094
; 361: 					If max_pos > 30 Then  'no more positions possible
	MOVF 0x35,W
	SUBLW 0x1E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0095
; 362: 						max_pos = 1
	MOVLW 0x01
	MOVWF 0x35
; 363: 					Endif
L0095:
; 364: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0096:	BTFSC EECON1,WR
	GOTO L0096
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 365: 				Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0097
L0094:
; 366: 					If max_pos > 47 Then  'no more positions possible
	MOVF 0x35,W
	SUBLW 0x2F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0098
; 367: 						max_pos = 1
	MOVLW 0x01
	MOVWF 0x35
; 368: 					Endif
L0098:
; 369: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0099:	BTFSC EECON1,WR
	GOTO L0099
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 370: 				EndSelect
L0097:
; 371: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0100
L0093:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0101
; 372: 				max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x35,W
	MOVWF 0x35
; 373: 				If max_pos < 1 Then  'mininum 2 positions
	MOVLW 0x01
	SUBWF 0x35,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0102
; 374: 					Select Case ctrl_type
; 375: 					Case 6
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0103
; 376: 						max_pos = 30
	MOVLW 0x1E
	MOVWF 0x35
; 377: 					Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0104
L0103:
; 378: 						max_pos = 47
	MOVLW 0x2F
	MOVWF 0x35
; 379: 					EndSelect
L0104:
; 380: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0105:	BTFSC EECON1,WR
	GOTO L0105
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 381: 				Endif
L0102:
; 382: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0106
L0101:
; 383: 			EndSelect
L0106:
L0100:
; 384: 		Case 3  'setting control type
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0107
L0092:
	MOVF 0x43,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0108
; 385: 			steps_set = 0
	BCF 0x3D,1
; 386: 			ena = 0  'shut off motor
	BCF 0x07,2
; 387: 			If ctrl_type > 6 Then
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0109
; 388: 				ctrl_type = 0
	CLRF 0x32
; 389: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0110:	BTFSC EECON1,WR
	GOTO L0110
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 390: 			Endif
L0109:
; 391: 			value = ctrl_type
	MOVF 0x32,W
	MOVWF 0x30
; 392: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 393: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 394: 			Select Case result
; 395: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0111
; 396: 				ctrl_type = ctrl_type + 1
	MOVF 0x32,W
	ADDLW 0x01
	MOVWF 0x32
; 397: 				If ctrl_type = 7 Then
	MOVF 0x32,W
	SUBLW 0x07
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0112
; 398: 					ctrl_type = 0
	CLRF 0x32
; 399: 				Endif
L0112:
; 400: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0113:	BTFSC EECON1,WR
	GOTO L0113
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 401: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0114
L0111:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0115
; 402: 				ctrl_type = ctrl_type - 1
	MOVLW 0x01
	SUBWF 0x32,W
	MOVWF 0x32
; 403: 				If ctrl_type = 255 Then
	MOVF 0x32,W
	SUBLW 0xFF
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0116
; 404: 					ctrl_type = 6
	MOVLW 0x06
	MOVWF 0x32
; 405: 				Endif
L0116:
; 406: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0117:	BTFSC EECON1,WR
	GOTO L0117
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 407: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0118
L0115:
; 408: 			EndSelect
L0118:
L0114:
; 409: 		Case 4  'setting of speed interval Minimum
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0119
L0108:
	MOVF 0x43,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0120
; 410: 					'setting will be done in multiple of 256 uSecs
; 411: 					'minimum is 2 and maximum is 99 (is real slow)
; 412: 			steps_set = 0
	BCF 0x3D,1
; 413: 			ena = 0  'shut off motor
	BCF 0x07,2
; 414: 			value = speed_min.HB
	MOVF 0x3B,W
	MOVWF 0x30
; 415: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 416: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 417: 			Select Case result
; 418: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0121
; 419: 				If speed_min.HB < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x3B,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0122
; 420: 					speed_min = speed_min + 256
	MOVF 0x3A,W
	ADDLW 0x00
	MOVWF 0x3A
	MOVF 0x3B,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x01
	MOVWF 0x3B
; 421: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0123:	BTFSC EECON1,WR
	GOTO L0123
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 422: 				Endif
L0122:
; 423: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0124
L0121:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0125
; 424: 				If speed_min > speed_max Then
	MOVF 0x3A,W
	MOVWF R0L
	MOVF 0x3B,W
	MOVWF R0H
	MOVF 0x38,W
	MOVWF R1L
	MOVF 0x39,W
	MOVWF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0126
; 425: 					speed_min = speed_min - 256
	MOVLW 0x00
	SUBWF 0x3A,W
	MOVWF 0x3A
	MOVLW 0x01
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x3B
; 426: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0127:	BTFSC EECON1,WR
	GOTO L0127
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 427: 				Endif
L0126:
; 428: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0128
L0125:
; 429: 			EndSelect
L0128:
L0124:
; 430: 		Case 5  'setting of speed interval Maximum
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0129
L0120:
	MOVF 0x43,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0130
; 431: 					'setting will be done in multiple of 256 uSecs
; 432: 					'minimum is 1 and maximum is 99 (is real slow)
; 433: 			steps_set = 0
	BCF 0x3D,1
; 434: 			ena = 0  'shut off motor
	BCF 0x07,2
; 435: 			value = speed_max.HB
	MOVF 0x39,W
	MOVWF 0x30
; 436: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 437: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 438: 			Select Case result
; 439: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0131
; 440: 				If speed_max.HB < speed_min.HB Then  'not more then speed_min
	MOVF 0x3B,W
	SUBWF 0x39,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0132
; 441: 					speed_max.HB = speed_max.HB + 1
	MOVF 0x39,W
	ADDLW 0x01
	MOVWF 0x39
; 442: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0133:	BTFSC EECON1,WR
	GOTO L0133
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 443: 				Endif
L0132:
; 444: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0134
L0131:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0135
; 445: 				If speed_max.HB > 1 Then
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0136
; 446: 					speed_max.HB = speed_max.HB - 1
	MOVLW 0x01
	SUBWF 0x39,W
	MOVWF 0x39
; 447: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0137:	BTFSC EECON1,WR
	GOTO L0137
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 448: 				Endif
L0136:
; 449: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0138
L0135:
; 450: 			EndSelect
L0138:
L0134:
; 451: 		Case 6  'setting of ramp up and down speed
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0139
L0130:
	MOVF 0x43,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0140
; 452: 					'speed will be the value that speed will be changed every step up and down
; 453: 			steps_set = 0
	BCF 0x3D,1
; 454: 			ena = 0  'shut off motor
	BCF 0x07,2
; 455: 			value = speed_step
	MOVF 0x45,W
	MOVWF 0x30
; 456: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 457: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 458: 			Select Case result
; 459: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0141
; 460: 				If speed_step < 99 Then  'maximum 99 is possible
	MOVLW 0x63
	SUBWF 0x45,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0142
; 461: 					speed_step = speed_step + 1
	MOVF 0x45,W
	ADDLW 0x01
	MOVWF 0x45
; 462: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x45,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0143:	BTFSC EECON1,WR
	GOTO L0143
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 463: 				Endif
L0142:
; 464: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0144
L0141:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0145
; 465: 				If speed_step > 1 Then
	MOVF 0x45,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0146
; 466: 					speed_step = speed_step - 1
	MOVLW 0x01
	SUBWF 0x45,W
	MOVWF 0x45
; 467: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x45,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0147:	BTFSC EECON1,WR
	GOTO L0147
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 468: 				Endif
L0146:
; 469: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0148
L0145:
; 470: 			EndSelect
L0148:
L0144:
; 471: 	
; 472: 		Case 7  'setting of extra free space steps
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0149
L0140:
	MOVF 0x43,W
	SUBLW 0x07
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0150
; 473: 			steps_set = 0
	BCF 0x3D,1
; 474: 			ena = 0  'shut off motor
	BCF 0x07,2
; 475: 			If free_space_steps > 99 Then
	MOVF 0x44,W
	SUBLW 0x63
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0151
; 476: 				free_space_steps = 99
	MOVLW 0x63
	MOVWF 0x44
; 477: 				Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0152:	BTFSC EECON1,WR
	GOTO L0152
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 478: 			Endif
L0151:
; 479: 			value = free_space_steps
	MOVF 0x44,W
	MOVWF 0x30
; 480: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 481: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 482: 			Select Case result
; 483: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0153
; 484: 				If free_space_steps < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x44,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0154
; 485: 					free_space_steps = free_space_steps + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
; 486: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0155:	BTFSC EECON1,WR
	GOTO L0155
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 487: 				Endif
L0154:
; 488: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0156
L0153:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0157
; 489: 				If free_space_steps > 0 Then
	MOVF 0x44,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0158
; 490: 					free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x44,W
	MOVWF 0x44
; 491: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0159:	BTFSC EECON1,WR
	GOTO L0159
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 492: 				Endif
L0158:
; 493: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0160
L0157:
; 494: 			EndSelect
L0160:
L0156:
; 495: 		Case 8  'setting if power should be on or off while bridge is moving (0 = off)
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0161
L0150:
	MOVF 0x43,W
	SUBLW 0x08
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0162
; 496: 			Read mem_bridge_power, value
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 497: 			If value > 1 Then
	MOVF 0x30,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0163
; 498: 				value = 1
	MOVLW 0x01
	MOVWF 0x30
; 499: 			Endif
L0163:
; 500: 			bridge_power = value.0
	BTFSC 0x30,0
	BSF 0x3D,3
	BTFSS 0x30,0
	BCF 0x3D,3
; 501: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 502: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 503: 			Select Case result
; 504: 			Case 1, 2
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0166
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0165
L0166:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0164
L0165:
; 505: 				bridge_power = Not bridge_power
	MOVLW 0x08
	XORWF 0x3D,F
; 506: 				value.0 = bridge_power
	BTFSC 0x3D,3
	BSF 0x30,0
	BTFSS 0x3D,3
	BCF 0x30,0
; 507: 				Write mem_bridge_power, value
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0167:	BTFSC EECON1,WR
	GOTO L0167
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 508: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0168
L0164:
; 509: 			EndSelect
L0168:
; 510: 		Case 9  'move but do not change stored steps
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0169
L0162:
	MOVF 0x43,W
	SUBLW 0x09
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0170
; 511: 			value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 512: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 513: 			Gosub calc_rotation  'look for the knob to be turned
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 514: 			Select Case result
; 515: 			Case 1
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0171
; 516: 					ena = 1  'motor on
	BSF 0x07,2
; 517: 					direction = 1
	BSF 0x07,0
; 518: 					clk = 1  'clock out
	BSF 0x07,1
; 519: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 520: 					clk = 0
	BCF 0x07,1
; 521: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0172
L0171:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0173
; 522: 					ena = 1  'motor on
	BSF 0x07,2
; 523: 					direction = 0
	BCF 0x07,0
; 524: 					clk = 1  'clock out
	BSF 0x07,1
; 525: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 526: 					clk = 0
	BCF 0x07,1
; 527: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0174
L0173:
; 528: 			EndSelect
L0174:
L0172:
; 529: 		EndSelect
L0170:
L0169:
L0161:
L0149:
L0139:
L0129:
L0119:
L0107:
L0091:
L0085:
; 530: 	Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0063
L0064:
; 531: 	ena = 0  'shut off motor
	BCF 0x07,2
; 532: 		'***************   now check if changes have to BE written in eeprom
; 533: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVF 0x46,W
	MOVWF R1L
	MOVF 0x47,W
	MOVWF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C002
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0175
; 534: 		Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 535: 	Endif
L0175:
; 536: 	value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 537: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 538: 	onoff = 1
	BSF 0x3D,2
; 539: 	Gosub relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 540: Return
	RETURN
; 541: 
; 542: i2c_display:
L0005:
; 543: 	disp1_val = value
	MOVF 0x30,W
	MOVWF 0x49
; 544: 	disp1_val = disp1_val Mod 10
	MOVF 0x49,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x49
; 545: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x49,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0176
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0005
	MOVWF 0x49
L0176:
; 546: 	disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x49,7
	BTFSS 0x07,7
	BCF 0x49,7
; 547: 	disp2_val = value
	MOVF 0x30,W
	MOVWF 0x4F
; 548: 	disp2_val = disp2_val / 10
	MOVF 0x4F,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4F
; 549: 	disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x4F,W
	MOVWF R0L
	SUBLW 0x0A
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0177
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0006
	MOVWF 0x4F
L0177:
; 550: 	disp2_val.7 = version
	BTFSC 0x3D,5
	BSF 0x4F,7
	BTFSS 0x3D,5
	BCF 0x4F,7
; 551: 	I2CStart
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC31
; 552: 	I2CSend disp1
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 553: 	I2CSend disp1_val
;       PAGE SELECT
;	BCF PCLATH,3
	MOVF 0x49,W
	CALL IC01
; 554: 	I2CStop
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
; 555: 	I2CStart
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC31
; 556: 	I2CSend disp2
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 557: 	I2CSend disp2_val
;       PAGE SELECT
;	BCF PCLATH,3
	MOVF 0x4F,W
	CALL IC01
; 558: 	I2CStop
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
; 559: Return
	RETURN
; 560: 
; 561: i2c_display_pgm:
L0006:
; 562: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), program_set
	MOVF 0x43,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0178
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0007
	MOVWF 0x49
L0178:
; 563: 	I2CStart
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC31
; 564: 	I2CSend disp1
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 565: 	I2CSend disp1_val
;       PAGE SELECT
;	BCF PCLATH,3
	MOVF 0x49,W
	CALL IC01
; 566: 	I2CStop
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
; 567: 	I2CStart
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC31
; 568: 	I2CSend disp2
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 569: 	I2CSend %10111111
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 570: 	I2CStop
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
; 571: Return
	RETURN
; 572: 
; 573: stepmotor:
L0007:
; 574: 	speed = 0
	CLRF 0x4D
	CLRF 0x4E
; 575: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 576: 	If new_steps = 65534 Then  'goto 0 detector position
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVLW 0xFE
	MOVWF R1L
	MOVLW 0xFF
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0179
; 577: 		direction = 0
	BCF 0x07,0
; 578: 		ena = 1  'set enable on
	BSF 0x07,2
; 579: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 580: 		While zero = 1  'turn motor until zero switch is activated
L0180:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0181
; 581: 			clk = 1  'clock out
	BSF 0x07,1
; 582: 			WaitUs speed_max
	MOVF 0x38,W
	MOVWF R4L
	MOVF 0x39,W
	MOVWF R4H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL Y001
; 583: 			clk = 0
	BCF 0x07,1
; 584: 			WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 585: 		Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0180
L0181:
; 586: 		ena = 0  'set enable off
	BCF 0x07,2
; 587: 		If act_steps = 0 Then
	MOVF 0x46,W
	MOVWF R0L
	MOVF 0x47,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0182
; 588: 			new_pos = 0
	CLRF 0x48
; 589: 		Else  'one_round count to be done
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0183
L0182:
; 590: 			act_steps = 0
	CLRF 0x46
	CLRF 0x47
; 591: 			value = 0  'first considerate that extra round is not allowed
	CLRF 0x30
; 592: 			Select Case ctrl_type
; 593: 			Case 2, 3  'check if extra round is allowed
	MOVF 0x32,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0186
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0185
L0186:
	MOVF 0x32,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0184
L0185:
; 594: 				Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 595: 				Select Case turn_counter
; 596: 				Case > 126  'check if shortest way is allowed
	MOVF 0x41,W
	SUBLW 0x7E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0187
; 597: 					turn_counter = turn_counter - 1  'yes it is, so substract one pass
	MOVLW 0x01
	SUBWF 0x41,W
	MOVWF 0x41
; 598: 					Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0188:	BTFSC EECON1,WR
	GOTO L0188
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 599: 					value = 1  'now it is allowed
	MOVLW 0x01
	MOVWF 0x30
; 600: 				Case < 126
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0189
L0187:
	MOVLW 0x7E
	SUBWF 0x41,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0190
; 601: 					Write mem_turn_counter, 126
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x7E
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0191:	BTFSC EECON1,WR
	GOTO L0191
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 602: 				Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0192
L0190:
; 603: 				EndSelect
L0192:
L0189:
; 604: 			Case 4, 5  'type with contact sliders, no twisting cables
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0193
L0184:
	MOVF 0x32,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0196
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0195
L0196:
	MOVF 0x32,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0194
L0195:
; 605: 				value = 1
	MOVLW 0x01
	MOVWF 0x30
; 606: 			Case Else  'no short way possible
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0197
L0194:
; 607: 			EndSelect
L0197:
L0193:
; 608: 			If value = 1 Then
	MOVF 0x30,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0198
; 609: 				one_round = 0  'start counting one round steps
	CLRF 0x3E
	CLRF 0x3F
; 610: 				ena = 1  'set enable on
	BSF 0x07,2
; 611: 				While zero = 0  'turn motor until zero switch is DISactivated
L0199:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0200
; 612: 					clk = 1  'clock out
	BSF 0x07,1
; 613: 					WaitUs speed_max
	MOVF 0x38,W
	MOVWF R4L
	MOVF 0x39,W
	MOVWF R4H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL Y001
; 614: 					clk = 0
	BCF 0x07,1
; 615: 					one_round = one_round + 1
	MOVF 0x3E,W
	ADDLW 0x01
	MOVWF 0x3E
	MOVF 0x3F,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3F
; 616: 					WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 617: 				Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0199
L0200:
; 618: 				For value = 1 To 100  'SOME MORE STEPS TO AVOID CONTACT DENDER.
	MOVLW 0x01
	MOVWF 0x30
L0201:
	MOVF 0x30,W
	SUBLW 0x64
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0202
; 619: 					clk = 1  'clock out
	BSF 0x07,1
; 620: 					WaitUs speed_max
	MOVF 0x38,W
	MOVWF R4L
	MOVF 0x39,W
	MOVWF R4H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL Y001
; 621: 					clk = 0
	BCF 0x07,1
; 622: 					WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 623: 					one_round = one_round + 1
	MOVF 0x3E,W
	ADDLW 0x01
	MOVWF 0x3E
	MOVF 0x3F,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3F
; 624: 				Next value
	MOVLW 0x01
	ADDWF 0x30,F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0201
L0202:
; 625: 				While zero = 1  'turn motor until zero switch is activated
L0203:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0204
; 626: 					clk = 1  'clock out
	BSF 0x07,1
; 627: 					WaitUs speed_max
	MOVF 0x38,W
	MOVWF R4L
	MOVF 0x39,W
	MOVWF R4H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL Y001
; 628: 					clk = 0
	BCF 0x07,1
; 629: 					WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 630: 					one_round = one_round + 1
	MOVF 0x3E,W
	ADDLW 0x01
	MOVWF 0x3E
	MOVF 0x3F,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x3F
; 631: 				Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0203
L0204:
; 632: 				one_round_half = one_round / 2
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x55
	MOVF R0H,W
	MOVWF 0x56
; 633: 				Write mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0205:	BTFSC EECON1,WR
	GOTO L0205
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 634: 				Write mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0206:	BTFSC EECON1,WR
	GOTO L0206
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 635: 				act_pos = 63
	MOVLW 0x3F
	MOVWF 0x31
; 636: 			Endif
L0198:
; 637: 			Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0207:	BTFSC EECON1,WR
	GOTO L0207
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 638: 			ena = 0  'set enable off
	BCF 0x07,2
; 639: 		Endif
L0183:
; 640: 	Else  'this is the normal position sequence
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0208
L0179:
; 641: 		steps = 0
	CLRF 0x33
	CLRF 0x34
; 642: 		If new_steps > act_steps Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVF 0x46,W
	MOVWF R1L
	MOVF 0x47,W
	MOVWF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0209
; 643: 			steps = new_steps - act_steps
	MOVF 0x46,W
	SUBWF 0x36,W
	MOVWF 0x33
	MOVF 0x47,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x34
; 644: 			direction = 1
	BSF 0x07,0
; 645: 			If steps > one_round_half Then  'is other direction shorter?
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x55,W
	MOVWF R1L
	MOVF 0x56,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0210
; 646: 				Select Case ctrl_type
; 647: 				Case 2, 3
	MOVF 0x32,W
	SUBLW 0x02
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0213
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0212
L0213:
	MOVF 0x32,W
	SUBLW 0x03
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0211
L0212:
; 648: 					Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 649: 					Select Case turn_counter
; 650: 					Case > 126  'check if shortest way is allowed
	MOVF 0x41,W
	SUBLW 0x7E
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0214
; 651: 						turn_counter = turn_counter - 1  'yes it is, so substract one pass
	MOVLW 0x01
	SUBWF 0x41,W
	MOVWF 0x41
; 652: 						steps = one_round - steps  'go shortest way
	MOVF 0x33,W
	SUBWF 0x3E,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x34
; 653: 						direction = 0  'change  direction
	BCF 0x07,0
; 654: 						Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0215:	BTFSC EECON1,WR
	GOTO L0215
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 655: 					Case < 126
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0216
L0214:
	MOVLW 0x7E
	SUBWF 0x41,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0217
; 656: 							Write mem_turn_counter, 126
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x7E
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0218:	BTFSC EECON1,WR
	GOTO L0218
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 657: 					Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0219
L0217:
; 658: 					EndSelect
L0219:
L0216:
; 659: 				Case 4, 5  'type with contact sliders, no twisting cables
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0220
L0211:
	MOVF 0x32,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0223
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0222
L0223:
	MOVF 0x32,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0221
L0222:
; 660: 					steps = one_round - steps
	MOVF 0x33,W
	SUBWF 0x3E,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x34
; 661: 					direction = 0
	BCF 0x07,0
; 662: 				Case Else  'no short way possible
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0224
L0221:
; 663: 				EndSelect
L0224:
L0220:
; 664: 			Endif
L0210:
; 665: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0225
L0209:
; 666: 			steps = act_steps - new_steps
	MOVF 0x36,W
	SUBWF 0x46,W
	MOVWF 0x33
	MOVF 0x37,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x47,W
	MOVWF 0x34
; 667: 			direction = 0
	BCF 0x07,0
; 668: 			If steps > one_round_half Then  'other direction shorter?
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x55,W
	MOVWF R1L
	MOVF 0x56,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0226
; 669: 				Select Case ctrl_type
; 670: 				Case 2, 3  'cable connected bridges
	MOVF 0x32,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0229
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0228
L0229:
	MOVF 0x32,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0227
L0228:
; 671: 					Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 672: 					Select Case turn_counter
; 673: 					Case < 130
	MOVLW 0x82
	SUBWF 0x41,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0230
; 674: 						turn_counter = turn_counter + 1  'yes it is, so add one pass
	MOVF 0x41,W
	ADDLW 0x01
	MOVWF 0x41
; 675: 						steps = one_round - steps  'go shortest way
	MOVF 0x33,W
	SUBWF 0x3E,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x34
; 676: 						direction = 1  'change direction
	BSF 0x07,0
; 677: 						Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0231:	BTFSC EECON1,WR
	GOTO L0231
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 678: 					Case > 130
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0232
L0230:
	MOVF 0x41,W
	SUBLW 0x82
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0233
; 679: 						Write mem_turn_counter, 130
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x82
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0234:	BTFSC EECON1,WR
	GOTO L0234
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 680: 					Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0235
L0233:
; 681: 					EndSelect
L0235:
L0232:
; 682: 				Case 4, 5  'type with contact sliders, no twisting cables
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0236
L0227:
	MOVF 0x32,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0239
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0238
L0239:
	MOVF 0x32,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0237
L0238:
; 683: 					steps = one_round - steps
	MOVF 0x33,W
	SUBWF 0x3E,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x34
; 684: 					direction = 1
	BSF 0x07,0
; 685: 				Case Else  'no short way possible
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0240
L0237:
; 686: 				EndSelect
L0240:
L0236:
; 687: 			Endif
L0226:
; 688: 		Endif
L0225:
; 689: 		If steps > 0 Then  'motor must be activated
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0241
; 690: 			If direction = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0242
; 691: 				steps = steps + free_space_word
	MOVF 0x33,W
	ADDWF 0x58,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x59,W
	MOVWF 0x34
; 692: 			Endif
L0242:
; 693: 			ramp_up = 1
	BSF 0x3D,4
; 694: 			ramp_down_point = 0
	CLRF 0x53
	CLRF 0x54
; 695: 			half_steps = steps / 2
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x5A
	MOVF R0H,W
	MOVWF 0x5B
; 696: 			speed = speed_min
	MOVF 0x3A,W
	MOVWF 0x4D
	MOVF 0x3B,W
	MOVWF 0x4E
; 697: 			ena = 1  'set anable on
	BSF 0x07,2
; 698: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 699: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0243:
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0244
; 700: 				If max_end = 0 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x06,7
	GOTO L0245
; 701: 					Gosub stop_the_motor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0016
; 702: 				Endif
L0245:
; 703: 				Select Case ctrl_type
; 704: 				Case 6
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0246
; 705: 					If fy_stop = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x05,5
	GOTO L0247
; 706: 						Gosub stop_the_motor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0016
; 707: 					Endif
L0247:
; 708: 				Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0248
L0246:
; 709: 				EndSelect
L0248:
; 710: 				clk = 1  'clock out
	BSF 0x07,1
; 711: 				WaitUs speed
	MOVF 0x4D,W
	MOVWF R4L
	MOVF 0x4E,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 712: 				clk = 0
	BCF 0x07,1
; 713: 				Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 714: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 715: 			Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0243
L0244:
; 716: 			WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 717: 			If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0249
; 718: 				steps = free_space_word
	MOVF 0x58,W
	MOVWF 0x33
	MOVF 0x59,W
	MOVWF 0x34
; 719: 				direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 720: 				While steps > 0  'NOW RUN UNTIL STEPS = 0
L0250:
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0251
; 721: 					If max_end = 0 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x06,7
	GOTO L0252
; 722: 						Gosub stop_the_motor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0016
; 723: 					Endif
L0252:
; 724: 					Select Case ctrl_type
; 725: 					Case 6
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0253
; 726: 						If fy_stop = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x05,5
	GOTO L0254
; 727: 							Gosub stop_the_motor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0016
; 728: 						Endif
L0254:
; 729: 					Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0255
L0253:
; 730: 					EndSelect
L0255:
; 731: 					clk = 1  'clock out
	BSF 0x07,1
; 732: 					WaitUs speed_min
	MOVF 0x3A,W
	MOVWF R4L
	MOVF 0x3B,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 733: 					clk = 0
	BCF 0x07,1
; 734: 					steps = steps - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 735: 					WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 736: 				Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0250
L0251:
; 737: 			Endif
L0249:
; 738: 			ena = 0  'enable off
	BCF 0x07,2
; 739: 		Endif
L0241:
; 740: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 741: 	Endif
L0208:
; 742: 	act_pos = new_pos
	MOVF 0x48,W
	MOVWF 0x31
; 743: 	Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0256:	BTFSC EECON1,WR
	GOTO L0256
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 744: 	bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x4C
; 745: 	old_bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x57
; 746: 	manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x40
; 747: 	old_manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x52
; 748: Return
	RETURN
; 749: 
; 750: 
; 751: speed_calc:
L0008:
; 752: 	If steps < half_steps Then  'at this point  ramp up MUST end
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x5A,W
	MOVWF R1L
	MOVF 0x5B,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0257
; 753: 		ramp_up = 0
	BCF 0x3D,4
; 754: 	Endif
L0257:
; 755: 	If ramp_up = 1 Then  'we were supposed to ramp up
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x3D,4
	GOTO L0258
; 756: 		If speed > speed_max Then
	MOVF 0x4D,W
	MOVWF R0L
	MOVF 0x4E,W
	MOVWF R0H
	MOVF 0x38,W
	MOVWF R1L
	MOVF 0x39,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0259
; 757: 			speed = speed - speed_step
	MOVF 0x45,W
	SUBWF 0x4D,W
	MOVWF 0x4D
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x4E,W
	MOVWF 0x4E
; 758: 			ramp_down_point = ramp_down_point + 1  'this counts down with the steps
	MOVF 0x53,W
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x54
; 759: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0260
L0259:
; 760: 			ramp_up = 0
	BCF 0x3D,4
; 761: 		Endif
L0260:
; 762: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0261
L0258:
; 763: 		If steps < ramp_down_point Then  'this is the point tot start ramp down
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x53,W
	MOVWF R1L
	MOVF 0x54,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0262
; 764: 			If speed < speed_min Then
	MOVF 0x4D,W
	MOVWF R0L
	MOVF 0x4E,W
	MOVWF R0H
	MOVF 0x3A,W
	MOVWF R1L
	MOVF 0x3B,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0263
; 765: 				speed = speed + speed_step
	MOVF 0x4D,W
	ADDWF 0x45,W
	MOVWF 0x4D
	MOVF 0x4E,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x4E
; 766: 			Endif
L0263:
; 767: 		Endif
L0262:
; 768: 	Endif
L0261:
; 769: Return
	RETURN
; 770: 
; 771: 
; 772: relays:
L0009:
; 773: 	Gosub read_bridge_switch
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0013
; 774: 	If bridge_power = 0 Then  'BRIDGE MUST BE SWITCHED OFF
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x3D,3
	GOTO L0264
; 775: 		If onoff = 1 Then  'the motor has stopped
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x3D,2
	GOTO L0265
; 776: 			Select Case ctrl_type
; 777: 			Case 1, 3, 5, 6
	MOVF 0x32,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0268
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0267
L0268:
	MOVF 0x32,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0269
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0267
L0269:
	MOVF 0x32,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0270
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0267
L0270:
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0266
L0267:
; 778: 				swfw = 0
	BCF 0x06,0
; 779: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 780: 				swrev = 1
	BSF 0x06,1
; 781: 			Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0271
L0266:
; 782: 				swfw = 0  'first both relays off
	BCF 0x06,0
; 783: 				swrev = 0
	BCF 0x06,1
; 784: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 785: 				swfw = bridge_switch
	BTFSC 0x3D,0
	BSF 0x06,0
	BTFSS 0x3D,0
	BCF 0x06,0
; 786: 				swrev = Not bridge_switch
	BTFSS 0x3D,0
	BSF 0x06,1
	BTFSC 0x3D,0
	BCF 0x06,1
; 787: 			EndSelect
L0271:
; 788: 		Else  'motor is moving
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0272
L0265:
; 789: 			swfw = 0
	BCF 0x06,0
; 790: 			swrev = 0
	BCF 0x06,1
; 791: 		Endif
L0272:
; 792: 	Else  'bridge remains under power
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0273
L0264:
; 793: 		swfw = bridge_switch
	BTFSC 0x3D,0
	BSF 0x06,0
	BTFSS 0x3D,0
	BCF 0x06,0
; 794: 		WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 795: 		swrev = Not bridge_switch
	BTFSS 0x3D,0
	BSF 0x06,1
	BTFSC 0x3D,0
	BCF 0x06,1
; 796: 	Endif
L0273:
; 797: Return
	RETURN
; 798: 
; 799: 
; 800: init_eeprom:
L0010:
; 801: 	If pgm = 0 Then  'special for my own fiddle yard
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0274
; 802: 		new_steps = 178
	MOVLW 0xB2
	MOVWF 0x36
	CLRF 0x37
; 803: 		For act_pos = 0 To 11
	CLRF 0x31
L0275:
	MOVF 0x31,W
	SUBLW 0x0B
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0276
; 804: 			Gosub save_steps
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0015
; 805: 			new_steps = new_steps + 4300
	MOVF 0x36,W
	ADDLW 0xCC
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x10
	MOVWF 0x37
; 806: 		Next act_pos
	MOVLW 0x01
	ADDWF 0x31,F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0275
L0276:
; 807: 		Write mem_max_pos, 11
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x0B
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0277:	BTFSC EECON1,WR
	GOTO L0277
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 808: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x35
; 809: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0278
L0274:
; 810: 		new_steps = 0
	CLRF 0x36
	CLRF 0x37
; 811: 		steps = one_round / (max_pos + 1)  'devide the steps between min and max
	MOVF 0x35,W
	ADDLW 0x01
	MOVWF 0x33
	CLRW
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x34
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVF 0x33,W
	MOVWF R1L
	MOVF 0x34,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x33
	MOVF R0H,W
	MOVWF 0x34
; 812: 		For act_pos = 0 To max_pos
	CLRF 0x31
L0279:
	MOVF 0x31,W
	SUBWF 0x35,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0280
; 813: 			Gosub save_steps
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0015
; 814: 			bridge_switch = 0
	BCF 0x3D,0
; 815: 			Gosub store_bridge_switch
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 816: 			new_steps = new_steps + steps
	MOVF 0x36,W
	ADDWF 0x33,W
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x34,W
	MOVWF 0x37
; 817: 		Next act_pos
	MOVLW 0x01
	ADDWF 0x31,F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0279
L0280:
; 818: 	Endif
L0278:
; 819: 	act_pos = 0
	CLRF 0x31
; 820: 	Write mem_act_pos, act_pos  'act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0281:	BTFSC EECON1,WR
	GOTO L0281
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 821: Return
	RETURN
; 822: 
; 823: init_values:
L0011:
; 824: 	version = 0  'decimal point in display on
	BCF 0x3D,5
; 825: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 826: 	WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 827: 	version = 1  'decimal point in display off
	BSF 0x3D,5
; 828: 	encoder_count = 0
	CLRF 0x4B
; 829: 	speed_min = 0
	CLRF 0x3A
	CLRF 0x3B
; 830: 	Read mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3B
; 831: 	If speed_min.HB > 99 Then
	MOVF 0x3B,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0282
; 832: 		speed_min.HB = 40
	MOVLW 0x28
	MOVWF 0x3B
; 833: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0283
L0282:
; 834: 		If speed_min.HB < 1 Then
	MOVLW 0x01
	SUBWF 0x3B,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0284
; 835: 			speed_min.HB = 40
	MOVLW 0x28
	MOVWF 0x3B
; 836: 		Endif
L0284:
; 837: 	Endif
L0283:
; 838: 	speed_max = 0
	CLRF 0x38
	CLRF 0x39
; 839: 	Read mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 840: 	If speed_max.HB > speed_min.HB Then
	MOVF 0x39,W
	SUBWF 0x3B,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0285
; 841: 		speed_max.HB = speed_min.HB
	MOVF 0x3B,W
	MOVWF 0x39
; 842: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0286
L0285:
; 843: 		If speed_max.HB < 1 Then
	MOVLW 0x01
	SUBWF 0x39,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0287
; 844: 			speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x39
; 845: 		Endif
L0287:
; 846: 	Endif
L0286:
; 847: 
; 848: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3E
; 849: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 850: 	If one_round = 0 Then
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0288
; 851: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x3E
	MOVLW 0x1F
	MOVWF 0x3F
; 852: 	Endif
L0288:
; 853: 	If one_round > 60000 Then
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0289
; 854: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x3E
	MOVLW 0x1F
	MOVWF 0x3F
; 855: 	Endif
L0289:
; 856: 	one_round_half = one_round / 2
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x55
	MOVF R0H,W
	MOVWF 0x56
; 857: 
; 858: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x32
; 859: 	If ctrl_type > 6 Then
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0290
; 860: 		ctrl_type = 6
	MOVLW 0x06
	MOVWF 0x32
; 861: 	Endif
L0290:
; 862: 
; 863: 	Read mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x35
; 864: 	Select Case ctrl_type
; 865: 	Case 6
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0291
; 866: 		If max_pos > 30 Then
	MOVF 0x35,W
	SUBLW 0x1E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0292
; 867: 			max_pos = 12
	MOVLW 0x0C
	MOVWF 0x35
; 868: 		Endif
L0292:
; 869: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0293
L0291:
; 870: 		If max_pos > 47 Then
	MOVF 0x35,W
	SUBLW 0x2F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0294
; 871: 			max_pos = 47
	MOVLW 0x2F
	MOVWF 0x35
; 872: 		Endif
L0294:
; 873: 	EndSelect
L0293:
; 874: 	Read mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 875: 	If act_pos > max_pos Then
	MOVF 0x31,W
	SUBWF 0x35,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0295
; 876: 		act_pos = 0
	CLRF 0x31
; 877: 	Endif
L0295:
; 878: 	Read mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x44
; 879: 	If free_space_steps > 99 Then
	MOVF 0x44,W
	SUBLW 0x63
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0296
; 880: 		free_space_steps = 0
	CLRF 0x44
; 881: 	Endif
L0296:
; 882: 
; 883: 	Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 884: 	If turn_counter > 131 Then  'in program impossible value
	MOVF 0x41,W
	SUBLW 0x83
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0297
; 885: 		turn_counter = 128
	MOVLW 0x80
	MOVWF 0x41
; 886: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0298
L0297:
; 887: 		If turn_counter < 125 Then  'in program impossible value
	MOVLW 0x7D
	SUBWF 0x41,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0299
; 888: 			turn_counter = 128
	MOVLW 0x80
	MOVWF 0x41
; 889: 		Endif
L0299:
; 890: 	Endif
L0298:
; 891: 	
; 892: 	Read mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x45
; 893: 	If speed_step > 99 Then
	MOVF 0x45,W
	SUBLW 0x63
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0300
; 894: 		speed_step = 0
	CLRF 0x45
; 895: 	Endif
L0300:
; 896: 	
; 897: 	If eep = 1 Then  'jumper set for initialisation
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0301
; 898: 		Gosub init_eeprom
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0010
; 899: 	Endif
L0301:
; 900: 	steps_set = 0
	BCF 0x3D,1
; 901: 	new_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x48
; 902: 	bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x4C
; 903: 	old_bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x57
; 904: 	manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x40
; 905: 	old_manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x52
; 906: Return
	RETURN
; 907: 
; 908: steps_reading:
L0012:
; 909: 	Select Case new_pos
; 910: 	Case 63
	MOVF 0x48,W
	SUBLW 0x3F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0302
; 911: 		new_steps = 65534
	MOVLW 0xFE
	MOVWF 0x36
	MOVLW 0xFF
	MOVWF 0x37
; 912: 		act_steps = 1
	MOVLW 0x01
	MOVWF 0x46
	CLRF 0x47
; 913: 	Case 62
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0303
L0302:
	MOVF 0x48,W
	SUBLW 0x3E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0304
; 914: 		new_steps = 65534
	MOVLW 0xFE
	MOVWF 0x36
	MOVLW 0xFF
	MOVWF 0x37
; 915: 		act_steps = 0
	CLRF 0x46
	CLRF 0x47
; 916: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0305
L0304:
; 917: 		eprom_pointer = act_pos + 48
	MOVF 0x31,W
	ADDLW 0x30
	MOVWF 0x50
; 918: 		Read act_pos, act_steps.LB
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x46
; 919: 		Read eprom_pointer, act_steps.HB
	MOVF 0x50,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x47
; 920: 		eprom_pointer = new_pos + 48
	MOVF 0x48,W
	ADDLW 0x30
	MOVWF 0x50
; 921: 		Read new_pos, new_steps.LB
	MOVF 0x48,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 922: 		Read eprom_pointer, new_steps.HB
	MOVF 0x50,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 923: 		Read mem_free_space, value
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 924: 		free_space_word = free_space_steps * 4
	MOVF 0x44,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x04
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x58
	MOVF R2H,W
	MOVWF 0x59
; 925: 	EndSelect
L0305:
L0303:
; 926: Return
	RETURN
; 927: 
; 928: read_bridge_switch:
L0013:
; 929: 	Select Case act_pos
; 930: 	Case < 8
	MOVLW 0x08
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0306
; 931: 		Read mem_bridge_switch1, value
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 932: 	Case < 16
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0307
L0306:
	MOVLW 0x10
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0308
; 933: 		Read mem_bridge_switch2, value
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 934: 	Case < 24
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0309
L0308:
	MOVLW 0x18
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0310
; 935: 		Read mem_bridge_switch3, value
	MOVLW 0x73
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 936: 	Case < 32
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0311
L0310:
	MOVLW 0x20
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0312
; 937: 		Read mem_bridge_switch4, value
	MOVLW 0x74
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 938: 	Case < 40
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0313
L0312:
	MOVLW 0x28
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0314
; 939: 		Read mem_bridge_switch5, value
	MOVLW 0x75
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 940: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0315
L0314:
; 941: 		Read mem_bridge_switch6, value
	MOVLW 0x76
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 942: 	EndSelect
L0315:
L0313:
L0311:
L0309:
L0307:
; 943: 	value2 = act_pos Mod 8
	MOVF 0x31,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x08
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x42
; 944: 	Select Case value2
; 945: 	Case 0
	MOVF 0x42,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0316
; 946: 		bridge_switch = value.0
	BTFSC 0x30,0
	BSF 0x3D,0
	BTFSS 0x30,0
	BCF 0x3D,0
; 947: 	Case 1
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0317
L0316:
	MOVF 0x42,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0318
; 948: 		bridge_switch = value.1
	BTFSC 0x30,1
	BSF 0x3D,0
	BTFSS 0x30,1
	BCF 0x3D,0
; 949: 	Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0319
L0318:
	MOVF 0x42,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0320
; 950: 		bridge_switch = value.2
	BTFSC 0x30,2
	BSF 0x3D,0
	BTFSS 0x30,2
	BCF 0x3D,0
; 951: 	Case 3
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0321
L0320:
	MOVF 0x42,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0322
; 952: 		bridge_switch = value.3
	BTFSC 0x30,3
	BSF 0x3D,0
	BTFSS 0x30,3
	BCF 0x3D,0
; 953: 	Case 4
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0323
L0322:
	MOVF 0x42,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0324
; 954: 		bridge_switch = value.4
	BTFSC 0x30,4
	BSF 0x3D,0
	BTFSS 0x30,4
	BCF 0x3D,0
; 955: 	Case 5
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0325
L0324:
	MOVF 0x42,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0326
; 956: 		bridge_switch = value.5
	BTFSC 0x30,5
	BSF 0x3D,0
	BTFSS 0x30,5
	BCF 0x3D,0
; 957: 	Case 6
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0327
L0326:
	MOVF 0x42,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0328
; 958: 		bridge_switch = value.6
	BTFSC 0x30,6
	BSF 0x3D,0
	BTFSS 0x30,6
	BCF 0x3D,0
; 959: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0329
L0328:
; 960: 		bridge_switch = value.7
	BTFSC 0x30,7
	BSF 0x3D,0
	BTFSS 0x30,7
	BCF 0x3D,0
; 961: 	EndSelect
L0329:
L0327:
L0325:
L0323:
L0321:
L0319:
L0317:
; 962: Return
	RETURN
; 963: store_bridge_switch:
L0014:
; 964: 	Select Case act_pos
; 965: 	Case < 8
	MOVLW 0x08
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0330
; 966: 		Read mem_bridge_switch1, value
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 967: 	Case < 16
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0331
L0330:
	MOVLW 0x10
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0332
; 968: 		Read mem_bridge_switch2, value
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 969: 	Case < 24
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0333
L0332:
	MOVLW 0x18
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0334
; 970: 		Read mem_bridge_switch3, value
	MOVLW 0x73
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 971: 	Case < 32
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0335
L0334:
	MOVLW 0x20
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0336
; 972: 		Read mem_bridge_switch4, value
	MOVLW 0x74
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 973: 	Case < 40
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0337
L0336:
	MOVLW 0x28
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0338
; 974: 		Read mem_bridge_switch5, value
	MOVLW 0x75
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 975: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0339
L0338:
; 976: 		Read mem_bridge_switch6, value
	MOVLW 0x76
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 977: 	EndSelect
L0339:
L0337:
L0335:
L0333:
L0331:
; 978: 	value2 = act_pos
	MOVF 0x31,W
	MOVWF 0x42
; 979: 	value2 = value2 Mod 8
	MOVF 0x42,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x08
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x42
; 980: 	Select Case value2
; 981: 	Case 0
	MOVF 0x42,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0340
; 982: 		value.0 = bridge_switch
	BTFSC 0x3D,0
	BSF 0x30,0
	BTFSS 0x3D,0
	BCF 0x30,0
; 983: 	Case 1
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0341
L0340:
	MOVF 0x42,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0342
; 984: 		value.1 = bridge_switch
	BTFSC 0x3D,0
	BSF 0x30,1
	BTFSS 0x3D,0
	BCF 0x30,1
; 985: 	Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0343
L0342:
	MOVF 0x42,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0344
; 986: 		value.2 = bridge_switch
	BTFSC 0x3D,0
	BSF 0x30,2
	BTFSS 0x3D,0
	BCF 0x30,2
; 987: 	Case 3
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0345
L0344:
	MOVF 0x42,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0346
; 988: 		value.3 = bridge_switch
	BTFSC 0x3D,0
	BSF 0x30,3
	BTFSS 0x3D,0
	BCF 0x30,3
; 989: 	Case 4
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0347
L0346:
	MOVF 0x42,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0348
; 990: 		value.4 = bridge_switch
	BTFSC 0x3D,0
	BSF 0x30,4
	BTFSS 0x3D,0
	BCF 0x30,4
; 991: 	Case 5
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0349
L0348:
	MOVF 0x42,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0350
; 992: 		value.5 = bridge_switch
	BTFSC 0x3D,0
	BSF 0x30,5
	BTFSS 0x3D,0
	BCF 0x30,5
; 993: 	Case 6
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0351
L0350:
	MOVF 0x42,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0352
; 994: 		value.6 = bridge_switch
	BTFSC 0x3D,0
	BSF 0x30,6
	BTFSS 0x3D,0
	BCF 0x30,6
; 995: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0353
L0352:
; 996: 		value.7 = bridge_switch
	BTFSC 0x3D,0
	BSF 0x30,7
	BTFSS 0x3D,0
	BCF 0x30,7
; 997: 	EndSelect
L0353:
L0351:
L0349:
L0347:
L0345:
L0343:
L0341:
; 998: 	Select Case act_pos
; 999: 	Case < 8
	MOVLW 0x08
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0354
; 1000: 		Write mem_bridge_switch1, value
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0355:	BTFSC EECON1,WR
	GOTO L0355
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1001: 	Case < 16
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0356
L0354:
	MOVLW 0x10
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0357
; 1002: 		Write mem_bridge_switch2, value
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0358:	BTFSC EECON1,WR
	GOTO L0358
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1003: 	Case < 24
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0359
L0357:
	MOVLW 0x18
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0360
; 1004: 		Write mem_bridge_switch3, value
	MOVLW 0x73
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0361:	BTFSC EECON1,WR
	GOTO L0361
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1005: 	Case < 32
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0362
L0360:
	MOVLW 0x20
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0363
; 1006: 		Write mem_bridge_switch4, value
	MOVLW 0x74
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0364:	BTFSC EECON1,WR
	GOTO L0364
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1007: 	Case < 40
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0365
L0363:
	MOVLW 0x28
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0366
; 1008: 		Write mem_bridge_switch5, value
	MOVLW 0x75
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0367:	BTFSC EECON1,WR
	GOTO L0367
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1009: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0368
L0366:
; 1010: 		Write mem_bridge_switch6, value
	MOVLW 0x76
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0369:	BTFSC EECON1,WR
	GOTO L0369
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1011: 	EndSelect
L0368:
L0365:
L0362:
L0359:
L0356:
; 1012: Return
	RETURN
; 1013: 
; 1014: save_steps:
L0015:
; 1015: 	eprom_pointer = act_pos + 48
	MOVF 0x31,W
	ADDLW 0x30
	MOVWF 0x50
; 1016: 	Write act_pos, new_steps.LB
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0370:	BTFSC EECON1,WR
	GOTO L0370
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1017: 	Write eprom_pointer, new_steps.HB
	MOVF 0x50,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0371:	BTFSC EECON1,WR
	GOTO L0371
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1018: Return
	RETURN
; 1019: 
; 1020: stop_the_motor:
L0016:
; 1021: 	While ecsw = 1
L0372:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,6
	GOTO L0373
; 1022: 		WaitMs 250
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 1023: 	Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0372
L0373:
; 1024: Return
	RETURN
; End of program
;       PAGE SELECT
;	BCF PCLATH,3
L0374:	GOTO L0374
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
