; Compiled with: PIC Simulator IDE v6.90
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_turn_counter' (global) is 101
;       The value of 'mem_act_pos' (global) is 102
;       The value of 'mem_speed_min' (global) is 103
;       The value of 'mem_speed_max' (global) is 104
;       The value of 'mem_speed_step' (global) is 105
;       The value of 'mem_one_round_lb' (global) is 106
;       The value of 'mem_one_round_hb' (global) is 107
;       The value of 'mem_ctrl_type' (global) is 108
;       The value of 'mem_max_pos' (global) is 109
;       The value of 'mem_free_space' (global) is 110
;       The address of 'act_pos' (byte) (global) is 0x30
	act_pos EQU 0x30
;       The address of 'value' (byte) (global) is 0x31
	value EQU 0x31
;       The address of 'ctrl_type' (byte) (global) is 0x32
	ctrl_type EQU 0x32
;       The address of 'steps' (word) (global) is 0x33
	steps EQU 0x33
;       The address of 'new_steps' (word) (global) is 0x35
	new_steps EQU 0x35
;       The address of 'one_round' (word) (global) is 0x37
	one_round EQU 0x37
;       The address of 'speed_max' (word) (global) is 0x39
	speed_max EQU 0x39
;       The address of 'speed_min' (word) (global) is 0x3B
	speed_min EQU 0x3B
;       The address of 'max_pos' (byte) (global) is 0x3D
	max_pos EQU 0x3D
;       The address of 'result' (byte) (global) is 0x3E
	result EQU 0x3E
;       The address of 'free_space_steps' (byte) (global) is 0x3F
	free_space_steps EQU 0x3F
;       The address of 'turn_counter' (byte) (global) is 0x40
	turn_counter EQU 0x40
;       The address of 'manual_pos' (byte) (global) is 0x41
	manual_pos EQU 0x41
;       The address of 'speed_step' (byte) (global) is 0x42
	speed_step EQU 0x42
;       The address of 'program_set' (byte) (global) is 0x43
	program_set EQU 0x43
;       The address of 'steps_set' (bit) (global) is 0x44,0
;       The address of 'act_steps' (word) (global) is 0x45
	act_steps EQU 0x45
;       The address of 'disp1_val' (byte) (global) is 0x47
	disp1_val EQU 0x47
;       The address of 'bus_pos' (byte) (global) is 0x48
	bus_pos EQU 0x48
;       The address of 'new_encoder' (byte) (global) is 0x49
	new_encoder EQU 0x49
;       The address of 'encoder_count' (byte) (global) is 0x4A
	encoder_count EQU 0x4A
;       The address of 'new_pos' (byte) (global) is 0x4B
	new_pos EQU 0x4B
;       The address of 'speed' (word) (global) is 0x4C
	speed EQU 0x4C
;       The address of 'onoff' (bit) (global) is 0x44,1
;       The address of 'disp2_val' (byte) (global) is 0x4E
	disp2_val EQU 0x4E
;       The address of 'eprom_pointer' (byte) (global) is 0x4F
	eprom_pointer EQU 0x4F
;       The address of 'old_encoder' (byte) (global) is 0x50
	old_encoder EQU 0x50
;       The address of 'old_manual_pos' (byte) (global) is 0x51
	old_manual_pos EQU 0x51
;       The address of 'ramp_up' (bit) (global) is 0x44,2
;       The address of 'version' (bit) (global) is 0x44,3
;       The address of 'ramp_down_point' (word) (global) is 0x52
	ramp_down_point EQU 0x52
;       The address of 'one_round_half' (word) (global) is 0x54
	one_round_half EQU 0x54
;       The address of 'old_bus_pos' (byte) (global) is 0x56
	old_bus_pos EQU 0x56
;       The address of 'old_pos_write' (bit) (global) is 0x44,4
;       The address of 'half_steps' (word) (global) is 0x57
	half_steps EQU 0x57
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'eep' (bit) (global) is 0x6,6
;       The address of 'max_end' (bit) (global) is 0x6,7
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x7,3
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0015
	ORG 0x0004
	RETFIE
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Byte
X001:	MOVLW 0x02
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
X002:	MOVLW 0x02
	SUBWF R4L,F
	NOP
	NOP
	NOP
	NOP
	BTFSS STATUS,C
	RETURN
	GOTO X002
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0015:
; 1: 'program TT for PCBoard MGV145
; 2: 'version V3-1  Fiddle Yard version, for turntables and fiddle yard
; 3: 'this version has all possibilities changeable by menue's.
; 4: 'V3-2 counter for twisting cables tored at eeprom pos zero.
; 5: 'the value of the counter can be anything between 125 and 131. 128 is zero point.
; 6: 'V3-3 eeprom startup improved. Reprogramming PIC can now be done without reprogramming data
; 7: 'V3.6 startup delayed, to avoid wrong positions
; 8: 'V3.7 extra separate positions for FY and TT with contact sliders.
; 9: '-----MGV50 input changed, ramp-up and ramp-down activated, including separate settings for min and max speed
; 10: 'V4.1 inital setting for FY, set pos 1 and pos 2 correct, rest will be automatic.
; 11: Define CONF_WORD = 0x3f72
; 12: Define CLOCK_FREQUENCY = 20
; 13: 'Define SIMULATION_WAITMS_VALUE = 1
; 14: Dim steps As Word
; 15: Dim half_steps As Word
; 16: Dim ramp_down_point As Word
; 17: Dim program_set As Byte
; 18: Dim new_steps As Word
; 19: Dim act_steps As Word
; 20: Dim new_pos As Byte
; 21: Dim act_pos As Byte
; 22: Dim one_round As Word
; 23: Dim one_round_half As Word
; 24: Dim bus_pos As Byte
; 25: Dim old_bus_pos As Byte
; 26: Dim speed As Word
; 27: Dim speed_min As Word
; 28: Dim speed_max As Word
; 29: Dim new_encoder As Byte
; 30: Dim old_encoder As Byte
; 31: Dim manual_pos As Byte
; 32: Dim old_manual_pos As Byte
; 33: Dim result As Byte
; 34: Dim free_space_steps As Byte
; 35: Dim value As Byte
; 36: Dim eprom_pointer As Byte
; 37: Dim encoder_count As Byte
; 38: Dim turn_counter As Byte
; 39: Dim onoff As Bit
; 40: Dim max_pos As Byte
; 41: Dim disp1_val As Byte
; 42: Dim disp2_val As Byte
; 43: Dim ctrl_type As Byte
; 44: Dim old_pos_write As Bit
; 45: Dim ramp_up As Bit
; 46: Dim speed_step As Byte
; 47: Dim version As Bit
; 48: Dim steps_set As Bit
; 49: Const disp1 = 64
; 50: Const disp2 = 66
; 51: Const mem_turn_counter = 101
; 52: Const mem_act_pos = 102
; 53: Const mem_speed_min = 103
; 54: Const mem_speed_max = 104
; 55: Const mem_speed_step = 105
; 56: Const mem_one_round_lb = 106
; 57: Const mem_one_round_hb = 107
; 58: Const mem_ctrl_type = 108
; 59: Const mem_max_pos = 109
; 60: Const mem_free_space = 110
; 61: Symbol swfw = RB0
; 62: Symbol swrev = RB1
; 63: Symbol sck = RB2
; 64: Symbol sda = RB3
; 65: Symbol pos_match = RB4
; 66: Symbol pos_write = RB5
; 67: Symbol eep = RB6
; 68: Symbol max_end = RB7
; 69: Symbol direction = RC0
; 70: Symbol clk = RC1
; 71: Symbol ena = RC2
; 72: Symbol zero = RC3
; 73: Symbol ec1 = RC4
; 74: Symbol ec2 = RC5
; 75: Symbol ecsw = RC6
; 76: Symbol pgm = RC7
; 77: 
; 78: ADCON1 = %0110
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 79: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 80: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 81: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 82: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 83: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 84: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 85: Gosub init_values
	BSF PCLATH,3
	CALL L0011
; 86: value = act_pos
	MOVF 0x30,W
	MOVWF 0x31
; 87: version = 1
	BSF 0x44,3
; 88: Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 89: onoff = 1
	BSF 0x44,1
; 90: Gosub relays
	BSF PCLATH,3
	CALL L0009
; 91: program_set = 1
	MOVLW 0x01
	MOVWF 0x43
; 92: main:
L0001:
; 93: 	If pgm = 0 Then
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0016
; 94: 		Gosub adjust_settings
	BCF PCLATH,3
	CALL L0004
; 95: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 96: 	Endif
L0016:
; 97: 
; 98: 	Gosub get_new_position
	BCF PCLATH,3
	CALL L0002
; 99: 	If bus_pos <> old_bus_pos Then
	MOVF 0x48,W
	SUBWF 0x56,W
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0017
; 100: 		onoff = 0
	BCF 0x44,1
; 101: 		Gosub relays
	BSF PCLATH,3
	CALL L0009
; 102: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 103: 		new_pos = bus_pos
	MOVF 0x48,W
	MOVWF 0x4B
; 104: 		Gosub stepmotor
	BCF PCLATH,3
	CALL L0007
; 105: 		value = act_pos
	MOVF 0x30,W
	MOVWF 0x31
; 106: 		Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 107: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 108: 		onoff = 1
	BSF 0x44,1
; 109: 	Else
	BCF PCLATH,3
	GOTO L0018
L0017:
; 110: 		If ecsw = 0 Then  'only when knob is pushed
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0019
; 111: 			If manual_pos <> old_manual_pos Then
	MOVF 0x41,W
	SUBWF 0x51,W
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0020
; 112: 				onoff = 0
	BCF 0x44,1
; 113: 				Gosub relays
	BSF PCLATH,3
	CALL L0009
; 114: 				pos_match = 1  'indicate not in position
	BSF 0x06,4
; 115: 				old_manual_pos = manual_pos
	MOVF 0x41,W
	MOVWF 0x51
; 116: 				new_pos = manual_pos
	MOVF 0x41,W
	MOVWF 0x4B
; 117: 				Gosub stepmotor
	BCF PCLATH,3
	CALL L0007
; 118: 				value = act_pos
	MOVF 0x30,W
	MOVWF 0x31
; 119: 				Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 120: 				pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 121: 				onoff = 1
	BSF 0x44,1
; 122: 			Endif
L0020:
; 123: 		Endif
L0019:
; 124: 	Endif
L0018:
; 125: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 126: 	Gosub relays
	BSF PCLATH,3
	CALL L0009
; 127: 	Goto main
	BCF PCLATH,3
	GOTO L0001
; 128: End
	BCF PCLATH,3
L0021:	GOTO L0021
; 129: 
; 130: 
; 131: get_new_position:
L0002:
; 132: 	value = bus_pos  'remember the position
	MOVF 0x48,W
	MOVWF 0x31
; 133: 	If pos_write = 1 Then
	BCF PCLATH,3
	BTFSS 0x06,5
	GOTO L0022
; 134: 		If old_pos_write = 0 Then  'react only once on rising edge
	BCF PCLATH,3
	BTFSC 0x44,4
	GOTO L0023
; 135: 			old_pos_write = 1
	BSF 0x44,4
; 136: 			value = PORTA And 63  'now get value from J5
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x31
; 137: 			If value > max_pos Then  'this is not allowed
	MOVF 0x31,W
	SUBWF 0x3D,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0024
; 138: 				value = bus_pos  'put it back to old situation
	MOVF 0x48,W
	MOVWF 0x31
; 139: 			Endif
L0024:
; 140: 			If value = 0 Then  'do not accept 0
	MOVF 0x31,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0025
; 141: 				value = bus_pos  'put it back to old situation
	MOVF 0x48,W
	MOVWF 0x31
; 142: 			Endif
L0025:
; 143: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 144: 			If value = bus_pos Then  'no other position is set, RR needs pos_match changes
	MOVF 0x31,W
	SUBWF 0x48,W
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0026
; 145: 				pos_match = 1
	BSF 0x06,4
; 146: 				WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 147: 				pos_match = 0
	BCF 0x06,4
; 148: 			Endif
L0026:
; 149: 		Endif
L0023:
; 150: 	Else
	BCF PCLATH,3
	GOTO L0027
L0022:
; 151: 		old_pos_write = 0
	BCF 0x44,4
; 152: 	Endif
L0027:
; 153: 	bus_pos = value  'now take over the dseired position
	MOVF 0x31,W
	MOVWF 0x48
; 154: 	Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 155: 	Select Case result
; 156: 	Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0028
; 157: 		If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x4A,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0029
; 158: 			encoder_count = encoder_count + 1
	MOVF 0x4A,W
	ADDLW 0x01
	MOVWF 0x4A
; 159: 		Else
	BCF PCLATH,3
	GOTO L0030
L0029:
; 160: 			encoder_count = 0
	CLRF 0x4A
; 161: 			manual_pos = manual_pos + 1
	MOVF 0x41,W
	ADDLW 0x01
	MOVWF 0x41
; 162: 			If manual_pos > max_pos Then
	MOVF 0x41,W
	SUBWF 0x3D,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0031
; 163: 				manual_pos = max_pos
	MOVF 0x3D,W
	MOVWF 0x41
; 164: 			Endif
L0031:
; 165: 			value = manual_pos
	MOVF 0x41,W
	MOVWF 0x31
; 166: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 167: 		Endif
L0030:
; 168: 	Case 2
	BCF PCLATH,3
	GOTO L0032
L0028:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0033
; 169: 		If encoder_count > 0 Then
	MOVF 0x4A,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0034
; 170: 			encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x4A,W
	MOVWF 0x4A
; 171: 		Else
	BCF PCLATH,3
	GOTO L0035
L0034:
; 172: 			encoder_count = 4
	MOVLW 0x04
	MOVWF 0x4A
; 173: 			If manual_pos > 0 Then
	MOVF 0x41,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0036
; 174: 				manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x41,W
	MOVWF 0x41
; 175: 			Endif
L0036:
; 176: 			value = manual_pos
	MOVF 0x41,W
	MOVWF 0x31
; 177: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 178: 		Endif
L0035:
; 179: 	Case Else
	BCF PCLATH,3
	GOTO L0037
L0033:
; 180: 	EndSelect
L0037:
L0032:
; 181: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 182: 	
; 183: Return
	RETURN
; 184: 
; 185: calc_rotation:  'this routine checks the incrimental switch
L0003:
; 186: '1 = increasing value
; 187: '2 = decreasing value
; 188: '3 = no change
; 189: 		new_encoder = 0
	CLRF 0x49
; 190: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x49,0
	BTFSS 0x07,4
	BCF 0x49,0
; 191: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x49,1
	BTFSS 0x07,5
	BCF 0x49,1
; 192: 		Select Case old_encoder
; 193: 		Case 0
	MOVF 0x50,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0038
; 194: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x49,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0039
	BCF PCLATH,3
	CALL L0040
	MOVWF 0x3E
	BCF PCLATH,3
	GOTO L0039
L0040:
	MOVLW 0x01
	MOVWF PCLATH
	MOVF 0x49,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
L0039:
; 195: 		Case 1
	BCF PCLATH,3
	GOTO L0041
L0038:
	MOVF 0x50,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0042
; 196: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x49,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0043
	BCF PCLATH,3
	CALL L0044
	MOVWF 0x3E
	BCF PCLATH,3
	GOTO L0043
L0044:
	MOVLW 0x01
	MOVWF PCLATH
	MOVF 0x49,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
L0043:
; 197: 		Case 2
	BCF PCLATH,3
	GOTO L0045
L0042:
	MOVF 0x50,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0046
; 198: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x49,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0047
	BCF PCLATH,3
	CALL L0048
	MOVWF 0x3E
	BCF PCLATH,3
	GOTO L0047
L0048:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x49,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
L0047:
; 199: 		Case Else
	BCF PCLATH,3
	GOTO L0049
L0046:
; 200: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x49,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0050
	BCF PCLATH,3
	CALL L0051
	MOVWF 0x3E
	BCF PCLATH,3
	GOTO L0050
L0051:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x49,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
L0050:
; 201: 		EndSelect
L0049:
L0045:
L0041:
; 202: 		old_encoder = new_encoder
	MOVF 0x49,W
	MOVWF 0x50
; 203: Return
	RETURN
; 204: 
; 205: 
; 206: adjust_settings:
L0004:
; 207: 	Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 208: 	WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 209: 	onoff = 0
	BCF 0x44,1
; 210: 	Gosub relays
	BSF PCLATH,3
	CALL L0009
; 211: 	Gosub steps_reading
	BSF PCLATH,3
	CALL L0012
; 212: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x45,W
	MOVWF 0x35
	MOVF 0x46,W
	MOVWF 0x36
; 213: 	While pgm = 0  'the program switch is still activated
L0052:
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0053
; 214: 		If ecsw = 0 Then  'knob is pressed, inrease program_set
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0054
; 215: 			program_set = program_set + 1
	MOVF 0x43,W
	ADDLW 0x01
	MOVWF 0x43
; 216: 			If program_set > 7 Then  'no more than 7 items te change
	MOVF 0x43,W
	SUBLW 0x07
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0055
; 217: 				program_set = 1
	MOVLW 0x01
	MOVWF 0x43
; 218: 			Endif
L0055:
; 219: 			Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 220: 			WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 221: 			While ecsw = 0  'be sure pushbutton is released
L0056:
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0057
; 222: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 223: 			Wend
	BCF PCLATH,3
	GOTO L0056
L0057:
; 224: 		Endif
L0054:
; 225: 		Select Case program_set
; 226: 		Case 1  'correction of current position
	MOVF 0x43,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0058
; 227: 			value = act_pos
	MOVF 0x30,W
	MOVWF 0x31
; 228: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 229: 			Gosub calc_rotation  'look for the knob to be turned
	BCF PCLATH,3
	CALL L0003
; 230: 			Select Case result
; 231: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0059
; 232: 				If new_steps < 60000 Then
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0060
; 233: 					ena = 1  'motor on
	BSF 0x07,2
; 234: 					new_steps = new_steps + 1
	MOVF 0x35,W
	ADDLW 0x01
	MOVWF 0x35
	MOVF 0x36,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x36
; 235: 					direction = 1
	BSF 0x07,0
; 236: 					clk = 1  'clock out
	BSF 0x07,1
; 237: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 238: 					clk = 0
	BCF 0x07,1
; 239: 				Endif
L0060:
; 240: 			Case 2
	BCF PCLATH,3
	GOTO L0061
L0059:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0062
; 241: 				If new_steps > 0 Then
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0063
; 242: 					ena = 1  'motor on
	BSF 0x07,2
; 243: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x35,W
	MOVWF 0x35
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x36,W
	MOVWF 0x36
; 244: 					direction = 0
	BCF 0x07,0
; 245: 					clk = 1  'clock out
	BSF 0x07,1
; 246: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 247: 					clk = 0
	BCF 0x07,1
; 248: 				Endif
L0063:
; 249: 			Case Else
	BCF PCLATH,3
	GOTO L0064
L0062:
; 250: 			EndSelect
L0064:
L0061:
; 251: 			Select Case act_pos
; 252: 			Case 1
	MOVF 0x30,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0065
; 253: 				steps_set = 1
	BSF 0x44,0
; 254: 			Case 2
	BCF PCLATH,3
	GOTO L0066
L0065:
	MOVF 0x30,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0067
; 255: 				If steps_set = 1 Then
	BCF PCLATH,3
	BTFSS 0x44,0
	GOTO L0068
; 256: 					If eep = 1 Then  'iF jumper eep1 is set to on
	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0069
; 257: 											'routine to set steps for pos 3 to max_pos
; 258: 						value = 88
	MOVLW 0x58
	MOVWF 0x31
; 259: 						Gosub i2c_display  'show 88 to indicate adjusting is proceeded
	BCF PCLATH,3
	CALL L0005
; 260: 						If act_steps <> new_steps Then
	MOVF 0x45,W
	MOVWF R0L
	MOVF 0x46,W
	MOVWF R0H
	MOVF 0x35,W
	MOVWF R1L
	MOVF 0x36,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C002
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0070
; 261: 							Gosub save_steps
	BSF PCLATH,3
	CALL L0013
; 262: 						Endif
L0070:
; 263: 						act_pos = 1
	MOVLW 0x01
	MOVWF 0x30
; 264: 						new_pos = 2
	MOVLW 0x02
	MOVWF 0x4B
; 265: 						Gosub steps_reading
	BSF PCLATH,3
	CALL L0012
; 266: 						steps = new_steps - act_steps  'calculate difference between one and two
	MOVF 0x45,W
	SUBWF 0x35,W
	MOVWF 0x33
	MOVF 0x46,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x36,W
	MOVWF 0x34
; 267: 						For act_pos = 3 To max_pos
	MOVLW 0x03
	MOVWF 0x30
L0071:
	MOVF 0x30,W
	SUBWF 0x3D,W
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0072
; 268: 							new_steps = new_steps + steps
	MOVF 0x35,W
	ADDWF 0x33,W
	MOVWF 0x35
	MOVF 0x36,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x34,W
	MOVWF 0x36
; 269: 							Gosub save_steps
	BSF PCLATH,3
	CALL L0013
; 270: 						Next act_pos
	MOVLW 0x01
	ADDWF 0x30,F
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0071
L0072:
; 271: 						WaitMs 2000  'give some timne to read display
	MOVLW 0xD0
	MOVWF R0L
	MOVLW 0x07
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 272: 						act_pos = 2  'we were at this position
	MOVLW 0x02
	MOVWF 0x30
; 273: 						steps_set = 0  'do this routine only once
	BCF 0x44,0
; 274: 					Endif
L0069:
; 275: 				Endif
L0068:
; 276: 			Case Else
	BCF PCLATH,3
	GOTO L0073
L0067:
; 277: 				steps_set = 0
	BCF 0x44,0
; 278: 			EndSelect  'act_pos
L0073:
L0066:
; 279: 		Case 2  'setting of maximum positions
	BCF PCLATH,3
	GOTO L0074
L0058:
	MOVF 0x43,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0075
; 280: 			steps_set = 0
	BCF 0x44,0
; 281: 			ena = 0  'shut off motor
	BCF 0x07,2
; 282: 			value = max_pos
	MOVF 0x3D,W
	MOVWF 0x31
; 283: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 284: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 285: 			Select Case result
; 286: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0076
; 287: 				If max_pos < 48 Then  'no more positions possible
	MOVLW 0x30
	SUBWF 0x3D,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0077
; 288: 					max_pos = max_pos + 1
	MOVF 0x3D,W
	ADDLW 0x01
	MOVWF 0x3D
; 289: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0078:	BTFSC EECON1,WR
	GOTO L0078
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 290: 				Endif
L0077:
; 291: 			Case 2
	BCF PCLATH,3
	GOTO L0079
L0076:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0080
; 292: 				If max_pos > 4 Then  'minum 4 positions
	MOVF 0x3D,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0081
; 293: 					max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
; 294: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0082:	BTFSC EECON1,WR
	GOTO L0082
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 295: 				Endif
L0081:
; 296: 			Case Else
	BCF PCLATH,3
	GOTO L0083
L0080:
; 297: 			EndSelect
L0083:
L0079:
; 298: 		Case 3  'setting control type
	BCF PCLATH,3
	GOTO L0084
L0075:
	MOVF 0x43,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0085
; 299: 			steps_set = 0
	BCF 0x44,0
; 300: 			ena = 0  'shut off motor
	BCF 0x07,2
; 301: 			If ctrl_type > 6 Then
	MOVF 0x32,W
	SUBLW 0x06
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0086
; 302: 				ctrl_type = 0
	CLRF 0x32
; 303: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0087:	BTFSC EECON1,WR
	GOTO L0087
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 304: 			Endif
L0086:
; 305: 			value = ctrl_type
	MOVF 0x32,W
	MOVWF 0x31
; 306: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 307: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 308: 			Select Case result
; 309: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0088
; 310: 				If ctrl_type < 6 Then
	MOVLW 0x06
	SUBWF 0x32,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0089
; 311: 					ctrl_type = ctrl_type + 1
	MOVF 0x32,W
	ADDLW 0x01
	MOVWF 0x32
; 312: 					Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0090:	BTFSC EECON1,WR
	GOTO L0090
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 313: 				Endif
L0089:
; 314: 			Case 2
	BCF PCLATH,3
	GOTO L0091
L0088:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0092
; 315: 				If ctrl_type > 0 Then
	MOVF 0x32,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0093
; 316: 					ctrl_type = ctrl_type - 1
	MOVLW 0x01
	SUBWF 0x32,W
	MOVWF 0x32
; 317: 					Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0094:	BTFSC EECON1,WR
	GOTO L0094
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 318: 				Endif
L0093:
; 319: 			Case Else
	BCF PCLATH,3
	GOTO L0095
L0092:
; 320: 			EndSelect
L0095:
L0091:
; 321: 		Case 4  'setting of speed interval Minimum
	BCF PCLATH,3
	GOTO L0096
L0085:
	MOVF 0x43,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0097
; 322: 					'setting will be done in multiple of 256 uSecs
; 323: 					'minimum is 2 and maximum is 99 (is real slow)
; 324: 			steps_set = 0
	BCF 0x44,0
; 325: 			ena = 0  'shut off motor
	BCF 0x07,2
; 326: 			value = speed_min.HB
	MOVF 0x3C,W
	MOVWF 0x31
; 327: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 328: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 329: 			Select Case result
; 330: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0098
; 331: 				If speed_min.HB < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x3C,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0099
; 332: 					speed_min = speed_min + 256
	MOVF 0x3B,W
	ADDLW 0x00
	MOVWF 0x3B
	MOVF 0x3C,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x01
	MOVWF 0x3C
; 333: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0100:	BTFSC EECON1,WR
	GOTO L0100
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 334: 				Endif
L0099:
; 335: 			Case 2
	BCF PCLATH,3
	GOTO L0101
L0098:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0102
; 336: 				If speed_min > speed_max Then
	MOVF 0x3B,W
	MOVWF R0L
	MOVF 0x3C,W
	MOVWF R0H
	MOVF 0x39,W
	MOVWF R1L
	MOVF 0x3A,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0103
; 337: 					speed_min = speed_min - 256
	MOVLW 0x00
	SUBWF 0x3B,W
	MOVWF 0x3B
	MOVLW 0x01
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3C,W
	MOVWF 0x3C
; 338: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0104:	BTFSC EECON1,WR
	GOTO L0104
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 339: 				Endif
L0103:
; 340: 			Case Else
	BCF PCLATH,3
	GOTO L0105
L0102:
; 341: 			EndSelect
L0105:
L0101:
; 342: 		Case 5  'setting of speed interval Maximum
	BCF PCLATH,3
	GOTO L0106
L0097:
	MOVF 0x43,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0107
; 343: 					'setting will be done in multiple of 256 uSecs
; 344: 					'minimum is 1 and maximum is 99 (is real slow)
; 345: 			steps_set = 0
	BCF 0x44,0
; 346: 			ena = 0  'shut off motor
	BCF 0x07,2
; 347: 			value = speed_max.HB
	MOVF 0x3A,W
	MOVWF 0x31
; 348: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 349: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 350: 			Select Case result
; 351: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0108
; 352: 				If speed_max.HB < speed_min.HB Then  'not more then speed_min
	MOVF 0x3C,W
	SUBWF 0x3A,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0109
; 353: 					speed_max.HB = speed_max.HB + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
; 354: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0110:	BTFSC EECON1,WR
	GOTO L0110
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 355: 				Endif
L0109:
; 356: 			Case 2
	BCF PCLATH,3
	GOTO L0111
L0108:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0112
; 357: 				If speed_max.HB > 1 Then
	MOVF 0x3A,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0113
; 358: 					speed_max.HB = speed_max.HB - 1
	MOVLW 0x01
	SUBWF 0x3A,W
	MOVWF 0x3A
; 359: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3A,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0114:	BTFSC EECON1,WR
	GOTO L0114
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 360: 				Endif
L0113:
; 361: 			Case Else
	BCF PCLATH,3
	GOTO L0115
L0112:
; 362: 			EndSelect
L0115:
L0111:
; 363: 		Case 6  'setting of ramp up and down speed
	BCF PCLATH,3
	GOTO L0116
L0107:
	MOVF 0x43,W
	SUBLW 0x06
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0117
; 364: 					'speed will be the value that speed will be changed every step up and down
; 365: 			steps_set = 0
	BCF 0x44,0
; 366: 			ena = 0  'shut off motor
	BCF 0x07,2
; 367: 			value = speed_step
	MOVF 0x42,W
	MOVWF 0x31
; 368: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 369: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 370: 			Select Case result
; 371: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0118
; 372: 				If speed_step < 99 Then  'maximum 99 is possible
	MOVLW 0x63
	SUBWF 0x42,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0119
; 373: 					speed_step = speed_step + 1
	MOVF 0x42,W
	ADDLW 0x01
	MOVWF 0x42
; 374: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0120:	BTFSC EECON1,WR
	GOTO L0120
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 375: 				Endif
L0119:
; 376: 			Case 2
	BCF PCLATH,3
	GOTO L0121
L0118:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0122
; 377: 				If speed_step > 1 Then
	MOVF 0x42,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0123
; 378: 					speed_step = speed_step - 1
	MOVLW 0x01
	SUBWF 0x42,W
	MOVWF 0x42
; 379: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0124:	BTFSC EECON1,WR
	GOTO L0124
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 380: 				Endif
L0123:
; 381: 			Case Else
	BCF PCLATH,3
	GOTO L0125
L0122:
; 382: 			EndSelect
L0125:
L0121:
; 383: 	
; 384: 		Case Else  'setting of extra free space steps
	BCF PCLATH,3
	GOTO L0126
L0117:
; 385: 			steps_set = 0
	BCF 0x44,0
; 386: 			ena = 0  'shut off motor
	BCF 0x07,2
; 387: 			If free_space_steps > 250 Then
	MOVF 0x3F,W
	SUBLW 0xFA
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0127
; 388: 				free_space_steps = 250
	MOVLW 0xFA
	MOVWF 0x3F
; 389: 				Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0128:	BTFSC EECON1,WR
	GOTO L0128
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 390: 			Endif
L0127:
; 391: 			value = free_space_steps
	MOVF 0x3F,W
	MOVWF 0x31
; 392: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 393: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 394: 			Select Case result
; 395: 			Case 1
	MOVF 0x3E,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0129
; 396: 				If free_space_steps < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x3F,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0130
; 397: 					free_space_steps = free_space_steps + 1
	MOVF 0x3F,W
	ADDLW 0x01
	MOVWF 0x3F
; 398: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0131:	BTFSC EECON1,WR
	GOTO L0131
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 399: 				Endif
L0130:
; 400: 			Case 2
	BCF PCLATH,3
	GOTO L0132
L0129:
	MOVF 0x3E,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0133
; 401: 				If free_space_steps > 0 Then
	MOVF 0x3F,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0134
; 402: 					free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x3F,W
	MOVWF 0x3F
; 403: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0135:	BTFSC EECON1,WR
	GOTO L0135
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 404: 				Endif
L0134:
; 405: 			Case Else
	BCF PCLATH,3
	GOTO L0136
L0133:
; 406: 			EndSelect
L0136:
L0132:
; 407: 		EndSelect
L0126:
L0116:
L0106:
L0096:
L0084:
L0074:
; 408: 	Wend
	BCF PCLATH,3
	GOTO L0052
L0053:
; 409: 	ena = 0  'shut off motor
	BCF 0x07,2
; 410: 		'***************   now check if changes have to BE written in eeprom
; 411: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	MOVF 0x45,W
	MOVWF R1L
	MOVF 0x46,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C002
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0137
; 412: 		Gosub save_steps
	BSF PCLATH,3
	CALL L0013
; 413: 	Endif
L0137:
; 414: 	value = act_pos
	MOVF 0x30,W
	MOVWF 0x31
; 415: 	Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 416: 	onoff = 1
	BSF 0x44,1
; 417: 	Gosub relays
	BSF PCLATH,3
	CALL L0009
; 418: Return
	RETURN
; 419: 
; 420: i2c_display:
L0005:
; 421: 	disp1_val = value
	MOVF 0x31,W
	MOVWF 0x47
; 422: 	disp1_val = disp1_val Mod 10
	MOVF 0x47,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x47
; 423: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x47,W
	SUBLW 0x09
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0138
	BCF PCLATH,3
	CALL L0139
	MOVWF 0x47
	BCF PCLATH,3
	GOTO L0138
L0139:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x47,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
L0138:
; 424: 	disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x47,7
	BTFSS 0x07,7
	BCF 0x47,7
; 425: 	disp2_val = value
	MOVF 0x31,W
	MOVWF 0x4E
; 426: 	disp2_val = disp2_val / 10
	MOVF 0x4E,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4E
; 427: 	disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x4E,W
	SUBLW 0x0A
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0140
	BCF PCLATH,3
	CALL L0141
	MOVWF 0x4E
	BCF PCLATH,3
	GOTO L0140
L0141:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x4E,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
L0140:
; 428: 	disp2_val.7 = version
	BTFSC 0x44,3
	BSF 0x4E,7
	BTFSS 0x44,3
	BCF 0x4E,7
; 429: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 430: 	I2CSend disp1
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 431: 	I2CSend disp1_val
	BCF PCLATH,3
	MOVF 0x47,W
	CALL IC01
; 432: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 433: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 434: 	I2CSend disp2
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 435: 	I2CSend disp2_val
	BCF PCLATH,3
	MOVF 0x4E,W
	CALL IC01
; 436: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 437: Return
	RETURN
; 438: 
; 439: i2c_display_pgm:
L0006:
; 440: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000), program_set
	MOVF 0x43,W
	SUBLW 0x07
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0142
	BCF PCLATH,3
	CALL L0143
	MOVWF 0x47
	BCF PCLATH,3
	GOTO L0142
L0143:
	MOVLW 0x05
	MOVWF PCLATH
	MOVF 0x43,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
L0142:
; 441: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 442: 	I2CSend disp1
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 443: 	I2CSend disp1_val
	BCF PCLATH,3
	MOVF 0x47,W
	CALL IC01
; 444: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 445: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 446: 	I2CSend disp2
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 447: 	I2CSend %10111111
	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 448: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 449: Return
	RETURN
; 450: 
; 451: stepmotor:
L0007:
; 452: 	speed = 0
	CLRF 0x4C
	CLRF 0x4D
; 453: 	Gosub steps_reading
	BSF PCLATH,3
	CALL L0012
; 454: 	If new_steps = 0 Then
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C001
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0144
; 455: 		direction = 0
	BCF 0x07,0
; 456: 		ena = 1  'set anable on
	BSF 0x07,2
; 457: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 458: 		While zero = 1  'turn motor until zero switch is activated
L0145:
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0146
; 459: 			clk = 1  'clock out
	BSF 0x07,1
; 460: 			WaitUs speed_max
	MOVF 0x39,W
	MOVWF R4L
	MOVF 0x3A,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 461: 			clk = 0
	BCF 0x07,1
; 462: 			WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 463: 		Wend
	BCF PCLATH,3
	GOTO L0145
L0146:
; 464: 		act_pos = 0
	CLRF 0x30
; 465: 		Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0147:	BTFSC EECON1,WR
	GOTO L0147
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 466: 		Select Case ctrl_type
; 467: 		Case 2, 3, 4, 5  'NOW GO ONE MORE COMPLETE ROUND FOR COUNTING STEPS
	MOVF 0x32,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0150
	BCF PCLATH,3
	GOTO L0149
L0150:
	MOVF 0x32,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0151
	BCF PCLATH,3
	GOTO L0149
L0151:
	MOVF 0x32,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0152
	BCF PCLATH,3
	GOTO L0149
L0152:
	MOVF 0x32,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0148
L0149:
; 468: 			one_round = 0
	CLRF 0x37
	CLRF 0x38
; 469: 			ena = 1  'set anable on
	BSF 0x07,2
; 470: 			While zero = 0  'turn motor until zero switch is DISactivated
L0153:
	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0154
; 471: 				clk = 1  'clock out
	BSF 0x07,1
; 472: 				WaitUs speed_max
	MOVF 0x39,W
	MOVWF R4L
	MOVF 0x3A,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 473: 				clk = 0
	BCF 0x07,1
; 474: 				one_round = one_round + 1
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x37
	MOVF 0x38,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x38
; 475: 				WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 476: 			Wend
	BCF PCLATH,3
	GOTO L0153
L0154:
; 477: 			For value = 1 To 100  'SOME MORE STEPS TO AVOID CONTACT DENDER.
	MOVLW 0x01
	MOVWF 0x31
L0155:
	MOVF 0x31,W
	SUBLW 0x64
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0156
; 478: 				clk = 1  'clock out
	BSF 0x07,1
; 479: 				WaitUs speed_max
	MOVF 0x39,W
	MOVWF R4L
	MOVF 0x3A,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 480: 				clk = 0
	BCF 0x07,1
; 481: 				WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 482: 				one_round = one_round + 1
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x37
	MOVF 0x38,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x38
; 483: 			Next value
	MOVLW 0x01
	ADDWF 0x31,F
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0155
L0156:
; 484: 			While zero = 1  'turn motor until zero switch is activated
L0157:
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0158
; 485: 				clk = 1  'clock out
	BSF 0x07,1
; 486: 				WaitUs speed_max
	MOVF 0x39,W
	MOVWF R4L
	MOVF 0x3A,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 487: 				clk = 0
	BCF 0x07,1
; 488: 				WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 489: 				one_round = one_round + 1
	MOVF 0x37,W
	ADDLW 0x01
	MOVWF 0x37
	MOVF 0x38,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x38
; 490: 			Wend
	BCF PCLATH,3
	GOTO L0157
L0158:
; 491: 			one_round_half = one_round / 2
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x54
	MOVF R0H,W
	MOVWF 0x55
; 492: 			Write mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0159:	BTFSC EECON1,WR
	GOTO L0159
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 493: 			Write mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0160:	BTFSC EECON1,WR
	GOTO L0160
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 494: 			act_pos = 0
	CLRF 0x30
; 495: 			Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0161:	BTFSC EECON1,WR
	GOTO L0161
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 496: 		Case Else
	BCF PCLATH,3
	GOTO L0162
L0148:
; 497: 			act_pos = 0
	CLRF 0x30
; 498: 			Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0163:	BTFSC EECON1,WR
	GOTO L0163
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 499: 		EndSelect
L0162:
; 500: 		ena = 0  'set anable off
	BCF 0x07,2
; 501: 	Else  'this is the normal position sequence
	BSF PCLATH,3
	GOTO L0164
L0144:
; 502: 		steps = 0
	CLRF 0x33
	CLRF 0x34
; 503: 		If new_steps > act_steps Then
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	MOVF 0x45,W
	MOVWF R1L
	MOVF 0x46,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0165
; 504: 			steps = new_steps - act_steps
	MOVF 0x45,W
	SUBWF 0x35,W
	MOVWF 0x33
	MOVF 0x46,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x36,W
	MOVWF 0x34
; 505: 			direction = 1
	BSF 0x07,0
; 506: 			If steps > one_round_half Then  'is other direction shorter?
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x54,W
	MOVWF R1L
	MOVF 0x55,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0166
; 507: 				Select Case ctrl_type
; 508: 				Case 2, 3
	MOVF 0x32,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0169
	BCF PCLATH,3
	GOTO L0168
L0169:
	MOVF 0x32,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0167
L0168:
; 509: 					If ctrl_type > 1 Then  'check If short way is set
	MOVF 0x32,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0170
; 510: 						Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 511: 						If turn_counter > 126 Then  'check if shortest way is allowed
	MOVF 0x40,W
	SUBLW 0x7E
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0171
; 512: 							turn_counter = turn_counter - 1  'yes it is, so substract one pass
	MOVLW 0x01
	SUBWF 0x40,W
	MOVWF 0x40
; 513: 							steps = one_round - steps  'go shortest way
	MOVF 0x33,W
	SUBWF 0x37,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x38,W
	MOVWF 0x34
; 514: 							direction = 0  'change  direction
	BCF 0x07,0
; 515: 							Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0172:	BTFSC EECON1,WR
	GOTO L0172
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 516: 						Endif
L0171:
; 517: 					Endif
L0170:
; 518: 				Case 4, 5  'type with contact sliders, no twisting cables
	BCF PCLATH,3
	GOTO L0173
L0167:
	MOVF 0x32,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0176
	BCF PCLATH,3
	GOTO L0175
L0176:
	MOVF 0x32,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0174
L0175:
; 519: 					steps = one_round - steps
	MOVF 0x33,W
	SUBWF 0x37,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x38,W
	MOVWF 0x34
; 520: 					direction = 0
	BCF 0x07,0
; 521: 				Case Else  'no short way possible
	BCF PCLATH,3
	GOTO L0177
L0174:
; 522: 				EndSelect
L0177:
L0173:
; 523: 			Endif
L0166:
; 524: 		Else
	BSF PCLATH,3
	GOTO L0178
L0165:
; 525: 			steps = act_steps - new_steps
	MOVF 0x35,W
	SUBWF 0x45,W
	MOVWF 0x33
	MOVF 0x36,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x46,W
	MOVWF 0x34
; 526: 			direction = 0
	BCF 0x07,0
; 527: 			If steps > one_round_half Then  'other direction shorter?
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x54,W
	MOVWF R1L
	MOVF 0x55,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0179
; 528: 				Select Case ctrl_type
; 529: 				Case 2, 3  'cable connected bridges
	MOVF 0x32,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0182
	BCF PCLATH,3
	GOTO L0181
L0182:
	MOVF 0x32,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0180
L0181:
; 530: 					Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 531: 					If turn_counter < 130 Then  'check if shortest way is allowed
	MOVLW 0x82
	SUBWF 0x40,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0183
; 532: 						turn_counter = turn_counter + 1  'yes it is, so add one pass
	MOVF 0x40,W
	ADDLW 0x01
	MOVWF 0x40
; 533: 						steps = one_round - steps  'go shortest way
	MOVF 0x33,W
	SUBWF 0x37,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x38,W
	MOVWF 0x34
; 534: 						direction = 1  'change direction
	BSF 0x07,0
; 535: 						Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0184:	BTFSC EECON1,WR
	GOTO L0184
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 536: 					Endif
L0183:
; 537: 				Case 4, 5  'type with contact sliders, no twisting cables
	BSF PCLATH,3
	GOTO L0185
L0180:
	MOVF 0x32,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0188
	BSF PCLATH,3
	GOTO L0187
L0188:
	MOVF 0x32,W
	SUBLW 0x05
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0186
L0187:
; 538: 					steps = one_round - steps
	MOVF 0x33,W
	SUBWF 0x37,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x38,W
	MOVWF 0x34
; 539: 					direction = 1
	BSF 0x07,0
; 540: 				Case Else  'no short way possible
	BSF PCLATH,3
	GOTO L0189
L0186:
; 541: 				EndSelect
L0189:
L0185:
; 542: 			Endif
L0179:
; 543: 		Endif
L0178:
; 544: 		If steps > 0 Then  'motor must be activated
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0190
; 545: 			If direction = 1 Then
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0191
; 546: 				steps = steps + free_space_steps
	MOVF 0x33,W
	ADDWF 0x3F,W
	MOVWF 0x33
	MOVF 0x34,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x34
; 547: 			Endif
L0191:
; 548: 			ramp_up = 1
	BSF 0x44,2
; 549: 			ramp_down_point = 0
	CLRF 0x52
	CLRF 0x53
; 550: 			half_steps = steps / 2
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x57
	MOVF R0H,W
	MOVWF 0x58
; 551: 			speed = speed_min
	MOVF 0x3B,W
	MOVWF 0x4C
	MOVF 0x3C,W
	MOVWF 0x4D
; 552: 			ena = 1  'set anable on
	BSF 0x07,2
; 553: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 554: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0192:
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0193
; 555: 				If max_end = 0 Then
	BSF PCLATH,3
	BTFSC 0x06,7
	GOTO L0194
; 556: 					Gosub stop_the_motor
	BSF PCLATH,3
	CALL L0014
; 557: 				Endif
L0194:
; 558: 				clk = 1  'clock out
	BSF 0x07,1
; 559: 				WaitUs speed
	MOVF 0x4C,W
	MOVWF R4L
	MOVF 0x4D,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 560: 				clk = 0
	BCF 0x07,1
; 561: 				Gosub speed_calc
	BSF PCLATH,3
	CALL L0008
; 562: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 563: 			Wend
	BSF PCLATH,3
	GOTO L0192
L0193:
; 564: 			WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 565: 			If direction = 1 Then
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0195
; 566: 				steps = free_space_steps
	MOVF 0x3F,W
	MOVWF 0x33
	CLRF 0x34
; 567: 				direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 568: 				While steps > 0  'NOW RUN UNTIL STEPS = 0
L0196:
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0197
; 569: 					If max_end = 0 Then
	BSF PCLATH,3
	BTFSC 0x06,7
	GOTO L0198
; 570: 						Gosub stop_the_motor
	BSF PCLATH,3
	CALL L0014
; 571: 					Endif
L0198:
; 572: 					clk = 1  'clock out
	BSF 0x07,1
; 573: 					WaitUs speed_min
	MOVF 0x3B,W
	MOVWF R4L
	MOVF 0x3C,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 574: 					clk = 0
	BCF 0x07,1
; 575: 					steps = steps - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
; 576: 					WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 577: 				Wend
	BSF PCLATH,3
	GOTO L0196
L0197:
; 578: 			Endif
L0195:
; 579: 			ena = 0  'enable off
	BCF 0x07,2
; 580: 		Endif
L0190:
; 581: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 582: 	Endif
L0164:
; 583: 	act_pos = new_pos
	MOVF 0x4B,W
	MOVWF 0x30
; 584: 	Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0199:	BTFSC EECON1,WR
	GOTO L0199
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 585: 	bus_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x48
; 586: 	old_bus_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x56
; 587: 	manual_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x41
; 588: 	old_manual_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x51
; 589: Return
	RETURN
; 590: 
; 591: 
; 592: speed_calc:
L0008:
; 593: 	If steps < half_steps Then  'at this point  ramp up MUST end
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x57,W
	MOVWF R1L
	MOVF 0x58,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0200
; 594: 		ramp_up = 0
	BCF 0x44,2
; 595: 	Endif
L0200:
; 596: 	If ramp_up = 1 Then  'we were supposed to ramp up
	BSF PCLATH,3
	BTFSS 0x44,2
	GOTO L0201
; 597: 		If speed > speed_max Then
	MOVF 0x4C,W
	MOVWF R0L
	MOVF 0x4D,W
	MOVWF R0H
	MOVF 0x39,W
	MOVWF R1L
	MOVF 0x3A,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0202
; 598: 			speed = speed - speed_step
	MOVF 0x42,W
	SUBWF 0x4C,W
	MOVWF 0x4C
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x4D,W
	MOVWF 0x4D
; 599: 			ramp_down_point = ramp_down_point + 1  'this counts down with the steps
	MOVF 0x52,W
	ADDLW 0x01
	MOVWF 0x52
	MOVF 0x53,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x53
; 600: 		Else
	BSF PCLATH,3
	GOTO L0203
L0202:
; 601: 			ramp_up = 0
	BCF 0x44,2
; 602: 		Endif
L0203:
; 603: 	Else
	BSF PCLATH,3
	GOTO L0204
L0201:
; 604: 		If steps < ramp_down_point Then  'this is the point tot start ramp down
	MOVF 0x33,W
	MOVWF R0L
	MOVF 0x34,W
	MOVWF R0H
	MOVF 0x52,W
	MOVWF R1L
	MOVF 0x53,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0205
; 605: 			If speed < speed_min Then
	MOVF 0x4C,W
	MOVWF R0L
	MOVF 0x4D,W
	MOVWF R0H
	MOVF 0x3B,W
	MOVWF R1L
	MOVF 0x3C,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0206
; 606: 				speed = speed + speed_step
	MOVF 0x4C,W
	ADDWF 0x42,W
	MOVWF 0x4C
	MOVF 0x4D,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x4D
; 607: 			Endif
L0206:
; 608: 		Endif
L0205:
; 609: 	Endif
L0204:
; 610: Return
	RETURN
; 611: 
; 612: 
; 613: relays:
L0009:
; 614: 	If onoff = 1 Then
	BSF PCLATH,3
	BTFSS 0x44,1
	GOTO L0207
; 615: 		value = max_pos + 1
	MOVF 0x3D,W
	ADDLW 0x01
	MOVWF 0x31
; 616: 		value = value / 2  'calulation of half max positions
	MOVF 0x31,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x31
; 617: 		Select Case ctrl_type
; 618: 		Case 1, 3, 5, 6
	MOVF 0x32,W
	SUBLW 0x01
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0210
	BSF PCLATH,3
	GOTO L0209
L0210:
	MOVF 0x32,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0211
	BSF PCLATH,3
	GOTO L0209
L0211:
	MOVF 0x32,W
	SUBLW 0x05
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0212
	BSF PCLATH,3
	GOTO L0209
L0212:
	MOVF 0x32,W
	SUBLW 0x06
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0208
L0209:
; 619: 			swfw = 0
	BCF 0x06,0
; 620: 			swrev = 1
	BSF 0x06,1
; 621: 		Case Else
	BSF PCLATH,3
	GOTO L0213
L0208:
; 622: 			If act_pos > value Then  'select polarity rails on bridge
	MOVF 0x30,W
	SUBWF 0x31,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0214
; 623: 				swfw = 0
	BCF 0x06,0
; 624: 				swrev = 1
	BSF 0x06,1
; 625: 			Else
	BSF PCLATH,3
	GOTO L0215
L0214:
; 626: 				swrev = 0
	BCF 0x06,1
; 627: 				swfw = 1
	BSF 0x06,0
; 628: 			Endif
L0215:
; 629: 		EndSelect
L0213:
; 630: 	Else
	BSF PCLATH,3
	GOTO L0216
L0207:
; 631: 		swfw = 0
	BCF 0x06,0
; 632: 		swrev = 0
	BCF 0x06,1
; 633: 	Endif
L0216:
; 634: Return
	RETURN
; 635: 
; 636: 
; 637: init_eeprom:
L0010:
; 638: 	If pgm = 0 Then  'special for my own fiddle yard
	BSF PCLATH,3
	BTFSC 0x07,7
	GOTO L0217
; 639: 		new_steps = 178
	MOVLW 0xB2
	MOVWF 0x35
	CLRF 0x36
; 640: 		For act_pos = 1 To 12
	MOVLW 0x01
	MOVWF 0x30
L0218:
	MOVF 0x30,W
	SUBLW 0x0C
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0219
; 641: 			Gosub save_steps
	BSF PCLATH,3
	CALL L0013
; 642: 			new_steps = new_steps + 4300
	MOVF 0x35,W
	ADDLW 0xCC
	MOVWF 0x35
	MOVF 0x36,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x10
	MOVWF 0x36
; 643: 		Next act_pos
	MOVLW 0x01
	ADDWF 0x30,F
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0218
L0219:
; 644: 		Write mem_max_pos, 12
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x0C
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0220:	BTFSC EECON1,WR
	GOTO L0220
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 645: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x3D
; 646: 	Else
	BSF PCLATH,3
	GOTO L0221
L0217:
; 647: 		new_steps = 0
	CLRF 0x35
	CLRF 0x36
; 648: 		For act_pos = 1 To max_pos
	MOVLW 0x01
	MOVWF 0x30
L0222:
	MOVF 0x30,W
	SUBWF 0x3D,W
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0223
; 649: 			steps = one_round / max_pos  'devide the steps between min and max
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	MOVF 0x3D,W
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x33
	MOVF R0H,W
	MOVWF 0x34
; 650: 			new_steps = new_steps + steps
	MOVF 0x35,W
	ADDWF 0x33,W
	MOVWF 0x35
	MOVF 0x36,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x34,W
	MOVWF 0x36
; 651: 			Gosub save_steps
	BSF PCLATH,3
	CALL L0013
; 652: 		Next act_pos
	MOVLW 0x01
	ADDWF 0x30,F
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0222
L0223:
; 653: 	Endif
L0221:
; 654: 	free_space_steps = 20
	MOVLW 0x14
	MOVWF 0x3F
; 655: 	Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3F,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0224:	BTFSC EECON1,WR
	GOTO L0224
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 656: 	one_round = 8000
	MOVLW 0x40
	MOVWF 0x37
	MOVLW 0x1F
	MOVWF 0x38
; 657: 	Write mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0225:	BTFSC EECON1,WR
	GOTO L0225
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 658: 	Write mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0226:	BTFSC EECON1,WR
	GOTO L0226
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 659: 	act_pos = 1
	MOVLW 0x01
	MOVWF 0x30
; 660: 	Write mem_act_pos, 1  'act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x01
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0227:	BTFSC EECON1,WR
	GOTO L0227
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 661: Return
	RETURN
; 662: 
; 663: init_values:
L0011:
; 664: 	value = 41  'version number
	MOVLW 0x29
	MOVWF 0x31
; 665: 	version = 0  'decimal point in display on
	BCF 0x44,3
; 666: 	Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 667: 	WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 668: 	version = 1  'decimal point in display off
	BSF 0x44,3
; 669: 	encoder_count = 0
	CLRF 0x4A
; 670: 	speed_min = 0
	CLRF 0x3B
	CLRF 0x3C
; 671: 	Read mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3C
; 672: 	If speed_min.HB > 99 Then
	MOVF 0x3C,W
	SUBLW 0x63
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0228
; 673: 		speed_min.HB = 40
	MOVLW 0x28
	MOVWF 0x3C
; 674: 	Else
	BSF PCLATH,3
	GOTO L0229
L0228:
; 675: 		If speed_min.HB < 1 Then
	MOVLW 0x01
	SUBWF 0x3C,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0230
; 676: 			speed_min.HB = 40
	MOVLW 0x28
	MOVWF 0x3C
; 677: 		Endif
L0230:
; 678: 	Endif
L0229:
; 679: 	speed_max = 0
	CLRF 0x39
	CLRF 0x3A
; 680: 	Read mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3A
; 681: 	If speed_max.HB > speed_min.HB Then
	MOVF 0x3A,W
	SUBWF 0x3C,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0231
; 682: 		speed_max.HB = speed_min.HB
	MOVF 0x3C,W
	MOVWF 0x3A
; 683: 	Else
	BSF PCLATH,3
	GOTO L0232
L0231:
; 684: 		If speed_max.HB < 1 Then
	MOVLW 0x01
	SUBWF 0x3A,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0233
; 685: 			speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x3A
; 686: 		Endif
L0233:
; 687: 	Endif
L0232:
; 688: 
; 689: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 690: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x38
; 691: 	If one_round = 0 Then
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C001
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0234
; 692: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x37
	MOVLW 0x1F
	MOVWF 0x38
; 693: 	Endif
L0234:
; 694: 	If one_round > 60000 Then
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0235
; 695: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x37
	MOVLW 0x1F
	MOVWF 0x38
; 696: 	Endif
L0235:
; 697: 	one_round_half = one_round / 2
	MOVF 0x37,W
	MOVWF R0L
	MOVF 0x38,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x54
	MOVF R0H,W
	MOVWF 0x55
; 698: 
; 699: 	Read mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3D
; 700: 	If max_pos > 48 Then
	MOVF 0x3D,W
	SUBLW 0x30
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0236
; 701: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x3D
; 702: 	Endif
L0236:
; 703: 	Read mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 704: 	If act_pos > max_pos Then
	MOVF 0x30,W
	SUBWF 0x3D,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0237
; 705: 		act_pos = 1
	MOVLW 0x01
	MOVWF 0x30
; 706: 	Endif
L0237:
; 707: 	Read mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3F
; 708: 	If free_space_steps > 99 Then
	MOVF 0x3F,W
	SUBLW 0x63
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0238
; 709: 		free_space_steps = 50
	MOVLW 0x32
	MOVWF 0x3F
; 710: 	Endif
L0238:
; 711: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x32
; 712: 	If ctrl_type > 6 Then
	MOVF 0x32,W
	SUBLW 0x06
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0239
; 713: 		ctrl_type = 6
	MOVLW 0x06
	MOVWF 0x32
; 714: 	Endif
L0239:
; 715: 
; 716: 	Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 717: 	If turn_counter > 131 Then  'in program impossible value
	MOVF 0x40,W
	SUBLW 0x83
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0240
; 718: 		turn_counter = 128
	MOVLW 0x80
	MOVWF 0x40
; 719: 	Else
	BSF PCLATH,3
	GOTO L0241
L0240:
; 720: 		If turn_counter < 125 Then  'in program impossible value
	MOVLW 0x7D
	SUBWF 0x40,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0242
; 721: 			turn_counter = 128
	MOVLW 0x80
	MOVWF 0x40
; 722: 		Endif
L0242:
; 723: 	Endif
L0241:
; 724: 	
; 725: 	Read mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x42
; 726: 	If speed_step > 99 Then
	MOVF 0x42,W
	SUBLW 0x63
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0243
; 727: 		speed_step = 20
	MOVLW 0x14
	MOVWF 0x42
; 728: 	Endif
L0243:
; 729: 	
; 730: 	If eep = 1 Then  'jumper set for initialisation
	BSF PCLATH,3
	BTFSS 0x06,6
	GOTO L0244
; 731: 		Gosub init_eeprom
	BSF PCLATH,3
	CALL L0010
; 732: 	Endif
L0244:
; 733: 	steps_set = 0
	BCF 0x44,0
; 734: 	new_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x4B
; 735: 	bus_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x48
; 736: 	old_bus_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x56
; 737: 	manual_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x41
; 738: 	old_manual_pos = act_pos
	MOVF 0x30,W
	MOVWF 0x51
; 739: Return
	RETURN
; 740: 
; 741: steps_reading:
L0012:
; 742: 	If act_pos = 0 Then
	MOVF 0x30,W
	SUBLW 0x00
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0245
; 743: 		act_steps = 0
	CLRF 0x45
	CLRF 0x46
; 744: 	Else
	BSF PCLATH,3
	GOTO L0246
L0245:
; 745: 		eprom_pointer = act_pos + 48
	MOVF 0x30,W
	ADDLW 0x30
	MOVWF 0x4F
; 746: 		Read act_pos, act_steps.LB
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x45
; 747: 		Read eprom_pointer, act_steps.HB
	MOVF 0x4F,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x46
; 748: 	Endif
L0246:
; 749: 	If new_pos = 0 Then
	MOVF 0x4B,W
	SUBLW 0x00
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0247
; 750: 		new_steps = 0
	CLRF 0x35
	CLRF 0x36
; 751: 	Else
	BSF PCLATH,3
	GOTO L0248
L0247:
; 752: 		eprom_pointer = new_pos + 48
	MOVF 0x4B,W
	ADDLW 0x30
	MOVWF 0x4F
; 753: 		Read new_pos, new_steps.LB
	MOVF 0x4B,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x35
; 754: 		Read eprom_pointer, new_steps.HB
	MOVF 0x4F,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 755: 	Endif
L0248:
; 756: Return
	RETURN
; 757: 
; 758: 
; 759: save_steps:
L0013:
; 760: 	eprom_pointer = act_pos + 48
	MOVF 0x30,W
	ADDLW 0x30
	MOVWF 0x4F
; 761: 	Write act_pos, new_steps.LB
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x35,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0249:	BTFSC EECON1,WR
	GOTO L0249
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 762: 	Write eprom_pointer, new_steps.HB
	MOVF 0x4F,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0250:	BTFSC EECON1,WR
	GOTO L0250
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 763: Return
	RETURN
; 764: 
; 765: stop_the_motor:
L0014:
; 766: 	While ecsw = 1
L0251:
	BSF PCLATH,3
	BTFSS 0x07,6
	GOTO L0252
; 767: 		WaitMs 250
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 768: 	Wend
	BSF PCLATH,3
	GOTO L0251
L0252:
; 769: Return
	RETURN
; End of program
	BSF PCLATH,3
L0253:	GOTO L0253
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
