; Compiled with: PIC Simulator IDE v6.90
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_turn_counter' (global) is 101
;       The value of 'mem_act_pos' (global) is 102
;       The value of 'mem_speed_min' (global) is 103
;       The value of 'mem_speed_max' (global) is 104
;       The value of 'mem_speed_step' (global) is 105
;       The value of 'mem_one_round_lb' (global) is 106
;       The value of 'mem_one_round_hb' (global) is 107
;       The value of 'mem_ctrl_type' (global) is 108
;       The value of 'mem_max_pos' (global) is 109
;       The value of 'mem_free_space' (global) is 110
;       The value of 'mem_bridge_power' (global) is 112
;       The value of 'mem_bridge_switch1' (global) is 113
;       The value of 'mem_bridge_switch2' (global) is 114
;       The value of 'mem_bridge_switch3' (global) is 115
;       The value of 'mem_bridge_switch4' (global) is 116
;       The value of 'mem_bridge_switch5' (global) is 117
;       The value of 'mem_bridge_switch6' (global) is 118
;       The address of 'value' (byte) (global) is 0x30
	value EQU 0x30
;       The address of 'act_pos' (byte) (global) is 0x31
	act_pos EQU 0x31
;       The address of 'ctrl_type' (byte) (global) is 0x32
	ctrl_type EQU 0x32
;       The address of 'max_pos' (byte) (global) is 0x33
	max_pos EQU 0x33
;       The address of 'steps' (word) (global) is 0x34
	steps EQU 0x34
;       The address of 'new_steps' (word) (global) is 0x36
	new_steps EQU 0x36
;       The address of 'one_round' (word) (global) is 0x38
	one_round EQU 0x38
;       The address of 'speed_max' (word) (global) is 0x3A
	speed_max EQU 0x3A
;       The address of 'speed_min' (word) (global) is 0x3C
	speed_min EQU 0x3C
;       The address of 'bridge_switch' (bit) (global) is 0x3E,0
;       The address of 'result' (byte) (global) is 0x3F
	result EQU 0x3F
;       The address of 'turn_counter' (byte) (global) is 0x40
	turn_counter EQU 0x40
;       The address of 'manual_pos' (byte) (global) is 0x41
	manual_pos EQU 0x41
;       The address of 'free_space_steps' (byte) (global) is 0x42
	free_space_steps EQU 0x42
;       The address of 'value2' (byte) (global) is 0x43
	value2 EQU 0x43
;       The address of 'program_set' (byte) (global) is 0x44
	program_set EQU 0x44
;       The address of 'speed_step' (byte) (global) is 0x45
	speed_step EQU 0x45
;       The address of 'steps_set' (bit) (global) is 0x3E,1
;       The address of 'act_steps' (word) (global) is 0x46
	act_steps EQU 0x46
;       The address of 'disp1_val' (byte) (global) is 0x48
	disp1_val EQU 0x48
;       The address of 'new_encoder' (byte) (global) is 0x49
	new_encoder EQU 0x49
;       The address of 'encoder_count' (byte) (global) is 0x4A
	encoder_count EQU 0x4A
;       The address of 'new_pos' (byte) (global) is 0x4B
	new_pos EQU 0x4B
;       The address of 'bus_pos' (byte) (global) is 0x4C
	bus_pos EQU 0x4C
;       The address of 'speed' (word) (global) is 0x4D
	speed EQU 0x4D
;       The address of 'onoff' (bit) (global) is 0x3E,2
;       The address of 'disp2_val' (byte) (global) is 0x4F
	disp2_val EQU 0x4F
;       The address of 'eprom_pointer' (byte) (global) is 0x50
	eprom_pointer EQU 0x50
;       The address of 'bridge_power' (bit) (global) is 0x3E,3
;       The address of 'old_encoder' (byte) (global) is 0x51
	old_encoder EQU 0x51
;       The address of 'old_manual_pos' (byte) (global) is 0x52
	old_manual_pos EQU 0x52
;       The address of 'ramp_up' (bit) (global) is 0x3E,4
;       The address of 'version' (bit) (global) is 0x3E,5
;       The address of 'ramp_down_point' (word) (global) is 0x53
	ramp_down_point EQU 0x53
;       The address of 'one_round_half' (word) (global) is 0x55
	one_round_half EQU 0x55
;       The address of 'old_bus_pos' (byte) (global) is 0x57
	old_bus_pos EQU 0x57
;       The address of 'old_pos_write' (bit) (global) is 0x3E,6
;       The address of 'free_space_word' (word) (global) is 0x58
	free_space_word EQU 0x58
;       The address of 'half_steps' (word) (global) is 0x5A
	half_steps EQU 0x5A
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'eep' (bit) (global) is 0x6,6
;       The address of 'max_end' (bit) (global) is 0x6,7
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x7,3
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
;       The address of 'fy_stop' (bit) (global) is 0x5,5
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0017
	ORG 0x0004
	RETFIE
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Byte
X001:	MOVLW 0x02
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
X002:	MOVLW 0x02
	SUBWF R4L,F
	NOP
	NOP
	NOP
	NOP
	BTFSS STATUS,C
	RETURN
	GOTO X002
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0017:
; 1: 'program TT for PCBoard MGV145
; 2: 'version V3-1  Fiddle Yard version, for turntables and fiddle yard
; 3: 'this version has all possibilities changeable by menue's.
; 4: 'V3-2 counter for twisting cables tored at eeprom pos zero.
; 5: 'the value of the counter can be anything between 125 and 131. 128 is zero point.
; 6: 'V3-3 eeprom startup improved. Reprogramming PIC can now be done without reprogramming data
; 7: 'V3.6 startup delayed, to avoid wrong positions
; 8: 'V3.7 extra separate positions for FY and TT with contact sliders.
; 9: '-----MGV50 input changed, ramp-up and ramp-down activated, including separate settings for min and max speed
; 10: 'V4.1 inital setting for FY, set pos 1 and pos 2 correct, rest will be automatic.
; 11: 'V4.4 initial setting freespace dafaults to 0.
; 12: '-    positions 0 and 63 are allowed from I/O input >>>> 63 will be seen as 0
; 13: '-    manual position setting can be turned through zero
; 14: 'V4.5 extra menu 8 for setting the first position where rail power should be reversed
; 15: 'V4.6 0 point will also control cable twist
; 16: 'V4.7 Fiddle yard (ctrl type 6) has only 5 selection lines.(max 30 positions , 31 = zero adjust)
; 17: '-    pos.req 6 is set as input, MGV50 should be set as block output
; 18: '-    the two connection rails in and out are connected to current detection
; 19: '-    any train on these tracks will give siganl,where FY will stop immediately (same as endswitch)
; 20: 'V4.8 Extra menu added for settings of reverse/not per position (only for 0,2,4 )
; 21: '-    These bits (bridge_switch) are stored and read in 6 bytes
; 22: 'V4.9 Free_space_steps multiplied by 10 , 990 correction steps available
; 23: '-    Positions are changed to 0-47
; 24: '-    Maximum positons can be as low as two
; 25: Define CONF_WORD = 0x3f72
; 26: Define CLOCK_FREQUENCY = 20
; 27: 'Define SIMULATION_WAITuS_VALUE = 1
; 28: Dim steps As Word
; 29: Dim half_steps As Word
; 30: Dim ramp_down_point As Word
; 31: Dim program_set As Byte
; 32: Dim new_steps As Word
; 33: Dim act_steps As Word
; 34: Dim new_pos As Byte
; 35: Dim act_pos As Byte
; 36: Dim one_round As Word
; 37: Dim one_round_half As Word
; 38: Dim bus_pos As Byte
; 39: Dim old_bus_pos As Byte
; 40: Dim speed As Word
; 41: Dim speed_min As Word
; 42: Dim speed_max As Word
; 43: Dim new_encoder As Byte
; 44: Dim old_encoder As Byte
; 45: Dim manual_pos As Byte
; 46: Dim old_manual_pos As Byte
; 47: Dim result As Byte
; 48: Dim free_space_steps As Byte
; 49: Dim free_space_word As Word
; 50: Dim value As Byte
; 51: Dim value2 As Byte
; 52: Dim eprom_pointer As Byte
; 53: Dim encoder_count As Byte
; 54: Dim turn_counter As Byte
; 55: Dim onoff As Bit
; 56: Dim max_pos As Byte
; 57: Dim disp1_val As Byte
; 58: Dim disp2_val As Byte
; 59: Dim ctrl_type As Byte
; 60: Dim old_pos_write As Bit
; 61: Dim ramp_up As Bit
; 62: Dim speed_step As Byte
; 63: Dim version As Bit
; 64: Dim steps_set As Bit
; 65: Dim bridge_power As Bit
; 66: Dim bridge_switch As Bit
; 67: Const disp1 = 64
; 68: Const disp2 = 66
; 69: Const mem_turn_counter = 101
; 70: Const mem_act_pos = 102
; 71: Const mem_speed_min = 103
; 72: Const mem_speed_max = 104
; 73: Const mem_speed_step = 105
; 74: Const mem_one_round_lb = 106
; 75: Const mem_one_round_hb = 107
; 76: Const mem_ctrl_type = 108
; 77: Const mem_max_pos = 109
; 78: Const mem_free_space = 110
; 79: 
; 80: Const mem_bridge_power = 112
; 81: Const mem_bridge_switch1 = 113
; 82: Const mem_bridge_switch2 = 114
; 83: Const mem_bridge_switch3 = 115
; 84: Const mem_bridge_switch4 = 116
; 85: Const mem_bridge_switch5 = 117
; 86: Const mem_bridge_switch6 = 118
; 87: Symbol swfw = RB0
; 88: Symbol swrev = RB1
; 89: Symbol sck = RB2
; 90: Symbol sda = RB3
; 91: Symbol pos_match = RB4
; 92: Symbol pos_write = RB5
; 93: Symbol eep = RB6
; 94: Symbol max_end = RB7
; 95: Symbol direction = RC0
; 96: Symbol clk = RC1
; 97: Symbol ena = RC2
; 98: Symbol zero = RC3
; 99: Symbol ec1 = RC4
; 100: Symbol ec2 = RC5
; 101: Symbol ecsw = RC6
; 102: Symbol pgm = RC7
; 103: Symbol fy_stop = RA5
; 104: ADCON1 = %0110
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 105: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 106: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 107: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 108: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 109: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 110: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 111: value = 49  'version number
	MOVLW 0x31
	MOVWF 0x30
; 112: Gosub init_values
	BSF PCLATH,3
	CALL L0011
; 113: value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 114: version = 1
	BSF 0x3E,5
; 115: Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 116: onoff = 1
	BSF 0x3E,2
; 117: Gosub relays
	BSF PCLATH,3
	CALL L0009
; 118: program_set = 1
	MOVLW 0x01
	MOVWF 0x44
; 119: main:
L0001:
; 120: 	If pgm = 0 Then
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0018
; 121: 		Gosub adjust_settings
	BCF PCLATH,3
	CALL L0004
; 122: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 123: 	Endif
L0018:
; 124: 
; 125: 	Gosub get_new_position
	BCF PCLATH,3
	CALL L0002
; 126: 	If bus_pos <> old_bus_pos Then
	MOVF 0x4C,W
	SUBWF 0x57,W
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0019
; 127: 		onoff = 0
	BCF 0x3E,2
; 128: 		Gosub relays
	BSF PCLATH,3
	CALL L0009
; 129: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 130: 		new_pos = bus_pos
	MOVF 0x4C,W
	MOVWF 0x4B
; 131: 		Gosub stepmotor
	BCF PCLATH,3
	CALL L0007
; 132: 		value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 133: 		Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 134: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 135: 		onoff = 1
	BSF 0x3E,2
; 136: 	Else
	BCF PCLATH,3
	GOTO L0020
L0019:
; 137: 		If ecsw = 0 Then  'only when knob is pushed
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0021
; 138: 			If manual_pos <> old_manual_pos Then
	MOVF 0x41,W
	SUBWF 0x52,W
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0022
; 139: 				onoff = 0
	BCF 0x3E,2
; 140: 				Gosub relays
	BSF PCLATH,3
	CALL L0009
; 141: 				pos_match = 1  'indicate not in position
	BSF 0x06,4
; 142: 				old_manual_pos = manual_pos
	MOVF 0x41,W
	MOVWF 0x52
; 143: 				new_pos = manual_pos
	MOVF 0x41,W
	MOVWF 0x4B
; 144: 				Gosub stepmotor
	BCF PCLATH,3
	CALL L0007
; 145: 				value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 146: 				Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 147: 				pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 148: 				onoff = 1
	BSF 0x3E,2
; 149: 			Endif
L0022:
; 150: 		Endif
L0021:
; 151: 	Endif
L0020:
; 152: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 153: 	Gosub relays
	BSF PCLATH,3
	CALL L0009
; 154: 	Goto main
	BCF PCLATH,3
	GOTO L0001
; 155: End
	BCF PCLATH,3
L0023:	GOTO L0023
; 156: 
; 157: 
; 158: get_new_position:
L0002:
; 159: 	value = bus_pos  'remember the position
	MOVF 0x4C,W
	MOVWF 0x30
; 160: 	If pos_write = 1 Then
	BCF PCLATH,3
	BTFSS 0x06,5
	GOTO L0024
; 161: 		If old_pos_write = 0 Then  'react only once on rising edge
	BCF PCLATH,3
	BTFSC 0x3E,6
	GOTO L0025
; 162: 			old_pos_write = 1
	BSF 0x3E,6
; 163: 			value = PORTA And 63  'now get value from J5
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x30
; 164: 			If ctrl_type = 6 Then  'fiddle yard max = 30
	MOVF 0x32,W
	SUBLW 0x06
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0026
; 165: 				value = value And 31
	MOVF 0x30,W
	MOVWF R0L
	MOVLW 0x1F
	ANDWF R0L,W
	MOVWF 0x30
; 166: 				If value = 31 Then  '31 is for zero adjust, maybe only 5 bits are available
	MOVF 0x30,W
	SUBLW 0x1F
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0027
; 167: 					value = 63
	MOVLW 0x3F
	MOVWF 0x30
; 168: 				Endif
L0027:
; 169: 			Endif
L0026:
; 170: 			Select Case value
; 171: 			Case 63  'make zero adjust
	MOVF 0x30,W
	SUBLW 0x3F
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0028
; 172: 				value = 0
	CLRF 0x30
; 173: 			Case Else
	BCF PCLATH,3
	GOTO L0029
L0028:
; 174: 				If value > max_pos Then  'this is not allowed
	MOVF 0x30,W
	SUBWF 0x33,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0030
; 175: 					value = bus_pos  'put it back to old situation
	MOVF 0x4C,W
	MOVWF 0x30
; 176: 				Endif
L0030:
; 177: 			EndSelect
L0029:
; 178: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 179: 			If value = bus_pos Then  'no other position is set, just a response on pos_write is required
	MOVF 0x30,W
	SUBWF 0x4C,W
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0031
; 180: 				pos_match = 1
	BSF 0x06,4
; 181: 				WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 182: 				pos_match = 0
	BCF 0x06,4
; 183: 			Endif
L0031:
; 184: 		Endif
L0025:
; 185: 	Else
	BCF PCLATH,3
	GOTO L0032
L0024:
; 186: 		old_pos_write = 0
	BCF 0x3E,6
; 187: 	Endif
L0032:
; 188: 	bus_pos = value  'now take over the desired position
	MOVF 0x30,W
	MOVWF 0x4C
; 189: 	Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 190: 	Select Case result
; 191: 	Case 1
	MOVF 0x3F,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0033
; 192: 		If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x4A,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0034
; 193: 			encoder_count = encoder_count + 1
	MOVF 0x4A,W
	ADDLW 0x01
	MOVWF 0x4A
; 194: 		Else
	BCF PCLATH,3
	GOTO L0035
L0034:
; 195: 			encoder_count = 0
	CLRF 0x4A
; 196: 			Select Case manual_pos
; 197: 			Case 63
	MOVF 0x41,W
	SUBLW 0x3F
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0036
; 198: 				manual_pos = 0
	CLRF 0x41
; 199: 			Case max_pos
	BCF PCLATH,3
	GOTO L0037
L0036:
	MOVF 0x41,W
	SUBWF 0x33,W
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0038
; 200: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x41
; 201: 			Case Else
	BCF PCLATH,3
	GOTO L0039
L0038:
; 202: 				manual_pos = manual_pos + 1
	MOVF 0x41,W
	ADDLW 0x01
	MOVWF 0x41
; 203: 			EndSelect
L0039:
L0037:
; 204: 			value = manual_pos
	MOVF 0x41,W
	MOVWF 0x30
; 205: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 206: 		Endif
L0035:
; 207: 	Case 2
	BCF PCLATH,3
	GOTO L0040
L0033:
	MOVF 0x3F,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0041
; 208: 		If encoder_count > 0 Then
	MOVF 0x4A,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0042
; 209: 			encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x4A,W
	MOVWF 0x4A
; 210: 		Else
	BCF PCLATH,3
	GOTO L0043
L0042:
; 211: 			encoder_count = 4
	MOVLW 0x04
	MOVWF 0x4A
; 212: 			Select Case manual_pos
; 213: 			Case 63
	MOVF 0x41,W
	SUBLW 0x3F
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0044
; 214: 				manual_pos = max_pos
	MOVF 0x33,W
	MOVWF 0x41
; 215: 			Case 0
	BCF PCLATH,3
	GOTO L0045
L0044:
	MOVF 0x41,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0046
; 216: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x41
; 217: 			Case Else
	BCF PCLATH,3
	GOTO L0047
L0046:
; 218: 				manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x41,W
	MOVWF 0x41
; 219: 			EndSelect
L0047:
L0045:
; 220: 			value = manual_pos
	MOVF 0x41,W
	MOVWF 0x30
; 221: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 222: 		Endif
L0043:
; 223: 	Case Else
	BCF PCLATH,3
	GOTO L0048
L0041:
; 224: 	EndSelect
L0048:
L0040:
; 225: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 226: 	
; 227: Return
	RETURN
; 228: 
; 229: calc_rotation:  'this routine checks the incrimental switch
L0003:
; 230: '1 = increasing value
; 231: '2 = decreasing value
; 232: '3 = no change
; 233: 		new_encoder = 0
	CLRF 0x49
; 234: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x49,0
	BTFSS 0x07,4
	BCF 0x49,0
; 235: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x49,1
	BTFSS 0x07,5
	BCF 0x49,1
; 236: 		Select Case old_encoder
; 237: 		Case 0
	MOVF 0x51,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0049
; 238: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x49,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0050
	BCF PCLATH,3
	CALL L0051
	MOVWF 0x3F
	BCF PCLATH,3
	GOTO L0050
L0051:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x49,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
L0050:
; 239: 		Case 1
	BCF PCLATH,3
	GOTO L0052
L0049:
	MOVF 0x51,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0053
; 240: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x49,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0054
	BCF PCLATH,3
	CALL L0055
	MOVWF 0x3F
	BCF PCLATH,3
	GOTO L0054
L0055:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x49,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
L0054:
; 241: 		Case 2
	BCF PCLATH,3
	GOTO L0056
L0053:
	MOVF 0x51,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0057
; 242: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x49,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0058
	BCF PCLATH,3
	CALL L0059
	MOVWF 0x3F
	BCF PCLATH,3
	GOTO L0058
L0059:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x49,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
L0058:
; 243: 		Case Else
	BCF PCLATH,3
	GOTO L0060
L0057:
; 244: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x49,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0061
	BCF PCLATH,3
	CALL L0062
	MOVWF 0x3F
	BCF PCLATH,3
	GOTO L0061
L0062:
	MOVLW 0x02
	MOVWF PCLATH
	MOVF 0x49,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
L0061:
; 245: 		EndSelect
L0060:
L0056:
L0052:
; 246: 		old_encoder = new_encoder
	MOVF 0x49,W
	MOVWF 0x51
; 247: Return
	RETURN
; 248: 
; 249: 
; 250: adjust_settings:
L0004:
; 251: 	Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 252: 	WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 253: 	onoff = 0
	BCF 0x3E,2
; 254: 	Gosub relays
	BSF PCLATH,3
	CALL L0009
; 255: 	Gosub steps_reading
	BSF PCLATH,3
	CALL L0012
; 256: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x46,W
	MOVWF 0x36
	MOVF 0x47,W
	MOVWF 0x37
; 257: 	While pgm = 0  'the program switch is still activated
L0063:
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0064
; 258: 		If ecsw = 0 Then  'knob is pressed, inrease program_set
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0065
; 259: 			program_set = program_set + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
; 260: 			If program_set > 8 Then  'no more than 9 items te change
	MOVF 0x44,W
	SUBLW 0x08
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0066
; 261: 				program_set = 0
	CLRF 0x44
; 262: 			Endif
L0066:
; 263: 			Gosub i2c_display_pgm
	BCF PCLATH,3
	CALL L0006
; 264: 			WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 265: 			While ecsw = 0  'be sure pushbutton is released
L0067:
	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0068
; 266: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 267: 			Wend
	BCF PCLATH,3
	GOTO L0067
L0068:
; 268: 		Endif
L0065:
; 269: 		Select Case program_set
; 270: 		Case 0  'correction of current position
	MOVF 0x44,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0069
; 271: 			value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 272: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 273: 			Gosub calc_rotation  'look for the knob to be turned
	BCF PCLATH,3
	CALL L0003
; 274: 			Select Case result
; 275: 			Case 1
	MOVF 0x3F,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0070
; 276: 				If new_steps < 60000 Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0071
; 277: 					ena = 1  'motor on
	BSF 0x07,2
; 278: 					new_steps = new_steps + 1
	MOVF 0x36,W
	ADDLW 0x01
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x37
; 279: 					direction = 1
	BSF 0x07,0
; 280: 					clk = 1  'clock out
	BSF 0x07,1
; 281: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 282: 					clk = 0
	BCF 0x07,1
; 283: 				Endif
L0071:
; 284: 			Case 2
	BCF PCLATH,3
	GOTO L0072
L0070:
	MOVF 0x3F,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0073
; 285: 				If new_steps > 0 Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0074
; 286: 					ena = 1  'motor on
	BSF 0x07,2
; 287: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x36,W
	MOVWF 0x36
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x37
; 288: 					direction = 0
	BCF 0x07,0
; 289: 					clk = 1  'clock out
	BSF 0x07,1
; 290: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 291: 					clk = 0
	BCF 0x07,1
; 292: 				Endif
L0074:
; 293: 			Case Else
	BCF PCLATH,3
	GOTO L0075
L0073:
; 294: 			EndSelect
L0075:
L0072:
; 295: 			Select Case act_pos
; 296: 			Case 1
	MOVF 0x31,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0076
; 297: 				steps_set = 1
	BSF 0x3E,1
; 298: 			Case 2
	BCF PCLATH,3
	GOTO L0077
L0076:
	MOVF 0x31,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0078
; 299: 				If steps_set = 1 Then
	BCF PCLATH,3
	BTFSS 0x3E,1
	GOTO L0079
; 300: 					If eep = 1 Then  'iF jumper eep1 is set to on
	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0080
; 301: 											'routine to set steps for pos 3 to max_pos
; 302: 						value = 63
	MOVLW 0x3F
	MOVWF 0x30
; 303: 						Gosub i2c_display  'show 63 to indicate adjusting is proceeded
	BCF PCLATH,3
	CALL L0005
; 304: 						If act_steps <> new_steps Then
	MOVF 0x46,W
	MOVWF R0L
	MOVF 0x47,W
	MOVWF R0H
	MOVF 0x36,W
	MOVWF R1L
	MOVF 0x37,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C002
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0081
; 305: 							Gosub save_steps
	BSF PCLATH,3
	CALL L0015
; 306: 						Endif
L0081:
; 307: 						act_pos = 1
	MOVLW 0x01
	MOVWF 0x31
; 308: 						new_pos = 2
	MOVLW 0x02
	MOVWF 0x4B
; 309: 						Gosub steps_reading
	BSF PCLATH,3
	CALL L0012
; 310: 						steps = new_steps - act_steps  'calculate difference between one and two
	MOVF 0x46,W
	SUBWF 0x36,W
	MOVWF 0x34
	MOVF 0x47,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x35
; 311: 						For act_pos = 3 To max_pos
	MOVLW 0x03
	MOVWF 0x31
L0082:
	MOVF 0x31,W
	SUBWF 0x33,W
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0083
; 312: 							new_steps = new_steps + steps
	MOVF 0x36,W
	ADDWF 0x34,W
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x35,W
	MOVWF 0x37
; 313: 							Gosub save_steps
	BSF PCLATH,3
	CALL L0015
; 314: 						Next act_pos
	MOVLW 0x01
	ADDWF 0x31,F
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0082
L0083:
; 315: 						WaitMs 2000  'give some timne to read display
	MOVLW 0xD0
	MOVWF R0L
	MOVLW 0x07
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 316: 						act_pos = 2  'we were at this position
	MOVLW 0x02
	MOVWF 0x31
; 317: 						steps_set = 0  'do this routine only once
	BCF 0x3E,1
; 318: 					Endif
L0080:
; 319: 				Endif
L0079:
; 320: 			Case Else
	BCF PCLATH,3
	GOTO L0084
L0078:
; 321: 				steps_set = 0
	BCF 0x3E,1
; 322: 			EndSelect  'act_pos
L0084:
L0077:
; 323: 		Case 1  'setting of inverse / not inverse bridge rail power
	BCF PCLATH,3
	GOTO L0085
L0069:
	MOVF 0x44,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0086
; 324: 			Gosub read_bridge_switch
	BSF PCLATH,3
	CALL L0013
; 325: 			value = 0
	CLRF 0x30
; 326: 			value.0 = bridge_switch
	BTFSC 0x3E,0
	BSF 0x30,0
	BTFSS 0x3E,0
	BCF 0x30,0
; 327: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 328: 			Gosub calc_rotation  'look for the knob to be turned
	BCF PCLATH,3
	CALL L0003
; 329: 			Select Case result
; 330: 			Case 1, 2
	MOVF 0x3F,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0089
	BCF PCLATH,3
	GOTO L0088
L0089:
	MOVF 0x3F,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0087
L0088:
; 331: 				bridge_switch = Not bridge_switch
	MOVLW 0x01
	XORWF 0x3E,F
; 332: 				Gosub store_bridge_switch
	BSF PCLATH,3
	CALL L0014
; 333: 				swfw = 0  'first both relays off
	BCF 0x06,0
; 334: 				swrev = 0
	BCF 0x06,1
; 335: 				WaitMs 20
	MOVLW 0x14
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 336: 				swfw = bridge_switch
	BTFSC 0x3E,0
	BSF 0x06,0
	BTFSS 0x3E,0
	BCF 0x06,0
; 337: 				swrev = Not bridge_switch
	BTFSS 0x3E,0
	BSF 0x06,1
	BTFSC 0x3E,0
	BCF 0x06,1
; 338: 			Case Else
	BCF PCLATH,3
	GOTO L0090
L0087:
; 339: 			EndSelect
L0090:
; 340: 		Case 2  'setting of maximum positions
	BCF PCLATH,3
	GOTO L0091
L0086:
	MOVF 0x44,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0092
; 341: 			steps_set = 0
	BCF 0x3E,1
; 342: 			ena = 0  'shut off motor
	BCF 0x07,2
; 343: 			value = max_pos
	MOVF 0x33,W
	MOVWF 0x30
; 344: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 345: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 346: 			Select Case result
; 347: 			Case 1
	MOVF 0x3F,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0093
; 348: 				max_pos = max_pos + 1
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x33
; 349: 				Select Case ctrl_type
; 350: 				Case 6
	MOVF 0x32,W
	SUBLW 0x06
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0094
; 351: 					If max_pos > 30 Then  'no more positions possible
	MOVF 0x33,W
	SUBLW 0x1E
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0095
; 352: 						max_pos = 1
	MOVLW 0x01
	MOVWF 0x33
; 353: 					Endif
L0095:
; 354: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0096:	BTFSC EECON1,WR
	GOTO L0096
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 355: 				Case Else
	BCF PCLATH,3
	GOTO L0097
L0094:
; 356: 					If max_pos > 47 Then  'no more positions possible
	MOVF 0x33,W
	SUBLW 0x2F
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0098
; 357: 						max_pos = 1
	MOVLW 0x01
	MOVWF 0x33
; 358: 					Endif
L0098:
; 359: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0099:	BTFSC EECON1,WR
	GOTO L0099
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 360: 				EndSelect
L0097:
; 361: 			Case 2
	BCF PCLATH,3
	GOTO L0100
L0093:
	MOVF 0x3F,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0101
; 362: 				max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
; 363: 				If max_pos < 1 Then  'mininum 2 positions
	MOVLW 0x01
	SUBWF 0x33,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0102
; 364: 					Select Case ctrl_type
; 365: 					Case 6
	MOVF 0x32,W
	SUBLW 0x06
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0103
; 366: 						max_pos = 30
	MOVLW 0x1E
	MOVWF 0x33
; 367: 					Case Else
	BCF PCLATH,3
	GOTO L0104
L0103:
; 368: 						max_pos = 47
	MOVLW 0x2F
	MOVWF 0x33
; 369: 					EndSelect
L0104:
; 370: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0105:	BTFSC EECON1,WR
	GOTO L0105
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 371: 				Endif
L0102:
; 372: 			Case Else
	BCF PCLATH,3
	GOTO L0106
L0101:
; 373: 			EndSelect
L0106:
L0100:
; 374: 		Case 3  'setting control type
	BCF PCLATH,3
	GOTO L0107
L0092:
	MOVF 0x44,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0108
; 375: 			steps_set = 0
	BCF 0x3E,1
; 376: 			ena = 0  'shut off motor
	BCF 0x07,2
; 377: 			If ctrl_type > 6 Then
	MOVF 0x32,W
	SUBLW 0x06
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0109
; 378: 				ctrl_type = 0
	CLRF 0x32
; 379: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0110:	BTFSC EECON1,WR
	GOTO L0110
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 380: 			Endif
L0109:
; 381: 			value = ctrl_type
	MOVF 0x32,W
	MOVWF 0x30
; 382: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 383: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 384: 			Select Case result
; 385: 			Case 1
	MOVF 0x3F,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0111
; 386: 				ctrl_type = ctrl_type + 1
	MOVF 0x32,W
	ADDLW 0x01
	MOVWF 0x32
; 387: 				If ctrl_type = 7 Then
	MOVF 0x32,W
	SUBLW 0x07
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0112
; 388: 					ctrl_type = 0
	CLRF 0x32
; 389: 				Endif
L0112:
; 390: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0113:	BTFSC EECON1,WR
	GOTO L0113
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 391: 			Case 2
	BCF PCLATH,3
	GOTO L0114
L0111:
	MOVF 0x3F,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0115
; 392: 				ctrl_type = ctrl_type - 1
	MOVLW 0x01
	SUBWF 0x32,W
	MOVWF 0x32
; 393: 				If ctrl_type = 255 Then
	MOVF 0x32,W
	SUBLW 0xFF
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0116
; 394: 					ctrl_type = 6
	MOVLW 0x06
	MOVWF 0x32
; 395: 				Endif
L0116:
; 396: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0117:	BTFSC EECON1,WR
	GOTO L0117
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 397: 			Case Else
	BCF PCLATH,3
	GOTO L0118
L0115:
; 398: 			EndSelect
L0118:
L0114:
; 399: 		Case 4  'setting of speed interval Minimum
	BCF PCLATH,3
	GOTO L0119
L0108:
	MOVF 0x44,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0120
; 400: 					'setting will be done in multiple of 256 uSecs
; 401: 					'minimum is 2 and maximum is 99 (is real slow)
; 402: 			steps_set = 0
	BCF 0x3E,1
; 403: 			ena = 0  'shut off motor
	BCF 0x07,2
; 404: 			value = speed_min.HB
	MOVF 0x3D,W
	MOVWF 0x30
; 405: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 406: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 407: 			Select Case result
; 408: 			Case 1
	MOVF 0x3F,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0121
; 409: 				If speed_min.HB < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x3D,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0122
; 410: 					speed_min = speed_min + 256
	MOVF 0x3C,W
	ADDLW 0x00
	MOVWF 0x3C
	MOVF 0x3D,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x01
	MOVWF 0x3D
; 411: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0123:	BTFSC EECON1,WR
	GOTO L0123
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 412: 				Endif
L0122:
; 413: 			Case 2
	BCF PCLATH,3
	GOTO L0124
L0121:
	MOVF 0x3F,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0125
; 414: 				If speed_min > speed_max Then
	MOVF 0x3C,W
	MOVWF R0L
	MOVF 0x3D,W
	MOVWF R0H
	MOVF 0x3A,W
	MOVWF R1L
	MOVF 0x3B,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0126
; 415: 					speed_min = speed_min - 256
	MOVLW 0x00
	SUBWF 0x3C,W
	MOVWF 0x3C
	MOVLW 0x01
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3D,W
	MOVWF 0x3D
; 416: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3D,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0127:	BTFSC EECON1,WR
	GOTO L0127
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 417: 				Endif
L0126:
; 418: 			Case Else
	BCF PCLATH,3
	GOTO L0128
L0125:
; 419: 			EndSelect
L0128:
L0124:
; 420: 		Case 5  'setting of speed interval Maximum
	BCF PCLATH,3
	GOTO L0129
L0120:
	MOVF 0x44,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0130
; 421: 					'setting will be done in multiple of 256 uSecs
; 422: 					'minimum is 1 and maximum is 99 (is real slow)
; 423: 			steps_set = 0
	BCF 0x3E,1
; 424: 			ena = 0  'shut off motor
	BCF 0x07,2
; 425: 			value = speed_max.HB
	MOVF 0x3B,W
	MOVWF 0x30
; 426: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 427: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 428: 			Select Case result
; 429: 			Case 1
	MOVF 0x3F,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0131
; 430: 				If speed_max.HB < speed_min.HB Then  'not more then speed_min
	MOVF 0x3D,W
	SUBWF 0x3B,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0132
; 431: 					speed_max.HB = speed_max.HB + 1
	MOVF 0x3B,W
	ADDLW 0x01
	MOVWF 0x3B
; 432: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0133:	BTFSC EECON1,WR
	GOTO L0133
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 433: 				Endif
L0132:
; 434: 			Case 2
	BCF PCLATH,3
	GOTO L0134
L0131:
	MOVF 0x3F,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0135
; 435: 				If speed_max.HB > 1 Then
	MOVF 0x3B,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0136
; 436: 					speed_max.HB = speed_max.HB - 1
	MOVLW 0x01
	SUBWF 0x3B,W
	MOVWF 0x3B
; 437: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3B,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0137:	BTFSC EECON1,WR
	GOTO L0137
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 438: 				Endif
L0136:
; 439: 			Case Else
	BCF PCLATH,3
	GOTO L0138
L0135:
; 440: 			EndSelect
L0138:
L0134:
; 441: 		Case 6  'setting of ramp up and down speed
	BCF PCLATH,3
	GOTO L0139
L0130:
	MOVF 0x44,W
	SUBLW 0x06
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0140
; 442: 					'speed will be the value that speed will be changed every step up and down
; 443: 			steps_set = 0
	BCF 0x3E,1
; 444: 			ena = 0  'shut off motor
	BCF 0x07,2
; 445: 			value = speed_step
	MOVF 0x45,W
	MOVWF 0x30
; 446: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 447: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 448: 			Select Case result
; 449: 			Case 1
	MOVF 0x3F,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0141
; 450: 				If speed_step < 99 Then  'maximum 99 is possible
	MOVLW 0x63
	SUBWF 0x45,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0142
; 451: 					speed_step = speed_step + 1
	MOVF 0x45,W
	ADDLW 0x01
	MOVWF 0x45
; 452: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x45,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0143:	BTFSC EECON1,WR
	GOTO L0143
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 453: 				Endif
L0142:
; 454: 			Case 2
	BCF PCLATH,3
	GOTO L0144
L0141:
	MOVF 0x3F,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0145
; 455: 				If speed_step > 1 Then
	MOVF 0x45,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0146
; 456: 					speed_step = speed_step - 1
	MOVLW 0x01
	SUBWF 0x45,W
	MOVWF 0x45
; 457: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x45,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0147:	BTFSC EECON1,WR
	GOTO L0147
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 458: 				Endif
L0146:
; 459: 			Case Else
	BCF PCLATH,3
	GOTO L0148
L0145:
; 460: 			EndSelect
L0148:
L0144:
; 461: 	
; 462: 		Case 7  'setting of extra free space steps
	BCF PCLATH,3
	GOTO L0149
L0140:
	MOVF 0x44,W
	SUBLW 0x07
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0150
; 463: 			steps_set = 0
	BCF 0x3E,1
; 464: 			ena = 0  'shut off motor
	BCF 0x07,2
; 465: 			If free_space_steps > 99 Then
	MOVF 0x42,W
	SUBLW 0x63
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0151
; 466: 				free_space_steps = 99
	MOVLW 0x63
	MOVWF 0x42
; 467: 				Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0152:	BTFSC EECON1,WR
	GOTO L0152
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 468: 			Endif
L0151:
; 469: 			value = free_space_steps
	MOVF 0x42,W
	MOVWF 0x30
; 470: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 471: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 472: 			Select Case result
; 473: 			Case 1
	MOVF 0x3F,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0153
; 474: 				If free_space_steps < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x42,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0154
; 475: 					free_space_steps = free_space_steps + 1
	MOVF 0x42,W
	ADDLW 0x01
	MOVWF 0x42
; 476: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0155:	BTFSC EECON1,WR
	GOTO L0155
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 477: 				Endif
L0154:
; 478: 			Case 2
	BCF PCLATH,3
	GOTO L0156
L0153:
	MOVF 0x3F,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0157
; 479: 				If free_space_steps > 0 Then
	MOVF 0x42,W
	SUBLW 0x00
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0158
; 480: 					free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x42,W
	MOVWF 0x42
; 481: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0159:	BTFSC EECON1,WR
	GOTO L0159
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 482: 				Endif
L0158:
; 483: 			Case Else
	BCF PCLATH,3
	GOTO L0160
L0157:
; 484: 			EndSelect
L0160:
L0156:
; 485: 		Case Else  'setting if power should be on or off while bridge is moving (0 = off)
	BCF PCLATH,3
	GOTO L0161
L0150:
; 486: 			Read mem_bridge_power, value
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 487: 			If value > 1 Then
	MOVF 0x30,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0162
; 488: 				value = 1
	MOVLW 0x01
	MOVWF 0x30
; 489: 			Endif
L0162:
; 490: 			bridge_power = value.0
	BTFSC 0x30,0
	BSF 0x3E,3
	BTFSS 0x30,0
	BCF 0x3E,3
; 491: 			Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 492: 			Gosub calc_rotation
	BCF PCLATH,3
	CALL L0003
; 493: 			Select Case result
; 494: 			Case 1, 2
	MOVF 0x3F,W
	SUBLW 0x01
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0165
	BCF PCLATH,3
	GOTO L0164
L0165:
	MOVF 0x3F,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0163
L0164:
; 495: 				bridge_power = Not bridge_power
	MOVLW 0x08
	XORWF 0x3E,F
; 496: 				value.0 = bridge_power
	BTFSC 0x3E,3
	BSF 0x30,0
	BTFSS 0x3E,3
	BCF 0x30,0
; 497: 				Write mem_bridge_power, value
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0166:	BTFSC EECON1,WR
	GOTO L0166
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 498: 			Case Else
	BCF PCLATH,3
	GOTO L0167
L0163:
; 499: 			EndSelect
L0167:
; 500: 		EndSelect
L0161:
L0149:
L0139:
L0129:
L0119:
L0107:
L0091:
L0085:
; 501: 	Wend
	BCF PCLATH,3
	GOTO L0063
L0064:
; 502: 	ena = 0  'shut off motor
	BCF 0x07,2
; 503: 		'***************   now check if changes have to BE written in eeprom
; 504: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVF 0x46,W
	MOVWF R1L
	MOVF 0x47,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C002
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0168
; 505: 		Gosub save_steps
	BSF PCLATH,3
	CALL L0015
; 506: 	Endif
L0168:
; 507: 	value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 508: 	Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 509: 	onoff = 1
	BSF 0x3E,2
; 510: 	Gosub relays
	BSF PCLATH,3
	CALL L0009
; 511: Return
	RETURN
; 512: 
; 513: i2c_display:
L0005:
; 514: 	disp1_val = value
	MOVF 0x30,W
	MOVWF 0x48
; 515: 	disp1_val = disp1_val Mod 10
	MOVF 0x48,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x48
; 516: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x48,W
	SUBLW 0x09
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0169
	BCF PCLATH,3
	CALL L0170
	MOVWF 0x48
	BCF PCLATH,3
	GOTO L0169
L0170:
	MOVLW 0x06
	MOVWF PCLATH
	MOVF 0x48,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
L0169:
; 517: 	disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x48,7
	BTFSS 0x07,7
	BCF 0x48,7
; 518: 	disp2_val = value
	MOVF 0x30,W
	MOVWF 0x4F
; 519: 	disp2_val = disp2_val / 10
	MOVF 0x4F,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4F
; 520: 	disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x4F,W
	SUBLW 0x0A
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0171
	BCF PCLATH,3
	CALL L0172
	MOVWF 0x4F
	BCF PCLATH,3
	GOTO L0171
L0172:
	MOVLW 0x06
	MOVWF PCLATH
	MOVF 0x4F,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
L0171:
; 521: 	disp2_val.7 = version
	BTFSC 0x3E,5
	BSF 0x4F,7
	BTFSS 0x3E,5
	BCF 0x4F,7
; 522: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 523: 	I2CSend disp1
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 524: 	I2CSend disp1_val
	BCF PCLATH,3
	MOVF 0x48,W
	CALL IC01
; 525: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 526: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 527: 	I2CSend disp2
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 528: 	I2CSend disp2_val
	BCF PCLATH,3
	MOVF 0x4F,W
	CALL IC01
; 529: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 530: Return
	RETURN
; 531: 
; 532: i2c_display_pgm:
L0006:
; 533: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), program_set
	MOVF 0x44,W
	SUBLW 0x09
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0173
	BCF PCLATH,3
	CALL L0174
	MOVWF 0x48
	BCF PCLATH,3
	GOTO L0173
L0174:
	MOVLW 0x06
	MOVWF PCLATH
	MOVF 0x44,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
L0173:
; 534: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 535: 	I2CSend disp1
	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 536: 	I2CSend disp1_val
	BCF PCLATH,3
	MOVF 0x48,W
	CALL IC01
; 537: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 538: 	I2CStart
	BCF PCLATH,3
	CALL IC31
; 539: 	I2CSend disp2
	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 540: 	I2CSend %10111111
	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 541: 	I2CStop
	BCF PCLATH,3
	CALL IC41
; 542: Return
	RETURN
; 543: 
; 544: stepmotor:
L0007:
; 545: 	speed = 0
	CLRF 0x4D
	CLRF 0x4E
; 546: 	Gosub steps_reading
	BSF PCLATH,3
	CALL L0012
; 547: 	If new_steps = 0 Then  'o correction is to be made
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C001
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0175
; 548: 		direction = 0
	BCF 0x07,0
; 549: 		ena = 1  'set anable on
	BSF 0x07,2
; 550: 		pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 551: 		While zero = 1  'turn motor until zero switch is activated
L0176:
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0177
; 552: 			clk = 1  'clock out
	BSF 0x07,1
; 553: 			WaitUs speed_max
	MOVF 0x3A,W
	MOVWF R4L
	MOVF 0x3B,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 554: 			clk = 0
	BCF 0x07,1
; 555: 			WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 556: 		Wend
	BCF PCLATH,3
	GOTO L0176
L0177:
; 557: 		value = 0  'first considerate that extra round is not allowed
	CLRF 0x30
; 558: 		Select Case ctrl_type
; 559: 		Case 2, 3  'check if extra round is allowed
	MOVF 0x32,W
	SUBLW 0x02
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0180
	BCF PCLATH,3
	GOTO L0179
L0180:
	MOVF 0x32,W
	SUBLW 0x03
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0178
L0179:
; 560: 			Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 561: 			Select Case turn_counter
; 562: 			Case > 126  'check if shortest way is allowed
	MOVF 0x40,W
	SUBLW 0x7E
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0181
; 563: 				turn_counter = turn_counter - 1  'yes it is, so substract one pass
	MOVLW 0x01
	SUBWF 0x40,W
	MOVWF 0x40
; 564: 				Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0182:	BTFSC EECON1,WR
	GOTO L0182
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 565: 				value = 1  'now it is allowed
	MOVLW 0x01
	MOVWF 0x30
; 566: 			Case < 126
	BCF PCLATH,3
	GOTO L0183
L0181:
	MOVLW 0x7E
	SUBWF 0x40,W
	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0184
; 567: 				Write mem_turn_counter, 126
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x7E
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0185:	BTFSC EECON1,WR
	GOTO L0185
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 568: 			Case Else
	BCF PCLATH,3
	GOTO L0186
L0184:
; 569: 			EndSelect
L0186:
L0183:
; 570: 		Case 4, 5  'type with contact sliders, no twisting cables
	BCF PCLATH,3
	GOTO L0187
L0178:
	MOVF 0x32,W
	SUBLW 0x04
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0190
	BCF PCLATH,3
	GOTO L0189
L0190:
	MOVF 0x32,W
	SUBLW 0x05
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0188
L0189:
; 571: 			value = 1
	MOVLW 0x01
	MOVWF 0x30
; 572: 		Case Else  'no short way possible
	BCF PCLATH,3
	GOTO L0191
L0188:
; 573: 		EndSelect
L0191:
L0187:
; 574: 		If value = 1 Then
	MOVF 0x30,W
	SUBLW 0x01
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0192
; 575: 			one_round = 0  'start counting one round steps
	CLRF 0x38
	CLRF 0x39
; 576: 			ena = 1  'set anable on
	BSF 0x07,2
; 577: 			While zero = 0  'turn motor until zero switch is DISactivated
L0193:
	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0194
; 578: 				clk = 1  'clock out
	BSF 0x07,1
; 579: 				WaitUs speed_max
	MOVF 0x3A,W
	MOVWF R4L
	MOVF 0x3B,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 580: 				clk = 0
	BCF 0x07,1
; 581: 				one_round = one_round + 1
	MOVF 0x38,W
	ADDLW 0x01
	MOVWF 0x38
	MOVF 0x39,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x39
; 582: 				WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 583: 			Wend
	BCF PCLATH,3
	GOTO L0193
L0194:
; 584: 			For value = 1 To 100  'SOME MORE STEPS TO AVOID CONTACT DENDER.
	MOVLW 0x01
	MOVWF 0x30
L0195:
	MOVF 0x30,W
	SUBLW 0x64
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0196
; 585: 				clk = 1  'clock out
	BSF 0x07,1
; 586: 				WaitUs speed_max
	MOVF 0x3A,W
	MOVWF R4L
	MOVF 0x3B,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 587: 				clk = 0
	BCF 0x07,1
; 588: 				WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 589: 				one_round = one_round + 1
	MOVF 0x38,W
	ADDLW 0x01
	MOVWF 0x38
	MOVF 0x39,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x39
; 590: 			Next value
	MOVLW 0x01
	ADDWF 0x30,F
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0195
L0196:
; 591: 			While zero = 1  'turn motor until zero switch is activated
L0197:
	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0198
; 592: 				clk = 1  'clock out
	BSF 0x07,1
; 593: 				WaitUs speed_max
	MOVF 0x3A,W
	MOVWF R4L
	MOVF 0x3B,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 594: 				clk = 0
	BCF 0x07,1
; 595: 				WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 596: 				one_round = one_round + 1
	MOVF 0x38,W
	ADDLW 0x01
	MOVWF 0x38
	MOVF 0x39,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x39
; 597: 			Wend
	BCF PCLATH,3
	GOTO L0197
L0198:
; 598: 			one_round_half = one_round / 2
	MOVF 0x38,W
	MOVWF R0L
	MOVF 0x39,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x55
	MOVF R0H,W
	MOVWF 0x56
; 599: 			Write mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BCF PCLATH,3
L0199:	BTFSC EECON1,WR
	GOTO L0199
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 600: 			Write mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0200:	BTFSC EECON1,WR
	GOTO L0200
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 601: 			act_pos = 63
	MOVLW 0x3F
	MOVWF 0x31
; 602: 		Endif
L0192:
; 603: 		Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0201:	BTFSC EECON1,WR
	GOTO L0201
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 604: 		ena = 0  'set anable off
	BCF 0x07,2
; 605: 	Else  'this is the normal position sequence
	BSF PCLATH,3
	GOTO L0202
L0175:
; 606: 		steps = 0
	CLRF 0x34
	CLRF 0x35
; 607: 		If new_steps > act_steps Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVF 0x46,W
	MOVWF R1L
	MOVF 0x47,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0203
; 608: 			steps = new_steps - act_steps
	MOVF 0x46,W
	SUBWF 0x36,W
	MOVWF 0x34
	MOVF 0x47,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x35
; 609: 			direction = 1
	BSF 0x07,0
; 610: 			If steps > one_round_half Then  'is other direction shorter?
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVF 0x55,W
	MOVWF R1L
	MOVF 0x56,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0204
; 611: 				Select Case ctrl_type
; 612: 				Case 2, 3
	MOVF 0x32,W
	SUBLW 0x02
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0207
	BSF PCLATH,3
	GOTO L0206
L0207:
	MOVF 0x32,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0205
L0206:
; 613: 					Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 614: 					Select Case turn_counter
; 615: 					Case > 126  'check if shortest way is allowed
	MOVF 0x40,W
	SUBLW 0x7E
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0208
; 616: 						turn_counter = turn_counter - 1  'yes it is, so substract one pass
	MOVLW 0x01
	SUBWF 0x40,W
	MOVWF 0x40
; 617: 						steps = one_round - steps  'go shortest way
	MOVF 0x34,W
	SUBWF 0x38,W
	MOVWF 0x34
	MOVF 0x35,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x39,W
	MOVWF 0x35
; 618: 						direction = 0  'change  direction
	BCF 0x07,0
; 619: 						Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0209:	BTFSC EECON1,WR
	GOTO L0209
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 620: 					Case < 126
	BSF PCLATH,3
	GOTO L0210
L0208:
	MOVLW 0x7E
	SUBWF 0x40,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0211
; 621: 							Write mem_turn_counter, 126
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x7E
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0212:	BTFSC EECON1,WR
	GOTO L0212
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 622: 					Case Else
	BSF PCLATH,3
	GOTO L0213
L0211:
; 623: 					EndSelect
L0213:
L0210:
; 624: 				Case 4, 5  'type with contact sliders, no twisting cables
	BSF PCLATH,3
	GOTO L0214
L0205:
	MOVF 0x32,W
	SUBLW 0x04
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0217
	BSF PCLATH,3
	GOTO L0216
L0217:
	MOVF 0x32,W
	SUBLW 0x05
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0215
L0216:
; 625: 					steps = one_round - steps
	MOVF 0x34,W
	SUBWF 0x38,W
	MOVWF 0x34
	MOVF 0x35,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x39,W
	MOVWF 0x35
; 626: 					direction = 0
	BCF 0x07,0
; 627: 				Case Else  'no short way possible
	BSF PCLATH,3
	GOTO L0218
L0215:
; 628: 				EndSelect
L0218:
L0214:
; 629: 			Endif
L0204:
; 630: 		Else
	BSF PCLATH,3
	GOTO L0219
L0203:
; 631: 			steps = act_steps - new_steps
	MOVF 0x36,W
	SUBWF 0x46,W
	MOVWF 0x34
	MOVF 0x37,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x47,W
	MOVWF 0x35
; 632: 			direction = 0
	BCF 0x07,0
; 633: 			If steps > one_round_half Then  'other direction shorter?
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVF 0x55,W
	MOVWF R1L
	MOVF 0x56,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0220
; 634: 				Select Case ctrl_type
; 635: 				Case 2, 3  'cable connected bridges
	MOVF 0x32,W
	SUBLW 0x02
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0223
	BSF PCLATH,3
	GOTO L0222
L0223:
	MOVF 0x32,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0221
L0222:
; 636: 					Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 637: 					Select Case turn_counter
; 638: 					Case < 130
	MOVLW 0x82
	SUBWF 0x40,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0224
; 639: 						turn_counter = turn_counter + 1  'yes it is, so add one pass
	MOVF 0x40,W
	ADDLW 0x01
	MOVWF 0x40
; 640: 						steps = one_round - steps  'go shortest way
	MOVF 0x34,W
	SUBWF 0x38,W
	MOVWF 0x34
	MOVF 0x35,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x39,W
	MOVWF 0x35
; 641: 						direction = 1  'change direction
	BSF 0x07,0
; 642: 						Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0225:	BTFSC EECON1,WR
	GOTO L0225
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 643: 					Case > 130
	BSF PCLATH,3
	GOTO L0226
L0224:
	MOVF 0x40,W
	SUBLW 0x82
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0227
; 644: 						Write mem_turn_counter, 130
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x82
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0228:	BTFSC EECON1,WR
	GOTO L0228
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 645: 					Case Else
	BSF PCLATH,3
	GOTO L0229
L0227:
; 646: 					EndSelect
L0229:
L0226:
; 647: 				Case 4, 5  'type with contact sliders, no twisting cables
	BSF PCLATH,3
	GOTO L0230
L0221:
	MOVF 0x32,W
	SUBLW 0x04
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0233
	BSF PCLATH,3
	GOTO L0232
L0233:
	MOVF 0x32,W
	SUBLW 0x05
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0231
L0232:
; 648: 					steps = one_round - steps
	MOVF 0x34,W
	SUBWF 0x38,W
	MOVWF 0x34
	MOVF 0x35,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x39,W
	MOVWF 0x35
; 649: 					direction = 1
	BSF 0x07,0
; 650: 				Case Else  'no short way possible
	BSF PCLATH,3
	GOTO L0234
L0231:
; 651: 				EndSelect
L0234:
L0230:
; 652: 			Endif
L0220:
; 653: 		Endif
L0219:
; 654: 		If steps > 0 Then  'motor must be activated
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0235
; 655: 			If direction = 1 Then
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0236
; 656: 				steps = steps + free_space_word
	MOVF 0x34,W
	ADDWF 0x58,W
	MOVWF 0x34
	MOVF 0x35,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x59,W
	MOVWF 0x35
; 657: 			Endif
L0236:
; 658: 			ramp_up = 1
	BSF 0x3E,4
; 659: 			ramp_down_point = 0
	CLRF 0x53
	CLRF 0x54
; 660: 			half_steps = steps / 2
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x5A
	MOVF R0H,W
	MOVWF 0x5B
; 661: 			speed = speed_min
	MOVF 0x3C,W
	MOVWF 0x4D
	MOVF 0x3D,W
	MOVWF 0x4E
; 662: 			ena = 1  'set anable on
	BSF 0x07,2
; 663: 			pos_match = 1  'not indicate pos_match
	BSF 0x06,4
; 664: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0237:
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0238
; 665: 				If max_end = 0 Then
	BSF PCLATH,3
	BTFSC 0x06,7
	GOTO L0239
; 666: 					Gosub stop_the_motor
	BSF PCLATH,3
	CALL L0016
; 667: 				Endif
L0239:
; 668: 				Select Case ctrl_type
; 669: 				Case 6
	MOVF 0x32,W
	SUBLW 0x06
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0240
; 670: 					If fy_stop = 1 Then
	BSF PCLATH,3
	BTFSS 0x05,5
	GOTO L0241
; 671: 						Gosub stop_the_motor
	BSF PCLATH,3
	CALL L0016
; 672: 					Endif
L0241:
; 673: 				Case Else
	BSF PCLATH,3
	GOTO L0242
L0240:
; 674: 				EndSelect
L0242:
; 675: 				clk = 1  'clock out
	BSF 0x07,1
; 676: 				WaitUs speed
	MOVF 0x4D,W
	MOVWF R4L
	MOVF 0x4E,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 677: 				clk = 0
	BCF 0x07,1
; 678: 				Gosub speed_calc
	BSF PCLATH,3
	CALL L0008
; 679: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x35,W
	MOVWF 0x35
; 680: 			Wend
	BSF PCLATH,3
	GOTO L0237
L0238:
; 681: 			WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 682: 			If direction = 1 Then
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0243
; 683: 				steps = free_space_word
	MOVF 0x58,W
	MOVWF 0x34
	MOVF 0x59,W
	MOVWF 0x35
; 684: 				direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 685: 				While steps > 0  'NOW RUN UNTIL STEPS = 0
L0244:
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0245
; 686: 					If max_end = 0 Then
	BSF PCLATH,3
	BTFSC 0x06,7
	GOTO L0246
; 687: 						Gosub stop_the_motor
	BSF PCLATH,3
	CALL L0016
; 688: 					Endif
L0246:
; 689: 					Select Case ctrl_type
; 690: 					Case 6
	MOVF 0x32,W
	SUBLW 0x06
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0247
; 691: 						If fy_stop = 1 Then
	BSF PCLATH,3
	BTFSS 0x05,5
	GOTO L0248
; 692: 							Gosub stop_the_motor
	BSF PCLATH,3
	CALL L0016
; 693: 						Endif
L0248:
; 694: 					Case Else
	BSF PCLATH,3
	GOTO L0249
L0247:
; 695: 					EndSelect
L0249:
; 696: 					clk = 1  'clock out
	BSF 0x07,1
; 697: 					WaitUs speed_min
	MOVF 0x3C,W
	MOVWF R4L
	MOVF 0x3D,W
	MOVWF R4H
	BCF PCLATH,3
	CALL Y001
; 698: 					clk = 0
	BCF 0x07,1
; 699: 					steps = steps - 1
	MOVLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x35,W
	MOVWF 0x35
; 700: 					WaitUs 5
	MOVLW 0x05
	MOVWF R4L
	BCF PCLATH,3
	CALL X001
; 701: 				Wend
	BSF PCLATH,3
	GOTO L0244
L0245:
; 702: 			Endif
L0243:
; 703: 			ena = 0  'enable off
	BCF 0x07,2
; 704: 		Endif
L0235:
; 705: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 706: 	Endif
L0202:
; 707: 	act_pos = new_pos
	MOVF 0x4B,W
	MOVWF 0x31
; 708: 	Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0250:	BTFSC EECON1,WR
	GOTO L0250
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 709: 	bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x4C
; 710: 	old_bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x57
; 711: 	manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x41
; 712: 	old_manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x52
; 713: Return
	RETURN
; 714: 
; 715: 
; 716: speed_calc:
L0008:
; 717: 	If steps < half_steps Then  'at this point  ramp up MUST end
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVF 0x5A,W
	MOVWF R1L
	MOVF 0x5B,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0251
; 718: 		ramp_up = 0
	BCF 0x3E,4
; 719: 	Endif
L0251:
; 720: 	If ramp_up = 1 Then  'we were supposed to ramp up
	BSF PCLATH,3
	BTFSS 0x3E,4
	GOTO L0252
; 721: 		If speed > speed_max Then
	MOVF 0x4D,W
	MOVWF R0L
	MOVF 0x4E,W
	MOVWF R0H
	MOVF 0x3A,W
	MOVWF R1L
	MOVF 0x3B,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0253
; 722: 			speed = speed - speed_step
	MOVF 0x45,W
	SUBWF 0x4D,W
	MOVWF 0x4D
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x4E,W
	MOVWF 0x4E
; 723: 			ramp_down_point = ramp_down_point + 1  'this counts down with the steps
	MOVF 0x53,W
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x54
; 724: 		Else
	BSF PCLATH,3
	GOTO L0254
L0253:
; 725: 			ramp_up = 0
	BCF 0x3E,4
; 726: 		Endif
L0254:
; 727: 	Else
	BSF PCLATH,3
	GOTO L0255
L0252:
; 728: 		If steps < ramp_down_point Then  'this is the point tot start ramp down
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVF 0x53,W
	MOVWF R1L
	MOVF 0x54,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0256
; 729: 			If speed < speed_min Then
	MOVF 0x4D,W
	MOVWF R0L
	MOVF 0x4E,W
	MOVWF R0H
	MOVF 0x3C,W
	MOVWF R1L
	MOVF 0x3D,W
	MOVWF R1H
	BCF PCLATH,3
	CALL C004
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0257
; 730: 				speed = speed + speed_step
	MOVF 0x4D,W
	ADDWF 0x45,W
	MOVWF 0x4D
	MOVF 0x4E,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x4E
; 731: 			Endif
L0257:
; 732: 		Endif
L0256:
; 733: 	Endif
L0255:
; 734: Return
	RETURN
; 735: 
; 736: 
; 737: relays:
L0009:
; 738: 	Gosub read_bridge_switch
	BSF PCLATH,3
	CALL L0013
; 739: 	If bridge_power = 0 Then  'BRIDGE MUST BE SWITCHED OFF
	BSF PCLATH,3
	BTFSC 0x3E,3
	GOTO L0258
; 740: 		If onoff = 1 Then  'the motor has stopped
	BSF PCLATH,3
	BTFSS 0x3E,2
	GOTO L0259
; 741: 			Select Case ctrl_type
; 742: 			Case 1, 3, 5, 6
	MOVF 0x32,W
	SUBLW 0x01
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0262
	BSF PCLATH,3
	GOTO L0261
L0262:
	MOVF 0x32,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0263
	BSF PCLATH,3
	GOTO L0261
L0263:
	MOVF 0x32,W
	SUBLW 0x05
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0264
	BSF PCLATH,3
	GOTO L0261
L0264:
	MOVF 0x32,W
	SUBLW 0x06
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0260
L0261:
; 743: 				swfw = 0
	BCF 0x06,0
; 744: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 745: 				swrev = 1
	BSF 0x06,1
; 746: 			Case Else
	BSF PCLATH,3
	GOTO L0265
L0260:
; 747: 				swfw = 0  'first both relays off
	BCF 0x06,0
; 748: 				swrev = 0
	BCF 0x06,1
; 749: 				WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 750: 				swfw = bridge_switch
	BTFSC 0x3E,0
	BSF 0x06,0
	BTFSS 0x3E,0
	BCF 0x06,0
; 751: 				swrev = Not bridge_switch
	BTFSS 0x3E,0
	BSF 0x06,1
	BTFSC 0x3E,0
	BCF 0x06,1
; 752: 			EndSelect
L0265:
; 753: 		Else  'motor is moving
	BSF PCLATH,3
	GOTO L0266
L0259:
; 754: 			swfw = 0
	BCF 0x06,0
; 755: 			swrev = 0
	BCF 0x06,1
; 756: 		Endif
L0266:
; 757: 	Else  'bridge remains under power
	BSF PCLATH,3
	GOTO L0267
L0258:
; 758: 		swfw = bridge_switch
	BTFSC 0x3E,0
	BSF 0x06,0
	BTFSS 0x3E,0
	BCF 0x06,0
; 759: 		WaitMs 2
	MOVLW 0x02
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 760: 		swrev = Not bridge_switch
	BTFSS 0x3E,0
	BSF 0x06,1
	BTFSC 0x3E,0
	BCF 0x06,1
; 761: 	Endif
L0267:
; 762: Return
	RETURN
; 763: 
; 764: 
; 765: init_eeprom:
L0010:
; 766: 	If pgm = 0 Then  'special for my own fiddle yard
	BSF PCLATH,3
	BTFSC 0x07,7
	GOTO L0268
; 767: 		new_steps = 178
	MOVLW 0xB2
	MOVWF 0x36
	CLRF 0x37
; 768: 		For act_pos = 0 To 11
	CLRF 0x31
L0269:
	MOVF 0x31,W
	SUBLW 0x0B
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0270
; 769: 			Gosub save_steps
	BSF PCLATH,3
	CALL L0015
; 770: 			new_steps = new_steps + 4300
	MOVF 0x36,W
	ADDLW 0xCC
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x10
	MOVWF 0x37
; 771: 		Next act_pos
	MOVLW 0x01
	ADDWF 0x31,F
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0269
L0270:
; 772: 		Write mem_max_pos, 11
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x0B
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0271:	BTFSC EECON1,WR
	GOTO L0271
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 773: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x33
; 774: 	Else
	BSF PCLATH,3
	GOTO L0272
L0268:
; 775: 		new_steps = 0
	CLRF 0x36
	CLRF 0x37
; 776: 		For act_pos = 0 To max_pos
	CLRF 0x31
L0273:
	MOVF 0x31,W
	SUBWF 0x33,W
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0274
; 777: 			steps = one_round / max_pos  'devide the steps between min and max
	MOVF 0x38,W
	MOVWF R0L
	MOVF 0x39,W
	MOVWF R0H
	MOVF 0x33,W
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x34
	MOVF R0H,W
	MOVWF 0x35
; 778: 			new_steps = new_steps + steps
	MOVF 0x36,W
	ADDWF 0x34,W
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x35,W
	MOVWF 0x37
; 779: 			Gosub save_steps
	BSF PCLATH,3
	CALL L0015
; 780: 			bridge_switch = 0
	BCF 0x3E,0
; 781: 			Gosub store_bridge_switch
	BSF PCLATH,3
	CALL L0014
; 782: 		Next act_pos
	MOVLW 0x01
	ADDWF 0x31,F
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0273
L0274:
; 783: 	Endif
L0272:
; 784: 	free_space_steps = 0
	CLRF 0x42
; 785: 	Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0275:	BTFSC EECON1,WR
	GOTO L0275
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 786: 	one_round = 8000
	MOVLW 0x40
	MOVWF 0x38
	MOVLW 0x1F
	MOVWF 0x39
; 787: 	Write mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x38,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0276:	BTFSC EECON1,WR
	GOTO L0276
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 788: 	Write mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0277:	BTFSC EECON1,WR
	GOTO L0277
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 789: 	act_pos = 0
	CLRF 0x31
; 790: 	Write mem_act_pos, 1  'act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x01
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0278:	BTFSC EECON1,WR
	GOTO L0278
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 791: Return
	RETURN
; 792: 
; 793: init_values:
L0011:
; 794: 	version = 0  'decimal point in display on
	BCF 0x3E,5
; 795: 	Gosub i2c_display
	BCF PCLATH,3
	CALL L0005
; 796: 	WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
	BCF PCLATH,3
	CALL W001
; 797: 	version = 1  'decimal point in display off
	BSF 0x3E,5
; 798: 	encoder_count = 0
	CLRF 0x4A
; 799: 	speed_min = 0
	CLRF 0x3C
	CLRF 0x3D
; 800: 	Read mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3D
; 801: 	If speed_min.HB > 99 Then
	MOVF 0x3D,W
	SUBLW 0x63
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0279
; 802: 		speed_min.HB = 40
	MOVLW 0x28
	MOVWF 0x3D
; 803: 	Else
	BSF PCLATH,3
	GOTO L0280
L0279:
; 804: 		If speed_min.HB < 1 Then
	MOVLW 0x01
	SUBWF 0x3D,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0281
; 805: 			speed_min.HB = 40
	MOVLW 0x28
	MOVWF 0x3D
; 806: 		Endif
L0281:
; 807: 	Endif
L0280:
; 808: 	speed_max = 0
	CLRF 0x3A
	CLRF 0x3B
; 809: 	Read mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3B
; 810: 	If speed_max.HB > speed_min.HB Then
	MOVF 0x3B,W
	SUBWF 0x3D,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0282
; 811: 		speed_max.HB = speed_min.HB
	MOVF 0x3D,W
	MOVWF 0x3B
; 812: 	Else
	BSF PCLATH,3
	GOTO L0283
L0282:
; 813: 		If speed_max.HB < 1 Then
	MOVLW 0x01
	SUBWF 0x3B,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0284
; 814: 			speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x3B
; 815: 		Endif
L0284:
; 816: 	Endif
L0283:
; 817: 
; 818: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x38
; 819: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 820: 	If one_round = 0 Then
	MOVF 0x38,W
	MOVWF R0L
	MOVF 0x39,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL C001
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0285
; 821: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x38
	MOVLW 0x1F
	MOVWF 0x39
; 822: 	Endif
L0285:
; 823: 	If one_round > 60000 Then
	MOVF 0x38,W
	MOVWF R0L
	MOVF 0x39,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
	BCF PCLATH,3
	CALL C003
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0286
; 824: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x38
	MOVLW 0x1F
	MOVWF 0x39
; 825: 	Endif
L0286:
; 826: 	one_round_half = one_round / 2
	MOVF 0x38,W
	MOVWF R0L
	MOVF 0x39,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x55
	MOVF R0H,W
	MOVWF 0x56
; 827: 
; 828: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x32
; 829: 	If ctrl_type > 6 Then
	MOVF 0x32,W
	SUBLW 0x06
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0287
; 830: 		ctrl_type = 6
	MOVLW 0x06
	MOVWF 0x32
; 831: 	Endif
L0287:
; 832: 
; 833: 	Read mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 834: 	Select Case ctrl_type
; 835: 	Case 6
	MOVF 0x32,W
	SUBLW 0x06
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0288
; 836: 		If max_pos > 30 Then
	MOVF 0x33,W
	SUBLW 0x1E
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0289
; 837: 			max_pos = 12
	MOVLW 0x0C
	MOVWF 0x33
; 838: 		Endif
L0289:
; 839: 	Case Else
	BSF PCLATH,3
	GOTO L0290
L0288:
; 840: 		If max_pos > 47 Then
	MOVF 0x33,W
	SUBLW 0x2F
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0291
; 841: 			max_pos = 47
	MOVLW 0x2F
	MOVWF 0x33
; 842: 		Endif
L0291:
; 843: 	EndSelect
L0290:
; 844: 	Read mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 845: 	If act_pos > max_pos Then
	MOVF 0x31,W
	SUBWF 0x33,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0292
; 846: 		act_pos = 0
	CLRF 0x31
; 847: 	Endif
L0292:
; 848: 	Read mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x42
; 849: 	If free_space_steps > 99 Then
	MOVF 0x42,W
	SUBLW 0x63
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0293
; 850: 		free_space_steps = 0
	CLRF 0x42
; 851: 	Endif
L0293:
; 852: 
; 853: 	Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 854: 	If turn_counter > 131 Then  'in program impossible value
	MOVF 0x40,W
	SUBLW 0x83
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0294
; 855: 		turn_counter = 128
	MOVLW 0x80
	MOVWF 0x40
; 856: 	Else
	BSF PCLATH,3
	GOTO L0295
L0294:
; 857: 		If turn_counter < 125 Then  'in program impossible value
	MOVLW 0x7D
	SUBWF 0x40,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0296
; 858: 			turn_counter = 128
	MOVLW 0x80
	MOVWF 0x40
; 859: 		Endif
L0296:
; 860: 	Endif
L0295:
; 861: 	
; 862: 	Read mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x45
; 863: 	If speed_step > 99 Then
	MOVF 0x45,W
	SUBLW 0x63
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0297
; 864: 		speed_step = 0
	CLRF 0x45
; 865: 	Endif
L0297:
; 866: 	
; 867: 	If eep = 1 Then  'jumper set for initialisation
	BSF PCLATH,3
	BTFSS 0x06,6
	GOTO L0298
; 868: 		Gosub init_eeprom
	BSF PCLATH,3
	CALL L0010
; 869: 	Endif
L0298:
; 870: 	steps_set = 0
	BCF 0x3E,1
; 871: 	new_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x4B
; 872: 	bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x4C
; 873: 	old_bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x57
; 874: 	manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x41
; 875: 	old_manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x52
; 876: Return
	RETURN
; 877: 
; 878: steps_reading:
L0012:
; 879: 	If new_pos = 63 Then
	MOVF 0x4B,W
	SUBLW 0x3F
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0299
; 880: 		new_steps = 0
	CLRF 0x36
	CLRF 0x37
; 881: 		act_steps = 0
	CLRF 0x46
	CLRF 0x47
; 882: 	Else
	BSF PCLATH,3
	GOTO L0300
L0299:
; 883: 		eprom_pointer = act_pos + 48
	MOVF 0x31,W
	ADDLW 0x30
	MOVWF 0x50
; 884: 		Read act_pos, act_steps.LB
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x46
; 885: 		Read eprom_pointer, act_steps.HB
	MOVF 0x50,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x47
; 886: 		eprom_pointer = new_pos + 48
	MOVF 0x4B,W
	ADDLW 0x30
	MOVWF 0x50
; 887: 		Read new_pos, new_steps.LB
	MOVF 0x4B,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 888: 		Read eprom_pointer, new_steps.HB
	MOVF 0x50,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 889: 		Read mem_free_space, value
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 890: 		free_space_word = free_space_steps * 10
	MOVF 0x42,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x58
	MOVF R2H,W
	MOVWF 0x59
; 891: 	Endif
L0300:
; 892: Return
	RETURN
; 893: 
; 894: read_bridge_switch:
L0013:
; 895: 	Select Case act_pos
; 896: 	Case < 8
	MOVLW 0x08
	SUBWF 0x31,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0301
; 897: 		Read mem_bridge_switch1, value
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 898: 	Case < 16
	BSF PCLATH,3
	GOTO L0302
L0301:
	MOVLW 0x10
	SUBWF 0x31,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0303
; 899: 		Read mem_bridge_switch2, value
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 900: 	Case < 24
	BSF PCLATH,3
	GOTO L0304
L0303:
	MOVLW 0x18
	SUBWF 0x31,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0305
; 901: 		Read mem_bridge_switch3, value
	MOVLW 0x73
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 902: 	Case < 32
	BSF PCLATH,3
	GOTO L0306
L0305:
	MOVLW 0x20
	SUBWF 0x31,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0307
; 903: 		Read mem_bridge_switch4, value
	MOVLW 0x74
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 904: 	Case < 40
	BSF PCLATH,3
	GOTO L0308
L0307:
	MOVLW 0x28
	SUBWF 0x31,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0309
; 905: 		Read mem_bridge_switch5, value
	MOVLW 0x75
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 906: 	Case Else
	BSF PCLATH,3
	GOTO L0310
L0309:
; 907: 		Read mem_bridge_switch6, value
	MOVLW 0x76
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 908: 	EndSelect
L0310:
L0308:
L0306:
L0304:
L0302:
; 909: 	value2 = act_pos Mod 8
	MOVF 0x31,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x08
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x43
; 910: 	Select Case value2
; 911: 	Case 0
	MOVF 0x43,W
	SUBLW 0x00
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0311
; 912: 		bridge_switch = value.0
	BTFSC 0x30,0
	BSF 0x3E,0
	BTFSS 0x30,0
	BCF 0x3E,0
; 913: 	Case 1
	BSF PCLATH,3
	GOTO L0312
L0311:
	MOVF 0x43,W
	SUBLW 0x01
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0313
; 914: 		bridge_switch = value.1
	BTFSC 0x30,1
	BSF 0x3E,0
	BTFSS 0x30,1
	BCF 0x3E,0
; 915: 	Case 2
	BSF PCLATH,3
	GOTO L0314
L0313:
	MOVF 0x43,W
	SUBLW 0x02
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0315
; 916: 		bridge_switch = value.2
	BTFSC 0x30,2
	BSF 0x3E,0
	BTFSS 0x30,2
	BCF 0x3E,0
; 917: 	Case 3
	BSF PCLATH,3
	GOTO L0316
L0315:
	MOVF 0x43,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0317
; 918: 		bridge_switch = value.3
	BTFSC 0x30,3
	BSF 0x3E,0
	BTFSS 0x30,3
	BCF 0x3E,0
; 919: 	Case 4
	BSF PCLATH,3
	GOTO L0318
L0317:
	MOVF 0x43,W
	SUBLW 0x04
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0319
; 920: 		bridge_switch = value.4
	BTFSC 0x30,4
	BSF 0x3E,0
	BTFSS 0x30,4
	BCF 0x3E,0
; 921: 	Case 5
	BSF PCLATH,3
	GOTO L0320
L0319:
	MOVF 0x43,W
	SUBLW 0x05
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0321
; 922: 		bridge_switch = value.5
	BTFSC 0x30,5
	BSF 0x3E,0
	BTFSS 0x30,5
	BCF 0x3E,0
; 923: 	Case 6
	BSF PCLATH,3
	GOTO L0322
L0321:
	MOVF 0x43,W
	SUBLW 0x06
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0323
; 924: 		bridge_switch = value.6
	BTFSC 0x30,6
	BSF 0x3E,0
	BTFSS 0x30,6
	BCF 0x3E,0
; 925: 	Case Else
	BSF PCLATH,3
	GOTO L0324
L0323:
; 926: 		bridge_switch = value.7
	BTFSC 0x30,7
	BSF 0x3E,0
	BTFSS 0x30,7
	BCF 0x3E,0
; 927: 	EndSelect
L0324:
L0322:
L0320:
L0318:
L0316:
L0314:
L0312:
; 928: Return
	RETURN
; 929: store_bridge_switch:
L0014:
; 930: 	Select Case act_pos
; 931: 	Case < 8
	MOVLW 0x08
	SUBWF 0x31,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0325
; 932: 		Read mem_bridge_switch1, value
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 933: 	Case < 16
	BSF PCLATH,3
	GOTO L0326
L0325:
	MOVLW 0x10
	SUBWF 0x31,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0327
; 934: 		Read mem_bridge_switch2, value
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 935: 	Case < 24
	BSF PCLATH,3
	GOTO L0328
L0327:
	MOVLW 0x18
	SUBWF 0x31,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0329
; 936: 		Read mem_bridge_switch3, value
	MOVLW 0x73
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 937: 	Case < 32
	BSF PCLATH,3
	GOTO L0330
L0329:
	MOVLW 0x20
	SUBWF 0x31,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0331
; 938: 		Read mem_bridge_switch4, value
	MOVLW 0x74
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 939: 	Case < 40
	BSF PCLATH,3
	GOTO L0332
L0331:
	MOVLW 0x28
	SUBWF 0x31,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0333
; 940: 		Read mem_bridge_switch5, value
	MOVLW 0x75
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 941: 	Case Else
	BSF PCLATH,3
	GOTO L0334
L0333:
; 942: 		Read mem_bridge_switch6, value
	MOVLW 0x76
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 943: 	EndSelect
L0334:
L0332:
L0330:
L0328:
L0326:
; 944: 	value2 = act_pos
	MOVF 0x31,W
	MOVWF 0x43
; 945: 	value2 = value2 Mod 8
	MOVF 0x43,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x08
	MOVWF R1L
	CLRF R1H
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x43
; 946: 	Select Case value2
; 947: 	Case 0
	MOVF 0x43,W
	SUBLW 0x00
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0335
; 948: 		value.0 = bridge_switch
	BTFSC 0x3E,0
	BSF 0x30,0
	BTFSS 0x3E,0
	BCF 0x30,0
; 949: 	Case 1
	BSF PCLATH,3
	GOTO L0336
L0335:
	MOVF 0x43,W
	SUBLW 0x01
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0337
; 950: 		value.1 = bridge_switch
	BTFSC 0x3E,0
	BSF 0x30,1
	BTFSS 0x3E,0
	BCF 0x30,1
; 951: 	Case 2
	BSF PCLATH,3
	GOTO L0338
L0337:
	MOVF 0x43,W
	SUBLW 0x02
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0339
; 952: 		value.2 = bridge_switch
	BTFSC 0x3E,0
	BSF 0x30,2
	BTFSS 0x3E,0
	BCF 0x30,2
; 953: 	Case 3
	BSF PCLATH,3
	GOTO L0340
L0339:
	MOVF 0x43,W
	SUBLW 0x03
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0341
; 954: 		value.3 = bridge_switch
	BTFSC 0x3E,0
	BSF 0x30,3
	BTFSS 0x3E,0
	BCF 0x30,3
; 955: 	Case 4
	BSF PCLATH,3
	GOTO L0342
L0341:
	MOVF 0x43,W
	SUBLW 0x04
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0343
; 956: 		value.4 = bridge_switch
	BTFSC 0x3E,0
	BSF 0x30,4
	BTFSS 0x3E,0
	BCF 0x30,4
; 957: 	Case 5
	BSF PCLATH,3
	GOTO L0344
L0343:
	MOVF 0x43,W
	SUBLW 0x05
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0345
; 958: 		value.5 = bridge_switch
	BTFSC 0x3E,0
	BSF 0x30,5
	BTFSS 0x3E,0
	BCF 0x30,5
; 959: 	Case 6
	BSF PCLATH,3
	GOTO L0346
L0345:
	MOVF 0x43,W
	SUBLW 0x06
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0347
; 960: 		value.6 = bridge_switch
	BTFSC 0x3E,0
	BSF 0x30,6
	BTFSS 0x3E,0
	BCF 0x30,6
; 961: 	Case Else
	BSF PCLATH,3
	GOTO L0348
L0347:
; 962: 		value.7 = bridge_switch
	BTFSC 0x3E,0
	BSF 0x30,7
	BTFSS 0x3E,0
	BCF 0x30,7
; 963: 	EndSelect
L0348:
L0346:
L0344:
L0342:
L0340:
L0338:
L0336:
; 964: 	Select Case act_pos
; 965: 	Case < 8
	MOVLW 0x08
	SUBWF 0x31,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0349
; 966: 		Write mem_bridge_switch1, value
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0350:	BTFSC EECON1,WR
	GOTO L0350
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 967: 	Case < 16
	BSF PCLATH,3
	GOTO L0351
L0349:
	MOVLW 0x10
	SUBWF 0x31,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0352
; 968: 		Write mem_bridge_switch2, value
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0353:	BTFSC EECON1,WR
	GOTO L0353
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 969: 	Case < 24
	BSF PCLATH,3
	GOTO L0354
L0352:
	MOVLW 0x18
	SUBWF 0x31,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0355
; 970: 		Write mem_bridge_switch3, value
	MOVLW 0x73
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0356:	BTFSC EECON1,WR
	GOTO L0356
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 971: 	Case < 32
	BSF PCLATH,3
	GOTO L0357
L0355:
	MOVLW 0x20
	SUBWF 0x31,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0358
; 972: 		Write mem_bridge_switch4, value
	MOVLW 0x74
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0359:	BTFSC EECON1,WR
	GOTO L0359
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 973: 	Case < 40
	BSF PCLATH,3
	GOTO L0360
L0358:
	MOVLW 0x28
	SUBWF 0x31,W
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0361
; 974: 		Write mem_bridge_switch5, value
	MOVLW 0x75
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0362:	BTFSC EECON1,WR
	GOTO L0362
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 975: 	Case Else
	BSF PCLATH,3
	GOTO L0363
L0361:
; 976: 		Write mem_bridge_switch6, value
	MOVLW 0x76
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0364:	BTFSC EECON1,WR
	GOTO L0364
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 977: 	EndSelect
L0363:
L0360:
L0357:
L0354:
L0351:
; 978: Return
	RETURN
; 979: 
; 980: save_steps:
L0015:
; 981: 	eprom_pointer = act_pos + 48
	MOVF 0x31,W
	ADDLW 0x30
	MOVWF 0x50
; 982: 	Write act_pos, new_steps.LB
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0365:	BTFSC EECON1,WR
	GOTO L0365
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 983: 	Write eprom_pointer, new_steps.HB
	MOVF 0x50,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
	BSF PCLATH,3
L0366:	BTFSC EECON1,WR
	GOTO L0366
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 984: Return
	RETURN
; 985: 
; 986: stop_the_motor:
L0016:
; 987: 	While ecsw = 1
L0367:
	BSF PCLATH,3
	BTFSS 0x07,6
	GOTO L0368
; 988: 		WaitMs 250
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
	BCF PCLATH,3
	CALL W001
; 989: 	Wend
	BSF PCLATH,3
	GOTO L0367
L0368:
; 990: Return
	RETURN
; End of program
	BSF PCLATH,3
L0369:	GOTO L0369
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
