	list p=16f628
	#include <p16f628.inc>
	radix dec
; Compiled with: PIC Simulator IDE v6.71
; Microcontroller model: PIC16F628
; Clock frequency: 4.0 MHz
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0003
	ORG 0x0004
	RETFIE
L0003:
; 1: Define CONF_WORD = 0x3f50
; 2: 
; 3:  'program servo motors
; 4:  'print MGV81 V1.2  with feed-backs
; 5: 
; 6: 
; 7: Dim counter As Byte
;       The address of 'counter' is 0x2C
	counter EQU 0x2C
; 8: Dim dummy As Byte
;       The address of 'dummy' is 0x2D
	dummy EQU 0x2D
; 9: Dim servoposition1 As Byte
;       The address of 'servoposition1' is 0x2E
	servoposition1 EQU 0x2E
; 10: Dim servoposition2 As Byte
;       The address of 'servoposition2' is 0x2F
	servoposition2 EQU 0x2F
; 11: Dim servoposition3 As Byte
;       The address of 'servoposition3' is 0x30
	servoposition3 EQU 0x30
; 12: Dim servoposition4 As Byte
;       The address of 'servoposition4' is 0x31
	servoposition4 EQU 0x31
; 13: Dim servo_time As Byte
;       The address of 'servo_time' is 0x32
	servo_time EQU 0x32
; 14: Dim ledcounter As Byte
;       The address of 'ledcounter' is 0x33
	ledcounter EQU 0x33
; 15: 
; 16: Symbol turnout_req1 = PORTB.0
;       The address of 'turnout_req1' is 0x6,0
; 17: Symbol turnout_req2 = PORTB.1
;       The address of 'turnout_req2' is 0x6,1
; 18: Symbol turnout_req3 = PORTB.2
;       The address of 'turnout_req3' is 0x6,2
; 19: Symbol turnout_req4 = PORTB.3
;       The address of 'turnout_req4' is 0x6,3
; 20: Symbol servo1 = PORTB.4
;       The address of 'servo1' is 0x6,4
; 21: Symbol servo2 = PORTB.5
;       The address of 'servo2' is 0x6,5
; 22: Symbol servo3 = PORTB.6
;       The address of 'servo3' is 0x6,6
; 23: Symbol servo4 = PORTB.7
;       The address of 'servo4' is 0x6,7
; 24: 
; 25: Symbol feed_back1 = PORTA.6
;       The address of 'feed_back1' is 0x5,6
; 26: Symbol feed_back2 = PORTA.7
;       The address of 'feed_back2' is 0x5,7
; 27: Symbol feed_back3 = PORTA.2
;       The address of 'feed_back3' is 0x5,2
; 28: Symbol feed_back4 = PORTA.3
;       The address of 'feed_back4' is 0x5,3
; 29: Symbol speed_select = PORTA.0
;       The address of 'speed_select' is 0x5,0
; 30: Symbol led = PORTA.4
;       The address of 'led' is 0x5,4
; 31: CMCON = 7
	MOVLW 0x07
	MOVWF 0x1F
; 32: AllDigital
	MOVLW 0x07
	MOVWF 0x1F
; 33: TRISA = %00000001
	BSF STATUS,RP0
	MOVLW 0x01
	MOVWF 0x05
; 34: TRISB = %00001111
	MOVLW 0x0F
	MOVWF 0x06
; 35: PORTA = %00000001
	BCF STATUS,RP0
	MOVLW 0x01
	MOVWF 0x05
; 36: PORTB = %00001111
	MOVLW 0x0F
	MOVWF 0x06
; 37: If speed_select = 0 Then 'jumper is set
	BTFSC 0x05,0
	GOTO L0004
; 38: servo_time = 50
	MOVLW 0x32
	MOVWF 0x32
; 39: Else
	GOTO L0005
L0004:	MOVLW 0x1F
	ANDWF STATUS,F
; 40: servo_time = 10
	MOVLW 0x0A
	MOVWF 0x32
; 41: Endif
L0005:	MOVLW 0x1F
	ANDWF STATUS,F
; 42: dummy = 0
	CLRF 0x2D
; 43:  'now read all saved positions
; 44: Read 0, servoposition1
	MOVLW 0x00
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x2E
; 45: Read 1, servoposition2
	MOVLW 0x01
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x2F
; 46: Read 2, servoposition3
	MOVLW 0x02
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x30
; 47: Read 3, servoposition4
	MOVLW 0x03
	BSF STATUS,RP0
	MOVWF EEADR
	BSF EECON1,RD
	NOP
	MOVF EEDATA,W
	BCF STATUS,RP0
	MOVWF 0x31
; 48:  'set the correct feed-backs
; 49: If servoposition1 = 1 Then
	MOVF 0x2E,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0006
; 50: feed_back1 = 1
	BSF 0x05,6
; 51: Endif
L0006:	MOVLW 0x1F
	ANDWF STATUS,F
; 52: If servoposition2 = 1 Then
	MOVF 0x2F,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0007
; 53: feed_back2 = 1
	BSF 0x05,7
; 54: Endif
L0007:	MOVLW 0x1F
	ANDWF STATUS,F
; 55: If servoposition3 = 1 Then
	MOVF 0x30,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0008
; 56: feed_back3 = 1
	BSF 0x05,2
; 57: Endif
L0008:	MOVLW 0x1F
	ANDWF STATUS,F
; 58: If servoposition4 = 1 Then
	MOVF 0x31,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0009
; 59: feed_back4 = 1
	BSF 0x05,3
; 60: Endif
L0009:	MOVLW 0x1F
	ANDWF STATUS,F
; 61: 
; 62: WaitMs 5000 'wait 5 seconds to enable MGV50 to finish Loconet communication
	MOVLW 0x88
	MOVWF R0L
	MOVLW 0x13
	MOVWF R0H
	CALL W001
; 63: main:  'endless loop
L0001:
; 64: ledcounter = ledcounter + 1
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x33
; 65: If ledcounter = 0 Then
	MOVF 0x33,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0010
; 66: led = 0
	BCF 0x05,4
; 67: Endif
L0010:	MOVLW 0x1F
	ANDWF STATUS,F
; 68: If ledcounter = 5 Then
	MOVF 0x33,W
	SUBLW 0x05
	BTFSS STATUS,Z
	GOTO L0011
; 69: led = 1
	BSF 0x05,4
; 70: Endif
L0011:	MOVLW 0x1F
	ANDWF STATUS,F
; 71: WaitMs 4 'this makes led 20 milliSecs flash approx every second
	MOVLW 0x04
	MOVWF R0L
	CLRF R0H
	CALL W001
; 72:  'motor 1
; 73: If turnout_req1 = 0 Then
	BTFSC 0x06,0
	GOTO L0012
; 74: If servoposition1 > 0 Then 'servo left turn
	MOVF 0x2E,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0013
; 75: Gosub check_speed
	CALL L0002
; 76: servoposition1 = 0
	CLRF 0x2E
; 77: counter = 200
	MOVLW 0xC8
	MOVWF 0x2C
; 78: While counter > 99
L0014:
	MOVF 0x2C,W
	SUBLW 0x63
	BTFSC STATUS,C
	GOTO L0015
; 79: WaitMs servo_time
	MOVF 0x32,W
	MOVWF R0L
	CLRF R0H
	CALL W001
; 80: ServoOut servo1, counter
	MOVF 0x2C,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0017
	BSF PORTB,4
L0016:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0016
	BCF PORTB,4
L0017:
; 81: counter = counter - 1
	MOVLW 0x01
	SUBWF 0x2C,W
	MOVWF 0x2C
; 82: Wend
	GOTO L0014
L0015:	MOVLW 0x1F
	ANDWF STATUS,F
; 83: Write 0, 0
	MOVLW 0x00
	BSF STATUS,RP0
	MOVWF EEADR
	MOVLW 0x00
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0018:	BTFSC EECON1,WR
	GOTO L0018
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 84: feed_back1 = 0
	BCF 0x05,6
; 85: Endif
L0013:	MOVLW 0x1F
	ANDWF STATUS,F
; 86: Else
	GOTO L0019
L0012:	MOVLW 0x1F
	ANDWF STATUS,F
; 87: If servoposition1 = 0 Then 'servo right turn
	MOVF 0x2E,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0020
; 88: Gosub check_speed
	CALL L0002
; 89: servoposition1 = 1
	MOVLW 0x01
	MOVWF 0x2E
; 90: counter = 100
	MOVLW 0x64
	MOVWF 0x2C
; 91: While counter < 201
L0021:
	MOVLW 0xC9
	SUBWF 0x2C,W
	BTFSC STATUS,C
	GOTO L0022
; 92: WaitMs servo_time
	MOVF 0x32,W
	MOVWF R0L
	CLRF R0H
	CALL W001
; 93: ServoOut servo1, counter
	MOVF 0x2C,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0024
	BSF PORTB,4
L0023:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0023
	BCF PORTB,4
L0024:
; 94: counter = counter + 1
	MOVF 0x2C,W
	ADDLW 0x01
	MOVWF 0x2C
; 95: Wend
	GOTO L0021
L0022:	MOVLW 0x1F
	ANDWF STATUS,F
; 96: Write 0, 1
	MOVLW 0x00
	BSF STATUS,RP0
	MOVWF EEADR
	MOVLW 0x01
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0025:	BTFSC EECON1,WR
	GOTO L0025
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 97: feed_back1 = 1
	BSF 0x05,6
; 98: Endif
L0020:	MOVLW 0x1F
	ANDWF STATUS,F
; 99: Endif
L0019:	MOVLW 0x1F
	ANDWF STATUS,F
; 100:  'motor 2
; 101: If turnout_req2 = 0 Then
	BTFSC 0x06,1
	GOTO L0026
; 102: If servoposition2 > 0 Then 'servo left turn
	MOVF 0x2F,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0027
; 103: Gosub check_speed
	CALL L0002
; 104: servoposition2 = 0
	CLRF 0x2F
; 105: counter = 200
	MOVLW 0xC8
	MOVWF 0x2C
; 106: While counter > 99
L0028:
	MOVF 0x2C,W
	SUBLW 0x63
	BTFSC STATUS,C
	GOTO L0029
; 107: WaitMs servo_time
	MOVF 0x32,W
	MOVWF R0L
	CLRF R0H
	CALL W001
; 108: ServoOut servo2, counter
	MOVF 0x2C,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0031
	BSF PORTB,5
L0030:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0030
	BCF PORTB,5
L0031:
; 109: counter = counter - 1
	MOVLW 0x01
	SUBWF 0x2C,W
	MOVWF 0x2C
; 110: Wend
	GOTO L0028
L0029:	MOVLW 0x1F
	ANDWF STATUS,F
; 111: Write 1, 0
	MOVLW 0x01
	BSF STATUS,RP0
	MOVWF EEADR
	MOVLW 0x00
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0032:	BTFSC EECON1,WR
	GOTO L0032
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 112: feed_back2 = 0
	BCF 0x05,7
; 113: Endif
L0027:	MOVLW 0x1F
	ANDWF STATUS,F
; 114: Else
	GOTO L0033
L0026:	MOVLW 0x1F
	ANDWF STATUS,F
; 115: If servoposition2 = 0 Then 'servo right turn
	MOVF 0x2F,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0034
; 116: Gosub check_speed
	CALL L0002
; 117: servoposition2 = 1
	MOVLW 0x01
	MOVWF 0x2F
; 118: counter = 100
	MOVLW 0x64
	MOVWF 0x2C
; 119: While counter < 201
L0035:
	MOVLW 0xC9
	SUBWF 0x2C,W
	BTFSC STATUS,C
	GOTO L0036
; 120: WaitMs servo_time
	MOVF 0x32,W
	MOVWF R0L
	CLRF R0H
	CALL W001
; 121: ServoOut servo2, counter
	MOVF 0x2C,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0038
	BSF PORTB,5
L0037:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0037
	BCF PORTB,5
L0038:
; 122: counter = counter + 1
	MOVF 0x2C,W
	ADDLW 0x01
	MOVWF 0x2C
; 123: Wend
	GOTO L0035
L0036:	MOVLW 0x1F
	ANDWF STATUS,F
; 124: Write 1, 1
	MOVLW 0x01
	BSF STATUS,RP0
	MOVWF EEADR
	MOVLW 0x01
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0039:	BTFSC EECON1,WR
	GOTO L0039
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 125: feed_back2 = 1
	BSF 0x05,7
; 126: Endif
L0034:	MOVLW 0x1F
	ANDWF STATUS,F
; 127: Endif
L0033:	MOVLW 0x1F
	ANDWF STATUS,F
; 128:  'motor 3
; 129: If turnout_req3 = 0 Then
	BTFSC 0x06,2
	GOTO L0040
; 130: If servoposition3 > 0 Then 'servo left turn
	MOVF 0x30,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0041
; 131: Gosub check_speed
	CALL L0002
; 132: servoposition3 = 0
	CLRF 0x30
; 133: counter = 200
	MOVLW 0xC8
	MOVWF 0x2C
; 134: While counter > 99
L0042:
	MOVF 0x2C,W
	SUBLW 0x63
	BTFSC STATUS,C
	GOTO L0043
; 135: WaitMs servo_time
	MOVF 0x32,W
	MOVWF R0L
	CLRF R0H
	CALL W001
; 136: ServoOut servo3, counter
	MOVF 0x2C,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0045
	BSF PORTB,6
L0044:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0044
	BCF PORTB,6
L0045:
; 137: counter = counter - 1
	MOVLW 0x01
	SUBWF 0x2C,W
	MOVWF 0x2C
; 138: Wend
	GOTO L0042
L0043:	MOVLW 0x1F
	ANDWF STATUS,F
; 139: Write 2, 0
	MOVLW 0x02
	BSF STATUS,RP0
	MOVWF EEADR
	MOVLW 0x00
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0046:	BTFSC EECON1,WR
	GOTO L0046
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 140: feed_back3 = 0
	BCF 0x05,2
; 141: Endif
L0041:	MOVLW 0x1F
	ANDWF STATUS,F
; 142: Else
	GOTO L0047
L0040:	MOVLW 0x1F
	ANDWF STATUS,F
; 143: If servoposition3 = 0 Then 'servo right turn
	MOVF 0x30,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0048
; 144: Gosub check_speed
	CALL L0002
; 145: servoposition3 = 1
	MOVLW 0x01
	MOVWF 0x30
; 146: counter = 100
	MOVLW 0x64
	MOVWF 0x2C
; 147: While counter < 201
L0049:
	MOVLW 0xC9
	SUBWF 0x2C,W
	BTFSC STATUS,C
	GOTO L0050
; 148: WaitMs servo_time
	MOVF 0x32,W
	MOVWF R0L
	CLRF R0H
	CALL W001
; 149: ServoOut servo3, counter
	MOVF 0x2C,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0052
	BSF PORTB,6
L0051:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0051
	BCF PORTB,6
L0052:
; 150: counter = counter + 1
	MOVF 0x2C,W
	ADDLW 0x01
	MOVWF 0x2C
; 151: Wend
	GOTO L0049
L0050:	MOVLW 0x1F
	ANDWF STATUS,F
; 152: Write 2, 1
	MOVLW 0x02
	BSF STATUS,RP0
	MOVWF EEADR
	MOVLW 0x01
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0053:	BTFSC EECON1,WR
	GOTO L0053
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 153: feed_back3 = 1
	BSF 0x05,2
; 154: Endif
L0048:	MOVLW 0x1F
	ANDWF STATUS,F
; 155: Endif
L0047:	MOVLW 0x1F
	ANDWF STATUS,F
; 156:  'motor 4
; 157: If turnout_req4 = 0 Then
	BTFSC 0x06,3
	GOTO L0054
; 158: If servoposition4 > 0 Then 'servo left turn
	MOVF 0x31,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0055
; 159: Gosub check_speed
	CALL L0002
; 160: servoposition4 = 0
	CLRF 0x31
; 161: counter = 200
	MOVLW 0xC8
	MOVWF 0x2C
; 162: While counter > 99
L0056:
	MOVF 0x2C,W
	SUBLW 0x63
	BTFSC STATUS,C
	GOTO L0057
; 163: WaitMs servo_time
	MOVF 0x32,W
	MOVWF R0L
	CLRF R0H
	CALL W001
; 164: ServoOut servo4, counter
	MOVF 0x2C,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0059
	BSF PORTB,7
L0058:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0058
	BCF PORTB,7
L0059:
; 165: counter = counter - 1
	MOVLW 0x01
	SUBWF 0x2C,W
	MOVWF 0x2C
; 166: Wend
	GOTO L0056
L0057:	MOVLW 0x1F
	ANDWF STATUS,F
; 167: Write 3, 0
	MOVLW 0x03
	BSF STATUS,RP0
	MOVWF EEADR
	MOVLW 0x00
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0060:	BTFSC EECON1,WR
	GOTO L0060
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 168: feed_back4 = 0
	BCF 0x05,3
; 169: Endif
L0055:	MOVLW 0x1F
	ANDWF STATUS,F
; 170: Else
	GOTO L0061
L0054:	MOVLW 0x1F
	ANDWF STATUS,F
; 171: If servoposition4 = 0 Then 'servo right turn
	MOVF 0x31,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0062
; 172: Gosub check_speed
	CALL L0002
; 173: servoposition4 = 1
	MOVLW 0x01
	MOVWF 0x31
; 174: counter = 100
	MOVLW 0x64
	MOVWF 0x2C
; 175: While counter < 201
L0063:
	MOVLW 0xC9
	SUBWF 0x2C,W
	BTFSC STATUS,C
	GOTO L0064
; 176: WaitMs servo_time
	MOVF 0x32,W
	MOVWF R0L
	CLRF R0H
	CALL W001
; 177: ServoOut servo4, counter
	MOVF 0x2C,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0066
	BSF PORTB,7
L0065:
	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0065
	BCF PORTB,7
L0066:
; 178: counter = counter + 1
	MOVF 0x2C,W
	ADDLW 0x01
	MOVWF 0x2C
; 179: Wend
	GOTO L0063
L0064:	MOVLW 0x1F
	ANDWF STATUS,F
; 180: Write 3, 1
	MOVLW 0x03
	BSF STATUS,RP0
	MOVWF EEADR
	MOVLW 0x01
	MOVWF EEDATA
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0067:	BTFSC EECON1,WR
	GOTO L0067
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 181: feed_back4 = 1
	BSF 0x05,3
; 182: Endif
L0062:	MOVLW 0x1F
	ANDWF STATUS,F
; 183: Endif
L0061:	MOVLW 0x1F
	ANDWF STATUS,F
; 184: 
; 185: Goto main
	GOTO L0001
; 186: End
L0068:	GOTO L0068
; 187: check_speed: 
L0002:
; 188: 
; 189: If speed_select = 0 Then 'jumper is set
	BTFSC 0x05,0
	GOTO L0069
; 190: servo_time = 50
	MOVLW 0x32
	MOVWF 0x32
; 191: Else
	GOTO L0070
L0069:	MOVLW 0x1F
	ANDWF STATUS,F
; 192: servo_time = 10
	MOVLW 0x0A
	MOVWF 0x32
; 193: Endif
L0070:	MOVLW 0x1F
	ANDWF STATUS,F
; 194: led = 0 'indicates that servo is moving
	BCF 0x05,4
; 195: 
; 196: Return
	RETURN
; End of program
L0071:	GOTO L0071
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x12
	MOVWF R1L
W005:	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
