Define CONF_WORD = 0x3f50

'program servo motors
'print MGV81 V1.2  with feed-backs


Dim counter As Byte
Dim dummy As Byte
Dim servoposition1 As Byte
Dim servoposition2 As Byte
Dim servoposition3 As Byte
Dim servoposition4 As Byte
Dim servo_time As Byte
Dim ledcounter As Byte

Symbol turnout_req1 = PORTB.0
Symbol turnout_req2 = PORTB.1
Symbol turnout_req3 = PORTB.2
Symbol turnout_req4 = PORTB.3
Symbol servo1 = PORTB.4
Symbol servo2 = PORTB.5
Symbol servo3 = PORTB.6
Symbol servo4 = PORTB.7

Symbol feed_back1 = PORTA.6
Symbol feed_back2 = PORTA.7
Symbol feed_back3 = PORTA.2
Symbol feed_back4 = PORTA.3
Symbol speed_select = PORTA.0
Symbol led = PORTA.4
CMCON = 7
AllDigital
TRISA = %00000001
TRISB = %00001111
PORTA = %00000001
PORTB = %00001111
If speed_select = 0 Then          'jumper is set
	servo_time = 50
Else
	servo_time = 10
Endif
dummy = 0
'now read all saved positions
Read 0, servoposition1
Read 1, servoposition2
Read 2, servoposition3
Read 3, servoposition4
'set the correct feed-backs
If servoposition1 = 1 Then
	feed_back1 = 1
Endif
If servoposition2 = 1 Then
	feed_back2 = 1
Endif
If servoposition3 = 1 Then
	feed_back3 = 1
Endif
If servoposition4 = 1 Then
	feed_back4 = 1
Endif

WaitMs 5000          'wait 5 seconds to enable MGV50 to finish Loconet communication
main:          'endless loop
	ledcounter = ledcounter + 1
	If ledcounter = 0 Then
		led = 0
	Endif
	If ledcounter = 5 Then
		led = 1
	Endif
	WaitMs 4          'this makes led 20 milliSecs flash approx every second
'motor 1
	If turnout_req1 = 0 Then
		If servoposition1 > 0 Then          'servo left turn
			Gosub check_speed
			servoposition1 = 0
			counter = 200
			While counter > 99
				WaitMs servo_time
				ServoOut servo1, counter
				counter = counter - 1
			Wend
			Write 0, 0
			feed_back1 = 0
		Endif
	Else
		If servoposition1 = 0 Then          'servo right turn
			Gosub check_speed
			servoposition1 = 1
			counter = 100
			While counter < 201
				WaitMs servo_time
				ServoOut servo1, counter
				counter = counter + 1
			Wend
			Write 0, 1
			feed_back1 = 1
		Endif
	Endif
'motor 2
	If turnout_req2 = 0 Then
		If servoposition2 > 0 Then          'servo left turn
			Gosub check_speed
			servoposition2 = 0
			counter = 200
			While counter > 99
				WaitMs servo_time
				ServoOut servo2, counter
				counter = counter - 1
			Wend
			Write 1, 0
			feed_back2 = 0
		Endif
	Else
		If servoposition2 = 0 Then          'servo right turn
			Gosub check_speed
			servoposition2 = 1
			counter = 100
			While counter < 201
				WaitMs servo_time
				ServoOut servo2, counter
				counter = counter + 1
			Wend
			Write 1, 1
			feed_back2 = 1
		Endif
	Endif
'motor 3
	If turnout_req3 = 0 Then
		If servoposition3 > 0 Then          'servo left turn
			Gosub check_speed
			servoposition3 = 0
			counter = 200
			While counter > 99
				WaitMs servo_time
				ServoOut servo3, counter
				counter = counter - 1
			Wend
			Write 2, 0
			feed_back3 = 0
		Endif
	Else
		If servoposition3 = 0 Then          'servo right turn
			Gosub check_speed
			servoposition3 = 1
			counter = 100
			While counter < 201
				WaitMs servo_time
				ServoOut servo3, counter
				counter = counter + 1
			Wend
			Write 2, 1
			feed_back3 = 1
		Endif
	Endif
'motor 4
	If turnout_req4 = 0 Then
		If servoposition4 > 0 Then          'servo left turn
			Gosub check_speed
			servoposition4 = 0
			counter = 200
			While counter > 99
				WaitMs servo_time
				ServoOut servo4, counter
				counter = counter - 1
			Wend
			Write 3, 0
			feed_back4 = 0
		Endif
	Else
		If servoposition4 = 0 Then          'servo right turn
			Gosub check_speed
			servoposition4 = 1
			counter = 100
			While counter < 201
				WaitMs servo_time
				ServoOut servo4, counter
				counter = counter + 1
			Wend
			Write 3, 1
			feed_back4 = 1
		Endif
	Endif

Goto main
End                                               
check_speed:

	If speed_select = 0 Then          'jumper is set
		servo_time = 50
	Else
		servo_time = 10
	Endif
	led = 0          'indicates that servo is moving

Return                                            