	list p=16f873a
	#include <p16f873a.inc>
	radix dec
; Compiled with: PIC Simulator IDE v6.83
; Microcontroller model: PIC16F873A
; Clock frequency: 1.0 MHz
;
;       The address of 'motornumber' (byte) (global) is 0x30
	motornumber EQU 0x30
;       The address of 'steps' (byte) (global) is 0x31
	steps EQU 0x31
;       The address of 'dummy' (byte) (global) is 0x32
	dummy EQU 0x32
;       The address of 'dummy1' (byte) (global) is 0x33
	dummy1 EQU 0x33
;       The address of 'position' (array 5) (byte) (global) is 0x34
	position EQU 0x34
;       The address of 'position_asked' (array 5) (byte) (global) is 0x39
	position_asked EQU 0x39
;       The address of 'angle_left' (array 5) (byte) (global) is 0x3E
	angle_left EQU 0x3E
;       The address of 'angle_right' (array 5) (byte) (global) is 0x43
	angle_right EQU 0x43
;       The address of 'angle' (array 5) (byte) (global) is 0x48
	angle EQU 0x48
;       The address of 'direction' (array 5) (byte) (global) is 0x4D
	direction EQU 0x4D
;       The address of 'speed' (array 5) (byte) (global) is 0x52
	speed EQU 0x52
;       The address of 'expander_out' (byte) (global) is 0x57
	expander_out EQU 0x57
;       The address of 'addr' (byte) (global) is 0x58
	addr EQU 0x58
;       The address of 'ledcount' (byte) (global) is 0x59
	ledcount EQU 0x59
;       The address of 'advalue' (word) (global) is 0x5A
	advalue EQU 0x5A
;       The address of 'led' (bit) (global) is 0x7,2
;       The address of 'sda' (bit) (global) is 0x7,0
;       The address of 'scl' (bit) (global) is 0x7,1
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0013
	ORG 0x0004
	RETFIE
L0013:
; 1: Define CONF_WORD = 0x3f73
; 2: 
; 3: 
; 4: 
; 5: 'program for control of 4 servomotors + 4 relais to switch turnout frogs.
; 6: 'new version also provides feed back of servomotor position after movement.
; 7: 'print MGV84
; 8: 'with jumper JP1 set, the program gets into adjust mode.
; 9: 'this enables adjust of:
; 10: '-  change polarity to turnout frog
; 11: '-  working angle of servo
; 12: '-  speed of servo.
; 13: Dim motornumber As Byte
	CLRF 0x30
; 14: Dim steps As Byte
	CLRF 0x31
; 15: Dim dummy As Byte
	CLRF 0x32
; 16: Dim dummy1 As Byte
	CLRF 0x33
; 17: Dim position(5) As Byte 'actual turnout position
	CLRF 0x34
	CLRF 0x35
	CLRF 0x36
	CLRF 0x37
	CLRF 0x38
; 18: Dim position_asked(5) As Byte
	CLRF 0x39
	CLRF 0x3A
	CLRF 0x3B
	CLRF 0x3C
	CLRF 0x3D
; 19: Dim angle_left(5) As Byte 'turning angle of servomotor
	CLRF 0x3E
	CLRF 0x3F
	CLRF 0x40
	CLRF 0x41
	CLRF 0x42
; 20: Dim angle_right(5) As Byte
	CLRF 0x43
	CLRF 0x44
	CLRF 0x45
	CLRF 0x46
	CLRF 0x47
; 21: Dim angle(5) As Byte
	CLRF 0x48
	CLRF 0x49
	CLRF 0x4A
	CLRF 0x4B
	CLRF 0x4C
; 22: Dim direction(5) As Byte 'this is position of the relay
	CLRF 0x4D
	CLRF 0x4E
	CLRF 0x4F
	CLRF 0x50
	CLRF 0x51
; 23: Dim speed(5) As Byte 'indicates speed of servomotor
	CLRF 0x52
	CLRF 0x53
	CLRF 0x54
	CLRF 0x55
	CLRF 0x56
; 24: Dim expander_out As Byte
	CLRF 0x57
; 25: Dim addr As Byte
	CLRF 0x58
; 26: Dim ledcount As Byte
	CLRF 0x59
; 27: Dim advalue As Word
	CLRF 0x5A
	CLRF 0x5B
; 28: Symbol led = PORTC.2
; 29: ADCON1 = 0
	BSF STATUS,RP0
	CLRF 0x1F
; 30: TRISA = %111111 'set 6 PORTA pins as inputs and +/-Vref
	MOVLW 0x3F
	MOVWF 0x05
; 31: TRISB = %00000000 'set portb as output
	CLRF 0x06
; 32: PORTB = %11111111
	BCF STATUS,RP0
	MOVLW 0xFF
	MOVWF 0x06
; 33: TRISC = %00001011 'set portc.0,1,3 as input , rest is output
	BSF STATUS,RP0
	MOVLW 0x0B
	MOVWF 0x07
; 34: PORTC = %00001111
	BCF STATUS,RP0
	MOVLW 0x0F
	MOVWF 0x07
; 35: Symbol sda = PORTC.0 'I2c Initialisation
; 36: Symbol scl = PORTC.1 'I2c Initialisation
; 37: I2CPrepare sda, scl 'I2c Initialisation
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x01
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,0
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x02
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,1
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
; 38: Gosub read_eeprom 'read all settings
	CALL L0007
; 39: 'adjust = 0
; 40: expander_out = 255
	MOVLW 0xFF
	MOVWF 0x57
; 41: For motornumber = 1 To 4
	MOVLW 0x01
	MOVWF 0x30
L0014:
	MOVF 0x30,W
	SUBLW 0x04
	BTFSS STATUS,C
	GOTO L0015
; 42: 	Gosub writeoutputs
	CALL L0012
; 43: 	Gosub setrelay
	CALL L0011
; 44: 	If position(motornumber) = 0 Then 'select position for each servo
	MOVF 0x30,W
	ADDLW 0x34
	MOVWF FSR
	MOVF INDF,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0016
; 45: 		angle(motornumber) = angle_left(motornumber)
	MOVF 0x30,W
	ADDLW 0x3E
	MOVWF FSR
	MOVF INDF,W
	MOVWF R5L
	MOVF 0x30,W
	ADDLW 0x48
	MOVWF FSR
	MOVF R5L,W
	MOVWF INDF
; 46: 	Else
	GOTO L0017
L0016:	MOVLW 0x1F
	ANDWF STATUS,F
; 47: 		angle(motornumber) = angle_right(motornumber)
	MOVF 0x30,W
	ADDLW 0x43
	MOVWF FSR
	MOVF INDF,W
	MOVWF R5L
	MOVF 0x30,W
	ADDLW 0x48
	MOVWF FSR
	MOVF R5L,W
	MOVWF INDF
; 48: 	Endif
L0017:	MOVLW 0x1F
	ANDWF STATUS,F
; 49: Next motornumber
	MOVLW 0x01
	ADDWF 0x30,F
	BTFSS STATUS,C
	GOTO L0014
L0015:	MOVLW 0x1F
	ANDWF STATUS,F
; 50: dummy = 0
	CLRF 0x32
; 51: For dummy1 = 1 To 10
	MOVLW 0x01
	MOVWF 0x33
L0018:
	MOVF 0x33,W
	SUBLW 0x0A
	BTFSS STATUS,C
	GOTO L0019
; 52: 	If PORTC.3 = 0 Then 'Adjustments jumper activated
	BTFSC 0x07,3
	GOTO L0020
; 53: 		dummy = dummy + 1
	MOVF 0x32,W
	ADDLW 0x01
	MOVWF 0x32
; 54: 		WaitMs 300
	MOVLW 0x2C
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	CALL W001
; 55: 	Endif
L0020:	MOVLW 0x1F
	ANDWF STATUS,F
; 56: Next dummy1
	MOVLW 0x01
	ADDWF 0x33,F
	BTFSS STATUS,C
	GOTO L0018
L0019:	MOVLW 0x1F
	ANDWF STATUS,F
; 57: If dummy = 10 Then 'no bouncing of jumper has been found.
	MOVF 0x32,W
	SUBLW 0x0A
	BTFSS STATUS,Z
	GOTO L0021
; 58: 	led = 0
	BCF 0x07,2
; 59: 	Gosub adjustments
	CALL L0006
; 60: Endif
L0021:	MOVLW 0x1F
	ANDWF STATUS,F
; 61: main:
L0001:
; 62: 	If ledcount = 10 Then
	MOVF 0x59,W
	SUBLW 0x0A
	BTFSS STATUS,Z
	GOTO L0022
; 63: 		led = 0
	BCF 0x07,2
; 64: 		ledcount = 0
	CLRF 0x59
; 65: 	Else
	GOTO L0023
L0022:	MOVLW 0x1F
	ANDWF STATUS,F
; 66: 		led = 1
	BSF 0x07,2
; 67: 	Endif
L0023:	MOVLW 0x1F
	ANDWF STATUS,F
; 68: 	ledcount = ledcount + 1
	MOVF 0x59,W
	ADDLW 0x01
	MOVWF 0x59
; 69: 	Gosub getinputs 'first read 4 inputs from I2C expander aderess 64
	CALL L0002
; 70: 	For motornumber = 1 To 4 'check if changes need to be made
	MOVLW 0x01
	MOVWF 0x30
L0024:
	MOVF 0x30,W
	SUBLW 0x04
	BTFSS STATUS,C
	GOTO L0025
; 71: 		If position_asked(motornumber) = 0 Then
	MOVF 0x30,W
	ADDLW 0x39
	MOVWF FSR
	MOVF INDF,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0026
; 72: 			If position(motornumber) = 1 Then 'motor must turn left
	MOVF 0x30,W
	ADDLW 0x34
	MOVWF FSR
	MOVF INDF,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0027
; 73: 				led = 0
	BCF 0x07,2
; 74: 				Gosub servo_control_left
	CALL L0008
; 75: 			Endif
L0027:	MOVLW 0x1F
	ANDWF STATUS,F
; 76: 		Else
	GOTO L0028
L0026:	MOVLW 0x1F
	ANDWF STATUS,F
; 77: 			If position(motornumber) = 0 Then 'motor must turn right
	MOVF 0x30,W
	ADDLW 0x34
	MOVWF FSR
	MOVF INDF,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0029
; 78: 				led = 0
	BCF 0x07,2
; 79: 				Gosub servo_control_right
	CALL L0009
; 80: 			Endif
L0029:	MOVLW 0x1F
	ANDWF STATUS,F
; 81: 		Endif
L0028:	MOVLW 0x1F
	ANDWF STATUS,F
; 82: 	Next motornumber
	MOVLW 0x01
	ADDWF 0x30,F
	BTFSS STATUS,C
	GOTO L0024
L0025:	MOVLW 0x1F
	ANDWF STATUS,F
; 83: 	WaitMs 100
	MOVLW 0x64
	MOVWF R0L
	CLRF R0H
	CALL W001
; 84: Goto main 'repeat process
	GOTO L0001
; 85: End
L0030:	GOTO L0030
; 86: getinputs:
L0002:
; 87: 	I2CStart 'Issue I2C start signal
	CALL IC31
; 88: 	I2CSend 65 'Send byte via I2C to U5
	MOVLW 0x41
	CALL IC01
; 89: 	I2CRecN dummy 'Read the data
	CALL IC11
	MOVWF 0x32
; 90: 	I2CStop 'Issue
	CALL IC41
; 91: 	If dummy.7 = 1 Then
	BTFSS 0x32,7
	GOTO L0031
; 92: 		position_asked(1) = 1
	MOVLW 0x01
	MOVWF 0x3A
; 93: 	Else
	GOTO L0032
L0031:	MOVLW 0x1F
	ANDWF STATUS,F
; 94: 		position_asked(1) = 0
	CLRF 0x3A
; 95: 	Endif
L0032:	MOVLW 0x1F
	ANDWF STATUS,F
; 96: 	If dummy.6 = 1 Then
	BTFSS 0x32,6
	GOTO L0033
; 97: 		position_asked(2) = 1
	MOVLW 0x01
	MOVWF 0x3B
; 98: 	Else
	GOTO L0034
L0033:	MOVLW 0x1F
	ANDWF STATUS,F
; 99: 		position_asked(2) = 0
	CLRF 0x3B
; 100: 	Endif
L0034:	MOVLW 0x1F
	ANDWF STATUS,F
; 101: 	If dummy.5 = 1 Then
	BTFSS 0x32,5
	GOTO L0035
; 102: 		position_asked(3) = 1
	MOVLW 0x01
	MOVWF 0x3C
; 103: 	Else
	GOTO L0036
L0035:	MOVLW 0x1F
	ANDWF STATUS,F
; 104: 		position_asked(3) = 0
	CLRF 0x3C
; 105: 	Endif
L0036:	MOVLW 0x1F
	ANDWF STATUS,F
; 106: 	If dummy.4 = 1 Then
	BTFSS 0x32,4
	GOTO L0037
; 107: 		position_asked(4) = 1
	MOVLW 0x01
	MOVWF 0x3D
; 108: 	Else
	GOTO L0038
L0037:	MOVLW 0x1F
	ANDWF STATUS,F
; 109: 		position_asked(4) = 0
	CLRF 0x3D
; 110: 	Endif
L0038:	MOVLW 0x1F
	ANDWF STATUS,F
; 111: Return
	RETURN
; 112: 
; 113: measure_relay_postion:
L0003:
; 114: 	If PORTC.3 = 0 Then
	BTFSC 0x07,3
	GOTO L0039
; 115: 		direction(motornumber) = 0
	MOVF 0x30,W
	ADDLW 0x4D
	MOVWF FSR
	MOVLW 0x00
	MOVWF INDF
; 116: 	Else
	GOTO L0040
L0039:	MOVLW 0x1F
	ANDWF STATUS,F
; 117: 		direction(motornumber) = 1
	MOVF 0x30,W
	ADDLW 0x4D
	MOVWF FSR
	MOVLW 0x01
	MOVWF INDF
; 118: 	Endif
L0040:	MOVLW 0x1F
	ANDWF STATUS,F
; 119: 	dummy = 12 + motornumber 'adress in EEprom
	MOVLW 0x0C
	ADDWF 0x30,W
	MOVWF 0x32
; 120: 	Write dummy, direction(motornumber)
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	ADDLW 0x4D
	MOVWF FSR
	MOVF INDF,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0041:	BTFSC EECON1,WR
	GOTO L0041
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 121: Return
	RETURN
; 122: 
; 123: measure_speed:
L0004:
; 124: 	Adcin 0, advalue
	BSF STATUS,RP0
	BSF ADCON1,ADFM
	BCF ADCON1,ADCS2
	MOVLW 0x00
	BCF STATUS,RP0
	MOVWF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x5A
	MOVF ADRESH,W
	MOVWF 0x5B
; 125: 	advalue = advalue / 4 'convert to byte
	MOVF 0x5A,W
	MOVWF R0L
	MOVF 0x5B,W
	MOVWF R0H
	MOVLW 0x04
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVWF 0x5A
	MOVF R0H,W
	MOVWF 0x5B
; 126: 	steps = advalue.LB
	MOVF 0x5A,W
	MOVWF 0x31
; 127: 	If steps = 0 Then 'zero not allowed
	MOVF 0x31,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0042
; 128: 		steps = 1
	MOVLW 0x01
	MOVWF 0x31
; 129: 	Endif
L0042:	MOVLW 0x1F
	ANDWF STATUS,F
; 130: 	speed(motornumber) = steps
	MOVF 0x31,W
	MOVWF R5L
	MOVF 0x30,W
	ADDLW 0x52
	MOVWF FSR
	MOVF R5L,W
	MOVWF INDF
; 131: 	dummy = 16 + motornumber 'adress in EEprom
	MOVLW 0x10
	ADDWF 0x30,W
	MOVWF 0x32
; 132: 	Write dummy, speed(motornumber)
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	ADDLW 0x52
	MOVWF FSR
	MOVF INDF,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0043:	BTFSC EECON1,WR
	GOTO L0043
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 133: Return
	RETURN
; 134: 
; 135: measure_angle:
L0005:
; 136: 	Adcin 1, advalue
	BSF STATUS,RP0
	BSF ADCON1,ADFM
	BCF ADCON1,ADCS2
	MOVLW 0x01
	BCF STATUS,RP0
	MOVWF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x5A
	MOVF ADRESH,W
	MOVWF 0x5B
; 137: 	advalue = advalue / 8
	MOVF 0x5A,W
	MOVWF R0L
	MOVF 0x5B,W
	MOVWF R0H
	MOVLW 0x08
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVWF 0x5A
	MOVF R0H,W
	MOVWF 0x5B
; 138: 	steps = advalue.LB
	MOVF 0x5A,W
	MOVWF 0x31
; 139: 	If steps > 95 Then 'maximumm close 170
	MOVF 0x31,W
	SUBLW 0x5F
	BTFSC STATUS,C
	GOTO L0044
; 140: 		steps = 95
	MOVLW 0x5F
	MOVWF 0x31
; 141: 	Endif
L0044:	MOVLW 0x1F
	ANDWF STATUS,F
; 142: 	If steps < 10 Then 'minimum close to 20
	MOVLW 0x0A
	SUBWF 0x31,W
	BTFSC STATUS,C
	GOTO L0045
; 143: 		steps = 10
	MOVLW 0x0A
	MOVWF 0x31
; 144: 	Endif
L0045:	MOVLW 0x1F
	ANDWF STATUS,F
; 145: 	angle_left(motornumber) = 150 - steps
	MOVF 0x31,W
	SUBLW 0x96
	MOVWF R5L
	MOVF 0x30,W
	ADDLW 0x3E
	MOVWF FSR
	MOVF R5L,W
	MOVWF INDF
; 146: 	angle_right(motornumber) = 150 + steps
	MOVLW 0x96
	ADDWF 0x31,W
	MOVWF R5L
	MOVF 0x30,W
	ADDLW 0x43
	MOVWF FSR
	MOVF R5L,W
	MOVWF INDF
; 147: 	dummy = motornumber + 4 'adress in EEprom
	MOVF 0x30,W
	ADDLW 0x04
	MOVWF 0x32
; 148: 	Write dummy, angle_left(motornumber)
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	ADDLW 0x3E
	MOVWF FSR
	MOVF INDF,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0046:	BTFSC EECON1,WR
	GOTO L0046
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 149: 	dummy = dummy + 4 'adress in EEprom
	MOVF 0x32,W
	ADDLW 0x04
	MOVWF 0x32
; 150: 	Write dummy, angle_right(motornumber)
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	ADDLW 0x43
	MOVWF FSR
	MOVF INDF,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0047:	BTFSC EECON1,WR
	GOTO L0047
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 151: Return
	RETURN
; 152: 
; 153: adjustments:
L0006:
; 154: 	Gosub getinputs
	CALL L0002
; 155: 	For motornumber = 1 To 4
	MOVLW 0x01
	MOVWF 0x30
L0048:
	MOVF 0x30,W
	SUBLW 0x04
	BTFSS STATUS,C
	GOTO L0049
; 156: 		Gosub setrelay
	CALL L0011
; 157: 		If position_asked(motornumber) = 0 Then
	MOVF 0x30,W
	ADDLW 0x39
	MOVWF FSR
	MOVF INDF,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0050
; 158: 			Gosub measure_relay_postion
	CALL L0003
; 159: 			Gosub measure_speed
	CALL L0004
; 160: 			Gosub measure_angle
	CALL L0005
; 161: 			Gosub servo_control_left
	CALL L0008
; 162: 			WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	CALL W001
; 163: 			Gosub measure_relay_postion
	CALL L0003
; 164: 			Gosub measure_speed
	CALL L0004
; 165: 			Gosub measure_angle
	CALL L0005
; 166: 			Gosub servo_control_right
	CALL L0009
; 167: 			WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	CALL W001
; 168: 		Endif
L0050:	MOVLW 0x1F
	ANDWF STATUS,F
; 169: 	Next motornumber
	MOVLW 0x01
	ADDWF 0x30,F
	BTFSS STATUS,C
	GOTO L0048
L0049:	MOVLW 0x1F
	ANDWF STATUS,F
; 170: Goto adjustments
	GOTO L0006
; 171: Return
	RETURN
; 172: 
; 173: read_eeprom:
L0007:
; 174: For dummy = 1 To 4
	MOVLW 0x01
	MOVWF 0x32
L0051:
	MOVF 0x32,W
	SUBLW 0x04
	BTFSS STATUS,C
	GOTO L0052
; 175: 	Read dummy, position(dummy)
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF R5L
	MOVF 0x32,W
	ADDLW 0x34
	MOVWF FSR
	MOVF R5L,W
	MOVWF INDF
; 176: 	If position(dummy) = 255 Then
	MOVF 0x32,W
	ADDLW 0x34
	MOVWF FSR
	MOVF INDF,W
	SUBLW 0xFF
	BTFSS STATUS,Z
	GOTO L0053
; 177: 		position(dummy) = 0
	MOVF 0x32,W
	ADDLW 0x34
	MOVWF FSR
	MOVLW 0x00
	MOVWF INDF
; 178: 	Endif
L0053:	MOVLW 0x1F
	ANDWF STATUS,F
; 179: Next dummy
	MOVLW 0x01
	ADDWF 0x32,F
	BTFSS STATUS,C
	GOTO L0051
L0052:	MOVLW 0x1F
	ANDWF STATUS,F
; 180: For dummy = 5 To 8
	MOVLW 0x05
	MOVWF 0x32
L0054:
	MOVF 0x32,W
	SUBLW 0x08
	BTFSS STATUS,C
	GOTO L0055
; 181: 	steps = dummy - 4
	MOVLW 0x04
	SUBWF 0x32,W
	MOVWF 0x31
; 182: 	Read dummy, angle_left(steps)
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF R5L
	MOVF 0x31,W
	ADDLW 0x3E
	MOVWF FSR
	MOVF R5L,W
	MOVWF INDF
; 183: 	If angle_left(steps) = 255 Then
	MOVF 0x31,W
	ADDLW 0x3E
	MOVWF FSR
	MOVF INDF,W
	SUBLW 0xFF
	BTFSS STATUS,Z
	GOTO L0056
; 184: 		angle_left(steps) = 60
	MOVF 0x31,W
	ADDLW 0x3E
	MOVWF FSR
	MOVLW 0x3C
	MOVWF INDF
; 185: 	Endif
L0056:	MOVLW 0x1F
	ANDWF STATUS,F
; 186: Next dummy
	MOVLW 0x01
	ADDWF 0x32,F
	BTFSS STATUS,C
	GOTO L0054
L0055:	MOVLW 0x1F
	ANDWF STATUS,F
; 187: For dummy = 9 To 12
	MOVLW 0x09
	MOVWF 0x32
L0057:
	MOVF 0x32,W
	SUBLW 0x0C
	BTFSS STATUS,C
	GOTO L0058
; 188: 	steps = dummy - 8
	MOVLW 0x08
	SUBWF 0x32,W
	MOVWF 0x31
; 189: 	Read dummy, angle_right(steps)
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF R5L
	MOVF 0x31,W
	ADDLW 0x43
	MOVWF FSR
	MOVF R5L,W
	MOVWF INDF
; 190: 	If angle_right(steps) = 255 Then
	MOVF 0x31,W
	ADDLW 0x43
	MOVWF FSR
	MOVF INDF,W
	SUBLW 0xFF
	BTFSS STATUS,Z
	GOTO L0059
; 191: 		angle_right(steps) = 200
	MOVF 0x31,W
	ADDLW 0x43
	MOVWF FSR
	MOVLW 0xC8
	MOVWF INDF
; 192: 	Endif
L0059:	MOVLW 0x1F
	ANDWF STATUS,F
; 193: Next dummy
	MOVLW 0x01
	ADDWF 0x32,F
	BTFSS STATUS,C
	GOTO L0057
L0058:	MOVLW 0x1F
	ANDWF STATUS,F
; 194: For dummy = 13 To 16
	MOVLW 0x0D
	MOVWF 0x32
L0060:
	MOVF 0x32,W
	SUBLW 0x10
	BTFSS STATUS,C
	GOTO L0061
; 195: 	steps = dummy - 12
	MOVLW 0x0C
	SUBWF 0x32,W
	MOVWF 0x31
; 196: 	Read dummy, direction(steps)
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF R5L
	MOVF 0x31,W
	ADDLW 0x4D
	MOVWF FSR
	MOVF R5L,W
	MOVWF INDF
; 197: 	If direction(steps) > 1 Then
	MOVF 0x31,W
	ADDLW 0x4D
	MOVWF FSR
	MOVF INDF,W
	SUBLW 0x01
	BTFSC STATUS,C
	GOTO L0062
; 198: 		direction(steps) = 1
	MOVF 0x31,W
	ADDLW 0x4D
	MOVWF FSR
	MOVLW 0x01
	MOVWF INDF
; 199: 	Endif
L0062:	MOVLW 0x1F
	ANDWF STATUS,F
; 200: Next dummy
	MOVLW 0x01
	ADDWF 0x32,F
	BTFSS STATUS,C
	GOTO L0060
L0061:	MOVLW 0x1F
	ANDWF STATUS,F
; 201: For dummy = 17 To 20
	MOVLW 0x11
	MOVWF 0x32
L0063:
	MOVF 0x32,W
	SUBLW 0x14
	BTFSS STATUS,C
	GOTO L0064
; 202: 	steps = dummy - 16
	MOVLW 0x10
	SUBWF 0x32,W
	MOVWF 0x31
; 203: 	Read dummy, speed(steps)
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF R5L
	MOVF 0x31,W
	ADDLW 0x52
	MOVWF FSR
	MOVF R5L,W
	MOVWF INDF
; 204: 	If speed(steps) = 255 Then
	MOVF 0x31,W
	ADDLW 0x52
	MOVWF FSR
	MOVF INDF,W
	SUBLW 0xFF
	BTFSS STATUS,Z
	GOTO L0065
; 205: 		speed(steps) = 120
	MOVF 0x31,W
	ADDLW 0x52
	MOVWF FSR
	MOVLW 0x78
	MOVWF INDF
; 206: 	Endif
L0065:	MOVLW 0x1F
	ANDWF STATUS,F
; 207: Next dummy
	MOVLW 0x01
	ADDWF 0x32,F
	BTFSS STATUS,C
	GOTO L0063
L0064:	MOVLW 0x1F
	ANDWF STATUS,F
; 208: Return
	RETURN
; 209: 
; 210: servo_control_left:
L0008:
; 211: 			steps = angle_right(motornumber)
	MOVF 0x30,W
	ADDLW 0x43
	MOVWF FSR
	MOVF INDF,W
	MOVWF 0x31
; 212: 			Gosub clear_relay
	CALL L0010
; 213: 			While steps > angle_left(motornumber)
L0066:
	MOVF 0x31,W
	MOVWF R5L
	MOVF 0x30,W
	ADDLW 0x3E
	MOVWF FSR
	MOVF R5L,W
	SUBWF INDF,W
	BTFSC STATUS,C
	GOTO L0067
; 214: 				steps = steps - 1
	MOVLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 215: 				Select Case motornumber
; 216: 				Case 1
	MOVF 0x30,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0068
; 217: 					ServoOut PORTC.7, steps
	MOVF 0x31,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0070
	BSF PORTC,7
L0069:
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0069
	BCF PORTC,7
L0070:
; 218: 				Case 2
	GOTO L0071
L0068:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x30,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0072
; 219: 					ServoOut PORTC.6, steps
	MOVF 0x31,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0074
	BSF PORTC,6
L0073:
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0073
	BCF PORTC,6
L0074:
; 220: 				Case 3
	GOTO L0075
L0072:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x30,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0076
; 221: 					ServoOut PORTC.5, steps
	MOVF 0x31,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0078
	BSF PORTC,5
L0077:
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0077
	BCF PORTC,5
L0078:
; 222: 				Case Else
	GOTO L0079
L0076:	MOVLW 0x1F
	ANDWF STATUS,F
; 223: 					ServoOut PORTC.4, steps
	MOVF 0x31,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0081
	BSF PORTC,4
L0080:
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0080
	BCF PORTC,4
L0081:
; 224: 				EndSelect
L0079:	MOVLW 0x1F
	ANDWF STATUS,F
L0075:	MOVLW 0x1F
	ANDWF STATUS,F
L0071:	MOVLW 0x1F
	ANDWF STATUS,F
; 225: 				WaitMs speed(motornumber)
	MOVF 0x30,W
	ADDLW 0x52
	MOVWF FSR
	MOVF INDF,W
	MOVWF R0L
	CLRF R0H
	CALL W001
; 226: 			Wend
	GOTO L0066
L0067:	MOVLW 0x1F
	ANDWF STATUS,F
; 227: 			position(motornumber) = 0
	MOVF 0x30,W
	ADDLW 0x34
	MOVWF FSR
	MOVLW 0x00
	MOVWF INDF
; 228: 			Gosub setrelay
	CALL L0011
; 229: 			Gosub writeoutputs
	CALL L0012
; 230: 			Write motornumber, 0 'Position saved
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x00
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0082:	BTFSC EECON1,WR
	GOTO L0082
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 231: Return
	RETURN
; 232: servo_control_right:
L0009:
; 233: 			steps = angle_left(motornumber)
	MOVF 0x30,W
	ADDLW 0x3E
	MOVWF FSR
	MOVF INDF,W
	MOVWF 0x31
; 234: 			Gosub clear_relay
	CALL L0010
; 235: 			While steps < angle_right(motornumber)
L0083:
	MOVF 0x30,W
	ADDLW 0x43
	MOVWF FSR
	MOVF INDF,W
	SUBWF 0x31,W
	BTFSC STATUS,C
	GOTO L0084
; 236: 				steps = steps + 1
	MOVF 0x31,W
	ADDLW 0x01
	MOVWF 0x31
; 237: 				Select Case motornumber
; 238: 				Case 1
	MOVF 0x30,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0085
; 239: 					ServoOut PORTC.7, steps
	MOVF 0x31,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0087
	BSF PORTC,7
L0086:
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0086
	BCF PORTC,7
L0087:
; 240: 				Case 2
	GOTO L0088
L0085:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x30,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0089
; 241: 					ServoOut PORTC.6, steps
	MOVF 0x31,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0091
	BSF PORTC,6
L0090:
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0090
	BCF PORTC,6
L0091:
; 242: 				Case 3
	GOTO L0092
L0089:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x30,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0093
; 243: 					ServoOut PORTC.5, steps
	MOVF 0x31,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0095
	BSF PORTC,5
L0094:
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0094
	BCF PORTC,5
L0095:
; 244: 				Case Else
	GOTO L0096
L0093:	MOVLW 0x1F
	ANDWF STATUS,F
; 245: 					ServoOut PORTC.4, steps
	MOVF 0x31,W
	MOVWF R4H
	MOVF R4H,F
	BTFSC STATUS,Z
	GOTO L0098
	BSF PORTC,4
L0097:
	DECF R4H,F
	BTFSS STATUS,Z
	GOTO L0097
	BCF PORTC,4
L0098:
; 246: 				EndSelect
L0096:	MOVLW 0x1F
	ANDWF STATUS,F
L0092:	MOVLW 0x1F
	ANDWF STATUS,F
L0088:	MOVLW 0x1F
	ANDWF STATUS,F
; 247: 				WaitMs speed(motornumber)
	MOVF 0x30,W
	ADDLW 0x52
	MOVWF FSR
	MOVF INDF,W
	MOVWF R0L
	CLRF R0H
	CALL W001
; 248: 			Wend
	GOTO L0083
L0084:	MOVLW 0x1F
	ANDWF STATUS,F
; 249: 			position(motornumber) = 1
	MOVF 0x30,W
	ADDLW 0x34
	MOVWF FSR
	MOVLW 0x01
	MOVWF INDF
; 250: 			Gosub setrelay
	CALL L0011
; 251: 			Gosub writeoutputs
	CALL L0012
; 252: 			Write motornumber, 1 'Position saved
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x01
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0099:	BTFSC EECON1,WR
	GOTO L0099
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 253: Return
	RETURN
; 254: clear_relay:
L0010:
; 255: 			Select Case motornumber
; 256: 			Case 1
	MOVF 0x30,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0100
; 257: 				PORTB.0 = 1
	BSF 0x06,0
; 258: 				PORTB.1 = 1
	BSF 0x06,1
; 259: 			Case 2
	GOTO L0101
L0100:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x30,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0102
; 260: 				PORTB.2 = 1
	BSF 0x06,2
; 261: 				PORTB.3 = 1
	BSF 0x06,3
; 262: 			Case 3
	GOTO L0103
L0102:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x30,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0104
; 263: 				PORTB.4 = 1
	BSF 0x06,4
; 264: 				PORTB.5 = 1
	BSF 0x06,5
; 265: 			Case Else
	GOTO L0105
L0104:	MOVLW 0x1F
	ANDWF STATUS,F
; 266: 				PORTB.6 = 1
	BSF 0x06,6
; 267: 				PORTB.7 = 1
	BSF 0x06,7
; 268: 			EndSelect
L0105:	MOVLW 0x1F
	ANDWF STATUS,F
L0103:	MOVLW 0x1F
	ANDWF STATUS,F
L0101:	MOVLW 0x1F
	ANDWF STATUS,F
; 269: 			
; 270: Return
	RETURN
; 271: 
; 272: setrelay:
L0011:
; 273: 			Select Case motornumber
; 274: 			Case 1
	MOVF 0x30,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0106
; 275: 				Select Case position(1)
; 276: 				Case 0
	MOVF 0x35,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0107
; 277: 					If direction(1) = 1 Then
	MOVF 0x4E,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0108
; 278: 						RB0 = 0
	BCF 0x06,0
; 279: 						RB1 = 1
	BSF 0x06,1
; 280: 					Else
	GOTO L0109
L0108:	MOVLW 0x1F
	ANDWF STATUS,F
; 281: 						RB1 = 0
	BCF 0x06,1
; 282: 						RB0 = 1
	BSF 0x06,0
; 283: 					Endif
L0109:	MOVLW 0x1F
	ANDWF STATUS,F
; 284: 				Case Else
	GOTO L0110
L0107:	MOVLW 0x1F
	ANDWF STATUS,F
; 285: 					If direction(1) = 1 Then
	MOVF 0x4E,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0111
; 286: 						RB1 = 0
	BCF 0x06,1
; 287: 						RB0 = 1
	BSF 0x06,0
; 288: 					Else
	GOTO L0112
L0111:	MOVLW 0x1F
	ANDWF STATUS,F
; 289: 						RB0 = 0
	BCF 0x06,0
; 290: 						RB1 = 1
	BSF 0x06,1
; 291: 					Endif
L0112:	MOVLW 0x1F
	ANDWF STATUS,F
; 292: 				EndSelect
L0110:	MOVLW 0x1F
	ANDWF STATUS,F
; 293: 			Case 2
	GOTO L0113
L0106:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x30,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0114
; 294: 				Select Case position(2)
; 295: 				Case 0
	MOVF 0x36,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0115
; 296: 					If direction(2) = 1 Then
	MOVF 0x4F,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0116
; 297: 						RB2 = 0
	BCF 0x06,2
; 298: 						RB3 = 1
	BSF 0x06,3
; 299: 					Else
	GOTO L0117
L0116:	MOVLW 0x1F
	ANDWF STATUS,F
; 300: 						RB3 = 0
	BCF 0x06,3
; 301: 						RB2 = 1
	BSF 0x06,2
; 302: 					Endif
L0117:	MOVLW 0x1F
	ANDWF STATUS,F
; 303: 				Case Else
	GOTO L0118
L0115:	MOVLW 0x1F
	ANDWF STATUS,F
; 304: 					If direction(2) = 1 Then
	MOVF 0x4F,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0119
; 305: 						RB3 = 0
	BCF 0x06,3
; 306: 						RB2 = 1
	BSF 0x06,2
; 307: 					Else
	GOTO L0120
L0119:	MOVLW 0x1F
	ANDWF STATUS,F
; 308: 						RB2 = 0
	BCF 0x06,2
; 309: 						RB3 = 1
	BSF 0x06,3
; 310: 					Endif
L0120:	MOVLW 0x1F
	ANDWF STATUS,F
; 311: 				EndSelect
L0118:	MOVLW 0x1F
	ANDWF STATUS,F
; 312: 			Case 3
	GOTO L0121
L0114:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x30,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0122
; 313: 				Select Case position(3)
; 314: 				Case 0
	MOVF 0x37,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0123
; 315: 					If direction(3) = 1 Then
	MOVF 0x50,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0124
; 316: 						RB4 = 0
	BCF 0x06,4
; 317: 						RB5 = 1
	BSF 0x06,5
; 318: 					Else
	GOTO L0125
L0124:	MOVLW 0x1F
	ANDWF STATUS,F
; 319: 						RB5 = 0
	BCF 0x06,5
; 320: 						RB4 = 1
	BSF 0x06,4
; 321: 					Endif
L0125:	MOVLW 0x1F
	ANDWF STATUS,F
; 322: 				Case Else
	GOTO L0126
L0123:	MOVLW 0x1F
	ANDWF STATUS,F
; 323: 					If direction(3) = 1 Then
	MOVF 0x50,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0127
; 324: 						RB5 = 0
	BCF 0x06,5
; 325: 						RB4 = 1
	BSF 0x06,4
; 326: 					Else
	GOTO L0128
L0127:	MOVLW 0x1F
	ANDWF STATUS,F
; 327: 						RB4 = 0
	BCF 0x06,4
; 328: 						RB5 = 1
	BSF 0x06,5
; 329: 					Endif
L0128:	MOVLW 0x1F
	ANDWF STATUS,F
; 330: 				EndSelect
L0126:	MOVLW 0x1F
	ANDWF STATUS,F
; 331: 			Case Else
	GOTO L0129
L0122:	MOVLW 0x1F
	ANDWF STATUS,F
; 332: 				Select Case position(4)
; 333: 				Case 0
	MOVF 0x38,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0130
; 334: 					If direction(4) = 1 Then
	MOVF 0x51,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0131
; 335: 						RB6 = 0
	BCF 0x06,6
; 336: 						RB7 = 1
	BSF 0x06,7
; 337: 					Else
	GOTO L0132
L0131:	MOVLW 0x1F
	ANDWF STATUS,F
; 338: 						RB7 = 0
	BCF 0x06,7
; 339: 						RB6 = 1
	BSF 0x06,6
; 340: 					Endif
L0132:	MOVLW 0x1F
	ANDWF STATUS,F
; 341: 				Case Else
	GOTO L0133
L0130:	MOVLW 0x1F
	ANDWF STATUS,F
; 342: 					If direction(4) = 1 Then
	MOVF 0x51,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0134
; 343: 						RB7 = 0
	BCF 0x06,7
; 344: 						RB6 = 1
	BSF 0x06,6
; 345: 					Else
	GOTO L0135
L0134:	MOVLW 0x1F
	ANDWF STATUS,F
; 346: 						RB6 = 0
	BCF 0x06,6
; 347: 						RB7 = 1
	BSF 0x06,7
; 348: 					Endif
L0135:	MOVLW 0x1F
	ANDWF STATUS,F
; 349: 				EndSelect
L0133:	MOVLW 0x1F
	ANDWF STATUS,F
; 350: 			EndSelect
L0129:	MOVLW 0x1F
	ANDWF STATUS,F
L0121:	MOVLW 0x1F
	ANDWF STATUS,F
L0113:	MOVLW 0x1F
	ANDWF STATUS,F
; 351: Return
	RETURN
; 352: 
; 353: 
; 354: writeoutputs:
L0012:
; 355: 	If position(motornumber) = 1 Then
	MOVF 0x30,W
	ADDLW 0x34
	MOVWF FSR
	MOVF INDF,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0136
; 356: 		Select Case motornumber
; 357: 		Case 1
	MOVF 0x30,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0137
; 358: 			expander_out.3 = 1 'set bit 3
	BSF 0x57,3
; 359: 		Case 2
	GOTO L0138
L0137:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x30,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0139
; 360: 			expander_out.2 = 1 'set bit 2
	BSF 0x57,2
; 361: 		Case 3
	GOTO L0140
L0139:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x30,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0141
; 362: 			expander_out.1 = 1 'set bit 1
	BSF 0x57,1
; 363: 		Case Else
	GOTO L0142
L0141:	MOVLW 0x1F
	ANDWF STATUS,F
; 364: 			expander_out.0 = 1 'set bit 0
	BSF 0x57,0
; 365: 		EndSelect
L0142:	MOVLW 0x1F
	ANDWF STATUS,F
L0140:	MOVLW 0x1F
	ANDWF STATUS,F
L0138:	MOVLW 0x1F
	ANDWF STATUS,F
; 366: 	Else
	GOTO L0143
L0136:	MOVLW 0x1F
	ANDWF STATUS,F
; 367: 		Select Case motornumber
; 368: 		Case 1
	MOVF 0x30,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0144
; 369: 			expander_out.3 = 0 'reset bit 3
	BCF 0x57,3
; 370: 		Case 2
	GOTO L0145
L0144:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x30,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0146
; 371: 			expander_out.2 = 0 'reset bit 2
	BCF 0x57,2
; 372: 		Case 3
	GOTO L0147
L0146:	MOVLW 0x1F
	ANDWF STATUS,F
	MOVF 0x30,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0148
; 373: 			expander_out.1 = 0 'reset bit  1
	BCF 0x57,1
; 374: 		Case Else
	GOTO L0149
L0148:	MOVLW 0x1F
	ANDWF STATUS,F
; 375: 			expander_out.0 = 0 'reset bit  1
	BCF 0x57,0
; 376: 		EndSelect
L0149:	MOVLW 0x1F
	ANDWF STATUS,F
L0147:	MOVLW 0x1F
	ANDWF STATUS,F
L0145:	MOVLW 0x1F
	ANDWF STATUS,F
; 377: 	Endif
L0143:	MOVLW 0x1F
	ANDWF STATUS,F
; 378: 	addr = 64
	MOVLW 0x40
	MOVWF 0x58
; 379: 	I2CWrite1 sda, scl, addr, expander_out
	MOVLW 0x07
	MOVWF SDA_PORT
	MOVLW 0x01
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISC,0
	BCF STATUS,RP0
	MOVLW 0x07
	MOVWF SCL_PORT
	MOVLW 0x02
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISC,1
	BCF STATUS,RP0
	CALL IC41
	CALL IC41
	CALL IC31
	MOVF 0x58,W
	ANDLW 0xFE
	CALL IC01
	MOVF 0x57,W
	CALL IC01
	CALL IC41
; 380: Return
	RETURN
; End of program
L0150:	GOTO L0150
; Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	MOVF R0L,W
	RETURN
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x03
	MOVWF R1L
W005:	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine - Byte Argument
X001:	MOVLW 0x25
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
X002:	MOVLW 0x18
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
; Adcin Routine
A001:	RLF R0L,F
	RLF R0L,F
	RLF R0L,F
	MOVLW 0x38
	ANDWF R0L,F
	MOVLW 0xC1
	IORWF R0L,W
	MOVWF ADCON0
	MOVLW 0x14
	MOVWF R4L
	CALL X001
	BSF ADCON0,GO
A002:	BTFSC ADCON0,GO
	GOTO A002
	BCF PIR1,ADIF
	BCF ADCON0,ADON
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:	CALL IC21
	CALL IC23
	GOTO IC29
IC41:	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; I2CRead Routine
IC11:	CALL IC24
	MOVLW 0x08
	MOVWF R0H
IC12:	CALL IC03
	RLF R0L,F
	DECFSZ R0H,F
	GOTO IC12
	CALL IC25
	CALL IC20
	CALL IC22
	CALL IC23
	CALL IC21
	MOVF R0L,W
	RETURN
IC13:	CALL IC24
	MOVLW 0x08
	MOVWF R0H
IC14:	CALL IC03
	RLF R0L,F
	DECFSZ R0H,F
	GOTO IC14
	CALL IC25
	CALL IC21
	CALL IC22
	CALL IC23
	MOVF R0L,W
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x3F73
; End of listing
	END
