Define CONF_WORD = 0x3f73



'program for control of 4 servomotors + 4 relais to switch turnout frogs.
'new version also provides feed back of servomotor position after movement.
'print MGV84
'with jumper JP1 set, the program gets into adjust mode.
'this enables adjust of:
'-  change polarity to turnout frog
'-  working angle of servo
'-  speed of servo.
Dim motornumber As Byte
Dim steps As Byte
Dim dummy As Byte
Dim dummy1 As Byte
Dim position(5) As Byte          'actual turnout position
Dim position_asked(5) As Byte
Dim angle_left(5) As Byte          'turning angle of servomotor
Dim angle_right(5) As Byte
Dim angle(5) As Byte
Dim direction(5) As Byte          'this is position of the relay
Dim speed(5) As Byte          'indicates speed of servomotor
Dim expander_out As Byte
Dim addr As Byte
Dim ledcount As Byte
Dim advalue As Word
Symbol led = PORTC.2
ADCON1 = 0
TRISA = %111111          'set 6 PORTA pins as inputs and +/-Vref
TRISB = %00000000          'set portb as output
PORTB = %11111111
TRISC = %00001011          'set portc.0,1,3 as input , rest is output
PORTC = %00001111
Symbol sda = PORTC.0          'I2c Initialisation
Symbol scl = PORTC.1          'I2c Initialisation
I2CPrepare sda, scl          'I2c Initialisation
Gosub read_eeprom          'read all settings
'adjust = 0
expander_out = 255
For motornumber = 1 To 4
	Gosub writeoutputs
	Gosub setrelay
	If position(motornumber) = 0 Then          'select position for each servo
		angle(motornumber) = angle_left(motornumber)
	Else
		angle(motornumber) = angle_right(motornumber)
	Endif
Next motornumber
dummy = 0
For dummy1 = 1 To 10
	If PORTC.3 = 0 Then          'Adjustments jumper activated
		dummy = dummy + 1
		WaitMs 300
	Endif
Next dummy1
If dummy = 10 Then          'no bouncing of jumper has been found.
	led = 0
	Gosub adjustments
Endif
main:
	If ledcount = 10 Then
		led = 0
		ledcount = 0
	Else
		led = 1
	Endif
	ledcount = ledcount + 1
	Gosub getinputs          'first read 4 inputs from I2C expander aderess 64
	For motornumber = 1 To 4          'check if changes need to be made
		If position_asked(motornumber) = 0 Then
			If position(motornumber) = 1 Then          'motor must turn left
				led = 0
				Gosub servo_control_left
			Endif
		Else
			If position(motornumber) = 0 Then          'motor must turn right
				led = 0
				Gosub servo_control_right
			Endif
		Endif
	Next motornumber
	WaitMs 100
Goto main          'repeat process
End                                               
getinputs:
	I2CStart          'Issue I2C start signal
	I2CSend 65          'Send byte via I2C to U5
	I2CRecN dummy          'Read the data
	I2CStop          'Issue
	If dummy.7 = 1 Then
		position_asked(1) = 1
	Else
		position_asked(1) = 0
	Endif
	If dummy.6 = 1 Then
		position_asked(2) = 1
	Else
		position_asked(2) = 0
	Endif
	If dummy.5 = 1 Then
		position_asked(3) = 1
	Else
		position_asked(3) = 0
	Endif
	If dummy.4 = 1 Then
		position_asked(4) = 1
	Else
		position_asked(4) = 0
	Endif
Return                                            

measure_relay_postion:
	If PORTC.3 = 0 Then
		direction(motornumber) = 0
	Else
		direction(motornumber) = 1
	Endif
	dummy = 12 + motornumber          'adress in EEprom
	Write dummy, direction(motornumber)
Return                                            

measure_speed:
	Adcin 0, advalue
	advalue = advalue / 4          'convert to byte
	steps = advalue.LB
	If steps = 0 Then          'zero not allowed
		steps = 1
	Endif
	speed(motornumber) = steps
	dummy = 16 + motornumber          'adress in EEprom
	Write dummy, speed(motornumber)
Return                                            

measure_angle:
	Adcin 1, advalue
	advalue = advalue / 8
	steps = advalue.LB
	If steps > 95 Then          'maximumm close 170
		steps = 95
	Endif
	If steps < 10 Then          'minimum close to 20
		steps = 10
	Endif
	angle_left(motornumber) = 150 - steps
	angle_right(motornumber) = 150 + steps
	dummy = motornumber + 4          'adress in EEprom
	Write dummy, angle_left(motornumber)
	dummy = dummy + 4          'adress in EEprom
	Write dummy, angle_right(motornumber)
Return                                            

adjustments:
	Gosub getinputs
	For motornumber = 1 To 4
		Gosub setrelay
		If position_asked(motornumber) = 0 Then
			Gosub measure_relay_postion
			Gosub measure_speed
			Gosub measure_angle
			Gosub servo_control_left
			WaitMs 500
			Gosub measure_relay_postion
			Gosub measure_speed
			Gosub measure_angle
			Gosub servo_control_right
			WaitMs 500
		Endif
	Next motornumber
Goto adjustments
Return                                            

read_eeprom:
For dummy = 1 To 4
	Read dummy, position(dummy)
	If position(dummy) = 255 Then
		position(dummy) = 0
	Endif
Next dummy
For dummy = 5 To 8
	steps = dummy - 4
	Read dummy, angle_left(steps)
	If angle_left(steps) = 255 Then
		angle_left(steps) = 60
	Endif
Next dummy
For dummy = 9 To 12
	steps = dummy - 8
	Read dummy, angle_right(steps)
	If angle_right(steps) = 255 Then
		angle_right(steps) = 200
	Endif
Next dummy
For dummy = 13 To 16
	steps = dummy - 12
	Read dummy, direction(steps)
	If direction(steps) > 1 Then
		direction(steps) = 1
	Endif
Next dummy
For dummy = 17 To 20
	steps = dummy - 16
	Read dummy, speed(steps)
	If speed(steps) = 255 Then
		speed(steps) = 120
	Endif
Next dummy
Return                                            

servo_control_left:
			steps = angle_right(motornumber)
			Gosub clear_relay
			While steps > angle_left(motornumber)
				steps = steps - 1
				Select Case motornumber
				Case 1
					ServoOut PORTC.7, steps
				Case 2
					ServoOut PORTC.6, steps
				Case 3
					ServoOut PORTC.5, steps
				Case Else
					ServoOut PORTC.4, steps
				EndSelect
				WaitMs speed(motornumber)
			Wend
			position(motornumber) = 0
			Gosub setrelay
			Gosub writeoutputs
			Write motornumber, 0          'Position saved
Return                                            
servo_control_right:
			steps = angle_left(motornumber)
			Gosub clear_relay
			While steps < angle_right(motornumber)
				steps = steps + 1
				Select Case motornumber
				Case 1
					ServoOut PORTC.7, steps
				Case 2
					ServoOut PORTC.6, steps
				Case 3
					ServoOut PORTC.5, steps
				Case Else
					ServoOut PORTC.4, steps
				EndSelect
				WaitMs speed(motornumber)
			Wend
			position(motornumber) = 1
			Gosub setrelay
			Gosub writeoutputs
			Write motornumber, 1          'Position saved
Return                                            
clear_relay:
			Select Case motornumber
			Case 1
				PORTB.0 = 1
				PORTB.1 = 1
			Case 2
				PORTB.2 = 1
				PORTB.3 = 1
			Case 3
				PORTB.4 = 1
				PORTB.5 = 1
			Case Else
				PORTB.6 = 1
				PORTB.7 = 1
			EndSelect
			
Return                                            

setrelay:
			Select Case motornumber
			Case 1
				Select Case position(1)
				Case 0
					If direction(1) = 1 Then
						RB0 = 0
						RB1 = 1
					Else
						RB1 = 0
						RB0 = 1
					Endif
				Case Else
					If direction(1) = 1 Then
						RB1 = 0
						RB0 = 1
					Else
						RB0 = 0
						RB1 = 1
					Endif
				EndSelect
			Case 2
				Select Case position(2)
				Case 0
					If direction(2) = 1 Then
						RB2 = 0
						RB3 = 1
					Else
						RB3 = 0
						RB2 = 1
					Endif
				Case Else
					If direction(2) = 1 Then
						RB3 = 0
						RB2 = 1
					Else
						RB2 = 0
						RB3 = 1
					Endif
				EndSelect
			Case 3
				Select Case position(3)
				Case 0
					If direction(3) = 1 Then
						RB4 = 0
						RB5 = 1
					Else
						RB5 = 0
						RB4 = 1
					Endif
				Case Else
					If direction(3) = 1 Then
						RB5 = 0
						RB4 = 1
					Else
						RB4 = 0
						RB5 = 1
					Endif
				EndSelect
			Case Else
				Select Case position(4)
				Case 0
					If direction(4) = 1 Then
						RB6 = 0
						RB7 = 1
					Else
						RB7 = 0
						RB6 = 1
					Endif
				Case Else
					If direction(4) = 1 Then
						RB7 = 0
						RB6 = 1
					Else
						RB6 = 0
						RB7 = 1
					Endif
				EndSelect
			EndSelect
Return                                            


writeoutputs:
	If position(motornumber) = 1 Then
		Select Case motornumber
		Case 1
			expander_out.3 = 1          'set bit 3
		Case 2
			expander_out.2 = 1          'set bit 2
		Case 3
			expander_out.1 = 1          'set bit 1
		Case Else
			expander_out.0 = 1          'set bit 0
		EndSelect
	Else
		Select Case motornumber
		Case 1
			expander_out.3 = 0          'reset bit 3
		Case 2
			expander_out.2 = 0          'reset bit 2
		Case 3
			expander_out.1 = 0          'reset bit  1
		Case Else
			expander_out.0 = 0          'reset bit  1
		EndSelect
	Endif
	addr = 64
	I2CWrite1 sda, scl, addr, expander_out
Return                                            