; Compiled with: PIC Simulator IDE v6.90
; Microcontroller model: PIC12F675
; Clock frequency: 4.0 MHz
;
;       The address of 'ok_state' (byte) (global) is 0x2C
	ok_state EQU 0x2C
;       The address of 'short_count1' (byte) (global) is 0x2D
	short_count1 EQU 0x2D
;       The address of 'short_count2' (byte) (global) is 0x2E
	short_count2 EQU 0x2E
;       The address of 'pulse_count1' (byte) (global) is 0x2F
	pulse_count1 EQU 0x2F
;       The address of 'pulse_count2' (byte) (global) is 0x30
	pulse_count2 EQU 0x30
;       The address of 'previous_pulse1' (bit) (global) is 0x31,0
;       The address of 'previous_pulse2' (bit) (global) is 0x31,1
;       The address of 'max_current' (word) (global) is 0x32
	max_current EQU 0x32
;       The address of 'short_time' (byte) (global) is 0x34
	short_time EQU 0x34
;       The address of 'v_r5' (word) (global) is 0x35
	v_r5 EQU 0x35
;       The address of 'pulse1' (bit) (global) is 0x5,3
;       The address of 'pulse2' (bit) (global) is 0x5,2
;       The address of 'l6203_enable' (bit) (global) is 0x5,4
;       The address of 'booster_on' (bit) (global) is 0x5,5
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0004
	ORG 0x0004
	RETFIE
; Begin of program
L0004:
; 1: 'program for ORD-3 Spax booster / DDX Booster
; 2: 
; 3: Define CONF_WORD = 0x31c4
; 4: 
; 5: AllDigital
	BSF STATUS,RP0
	CLRF 0x1F
	MOVLW 0x07
	BCF STATUS,RP0
	MOVWF 0x19
; 6: ANSEL.ANS0 = 1
	BSF STATUS,RP0
	BSF 0x1F,0
; 7: ANSEL.ANS1 = 0
	BCF 0x1F,1
; 8: ANSEL.ANS2 = 0
	BCF 0x1F,2
; 9: ANSEL.ANS3 = 0
	BCF 0x1F,3
	BCF STATUS,RP0
; 10: 
; 11: ADCON0.ADON = 1
	BSF 0x1F,0
; 12: ADCON0.VCFG = 0
	BCF 0x1F,6
; 13: 
; 14: TRISIO = %001111
	MOVLW 0x0F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 15: WPU = %000010  'internal pull-up's
	MOVLW 0x02
	BSF STATUS,RP0
	MOVWF 0x15
	BCF STATUS,RP0
; 16: Dim short_count1 As Byte
; 17: Dim short_count2 As Byte
; 18: Dim short_time As Byte
; 19: Dim pulse_count1 As Byte
; 20: Dim pulse_count2 As Byte
; 21: Dim v_r5 As Word
; 22: Dim previous_pulse1 As Bit
; 23: Dim previous_pulse2 As Bit
; 24: Dim max_current As Word
; 25: Dim ok_state As Byte
; 26: Symbol pulse1 = GP3
; 27: Symbol pulse2 = GP2
; 28: Symbol l6203_enable = GP4
; 29: Symbol booster_on = GP5
; 30: l6203_enable = 0  'system off
	BCF 0x05,4
; 31: short_count1 = 0
	CLRF 0x2D
; 32: short_count2 = 0
	CLRF 0x2E
; 33: short_time = 0
	CLRF 0x34
; 34: pulse_count1 = 0
	CLRF 0x2F
; 35: pulse_count2 = 0
	CLRF 0x30
; 36: booster_on = 1
	BSF 0x05,5
; 37: ok_state = 0
	CLRF 0x2C
; 38: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 39: Gosub check_jumper
	CALL L0003
; 40: main:
L0001:
; 41: 		WaitUs 1750  'Total loop time of program = ~~ 250us.
	MOVLW 0xD6
	MOVWF R4L
	MOVLW 0x06
	MOVWF R4H
	CALL Y001
; 42: 					'.         so this will make  2 mS  for each loop
; 43: 		Gosub check_l6203
	CALL L0002
; 44: 		If ok_state.2 = 1 Then
	BTFSS 0x2C,2
	GOTO L0005
; 45: 			If short_count2 > 0 Then
	MOVF 0x2E,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0006
; 46: 				If short_count1 > 0 Then
	MOVF 0x2D,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0007
; 47: 					short_count1 = short_count1 - 1
	MOVLW 0x01
	SUBWF 0x2D,W
	MOVWF 0x2D
; 48: 				Else
	GOTO L0008
L0007:
; 49: 					short_count2 = short_count2 - 1
	MOVLW 0x01
	SUBWF 0x2E,W
	MOVWF 0x2E
; 50: 					short_count1 = 250
	MOVLW 0xFA
	MOVWF 0x2D
; 51: 				Endif
L0008:
; 52: 			Else
	GOTO L0009
L0006:
; 53: 				ok_state.2 = 0
	BCF 0x2C,2
; 54: 			Endif
L0009:
; 55: 		Endif
L0005:
; 56: 
; 57: 		If pulse1 <> previous_pulse1 Then  'check railsync
	CLRW
	BTFSC 0x05,3
	ADDLW 0x01
	BTFSC 0x31,0
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0010
; 58: 			previous_pulse1 = pulse1  'remember this bit
	BTFSC 0x05,3
	BSF 0x31,0
	BTFSS 0x05,3
	BCF 0x31,0
; 59: 			ok_state.0 = 0
	BCF 0x2C,0
; 60: 			pulse_count1 = 0
	CLRF 0x2F
; 61: 		Else
	GOTO L0011
L0010:
; 62: 			If pulse_count1 < 30 Then  'within 30 mSec power off
	MOVLW 0x1E
	SUBWF 0x2F,W
	BTFSC STATUS,C
	GOTO L0012
; 63: 				pulse_count1 = pulse_count1 + 1
	MOVF 0x2F,W
	ADDLW 0x01
	MOVWF 0x2F
; 64: 			Else
	GOTO L0013
L0012:
; 65: 				ok_state.0 = 1
	BSF 0x2C,0
; 66: 			Endif
L0013:
; 67: 		Endif
L0011:
; 68: 		If pulse2 <> previous_pulse2 Then  'check railsync
	CLRW
	BTFSC 0x05,2
	ADDLW 0x01
	BTFSC 0x31,1
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0014
; 69: 			previous_pulse2 = pulse2  'remember this bit
	BTFSC 0x05,2
	BSF 0x31,1
	BTFSS 0x05,2
	BCF 0x31,1
; 70: 			ok_state.1 = 0
	BCF 0x2C,1
; 71: 			pulse_count2 = 0
	CLRF 0x30
; 72: 		Else
	GOTO L0015
L0014:
; 73: 			If pulse_count2 < 30 Then  'within 30 mSec power off
	MOVLW 0x1E
	SUBWF 0x30,W
	BTFSC STATUS,C
	GOTO L0016
; 74: 				pulse_count2 = pulse_count2 + 1
	MOVF 0x30,W
	ADDLW 0x01
	MOVWF 0x30
; 75: 			Else
	GOTO L0017
L0016:
; 76: 				ok_state.1 = 1
	BSF 0x2C,1
; 77: 			Endif
L0017:
; 78: 		Endif
L0015:
; 79: 		Select Case ok_state
; 80: 		Case 0  'no problem found
	MOVF 0x2C,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0018
; 81: 			l6203_enable = 1  'power on booster
	BSF 0x05,4
; 82: 			booster_on = 0
	BCF 0x05,5
; 83: 		Case Else  'there is a problem
	GOTO L0019
L0018:
; 84: 			Gosub check_jumper
	CALL L0003
; 85: 			l6203_enable = 0  'power off booster
	BCF 0x05,4
; 86: 			booster_on = 1
	BSF 0x05,5
; 87: 		EndSelect
L0019:
; 88: Goto main
	GOTO L0001
; 89: End
L0020:	GOTO L0020
; 90: 
; 91: check_l6203:
L0002:
; 92: 	Adcin 0, v_r5  'measure currect
	BSF ADCON0,ADFM
	BSF STATUS,RP0
	MOVLW 0x30
	IORWF ANSEL,F
	BCF STATUS,RP0
	CLRF R0L
	CALL A001
	BSF STATUS,RP0
	MOVF ADRESL,W
	BCF STATUS,RP0
	MOVWF 0x35
	MOVF ADRESH,W
	MOVWF 0x36
; 93: 	If v_r5 > max_current Then
	MOVF 0x35,W
	MOVWF R0L
	MOVF 0x36,W
	MOVWF R0H
	MOVF 0x32,W
	MOVWF R1L
	MOVF 0x33,W
	MOVWF R1H
	CALL C003
	BTFSS STATUS,Z
	GOTO L0021
; 94: 		If short_count1 < 250 Then  '250 times too high = after 0,5 second
	MOVLW 0xFA
	SUBWF 0x2D,W
	BTFSC STATUS,C
	GOTO L0022
; 95: 			short_count1 = short_count1 + 1
	MOVF 0x2D,W
	ADDLW 0x01
	MOVWF 0x2D
; 96: 		Else
	GOTO L0023
L0022:
; 97: 			short_count2 = 10  'delay 10 x 0,5 before switch on again
	MOVLW 0x0A
	MOVWF 0x2E
; 98: 			ok_state.2 = 1  'indicate power should be off
	BSF 0x2C,2
; 99: 		Endif
L0023:
; 100: 	Endif
L0021:
; 101: Return
	RETURN
; 102: 
; 103: check_jumper:
L0003:
; 104: 	If GP1 = 1 Then
	BTFSS 0x05,1
	GOTO L0024
; 105: 		max_current = 240  '(V_r5 * 1023)/Vref  = 0,33Ohm x 3 Amp x 1023 / 5
	MOVLW 0xF0
	MOVWF 0x32
	CLRF 0x33
; 106: 	Else
	GOTO L0025
L0024:
; 107: 		max_current = 80  '(V_r5 * 1023)/Vref  = 0,33Ohm x 1 Amp x 1023 / 5
	MOVLW 0x50
	MOVWF 0x32
	CLRF 0x33
; 108: 	Endif
L0025:
; 109: Return
	RETURN
; 110: 
; 111: 
; End of program
L0026:	GOTO L0026
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x12
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Byte
X001:	MOVLW 0x0A
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
X002:	MOVLW 0x06
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
; Waitus Routine Word
Y001:	MOVLW 0x10
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x0A
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; Adcin Routine
A001:	RLF R0L,F
	RLF R0L,F
	MOVLW 0x3C
	ANDWF R0L,F
	MOVLW 0xC0
	ANDWF ADCON0,F
	MOVF R0L,W
	IORWF ADCON0,F
	BSF ADCON0,ADON
	MOVLW 0x14
	MOVWF R4L
	CALL X001
	BSF ADCON0,GO
A002:
	BTFSC ADCON0,GO
	GOTO A002
	BCF PIR1,ADIF
	BCF ADCON0,ADON
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x31C4
; End of listing
	END
