
#!/usr/bin/env python
# -*- coding: utf-8 -*-
#written by Helge Karkoska 
# Sends sensor feedbacks via wlan to rocail server

import RPi.GPIO as GPIO
import os
import sys
import socket
from time import sleep


#user specific data: ip address rocrail server and rocrail sensor ids
rr_server_ip = '192.168.128.201'

# feedback 1
#sensor_1_rr_id = 'B1-Cha1/1'
#sensor_2_rr_id = 'B1-Cha1/2'
#sensor_3_rr_id = 'B2-Cha2/1'
#sensor_4_rr_id = 'B2-Cha2/2'
#sensor_5_rr_id = 'B5-Loop2'
#sensor_6_rr_id = 'B4-Cha4/1'
#sensor_7_rr_id = 'B3-Cha3/2'
#sensor_8_rr_id = 'B3-Cha3/1'

# feedback 2
sensor_1_rr_id = 'B6-Cum2/1'
sensor_2_rr_id = 'B7-Cum1/2'
sensor_3_rr_id = 'B7-Cum1/1'
sensor_4_rr_id = 'B6-Cum2/2'
sensor_5_rr_id = 'B11-Loop1'
sensor_6_rr_id = 'B12-Highline1'
sensor_7_rr_id = ''
sensor_8_rr_id = ''


def restart_program():
        python = sys.executable
        os.execl(python, python, * sys.argv)
        print ' Restart program '


# add the XML-Header and send it to the server
def sendMsg(s,xmlMsg):
        msg = "<xmlh><xml size=\"%d\"/></xmlh>%s" % (len(xmlMsg), xmlMsg)
        print msg
        try :
                s.sendall(msg)
        except socket.error, msg:
                print 'Send failed. Restart program'
                restart_program()

# Main program

try :
        s = socket.socket(socket.AF_INET,socket.SOCK_STREAM)    #create a tcp/ip $
except  socket.error, msg:
        print 'Failed to create socket. Restart program '
        restart_program()

try :
        s.connect((rr_server_ip,8051))                          #connect to rocral$
except  socket.error, msg:
        print 'Failed to connect. Restart program '
        restart_program()

GPIO.setmode(GPIO.BOARD)
GPIO.setup(7,GPIO.IN,pull_up_down=GPIO.PUD_UP)
GPIO.setup(11,GPIO.IN,pull_up_down=GPIO.PUD_UP)
GPIO.setup(12,GPIO.IN,pull_up_down=GPIO.PUD_UP)
GPIO.setup(13,GPIO.IN,pull_up_down=GPIO.PUD_UP)
GPIO.setup(15,GPIO.IN,pull_up_down=GPIO.PUD_UP)
GPIO.setup(16,GPIO.IN,pull_up_down=GPIO.PUD_UP)
GPIO.setup(18,GPIO.IN,pull_up_down=GPIO.PUD_UP)
GPIO.setup(22,GPIO.IN,pull_up_down=GPIO.PUD_UP)

sensor_1_old = True
sensor_2_old = True
sensor_3_old = True
sensor_4_old = True
sensor_5_old = True
sensor_6_old = True
sensor_7_old = True
sensor_8_old = True

sensor1 = 0
sensor2 = 0
sensor3 = 0
sensor4 = 0
sensor5 = 0
sensor6 = 0
sensor7 = 0
sensor8 = 0

filter = 15
limit = 0.8

while True:
        for i in range(filter):
            sensor_1 = GPIO.input(7)                                                    #sensor 1
            sensor_2 = GPIO.input(11)                                                   #sensor 2
            sensor_3 = GPIO.input(12)                                                   #sensor 4
            sensor_4 = GPIO.input(13)                                                   #sensor 4
            sensor_5 = GPIO.input(15)                                                   #sensor 4
            sensor_6 = GPIO.input(16)                                                   #sensor 5
            sensor_7 = GPIO.input(18)                                                   #sensor 7
            sensor_8 = GPIO.input(22)                                                    #sensor 8
            if sensor_1 == False :
                     sensor1 = sensor1 + 1
            if sensor_2 == False :
                     sensor2 = sensor2 + 1
            if sensor_3 == False :
                     sensor3 = sensor3 + 1
            if sensor_4 == False :
                     sensor4 = sensor4 + 1
            if sensor_5 == False :
                     sensor5 = sensor5 + 1
            if sensor_6 == False :
                     sensor6 = sensor6 + 1
            if sensor_7 == False :
                     sensor7 = sensor7 + 1
            if sensor_8 == False :
                     sensor8 = sensor8 + 1

        msensor1 = sensor1 / filter
        if msensor1 > limit :
                  sensor_1 = False
                  if sensor_1_old != sensor_1 :
                        xmlcmd = '<fb id="' + sensor_1_rr_id + '" state="true"/>'
                        sendMsg(s,xmlcmd)
                        print" sensor_1 activated"
        else :
                  sensor_1 = True
                  if sensor_1_old != sensor_1 :
                        xmlcmd = '<fb id="' + sensor_1_rr_id + '" state="false"/>'
                        sendMsg(s,xmlcmd)
                        print" sensor_1 deactivated"
        sensor_1_old = sensor_1
        sensor1 = 0

        msensor2 = sensor2 / filter
        if msensor2 > limit :
                  sensor_2 = False
                  if sensor_2_old != sensor_2 :
                        xmlcmd = '<fb id="' + sensor_2_rr_id + '" state="true"/>'
                        sendMsg(s,xmlcmd)
                        print" sensor_2 activated"
        else :
                  sensor_2 = True
                  if sensor_2_old != sensor_2 :
                        xmlcmd = '<fb id="' + sensor_2_rr_id + '" state="false"/>'
                        sendMsg(s,xmlcmd)
                        print" sensor_2 deactivated"
        sensor_2_old = sensor_2
        sensor2 = 0

        msensor3 = sensor3 / filter
        if msensor3 > limit :
                  sensor_3 = False
                  if sensor_3_old != sensor_3 :
                        xmlcmd = '<fb id="' + sensor_3_rr_id + '" state="true"/>'
                        sendMsg(s,xmlcmd)
                        print" sensor_3 activated"
        else :
                  sensor_3 = True
                  if sensor_3_old != sensor_3 :
                        xmlcmd = '<fb id="' + sensor_3_rr_id + '" state="false"/>'
                        sendMsg(s,xmlcmd)
                        print" sensor_3 deactivated"
        sensor_3_old = sensor_3
        sensor3 = 0

        msensor4 = sensor4 / filter
        if msensor4 > limit :
                  sensor_4 = False
                  if sensor_4_old != sensor_4 :
                        xmlcmd = '<fb id="' + sensor_4_rr_id + '" state="true"/>'
                        sendMsg(s,xmlcmd)
                        print" sensor_4 activated"
        else :
             	  sensor_4 = True
                  if sensor_4_old != sensor_4 :
                        xmlcmd = '<fb id="' + sensor_4_rr_id + '" state="false"/>'
                        sendMsg(s,xmlcmd)
                        print" sensor_4 deactivated"
	sensor_4_old = sensor_4
        sensor4 = 0

        msensor5 = sensor5 / filter
        if msensor5 > limit :
                  sensor_5 = False
                  if sensor_5_old != sensor_5 :
                        xmlcmd = '<fb id="' + sensor_5_rr_id + '" state="true"/>'
                        sendMsg(s,xmlcmd)
                        print" sensor_5 activated"
        else :
                  sensor_5 = True
                  if sensor_5_old != sensor_5 :
                        xmlcmd = '<fb id="' + sensor_5_rr_id + '" state="false"/>'
                        sendMsg(s,xmlcmd)
                        print" sensor_5 deactivated"
        sensor_5_old = sensor_5
        sensor5 = 0

        msensor6 = sensor6 / filter
        if msensor6 > limit :
                  sensor_6 = False
                  if sensor_6_old != sensor_6 :
                        xmlcmd = '<fb id="' + sensor_6_rr_id + '" state="true"/>'
                        sendMsg(s,xmlcmd)
                        print" sensor_6 activated"
        else :
                  sensor_6 = True
                  if sensor_6_old != sensor_6 :
                        xmlcmd = '<fb id="' + sensor_6_rr_id + '" state="false"/>'
                        sendMsg(s,xmlcmd)
                        print" sensor_6 deactivated"
        sensor_6_old = sensor_6
        sensor6 = 0

        msensor7 = sensor7 / filter
        if msensor7 > limit :
                  sensor_7 = False
                  if sensor_7_old != sensor_7 :
                        xmlcmd = '<fb id="' + sensor_7_rr_id + '" state="true"/>'
                        sendMsg(s,xmlcmd)
                        print" sensor_7 activated"
        else :
                  sensor_7 = True
                  if sensor_7_old != sensor_7 :
                        xmlcmd = '<fb id="' + sensor_7_rr_id + '" state="false"/>'
                        sendMsg(s,xmlcmd)
                        print" sensor_7 deactivated"
        sensor_7_old = sensor_7
        sensor7 = 0

        msensor8 = sensor8 / filter
        if msensor8 > limit :
                  sensor_8 = False
                  if sensor_8_old != sensor_8 :
                        xmlcmd = '<fb id="' + sensor_8_rr_id + '" state="true"/>'
                        sendMsg(s,xmlcmd)
                        print" sensor_8 activated"
        else :
                  sensor_8 = True
                  if sensor_8_old != sensor_8 :
                        xmlcmd = '<fb id="' + sensor_8_rr_id + '" state="false"/>'
                        sendMsg(s,xmlcmd)
                        print" sensor_8 deactivated"
        sensor_8_old = sensor_8
        sensor8 = 0
s.close                                                                                         #close server connection


