/* ROCO MULTIMAUSPRO Developed by haber & koenig electronics gmbh               */
/* Version: 1.00                                                                */
/* Letzte nderung: 05.10.2009                                                  */
/* Filename: COMMONCODE.H                                                       */
/* Verwendung: Wird nur in C verwendet, da direkt auf die HW zugegriffen wird   */
/* Dieses File wird von der MultiZentralePro, der MultiMausPro und dem          */
/* Funkmodul verwendet!!!                                                       */
/* nderungen:                                                                  */
/*                                                                              */
/*                                                                              */

#ifndef COMMONCODE_H
#define COMMONCODE_H

#ifdef __KEIL__
	#include "71x_lib.h"
	#define packed __packed
#else
	#define packed
#endif

// Maximalanzahl der anschliebaren FunkMausPro
#define	MAX_CHILDREN_COUNT								4

// Device-Typen des FunkModuls
#ifndef BITCLOUDMODULE
  #define DEVICE_TYPE_COORDINATOR					0x00
  #define DEVICE_TYPE_ROUTER							0x01
  #define DEVICE_TYPE_END_DEVICE					0x02
#endif

#ifdef MULTIMAUSPRO
	#ifndef BOOL
	#define BOOL boolean
	#endif
#endif


// PANID ist der Netzwerk-ID.
#define PANID_INVALID											0x0000	// Dieser PANID darf nicht verwendet werden
#define PANID_JOINEVERY										0xFFFF	// Joins every network (not used by application)
#define PANID_RESERVED_MAX								0xFFFE	// Invalid setting range max
#define PANID_RESERVED_MIN								0xFFF1	// Invalid setting range min
#define PANID_LOGIN_OFFLINE								0xFFF0	// Das Gert ist Offline (nicht angemeldet) Dieser PANID wird auch zum Login verwendet
// Die PANID's von 0x0001 - 0xFFEF sind frei verfgbar.

// ApplicationState ist der Status, in dem das Funkmodul sich befindet
#define	APL_STARTUP												0x00
#define	APL_INITIALIZED										0x01
#define APL_NETWORK_RESET									0x02
#define APL_NETWORK_RESETING							0x03
#define APL_NETWORK_START									0x04
#define APL_NETWORK_STARTING							0x05
#define	APL_NETWORK_READY									0x06

// ModuleMode ist der Modus, in dem das Funkmodul sich befindet
#define MM_UNKNOWN												0x00
#define MM_MULTIZENTRALEPRO								0x01	// Modul in der Zentrale
#define MM_MULTIMAUSPRO										0x02	// Modul im Handregler (Funkmaus)	

// USB-Kommunikations Header
// Header Konstanten fr die Kommunikation ber die USB-Schnittstelle
#define USB_NOSEND												0x00
#define USB_FIRMWARE_INFO									0x01
#define USB_RF_SENDDATA										0x03
#define USB_RF_SENDSTATE									0x04
#define USB_RF_RECEIVEDDATA								0x05
#define USB_RF_ACK												0x06
#define USB_GET_SERIALNUMBER							0x10
#define USB_GET_SETTINGS									0x12
#define USB_SET_SETTINGS									0x13
#define USB_GET_DCCSETTINGS								0x16
#define USB_SET_DCCSETTINGS								0x17
#define USB_GET_WIRELESSMODULEVERSION			0x20
#define USB_XPRESSNET											0x40
#define USB_SETAUTOINFORMFLAGS						0x50
#define USB_GETAUTOINFORMFLAGS						0x51
#define USB_RMBUS_DATACHANGED							0x80
#define USB_RMBUS_GETDATA									0x81
#define USB_RMBUS_PROGRAMMODULE						0x82
#define USB_SYSTEMSTATE_DATACHANGED				0x84
#define USB_SYSTEMSTATE_GETDATA						0x85
#define USB_NETWORKCHILDREN_DATACHANGED		0x86
#define	USB_NETWORKCHILDREN_GETDATA				0x87
#define USB_RAILCOM_DATACHANGED						0x88
#define USB_RAILCOM_GETDATA								0x89



// Die Zentrale hat immer die MAC-Addresse 0x0000
#define MZP_NETWORK_ADDRESS								0x0000

// Maximalanzahl der Strassen in der Bibliothek
#define STREETCOUNT        			64

// Maximalanzahl der Weichen in einer Fahrtrasse
#define TURNOUTCOUNTPERSTREET 	16

// Konstanten fr TCentralState
#define csEmergencyStop						0x01	// Der Nothalt ist eingeschaltet
#define csTrackVoltageOff					0x02	// Die Gleisspannung ist abgeschaltet
#define csShortCircuit						0x04	// Kurschluss am Gleisausgang
#define csNotDefined							0x08	// Nicht definiert bzw. unbekannt
#define csAutoMode								0x10	// Der Automatische Startmodus ist aktiv
#define csProgrammingModeActive		0x20	// Der Programmiermodus ist aktiv
#define csColdStart								0x40	// Kaltstart
#define csRamError								0x80	// RAM Fehler in der Zentrale
typedef unsigned char TCentralState;

// Konstanten fr XBusSubVersion
#define xsvLZ100										0x00              // XBus Sub Version for Lenz LZ100
#define xsvLH200										0x01              // XBus Sub Version fr Lenz LH200
#define xsvCompact									0x02              // XBUs Sub Version fr Lenz Compact
#define xsvLokMaus2									0x04              // XBus Sub Version fr Roco LokMaus 2
#define xsvLokMausR3								0x05              // XBus Sub Version fr Roco LokMaus R3
#define xsvLokStation								0x06              // XBus Sub Version for hke LokStation
#define xsvMultiMaus								0x10              // XBus Sub Version for Roco Multi Maus
#define xsvMultiZentralePro					0x11							// XBus Sub Version for Roco MultiZentralePro
#define xsvUnknown									0xFF              // XBus Sub Version fr Unbekannte Zentralen

// Konstanten fr TSpeedSteps
#define ss14												0x00
#define ss28												0x01
#define ss128												0x02
typedef unsigned char TSpeedSteps;

// Konstaten fr TStreetCommand
#define scGet                     	0x10
#define scGetNext                 	0x11
#define scGetNextEmpty            	0x12
#define scGetPrev                 	0x13
#define scGetPrevEmpty            	0x14
#define scDelete                  	0x20
#define scDeleteAll									0x21
#define scSwitch                  	0x30

// Konstanten fr TStreetState
#define ssUnknown										0x00
#define ssValid											0x01
#define ssInValid										0x02
#define ssSwitching									0x03
#define ssChanged										0x80

// Konstaten fr TDTRState
#define dsErrorSameAddresses				0x00
#define dsErrorDifferentSpeedSteps	0x01
#define dsErrorSpeedNotZero					0x02
#define dsErrorAlreadyInDTR					0x03
#define dsErrorNotInDTR							0x04
#define dsErrorMemoryFull						0x05
#define dsErrorUnknown							0x10
#define dsOk												0x20

// Konstanten fr TDTRCommand
#define dcBuildDTR									0x10
#define dcReleaseDTR								0x11
#define dcGetDTRInfos								0x12
#define dcSetDTRDirection						0x13
#define dcReleaseAllDTR							0x14

// Konstanten fr TProgrammingResult
#define prUnknown										0x00
#define prUserAbort									0x01
#define prOk												0x02
#define prShortCircuit							0x03
#define prNothingFound							0x04
#define prNotSupported							0x05
typedef unsigned char TProgrammingResult;

// Konstanten fr TProgrammingType
#define ptNothing										0x00
#define ptBitOnly										0x01
#define ptByteOnly									0x02
#define ptBoth											0x03
typedef unsigned char TProgrammingType;

// Konstanten fr TWirelessLostMode
#define wlmTrackPowerOff						0x00
#define wlmEmergencyStop						0x01
#define wlmNothing									0x02
typedef unsigned char TWirelessLostMode;

// Konstanten fr TTurnoutState
#define tsNone											0x00
#define tsStraight									0x01
#define tsBranch										0x02
#define tsBoth											0x03
typedef unsigned char TTurnoutState;

// Konstanten fr TLedOptions
#define loNone											0x00
#define loSinglePulse								0x01
#define loSynchronize								0x02

typedef unsigned short TNetworkAddress;

// Konstanten fr TAutoInformFlags
#define aiXPressNet						0x00000001
#define aiRMFeedBack					0x00000002
#define aiRailCom							0x00000004
#define aiMMUpdate						0x00000008
#define aiSystemState					0x00000100
#define aiWireless						0x00000200
#define aiWirelessConnect			0x00000400
typedef unsigned long TAutoInformFlags;

packed typedef struct
{
	unsigned char Header;
	unsigned char Data[WL_MAX_DATA_LENGTH-1];
} TAirData;

packed typedef struct
{
	TNetworkAddress NetworkAddress;
	unsigned char LQI;
	unsigned char RSSI;
	TAirData AirData;
} TRadioReceivedData;

#define RADIORECEIVEDDATA_AIRDATA_OFFSET	(sizeof(TNetworkAddress)+sizeof(unsigned char)+sizeof(unsigned char))

packed typedef struct
{
	TNetworkAddress NetworkAddress;
	TAirData AirData;
} TRadioData;

#define RADIODATA_AIRDATA_OFFSET	(sizeof(TNetworkAddress))

packed typedef struct
{
	unsigned short UniqueIndex;
	char Name[0x06];
} TStreetInfo;

packed typedef struct
{
	TStreetInfo Info;
	unsigned char State;
} TStreetWork;

packed typedef struct
{
	TStreetInfo Info;
	unsigned short Adresses[TURNOUTCOUNTPERSTREET];
} TStreetEdit;

typedef TStreetEdit *PStreetEdit;

packed typedef struct
{
	unsigned char Index;
	unsigned char PWMMax;
	unsigned char PWM;
	unsigned char Options;	// 0x01: Single Pulse, 0x02: Sync LEDs
} TLEDControl;

packed typedef struct
{
	unsigned long SleepPeriod;
	unsigned short StayActiveAfterWakeup;
	unsigned short StayActiveAfterAction;
	unsigned char CanSleep;
} TSleepControl;

packed typedef struct
{
	unsigned char Count;
	TNetworkAddress NetworkAddress[MAX_CHILDREN_COUNT];
} TNetworkChildren;

packed typedef struct
{
	unsigned short Version;
	unsigned char Name[32];
} TWirelessModuleVersion;

packed typedef struct
{
	TNetworkAddress NetworkAddress;
	unsigned char Added;
} TNetworkChildChange;

packed typedef struct TStackData
{
	unsigned char Data[16];
} TStackData;

packed typedef struct
{
	TNetworkAddress NetworkAddress;	// ist zugleich Die Seriennummer der Funkmaus
} TLogin;

packed typedef struct
{
	unsigned long PANID;		// PANID (Ist zugleich die Seriennummer der Zentrale)
	unsigned long ChannelMask;
} TLoginInfo;

//

packed typedef struct
{
	unsigned char LockTime;
} TUserInterfaceLock;

packed typedef struct
{
	unsigned char LockTime;
} TUserInterfaceLockInfo;

#endif
