;  This file is part of the piclight
;  Copyright (C)  2013 Kurt Zerzawy www.zerzawy.ch
;  uPStellwerk is free software: you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation, either version 3 of the License, or
;  (at your option) any later version.
; 
;  uPStellwerk is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
; 
;  You should have received a copy of the GNU General Public License
;  along with uPStellwerk. If not, see <http://www.gnu.org/licenses/>.
; 

;                                                                              *
;   Filename:       eeprom.asm                                                 *
;                                                                              *
;*******************************************************************************
;                                                                              *
;   $Author:$ 
;   $Date$
;                                                                              *
;*******************************************************************************


;*******************************************************************************
;  Function to write to EEPROM                                                 *
;  expects data to write in eepromdata                                         *
;  expects address to write into in eepromaddr                                 *
;******************************************************************************/
; 
; Kurt Zerzawy 19.02.2013
;
eewrite			
				banksel 	EECON1			; Bank 1
				btfsc		EECON1,WR		; check if last write pending
				goto		eewrite			; wait if so
				movf		eepromaddr,0
				movwf		EEADR
				movf		eepromdata,0
				movwf		EEDATA
				bsf			EECON1,WREN		; enable write
				bcf			INTCON,GIE		; disable all interrupts
				movlw		0x55			; write magic unlock sequence
				movwf		EECON2
				movlw		0xAA
				movwf		EECON2
				bsf			EECON1,WR		; start writing
				bsf			INTCON,GIE		; reenable interrupts
				bcf			EECON1,WREN		; disable further accidental writes
				return

;*******************************************************************************
;  Function to read from EEPROM                                                *
;  expects address to write into in eepromaddr                                 *
;  returns value in W                                                          *
;******************************************************************************/
; 
; Kurt Zerzawy 19.02.2013
;

eeread			
				banksel		EEADR
				movf		eepromaddr,0
				movwf		EEADR

				bsf			EECON1,RD		; read value
				movf		EEDATA,0		; move to W
				return
