;  This file is part of the piclight
;  Copyright (C)  2012 - 2013 Kurt Zerzawy www.zerzawy.ch
;  uPStellwerk is free software: you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation, either version 3 of the License, or
;  (at your option) any later version.
; 
;  uPStellwerk is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
; 
;  You should have received a copy of the GNU General Public License
;  along with uPStellwerk. If not, see <http://www.gnu.org/licenses/>.
; 

;                                                                              *
;   Filename:       piclight.asm                                               *
;                                                                              *
;*******************************************************************************
;                                                                              *
;   $Author:$ 
;   $Date$
;                                                                              *
;*******************************************************************************
;                                                                              *
;   rs232 input on GP3 to GND                                                  *
;                                                                              *
;   LEDs on GP0..GP2 and GP4,GP5ive)                                           *
;                                                                              *
;******************************************************************************/

        list    p=12F675
        #include <p12f675.inc>

        __CONFIG   _CP_OFF & _CPD_OFF & _BODEN_OFF & _MCLRE_OFF & _WDT_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT  

;******************************************************************************
; Constants                                                                   *
;*****************************************************************************/

#define TRISIO_INIT     b'11001000'
;                         ||||||||      
;                         ||||||||
;                         |||||||+--- GP0 - Output
;                         ||||||+---- GP1 - Output
;                         |||||+----- GP2 - Output
;                         ||||+------ GP3 - Input
;                         |||+------- GP4 - Output
;                         ||+-------- GP5 - Output
;                         |+--------- Input
;                         +---------- Input

#define	ADDRESS		05				; address of the house

#define RS232		GPIO, 3
#define ERROR		0xff

#define LOWADDR		0
#define HIGHADDR	1


waitLongTime	equ			0x26
hex1			equ			0x27
hex2			equ			0x28
temp			equ			0x29
temp2			equ			0x30
temp3			equ			0x31
temp4			equ			0x38
char			equ			0x32
value			equ			0x33
addrhigh		equ			0x34
addrlow			equ			0x35
eepromdata		equ			0x36
eepromaddr		equ			0x37

;******************************************************************************
; Main Program                                                                *
;*****************************************************************************/

				ORG			0x00            ;Start on Reset Vector


				banksel		OSCCAL          ;Bank 1
				bsf			STATUS, RP0
				call 		0x3FF           ;Get the Calibration Value
                movwf   	OSCCAL          ;Calibrate
                bcf     	STATUS, RP0

				goto		Initialize

#include 			"eeprom.asm"
#include 			"rs232.asm"	
#include 			"timer.asm"

Initialize
                banksel 	CMCON           ;Bank 0
                movlw   	B'00000111'     ;Binary Version
;                             ||||||||      
;                             ||||||||
;                             |||||+++--- Comparator OFF
;                             ||||+------ not used
;                             |||+------- Output not inverted
;                             ||+-------- unimplemented
;                             |+--------- not used
;                             +---------- unimplemented
                movwf   	CMCON           ;Comparator Off, Pins Set for Digital

                banksel 	OPTION_REG      ;Bank 1
                movlw   	B'11000000'     ;mask out uninteresting Bits
                andwf   	OPTION_REG, 1

                movlw   	B'00000111'
;                             ||||||||      
;                             ||||||||
;                             |||||+++--- Prescaler 1:256
;                             ||||+------ Prescaler Assignement Timer0
;                             |||+------- Source Edge select
;                             ||+-------- TMR0 Internal
;                             |+--------- Interrupt Edge Bit
;                             +---------- GPIO Pull-Up
                
                iorwf  		OPTION_REG, 1   

                banksel 	T1CON           ;Bank 0
                movlw   	B'00110001'
;                             ||||||||      
;                             ||||||||
;                             |||||||+--- Timer ON
;                             ||||||+---- internal Clock
;                             |||||+----- ignored
;                             ||||+------ ignored
;                             ||++------- Prescaler 1:8
;                             |+--------- Timer 1 ON
;                             +---------- unimplemented
                movwf   	T1CON;   

                clrf    	GPIO

                banksel 	TRISIO          ;Bank 1
                movlw   	TRISIO_INIT
                movwf   	TRISIO
                clrf    	ANSEL           ;Pins Set For Digital

                banksel 	GPIO            ;Bank 0

Main			

; now find out your own address. if this goes wrong, use default address
				movlw		LOWADDR
				movwf		eepromaddr
				call		eeread
				movwf		addrlow
				call		ASCII2Hex
				sublw		ERROR			; check for hex number
				btfsc		STATUS,2
				goto		UseDefault

				movlw		HIGHADDR
				movwf		eepromaddr
				call		eeread
				movwf		addrhigh
				call		ASCII2Hex
				sublw		ERROR			; check for hex number
				btfsc		STATUS,2
				goto		UseDefault

; on this point, all is fine with my own address, show it by light show
				call		WalkLight
				goto		FrameError		; now wait for sync

; useDefault is the address to be jumped to when the own address is not valid
; show it by blinking once with all lamps
UseDefault		movlw		'F'
				movwf		addrhigh
				movwf		addrlow
				banksel		GPIO
				movlw		0x37
				movwf		GPIO
				movlw		.100
				call		WaitLong
				movlw		0
				movwf		GPIO

; a frame error is jumped to if the rs232 signal was not logical
FrameError		call		WaitSync

				
; now check if the first char is a 'H'. 
Decode			ExpChar		'H',Decode

; now decode the address which is hex
				ExpCharReg	addrhigh,Decode
				ExpCharReg	addrlow,Decode

; now check for the command
				GetChar		char
				movf		char,0
				sublw		'S'				; was it for setting lamps?
				btfsc		STATUS,2
				goto		SetLamps		; so go there
				movf		char,0
				sublw		'P'				; is the char an P as programming?
				btfss		STATUS,2
				goto		Decode			; if NOT, goto beginning

; programming address section

; check if next string is aa55
				ExpChar 	'a',Decode
				ExpChar 	'a',Decode
				ExpChar 	'5',Decode
				ExpChar 	'5',Decode

; as a sign that programming starts, all lamps go on
				banksel		GPIO
				movlw		0x37
				movwf		GPIO

; now fetch the address to be programmed. 

; first nibble is stored in hex1 as ASCII
				GetChar		hex1
				movf		hex1,0
				call		ASCII2Hex
				sublw		ERROR			; check for hex number
				btfsc		STATUS,2
				goto		Decode

; second nibble is stored in hex2
				GetChar		hex2
				movf		hex2,0
				call		ASCII2Hex
				sublw		ERROR
				btfsc		STATUS,2
				goto		Decode

; expect Carriage Return
				ExpChar 	0x0d,Decode

; write into EEPROM
				movlw		LOWADDR
				movwf		eepromaddr
				movf		hex2,0
				movwf		eepromdata
				call		eewrite			; write low nibble

				movlw		HIGHADDR
				movwf		eepromaddr
				movf		hex1,0
				movwf		eepromdata
				call		eewrite			; write high nibble

; as a sign that programming finished, all lamps go off
				banksel		GPIO			; io bank
				movlw		0
				movwf		GPIO

; time to restart
				goto		Main

; now decode the value to be set
; first nibble
SetLamps		ExpHex		Decode,hex1
				ExpHex		Decode,hex2

				bcf			STATUS,0		; clear C
				rlf			hex1,1
				rlf			hex1,1
				rlf			hex1,1
				rlf			hex1,0			; multiply hex1 with 16 and put it to W
				iorwf		hex2,0			; add hex2
				movwf		value

; before writing out, expect Carriage Return
				ExpChar 	0x0d,Decode

; now move the bits that the user does not see that Bit 3 isnt used
				rlf			value,0
				andlw		0x30			; upper 2 bits one shifted to left 
				movwf		temp
				
				movfw		value
				andlw		0x07			; keep the lower bytes unchanged
					
				iorwf		temp,0
				banksel		GPIO
				movwf		GPIO
				
				goto		Decode				



;*******************************************************************************
;  Function to make walking light in the beginning                             *
;  uses register Temp                                                          *
;******************************************************************************/
; 
; Kurt Zerzawy 18.12.2012
;
WalkLight		
				banksel		GPIO
				movlw		.100
				call		WaitLong
				movlw		1
				movwf		GPIO
				movlw		.100
				call		WaitLong
				movlw		3
				movwf		GPIO
				movlw		.100
				call		WaitLong
				movlw		7
				movwf		GPIO
				movlw		.100
				call		WaitLong
				movlw		17
				movwf		GPIO
				movlw		.100
				call		WaitLong
				movlw		37
				movwf		GPIO
				movlw		.100
				call		WaitLong
				movlw		0
				movwf		GPIO
				movlw		.100
				call 		WaitLong
				return



;*******************************************************************************
;  Calibration Value for Simulation                                            *
;******************************************************************************/

                ORG     	0x3FF             ;Oscillator Calibration Value for Simulation
                messg   	"Dummy Oscillator Calibration value for simulation."
                messg   	"Please remove the following source code line when programming a device."


;*******************************************************************************
                END                     ;directive 'end of program'
