;  This file is part of the piclight
;  Copyright (C)  2012 - 2013 Kurt Zerzawy www.zerzawy.ch
;  uPStellwerk is free software: you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation, either version 3 of the License, or
;  (at your option) any later version.
; 
;  uPStellwerk is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
; 
;  You should have received a copy of the GNU General Public License
;  along with uPStellwerk. If not, see <http://www.gnu.org/licenses/>.
; 

;                                                                              *
;   Filename:       rs232.asm                                                  *
;                                                                              *
;*******************************************************************************
;                                                                              *
;   $Author:$ 
;   $Date$
;                                                                              *
;*******************************************************************************


;*******************************************************************************
;  Function to wait for synchronisation of RS232                               *
;  register used: temp                                                         *
;******************************************************************************/
; 
; Kurt Zerzawy 18.12.2012
;
WaitSync	
				banksel		GPIO
				movlw		.167
				movwf		temp
WaitSync1		btfsc		GPIO,3
				goto		WaitSync2
				movlw		.167
				movwf		temp
WaitSync2		decfsz		temp,1
				goto		WaitSync1
				return

;*******************************************************************************
;  Function to read serial data with 9600Baud.                                 *
;  returns char in W, ERROR in case of error.                                  *
;  uses register temp, temp2, temp3                                            *
;******************************************************************************/
; 
; Kurt Zerzawy 18.12.2012
;

ReadChar		movlw		.52
				movwf		temp2			; waiting time
				movlw		8
				movwf		temp3			; is bit counter
WaitSpace		btfsc		GPIO,3
				goto		WaitSpace
WaitBit			decfsz		temp2,1
				goto		WaitBit
				bcf			STATUS,0
				btfsc		GPIO,3
				bsf			STATUS,0
				rrf			temp,1			; storage for result
				movlw		.32
				movwf		temp2
				decfsz		temp3,1
				goto		WaitBit
				movlw		.33
				movwf		temp2
WaitMark		decfsz		temp2,1
				goto		WaitMark
				movf		temp,0
				btfss		GPIO,3
				retlw		ERROR
				return

;*******************************************************************************
;  Function to change ASCII to Hex number.                                     *
;  expects ASCII in W                                                          *
;  returns Hex in W, ERROR in case of error..                                  *
;  register used: temp                                                         *
;******************************************************************************/
; 
; Kurt Zerzawy 18.12.2012
;
ASCII2Hex		movwf		temp
				addlw		0xff-'9'
				btfsc		STATUS,0		; Carry
				goto		AtoF
				movf		temp,0
				addlw		0xff-'0'+1
				btfss		STATUS,0
				retlw		ERROR
				return					; '0' already subtracted:
AtoF			movf		temp,0
				addlw		0xff-'F'
				btfsc		STATUS,0
				retlw		ERROR
				movf		temp,0
				addlw		0xff-'A'+1
				btfss		STATUS,0
				retlw		ERROR
				addlw		.10
				return	

;*******************************************************************************
;  Macro to get a char from RS232                                              *
;  returns value read in register char                                         *
;  in case of framing error, it jumps to FrameError                            *
;  uses register temp, temp2, temp3 in function ReadChar                       *
;******************************************************************************/
; 
; Kurt Zerzawy 
GetChar			MACRO		char
				call		ReadChar
				movwf		char
				sublw		ERROR			; is there a frame error
				btfsc		STATUS,2
				goto		FrameError		; if so, go to sync
				ENDM	

;*******************************************************************************
;  Macro to get a char from RS232                                              *
;  expects literal value from rs232 as given in char. If another character is  *
;   received, it jumps to dest                                                 *
;  in case of framing error, it jumps to FrameError                            *
;  uses register temp, temp2, temp3, temp4                                     *
;******************************************************************************/
; 
; Kurt Zerzawy 
ExpChar			MACRO		char,dest
				GetChar		temp4
				movf		temp4,0
				sublw		char			; is the char the expected one?
				btfss		STATUS,2
				goto		dest			; if NOT, goto the destination
				ENDM	

;*******************************************************************************
;  Macro to get a char from RS232                                              *
;  expects value from rs232 as given in register reg. If another character is  *
;   received, it jumps to dest                                                 *
;  in case of framing error, it jumps to FrameError                            *
;  uses register temp, temp2, temp3, temp4                                     *
;******************************************************************************/
; 
; Kurt Zerzawy 
ExpCharReg		MACRO		reg,dest
				GetChar		temp4
				movf		temp4,0
				subwf		reg,0			; is the char the expected one?
				btfss		STATUS,2
				goto		dest			; if NOT, goto the destination
				ENDM	

;*******************************************************************************
;  Macro to expect a hex value from RS232                                      *
;  expects a valid hex ASCII from rs232. If this is not received, it jumps     *
;   to dest                                                                    *
;  the value is stored in reg as the result of the ASCII-to hex calculation    *
;  in case of framing error, it jumps to FrameError                            *
;  uses register temp, temp2, temp3, temp4                                     *
;******************************************************************************/
; 
; Kurt Zerzawy 
ExpHex			MACRO		dest,reg
				GetChar		temp4			; contains character received
				movf		temp4,0
				call		ASCII2Hex
				movwf		reg
				sublw		ERROR			; was it a hex number?
				btfsc		STATUS,2
				goto		dest			; no, so start new try
				ENDM

