;  This file is part of the piclight
;  Copyright (C)  2013 Kurt Zerzawy www.zerzawy.ch
;  uPStellwerk is free software: you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation, either version 3 of the License, or
;  (at your option) any later version.
; 
;  uPStellwerk is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
; 
;  You should have received a copy of the GNU General Public License
;  along with uPStellwerk. If not, see <http://www.gnu.org/licenses/>.
; 

;                                                                              *
;   Filename:       timer.asm                                                  *
;                                                                              *
;*******************************************************************************
;                                                                              *
;   $Author:$ 
;   $Date$
;                                                                              *
;*******************************************************************************

TIMEOUT			equ			.216			; Timeout for Timer 0


;*******************************************************************************
;  Function waiting for the Time given in 256-Timeout                          *
;  expects time in 10 ms in W                                                  *
;  registers used: waitLongTime                                                *
;  functions used: Wait10ms                                                    *
;*******************************************************************************
WaitLong		movwf		waitLongTime
WaitLong1		call		Wait10ms
				decfsz		waitLongTime,1
				goto		WaitLong1
				return
				
;*******************************************************************************
;  Function waiting for the Time given in 256-Timeout                          *
;******************************************************************************/
; 
; Kurt Zerzawy 14.01.2006
;
Wait10ms		btfss   	INTCON, 2       ;Wait for Timeout
                goto    	Wait10ms

                bcf     	INTCON, 2       ;clear overflow
                movlw   	TIMEOUT         ;reload timer
                movwf   	TMR0
                return
                
